%%% Example in 
%%% Eisele and Dorre, Unification of Disjunctive Feature Structure,
%%%   26th ACL, 1988.
%%% 	
%%%  Disjunctive feature unification between
%%%  [a:{[b:+,c:-],[b:-,c+]}] and [a:[b:<d>],d:_].
%%% --> [a:[b:+,c:-],d:+] or [a:[b:-,c:+],d:-] 
%%%
f({a/X}):-cc1(X).
cc1({b/plus,c/minus}).
cc1({b/minus,c/plus}).

@ f(U),U={a/{b/X},d/X}.

%% --> c0(U,....)
%% then, solve :-c0(U,_,_).  This goal has two solutions.
%%   ------------------------------
%% solution = c0(U_0, X_1, {a/{b/X_1}, d/X_1})
%% c1(plus, {b/plus, c/minus}).
%% c1(minus, {b/minus, c/plus}).
%% c0(_p1, V0_0, _p1) :- c1(V0_0, {b/V0_0});_p1={a/{b/V0_0}, d/V0_0}.
%% CPU time = 0.017 sec (Constraints Handling = 0.000 sec)
%% 
%% _:-c0(U,_,_).
%%   U = {a/{b/plus, c/minus}, d/plus};
%%   U = {a/{b/minus, c/plus}, d/minus};
%% 
%% CPU time = 0.000 sec (Constraints Handling = 0.000 sec)

