/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrepReader
extends FilterReader {
    String curLine;
    int curLineIx;
    boolean emitNewline;
    Matcher matcher;

    public GrepReader(String filename, String patternStr) throws IOException {
        super(filename.endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream((InputStream)new FileInputStream(filename)))) : new BufferedReader(new FileReader(filename)));
        Pattern pattern = Pattern.compile(patternStr);
        this.matcher = pattern.matcher("");
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.curLine == null && !this.emitNewline) {
            this.getNextLine();
        }
        if (this.curLine != null) {
            int num = Math.min(len, Math.min(cbuf.length - off, this.curLine.length() - this.curLineIx));
            for (int i = 0; i < num; ++i) {
                cbuf[off++] = this.curLine.charAt(this.curLineIx++);
            }
            if (this.curLineIx == this.curLine.length()) {
                this.curLine = null;
                if (num < len && off < cbuf.length) {
                    cbuf[off++] = 10;
                    this.emitNewline = false;
                    ++num;
                }
            }
            return num;
        }
        if (this.emitNewline && len > 0) {
            cbuf[off] = 10;
            this.emitNewline = false;
            return 1;
        }
        if (len > 0) {
            return -1;
        }
        return 0;
    }

    private void getNextLine() throws IOException {
        this.curLine = ((BufferedReader)this.in).readLine();
        while (this.curLine != null) {
            this.matcher.reset(this.curLine);
            if (!this.matcher.find()) {
                this.emitNewline = true;
                this.curLineIx = 0;
                return;
            }
            this.curLine = ((BufferedReader)this.in).readLine();
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.curLine != null || this.emitNewline || this.in.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

