/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.chess.BoardPainter;
import free.chess.ColoredBoardPainter;
import free.chess.ColoredPiecePainter;
import free.chess.PiecePainter;
import free.chess.Player;
import free.chess.Position;
import free.jin.Connection;
import free.jin.Game;
import free.jin.I18n;
import free.jin.Preferences;
import free.jin.board.BoardPanel;
import free.jin.board.BoardPattern;
import free.jin.board.BoardPreferencesPanel;
import free.jin.board.PieceSet;
import free.jin.board.event.UserMoveEvent;
import free.jin.board.event.UserMoveListener;
import free.jin.event.BoardFlipEvent;
import free.jin.event.ClockAdjustmentEvent;
import free.jin.event.ConnectionListener;
import free.jin.event.GameEndEvent;
import free.jin.event.GameListener;
import free.jin.event.GameStartEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.ListenerManager;
import free.jin.event.MoveMadeEvent;
import free.jin.event.OfferEvent;
import free.jin.event.PositionChangedEvent;
import free.jin.event.TakebackEvent;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginStartException;
import free.jin.plugin.PluginUIContainer;
import free.jin.plugin.PluginUIEvent;
import free.jin.plugin.PluginUIListener;
import free.jin.ui.OptionPanel;
import free.jin.ui.PreferencesPanel;
import free.util.BeanProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BoardManager
extends Plugin
implements GameListener,
UserMoveListener,
PluginUIListener,
ConnectionListener {
    public static final int LEGAL_CHESS_MOVE_SENDING_MODE = 1;
    public static final int PREDRAG_MOVE_SENDING_MODE = 2;
    public static final int PREMOVE_MOVE_SENDING_MODE = 3;
    private Plugin soundManager = null;
    protected final Hashtable gamesToBoardPanels = new Hashtable();
    protected final Hashtable containersToBoardPanels = new Hashtable();
    protected final Hashtable boardPanelsToContainers = new Hashtable();
    protected final Vector containers = new Vector();
    private final BeanProperties props = new BeanProperties((Object)this);
    private PiecePainter piecePainter;
    private BoardPainter boardPainter;

    public void start() throws PluginStartException {
        this.obtainSoundManager();
        this.initPreferences();
        this.registerConnListeners();
        this.preload();
    }

    public void stop() {
        this.unregisterConnListeners();
    }

    private void obtainSoundManager() {
        this.soundManager = this.getPlugin("sound");
    }

    public void playSound(String string) {
        if (this.soundManager != null) {
            this.playSoundImpl(string);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void playSoundImpl(String string) {
        try {
            Class<?> clazz = Class.forName("free.jin.sound.SoundManager");
            Method method = clazz.getMethod("playEventSound", String.class);
            method.invoke((Object)this.soundManager, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    protected void initPreferences() {
        String string;
        Preferences preferences = this.getPrefs();
        this.setAutoPromote(preferences.getBool("auto-promote", false));
        this.setMoveInputStyle("click'n'click".equals(preferences.getString("move-input-style", "drag'n'drop")) ? 2 : 1);
        this.setPieceFollowsCursor(preferences.getBool("piece-follows-cursor", true));
        this.setHighlightMadeMoveSquares(preferences.getBool("highlight-made-move-squares", false));
        this.setMadeMoveSquaresHighlightColor(preferences.getColor("highlight-made-move-squares.color", new Color(255)));
        String string2 = preferences.getString("move-highlight.style", "square");
        if ("target-square".equals(string2)) {
            this.setMoveHighlightingStyle(1);
        } else if ("square".equals(string2)) {
            this.setMoveHighlightingStyle(2);
        } else if ("arrow".equals(string2)) {
            this.setMoveHighlightingStyle(3);
        } else {
            this.setMoveHighlightingStyle(0);
        }
        this.setHighlightingOwnMoves(preferences.getBool("move-highlight.highlight-own", false));
        this.setMoveHighlightingColor(preferences.getColor("move-highlight.color", new Color(45746)));
        String string3 = preferences.getString("move-sending-mode", "predrag");
        if ("legal-chess".equals(string3)) {
            this.setMoveSendingMode(1);
        } else if ("premove".equals(string3)) {
            this.setMoveSendingMode(3);
        } else {
            this.setMoveSendingMode(2);
        }
        String string4 = preferences.getString("coords-display.style", "none");
        if ("rim".equals(string4)) {
            this.setCoordsDisplayStyle(1);
        } else if ("outside".equals(string4)) {
            this.setCoordsDisplayStyle(2);
        } else if ("every-square".equals(string4)) {
            this.setCoordsDisplayStyle(3);
        } else {
            this.setCoordsDisplayStyle(0);
        }
        this.setCoordsDisplayColor(preferences.getColor("coords-display.color", Color.blue.darker()));
        String string5 = preferences.getString("piece-set-id", null);
        if (string5 != null) {
            this.setPieceSet((PieceSet)this.getResource("pieces", string5));
        }
        if ((string = preferences.getString("board-pattern-id", null)) != null) {
            this.setBoardPattern((BoardPattern)this.getResource("boards", string));
        }
        this.setWhitePieceColor(preferences.getColor("white-piece-color", Color.white));
        this.setBlackPieceColor(preferences.getColor("black-piece-color", Color.black));
        this.setWhiteOutlineColor(preferences.getColor("white-outline-color", Color.black));
        this.setBlackOutlineColor(preferences.getColor("black-outline-color", Color.white));
        this.setLightSquareColor(preferences.getColor("light-square-color", new Color(16764816)));
        this.setDarkSquareColor(preferences.getColor("dark-square-color", new Color(9396303)));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.removePropertyChangeListener(propertyChangeListener);
    }

    protected void configurePiecePainter() {
        if (this.piecePainter instanceof ColoredPiecePainter) {
            ColoredPiecePainter coloredPiecePainter = (ColoredPiecePainter)this.piecePainter;
            Color color = this.getWhitePieceColor();
            Color color2 = this.getBlackPieceColor();
            Color color3 = this.getWhiteOutlineColor();
            Color color4 = this.getBlackOutlineColor();
            if (color != null) {
                coloredPiecePainter.setWhiteColor(color);
            }
            if (color2 != null) {
                coloredPiecePainter.setBlackColor(color2);
            }
            if (color3 != null) {
                coloredPiecePainter.setWhiteOutline(color3);
            }
            if (color4 != null) {
                coloredPiecePainter.setBlackOutline(color4);
            }
        }
    }

    protected void configureBoardPainter() {
        if (this.boardPainter instanceof ColoredBoardPainter) {
            ColoredBoardPainter coloredBoardPainter = (ColoredBoardPainter)this.boardPainter;
            Color color = this.getLightSquareColor();
            Color color2 = this.getDarkSquareColor();
            if (color != null) {
                coloredBoardPainter.setLightColor(color);
            }
            if (color2 != null) {
                coloredBoardPainter.setDarkColor(color2);
            }
        }
    }

    public Color getWhitePieceColor() {
        return (Color)this.props.getProperty("whitePieceColor", null);
    }

    public void setWhitePieceColor(Color color) {
        this.props.setProperty("whitePieceColor", (Object)color);
        this.configurePiecePainter();
    }

    public Color getBlackPieceColor() {
        return (Color)this.props.getProperty("blackPieceColor", null);
    }

    public void setBlackPieceColor(Color color) {
        this.props.setProperty("blackPieceColor", (Object)color);
        this.configurePiecePainter();
    }

    public Color getWhiteOutlineColor() {
        return (Color)this.props.getProperty("whiteOutlineColor", null);
    }

    public void setWhiteOutlineColor(Color color) {
        this.props.setProperty("whiteOutlineColor", (Object)color);
        this.configurePiecePainter();
    }

    public Color getBlackOutlineColor() {
        return (Color)this.props.getProperty("blackOutlineColor", null);
    }

    public void setBlackOutlineColor(Color color) {
        this.props.setProperty("blackOutlineColor", (Object)color);
        this.configurePiecePainter();
    }

    public Color getLightSquareColor() {
        return (Color)this.props.getProperty("lightSquareColor", null);
    }

    public void setLightSquareColor(Color color) {
        this.props.setProperty("lightSquareColor", (Object)color);
        this.configureBoardPainter();
    }

    public Color getDarkSquareColor() {
        return (Color)this.props.getProperty("darkSquareColor", null);
    }

    public void setDarkSquareColor(Color color) {
        this.props.setProperty("darkSquareColor", (Object)color);
        this.configureBoardPainter();
    }

    public int getMoveInputStyle() {
        return this.props.getIntegerProperty("moveInputStyle");
    }

    public void setMoveInputStyle(int n) {
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown move input style: " + n);
            }
        }
        this.props.setIntegerProperty("moveInputStyle", n);
    }

    public boolean isPieceFollowsCursor() {
        return this.props.getBooleanProperty("pieceFollowsCursor");
    }

    public void setPieceFollowsCursor(boolean bl) {
        this.props.setBooleanProperty("pieceFollowsCursor", bl);
    }

    public boolean isHighlightMadeMoveSquares() {
        return this.props.getBooleanProperty("highlightMadeMoveSquares");
    }

    public void setHighlightMadeMoveSquares(boolean bl) {
        this.props.setBooleanProperty("highlightMadeMoveSquares", bl);
    }

    public Color getMadeMoveSquaresHighlightColor() {
        return (Color)this.props.getProperty("madeMoveSquaresHighlightColor");
    }

    public void setMadeMoveSquaresHighlightColor(Color color) {
        this.props.setProperty("madeMoveSquaresHighlightColor", (Object)color);
    }

    public boolean isAutoPromote() {
        return this.props.getBooleanProperty("autoPromote");
    }

    public void setAutoPromote(boolean bl) {
        this.props.setBooleanProperty("autoPromote", bl);
    }

    public int getMoveHighlightingStyle() {
        return this.props.getIntegerProperty("moveHighlightingStyle");
    }

    public void setMoveHighlightingStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown move higlighting style: " + n);
            }
        }
        this.props.setIntegerProperty("moveHighlightingStyle", n);
    }

    public boolean isHighlightingOwnMoves() {
        return this.props.getBooleanProperty("highlightingOwnMoves");
    }

    public void setHighlightingOwnMoves(boolean bl) {
        this.props.setBooleanProperty("highlightingOwnMoves", bl);
    }

    public Color getMoveHighlightingColor() {
        return (Color)this.props.getProperty("moveHighlightingColor");
    }

    public void setMoveHighlightingColor(Color color) {
        this.props.setProperty("moveHighlightingColor", (Object)color);
    }

    public int getMoveSendingMode() {
        return this.props.getIntegerProperty("moveSendingMode");
    }

    public void setMoveSendingMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized value for move sending mode: " + n);
            }
        }
        this.props.setIntegerProperty("moveSendingMode", n);
    }

    public int getCoordsDisplayStyle() {
        return this.props.getIntegerProperty("coordsDisplayStyle");
    }

    public void setCoordsDisplayStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized coordinates display style value: " + n);
            }
        }
        this.props.setIntegerProperty("coordsDisplayStyle", n);
    }

    public Color getCoordsDisplayColor() {
        return (Color)this.props.getProperty("coordsDisplayColor");
    }

    public void setCoordsDisplayColor(Color color) {
        this.props.setProperty("coordsDisplayColor", (Object)color);
    }

    public PieceSet getPieceSet() {
        return (PieceSet)this.props.getProperty("pieceSet", null);
    }

    public PiecePainter getPiecePainter() {
        return this.piecePainter;
    }

    public BoardPattern getBoardPattern() {
        return (BoardPattern)this.props.getProperty("boardPattern", null);
    }

    public BoardPainter getBoardPainter() {
        return this.boardPainter;
    }

    public void setPieceSet(PieceSet pieceSet) {
        PieceSet pieceSet2 = pieceSet == null ? PieceSet.DEFAULT_PIECE_SET : pieceSet;
        this.piecePainter = pieceSet2.getPiecePainter();
        this.configurePiecePainter();
        this.props.setProperty("pieceSet", (Object)pieceSet2);
    }

    public void setBoardPattern(BoardPattern boardPattern) {
        BoardPattern boardPattern2 = boardPattern == null ? BoardPattern.DEFAULT_BOARD_PATTERN : boardPattern;
        this.boardPainter = boardPattern2.getBoardPainter();
        this.configureBoardPainter();
        this.props.setProperty("boardPattern", (Object)boardPattern2);
    }

    protected void registerConnListeners() {
        ListenerManager listenerManager = this.getConn().getListenerManager();
        listenerManager.addGameListener((GameListener)this);
        listenerManager.addConnectionListener((ConnectionListener)this);
    }

    private void preload() {
        this.createBoardPanel(new Game(1, new Position(), 0, "AlexTheGreat", "Kasparov", 300000, 2000, 300000, 2000, 1800, 2852, (Object)"blah", "Blitz", true, true, "C", "GM", false, Player.WHITE_PLAYER));
    }

    protected void unregisterConnListeners() {
        ListenerManager listenerManager = this.getConn().getListenerManager();
        listenerManager.removeGameListener((GameListener)this);
        listenerManager.removeConnectionListener((ConnectionListener)this);
    }

    public BoardPanel getBoardPanel(Game game) {
        return (BoardPanel)this.gamesToBoardPanels.get(game);
    }

    public void gameStarted(GameStartEvent gameStartEvent) {
        this.createNewBoardPanel(gameStartEvent.getGame());
    }

    protected void createNewBoardPanel(Game game) {
        BoardPanel boardPanel = this.createBoardPanel(game);
        this.initBoardPanel(game, boardPanel);
        game.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PluginUIContainer pluginUIContainer;
                Game game = (Game)propertyChangeEvent.getSource();
                BoardPanel boardPanel = (BoardPanel)BoardManager.this.gamesToBoardPanels.get(game);
                if (boardPanel != null && (pluginUIContainer = (PluginUIContainer)BoardManager.this.boardPanelsToContainers.get(boardPanel)) != null) {
                    pluginUIContainer.setTitle(BoardManager.this.getBoardTitle(boardPanel));
                }
            }
        });
    }

    private PluginUIContainer createBoardContainer() {
        for (int i = 0; i < this.containers.size(); ++i) {
            PluginUIContainer pluginUIContainer = (PluginUIContainer)this.containers.elementAt(i);
            BoardPanel boardPanel = (BoardPanel)this.containersToBoardPanels.get(pluginUIContainer);
            if (boardPanel != null && boardPanel.isActive()) continue;
            return this.recycleContainer(pluginUIContainer);
        }
        return this.createNewBoardContainer();
    }

    private PluginUIContainer createNewBoardContainer() {
        PluginUIContainer pluginUIContainer = this.createContainer(String.valueOf(this.containers.size()), -1);
        this.containers.addElement(pluginUIContainer);
        URL uRL = BoardManager.class.getResource("board.gif");
        if (uRL != null) {
            pluginUIContainer.setIcon(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        pluginUIContainer.addPluginUIListener((PluginUIListener)this);
        return pluginUIContainer;
    }

    private PluginUIContainer recycleContainer(PluginUIContainer pluginUIContainer) {
        BoardPanel boardPanel = (BoardPanel)this.containersToBoardPanels.remove(pluginUIContainer);
        if (boardPanel != null) {
            boardPanel.done();
            this.boardPanelsToContainers.remove(boardPanel);
        }
        Container container = pluginUIContainer.getContentPane();
        container.removeAll();
        return pluginUIContainer;
    }

    protected BoardPanel createBoardPanel(Game game) {
        BoardPanel boardPanel = new BoardPanel(this, game);
        return boardPanel;
    }

    protected void initBoardPanel(Game game, BoardPanel boardPanel) {
        boardPanel.addUserMoveListener(this);
        this.getConn().getListenerManager().addGameListener((GameListener)boardPanel);
        this.gamesToBoardPanels.put(game, boardPanel);
        PluginUIContainer pluginUIContainer = this.createBoardContainer();
        Container container = pluginUIContainer.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)((Object)boardPanel), "Center");
        container.invalidate();
        container.validate();
        pluginUIContainer.setTitle(this.getBoardTitle(boardPanel));
        this.containersToBoardPanels.put(pluginUIContainer, boardPanel);
        this.boardPanelsToContainers.put(boardPanel, pluginUIContainer);
        pluginUIContainer.setActive(true);
    }

    public void moveMade(MoveMadeEvent moveMadeEvent) {
    }

    public void positionChanged(PositionChangedEvent positionChangedEvent) {
    }

    public void takebackOccurred(TakebackEvent takebackEvent) {
    }

    public void illegalMoveAttempted(IllegalMoveEvent illegalMoveEvent) {
    }

    public void clockAdjusted(ClockAdjustmentEvent clockAdjustmentEvent) {
    }

    public void boardFlipped(BoardFlipEvent boardFlipEvent) {
    }

    public void offerUpdated(OfferEvent offerEvent) {
    }

    public void gameEnded(GameEndEvent gameEndEvent) {
        this.gameEndCleanup(gameEndEvent.getGame());
    }

    public void connectingFailed(Connection connection, String string) {
    }

    public void connectionAttempted(Connection connection, String string, int n) {
    }

    public void connectionEstablished(Connection connection) {
    }

    public void loginFailed(Connection connection, String string) {
    }

    public void loginSucceeded(Connection connection) {
    }

    public void connectionLost(Connection connection) {
        Vector vector = new Vector();
        Enumeration enumeration = this.gamesToBoardPanels.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.gameEndCleanup((Game)vector.elementAt(i));
        }
    }

    protected void gameEndCleanup(Game game) {
        BoardPanel boardPanel = (BoardPanel)this.gamesToBoardPanels.remove(game);
        if (boardPanel != null) {
            this.getConn().getListenerManager().removeGameListener((GameListener)boardPanel);
            boardPanel.removeUserMoveListener(this);
            boardPanel.setInactive();
            PluginUIContainer pluginUIContainer = (PluginUIContainer)this.boardPanelsToContainers.get(boardPanel);
            if (pluginUIContainer != null) {
                pluginUIContainer.setTitle(this.getBoardTitle(boardPanel));
            }
        }
    }

    protected String getBoardTitle(BoardPanel boardPanel) {
        Game game = boardPanel.getGame();
        I18n i18n = this.getI18n();
        Object[] objectArray = new Object[]{game};
        if (boardPanel.isActive()) {
            if (game.getGameType() == 1) {
                if (game.isPlayed()) {
                    return i18n.getFormattedString("playingBoardTitle", objectArray);
                }
                return i18n.getFormattedString("examiningBoardTitle", objectArray);
            }
            return i18n.getFormattedString("observingBoardTitle", objectArray);
        }
        return i18n.getFormattedString("inactiveBoardTitle", objectArray);
    }

    public boolean isUserPlaying() {
        Enumeration enumeration = this.gamesToBoardPanels.keys();
        while (enumeration.hasMoreElements()) {
            Game game = (Game)enumeration.nextElement();
            if (game.getGameType() != 1 || !game.isPlayed()) continue;
            return true;
        }
        return false;
    }

    public void userMadeMove(UserMoveEvent userMoveEvent) {
        Object object = userMoveEvent.getSource();
        if (object instanceof BoardPanel) {
            BoardPanel boardPanel = (BoardPanel)object;
            Game game = boardPanel.getGame();
            this.getConn().makeMove(game, userMoveEvent.getMove());
        }
    }

    public void pluginUIClosing(PluginUIEvent pluginUIEvent) {
        PluginUIContainer pluginUIContainer = pluginUIEvent.getPluginUIContainer();
        BoardPanel boardPanel = (BoardPanel)this.containersToBoardPanels.get(pluginUIContainer);
        if (boardPanel.isActive()) {
            Game game = boardPanel.getGame();
            Object object = OptionPanel.OK;
            if (game.getGameType() == 1) {
                object = this.getI18n().confirm(OptionPanel.OK, game.isPlayed() ? "resignDialog" : "unexamineDialog", (Component)((Object)boardPanel));
            }
            if (object == OptionPanel.OK) {
                this.getConn().quitGame(game);
                pluginUIContainer.setVisible(false);
            }
        } else {
            pluginUIContainer.setVisible(false);
        }
    }

    public void pluginUIHidden(PluginUIEvent pluginUIEvent) {
        PluginUIContainer pluginUIContainer = pluginUIEvent.getPluginUIContainer();
        BoardPanel boardPanel = (BoardPanel)this.containersToBoardPanels.remove(pluginUIContainer);
        this.boardPanelsToContainers.remove(boardPanel);
        boardPanel.done();
    }

    public void pluginUIShown(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIActivated(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIDeactivated(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIDisposed(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUITitleChanged(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIIconChanged(PluginUIEvent pluginUIEvent) {
    }

    public boolean hasPreferencesUI() {
        return true;
    }

    public PreferencesPanel getPreferencesUI() {
        return new BoardPreferencesPanel(this);
    }

    public void saveState() {
        String string;
        String string2;
        Preferences preferences = this.getPrefs();
        preferences.setString("piece-set-id", this.getPieceSet().getId());
        preferences.setString("board-pattern-id", this.getBoardPattern().getId());
        preferences.setBool("auto-promote", this.isAutoPromote());
        preferences.setString("move-input-style", this.getMoveInputStyle() == 2 ? "click'n'click" : "drag'n'drop");
        preferences.setBool("piece-follows-cursor", this.isPieceFollowsCursor());
        preferences.setBool("highlight-made-move-squares", this.isHighlightMadeMoveSquares());
        preferences.setColor("highlight-made-move-squares.color", this.getMadeMoveSquaresHighlightColor());
        switch (this.getMoveHighlightingStyle()) {
            case 0: {
                string2 = "none";
                break;
            }
            case 1: {
                string2 = "target-square";
                break;
            }
            case 2: {
                string2 = "square";
                break;
            }
            case 3: {
                string2 = "arrow";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized move highlighting style: " + this.getMoveHighlightingStyle());
            }
        }
        preferences.setString("move-highlight.style", string2);
        switch (this.getCoordsDisplayStyle()) {
            case 0: {
                string = "none";
                break;
            }
            case 1: {
                string = "rim";
                break;
            }
            case 2: {
                string = "outside";
                break;
            }
            case 3: {
                string = "every-square";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized coords display style: " + this.getCoordsDisplayStyle());
            }
        }
        preferences.setString("coords-display.style", string);
        preferences.setColor("coords-display.color", this.getCoordsDisplayColor());
        preferences.setBool("move-highlight.highlight-own", this.isHighlightingOwnMoves());
        preferences.setColor("move-highlight.color", this.getMoveHighlightingColor());
        int n = this.getMoveSendingMode();
        String string3 = n == 1 ? "legal-chess" : (n == 2 ? "predrag" : "premove");
        preferences.setString("move-sending-mode", string3);
        preferences.setColor("white-piece-color", this.getWhitePieceColor());
        preferences.setColor("black-piece-color", this.getBlackPieceColor());
        preferences.setColor("white-outline-color", this.getWhiteOutlineColor());
        preferences.setColor("black-outline-color", this.getBlackOutlineColor());
        preferences.setColor("light-square-color", this.getLightSquareColor());
        preferences.setColor("dark-square-color", this.getDarkSquareColor());
    }

    public String getId() {
        return "board";
    }

    public String getName() {
        return this.getI18n().getString("pluginName");
    }
}

