/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    private Pattern pattern;
    private CharSequence input;
    private int position;
    private int appendPosition;
    private REMatch match;

    public final Matcher appendReplacement(StringBuffer stringBuffer, String string) throws IllegalStateException {
        this.assertMatchOp();
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.match.getStartIndex()).toString());
        stringBuffer.append(RE.getReplacement(string, this.match, 512));
        this.appendPosition = this.match.getEndIndex();
        return this;
    }

    public final StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.input.length()).toString());
        return stringBuffer;
    }

    public final int end() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex();
    }

    public final int end(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex(n);
    }

    public final boolean find() {
        boolean bl = false;
        if (this.match == null) {
            bl = true;
        }
        boolean bl2 = bl;
        this.match = this.pattern.getRE().getMatch(this.input, this.position);
        if (this.match != null) {
            int n = this.match.getEndIndex();
            if (!bl2 && n == this.position) {
                this.match = null;
                if (this.position < this.input.length() - 1) {
                    ++this.position;
                    return this.find(this.position);
                }
                return false;
            }
            this.position = n;
            return true;
        }
        return false;
    }

    public final boolean find(int n) {
        this.match = this.pattern.getRE().getMatch(this.input, n);
        if (this.match != null) {
            this.position = this.match.getEndIndex();
            return true;
        }
        return false;
    }

    public final String group() {
        this.assertMatchOp();
        return this.match.toString();
    }

    public final String group(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.toString(n);
    }

    public final String replaceFirst(String string) {
        this.reset();
        return this.pattern.getRE().substitute(this.input, string, this.position, 512);
    }

    public final String replaceAll(String string) {
        this.reset();
        return this.pattern.getRE().substituteAll(this.input, string, this.position, 512);
    }

    public final int groupCount() {
        return this.pattern.getRE().getNumSubs();
    }

    public final boolean lookingAt() {
        this.match = this.pattern.getRE().getMatch(this.input, 0);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public final boolean matches() {
        this.match = this.pattern.getRE().getMatch(this.input, 0, 256);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                if (this.position == this.input.length()) {
                    return true;
                }
            }
            this.match = null;
        }
        return false;
    }

    public final Pattern pattern() {
        return this.pattern;
    }

    public final Matcher reset() {
        this.position = 0;
        this.match = null;
        return this;
    }

    public final Matcher reset(CharSequence charSequence) {
        this.input = charSequence;
        return this.reset();
    }

    public final int start() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex();
    }

    public final int start(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex(n);
    }

    private final void assertMatchOp() {
        if (this.match == null) {
            throw new IllegalStateException();
        }
    }

    Matcher(Pattern pattern2, CharSequence charSequence) {
        this.pattern = pattern2;
        this.input = charSequence;
    }
}

