// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOCLOCK_H
#define _GSTREAMERMM_AUDIOCLOCK_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/systemclock.h>
#include <memory>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstAudioClock = struct _GstAudioClock;
using GstAudioClockClass = struct _GstAudioClockClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class AudioClock_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** A Helper object for implementing audio clocks.
 * Gst::AudioClock makes it easy for elements to implement a Gst::Clock,
 * they simply need to provide a slot that returns the current clock time.
 *
 * This object is internally used to implement the clock in
 * Gst::AudioBaseSink.
 *
 * Last reviewed on 2016-04-23 (1.8.0).
 */

class AudioClock : public Gst::SystemClock
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = AudioClock;
  using CppClassType = AudioClock_Class;
  using BaseObjectType = GstAudioClock;
  using BaseClassType = GstAudioClockClass;

  // noncopyable
  AudioClock(const AudioClock&) = delete;
  AudioClock& operator=(const AudioClock&) = delete;

private:  friend class AudioClock_Class;
  static CppClassType audioclock_class_;

protected:
  explicit AudioClock(const Glib::ConstructParams& construct_params);
  explicit AudioClock(GstAudioClock* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  AudioClock(AudioClock&& src) noexcept;
  AudioClock& operator=(AudioClock&& src) noexcept;

  ~AudioClock() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAudioClock*       gobj()       { return reinterpret_cast<GstAudioClock*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAudioClock* gobj() const { return reinterpret_cast<GstAudioClock*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAudioClock* gobj_copy();

private:


public:
  /** For example,
   * Gst::ClockTime on_get_time(const Glib::RefPtr<Gst::Clock>& clock);.
   * This function will be called whenever the current clock time needs to be
   * calculated. If this function returns Gst::CLOCK_TIME_NONE, the last
   * reported time will be returned by the clock.
   *
   * @param clock The Gst::AudioClock.
   */
  typedef sigc::slot< Gst::ClockTime, const Glib::RefPtr<Gst::Clock>& > SlotGetTime;

protected:
  AudioClock(const Glib::ustring& name, const SlotGetTime& time_slot);

public:
  /** Create a new Gst::AudioClock instance. Whenever the clock time should
   * be calculated it will call @a time_slot. When @a time_slot returns
   * Gst::CLOCK_TIME_NONE, the clock will return the last reported time.
   * 
   * @param name The name of the clock.
   * @param time_slot A slot that returns the time.
   *
   * @return a new Gst::AudioClock.
   */
  
  static Glib::RefPtr<AudioClock> create(const Glib::ustring& name, const SlotGetTime& time_slot);


  /** Inform @a clock that future calls to Gst::AudioClockGetTimeFunc will return values
   * starting from @a time. The clock will update an internal offset to make sure that
   * future calls to internal_time will return an increasing result as required by
   * the Gst::Clock object.
   * 
   * @param time A Gst::ClockTime.
   */
  void reset(Gst::ClockTime time);

  // TODO methods below get GstClock as a first argument,
  // so have to be wrapped manually. It has been fixed in
  // GStreamer (https://bugzilla.gnome.org/show_bug.cgi?id=756628)
  // but patch is not available in 1.8.0 version.
  
  /** Adjust @a time with the internal offset of the audio clock.
   * 
   * @param clock A Gst::AudioClock.
   * @param time A Gst::ClockTime.
   * @return  @a time adjusted with the internal offset.
   */

  Gst::ClockTime adjust(Gst::ClockTime time);

  
  /** Report the time as returned by the Gst::AudioClockGetTimeFunc without applying
   * any offsets.
   * 
   * @param clock A Gst::AudioClock.
   * @return The time as reported by the time function of the audio clock.
   */

  Gst::ClockTime get_time() const;

  
  /** Invalidate the clock function. Call this function when the provided
   * Gst::AudioClockGetTimeFunc cannot be called anymore, for example, when the
   * user_data becomes invalid.
   * 
   * After calling this function, @a clock will return the last returned time for
   * the rest of its lifetime.
   * 
   * @param clock A Gst::AudioClock.
   */

  void invalidate();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  // TODO this slot should be moved in move constructor, but for now it's
  // impossible to provide custom move constructor
  // (see https://bugzilla.gnome.org/show_bug.cgi?id=756593).
  // However, task should be managed by RefPtr class, so move constructor
  // and move assignment operator will never be called.
  std::unique_ptr<SlotGetTime> m_slot;
#endif


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::AudioClock
   */
  Glib::RefPtr<Gst::AudioClock> wrap(GstAudioClock* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_AUDIOCLOCK_H */

