/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.StringUtils;

public class Options {
    private final ArrayList m_args = new ArrayList();
    private final Map m_map = new TreeMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Options(String[] stringArray, String[] stringArray2) throws ErrorMessage {
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (string.length() <= 0) continue;
            this.m_map.put(string, null);
        }
        this.parseArgs(stringArray);
    }

    public boolean contains(String string) {
        return this.getValue(string) != null;
    }

    public ArrayList getArguments() {
        return this.m_args;
    }

    public double getDouble(String string) throws ErrorMessage {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) throws ErrorMessage {
        String string2 = this.getString(string, Double.toString(d));
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ErrorMessage("Option -" + string + " needs float value");
        }
    }

    public int getInteger(String string) throws ErrorMessage {
        return this.getInteger(string, 0);
    }

    public int getInteger(String string, int n) throws ErrorMessage {
        String string2 = this.getString(string, Integer.toString(n));
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ErrorMessage("Option -" + string + " needs integer value");
        }
    }

    public int getInteger(String string, int n, int n2) throws ErrorMessage {
        int n3 = this.getInteger(string, n);
        if (n3 < n2) {
            throw new ErrorMessage("Option -" + string + " must be greater than " + n2);
        }
        return n3;
    }

    public int getInteger(String string, int n, int n2, int n3) throws ErrorMessage {
        int n4 = this.getInteger(string, n);
        if (n4 < n2 || n4 > n3) {
            throw new ErrorMessage("Option -" + string + " must be in [" + n2 + ".." + n3 + "]");
        }
        return n4;
    }

    public long getLong(String string) throws ErrorMessage {
        return this.getLong(string, 0L);
    }

    public long getLong(String string, long l) throws ErrorMessage {
        String string2 = this.getString(string, Long.toString(l));
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ErrorMessage("Option -" + string + " needs long integer value");
        }
    }

    public String getString(String string) {
        return this.getString(string, "");
    }

    public String getString(String string, String string2) {
        if (!$assertionsDisabled && !this.isValidOption(string)) {
            throw new AssertionError();
        }
        String string3 = this.getValue(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public boolean isSet(String string) {
        String string2 = this.getString(string, null);
        return string2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConfigOption() throws ErrorMessage {
        FileInputStream fileInputStream;
        if (!this.isSet("config")) {
            return;
        }
        String string = this.getString("config");
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ErrorMessage("File not found: " + string);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(256);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(' ');
            }
            this.parseArgs(StringUtils.splitArguments(stringBuffer.toString()));
        }
        catch (IOException iOException) {
            StringUtils.printException(iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                StringUtils.printException(iOException);
            }
        }
    }

    public static Options parse(String[] stringArray, String[] stringArray2) throws ErrorMessage {
        Options options = new Options(stringArray, stringArray2);
        options.handleConfigOption();
        return options;
    }

    private String getSpec(String string) throws ErrorMessage {
        if (this.m_map.containsKey(string)) {
            return string;
        }
        if (this.m_map.containsKey(string + ":")) {
            return string + ":";
        }
        throw new ErrorMessage("Unknown option -" + string);
    }

    private String getValue(String string) {
        if (!$assertionsDisabled && !this.isValidOption(string)) {
            throw new AssertionError();
        }
        if (this.m_map.containsKey(string)) {
            return (String)this.m_map.get(string);
        }
        return (String)this.m_map.get(string + ":");
    }

    private boolean isOptionKey(String string) {
        return string.length() > 0 && string.charAt(0) == '-';
    }

    private boolean isValidOption(String string) {
        return this.m_map.containsKey(string) || this.m_map.containsKey(string + ":");
    }

    private boolean needsValue(String string) {
        return string.length() > 0 && string.substring(string.length() - 1).equals(":");
    }

    private void parseArgs(String[] stringArray) throws ErrorMessage {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ++n;
            if (string.equals("--")) {
                bl = true;
                continue;
            }
            if (this.isOptionKey(string) && !bl) {
                String string2 = this.getSpec(string.substring(1));
                if (this.needsValue(string2)) {
                    if (n >= stringArray.length) {
                        throw new ErrorMessage("Option " + string + " needs value");
                    }
                    String string3 = stringArray[n];
                    ++n;
                    this.m_map.put(string2, string3);
                    continue;
                }
                this.m_map.put(string2, "1");
                continue;
            }
            this.m_args.add(string);
        }
    }

    static {
        $assertionsDisabled = !Options.class.desiredAssertionStatus();
    }
}

