/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PYTHON_H__
#define __SG_PYTHON_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <Python.h>
#include <grammar.h>
#include <node.h>
#include <parsetok.h>
#include <errcode.h>
#include <compile.h>
#include <eval.h>
#include <marshal.h>
#define PY_ARRAY_UNIQUE_SYMBOL PyArrayXXX
#include <arrayobject.h>

gint 		sg_python_error_report                	(PyObject *object);
gint 		sg_python_error_report_verbose        	(PyObject *object,
                                         		 gboolean report,
                                         		 gchar *message,
                                         		 gint type);
gint 		sg_python_init                		(const gchar *progname);
gint 		sg_python_config_init                 	(void);
gint 		sg_python_config_save                 	(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PYTHON_H__ */
