#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GContainer',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 114 => 0x69 },
	'about' => { 540 => 'about' },
	'aboutcvterm' => { 531 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 531 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 531 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 531 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 531 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 121 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 546 => 'absPeakAudioFilePath' },
	'academicfield' => { 536 => 'academicField' },
	'acceleration' => { 124 => 0x9404, 524 => 'Acceleration' },
	'accelerationtracking' => { 89 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 423 => 0x3 },
	'accelerometerdata' => { 413 => 'vrot' },
	'accelerometerx' => { 352 => 0x8d },
	'accelerometery' => { 352 => 0x8e },
	'accelerometerz' => { 352 => 0x8c },
	'accessoryserialnumber' => { 352 => 0x54 },
	'accessorytype' => { 352 => 0x53 },
	'acdseeregion' => { 492 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 492 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 492 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 492 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 492 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 492 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 492 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 492 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 492 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 492 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 492 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 492 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 492 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 492 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 492 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 492 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 492 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 492 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 136 => 0x2a },
	'activearea' => { 124 => 0xc68d },
	'actived-lighting' => { 241 => 0x22, 298 => 0x24 },
	'actived-lightingmode' => { 298 => 0x25 },
	'adaptervoltage' => { 143 => 0x407 },
	'addaspectratioinfo' => { 89 => 0x80e },
	'addiptcinformation' => { 89 => 0x815 },
	'additionalmodelinformation' => { 531 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 89 => 0x80f, 90 => 0x11, 91 => 0x13, 94 => 0x14 },
	'address' => { 166 => 'Address' },
	'adjustmentmode' => { 430 => 0x15 },
	'adlbracketingstep' => { 203 => 0x17 },
	'adlbracketingtype' => { 203 => 0x18 },
	'adobe' => { 125 => 'Adobe' },
	'adultcontentwarning' => { 338 => 'AdultContentWarning', 539 => 'adultContentWarning' },
	'advancedfilter' => { 132 => 0x1201 },
	'advancedraw' => { 300 => 0x76a43203 },
	'advancedscenetype' => { 352 => 0x3d },
	'advisory' => { 544 => 'Advisory' },
	'ae_iso' => { 360 => 0x2, 361 => 0x4, 362 => 0x12 },
	'aeaperture' => { 360 => 0x1, 361 => 0x3, 362 => 0x11 },
	'aeaperturesteps' => { 360 => 0x8, 361 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 89 => 0x104 },
	'aebbracketvalue' => { 81 => 0x11 },
	'aebracketingsteps' => { 203 => 0xf, 204 => 0xf, 280 => 0x174c },
	'aebsequence' => { 89 => 0x105 },
	'aebsequenceautocancel' => { 87 => 0x9, 88 => 0x9, 90 => 0x8, 91 => 0x9, 94 => 0x9, 95 => 0x7 },
	'aebshotcount' => { 89 => 0x106 },
	'aebxv' => { 360 => 0x4, 361 => 0x6 },
	'aeerror' => { 361 => 0x8 },
	'aeexposuretime' => { 360 => 0x0, 361 => 0x2, 362 => 0x10 },
	'aelbutton' => { 189 => 0x45 },
	'aelexposureindicator' => { 189 => 0x51 },
	'aelock' => { 189 => 0x5b, 309 => '4.2', 318 => '4.2', 328 => 0x201, 388 => 0x48, 440 => 0x40, 441 => 0x40, 442 => [0x86,0x286] },
	'aelockbutton' => { 307 => '16.1', 309 => '4.1', 312 => '15.1', 313 => '16.1', 314 => '16.1', 316 => '30.1', 317 => '16.1', 318 => '4.1', 320 => '17.1', 322 => '17.1' },
	'aelockbuttonplusdials' => { 307 => '16.2', 316 => '32.1', 320 => '44.1' },
	'aelockformb-d80' => { 322 => '3.1' },
	'aelockmetermodeafterfocus' => { 89 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 360 => 0x9, 361 => 0x10, 362 => 0x1c },
	'aemaxaperture2' => { 360 => 0xa, 361 => 0x11, 362 => 0x1d },
	'aemeteringmode' => { 360 => 0xc },
	'aemeteringmode2' => { 360 => '13.1' },
	'aemeteringsegments' => { 192 => 0x628, 388 => 0x209 },
	'aemicroadjustment' => { 89 => 0x110 },
	'aeminaperture' => { 360 => 0xb, 361 => 0x12, 362 => 0x1e },
	'aeminexposuretime' => { 360 => 0x5, 361 => 0x13, 362 => 0x1f },
	'aeprogrammode' => { 360 => 0x6 },
	'aeprojectlink' => { 518 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 518 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 518 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 518 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 518 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 518 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 36 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 341 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 360 => 0xd },
	'aexv' => { 360 => 0x3, 361 => 0x5 },
	'af-assistilluminator' => { 323 => 0x1a, 324 => 0x19, 325 => 0x19, 326 => 0x19 },
	'af-cfocusdisplay' => { 324 => 0x234, 325 => 0x234, 326 => 0x24c },
	'af-cpriority' => { 133 => '0.2' },
	'af-cpriorityselection' => { 307 => '1.1', 308 => '1.1', 310 => '1.1', 311 => '1.1', 313 => '0.1', 314 => '0.1', 315 => '0.1', 316 => '1.1', 317 => '0.1', 320 => '1.1', 321 => '1.1', 323 => 0x3, 324 => 0x3, 325 => 0x3, 326 => 0x3 },
	'af-csetting' => { 129 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 129 => '0.2' },
	'af-ctrackingsensitivity' => { 129 => '0.1' },
	'af-czoneareaswitching' => { 129 => '0.3' },
	'af-onbutton' => { 310 => '70.1', 311 => '70.1', 321 => '70.1' },
	'af-onformb-d10' => { 307 => '3.3', 316 => '3.2' },
	'af-onformb-d11' => { 317 => '2.2' },
	'af-onformb-d12' => { 320 => '50.1' },
	'af-onoutoffocusrelease' => { 323 => 0x10, 324 => 0x10, 325 => 0x10, 326 => 0x10 },
	'af-spriority' => { 133 => '0.1' },
	'af-spriorityselection' => { 307 => '1.2', 308 => '1.2', 310 => '1.2', 311 => '1.2', 315 => '0.2', 316 => '1.2', 317 => '0.2', 320 => '1.2', 321 => '1.2', 323 => 0x5, 324 => 0x5, 325 => 0x5, 326 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 307 => '2.1', 308 => '2.1', 310 => '78.3', 311 => '78.3', 316 => '2.1', 320 => '2.1', 321 => '78.3', 323 => 0xf, 324 => 0xf, 325 => 0xf, 326 => 0xf },
	'afadjustment' => { 388 => 0x72, 397 => 0x267 },
	'afandmeteringbuttons' => { 89 => 0x701 },
	'afaperture' => { 234 => 0x5, 235 => 0x5, 239 => 0x5 },
	'afareaheight' => { 198 => [0x1a,0x34,0x50], 199 => 0x48 },
	'afareaillumination' => { 189 => 0x4b, 318 => '15.3' },
	'afareainitialheight' => { 255 => 0xbeb },
	'afareainitialwidth' => { 255 => 0xbea },
	'afareainitialxposition' => { 255 => 0xbe8 },
	'afareainitialyposition' => { 255 => 0xbe9 },
	'afareamode' => { 131 => '0.3', 185 => 0x33, 189 => 0xe, 197 => 0x0, 198 => 0x5, 199 => 0x5, 245 => 0x340, 247 => 0x224, 248 => 0x224, 249 => 0x210, 250 => 0x224, 251 => 0x224, 352 => 0xf, 420 => 0x1205, 433 => [0xa,0x3a], 440 => 0x11, 441 => 0x10, 442 => 0x24, 454 => 0xb043, 480 => 0x17 },
	'afareamodesetting' => { 309 => '11.1', 312 => '0.1', 318 => '16.1', 322 => '2.1', 454 => 0x201c },
	'afareapointsize' => { 131 => '0.4' },
	'afareas' => { 328 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 89 => 0x51b },
	'afareawidth' => { 198 => [0x18,0x32,0x4e], 199 => 0x46 },
	'afareaxposition' => { 198 => [0x14,0x2e,0x4a], 199 => 0x42, 420 => 0x1203 },
	'afareaxposition1' => { 420 => 0x1201 },
	'afareayposition' => { 198 => [0x16,0x30,0x4c], 199 => 0x44, 420 => 0x1204 },
	'afareayposition1' => { 420 => 0x1202 },
	'afareazonesize' => { 131 => '0.5' },
	'afassist' => { 87 => 0x5, 95 => 0x5, 189 => 0x48, 307 => '2.5', 309 => '0.2', 312 => '0.2', 313 => '1.1', 314 => '1.1', 315 => '1.3', 316 => '2.4', 317 => '1.3', 318 => '0.2', 320 => '2.4', 322 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 89 => 0x50e, 90 => 0x4, 91 => 0x5, 92 => 0x4, 93 => 0x4, 94 => 0x5 },
	'afassistlamp' => { 352 => 0x31 },
	'afbuttonpressed' => { 442 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 363 => 0x6 },
	'afduringliveview' => { 89 => 0x511 },
	'affinea' => { 511 => 'AffineA' },
	'affineb' => { 511 => 'AffineB' },
	'affinec' => { 511 => 'AffineC' },
	'affined' => { 511 => 'AffineD' },
	'affinetune' => { 200 => 0x0, 247 => 0x6b0, 248 => 0x6c0, 249 => 0x5b0, 250 => 0x5e0, 251 => 0x5f8, 328 => 0x306 },
	'affinetuneadj' => { 200 => 0x2, 273 => 0x2d1, 274 => 0x2dc, 328 => 0x307 },
	'affinetuneadjtele' => { 200 => 0x3 },
	'affinetuneindex' => { 200 => 0x1 },
	'affinex' => { 511 => 'AffineX' },
	'affiney' => { 511 => 'AffineY' },
	'afhold' => { 363 => 0x1fd },
	'afilluminator' => { 440 => 0x29, 454 => 0xb044 },
	'afimageheight' => { 198 => [0x12,0x2c,0x48], 199 => 0x40 },
	'afimagewidth' => { 198 => [0x10,0x2a,0x46], 199 => 0x3e },
	'afintegrationtime' => { 363 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 433 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 437 => 0x131 },
	'afmicroadjregisteredlenses' => { 437 => '305.1' },
	'afmicroadjustment' => { 89 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 437 => 0x130 },
	'afmode' => { 118 => 0x3009, 132 => 0x1022, 185 => 0x16, 430 => 0x5 },
	'afmoderestrictions' => { 308 => '50.3', 310 => '48.3', 311 => '48.3', 320 => '48.3', 321 => '48.3' },
	'afonaelockbuttonswitch' => { 89 => 0x702 },
	'afonbutton' => { 307 => '3.1', 308 => '47.1', 323 => 0x87, 324 => 0x83, 325 => 0x83, 326 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 36 => 0x13, 117 => 0x18, 185 => 0x15, 197 => 0x1, 331 => 0x308, 430 => 0x1f, 433 => [0x37,0x7], 437 => 0x19, 438 => 0x18, 439 => [0x18,0x20] },
	'afpointactivationarea' => { 88 => 0x11, 94 => 0x11 },
	'afpointareaexpansion' => { 89 => 0x508 },
	'afpointatshutterrelease' => { 433 => [0x39,0x9] },
	'afpointautoselection' => { 89 => 0x50b },
	'afpointbrightness' => { 89 => 0x50d, 307 => '2.4', 308 => '46.5', 310 => '2.2', 311 => '2.2', 320 => '2.3', 321 => '2.2' },
	'afpointdetails' => { 331 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 89 => 0x50c },
	'afpointillumination' => { 88 => 0xa, 307 => '2.3', 308 => '46.2', 310 => '47.2', 311 => '47.2', 315 => '1.2', 316 => '2.3', 317 => '1.2', 320 => '47.2', 321 => '47.2', 322 => '2.4' },
	'afpointinfocus' => { 433 => [0x38,0x8] },
	'afpointmode' => { 368 => 0x3 },
	'afpointposition' => { 118 => 0x2021, 352 => 0x4d },
	'afpointregistration' => { 87 => 0x7 },
	'afpoints' => { 188 => 0x10 },
	'afpointsel' => { 323 => 0xb, 324 => 0xb, 325 => 0xb, 326 => 0xb },
	'afpointselected' => { 189 => 0xd, 328 => 0x305, 388 => 0xe, 437 => 0x15, 438 => 0x14, 439 => [0x14,0x1c], 454 => 0x201e },
	'afpointselected2' => { 368 => 0x4 },
	'afpointselection' => { 88 => 0xb, 307 => '1.3', 308 => '1.3', 316 => '1.3', 320 => '1.3', 321 => '1.3' },
	'afpointselectionmethod' => { 89 => 0x50f, 90 => 0xc, 91 => 0xd, 94 => 0xd },
	'afpointsetting' => { 440 => 0x12, 441 => 0x11 },
	'afpointsinfocus' => { 81 => 0xe, 197 => 0x2, 198 => 0x30, 363 => 0xb, 364 => 0x4, 388 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 88 => 0xd },
	'afpointsselected' => { 198 => 0x1c, 364 => '4.1', 489 => 0x4 },
	'afpointsspecial' => { 364 => '4.2' },
	'afpointsunknown1' => { 363 => 0x0 },
	'afpointsunknown2' => { 363 => 0x2 },
	'afpointsused' => { 198 => [0xa,0x8], 199 => 0xa, 433 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 363 => 0x4 },
	'afresponse' => { 241 => 0xad },
	'afresult' => { 333 => 0x1038 },
	'afsearch' => { 328 => 0x303 },
	'afsensoractive' => { 185 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 420 => 0x1200 },
	'afstatus_00_b4' => { 436 => 0x0 },
	'afstatus_01_c4' => { 436 => 0x2 },
	'afstatus_02_d4' => { 436 => 0x4 },
	'afstatus_03_e4' => { 436 => 0x6 },
	'afstatus_04_f4' => { 436 => 0x8 },
	'afstatus_05_g4' => { 436 => 0xa },
	'afstatus_06_h4' => { 436 => 0xc },
	'afstatus_07_b3' => { 436 => 0xe },
	'afstatus_08_c3' => { 436 => 0x10 },
	'afstatus_09_d3' => { 436 => 0x12 },
	'afstatus_10_e3' => { 436 => 0x14 },
	'afstatus_11_f3' => { 436 => 0x16 },
	'afstatus_12_g3' => { 436 => 0x18 },
	'afstatus_13_h3' => { 436 => 0x1a },
	'afstatus_14_b2' => { 436 => 0x1c },
	'afstatus_15_c2' => { 436 => 0x1e },
	'afstatus_16_d2' => { 436 => 0x20 },
	'afstatus_17_e2' => { 436 => 0x22 },
	'afstatus_18_f2' => { 436 => 0x24 },
	'afstatus_19_g2' => { 436 => 0x26 },
	'afstatus_20_h2' => { 436 => 0x28 },
	'afstatus_21_c1' => { 436 => 0x2a },
	'afstatus_22_d1' => { 436 => 0x2c },
	'afstatus_23_e1' => { 436 => 0x2e },
	'afstatus_24_f1' => { 436 => 0x30 },
	'afstatus_25_g1' => { 436 => 0x32 },
	'afstatus_26_a7_vertical' => { 436 => 0x34 },
	'afstatus_27_a6_vertical' => { 436 => 0x36 },
	'afstatus_28_a5_vertical' => { 436 => 0x38 },
	'afstatus_29_c7_vertical' => { 436 => 0x3a },
	'afstatus_30_c6_vertical' => { 436 => 0x3c },
	'afstatus_31_c5_vertical' => { 436 => 0x3e },
	'afstatus_32_e7_vertical' => { 436 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 436 => 0x42 },
	'afstatus_34_e5_vertical' => { 436 => 0x44 },
	'afstatus_35_g7_vertical' => { 436 => 0x46 },
	'afstatus_36_g6_vertical' => { 436 => 0x48 },
	'afstatus_37_g5_vertical' => { 436 => 0x4a },
	'afstatus_38_i7_vertical' => { 436 => 0x4c },
	'afstatus_39_i6_vertical' => { 436 => 0x4e },
	'afstatus_40_i5_vertical' => { 436 => 0x50 },
	'afstatus_41_a7' => { 436 => 0x52 },
	'afstatus_42_b7' => { 436 => 0x54 },
	'afstatus_43_c7' => { 436 => 0x56 },
	'afstatus_44_d7' => { 436 => 0x58 },
	'afstatus_45_e7' => { 436 => 0x5a },
	'afstatus_46_f7' => { 436 => 0x5c },
	'afstatus_47_g7' => { 436 => 0x5e },
	'afstatus_48_h7' => { 436 => 0x60 },
	'afstatus_49_i7' => { 436 => 0x62 },
	'afstatus_50_a6' => { 436 => 0x64 },
	'afstatus_51_b6' => { 436 => 0x66 },
	'afstatus_52_c6' => { 436 => 0x68 },
	'afstatus_53_d6' => { 436 => 0x6a },
	'afstatus_54_e6_center' => { 436 => 0x6c },
	'afstatus_55_f6' => { 436 => 0x6e },
	'afstatus_56_g6' => { 436 => 0x70 },
	'afstatus_57_h6' => { 436 => 0x72 },
	'afstatus_58_i6' => { 436 => 0x74 },
	'afstatus_59_a5' => { 436 => 0x76 },
	'afstatus_60_b5' => { 436 => 0x78 },
	'afstatus_61_c5' => { 436 => 0x7a },
	'afstatus_62_d5' => { 436 => 0x7c },
	'afstatus_63_e5' => { 436 => 0x7e },
	'afstatus_64_f5' => { 436 => 0x80 },
	'afstatus_65_g5' => { 436 => 0x82 },
	'afstatus_66_h5' => { 436 => 0x84 },
	'afstatus_67_i5' => { 436 => 0x86 },
	'afstatus_68_c11' => { 436 => 0x88 },
	'afstatus_69_d11' => { 436 => 0x8a },
	'afstatus_70_e11' => { 436 => 0x8c },
	'afstatus_71_f11' => { 436 => 0x8e },
	'afstatus_72_g11' => { 436 => 0x90 },
	'afstatus_73_b10' => { 436 => 0x92 },
	'afstatus_74_c10' => { 436 => 0x94 },
	'afstatus_75_d10' => { 436 => 0x96 },
	'afstatus_76_e10' => { 436 => 0x98 },
	'afstatus_77_f10' => { 436 => 0x9a },
	'afstatus_78_g10' => { 436 => 0x9c },
	'afstatus_79_h10' => { 436 => 0x9e },
	'afstatus_80_b9' => { 436 => 0xa0 },
	'afstatus_81_c9' => { 436 => 0xa2 },
	'afstatus_82_d9' => { 436 => 0xa4 },
	'afstatus_83_e9' => { 436 => 0xa6 },
	'afstatus_84_f9' => { 436 => 0xa8 },
	'afstatus_85_g9' => { 436 => 0xaa },
	'afstatus_86_h9' => { 436 => 0xac },
	'afstatus_87_b8' => { 436 => 0xae },
	'afstatus_88_c8' => { 436 => 0xb0 },
	'afstatus_89_d8' => { 436 => 0xb2 },
	'afstatus_90_e8' => { 436 => 0xb4 },
	'afstatus_91_f8' => { 436 => 0xb6 },
	'afstatus_92_g8' => { 436 => 0xb8 },
	'afstatus_93_h8' => { 436 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 436 => 0xbc },
	'afstatusactivesensor' => { 185 => 0x2, 433 => [0x4,0x3b], 437 => 0x1e, 438 => 0x1b, 439 => [0x1b,0x21] },
	'afstatusbottom' => { 185 => 0x8, 437 => 0x2a, 438 => 0x21, 439 => 0x21 },
	'afstatusbottom-left' => { 185 => 0x12, 438 => 0x2b, 439 => 0x2b },
	'afstatusbottom-right' => { 185 => 0x6, 438 => 0x1f, 439 => 0x1f },
	'afstatusbottomassist-left' => { 437 => 0x28 },
	'afstatusbottomassist-right' => { 437 => 0x2c },
	'afstatusbottomhorizontal' => { 434 => 0x10, 435 => 0x1c },
	'afstatusbottomvertical' => { 434 => 0x16, 435 => 0x26 },
	'afstatuscenter-10' => { 437 => 0x34 },
	'afstatuscenter-11' => { 437 => 0x36 },
	'afstatuscenter-12' => { 437 => 0x38 },
	'afstatuscenter-14' => { 437 => 0x3c },
	'afstatuscenter-7' => { 437 => 0x2e },
	'afstatuscenter-9' => { 437 => 0x32 },
	'afstatuscenter-horizontal' => { 437 => 0x30 },
	'afstatuscenter-vertical' => { 437 => 0x3a },
	'afstatuscenterf2-8' => { 437 => 0x4c },
	'afstatuscenterhorizontal' => { 185 => 0x2f, 434 => 0xc, 435 => 0x18, 438 => 0x2f, 439 => 0x2f },
	'afstatuscentervertical' => { 185 => 0xc, 434 => 0x14, 435 => 0x22, 438 => 0x25, 439 => 0x25 },
	'afstatusfarleft' => { 434 => 0x6, 437 => 0x26 },
	'afstatusfarlefthorizontal' => { 435 => 0x4 },
	'afstatusfarleftvertical' => { 435 => 0x12 },
	'afstatusfarright' => { 434 => 0x18, 437 => 0x44 },
	'afstatusfarrighthorizontal' => { 435 => 0x2c },
	'afstatusfarrightvertical' => { 435 => 0x34 },
	'afstatusleft' => { 185 => 0x2d, 434 => 0x2, 437 => 0x22, 438 => 0x2d, 439 => 0x2d },
	'afstatuslefthorizontal' => { 435 => 0x6 },
	'afstatusleftvertical' => { 435 => 0xe },
	'afstatuslower-left' => { 434 => 0x4, 437 => 0x24 },
	'afstatuslower-lefthorizontal' => { 435 => 0xa },
	'afstatuslower-leftvertical' => { 435 => 0x10 },
	'afstatuslower-middle' => { 434 => 0x22, 435 => 0x24 },
	'afstatuslower-right' => { 434 => 0x1e, 437 => 0x4a },
	'afstatuslower-righthorizontal' => { 435 => 0x32 },
	'afstatuslower-rightvertical' => { 435 => 0x3a },
	'afstatuslowerfarleft' => { 435 => 0x8 },
	'afstatuslowerfarright' => { 435 => 0x30 },
	'afstatusmiddlehorizontal' => { 185 => 0xa, 438 => 0x23, 439 => 0x23 },
	'afstatusnearleft' => { 434 => 0xe, 435 => 0x1a },
	'afstatusnearright' => { 434 => 0xa, 435 => 0x16 },
	'afstatusright' => { 185 => 0x31, 434 => 0x1c, 437 => 0x48, 438 => 0x31, 439 => 0x31 },
	'afstatusrighthorizontal' => { 435 => 0x2e },
	'afstatusrightvertical' => { 435 => 0x38 },
	'afstatustop' => { 185 => 0xe, 437 => 0x40, 438 => 0x27, 439 => 0x27 },
	'afstatustop-left' => { 185 => 0x10, 438 => 0x29, 439 => 0x29 },
	'afstatustop-right' => { 185 => 0x4, 438 => 0x1d, 439 => 0x1d },
	'afstatustopassist-left' => { 437 => 0x3e },
	'afstatustopassist-right' => { 437 => 0x42 },
	'afstatustophorizontal' => { 434 => 0x8, 435 => 0x14 },
	'afstatustopvertical' => { 434 => 0x12, 435 => 0x1e },
	'afstatusupper-left' => { 434 => 0x0, 437 => 0x20 },
	'afstatusupper-lefthorizontal' => { 435 => 0x2 },
	'afstatusupper-leftvertical' => { 435 => 0xc },
	'afstatusupper-middle' => { 434 => 0x20, 435 => 0x20 },
	'afstatusupper-right' => { 434 => 0x1a, 437 => 0x46 },
	'afstatusupper-righthorizontal' => { 435 => 0x2a },
	'afstatusupper-rightvertical' => { 435 => 0x36 },
	'afstatusupperfarleft' => { 435 => 0x0 },
	'afstatusupperfarright' => { 435 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 454 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 433 => 0x2 },
	'afwithshutter' => { 440 => 0x2a },
	'aggregateissuenumber' => { 536 => 'aggregateIssueNumber' },
	'aggregationtype' => { 536 => 'aggregationType' },
	'agreement' => { 539 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 143 => 0xe4e },
	'airplanemode' => { 245 => 0x9c0, 247 => 0x722, 248 => 0x732, 249 => 0x624, 250 => 0x654, 251 => 0x6bc },
	'aiservocontinuousshooting' => { 88 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 89 => 0x519 },
	'aiservoimagepriority' => { 89 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 89 => 0x51a },
	'aiservotrackingmethod' => { 89 => 0x504 },
	'aiservotrackingsensitivity' => { 88 => 0x14, 89 => 0x502 },
	'aisubjecttrackingmode' => { 328 => 0x309 },
	'album' => { 405 => ['albm',"\xa9alb"], 407 => 'album', 413 => ['albm',"\xa9alb"], 546 => 'album' },
	'albumartist' => { 184 => 'WM/AlbumArtist', 405 => 'aART', 413 => 'albr' },
	'albumcoverurl' => { 184 => 'WM/AlbumCoverURL' },
	'albumid' => { 405 => 'plID' },
	'albumtitle' => { 184 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 517 => 'AlreadyApplied', 519 => 'AlreadyApplied' },
	'alternatetitle' => { 536 => 'alternateTitle' },
	'alternatetitlea-lang' => { 536 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 536 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 536 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 202 => 0x6 },
	'alttapename' => { 546 => 'altTapeName' },
	'alttextaccessibility' => { 530 => 'AltTextAccessibility' },
	'alttimecode' => { 546 => 'altTimecode' },
	'alttimecodetimeformat' => { 546 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 546 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 546 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 416 => 0x5c },
	'ambientlight' => { 416 => 0x5e },
	'ambienttemperature' => { 124 => 0x9400, 414 => 0x14, 415 => 0x46, 416 => 0x50, 480 => 0x4, 524 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 414 => 0x13, 415 => 0x44, 416 => 0x4e },
	'analogbalance' => { 124 => 0xc627 },
	'analogcaptureiso' => { 143 => 0x89e },
	'analogisotable' => { 143 => 0x89d },
	'androidcapturefps' => { 407 => 'com.android.capture.fps' },
	'androidmake' => { 407 => 'com.android.manufacturer' },
	'androidmodel' => { 407 => 'com.android.model' },
	'androidversion' => { 407 => 'com.android.version' },
	'angleadj' => { 108 => 0x10003, 114 => 0x8b },
	'angleinforoll' => { 513 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 513 => 'AngleInfoYaw' },
	'anti-blur' => { 454 => 0xb04b },
	'antialiasstrength' => { 124 => 0xc632 },
	'antiflicker' => { 60 => 0x20 },
	'aperturelock' => { 308 => '38.2', 310 => '38.2', 311 => '38.2', 320 => '38.2', 321 => '38.2', 323 => 0xbc, 324 => 0xb8, 325 => 0xb8, 326 => 0xb8 },
	'aperturemode' => { 413 => 'apmd' },
	'aperturerange' => { 89 => 0x10d },
	'apertureringuse' => { 368 => '1.4' },
	'aperturesetting' => { 189 => 0x7, 440 => 0x30, 441 => 0x29, 442 => 0x1 },
	'aperturevalue' => { 98 => 0x2, 124 => 0x9202, 333 => 0x1002, 397 => 0x401, 523 => 'ApertureValue' },
	'appinfo' => { 495 => 'AppInfo' },
	'appinfoapplication' => { 495 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 495 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 495 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'applekeywords' => { 337 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 407 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 405 => 'apID' },
	'applestoreaccounttype' => { 405 => 'akID' },
	'applestorecatalogid' => { 405 => 'cnID' },
	'applestorecountry' => { 405 => 'sfID' },
	'applicationkeystring' => { 143 => 0x400 },
	'applicationnotes' => { 124 => 0x2bc, 357 => 0x2bc },
	'applicationrecordversion' => { 136 => 0x0 },
	'applyautomatically' => { 342 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 89 => 0x10e },
	'approved' => { 525 => 'Approved' },
	'approvedby' => { 525 => 'ApprovedBy' },
	'approximatefnumber' => { 347 => 0x313, 354 => 0x3406 },
	'approximatefocusdistance' => { 514 => 'ApproximateFocusDistance' },
	'appversion' => { 529 => 'AppVersion' },
	'aps-csizecapture' => { 473 => 0x114, 474 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 108 => 0x20914 },
	'armidentifier' => { 137 => 0x78 },
	'armversion' => { 137 => 0x7a },
	'arranger' => { 405 => "\xa9arg", 413 => "\xa9arg" },
	'arrangerkeywords' => { 413 => "\xa9ark" },
	'artdirector' => { 405 => "\xa9ard" },
	'artfilter' => { 328 => 0x529 },
	'artfiltereffect' => { 328 => 0x52f },
	'artist' => { 124 => 0x13b, 341 => 'Artist', 357 => 0x13b, 388 => 0x22e, 405 => "\xa9ART", 407 => 'artist', 413 => "\xa9ART", 542 => 'Artist', 546 => 'artist' },
	'artistid' => { 405 => 'atID' },
	'artmode' => { 118 => 0x301b },
	'artmodeparameters' => { 118 => 0x310b },
	'artwork' => { 407 => 'artwork' },
	'artworkcircadatecreated' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 531 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 531 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 332 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 332 => 0x1112, 388 => 0x80, 440 => 0x55, 441 => 0x55, 442 => 0xa, 467 => [0x192c,0x1a88], 468 => 0x192c, 469 => 0x1958, 470 => 0x192c, 471 => 0x188c },
	'assetid' => { 507 => 'AssetID' },
	'asshoticcprofile' => { 124 => 0xc68f },
	'asshotneutral' => { 124 => 0xc628 },
	'asshotpreprofilematrix' => { 124 => 0xc690 },
	'asshotprofilename' => { 124 => 0xc6f6 },
	'asshotwhitexy' => { 124 => 0xc629 },
	'assignbktbutton' => { 307 => '4.2', 308 => '16.1', 310 => '16.1', 311 => '16.1', 320 => '16.1', 321 => '16.1' },
	'assignfuncbutton' => { 89 => 0x70b },
	'assignmb-d17af-onbutton' => { 311 => '79.1' },
	'assignmb-d17funcbutton' => { 311 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 311 => '68.1' },
	'assignmb-d18af-onbutton' => { 321 => '79.1' },
	'assignmb-d18funcbutton' => { 321 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 321 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 310 => '75.1', 311 => '75.1', 321 => '75.1' },
	'assignmoviefunc2button' => { 310 => '82.1', 311 => '82.1', 321 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 310 => '75.2', 311 => '75.2', 321 => '75.2' },
	'assignmovierecordbutton' => { 308 => '43.2', 320 => '45.1', 323 => 0x9f, 324 => 0x9b, 325 => 0x9b, 326 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 310 => '45.1', 311 => '45.1', 321 => '45.1' },
	'assignmoviesubselector' => { 310 => '74.1', 311 => '74.1', 321 => '74.1' },
	'assignmoviesubselectorplusdials' => { 310 => '76.1', 311 => '76.1', 321 => '76.1' },
	'assignremotefnbutton' => { 308 => '54.1', 320 => '51.1' },
	'assistbuttonfunction' => { 87 => 0xd },
	'atcaptureusercrop' => { 143 => 0x943 },
	'attributionname' => { 515 => 'attributionName' },
	'attributionurl' => { 515 => 'attributionURL' },
	'audio' => { 352 => 0x20 },
	'audiobitrate' => { 71 => 0x6c, 531 => 'audioBitRate' },
	'audiobitratemode' => { 531 => 'audioBitRateMode' },
	'audiobitspersample' => { 531 => 'audioBitsPerSample' },
	'audiobutton' => { 325 => 0x17b, 326 => 0x193 },
	'audiobuttonplaybackmode' => { 325 => 0x1b9, 326 => 0x1d1 },
	'audiochannelcount' => { 531 => 'audioChannelCount' },
	'audiochannels' => { 71 => 0x70 },
	'audiochanneltype' => { 546 => 'audioChannelType' },
	'audiocompression' => { 89 => 0x816, 160 => 'Compression' },
	'audiocompressor' => { 546 => 'audioCompressor' },
	'audiodata' => { 498 => 'Data' },
	'audioduration' => { 136 => 0x99 },
	'audiogain' => { 407 => 'player.movie.audio.gain' },
	'audiomimetype' => { 498 => 'Mime' },
	'audiomoddate' => { 546 => 'audioModDate' },
	'audiooutcue' => { 136 => 0x9a },
	'audiosamplerate' => { 71 => 0x6e, 546 => 'audioSampleRate' },
	'audiosampletype' => { 546 => 'audioSampleType' },
	'audiosamplingrate' => { 136 => 0x97 },
	'audiosamplingresolution' => { 136 => 0x98 },
	'audiotype' => { 136 => 0x96 },
	'author' => { 162 => 'Author', 337 => 'Author', 341 => 'Author', 404 => 'Author', 405 => ['auth',"\xa9aut"], 407 => 'author', 413 => 'auth', 512 => 'author', 533 => 'Author', 544 => 'Author' },
	'authorsposition' => { 534 => 'AuthorsPosition' },
	'authorurl' => { 184 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 89 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 378 => '0.1' },
	'autobracket' => { 430 => 0x19 },
	'autobracketing' => { 132 => 0x1100, 388 => 0x18, 420 => 0x1007 },
	'autobracketingmode' => { 319 => '12.3' },
	'autobracketingset' => { 319 => '12.1' },
	'autobracketmodem' => { 307 => '21.2', 308 => '13.3', 310 => '13.2', 311 => '13.2', 316 => '26.2', 320 => '13.3', 321 => '13.2', 323 => 0x63, 324 => 0x5f, 325 => 0x5f, 326 => 0x5f },
	'autobracketorder' => { 189 => 0x43, 307 => '21.3', 308 => '13.2', 310 => '13.1', 311 => '13.1', 316 => '26.3', 317 => '12.2', 318 => '2.2', 319 => '12.2', 320 => '13.2', 321 => '13.1', 322 => '13.2', 323 => 0x65, 324 => 0x61, 325 => 0x61, 326 => 0x61 },
	'autobracketset' => { 307 => '21.1', 308 => '13.1', 312 => '11.1', 313 => '12.1', 314 => '12.1', 316 => '26.1', 317 => '12.1', 318 => '2.1', 320 => '13.1', 322 => '13.1' },
	'autobrightness' => { 517 => 'AutoBrightness', 519 => 'AutoBrightness' },
	'autocapturecriteria' => { 201 => 0x1 },
	'autocapturecriteriamotiondirection' => { 201 => 0x5f },
	'autocapturecriteriamotionsize' => { 201 => 0x64 },
	'autocapturecriteriamotionspeed' => { 201 => 0x63 },
	'autocapturecriteriasubjectsize' => { 201 => 0x69 },
	'autocapturecriteriasubjecttype' => { 201 => 0x6a },
	'autocapturedframe' => { 201 => 0x0 },
	'autocapturedistancefar' => { 201 => 0x4a },
	'autocapturedistancenear' => { 201 => 0x4e },
	'autocapturepreset' => { 251 => 0x746 },
	'autocapturerecordingtime' => { 201 => 0x37 },
	'autocapturewaittime' => { 201 => 0x38 },
	'autocontrast' => { 517 => 'AutoContrast', 519 => 'AutoContrast' },
	'autodistortioncontrol' => { 215 => 0x4, 245 => 0x2cf, 246 => 0x143 },
	'autodynamicrange' => { 132 => 0x140b },
	'autoexposure' => { 517 => 'AutoExposure', 519 => 'AutoExposure' },
	'autoexposurebracketing' => { 81 => 0x10 },
	'autoflashisosensitivity' => { 310 => '38.5', 311 => '38.5', 321 => '38.5', 323 => 0x5f, 324 => 0x5b, 325 => 0x5b, 326 => 0x5b },
	'autofocus' => { 331 => 0x209 },
	'autofocusmoderestrictions' => { 324 => 0x107, 325 => 0x107, 326 => 0x11d },
	'autofp' => { 318 => '7.3', 322 => '31.4' },
	'autoiso' => { 81 => 0x1, 118 => 0x3008, 245 => 0x288, 247 => 0x152, 248 => 0x152, 249 => 0x142, 250 => 0x156, 251 => 0x156, 309 => '1.1', 318 => '1.1' },
	'autoisomax' => { 309 => '1.2', 318 => '1.2' },
	'autoisominshutterspeed' => { 309 => '1.3', 318 => '1.3' },
	'autolateralca' => { 517 => 'AutoLateralCA', 519 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 66 => 0x2, 89 => 0x204, 108 => 0x20500, 114 => 0x6f },
	'autolightingoptimizeron' => { 108 => '0x20500.0', 114 => 0x6e },
	'autoportraitframed' => { 454 => 0x2016 },
	'autoredeye' => { 300 => 0xfe28a44f },
	'autorotate' => { 81 => 0x1b },
	'autoshadows' => { 517 => 'AutoShadows', 519 => 'AutoShadows' },
	'autotone' => { 517 => 'AutoTone', 519 => 'AutoTone' },
	'autotonedigest' => { 517 => 'AutoToneDigest', 519 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 517 => 'AutoToneDigestNoSat', 519 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 517 => 'AutoWhiteVersion', 519 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 241 => 0x82 },
	'avaperturesetting' => { 368 => 0x13 },
	'averageblacklevel' => { 48 => 0xe7, 50 => 0xfb, 51 => 0x114, 52 => 0x146 },
	'averagelv' => { 192 => 0x38 },
	'avsettingwithoutlens' => { 89 => 0x707 },
	'azimuth' => { 170 => 'Azimuth' },
	'babyage' => { 352 => [0x8010,0x33] },
	'babyname' => { 352 => 0x66 },
	'backgroundalpha' => { 541 => 'bgalpha' },
	'balance' => { 407 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 368 => 0x15 },
	'baseiso' => { 81 => 0x2, 102 => 0x101c, 143 => 0x903, 354 => 0x312a, 486 => 0x6 },
	'baseisodaylight' => { 143 => 0x910 },
	'baseisoflash' => { 143 => 0x913 },
	'baseisofluorescent' => { 143 => 0x912 },
	'baseisotungsten' => { 143 => 0x911 },
	'baselineexposure' => { 124 => 0xc62a },
	'baselineexposureoffset' => { 124 => 0xc7a5 },
	'baselinenoise' => { 124 => 0xc62b },
	'baselinesharpness' => { 124 => 0xc62c },
	'baserenditionishdr' => { 528 => 'BaseRenditionIsHDR' },
	'baseurl' => { 544 => 'BaseURL' },
	'bass' => { 407 => 'player.movie.audio.bass' },
	'batterylevel' => { 352 => 0x38, 440 => 0x51, 444 => 0xc, 445 => 0x4, 446 => 0x4, 487 => 0x7, 488 => 0x5 },
	'batterylevel2' => { 488 => 0x7 },
	'batterylevelgrip1' => { 487 => 0x6 },
	'batterylevelgrip2' => { 487 => 0x8 },
	'batteryorder' => { 307 => '12.5', 316 => '13.2', 317 => '2.1', 320 => '3.1' },
	'batterystate' => { 189 => 0x60, 440 => 0x50, 446 => 0x14 },
	'batterytemperature' => { 444 => 0x1, 446 => 0x2, 487 => 0x5 },
	'batterytype' => { 68 => 0x38, 416 => 0x66 },
	'batteryunknown' => { 444 => 0x2, 446 => 0x0 },
	'batteryvoltage' => { 143 => 0x408, 414 => 0x2a, 415 => 0x49, 416 => 0x62, 444 => 0x8 },
	'batteryvoltage1' => { 446 => 0x6 },
	'batteryvoltage2' => { 446 => 0x8 },
	'batteryvoltageavg' => { 416 => 0x64 },
	'bayergreensplit' => { 124 => 0xc62d },
	'bayerpattern' => { 142 => 0xf902, 193 => 0x17 },
	'beatsperminute' => { 405 => 'tmpo' },
	'beatspliceparams' => { 546 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 546 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 546 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 546 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 546 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 546 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 307 => '13.1', 308 => '5.4', 309 => '0.1', 312 => '2.1', 313 => '3.1', 314 => '3.1', 316 => '10.1', 318 => '0.1', 320 => '5.5', 322 => '4.1' },
	'beeppitch' => { 317 => '3.1' },
	'beepvolume' => { 317 => '4.5' },
	'bestqualityscale' => { 124 => 0xc65c },
	'bestshotmode' => { 118 => 0x3007 },
	'bitdepth' => { 167 => 'BitDepth', 193 => 0x11, 266 => 0x41 },
	'bitspercomponent' => { 138 => 0x87 },
	'bitspersample' => { 124 => 0x102, 357 => 0xa, 542 => 'BitsPerSample' },
	'blackacquirerows' => { 143 => 0x18ba },
	'blacklevel' => { 124 => [0x7310,0xc61a], 212 => 0x20, 241 => 0x3d, 333 => [0x401,0x1012], 397 => 0x21d, 461 => [0x7300,0x7310] },
	'blacklevel2' => { 332 => 0x600, 336 => 0x600 },
	'blacklevelblue' => { 357 => 0x1e },
	'blacklevelbottom' => { 143 => 0x3f0 },
	'blackleveldata' => { 397 => 0x223 },
	'blackleveldeltah' => { 124 => 0xc61b },
	'blackleveldeltav' => { 124 => 0xc61c },
	'blacklevelgreen' => { 357 => 0x1d },
	'blacklevelred' => { 357 => 0x1c },
	'blacklevelrepeatdim' => { 124 => 0xc619 },
	'blacklevelrough' => { 143 => 0x40e },
	'blacklevelroughafter' => { 143 => 0x416 },
	'blacklevels' => { 37 => 0x1d },
	'blackleveltop' => { 143 => 0x3ef },
	'blackpoint' => { 388 => 0x200 },
	'blacks2012' => { 517 => 'Blacks2012', 519 => 'Blacks2012' },
	'blacksadj' => { 491 => 0x9018 },
	'bleachbypasstoning' => { 388 => 0x7f },
	'blockshotafresponse' => { 310 => '1.5', 311 => '1.5', 321 => '1.5', 323 => 0x7, 324 => 0x7, 325 => 0x7, 326 => 0x7 },
	'blogtitle' => { 536 => 'blogTitle' },
	'blogurl' => { 536 => 'blogURL' },
	'bluebalance' => { 333 => 0x1018, 357 => 0x12, 388 => 0x1b },
	'bluecurvelimits' => { 113 => 0x1fe },
	'bluecurvepoints' => { 112 => 0x79, 113 => 0x1d4 },
	'bluehsl' => { 108 => 0x20915 },
	'bluehue' => { 517 => 'BlueHue', 519 => 'BlueHue' },
	'bluesaturation' => { 517 => 'BlueSaturation', 519 => 'BlueSaturation' },
	'bluratinfinity' => { 503 => 'BlurAtInfinity' },
	'blurcontrol' => { 388 => 0x82 },
	'blurwarning' => { 132 => 0x1300 },
	'bodybatteryadload' => { 366 => 0x3 },
	'bodybatteryadnoload' => { 366 => 0x2 },
	'bodybatterypercent' => { 366 => 0x3 },
	'bodybatterystate' => { 366 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 366 => 0x4 },
	'bodybatteryvoltage1' => { 366 => 0x2 },
	'bodybatteryvoltage2' => { 366 => 0x4 },
	'bodybatteryvoltage3' => { 366 => 0x6 },
	'bodybatteryvoltage4' => { 366 => 0x8 },
	'bodyfirmware' => { 421 => 0x0 },
	'bodyfirmwareversion' => { 329 => 0x104, 330 => 0x100, 333 => 0x104 },
	'bodyserialnumber' => { 421 => 0x10 },
	'bookedition' => { 536 => 'bookEdition' },
	'bootloaderversion' => { 415 => 0x26 },
	'bracketbutton' => { 248 => 0x808, 251 => 0x80c },
	'bracketbuttonplaybackmode' => { 248 => 0x810, 251 => 0x816 },
	'bracketincrement' => { 245 => 0x34a, 247 => 0x22e, 248 => 0x22e, 249 => 0x21a, 250 => 0x22e, 251 => 0x22e },
	'bracketmode' => { 60 => 0x3 },
	'bracketprogram' => { 245 => 0x348, 247 => 0x22c, 248 => 0x22c, 249 => 0x218, 250 => 0x22c, 251 => 0x22c },
	'bracketsequence' => { 118 => 0x301d },
	'bracketset' => { 245 => 0x346, 247 => 0x22a, 248 => 0x22a, 249 => 0x216, 250 => 0x22a, 251 => 0x22a },
	'bracketsettings' => { 352 => 0x45 },
	'bracketshotnumber' => { 60 => 0x5, 368 => 0x9, 451 => 0x2b },
	'bracketshotnumber2' => { 451 => 0x2d },
	'bracketstep' => { 186 => 0xe },
	'bracketvalue' => { 60 => 0x4 },
	'brightness' => { 124 => 0xfe53, 161 => 'Brightness', 181 => 'Brightness', 186 => 0x2c, 258 => 0x34, 259 => 0x39, 260 => 0x41, 407 => 'player.movie.visual.brightness', 414 => 0x25, 416 => 0x54, 440 => 0x22, 454 => 0x2007, 517 => 'Brightness', 519 => 'Brightness' },
	'brightnessadj' => { 113 => 0x114, 293 => 0x0, 303 => 0x2d, 491 => 0x8018 },
	'brightnessvalue' => { 124 => 0x9203, 192 => [0x691,0x49c3], 333 => 0x1003, 459 => 0x1e, 463 => 0x1140, 464 => 0x1140, 465 => 0x111c, 466 => 0x1198, 467 => 0x1174, 468 => 0x102c, 469 => 0x224, 470 => 0x224, 471 => 0x219, 523 => 'BrightnessValue' },
	'buildnumber' => { 196 => 0x5500 },
	'bulbduration' => { 81 => 0x18 },
	'burstcount' => { 143 => 0x40d },
	'burstgroupid' => { 243 => 0x4 },
	'burstid' => { 499 => 'BurstID' },
	'burstmode' => { 145 => 0xa, 352 => 0x2a },
	'burstmode2' => { 145 => 0x18 },
	'burstprimary' => { 499 => 'BurstPrimary' },
	'burstshot' => { 430 => 0x34 },
	'burstspeed' => { 352 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 89 => 0x70a },
	'bwadjustment' => { 132 => 0x1049 },
	'bwfilter' => { 186 => 0x2a, 194 => 0x39 },
	'bwmagentagreen' => { 132 => 0x104b },
	'bwmode' => { 333 => 0x203 },
	'by-line' => { 136 => 0x50 },
	'by-linetitle' => { 136 => 0x55 },
	'bytecount' => { 536 => 'byteCount' },
	'c14configuration' => { 143 => 0x1964 },
	'cacheversion' => { 124 => 0xc7aa },
	'calibratedfocallength' => { 121 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 121 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 121 => 'CalibratedOpticalCenterY' },
	'calibration' => { 430 => [0x24,0x30] },
	'calibrationhistory' => { 143 => 0x9c9 },
	'calibrationilluminant1' => { 124 => 0xc65a },
	'calibrationilluminant2' => { 124 => 0xc65b },
	'calibrationilluminant3' => { 124 => 0xcd31 },
	'calibrationversion' => { 143 => 0x9c6 },
	'callforimage' => { 507 => 'CallForImage' },
	'camera' => { 495 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 413 => 'angl', 546 => 'cameraAngle' },
	'cameraappinfo' => { 495 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 495 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 495 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 495 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 501 => 'CameraBurstID' },
	'cameracalibration' => { 430 => 0x11f },
	'cameracalibration1' => { 124 => 0xc623 },
	'cameracalibration2' => { 124 => 0xc624 },
	'cameracalibration3' => { 124 => 0xcd32 },
	'cameracalibrationsig' => { 124 => 0xc6f3 },
	'cameracolorcalibration01' => { 38 => 0x0, 39 => 0x0 },
	'cameracolorcalibration02' => { 38 => 0x4, 39 => 0x5 },
	'cameracolorcalibration03' => { 38 => 0x8, 39 => 0xa },
	'cameracolorcalibration04' => { 38 => 0xc, 39 => 0xf },
	'cameracolorcalibration05' => { 38 => 0x10, 39 => 0x14 },
	'cameracolorcalibration06' => { 38 => 0x14, 39 => 0x19 },
	'cameracolorcalibration07' => { 38 => 0x18, 39 => 0x1e },
	'cameracolorcalibration08' => { 38 => 0x1c, 39 => 0x23 },
	'cameracolorcalibration09' => { 38 => 0x20, 39 => 0x28 },
	'cameracolorcalibration10' => { 38 => 0x24, 39 => 0x2d },
	'cameracolorcalibration11' => { 38 => 0x28, 39 => 0x32 },
	'cameracolorcalibration12' => { 38 => 0x2c, 39 => 0x37 },
	'cameracolorcalibration13' => { 38 => 0x30, 39 => 0x3c },
	'cameracolorcalibration14' => { 38 => 0x34, 39 => 0x41 },
	'cameracolorcalibration15' => { 38 => 0x38, 39 => 0x46 },
	'cameradepthmap' => { 495 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 495 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 495 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 495 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 495 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 495 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 495 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 495 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 495 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 495 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 495 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 495 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 407 => 'direction.facing' },
	'camerae-mountversion' => { 490 => 0xb },
	'cameraelevationangle' => { 124 => 0x9405, 524 => 'CameraElevationAngle' },
	'camerafilename' => { 507 => 'CameraFilename' },
	'camerafirmware' => { 124 => 0xa439, 524 => 'CameraFirmware' },
	'cameraid' => { 333 => 0x209, 413 => 'cmid', 429 => 0x209 },
	'cameraidentifier' => { 407 => 'camera.identifier' },
	'cameraimage' => { 495 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 495 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 495 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 495 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 495 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 495 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 495 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 495 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 495 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 495 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 495 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 495 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 495 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 495 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 36 => 0x10 },
	'cameralabel' => { 124 => 0xc7a1, 546 => 'cameraLabel' },
	'cameralightestimate' => { 495 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 495 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 495 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 495 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 495 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 507 => 'CameraMakeModel' },
	'cameramodel' => { 397 => 0x410, 546 => 'cameraModel' },
	'cameramodelid' => { 181 => 'CameraModelID' },
	'cameramodelrestriction' => { 517 => 'CameraModelRestriction', 519 => 'CameraModelRestriction' },
	'cameramotion' => { 407 => 'direction.motion' },
	'cameramove' => { 546 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 352 => 0x8f, 387 => 0x1, 392 => 0x1, 397 => 0x100, 446 => [0x16,0x18], 477 => 0x28, 478 => 0x24, 479 => 0x29 },
	'cameraowner' => { 146 => 0xc353 },
	'cameraparameters' => { 333 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 120 => 0x9, 413 => "\xa9gpt" },
	'camerapointcloud' => { 495 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 495 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 495 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 495 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 495 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 495 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 495 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 495 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 495 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 495 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 495 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 495 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 495 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 517 => 'CameraProfile', 519 => 'CameraProfile' },
	'cameraprofiledigest' => { 517 => 'CameraProfileDigest', 519 => 'CameraProfileDigest' },
	'cameraprofiles' => { 534 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 534 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 534 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 534 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 534 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 534 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 534 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 534 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 534 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 534 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 534 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 534 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 534 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 534 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 534 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 534 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 114 => 0xe1 },
	'camerarawcontrast' => { 114 => 0xe3 },
	'camerarawhighlightpoint' => { 114 => 0xe6 },
	'camerarawlinear' => { 114 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 114 => 0xe8 },
	'camerarawoutputshadowpoint' => { 114 => 0xe9 },
	'camerarawsaturation' => { 114 => 0xe2 },
	'camerarawshadowpoint' => { 114 => 0xe7 },
	'camerarawsharpness' => { 114 => 0xe5 },
	'cameraroll' => { 120 => 0xb, 413 => "\xa9grl" },
	'cameras' => { 495 => 'Cameras' },
	'cameraserialnumber' => { 124 => 0xc62f, 183 => 'CameraSerialNumber', 507 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 328 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 35 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 81 => 0xc, 143 => 0x406, 332 => 0x1306, 347 => 0x320, 354 => 0x3402, 388 => 0x47, 427 => 0x43, 481 => 0x5 },
	'cameratemperature4' => { 393 => 0x14 },
	'cameratemperature5' => { 393 => 0x16 },
	'cameratemperaturerangemax' => { 126 => 0x5 },
	'cameratemperaturerangemin' => { 126 => 0x6 },
	'cameratrait' => { 495 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 81 => 0x1a, 333 => 0x207 },
	'cameratype2' => { 329 => 0x100 },
	'cameravendorinfo' => { 495 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 495 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 495 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 495 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 120 => 0xa, 413 => "\xa9gyw" },
	'camreverse' => { 121 => 'CamReverse' },
	'canondr4' => { 125 => 'CanonDR4' },
	'canonexposuremode' => { 36 => 0x14 },
	'canonfiledescription' => { 102 => 0x805 },
	'canonfilelength' => { 68 => 0xe },
	'canonfirmwareversion' => { 68 => 0x7, 102 => 0x80b },
	'canonflashinfo' => { 102 => 0x1028 },
	'canonflashmode' => { 36 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 36 => 0xa },
	'canonimagetype' => { 68 => 0x6, 102 => 0x815 },
	'canonlogversion' => { 67 => 0xb },
	'canonmodelid' => { 68 => 0x10, 102 => 0x1834 },
	'canonvrd' => { 125 => 'CanonVRD' },
	'caption' => { 512 => 'caption' },
	'caption-abstract' => { 136 => 0x78 },
	'captionsauthornames' => { 522 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 522 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 534 => 'CaptionWriter' },
	'captureframerate' => { 118 => 0x4001 },
	'captureheightnormal' => { 143 => 0x1839 },
	'capturelook' => { 143 => 0xc48 },
	'capturemode' => { 407 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 505 => 'CaptureSoftware' },
	'capturewidthnormal' => { 143 => 0x1838 },
	'capturewidthtest' => { 143 => 0x1842 },
	'cardshutterlock' => { 189 => 0x49 },
	'casioimagesize' => { 118 => 0x9 },
	'catalogsets' => { 136 => 0xff, 497 => 'CatalogSets', 510 => 'CatalogSets' },
	'categories' => { 68 => 0x23, 512 => 'categories' },
	'category' => { 136 => 0xf, 184 => 'WM/Category', 327 => 0x30, 405 => 'catg', 534 => 'Category' },
	'cbcrgain' => { 427 => 0xa036 },
	'cbcrgaindefault' => { 427 => 0xa035 },
	'cbcrmatrix' => { 427 => 0xa034 },
	'cbcrmatrixdefault' => { 427 => 0xa033 },
	'ccdboardversion' => { 347 => 0x331 },
	'ccdscanmode' => { 333 => 0x1039 },
	'ccdsensitivity' => { 289 => 0x6 },
	'ccdversion' => { 347 => 0x330 },
	'ccvavgluminancenits' => { 527 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 527 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 527 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 527 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 527 => 'ccv_white_xy' },
	'cellglobalid' => { 516 => 'cgi' },
	'celllength' => { 124 => 0x109 },
	'cellr' => { 516 => 'r' },
	'celltowerid' => { 516 => 'cellid' },
	'cellwidth' => { 124 => 0x108 },
	'centerafarea' => { 318 => '15.1' },
	'centerfocuspoint' => { 322 => '2.2' },
	'centerpixel' => { 143 => 0x40c },
	'centerweightedareasize' => { 307 => '7.1', 308 => '8.1', 310 => '8.1', 311 => '8.1', 315 => '7.1', 316 => '5.1', 317 => '7.1', 318 => '6.3', 320 => '8.1', 321 => '8.1', 322 => '8.1', 323 => 0x21, 324 => 0x1f, 325 => 0x1f, 326 => 0x1f },
	'certificate' => { 550 => 'Certificate' },
	'cfainterpolationalgorithm' => { 143 => 0xe60 },
	'cfainterpolationmetric' => { 143 => 0xe61 },
	'cfaoffsetcols' => { 143 => 0xc71 },
	'cfaoffsetrows' => { 143 => 0xc6f },
	'cfapattern' => { 124 => 0xa302, 357 => 0x9, 523 => 'CFAPattern' },
	'cfapattern2' => { 124 => 0x828e },
	'cfapatterncolumns' => { 523 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 523 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 523 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 124 => 0x828d },
	'cfazipperfixthreshold' => { 143 => 0xe62 },
	'channel' => { 536 => 'channel' },
	'channela-lang' => { 536 => [\'channel','channelA-lang'] },
	'channelchannel' => { 536 => [\'channel','channelChannel'] },
	'channels' => { 160 => 'Channels' },
	'channelsubchannel1' => { 536 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 536 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 536 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 536 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 413 => 'chpl' },
	'checkmark' => { 108 => 0x10101, 113 => 0x26a },
	'checkmark2' => { 114 => 0x8e },
	'childfontfiles' => { 551 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 307 => '10.3', 308 => '11.2', 324 => 0x10b, 325 => 0x10b, 326 => 0x121 },
	'chromablurradius' => { 124 => 0xc631 },
	'chromanoisecolorspace' => { 143 => 0xe6d },
	'chromanoiseedgemapthresh' => { 143 => 0xe6c },
	'chromanoisehighfthresh' => { 143 => 0xe6a },
	'chromanoiselowfthresh' => { 143 => 0xe6b },
	'chromaticaberration' => { 108 => 0x20703, 114 => 0x66, 427 => 0xa051 },
	'chromaticaberrationb' => { 517 => 'ChromaticAberrationB', 519 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 108 => 0x20708, 114 => 0x6b },
	'chromaticaberrationcorr' => { 83 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 124 => 0x7034, 377 => 0x1, 491 => 0x900d },
	'chromaticaberrationcorrparams' => { 124 => 0x7035, 485 => 0x66a, 486 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 108 => '0x20703.0', 114 => 0x62 },
	'chromaticaberrationr' => { 517 => 'ChromaticAberrationR', 519 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 108 => 0x20707, 114 => 0x6a },
	'chromaticaberrationsetting' => { 84 => 0x6 },
	'chrominancenoisereduction' => { 108 => 0x20601, 114 => 0x5e, 430 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 114 => 0x60 },
	'circadatecreated' => { 531 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 517 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 519 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 517 => 'CircularGradientBasedCorrections', 519 => 'CircularGradientBasedCorrections' },
	'city' => { 136 => 0x5a, 166 => 'City', 352 => 0x6d, 534 => 'City' },
	'city2' => { 352 => 0x80 },
	'clarity' => { 36 => 0x33, 132 => 0x100f, 259 => 0x35, 260 => 0x3d, 454 => 0x2036, 517 => 'Clarity', 519 => 'Clarity' },
	'clarity2012' => { 517 => 'Clarity2012', 519 => 'Clarity2012' },
	'claritycontrol' => { 388 => 0x96 },
	'classification' => { 413 => 'clsf' },
	'classifystate' => { 136 => 0xe1 },
	'clearretouch' => { 352 => 0x7c },
	'clearretouchvalue' => { 352 => 0xa3 },
	'client' => { 546 => 'client' },
	'clientname' => { 525 => 'ClientName' },
	'clipboardaspectratio' => { 517 => 'ClipboardAspectRatio', 519 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 517 => 'ClipboardOrientation', 519 => 'ClipboardOrientation' },
	'clipfilename' => { 413 => 'clfn' },
	'clipid' => { 413 => 'clid' },
	'clmodeshootingspeed' => { 307 => '10.2', 308 => '11.3', 310 => '11.2', 311 => '11.2', 316 => '11.2', 317 => '10.2', 320 => '11.2', 321 => '11.2', 322 => '11.1', 323 => 0x3f, 324 => 0x3b, 325 => 0x3b, 326 => 0x3b },
	'cluster' => { 517 => 'Cluster', 519 => 'Cluster' },
	'cmcontrast' => { 336 => 0x2022 },
	'cmddialsreverserotation' => { 323 => 0xbe, 324 => 0xba, 325 => 0xba, 326 => 0xba },
	'cmexposurecompensation' => { 336 => 0x2000 },
	'cmhue' => { 336 => 0x2021 },
	'cmsaturation' => { 336 => 0x2020 },
	'cmsharpness' => { 336 => 0x2023 },
	'cmwhitebalance' => { 336 => 0x2001 },
	'cmwhitebalancecomp' => { 336 => 0x2002 },
	'cmwhitebalancegraypoint' => { 336 => 0x2010 },
	'codec' => { 174 => 'Codec' },
	'codedcharacterset' => { 137 => 0x5a },
	'codeversion' => { 413 => 'cver' },
	'collection' => { 341 => 'Collection' },
	'collectionname' => { 175 => [\'Collections','CollectionsCollectionName'], 413 => 'coll' },
	'collections' => { 175 => 'Collections', 512 => 'collections' },
	'collectionuri' => { 175 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 407 => 'player.movie.visual.color', 535 => 'color' },
	'coloraberrationcontrol' => { 300 => 0xc89224b },
	'coloradjustment' => { 430 => 0x14 },
	'coloradjustmentmode' => { 429 => 0x210 },
	'coloranta' => { 551 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 551 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 551 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 551 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 551 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 551 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 551 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 551 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 551 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 551 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 551 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 551 => 'Colorants' },
	'colorantswatchname' => { 551 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 551 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 551 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 551 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 161 => 'ColorBalance' },
	'colorbalanceadj' => { 300 => 0x76a43202 },
	'colorbalanceblue' => { 186 => 0x1e },
	'colorbalancegreen' => { 186 => 0x1d },
	'colorbalancered' => { 186 => 0x1c },
	'colorbalanceversion' => { 211 => 0x4, 212 => 0x4, 213 => 0x0, 214 => 0x0 },
	'colorblur' => { 114 => 0x65 },
	'colorbluron' => { 108 => 0x20704 },
	'colorbooster' => { 300 => 0x5f0e7d23 },
	'colorboostlevel' => { 294 => 0x1 },
	'colorboosttype' => { 294 => 0x0 },
	'colorchromeeffect' => { 132 => 0x1048 },
	'colorchromefxblue' => { 132 => 0x104e },
	'colorclass' => { 399 => 0xde, 400 => 'ColorClass' },
	'colorcompensationfilter' => { 189 => [0x3a,0x5f], 191 => 0x111, 454 => 0xb022 },
	'colorcompensationfiltercustom' => { 440 => 0xd, 441 => 0xc },
	'colorcompensationfilterset' => { 440 => 0x8, 441 => 0x7, 442 => 0x18, 459 => 0xf },
	'colorcontrol' => { 333 => 0x102b },
	'colorcorrection' => { 491 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 328 => 0x532 },
	'colordataversion' => { 43 => 0x0, 44 => 0x0, 45 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0 },
	'coloreffect' => { 352 => 0x28 },
	'colorfilter' => { 117 => 0x17, 118 => 0x3017, 186 => 0x29, 194 => [0x38,0x4d,0x4f], 395 => 0x17 },
	'colorgain' => { 266 => 0x51 },
	'colorgradeblending' => { 517 => 'ColorGradeBlending', 519 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 517 => 'ColorGradeGlobalHue', 519 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 517 => 'ColorGradeGlobalLum', 519 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 517 => 'ColorGradeGlobalSat', 519 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 517 => 'ColorGradeHighlightLum', 519 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 517 => 'ColorGradeMidtoneHue', 519 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 517 => 'ColorGradeMidtoneLum', 519 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 517 => 'ColorGradeMidtoneSat', 519 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 517 => 'ColorGradeShadowLum', 519 => 'ColorGradeShadowLum' },
	'colorhue' => { 108 => 0x20900, 241 => 0x8d },
	'colorimetricreference' => { 124 => 0xc6bf },
	'colorlabel' => { 522 => 'ColorLabel' },
	'colormatrix' => { 67 => 0xa, 332 => 0x200, 333 => 0x1011, 427 => 0xa030 },
	'colormatrix1' => { 124 => 0xc621, 397 => 0x106 },
	'colormatrix2' => { 124 => 0xc622, 336 => 0x200, 397 => 0x226 },
	'colormatrix3' => { 124 => 0xcd33 },
	'colormatrixa' => { 388 => 0x203 },
	'colormatrixa2' => { 388 => 0x21c },
	'colormatrixadobergb' => { 427 => 0xa032 },
	'colormatrixb' => { 388 => 0x204 },
	'colormatrixb2' => { 388 => 0x21d },
	'colormatrixnumber' => { 333 => 0x1019 },
	'colormatrixsrgb' => { 427 => 0xa031 },
	'colormode' => { 118 => 0x3015, 132 => 0x1210, 145 => 0x66, 186 => 0x28, 189 => 0x16, 191 => 0x101, 192 => 0x36, 194 => 0x7, 241 => 0x3, 289 => 0x4, 352 => 0x32, 430 => 0x2c, 454 => 0xb029, 534 => 'ColorMode' },
	'colormoirereduction' => { 108 => 0x20670, 301 => 0x15 },
	'colormoirereductionmode' => { 301 => 0x5 },
	'colormoirereductionon' => { 108 => '0x20670.0' },
	'colornoisereduction' => { 491 => 0x8029, 517 => 'ColorNoiseReduction', 519 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 517 => 'ColorNoiseReductionDetail', 519 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 301 => 0x18 },
	'colornoisereductionsharpness' => { 301 => 0x1c },
	'colornoisereductionsmoothness' => { 517 => 'ColorNoiseReductionSmoothness', 519 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 128 => 0x2 },
	'colorprofile' => { 186 => 0x33 },
	'colorprofilesettings' => { 328 => 0x539 },
	'colorrepresentation' => { 138 => 0x3c },
	'colorsaturationadj' => { 108 => 0x20305 },
	'colorsequence' => { 138 => 0x41 },
	'colorspace' => { 54 => 0x3, 68 => 0xb4, 102 => 0x10b4, 124 => 0xa001, 140 => 0x3, 167 => 'ColorSpace', 187 => 0x2f, 188 => 0x25, 189 => 0x17, 241 => 0x1e, 328 => 0x507, 388 => 0x37, 427 => 0xa011, 430 => 0xb, 440 => 0x1b, 441 => 0x83, 442 => 0xe, 459 => 0x6, 523 => 'ColorSpace' },
	'colorspace2' => { 67 => 0x9 },
	'colorspecapproximation' => { 140 => 0x2 },
	'colorspecdata' => { 140 => 0x3 },
	'colorspecmethod' => { 140 => 0x0 },
	'colorspecprecedence' => { 140 => 0x1 },
	'colortempasshot' => { 40 => 0x4, 41 => 0x7, 42 => 0x1d, 43 => 0x59, 44 => 0x6d, 45 => 0x6d, 46 => 0x26, 47 => 0x43, 50 => 0x43, 51 => 0x43, 52 => 0x43, 53 => 0x4b },
	'colortempauto' => { 40 => 0x9, 41 => 0xf, 42 => 0x22, 43 => 0x5e, 44 => 0x72, 46 => 0x1c, 47 => 0x48, 50 => 0x48, 51 => 0x48, 52 => 0x48, 53 => 0x50 },
	'colortempcloudy' => { 40 => 0x22, 41 => 0x37, 42 => 0x31, 43 => 0xa4, 44 => 0xdb, 45 => 0x7c, 46 => 0x35, 47 => 0x5c, 50 => 0x75, 51 => 0x8e, 52 => 0x93, 53 => 0x96, 388 => 0x55 },
	'colortempcustom' => { 47 => 0x84 },
	'colortempcustom1' => { 42 => 0x45 },
	'colortempcustom2' => { 42 => 0x4a },
	'colortempdaylight' => { 40 => 0x18, 41 => 0x27, 42 => 0x27, 43 => 0x9a, 44 => 0xd1, 45 => 0x72, 46 => 0x2b, 47 => 0x52, 50 => 0x6b, 51 => 0x84, 52 => 0x89, 53 => 0x8c, 388 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 68 => 0xae, 78 => 0x9, 102 => 0x10ae, 132 => 0x1005, 143 => 0x846, 161 => 'ColorTemperature', 187 => [0x6e,0x49], 188 => 0x3f, 189 => [0x39,0x5e], 191 => 0x10b, 194 => [0x3c,0x4c,0x4e], 347 => 0x321, 388 => 0x50, 420 => 0x1308, 454 => 0xb021, 517 => 'Temperature', 519 => 'Temperature' },
	'colortemperatureadj' => { 491 => 0x8013 },
	'colortemperatureauto' => { 241 => 0x4f },
	'colortemperaturebg' => { 333 => 0x1013 },
	'colortemperaturecustom' => { 440 => 0xc, 441 => 0xb },
	'colortemperaturerg' => { 333 => 0x1014 },
	'colortemperatureset' => { 440 => 0x7, 441 => 0x6 },
	'colortemperaturesetting' => { 189 => 0x25, 442 => 0x17, 459 => 0xe },
	'colortempflash' => { 40 => 0x36, 41 => 0x57, 42 => 0x40, 43 => 0xb8, 44 => 0xef, 45 => 0x8b, 46 => 0x49, 47 => 0x70, 50 => 0x89, 51 => 0xa2, 52 => 0xa7, 53 => 0xaa, 388 => 0x5a },
	'colortempflashdata' => { 47 => 0x24a },
	'colortempfluorescent' => { 40 => 0x2c, 41 => 0x47, 42 => 0x3b, 43 => 0xae, 44 => 0xe5, 45 => 0x86, 46 => 0x3f, 47 => 0x66, 50 => 0x7f, 51 => 0x98, 52 => 0x9d, 53 => 0xa0 },
	'colortempfluorescentd' => { 388 => 0x57 },
	'colortempfluorescentn' => { 388 => 0x58 },
	'colortempfluorescentw' => { 388 => 0x59 },
	'colortempkelvin' => { 40 => 0x31, 41 => 0x4f, 43 => 0xb3, 44 => 0xea, 46 => 0x44, 47 => 0x6b, 50 => 0x84, 51 => 0x9d, 52 => 0xa2, 53 => 0xa5, 352 => 0x44, 420 => 0x1307 },
	'colortempmeasured' => { 40 => 0xe, 41 => 0x17, 43 => 0x63, 44 => 0x77, 47 => 0x4d, 50 => 0x4d, 51 => 0x4d, 52 => 0x4d, 53 => 0x55 },
	'colortemppc1' => { 46 => 0x94, 47 => 0x75 },
	'colortemppc2' => { 46 => 0x99, 47 => 0x7a },
	'colortemppc3' => { 46 => 0x9e, 47 => 0x7f },
	'colortempshade' => { 40 => 0x1d, 41 => 0x2f, 42 => 0x2c, 43 => 0x9f, 44 => 0xd6, 45 => 0x77, 46 => 0x30, 47 => 0x57, 50 => 0x70, 51 => 0x89, 52 => 0x8e, 53 => 0x91, 388 => 0x54 },
	'colortemptungsten' => { 40 => 0x27, 41 => 0x3f, 42 => 0x36, 43 => 0xa9, 44 => 0xe0, 45 => 0x81, 46 => 0x3a, 47 => 0x61, 50 => 0x7a, 51 => 0x93, 52 => 0x98, 53 => 0x9b, 388 => 0x56 },
	'colortempunknown' => { 40 => 0x13, 41 => 0x1f, 43 => 0x68, 44 => 0x7c, 46 => 0x21, 50 => 0x52, 51 => 0x52, 52 => 0x52, 53 => 0x5a },
	'colortempunknown10' => { 40 => 0x63, 41 => 0x9f, 43 => 0x95, 44 => 0xa9, 45 => 0xb8, 46 => 0x76, 50 => 0xa2, 51 => 0x7f, 52 => 0x7f, 53 => 0x87 },
	'colortempunknown11' => { 40 => 0x68, 41 => 0xa7, 43 => 0xbd, 44 => [0xae,0xb3], 45 => 0xbd, 46 => 0x7b, 50 => 0xa7, 51 => 0xa7, 52 => 0x84, 53 => 0xaf },
	'colortempunknown12' => { 40 => 0x6d, 41 => 0xaf, 43 => 0xc2, 44 => 0xb8, 45 => 0xc2, 46 => 0x80, 50 => 0xac, 51 => 0xac, 52 => 0xac, 53 => 0xb4 },
	'colortempunknown13' => { 40 => 0x72, 41 => 0xb7, 43 => 0xc7, 44 => 0xbd, 45 => 0xc7, 46 => 0x85, 50 => 0xb1, 51 => 0xb1, 52 => 0xb1, 53 => 0xb9 },
	'colortempunknown14' => { 43 => 0xcc, 44 => 0xc2, 45 => 0xcc, 46 => 0x8a, 50 => 0xb6, 51 => 0xb6, 52 => 0xb6, 53 => 0xbe },
	'colortempunknown15' => { 43 => 0xd1, 44 => 0xc7, 45 => 0xd1, 46 => 0x8f, 50 => 0xbb, 51 => 0xbb, 52 => 0xbb, 53 => 0xc3 },
	'colortempunknown16' => { 43 => 0xd6, 44 => 0xcc, 45 => 0xd6, 46 => 0xa3, 51 => 0xc0, 52 => 0xc0, 53 => 0xc8 },
	'colortempunknown17' => { 43 => 0xdb, 44 => 0xf4, 45 => 0xdb, 51 => 0xc5, 52 => 0xc5, 53 => 0xcd },
	'colortempunknown18' => { 43 => 0xe0, 44 => 0xf9, 45 => 0xe0, 51 => 0xca, 52 => 0xca, 53 => 0xd2 },
	'colortempunknown19' => { 43 => 0xe5, 44 => 0xfe, 45 => 0xe5, 51 => 0xcf, 52 => 0xcf, 53 => 0xd7 },
	'colortempunknown2' => { 40 => 0x3b, 41 => 0x5f, 43 => 0x6d, 44 => 0x81, 45 => 0x90, 46 => 0x4e, 50 => 0x57, 51 => 0x57, 52 => 0x57, 53 => 0x5f },
	'colortempunknown20' => { 43 => 0xea, 44 => 0x103, 45 => 0xea, 51 => 0xd4, 52 => 0xd4, 53 => 0xdc },
	'colortempunknown21' => { 43 => 0xef, 44 => 0x108, 45 => 0xef, 52 => 0xd9, 53 => 0xe1 },
	'colortempunknown22' => { 43 => 0xf4, 44 => 0x10d, 45 => 0xf4, 52 => 0xde, 53 => 0xe6 },
	'colortempunknown23' => { 43 => 0xf9, 44 => 0x112, 45 => 0xf9, 52 => 0xe3, 53 => 0xeb },
	'colortempunknown24' => { 43 => 0xfe, 44 => 0x117, 45 => 0xfe, 52 => 0xe8, 53 => 0xf0 },
	'colortempunknown25' => { 43 => 0x103, 44 => 0x11c, 45 => 0x103, 52 => 0xed, 53 => 0xf5 },
	'colortempunknown26' => { 43 => 0x108, 44 => 0x121, 45 => 0x108, 52 => 0xf2, 53 => 0xfa },
	'colortempunknown27' => { 43 => 0x10d, 44 => 0x126, 45 => 0x10d, 52 => 0xf7, 53 => 0xff },
	'colortempunknown28' => { 43 => 0x112, 45 => 0x112, 52 => 0xfc, 53 => 0x104 },
	'colortempunknown29' => { 43 => 0x117, 45 => 0x117, 52 => 0x101, 53 => 0x109 },
	'colortempunknown3' => { 40 => 0x40, 41 => 0x67, 43 => 0x72, 44 => 0x86, 45 => 0x95, 46 => 0x53, 50 => 0x5c, 51 => 0x5c, 52 => 0x5c, 53 => 0x64 },
	'colortempunknown30' => { 45 => 0x11c, 52 => 0x106 },
	'colortempunknown31' => { 45 => 0x121 },
	'colortempunknown32' => { 45 => 0x126 },
	'colortempunknown33' => { 45 => 0x12b },
	'colortempunknown4' => { 40 => 0x45, 41 => 0x6f, 43 => 0x77, 44 => 0x8b, 45 => 0x9a, 46 => 0x58, 50 => 0x61, 51 => 0x61, 52 => 0x61, 53 => 0x69 },
	'colortempunknown5' => { 40 => 0x4a, 41 => 0x77, 43 => 0x7c, 44 => 0x90, 45 => 0x9f, 46 => 0x5d, 50 => 0x66, 51 => 0x66, 52 => 0x66, 53 => 0x6e },
	'colortempunknown6' => { 40 => 0x4f, 41 => 0x7f, 43 => 0x81, 44 => 0x95, 45 => 0xa4, 46 => 0x62, 50 => 0x8e, 51 => 0x6b, 52 => 0x6b, 53 => 0x73 },
	'colortempunknown7' => { 40 => 0x54, 41 => 0x87, 43 => 0x86, 44 => 0x9a, 45 => 0xa9, 46 => 0x67, 50 => 0x93, 51 => 0x70, 52 => 0x70, 53 => 0x78 },
	'colortempunknown8' => { 40 => 0x59, 41 => 0x8f, 43 => 0x8b, 44 => 0x9f, 45 => 0xae, 46 => 0x6c, 50 => 0x98, 51 => 0x75, 52 => 0x75, 53 => 0x7d },
	'colortempunknown9' => { 40 => 0x5e, 41 => 0x97, 43 => 0x90, 44 => 0xa4, 45 => 0xb3, 46 => 0x71, 50 => 0x9d, 51 => 0x7a, 52 => 0x7a, 53 => 0x82 },
	'colortint' => { 351 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 36 => 0x2a, 54 => 0x2, 67 => 0x8 },
	'colortoneadj' => { 108 => 0x20304, 113 => 0x11e },
	'colortoneauto' => { 75 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 74 => 0x6c, 75 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 74 => 0x3c, 75 => 0x3c },
	'colortonemonochrome' => { 74 => 0x84, 75 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 74 => 0x54, 75 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 74 => 0x24, 75 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 74 => 0xc, 75 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 74 => 0x9c, 75 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 74 => 0xb4, 75 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 74 => 0xcc, 75 => 0xe4 },
	'columninterleavefactor' => { 124 => 0xcd43 },
	'comlenblksize' => { 143 => 0xfde8 },
	'commanddialframeadvancezoom' => { 251 => 0x804 },
	'commanddialplaybackmode' => { 324 => 0x1cb, 325 => 0x1cb, 326 => 0x1e3 },
	'commanddials' => { 318 => '5.1' },
	'commanddialsaperturesetting' => { 307 => '17.3', 308 => '18.3', 310 => '18.3', 311 => '18.3', 316 => '33.3', 317 => '17.3', 320 => '18.3', 321 => '18.3' },
	'commanddialschangemainsub' => { 307 => '17.2', 308 => '18.1', 310 => '18.1', 311 => '18.1', 316 => '33.2', 317 => '17.2', 320 => '18.1', 321 => '18.1' },
	'commanddialsmenuandplayback' => { 307 => '17.4', 308 => '18.2', 310 => '18.2', 311 => '18.2', 316 => '33.4', 317 => '17.4', 320 => '18.2', 321 => '18.2' },
	'commanddialsreverserotation' => { 307 => '17.1', 308 => '6.4', 310 => '6.2', 311 => '6.2', 312 => '16.2', 313 => '17.2', 316 => '33.1', 317 => '17.1', 320 => '6.2', 321 => '6.2', 322 => '18.1' },
	'commanddialvideoplaybackmode' => { 324 => 0x1cd, 326 => 0x1e5 },
	'commanderchannel' => { 318 => '10.2', 319 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 318 => '13.1', 319 => '31.1' },
	'commandergroupa_ttlcomp' => { 322 => '32.1' },
	'commandergroupamanualoutput' => { 318 => '13.2', 319 => '28.2' },
	'commandergroupamode' => { 318 => '11.2', 319 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 318 => '14.1', 319 => '32.1' },
	'commandergroupb_ttlcomp' => { 322 => '33.1' },
	'commandergroupbmanualoutput' => { 318 => '14.2', 319 => '29.2' },
	'commandergroupbmode' => { 318 => '11.3', 319 => '29.1' },
	'commanderinternalflash' => { 318 => '11.1', 319 => '27.1' },
	'commanderinternalmanualoutput' => { 318 => '12.2', 319 => '27.2' },
	'commanderinternalttlchannel' => { 316 => '18.2' },
	'commanderinternalttlcomp' => { 318 => '12.1', 319 => '30.2', 322 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 316 => '20.1', 317 => '26.1' },
	'commanderinternalttlcompgroupa' => { 316 => '21.1', 317 => '27.1' },
	'commanderinternalttlcompgroupb' => { 316 => '22.1', 317 => '28.1' },
	'comment' => { 0 => 0x2, 125 => 'Comment', 162 => 'Comment', 341 => 'Comment', 405 => "\xa9cmt", 407 => 'comment', 413 => "\xa9cmt" },
	'compass' => { 423 => 0x4 },
	'compatiblebrands' => { 407 => 'compatible_brands' },
	'compatibleversion' => { 517 => 'CompatibleVersion', 519 => 'CompatibleVersion' },
	'compilation' => { 405 => 'cpil' },
	'compimageimagespersequence' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 524 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 536 => 'complianceProfile' },
	'componentsconfiguration' => { 124 => 0x9101, 167 => 'Components', 523 => 'ComponentsConfiguration' },
	'componentversion' => { 102 => 0x80c },
	'composer' => { 184 => 'WM/Composer', 405 => ["\xa9com","\xa9wrt"], 413 => ["\xa9com","\xa9wrt"], 546 => 'composer' },
	'composerid' => { 405 => 'cmID' },
	'composerkeywords' => { 413 => "\xa9cok" },
	'compositeimage' => { 124 => 0xa460, 524 => 'CompositeImage' },
	'compositeimagecount' => { 124 => 0xa461, 524 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 124 => 0xa462, 524 => 'CompositeImageExposureTimes' },
	'composition' => { 507 => 'Composition' },
	'compositionadjust' => { 386 => '0.1' },
	'compositionadjustrotation' => { 386 => 0x7 },
	'compositionadjustx' => { 386 => 0x5 },
	'compositionadjusty' => { 386 => 0x6 },
	'compressedbitsperpixel' => { 124 => 0x9102, 523 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 191 => 0x40, 333 => 0x40 },
	'compression' => { 124 => 0x103, 357 => 0xb, 542 => 'Compression' },
	'compressionfactor' => { 328 => 0x50d },
	'compressionformat' => { 67 => 0x4 },
	'compressionratio' => { 167 => 'Compression', 333 => 0x1034 },
	'compressorversion' => { 413 => 'CNCV' },
	'condadobvfactor' => { 143 => 0xf3e },
	'condadodaybvthresh' => { 143 => 0xf3c },
	'condadodayoffsets' => { 143 => 0xf42 },
	'condadofluoffsets' => { 143 => 0xf44 },
	'condadofluthresh' => { 143 => 0xf41 },
	'condadoillfactor' => { 143 => 0xf3f },
	'condadoneurange' => { 143 => 0xf3d },
	'condadotunoffsets' => { 143 => 0xf43 },
	'condadotunthresh' => { 143 => 0xf40 },
	'conductor' => { 184 => 'WM/Conductor', 405 => "\xa9con" },
	'confidence' => { 502 => 'Confidence' },
	'confidencelevel' => { 513 => 'ConfidenceLevel' },
	'confidencemime' => { 502 => 'ConfidenceMime' },
	'constrainedcropheight' => { 113 => 0x266, 399 => 0xd6 },
	'constrainedcropwidth' => { 113 => 0x262, 399 => 0xd5 },
	'contact' => { 136 => 0x76 },
	'contactinfo' => { 517 => 'ContactInfo', 519 => 'ContactInfo', 535 => 'contactInfo' },
	'container' => { 495 => 'Container' },
	'containerdirectory' => { 495 => [\'Container','ContainerDirectory'], 500 => 'Directory' },
	'containerdirectoryitem' => { 495 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 495 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 495 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 495 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 495 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 531 => 'ContainerFormat' },
	'containerformatidentifier' => { 531 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 531 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 405 => "\xa9day", 413 => ['@day',"\xa9day"] },
	'contentdistributor' => { 184 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 413 => 'cdis' },
	'contentid' => { 413 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 407 => 'content.identifier' },
	'contentlocationcode' => { 136 => 0x1a },
	'contentlocationname' => { 136 => 0x1b },
	'contenttype' => { 536 => 'contentType' },
	'continuousbracketing' => { 189 => 0x20 },
	'continuousdrive' => { 36 => 0x5 },
	'continuousmodedisplay' => { 323 => 0x55, 324 => 0x51, 325 => 0x51, 326 => 0x51 },
	'continuousmodeliveview' => { 321 => '77.2' },
	'continuousshootingspeed' => { 89 => 0x610 },
	'continuousshotlimit' => { 89 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 36 => 0xd, 117 => 0xc, 118 => [0x3012,0x20], 124 => [0xa408,0xfe54], 132 => [0x1004,0x1006], 161 => 'Contrast', 181 => 'Contrast', 186 => 0x20, 187 => 0x31, 188 => 0x27, 189 => 0x19, 194 => 0x2, 258 => 0x33, 259 => 0x37, 260 => 0x3f, 333 => 0x1029, 352 => 0x39, 354 => 0x300a, 388 => 0x20, 395 => 0xc, 407 => 'player.movie.visual.contrast', 414 => 0x24, 416 => 0x52, 420 => 0x1012, 430 => 0xd, 440 => 0x1d, 441 => 0x1a, 454 => 0x2004, 517 => 'Contrast', 519 => 'Contrast', 523 => 'Contrast' },
	'contrast2012' => { 517 => 'Contrast2012', 519 => 'Contrast2012' },
	'contrastadj' => { 108 => 0x20303, 113 => 0x115, 303 => 0x2c, 491 => 0x8017 },
	'contrastauto' => { 75 => 0x90 },
	'contrastcurve' => { 241 => 0x8c },
	'contrastdetectaf' => { 198 => 0x4 },
	'contrastdetectafarea' => { 388 => 0x231 },
	'contrastdetectafinfocus' => { 198 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 74 => 0x60, 75 => 0x60 },
	'contrasthighlight' => { 388 => 0x6d },
	'contrasthighlightshadowadj' => { 388 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 74 => 0x30, 75 => 0x30 },
	'contrastmode' => { 352 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 74 => 0x78, 75 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 74 => 0x48, 75 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 74 => 0x18, 75 => 0x18 },
	'contrastsetting' => { 328 => 0x505, 336 => 0x1012, 442 => 0x10, 459 => 0x8 },
	'contrastshadow' => { 388 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 74 => 0x0, 75 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 74 => 0x90, 75 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 74 => 0xa8, 75 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 74 => 0xc0, 75 => 0xd8 },
	'contributedmedia' => { 546 => 'contributedMedia' },
	'contributedmediaduration' => { 546 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 546 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 546 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 546 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 546 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 546 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 546 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 546 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 546 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 546 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 520 => 'contributor', 531 => 'Contributor' },
	'contributoridentifier' => { 531 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 531 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 531 => [\'Contributor','ContributorRole'] },
	'contributors' => { 162 => 'Contributors' },
	'controldialset' => { 189 => 0x46 },
	'controlledvocabularyterm' => { 531 => 'CVterm' },
	'controllerboardversion' => { 347 => 0x332 },
	'controlmode' => { 81 => 0x12 },
	'controlringresponse' => { 323 => 0x1cf, 324 => 0x1d5, 325 => 0x1d5, 326 => 0x1ed },
	'controlringrotation' => { 89 => 0x712 },
	'conversionlens' => { 329 => 0x403, 352 => 0x35 },
	'converter' => { 124 => 0xfe4d, 289 => 0xb, 517 => 'Converter', 519 => 'Converter' },
	'converttograyscale' => { 517 => 'ConvertToGrayscale', 519 => 'ConvertToGrayscale' },
	'cookingequipment' => { 538 => 'cookingEquipment' },
	'cookingmethod' => { 538 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 124 => 0x8298, 162 => 'Copyright', 341 => 'Copyright', 357 => 0x8298, 388 => 0x22f, 404 => 'Copyright', 405 => ['cprt',"\xa9cpy"], 407 => 'copyright', 413 => ['cprt',"\xa9cpy"], 517 => 'Copyright', 519 => 'Copyright', 533 => 'Copyright', 539 => 'copyright', 542 => 'Copyright', 546 => 'copyright' },
	'copyrightflag' => { 402 => 0x40a },
	'copyrightnotice' => { 136 => 0x74 },
	'copyrightowner' => { 338 => 'CopyrightOwner' },
	'copyrightownerid' => { 338 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 338 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 338 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 338 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 338 => 'CopyrightStatus' },
	'copyrightyear' => { 531 => 'CopyrightYear', 536 => 'copyrightYear' },
	'coringfilter' => { 332 => 0x310, 333 => 0x102d, 336 => 0x310 },
	'coringvalues' => { 332 => 0x311, 336 => 0x311 },
	'corporateentity' => { 536 => 'corporateEntity' },
	'correctionalreadyapplied' => { 342 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 351 => 0x35b },
	'country' => { 166 => 'Country', 352 => 0x69, 534 => 'Country' },
	'country-primarylocationcode' => { 136 => 0x64 },
	'country-primarylocationname' => { 136 => 0x65 },
	'countrycode' => { 240 => 0x5, 400 => 'CountryCode', 530 => 'CountryCode' },
	'course' => { 538 => 'course' },
	'coverage' => { 520 => 'coverage' },
	'coverart' => { 405 => 'covr' },
	'coverdate' => { 536 => 'coverDate' },
	'coverdisplaydate' => { 536 => 'coverDisplayDate' },
	'coveruri' => { 413 => 'cvru' },
	'cpufirmwareversion' => { 388 => 0x28 },
	'crc32' => { 521 => 'crc32' },
	'createdate' => { 124 => 0x9004, 162 => 'CreateDate', 337 => 'CreationDate', 341 => 'create-date', 404 => 'CreationDate', 410 => 0x1, 544 => 'CreateDate' },
	'creationdate' => { 407 => 'creationdate', 533 => 'CreationDate', 536 => 'creationDate' },
	'creationtime' => { 341 => 'Creation Time', 407 => 'creation_time' },
	'creativestyle' => { 440 => 0x1a, 441 => 0x18, 451 => 0x41, 454 => 0xb020, 486 => 0x4a },
	'creativestylesetting' => { 442 => 0xf, 459 => 0x7 },
	'creativestylewaschanged' => { 491 => 0x8001 },
	'creator' => { 337 => 'Creator', 404 => 'Creator', 520 => 'creator', 531 => 'Creator', 533 => 'Creator' },
	'creatoraddress' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 183 => 'CreatorAppId' },
	'creatorcity' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 530 => 'CreatorContactInfo' },
	'creatorcountry' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 531 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 400 => 'CreatorIdentity' },
	'creatorname' => { 531 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 183 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 531 => [\'Creator','CreatorRole'] },
	'creatortool' => { 544 => 'CreatorTool' },
	'creatorworkemail' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 530 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 136 => 0x6e, 534 => 'Credit' },
	'creditline' => { 539 => 'creditLine' },
	'creditlinereq' => { 549 => 'CreditLineReq' },
	'creditlinerequired' => { 338 => 'CreditLineRequired' },
	'cropactive' => { 106 => 0x0, 113 => 0x244 },
	'cropangle' => { 106 => 0x8, 517 => 'CropAngle', 519 => 'CropAngle' },
	'croparea' => { 241 => 0x45, 491 => 0x9011 },
	'cropaspectratio' => { 108 => 0x30101, 113 => 0x260 },
	'cropaspectratiocustom' => { 108 => 0x30102 },
	'cropbottom' => { 128 => 0x9, 295 => 0x36, 357 => 0x31, 399 => 0xdc, 517 => 'CropBottom', 519 => 'CropBottom' },
	'cropbottommargin' => { 56 => 0x3 },
	'cropcircleactive' => { 114 => 0xd6 },
	'cropcircleradius' => { 114 => 0xd9 },
	'cropcirclex' => { 114 => 0xd7 },
	'cropcircley' => { 114 => 0xd8 },
	'cropconstraintowarp' => { 517 => 'CropConstrainToWarp', 519 => 'CropConstrainToWarp' },
	'cropflag' => { 132 => 0x1051 },
	'croph' => { 511 => 'CropH' },
	'cropheight' => { 106 => 0x6, 113 => 0x24c, 332 => 0x615, 336 => 0x615, 517 => 'CropHeight', 519 => 'CropHeight' },
	'crophispeed' => { 241 => 0x1b },
	'cropleft' => { 113 => 0x246, 128 => 0x6, 295 => 0x1e, 332 => 0x612, 336 => 0x612, 357 => 0x30, 399 => 0xd9, 517 => 'CropLeft', 519 => 'CropLeft' },
	'cropleftmargin' => { 56 => 0x0 },
	'cropmode' => { 132 => 0x104d, 420 => 0x1018 },
	'croporiginalheight' => { 106 => 0xb },
	'croporiginalwidth' => { 106 => 0xa },
	'cropoutputheight' => { 295 => 0xce },
	'cropoutputheightinches' => { 295 => 0x96 },
	'cropoutputpixels' => { 295 => 0xd6 },
	'cropoutputresolution' => { 295 => 0xb6 },
	'cropoutputscale' => { 295 => 0xbe },
	'cropoutputwidth' => { 295 => 0xc6 },
	'cropoutputwidthinches' => { 295 => 0x8e },
	'croppedareaimageheightpixels' => { 505 => 'CroppedAreaImageHeightPixels', 506 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 505 => 'CroppedAreaImageWidthPixels', 506 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 505 => 'CroppedAreaLeftPixels', 506 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 505 => 'CroppedAreaTopPixels', 506 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 420 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 420 => 0x1603 },
	'cropping' => { 491 => 0x9010 },
	'cropright' => { 128 => 0x8, 295 => 0x2e, 357 => 0x32, 399 => 0xdb, 517 => 'CropRight', 519 => 'CropRight' },
	'croprightmargin' => { 56 => 0x1 },
	'croprotatedoriginalheight' => { 106 => 0x2 },
	'croprotatedoriginalwidth' => { 106 => 0x1 },
	'croprotation' => { 106 => 0x7, 128 => 0xb },
	'cropscaledresolution' => { 295 => 0x9e },
	'cropsize' => { 132 => 0x1053 },
	'cropsourceresolution' => { 295 => 0xae },
	'croptop' => { 113 => 0x248, 128 => 0x7, 295 => 0x26, 332 => 0x613, 336 => 0x613, 357 => 0x2f, 399 => 0xda, 517 => 'CropTop', 519 => 'CropTop' },
	'croptopleft' => { 132 => 0x1052 },
	'croptopmargin' => { 56 => 0x2 },
	'cropunit' => { 517 => 'CropUnit', 519 => 'CropUnit' },
	'cropunits' => { 517 => 'CropUnits', 519 => 'CropUnits' },
	'cropw' => { 511 => 'CropW' },
	'cropwidth' => { 106 => 0x5, 113 => 0x24a, 332 => 0x614, 336 => 0x614, 517 => 'CropWidth', 519 => 'CropWidth' },
	'cropx' => { 106 => 0x3, 511 => 'CropX' },
	'cropy' => { 106 => 0x4, 511 => 'CropY' },
	'crossprocess' => { 388 => 0x7b },
	'crossprocessparams' => { 388 => 0x235 },
	'cuisine' => { 538 => 'cuisine' },
	'currenticcprofile' => { 124 => 0xc691 },
	'currentpreprofilematrix' => { 124 => 0xc692 },
	'currentversion' => { 491 => 0xd000 },
	'curve0x' => { 511 => 'Curve0x' },
	'curve0y' => { 511 => 'Curve0y' },
	'curve1x' => { 511 => 'Curve1x' },
	'curve1y' => { 511 => 'Curve1y' },
	'curve2x' => { 511 => 'Curve2x' },
	'curve2y' => { 511 => 'Curve2y' },
	'curve3x' => { 511 => 'Curve3x' },
	'curve3y' => { 511 => 'Curve3y' },
	'curve4x' => { 511 => 'Curve4x' },
	'curve4y' => { 511 => 'Curve4y' },
	'curves' => { 300 => 0x76a43201 },
	'custom1' => { 338 => 'Custom1' },
	'custom10' => { 338 => 'Custom10' },
	'custom2' => { 338 => 'Custom2' },
	'custom3' => { 338 => 'Custom3' },
	'custom4' => { 338 => 'Custom4' },
	'custom5' => { 338 => 'Custom5' },
	'custom6' => { 338 => 'Custom6' },
	'custom7' => { 338 => 'Custom7' },
	'custom8' => { 338 => 'Custom8' },
	'custom9' => { 338 => 'Custom9' },
	'customcolortone' => { 114 => 0x4c },
	'customcontrast' => { 114 => 0x4e },
	'customcontrols' => { 89 => 0x70c },
	'customdefaultunsharpfineness' => { 114 => 0xbe },
	'customdefaultunsharpstrength' => { 114 => 0xbc },
	'customdefaultunsharpthreshold' => { 114 => 0xc0 },
	'customilluminant' => { 143 => 0x405 },
	'customizedials' => { 89 => 0x715 },
	'customlinear' => { 114 => 0x4f },
	'customoutputhighlightpoint' => { 114 => 0x53 },
	'customoutputshadowpoint' => { 114 => 0x54 },
	'custompicturestyle' => { 108 => 0x10021 },
	'custompicturestyledata' => { 108 => 0xf0500 },
	'custompicturestylefilename' => { 68 => 0x4010 },
	'customrawhighlight' => { 114 => 0x7c },
	'customrawhighlightpoint' => { 114 => 0x51 },
	'customrawshadow' => { 114 => 0x85 },
	'customrawshadowpoint' => { 114 => 0x52 },
	'customrendered' => { 124 => 0xa401, 196 => 0x6420, 523 => 'CustomRendered' },
	'customsaturation' => { 114 => 0x4d, 328 => 0x503 },
	'customsettingsalldefault' => { 307 => '0.2', 316 => '0.2' },
	'customsettingsbank' => { 307 => '0.1', 308 => '0.1', 310 => '0.1', 311 => '0.1', 316 => '0.1', 320 => '0.2', 321 => '0.2', 324 => 0x1, 325 => 0x1, 326 => 0x1 },
	'customsharpness' => { 114 => 0x50 },
	'customunsharpmaskfineness' => { 114 => 0xb8 },
	'customunsharpmaskstrength' => { 114 => 0xb6 },
	'customunsharpmaskthreshold' => { 114 => 0xba },
	'customwb_rblevels' => { 459 => 0x1a },
	'customwb_rgblevels' => { 441 => 0x8, 442 => 0x19 },
	'customwbbluelevel' => { 189 => 0x36 },
	'customwberror' => { 189 => 0x37 },
	'customwbgreenlevel' => { 189 => 0x35 },
	'customwbredlevel' => { 189 => 0x34 },
	'customwbsetting' => { 189 => 0x26 },
	'cx' => { 413 => '_cx_' },
	'cy' => { 413 => '_cy_' },
	'd-lightinghq' => { 300 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 296 => 0x2 },
	'd-lightinghqhighlight' => { 296 => 0x1 },
	'd-lightinghqselected' => { 300 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 296 => 0x0 },
	'd-lightinghs' => { 300 => 0xce5554aa },
	'd-lightinghsadjustment' => { 297 => 0x0 },
	'd-lightinghscolorboost' => { 297 => 0x1 },
	'd-rangeoptimizerhighlight' => { 491 => 0x8024 },
	'd-rangeoptimizermode' => { 491 => 0x8022 },
	'd-rangeoptimizershadow' => { 491 => 0x802d },
	'd-rangeoptimizervalue' => { 491 => 0x8023 },
	'darkblacksegrows' => { 143 => 0x18d8 },
	'darkfocusenvironment' => { 352 => 0x8003 },
	'darkframecountfactor' => { 143 => 0xc85 },
	'darkframelongexposure' => { 143 => 0xc84 },
	'darkframeshortexposure' => { 143 => 0xc83 },
	'darkpedestal' => { 143 => 0xc7f },
	'datacompressionmethod' => { 138 => 0x6e },
	'dataimprint' => { 186 => 0x34 },
	'datamining' => { 338 => 'DataMining' },
	'dataonscreen' => { 531 => 'DataOnScreen' },
	'dataonscreenregion' => { 531 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 531 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 531 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 531 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 531 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 531 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 531 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 531 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 388 => 0x3d },
	'date' => { 388 => 0x6, 520 => 'date' },
	'dateacquired' => { 183 => 'DateAcquired', 184 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 136 => 0x37, 534 => 'DateCreated' },
	'datedisplayformat' => { 292 => 0x3 },
	'dateidentified' => { 123 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 312 => '4.2' },
	'daterecieved' => { 536 => 'dateRecieved' },
	'datesent' => { 137 => 0x46 },
	'datestampmode' => { 68 => 0x1c, 241 => 0x9d },
	'datetime' => { 512 => 'datetime', 542 => 'DateTime' },
	'datetimedigitized' => { 523 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 105 => 0x0, 124 => 0x9003, 159 => 0x14, 162 => 'OriginalDate', 408 => 'IDIT', 413 => 'date', 414 => 0xb, 415 => 0x3b, 416 => 0x3e, 523 => 'DateTimeOriginal' },
	'datetimestamp' => { 145 => 0x64 },
	'datetimeutc' => { 328 => 0x908 },
	'daylightsavings' => { 82 => 0x3, 292 => 0x2 },
	'dayofweek' => { 415 => 0x42, 416 => 0x4a },
	'dccontinent' => { 123 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 123 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 123 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 123 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 123 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 123 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 123 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 123 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 123 => 'Event' },
	'dcfootprintspatialfit' => { 123 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 123 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 123 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 123 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 123 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 123 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 123 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 123 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 123 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 123 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 123 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 123 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 123 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 123 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 123 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 123 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 123 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 123 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 123 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 123 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 123 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 170 => 'Declination' },
	'decposition' => { 186 => 0x32 },
	'defaultautogray' => { 517 => 'DefaultAutoGray', 519 => 'DefaultAutoGray' },
	'defaultautotone' => { 517 => 'DefaultAutoTone', 519 => 'DefaultAutoTone' },
	'defaultblackrender' => { 124 => 0xc7a6 },
	'defaultcroporigin' => { 124 => 0xc61f },
	'defaultcropsize' => { 124 => 0xc620 },
	'defaulteraseoption' => { 89 => 0x813 },
	'defaultscale' => { 124 => 0xc61e },
	'defaultsspecifictoiso' => { 517 => 'DefaultsSpecificToISO', 519 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 517 => 'DefaultsSpecificToSerial', 519 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 124 => 0xc7b5 },
	'defectisocode' => { 143 => 0x90f },
	'defringe' => { 517 => 'Defringe', 519 => 'Defringe' },
	'defringegreenamount' => { 517 => 'DefringeGreenAmount', 519 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 517 => 'DefringeGreenHueHi', 519 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 517 => 'DefringeGreenHueLo', 519 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 517 => 'DefringePurpleAmount', 519 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 517 => 'DefringePurpleHueHi', 519 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 517 => 'DefringePurpleHueLo', 519 => 'DefringePurpleHueLo' },
	'dehaze' => { 517 => 'Dehaze', 519 => 'Dehaze' },
	'deletedimagecount' => { 241 => 0xa6, 271 => 0x6e },
	'deprecatedon' => { 515 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 517 => 'DepthBasedCorrections', 519 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 517 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 519 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 124 => 0xc7eb },
	'depthformat' => { 124 => 0xc7e9 },
	'depthimage' => { 502 => 'Data' },
	'depthmapinfo' => { 517 => 'DepthMapInfo', 519 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 519 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 519 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 519 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 519 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 519 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 519 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 519 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 519 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 517 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 519 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 517 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 519 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 124 => 0xc7ed },
	'depthnear' => { 124 => 0xc7ea },
	'depthunits' => { 124 => 0xc7ec },
	'derivedfrom' => { 547 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 547 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 547 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 547 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 547 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 547 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 547 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 547 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 547 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 547 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 547 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 547 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 547 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 547 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 547 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 547 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 547 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 547 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 547 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 547 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 547 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 547 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 547 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 547 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 184 => 'Description', 341 => 'Description', 405 => ['desc','dscp',"\xa9des"], 407 => 'description', 413 => 'dscp', 517 => 'Description', 519 => 'Description', 520 => 'description', 544 => 'Description' },
	'destination' => { 137 => 0x5 },
	'destinationcity' => { 388 => 0x24, 394 => 0x3 },
	'destinationcitycode' => { 395 => 0x1001 },
	'destinationdst' => { 388 => 0x26, 394 => '0.3' },
	'developmentdynamicrange' => { 132 => 0x1403 },
	'deviantmatrixcustom' => { 143 => 0x7de },
	'deviantmatrixdaylight' => { 143 => 0x7da },
	'deviantmatrixflash' => { 143 => 0x7dd },
	'deviantmatrixfluorescent' => { 143 => 0x7dc },
	'deviantmatrixtungsten' => { 143 => 0x7db },
	'deviantwhitecustom' => { 143 => 0x842 },
	'deviantwhitedaylight' => { 143 => 0x83e },
	'deviantwhiteflash' => { 143 => 0x841 },
	'deviantwhitefluorescent' => { 143 => 0x840 },
	'deviantwhitetungsten' => { 143 => 0x83f },
	'device' => { 536 => 'device' },
	'devicesettingdescription' => { 523 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 523 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 523 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 523 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 427 => 0x2 },
	'dewarpdata' => { 121 => 'DewarpData' },
	'dewarpflag' => { 121 => 'DewarpFlag' },
	'dialdirectiontvav' => { 89 => 0x706 },
	'dietaryneeds' => { 538 => 'dietaryNeeds' },
	'diffractioncompensation' => { 230 => 0x20e, 245 => 0x2ce, 246 => 0x142, 247 => 0x1b2, 248 => 0x1b2, 249 => 0x1a2, 250 => 0x1b6, 251 => 0x1b6 },
	'diffractioncorrection' => { 352 => 0xbc, 377 => 0x3 },
	'diffractioncorrectionon' => { 108 => 0x2070b },
	'digitalcreationdate' => { 136 => 0x3e },
	'digitalcreationtime' => { 136 => 0x3f },
	'digitaldeehighlightadj' => { 266 => 0x202 },
	'digitaldeeshadowadj' => { 266 => 0x200 },
	'digitaldeethreshold' => { 266 => 0x201 },
	'digitalfilter' => { 430 => 0x59 },
	'digitalfilter01' => { 374 => 0x5 },
	'digitalfilter02' => { 374 => 0x16 },
	'digitalfilter03' => { 374 => 0x27 },
	'digitalfilter04' => { 374 => 0x38 },
	'digitalfilter05' => { 374 => 0x49 },
	'digitalfilter06' => { 374 => 0x5a },
	'digitalfilter07' => { 374 => 0x6b },
	'digitalfilter08' => { 374 => 0x7c },
	'digitalfilter09' => { 374 => 0x8d },
	'digitalfilter10' => { 374 => 0x9e },
	'digitalfilter11' => { 374 => 0xaf },
	'digitalfilter12' => { 374 => 0xc0 },
	'digitalfilter13' => { 374 => 0xd1 },
	'digitalfilter14' => { 374 => 0xe2 },
	'digitalfilter15' => { 374 => 0xf3 },
	'digitalfilter16' => { 374 => 0x104 },
	'digitalfilter17' => { 374 => 0x115 },
	'digitalfilter18' => { 374 => 0x126 },
	'digitalfilter19' => { 374 => 0x137 },
	'digitalfilter20' => { 374 => 0x148 },
	'digitalgain' => { 78 => 0xb },
	'digitalgem' => { 225 => 0x0 },
	'digitalice' => { 266 => 0x100 },
	'digitalimageguid' => { 531 => 'DigImageGUID' },
	'digitallensoptimizer' => { 66 => 0xa },
	'digitallensoptimizersetting' => { 84 => 0x9 },
	'digitalroc' => { 263 => 0x0 },
	'digitalsourcefiletype' => { 531 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 531 => 'DigitalSourceType' },
	'digitalzoom' => { 36 => 0xc, 117 => 0xa, 132 => 0x1044, 145 => 0x68, 156 => 0x22, 157 => 0x1e, 161 => 'DigitalZoom', 186 => 0xc, 241 => 0x86, 289 => 0xa, 333 => 0x204, 388 => 0x1e, 395 => 0xa, 429 => 0x204, 477 => 0x12, 478 => 0x12 },
	'digitalzoomon' => { 429 => 0x21b },
	'digitalzoomratio' => { 124 => 0xa404, 465 => 0x200, 467 => 0x21c, 523 => 'DigitalZoomRatio' },
	'director' => { 184 => 'WM/Director', 405 => "\xa9dir", 407 => 'director', 413 => "\xa9dir", 546 => 'director' },
	'directorphotography' => { 546 => 'directorPhotography' },
	'directory' => { 125 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 500 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 500 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 500 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 500 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 500 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 500 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 500 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 218 => 0x3, 416 => 0x12 },
	'disableautocreation' => { 499 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 499 => 'DisableSuggestedAction' },
	'disclaimer' => { 341 => 'Disclaimer' },
	'discnumber' => { 546 => 'discNumber' },
	'dishtype' => { 538 => 'dishType' },
	'disknumber' => { 405 => 'disk' },
	'dispbutton' => { 251 => 0x7d4, 324 => 0x2ab },
	'displayallafpoints' => { 89 => 0x514 },
	'displayaperture' => { 36 => 0x23 },
	'displayedunitsx' => { 403 => 0x2 },
	'displayedunitsy' => { 403 => 0x6 },
	'displayname' => { 407 => 'displayname', 535 => 'displayName' },
	'distance1' => { 145 => 0x28 },
	'distance2' => { 145 => 0x2c },
	'distance3' => { 145 => 0x30 },
	'distance4' => { 145 => 0x34 },
	'distortion' => { 427 => 0xa050 },
	'distortioncompensation' => { 491 => 0x8040 },
	'distortioncontrol' => { 271 => 0x10 },
	'distortioncorrection' => { 83 => 0x3, 108 => 0x20705, 114 => 0x67, 124 => 0x7036, 216 => 0x4, 328 => 0x50b, 356 => '7.1', 377 => 0x0, 485 => 0x601, 486 => 0x5b },
	'distortioncorrection2' => { 332 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 514 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 108 => '0x20705.0', 114 => 0x63 },
	'distortioncorrectionsetting' => { 84 => 0x7, 454 => 0x2013 },
	'distortioncorrectionvalue' => { 83 => 0x9 },
	'distortioncorrectionversion' => { 216 => 0x0 },
	'distortioncorrparams' => { 124 => 0x7037, 464 => 0x1a23, 467 => 0x1870, 469 => 0x189c, 470 => 0x18cc, 471 => 0x17d0, 485 => 0x6ca, 486 => 0x64 },
	'distortioncorrparamsnumber' => { 467 => 0x1899, 469 => 0x18c5, 470 => 0x18f5, 471 => 0x17f9 },
	'distortioncorrparamspresent' => { 467 => 0x1898, 469 => 0x18c4, 470 => 0x18f4, 471 => 0x17f8, 473 => 0x10b, 474 => 0x10b, 485 => 0x600, 486 => 0x5a },
	'distortioneffect' => { 108 => 0x20709 },
	'distortionn' => { 356 => 0xc },
	'distortionparam02' => { 356 => 0x2 },
	'distortionparam04' => { 356 => 0x4 },
	'distortionparam08' => { 356 => 0x8 },
	'distortionparam09' => { 356 => 0x9 },
	'distortionparam11' => { 356 => 0xb },
	'distortionscale' => { 356 => 0x5 },
	'distributor' => { 536 => 'distributor' },
	'distributorproductid' => { 535 => 'distributorProductID' },
	'dloon' => { 108 => '0x20706.0', 114 => 0xdc },
	'dlosetting' => { 108 => 0x20706, 114 => 0xdd },
	'dlosettingapplied' => { 107 => 0x4 },
	'dloshootingdistance' => { 114 => 0xde },
	'dloversion' => { 107 => 0x5 },
	'dmcomment' => { 546 => 'comment' },
	'dmdithermatrix' => { 143 => 0xc7a },
	'dmdithermatrixheight' => { 143 => 0xc7c },
	'dmdithermatrixwidth' => { 143 => 0xc7b },
	'dngadobedata' => { 124 => 0xc634 },
	'dngbackwardversion' => { 124 => 0xc613 },
	'dngignoresidecars' => { 517 => 'DNGIgnoreSidecars', 519 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 124 => 0xc630 },
	'dngprivatedata' => { 124 => 0xc634 },
	'dngversion' => { 124 => 0xc612 },
	'document' => { 341 => 'Document' },
	'documentancestors' => { 534 => 'DocumentAncestors' },
	'documenthistory' => { 136 => 0xe7 },
	'documentid' => { 547 => 'DocumentID' },
	'documentname' => { 124 => 0x10d },
	'documentnotes' => { 136 => 0xe6 },
	'doi' => { 536 => 'doi' },
	'dopesheet' => { 531 => 'Dopesheet' },
	'dopesheetlink' => { 531 => 'DopesheetLink' },
	'dopesheetlinklink' => { 531 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 531 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 143 => 0xc82 },
	'dpp' => { 512 => 'dpp' },
	'dprawbokehshift' => { 108 => 0x20b20 },
	'dprawbokehshiftarea' => { 108 => 0x20b21 },
	'dprawghostingreductionarea' => { 108 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 108 => 0x20b10 },
	'dprawmicroadjuststrength' => { 108 => 0x20b12 },
	'dr4cameramodel' => { 109 => 0x3 },
	'drangepriority' => { 132 => 0x1443 },
	'drangepriorityauto' => { 132 => 0x1444 },
	'drangepriorityfixed' => { 132 => 0x1445 },
	'drivemode' => { 118 => 0x3103, 130 => '0.1', 186 => 0x6, 189 => 0x1e, 192 => 0xe, 196 => 0x64d0, 328 => 0x600, 388 => 0x34, 420 => 0x1002, 430 => 0x3, 440 => 0x4, 441 => 0x7e, 442 => 0x34 },
	'drivemode2' => { 189 => 0xa, 368 => 0x7, 451 => 0xe, 459 => 0x1 },
	'drivemodesetting' => { 442 => 0x4 },
	'drivespeed' => { 130 => '0.2' },
	'dspfirmwareversion' => { 388 => 0x27 },
	'dualpixelraw' => { 66 => 0xb },
	'duration' => { 71 => 0x6a, 160 => 'Duration', 174 => 'Duration', 538 => 'duration', 546 => 'duration' },
	'durationscale' => { 546 => [\'duration','durationScale'] },
	'durationvalue' => { 546 => [\'duration','durationValue'] },
	'dustremovaldata' => { 68 => 0x97 },
	'dxcropalert' => { 247 => 0x250, 248 => 0x250, 249 => 0x23c, 250 => 0x250, 251 => 0x250 },
	'dynamicafarea' => { 307 => '1.4', 316 => '1.4' },
	'dynamicafareasize' => { 245 => 0x370, 247 => 0x254, 248 => 0x254, 249 => 0x240, 250 => 0x254, 251 => 0x254 },
	'dynamicareaafassist' => { 323 => 0x18, 324 => 0x18, 325 => 0x18, 326 => 0x18 },
	'dynamicareaafdisplay' => { 308 => '46.1', 310 => '47.1', 311 => '47.1', 320 => '47.1', 321 => '47.1' },
	'dynamicrange' => { 132 => 0x1400 },
	'dynamicrangeboost' => { 352 => 0xee },
	'dynamicrangeexpansion' => { 388 => 0x69, 420 => 0x100e },
	'dynamicrangemax' => { 113 => 0x7c },
	'dynamicrangemin' => { 113 => 0x7a },
	'dynamicrangeoptimizer' => { 189 => 0x15, 454 => [0xb025,0xb04f], 463 => 0x1144, 464 => [0x1144,0x324], 465 => [0x1120,0x300], 466 => [0x119c,0x37c], 467 => [0x1178,0x328], 468 => [0x1030,0x50], 469 => [0x228,0x50], 470 => [0x228,0x50], 471 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 451 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 440 => 0x19, 441 => 0x17, 442 => 0xd, 451 => 0x79, 459 => 0x5 },
	'dynamicrangeoptimizermode' => { 192 => 0x15, 440 => 0x18, 441 => 0x16, 451 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 189 => 0x27, 442 => 0xc, 459 => 0x4 },
	'dynamicrangesetting' => { 132 => 0x1402 },
	'e-dialinprogram' => { 368 => '1.3' },
	'earliestageorloweststage' => { 123 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 123 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 123 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 123 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 123 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 495 => 'EarthPos' },
	'earthposaltitude' => { 495 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 495 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 495 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 495 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 495 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 495 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 495 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 495 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 322 => '6.1' },
	'easyexposurecompensation' => { 307 => '6.4', 308 => '6.5', 310 => '6.3', 311 => '6.3', 315 => '5.1', 316 => '4.4', 317 => '5.2', 320 => '6.3', 321 => '6.3', 323 => 0x1f, 324 => 0x1d, 325 => 0x1d, 326 => 0x1d },
	'easymode' => { 36 => 0xb },
	'edgemapslope' => { 143 => 0x930 },
	'edgemapx1' => { 143 => 0x931 },
	'edgemapx2' => { 143 => 0x932 },
	'edgemapx3' => { 143 => 0x934 },
	'edgemapx4' => { 143 => 0x935 },
	'edgenoisereduction' => { 301 => 0x4, 491 => 0x8028 },
	'edit1' => { 413 => "\xa9ed1" },
	'edit2' => { 413 => "\xa9ed2" },
	'edit3' => { 413 => "\xa9ed3" },
	'edit4' => { 413 => "\xa9ed4" },
	'edit5' => { 413 => "\xa9ed5" },
	'edit6' => { 413 => "\xa9ed6" },
	'edit7' => { 413 => "\xa9ed7" },
	'edit8' => { 413 => "\xa9ed8" },
	'edit9' => { 413 => "\xa9ed9" },
	'edition' => { 536 => 'edition' },
	'editorialupdate' => { 136 => 0x8 },
	'editstatus' => { 136 => 0x7, 400 => 'EditStatus', 512 => 'EditStatus' },
	'editversionname' => { 300 => 0x3d136244 },
	'effectivelv' => { 388 => 0x2d },
	'effectivemaxaperture' => { 234 => 0x12, 235 => 0x13, 239 => 0x14 },
	'eissn' => { 536 => 'eIssn' },
	'electricalblackcolumns' => { 143 => 0x1810 },
	'electronicfront-curtainshutter' => { 310 => '5.2', 311 => '5.2', 320 => '5.3', 321 => '5.2' },
	'electronicfrontcurtainshutter' => { 454 => 0x201a },
	'elevation' => { 170 => 'Elevation' },
	'email' => { 162 => 'EMail' },
	'embargodate' => { 539 => 'embargoDate' },
	'embdencrightsexpr' => { 531 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 531 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 531 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 531 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 534 => 'EmbeddedXMPDigest' },
	'emissivity' => { 126 => 0x3 },
	'emptyslotrelease' => { 245 => 0x98c, 247 => 0x723, 248 => 0x733, 249 => 0x625, 250 => 0x655, 251 => 0x6bd },
	'enablechromanoisereduction' => { 143 => 0xe6e },
	'enablesharpening' => { 143 => 0x92e },
	'encodedby' => { 184 => 'WM/EncodedBy', 405 => "\xa9enc" },
	'encodedwith' => { 407 => 'Encoded_With' },
	'encoder' => { 405 => "\xa9too", 407 => 'encoder', 413 => "\xa9too" },
	'encoderid' => { 413 => "\xa9enc" },
	'encodingtime' => { 184 => 'WM/EncodingTime' },
	'encryptionkey' => { 427 => 0xa020 },
	'endingpage' => { 536 => 'endingPage' },
	'enduser' => { 338 => 'EndUser' },
	'enduserid' => { 338 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 338 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 245 => 0x992, 247 => 0x746, 248 => 0x756, 249 => 0x648, 250 => 0x678, 251 => 0x6e0 },
	'engineer' => { 546 => 'engineer' },
	'enhancedarktones' => { 293 => 0x8 },
	'enhancedenoisealreadyapplied' => { 514 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 514 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 514 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 514 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 514 => 'EnhanceDetailsVersion' },
	'enhancement' => { 117 => 0x16, 118 => 0x3016 },
	'enhanceparams' => { 124 => 0xc7ee },
	'enhancer' => { 332 => 0x300 },
	'enhancervalues' => { 332 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 514 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 514 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 514 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 137 => 0x28 },
	'envelopepriority' => { 137 => 0x3c },
	'enveloperecordversion' => { 137 => 0x0 },
	'episode' => { 531 => 'Episode' },
	'episodeglobaluniqueid' => { 405 => 'egid' },
	'episodeidentifier' => { 531 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 531 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 531 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 333 => 0x20c },
	'epsonimagewidth' => { 333 => 0x20b },
	'epsonsoftware' => { 333 => 0x20d },
	'equipmentinstitution' => { 494 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 494 => 'EquipmentManufacturer' },
	'equipmentversion' => { 329 => 0x0 },
	'ettlii' => { 89 => 0x304, 90 => 0xd, 91 => 0xe, 92 => 0x7, 93 => 0x7, 94 => 0xe },
	'event' => { 497 => 'Event', 510 => 'Event', 531 => 'Event', 536 => 'event' },
	'eventalias' => { 535 => 'eventAlias' },
	'eventdate' => { 123 => [\'Event','EventEventDate'] },
	'eventday' => { 123 => [\'Event','EventDay'] },
	'eventearliestdate' => { 123 => [\'Event','EventEarliestDate'] },
	'eventend' => { 535 => 'eventEnd' },
	'eventenddayofyear' => { 123 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 123 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 123 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 123 => [\'Event','EventHabitat'] },
	'eventid' => { 123 => [\'Event','EventEventID'], 531 => 'EventId' },
	'eventlatestdate' => { 123 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 123 => [\'Event','EventMonth'] },
	'eventnumber' => { 414 => 0x9, 415 => 0x37, 416 => 0x3a },
	'eventparenteventid' => { 123 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 123 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 123 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 123 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 123 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 123 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 535 => 'eventStart' },
	'eventstartdayofyear' => { 123 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 535 => 'eventSubtype' },
	'eventtime' => { 123 => [\'Event','EventEventTime'] },
	'eventtype' => { 535 => 'eventType' },
	'eventverbatimeventdate' => { 123 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 123 => [\'Event','EventYear'] },
	'evfgrid' => { 323 => 0x15f, 324 => 0x165, 325 => 0x165, 326 => 0x17d },
	'evfimageframe' => { 323 => 0x15e, 324 => 0x164, 325 => 0x164, 326 => 0x17c },
	'evfreleaseindicator' => { 324 => 0x24f, 325 => 0x24f, 326 => 0x267 },
	'evfwarmdisplaybrightness' => { 324 => 0x24d, 325 => 0x24d, 326 => 0x265 },
	'evfwarmdisplaymode' => { 324 => 0x24b, 325 => 0x24b, 326 => 0x263 },
	'evsteps' => { 368 => '1.2', 370 => 0x0 },
	'evstepsize' => { 312 => '5.1', 313 => '6.1', 314 => '6.1', 318 => '0.7' },
	'exclusivecoverage' => { 507 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 539 => 'exclusivityEndDate' },
	'excursiontolerance' => { 138 => 0x82 },
	'executiveproducer' => { 405 => "\xa9xpd" },
	'exif' => { 125 => 'EXIF' },
	'exifbyteorder' => { 125 => 'ExifByteOrder' },
	'exifcamerainfo' => { 136 => 0xe8 },
	'exifimageheight' => { 124 => 0xa003, 523 => 'PixelYDimension' },
	'exifimagewidth' => { 124 => 0xa002, 523 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 125 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 124 => 0x9000, 523 => 'ExifVersion' },
	'exitpupilposition' => { 234 => 0x4, 235 => 0x4, 239 => 0x4 },
	'expirationdate' => { 136 => 0x25, 539 => 'expirationDate' },
	'expirationtime' => { 136 => 0x26 },
	'exposure' => { 124 => 0xfe51, 517 => 'Exposure', 519 => 'Exposure' },
	'exposure2012' => { 517 => 'Exposure2012', 519 => 'Exposure2012' },
	'exposureadj' => { 298 => 0x0 },
	'exposureadj2' => { 298 => 0x12 },
	'exposureadjust' => { 430 => 0xc },
	'exposurebracketingindicatorlast' => { 189 => 0x52 },
	'exposurebracketshotnumber' => { 192 => 0x2d, 451 => 0x2f },
	'exposurebracketstepsize' => { 368 => 0x8 },
	'exposurebracketvalue' => { 241 => 0x19 },
	'exposurecompautocancel' => { 89 => 0x113 },
	'exposurecompensation' => { 81 => 0x6, 98 => 0x0, 124 => 0x9204, 145 => 0x24, 161 => 'ExposureComp', 181 => 'ExposureCompensation', 186 => 0xd, 187 => 0x53, 188 => 0x1e, 192 => 0x49c0, 333 => 0x1006, 388 => 0x16, 397 => 0x402, 427 => 0xa013, 430 => [0xc,0x35,0x4d], 463 => 0x114c, 464 => 0x114c, 465 => 0x1128, 467 => 0x1180, 468 => 0x1038, 469 => 0x230, 470 => 0x230, 471 => 0x223, 523 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 459 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 251 => 0x794 },
	'exposurecompensationmode' => { 189 => 0x47, 192 => 0x2a },
	'exposurecompensationset' => { 440 => 0x3, 441 => 0x3, 442 => 0x3, 459 => 0x1e },
	'exposurecompensationsetting' => { 189 => 0x1 },
	'exposurecompstepsize' => { 307 => '6.3', 308 => '7.3', 310 => '7.3', 311 => '7.3', 316 => '4.3', 320 => '7.3', 321 => '7.3' },
	'exposurecontrolstep' => { 315 => '6.1', 317 => '6.1' },
	'exposurecontrolstepsize' => { 307 => '6.2', 308 => '7.1', 310 => '7.1', 311 => '7.1', 316 => '4.2', 320 => '7.1', 321 => '7.1', 322 => '7.1', 323 => 0x1d, 324 => 0x1b, 325 => 0x1b, 326 => 0x1b },
	'exposurecount' => { 132 => 0x1032 },
	'exposuredelay' => { 251 => 0x800, 324 => 0x2f1 },
	'exposuredelaymode' => { 307 => '10.1', 308 => '11.1', 310 => '11.1', 311 => '11.1', 312 => '9.1', 313 => '10.1', 314 => '10.1', 316 => '10.4', 317 => '10.1', 318 => '6.4', 320 => '11.1', 321 => '11.1', 322 => '11.2' },
	'exposuredifference' => { 241 => 0xe },
	'exposuregaincustom' => { 143 => 0x89c },
	'exposuregaindaylight' => { 143 => 0x898 },
	'exposuregainflash' => { 143 => 0x89b },
	'exposuregainfluorescent' => { 143 => 0x89a },
	'exposuregaintungsten' => { 143 => 0x899 },
	'exposureindex' => { 124 => 0xa215, 523 => 'ExposureIndex' },
	'exposureindicator' => { 189 => 0x50 },
	'exposurelevelincrements' => { 87 => 0x6, 88 => 0x6, 89 => 0x101, 90 => 0x5, 91 => 0x6, 92 => 0x5, 93 => 0x5, 94 => 0x6, 95 => 0x4, 440 => 0x58, 441 => 0x58 },
	'exposurelockused' => { 505 => 'ExposureLockUsed' },
	'exposuremode' => { 124 => 0xa402, 161 => 'ExposureMode', 186 => 0x1, 187 => 0xa, 188 => 0x0, 189 => 0x0, 192 => 0x34, 328 => 0x200, 349 => 0x40d, 430 => 0x8, 454 => 0xb041, 523 => 'ExposureMode' },
	'exposuremodeinmanual' => { 89 => 0x10b },
	'exposureprogram' => { 124 => 0x8822, 420 => 0x1001, 433 => [0x17e,0x43], 440 => 0x3c, 441 => 0x3c, 442 => 0x5, 446 => 0x14, 451 => 0x3f, 459 => 0x2, 463 => 0x1175, 464 => 0x1179, 465 => 0x1155, 466 => 0x11d1, 467 => 0x11ad, 468 => 0x1065, 469 => 0x25d, 470 => 0x25d, 471 => 0x24c, 482 => 0xb, 483 => 0xc, 484 => 0xb, 486 => 0x48, 523 => 'ExposureProgram' },
	'exposureshift' => { 328 => 0x203 },
	'exposurestandardadjustment' => { 454 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 81 => 0x16, 124 => 0x829a, 142 => 0xfd05, 145 => 0x20, 147 => 0xfa24, 149 => 0xf104, 152 => 0x12, 154 => 0x38, 156 => 0x14, 157 => 0x10, 159 => 0x10, 161 => 'ExposureTime', 186 => 0x9, 187 => 0x35, 188 => 0x48, 189 => 0x8, 192 => 0x49b8, 388 => 0x12, 427 => 0xa018, 430 => [0x32,0x4a], 440 => 0x0, 441 => 0x0, 459 => [0x21,0x23,0x27], 486 => 0x10, 523 => 'ExposureTime' },
	'exposuretime2' => { 430 => [0x33,0x4b] },
	'exposuretuning' => { 241 => 0x1c },
	'exposurevalue' => { 143 => 0x3 },
	'exposurewarning' => { 132 => 0x1302 },
	'exrauto' => { 132 => 0x1033 },
	'exrmode' => { 132 => 0x1034 },
	'extdescraccessibility' => { 530 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 247 => 0x120, 248 => 0x120, 249 => 0x114, 250 => 0x124, 251 => 0x124 },
	'extendedshutterspeeds' => { 323 => 0xf2, 324 => 0x102, 325 => 0x102, 326 => 0x118 },
	'extendedwbdetect' => { 328 => 0x902 },
	'extender' => { 329 => 0x301 },
	'extenderfirmwareversion' => { 329 => 0x304 },
	'extendermagnification' => { 163 => 'Magnification' },
	'extendermake' => { 163 => 'Make' },
	'extendermodel' => { 163 => 'Model', 329 => 0x303 },
	'extenderserialnumber' => { 163 => 'SerialNumber', 329 => 0x302 },
	'extenderstatus' => { 385 => 0x3 },
	'externalflash' => { 331 => 0x1201 },
	'externalflashae1' => { 333 => 0x101f },
	'externalflashae1_0' => { 333 => 0x101b },
	'externalflashae2' => { 333 => 0x1020 },
	'externalflashae2_0' => { 333 => 0x101c },
	'externalflashbounce' => { 331 => 0x1204, 333 => 0x1026, 375 => 0x1a },
	'externalflashcompensation' => { 221 => 0x1b },
	'externalflashexposurecomp' => { 241 => 0x17, 375 => 0x19 },
	'externalflashfirmware' => { 219 => 0x6, 220 => 0x6, 221 => 0x6, 222 => 0x6, 223 => 0x6, 224 => 0x6 },
	'externalflashflags' => { 219 => 0x8, 220 => 0x8, 221 => 0x8, 222 => 0x8, 224 => 0x8 },
	'externalflashguidenumber' => { 331 => 0x1203, 375 => '24.1' },
	'externalflashgvalue' => { 333 => 0x1025 },
	'externalflashmode' => { 333 => 0x1028, 375 => 0x2 },
	'externalflashreadystate' => { 223 => '9.1' },
	'externalflashstatus' => { 223 => '8.2' },
	'externalflashzoom' => { 331 => 0x1205, 333 => 0x1027 },
	'externalflashzoomoverride' => { 223 => '8.1' },
	'externalmetadatalink' => { 531 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 347 => 0x311, 350 => 0x311, 351 => 0x311, 354 => 0x3408 },
	'extrainfoversion' => { 444 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 189 => 0x40 },
	'fac100per' => { 143 => 0xe94 },
	'fac170per' => { 143 => 0xe93 },
	'fac18per' => { 143 => 0xe92 },
	'face10position' => { 115 => 0x3f4, 116 => 0x1ec, 217 => 0x28, 372 => 0x12 },
	'face10size' => { 373 => 0x12 },
	'face11position' => { 217 => 0x2c, 372 => 0x14 },
	'face11size' => { 373 => 0x14 },
	'face12position' => { 217 => 0x30, 372 => 0x16 },
	'face12size' => { 373 => 0x16 },
	'face13position' => { 372 => 0x18 },
	'face13size' => { 373 => 0x18 },
	'face14position' => { 372 => 0x1a },
	'face14size' => { 373 => 0x1a },
	'face15position' => { 372 => 0x1c },
	'face15size' => { 373 => 0x1c },
	'face16position' => { 372 => 0x1e },
	'face16size' => { 373 => 0x1e },
	'face17position' => { 372 => 0x20 },
	'face17size' => { 373 => 0x20 },
	'face18position' => { 372 => 0x22 },
	'face18size' => { 373 => 0x22 },
	'face19position' => { 372 => 0x24 },
	'face19size' => { 373 => 0x24 },
	'face1position' => { 57 => 0x8, 115 => 0xd, 116 => 0x18, 217 => 0x4, 344 => 0x1, 372 => 0x0, 417 => 0xbc, 447 => 0x1, 448 => 0x0, 449 => 0x0, 450 => 0x5b },
	'face1size' => { 373 => 0x0 },
	'face20position' => { 372 => 0x26 },
	'face20size' => { 373 => 0x26 },
	'face21position' => { 372 => 0x28 },
	'face21size' => { 373 => 0x28 },
	'face22position' => { 372 => 0x2a },
	'face22size' => { 373 => 0x2a },
	'face23position' => { 372 => 0x2c },
	'face23size' => { 373 => 0x2c },
	'face24position' => { 372 => 0x2e },
	'face24size' => { 373 => 0x2e },
	'face25position' => { 372 => 0x30 },
	'face25size' => { 373 => 0x30 },
	'face26position' => { 372 => 0x32 },
	'face26size' => { 373 => 0x32 },
	'face27position' => { 372 => 0x34 },
	'face27size' => { 373 => 0x34 },
	'face28position' => { 372 => 0x36 },
	'face28size' => { 373 => 0x36 },
	'face29position' => { 372 => 0x38 },
	'face29size' => { 373 => 0x38 },
	'face2position' => { 57 => 0xa, 115 => 0x7c, 116 => 0x4c, 217 => 0x8, 344 => 0x5, 372 => 0x2, 417 => 0xc8, 447 => 0x6, 448 => 0x20, 449 => 0x25, 450 => 0x65 },
	'face2size' => { 373 => 0x2 },
	'face30position' => { 372 => 0x3a },
	'face30size' => { 373 => 0x3a },
	'face31position' => { 372 => 0x3c },
	'face31size' => { 373 => 0x3c },
	'face32position' => { 372 => 0x3e },
	'face32size' => { 373 => 0x3e },
	'face3position' => { 57 => 0xc, 115 => 0xeb, 116 => 0x80, 217 => 0xc, 344 => 0x9, 372 => 0x4, 417 => 0xd4, 447 => 0xb, 448 => 0x40, 449 => 0x4a, 450 => 0x6f },
	'face3size' => { 373 => 0x4 },
	'face4position' => { 57 => 0xe, 115 => 0x15a, 116 => 0xb4, 217 => 0x10, 344 => 0xd, 372 => 0x6, 417 => 0xe0, 447 => 0x10, 448 => 0x60, 449 => 0x6f, 450 => 0x79 },
	'face4size' => { 373 => 0x6 },
	'face5position' => { 57 => 0x10, 115 => 0x1c9, 116 => 0xe8, 217 => 0x14, 344 => 0x11, 372 => 0x8, 417 => 0xec, 447 => 0x15, 448 => 0x80, 449 => 0x94 },
	'face5size' => { 373 => 0x8 },
	'face6position' => { 57 => 0x12, 115 => 0x238, 116 => 0x11c, 217 => 0x18, 372 => 0xa, 417 => 0xf8, 447 => 0x1a, 448 => 0xa0, 449 => 0xb9 },
	'face6size' => { 373 => 0xa },
	'face7position' => { 57 => 0x14, 115 => 0x2a7, 116 => 0x150, 217 => 0x1c, 372 => 0xc, 417 => 0x104, 447 => 0x1f, 448 => 0xc0, 449 => 0xde },
	'face7size' => { 373 => 0xc },
	'face8position' => { 57 => 0x16, 115 => 0x316, 116 => 0x184, 217 => 0x20, 372 => 0xe, 417 => 0x110, 447 => 0x24, 448 => 0xe0, 449 => 0x103 },
	'face8size' => { 373 => 0xe },
	'face9position' => { 57 => 0x18, 115 => 0x385, 116 => 0x1b8, 217 => 0x24, 372 => 0x10 },
	'face9size' => { 373 => 0x10 },
	'facebalanceorigi' => { 511 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 511 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 511 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 511 => 'FaceBalanceWarmth' },
	'facedetect' => { 388 => 0x76, 427 => 0x100 },
	'facedetectarea' => { 332 => 0x1201 },
	'facedetectframecrop' => { 332 => 0x1207 },
	'facedetectframesize' => { 57 => 0x3, 115 => 0x1, 116 => 0x4, 217 => 0x1, 332 => 0x1203, 388 => 0x77, 417 => 0xb6 },
	'facedetection' => { 442 => 0x30, 459 => 0x19 },
	'faceelementpositions' => { 132 => 0x4203 },
	'faceelementselected' => { 132 => 0x4005 },
	'faceelementtypes' => { 132 => 0x4201 },
	'faceid' => { 513 => 'FaceID' },
	'faceinfounknown' => { 118 => 0x2089 },
	'facename' => { 427 => 0x123 },
	'faceorientation' => { 116 => 0x8 },
	'faceposition' => { 371 => 0x2, 428 => 0x4 },
	'facepositions' => { 132 => 0x4103 },
	'facerecognition' => { 427 => 0x120 },
	'facesdetected' => { 57 => 0x2, 58 => 0x2, 59 => 0x3, 115 => 0x0, 116 => 0x2, 118 => 0x211c, 132 => 0x4100, 217 => 0x3, 332 => 0x1200, 352 => 0x3f, 371 => 0x0, 417 => 0xb5, 428 => 0x0, 447 => 0x0, 450 => 0x3, 462 => 0x30 },
	'facesrecognized' => { 345 => 0x0 },
	'facewidth' => { 58 => 0x1 },
	'fade' => { 454 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 114 => 0x38 },
	'faithfuloutputshadowpoint' => { 114 => 0x39 },
	'faithfulrawcolortone' => { 114 => 0x31 },
	'faithfulrawcontrast' => { 114 => 0x33 },
	'faithfulrawhighlight' => { 114 => 0x79 },
	'faithfulrawhighlightpoint' => { 114 => 0x36 },
	'faithfulrawlinear' => { 114 => 0x34 },
	'faithfulrawsaturation' => { 114 => 0x32 },
	'faithfulrawshadow' => { 114 => 0x82 },
	'faithfulrawshadowpoint' => { 114 => 0x37 },
	'faithfulrawsharpness' => { 114 => 0x35 },
	'faithfulunsharpmaskfineness' => { 114 => 0xac },
	'faithfulunsharpmaskstrength' => { 114 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 114 => 0xae },
	'far' => { 502 => 'Far' },
	'fastresetlinetime' => { 143 => 0x1860 },
	'feedidentifier' => { 531 => 'FeedIdentifier' },
	'femicroadjustment' => { 89 => 0x111 },
	'ffid' => { 521 => 'ffid' },
	'field' => { 535 => 'field' },
	'fieldcount' => { 333 => 0x103f },
	'fieldofview' => { 413 => "FOV\x00" },
	'fifoenonepixeldelay' => { 143 => 0x1901 },
	'filecreatedate' => { 125 => 'FileCreateDate' },
	'filedatarate' => { 546 => 'fileDataRate' },
	'fileformat' => { 100 => 0x0, 137 => 0x14, 430 => [0x22,0x26], 454 => 0xb000 },
	'filegroupid' => { 125 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 353 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 125 => 'FileModifyDate' },
	'filename' => { 125 => 'FileName' },
	'filenameasdelivered' => { 338 => 'FileNameAsDelivered' },
	'filenumber' => { 60 => 0x1, 68 => 0x8, 102 => 0x1817, 119 => 'Canon-FileNumber', 218 => 0x4, 416 => 0x10 },
	'filenumbermemory' => { 186 => 0x1a },
	'filenumbersequence' => { 307 => '12.2', 312 => '3.1', 313 => '4.1', 314 => '4.1', 316 => '11.1', 317 => '4.3', 322 => '5.2', 323 => 0x4e, 324 => 0x48, 325 => 0x48, 326 => 0x48 },
	'filepermissions' => { 125 => 'FilePermissions' },
	'filesource' => { 124 => 0xa300, 132 => 0x8000, 523 => 'FileSource' },
	'fileuserid' => { 125 => 'FileUserID' },
	'fileversion' => { 137 => 0x16 },
	'fillflashautoreduction' => { 87 => 0xe, 88 => 0xe, 95 => 0xa },
	'filllight' => { 517 => 'FillLight', 519 => 'FillLight' },
	'fillorder' => { 124 => 0x10a },
	'filmgraineffect' => { 328 => 0x538 },
	'filmmode' => { 132 => 0x1401, 349 => 0x412, 352 => 0x42 },
	'filmtype' => { 266 => 0x2 },
	'filtereffect' => { 60 => 0xe, 258 => 0x37, 259 => 0x3f, 260 => 0x47, 352 => 0xa1 },
	'filtereffectauto' => { 75 => 0xa0 },
	'filtereffectfaithful' => { 74 => 0x70, 75 => 0x70 },
	'filtereffectlandscape' => { 74 => 0x40, 75 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 74 => 0x88, 75 => 0x88 },
	'filtereffectneutral' => { 74 => 0x58, 75 => 0x58 },
	'filtereffectportrait' => { 74 => 0x28, 75 => 0x28 },
	'filtereffectstandard' => { 74 => 0x10, 75 => 0x10 },
	'filtereffectuserdef1' => { 74 => 0xa0, 75 => 0xb8 },
	'filtereffectuserdef2' => { 74 => 0xb8, 75 => 0xd0 },
	'filtereffectuserdef3' => { 74 => 0xd0, 75 => 0xe8 },
	'finderdisplayduringexposure' => { 88 => 0x1 },
	'finesharpness' => { 388 => 0x70 },
	'finetuneoptcenterweighted' => { 307 => '7.2', 308 => '9.1', 310 => '9.1', 311 => '9.1', 315 => '8.1', 320 => '9.1', 321 => '9.1', 322 => '9.1', 323 => 0x25, 324 => 0x23, 325 => 0x23, 326 => 0x23 },
	'finetuneopthighlightweighted' => { 310 => '46.1', 311 => '46.1', 320 => '46.1', 321 => '46.1', 323 => 0x29, 324 => 0x27, 325 => 0x27, 326 => 0x27 },
	'finetuneoptmatrixmetering' => { 307 => '8.1', 308 => '8.2', 310 => '8.2', 311 => '8.2', 315 => '7.2', 316 => '6.1', 320 => '8.2', 321 => '8.2', 322 => '8.2', 323 => 0x23, 324 => 0x21, 325 => 0x21, 326 => 0x21 },
	'finetuneoptspotmetering' => { 307 => '8.2', 308 => '9.2', 310 => '9.2', 311 => '9.2', 315 => '8.2', 316 => '6.2', 320 => '9.2', 321 => '9.2', 322 => '9.2', 323 => 0x27, 324 => 0x25, 325 => 0x25, 326 => 0x25 },
	'finishexposure' => { 143 => 0xdbd },
	'finishfiletype' => { 143 => 0xdb8 },
	'finishlook' => { 143 => 0xdbc },
	'finishnoise' => { 143 => 0xdba },
	'finishresolution' => { 143 => 0xdb9 },
	'finishsharpening' => { 143 => 0xdbb },
	'firmware' => { 333 => 0x405, 430 => [0x8c,0x17,0x3b], 514 => 'Firmware' },
	'firmware2' => { 430 => 0x57 },
	'firmwaredate' => { 117 => 0x15, 118 => 0x2001, 414 => 0x4, 416 => 0x30 },
	'firmwareid' => { 193 => 0x0 },
	'firmwarename' => { 427 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 68 => 0x1e, 418 => 0x0 },
	'firmwarerevision2' => { 418 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 143 => [0x415,0xce5], 159 => 0x57, 161 => 'FirmwareVersion', 350 => 0x320, 352 => 0x2, 354 => 0x3109, 388 => 0x230, 413 => ['CNFV','FIRM','info'], 415 => 0x18, 416 => 0x2a, 420 => 0x2 },
	'firmwareversions' => { 397 => 0x301 },
	'firstphotodate' => { 505 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 338 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 136 => 0x16, 512 => 'FixtureIdentifier' },
	'flash' => { 119 => 'XMP-Flash', 124 => 0x9209, 157 => 0x22, 187 => 0x1f, 188 => 0x15, 416 => 0x5a, 523 => 'Flash' },
	'flashaction' => { 440 => 0x3e, 441 => 0x3e, 454 => 0x2017, 459 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 440 => 0x4c, 441 => 0x4c, 459 => 0x77 },
	'flashactionexternal' => { 459 => [0x78,0x7c] },
	'flashactivity' => { 36 => 0x1c },
	'flashbatterylevel' => { 47 => 0x249 },
	'flashbias' => { 352 => 0x24 },
	'flashbits' => { 36 => 0x1d },
	'flashburstpriority' => { 323 => 0x101, 324 => 0x111, 325 => 0x111, 326 => 0x129 },
	'flashbuttonfunction' => { 89 => 0x70e },
	'flashchargelevel' => { 333 => 0x1010 },
	'flashcolorfilter' => { 221 => 0x10, 222 => 0x10, 224 => 0x10 },
	'flashcommandermode' => { 219 => '9.1', 220 => '9.1', 221 => '9.1', 222 => '9.1', 224 => '9.1' },
	'flashcompensation' => { 143 => 0x3f3, 219 => 0xa, 220 => 0xa, 221 => 0xa, 222 => 0x27, 223 => 0xa, 224 => 0xa, 514 => 'FlashCompensation' },
	'flashcontrol' => { 440 => 0x23, 441 => 0x1f, 442 => 0x21 },
	'flashcontrolbuilt-in' => { 316 => '16.1', 317 => '23.1', 319 => '23.1', 320 => '24.1' },
	'flashcontrolmode' => { 219 => '9.2', 220 => '9.2', 221 => '9.2', 222 => '9.2', 224 => '9.2', 230 => 0x214, 245 => 0x2d4, 246 => 0x148, 247 => 0x1b8, 248 => 0x1b8, 249 => 0x1a8, 250 => 0x1bc, 251 => 0x1bc, 328 => 0x404 },
	'flashcurtain' => { 352 => 0x48 },
	'flashdefault' => { 189 => 0x42 },
	'flashdevice' => { 333 => 0x1005 },
	'flashdistance' => { 118 => 0x2034 },
	'flashenergy' => { 124 => 0xa20b, 523 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 241 => 0x18 },
	'flashexposurecomp' => { 81 => 0xf, 132 => 0x1011, 164 => 'ExposureComp', 186 => 0x23, 191 => 0x104, 192 => 0x49c1, 241 => 0x12, 328 => 0x401, 333 => 0x1023, 388 => 0x4d, 420 => 0x100b, 430 => [0x3a,0x56], 454 => 0x104 },
	'flashexposurecomp2' => { 287 => 0x4d2 },
	'flashexposurecomp3' => { 221 => 0x1d },
	'flashexposurecomp4' => { 221 => 0x27 },
	'flashexposurecomparea' => { 308 => '38.4', 310 => '38.4', 311 => '38.4', 320 => '38.4', 321 => '38.4', 323 => 0x5d, 324 => 0x59, 325 => 0x59, 326 => 0x59 },
	'flashexposurecompset' => { 189 => 0x10, 360 => 0xe, 440 => 0x14, 441 => 0x12, 442 => 0x23, 459 => 0x1f },
	'flashexposurecompset2' => { 459 => [0x26,0x2c] },
	'flashexposureindicator' => { 189 => 0x54 },
	'flashexposureindicatorlast' => { 189 => 0x56 },
	'flashexposureindicatornext' => { 189 => 0x55 },
	'flashexposurelock' => { 60 => 0x19 },
	'flashfired' => { 145 => 0x5d, 164 => 'Fired', 186 => 0x14, 286 => '590.3', 523 => [\'Flash','FlashFired'] },
	'flashfiring' => { 89 => 0x306, 90 => 0x6, 91 => 0x7, 94 => 0x7 },
	'flashfirmwareversion' => { 329 => 0x1002 },
	'flashfocallength' => { 219 => 0xb, 220 => 0xc, 221 => 0xc, 222 => 0xc, 223 => 0xc, 224 => 0x26 },
	'flashfunction' => { 192 => 0x31, 523 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 219 => 0xe, 220 => 0xf, 221 => 0xf, 222 => 0xf, 223 => 0xf, 224 => 0xf, 230 => 0x21a, 245 => 0x2da, 246 => 0x14e, 249 => 0x1ae, 250 => 0x1c2, 251 => 0x1c2 },
	'flashgroupacompensation' => { 219 => 0x11, 220 => 0x12, 221 => 0x13, 222 => 0x28, 223 => 0x28, 224 => 0x28 },
	'flashgroupacontrolmode' => { 219 => 0xf, 220 => '16.1', 221 => '17.1', 222 => '17.1', 223 => '17.1', 224 => '17.1' },
	'flashgroupaoutput' => { 219 => 0x11, 220 => 0x12, 221 => 0x13, 222 => 0x28, 223 => 0x28, 224 => 0x28 },
	'flashgroupbcompensation' => { 219 => 0x12, 220 => 0x13, 221 => 0x14, 222 => 0x29, 223 => 0x29, 224 => 0x29 },
	'flashgroupbcontrolmode' => { 219 => 0x10, 220 => '17.1', 221 => '18.1', 222 => '18.1', 223 => '18.1', 224 => '18.1' },
	'flashgroupboutput' => { 219 => 0x12, 220 => 0x13, 221 => 0x14, 222 => 0x29, 223 => 0x29, 224 => 0x29 },
	'flashgroupccompensation' => { 220 => 0x14, 221 => 0x15, 222 => 0x2a, 223 => 0x2a, 224 => 0x2a },
	'flashgroupccontrolmode' => { 220 => '17.2', 221 => '18.2', 222 => '18.2', 223 => '18.2', 224 => '18.2' },
	'flashgroupcoutput' => { 220 => 0x14, 221 => 0x15, 222 => 0x2a, 223 => 0x2a, 224 => 0x2a },
	'flashguidenumber' => { 81 => 0xd, 99 => 0x0, 164 => 'GuideNumber' },
	'flashilluminationpattern' => { 224 => 0x25 },
	'flashintensity' => { 117 => [0x19,0x5], 328 => 0x405 },
	'flashlevel' => { 309 => 0x9, 454 => 0xb048 },
	'flashmake' => { 164 => 'Make' },
	'flashmanufacturer' => { 183 => 'FlashManufacturer' },
	'flashmastercompensation' => { 230 => 0x22e, 245 => 0x2ee, 246 => 0x162, 249 => 0x1aa, 250 => 0x1be, 251 => 0x1be },
	'flashmastercontrolmode' => { 230 => 0x22c, 245 => 0x2ec, 246 => 0x160 },
	'flashmasteroutput' => { 230 => 0x232, 245 => 0x2f2, 246 => 0x166 },
	'flashmetering' => { 186 => 0x3f, 189 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 388 => 0x20a },
	'flashmode' => { 117 => 0x4, 143 => 0x3f2, 145 => 0x5c, 156 => 0x27, 164 => 'Mode', 186 => 0x2, 187 => 0x20, 188 => 0x16, 189 => 0xf, 241 => 0x87, 328 => 0x400, 333 => 0x1004, 388 => 0xc, 395 => 0x4, 419 => 0x20, 420 => 0x100a, 429 => 0x225, 440 => 0x13, 441 => 0x7f, 442 => 0x20, 459 => 0x10, 463 => 0x1138, 464 => 0x1138, 465 => 0x1114, 466 => 0x1190, 467 => 0x116c, 468 => 0x1024, 469 => 0x21c, 470 => 0x21c, 471 => 0x211, 523 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 251 => 0x80e },
	'flashmodebuttonplaybackmode' => { 251 => 0x818 },
	'flashmodel' => { 164 => 'Model', 183 => 'FlashModel', 329 => 0x1001 },
	'flashoptions' => { 368 => 0x2 },
	'flashoptions2' => { 368 => 0x10 },
	'flashoutput' => { 47 => 0x248, 81 => 0x21, 219 => 0xa, 220 => 0xa, 221 => 0xa, 222 => 0x27, 224 => 0x21, 230 => 0x21e, 245 => 0x2de, 246 => 0x152, 249 => 0x1b2, 250 => 0x1c6, 251 => 0x1c6 },
	'flashpixversion' => { 124 => 0xa000, 523 => 'FlashpixVersion' },
	'flashredeyemode' => { 523 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 230 => 0x228, 245 => 0x2e8, 246 => 0x15c, 249 => 0x1bc, 328 => 0x403 },
	'flashreturn' => { 523 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 164 => 'SerialNumber', 329 => 0x1003 },
	'flashsetting' => { 241 => 0x8 },
	'flashshutterspeed' => { 307 => '20.2', 308 => '23.2', 310 => '23.2', 311 => '23.2', 316 => '15.2', 317 => '22.2', 318 => '7.2', 319 => '22.2', 320 => '23.2', 321 => '23.2', 322 => '23.1', 323 => 0x5b, 324 => 0x57, 325 => 0x57, 326 => 0x57 },
	'flashsource' => { 219 => 0x4, 220 => 0x4, 221 => 0x4, 222 => 0x4, 223 => 0x4, 224 => 0x4 },
	'flashstatus' => { 375 => 0x0, 459 => [0x82,0x86], 473 => 0x31, 474 => 0x39, 475 => 0x39 },
	'flashstatusbuilt-in' => { 442 => [0x87,0x287] },
	'flashstatusexternal' => { 442 => [0x88,0x288] },
	'flashsyncspeed' => { 307 => '20.1', 308 => '23.1', 310 => '23.1', 311 => '23.1', 316 => '15.1', 317 => '22.1', 319 => '22.1', 320 => '23.1', 321 => '23.1', 323 => 0x57, 324 => 0x53, 325 => 0x53, 326 => 0x53 },
	'flashsyncspeedav' => { 87 => 0x3, 89 => 0x10f, 90 => 0x2, 91 => 0x3, 92 => 0x2, 93 => 0x2, 94 => 0x3, 95 => 0x6 },
	'flashthreshold' => { 99 => 0x1 },
	'flashtype' => { 164 => 'Type', 189 => 0x59, 241 => 0x9, 329 => 0x1000 },
	'flashwarning' => { 317 => '30.1', 318 => '7.1', 322 => '31.1', 352 => 0x62 },
	'flashwirelessoption' => { 230 => 0x234, 245 => 0x2e6, 246 => 0x15a, 249 => 0x1c8 },
	'flexiblespotposition' => { 454 => 0x201d },
	'flickadvancedirection' => { 324 => 0x25f, 325 => 0x25f, 326 => 0x277 },
	'flickerreduce' => { 429 => 0x218 },
	'flickerreduction' => { 132 => 0x1446, 270 => 0x7 },
	'flickerreductionindicator' => { 265 => 0x532 },
	'flickerreductionshooting' => { 245 => 0x2d0, 247 => 0x1b4, 248 => 0x1b4, 249 => 0x1a4, 250 => 0x1b8, 251 => 0x1b8 },
	'flightpitchdegree' => { 121 => 'FlightPitchDegree' },
	'flightrolldegree' => { 121 => 'FlightRollDegree' },
	'flightxspeed' => { 121 => 'FlightXSpeed' },
	'flightyawdegree' => { 121 => 'FlightYawDegree' },
	'flightyspeed' => { 121 => 'FlightYSpeed' },
	'flightzspeed' => { 121 => 'FlightZSpeed' },
	'fliphorizontal' => { 300 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 81 => 0x15, 124 => 0x829d, 142 => 0xfd04, 145 => 0x1e, 147 => 0xfa23, 149 => 0xf103, 152 => 0x13, 154 => 0x3c, 156 => 0x1c, 157 => 0x18, 159 => 0xc, 168 => 'FNumber', 186 => 0xa, 187 => 0x36, 188 => 0x47, 189 => 0x9, 192 => 0x49c7, 239 => 0x38, 351 => 0x35a, 388 => 0x13, 427 => 0xa019, 430 => [0x31,0x49], 440 => 0x1, 441 => 0x1, 459 => [0x20,0x22,0x26], 523 => 'FNumber' },
	'focaldistance' => { 503 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 62 => 0x1, 65 => 0x7, 118 => 0x1d, 124 => 0x920a, 152 => 0x1d, 168 => 'FocalLength', 186 => 0x12, 234 => 0xa, 235 => 0xb, 239 => [0xc,0x3c], 346 => 0x1, 388 => 0x1d, 397 => 0x403, 420 => 0x1500, 439 => 0xe, 467 => 0x1278, 468 => 0x1134, 469 => 0x32c, 470 => 0x32c, 471 => 0x30a, 523 => 'FocalLength' },
	'focallength2' => { 459 => [0x23,0x25,0x29] },
	'focallength35mm' => { 342 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 124 => 0xa405, 427 => 0xa01a, 523 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 439 => 0x10 },
	'focalplaneafpointarea' => { 472 => 0x2 },
	'focalplaneafpointlocation1' => { 472 => 0x6 },
	'focalplaneafpointlocation10' => { 472 => 0x2a },
	'focalplaneafpointlocation11' => { 472 => 0x2e },
	'focalplaneafpointlocation12' => { 472 => 0x32 },
	'focalplaneafpointlocation13' => { 472 => 0x36 },
	'focalplaneafpointlocation14' => { 472 => 0x3a },
	'focalplaneafpointlocation15' => { 472 => 0x3e },
	'focalplaneafpointlocation2' => { 472 => 0xa },
	'focalplaneafpointlocation3' => { 472 => 0xe },
	'focalplaneafpointlocation4' => { 472 => 0x12 },
	'focalplaneafpointlocation5' => { 472 => 0x16 },
	'focalplaneafpointlocation6' => { 472 => 0x1a },
	'focalplaneafpointlocation7' => { 472 => 0x1e },
	'focalplaneafpointlocation8' => { 472 => 0x22 },
	'focalplaneafpointlocation9' => { 472 => 0x26 },
	'focalplaneafpointsused' => { 472 => 0x1 },
	'focalplanediagonal' => { 329 => 0x103, 333 => 0x205 },
	'focalplaneresolutionunit' => { 124 => 0xa210, 523 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 124 => 0xa20e, 523 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 62 => 0x2 },
	'focalplanexunknown' => { 62 => 0x2 },
	'focalplaneyresolution' => { 124 => 0xa20f, 523 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 62 => 0x3 },
	'focalplaneyunknown' => { 62 => 0x3 },
	'focalpointx' => { 503 => 'FocalPointX' },
	'focalpointy' => { 503 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 62 => 0x0 },
	'focalunits' => { 36 => 0x19 },
	'focus' => { 289 => 0x8 },
	'focusarea' => { 186 => 0x31 },
	'focusareaselection' => { 318 => '15.2' },
	'focusbracket' => { 352 => 0xbd },
	'focusbracketstepsize' => { 328 => 0x308 },
	'focuscontinuous' => { 36 => 0x20 },
	'focusdisplayaiservoandmf' => { 89 => 0x515 },
	'focusdistance' => { 168 => 'FocusDistance', 186 => 0x13, 192 => 0x49bb, 234 => 0x9, 235 => 0xa, 239 => [0xb,0x4e], 331 => 0x305, 346 => 0x0, 350 => 0x304, 351 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 60 => 0x15, 81 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 239 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 60 => 0x14, 81 => 0x13 },
	'focusholdbutton' => { 189 => 0x44 },
	'focusinfoversion' => { 331 => 0x0 },
	'focusingscreen' => { 88 => 0x0, 89 => 0x80b, 94 => 0x0 },
	'focuslocation' => { 454 => 0x2027 },
	'focuslocation2' => { 454 => 0x204a },
	'focuslocked' => { 185 => 0x14 },
	'focusmode' => { 36 => 0x7, 117 => 0x3, 118 => [0x3003,0xd], 132 => 0x1021, 143 => 0x3f5, 145 => 0x38, 161 => 'FocusMode', 186 => 0x30, 188 => 0xe, 189 => 0xc, 241 => 0x7, 328 => 0x301, 333 => 0x100b, 352 => 0x7, 388 => 0xd, 395 => 0x3, 420 => 0x1006, 433 => [0xb,0x5], 439 => [0x15,0x1d], 440 => 0x4d, 441 => 0x4d, 454 => [0xb042,0xb04e,0x201b], 459 => 0x13, 480 => 0x16 },
	'focusmode2' => { 131 => '0.1', 368 => '3.1', 459 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 309 => '10.1', 437 => 0x14, 438 => 0x15, 440 => 0x10, 441 => 0xf, 442 => 0x6 },
	'focusmodeswitch' => { 189 => 0x58, 440 => 0x2e },
	'focuspeakingdisplay' => { 323 => 0x22f, 324 => 0x235, 325 => 0x235, 326 => 0x24d },
	'focuspeakinghighlightcolor' => { 323 => 0x53, 324 => 0x4b, 325 => 0x4b, 326 => 0x4b },
	'focuspeakinglevel' => { 323 => 0x51, 324 => 0x49, 325 => 0x49, 326 => 0x49 },
	'focuspixel' => { 132 => 0x1023 },
	'focuspointlock' => { 324 => 0x1d3, 325 => 0x1d3, 326 => 0x1eb },
	'focuspointpersistence' => { 323 => 0xf5, 324 => 0x105, 325 => 0x105, 326 => 0x11b },
	'focuspointwrap' => { 307 => '2.2', 308 => '2.2', 310 => '2.1', 311 => '2.1', 315 => '1.1', 316 => '2.2', 317 => '1.1', 320 => '2.2', 321 => '2.1', 322 => '2.5', 323 => 0x16, 324 => 0x16, 325 => 0x16, 326 => 0x16 },
	'focusposition' => { 1 => 0x2f, 234 => 0x8, 235 => 0x8, 388 => 0x10, 451 => 0x9bb },
	'focusposition2' => { 459 => [0x29,0x2b,0x2f], 480 => 0x2d, 483 => 0x20 },
	'focuspositionhorizontal' => { 198 => 0x2f, 199 => 0x43 },
	'focuspositionvertical' => { 198 => 0x31, 199 => 0x45 },
	'focusprocess' => { 328 => 0x302 },
	'focusrange' => { 36 => 0x12, 333 => 0x100a },
	'focusrangeindex' => { 378 => '3.1' },
	'focusresult' => { 199 => 0x4a },
	'focusringrotation' => { 89 => 0x713 },
	'focussetting' => { 430 => 0x6 },
	'focusshiftautoreset' => { 250 => 0x6da, 251 => 0x748 },
	'focusshiftexposurelock' => { 230 => 0x1b4, 245 => 0x224, 246 => 0xe8, 247 => 0x100, 248 => 0x100, 249 => 0xf4, 250 => 0x104, 251 => 0x104 },
	'focusshiftinterval' => { 230 => 0x1b0, 245 => 0x220, 246 => 0xe4, 247 => 0xfc, 248 => 0xfc, 249 => 0xf0, 250 => 0x100, 251 => 0x100 },
	'focusshiftnumbershots' => { 230 => 0x1a8, 245 => 0x218, 246 => 0xdc, 247 => 0xf4, 248 => 0xf4, 249 => 0xe8, 250 => 0xf8, 251 => 0xf8 },
	'focusshiftshooting' => { 268 => 0x20 },
	'focusshiftstepwidth' => { 230 => 0x1ac, 245 => 0x21c, 246 => 0xe0, 247 => 0xf8, 248 => 0xf8, 249 => 0xec, 250 => 0xfc, 251 => 0xfc },
	'focusstatus' => { 439 => 0x19, 440 => 0x53, 441 => 0x53 },
	'focusstepcount' => { 331 => 0x301, 333 => 0x100e },
	'focusstepinfinity' => { 331 => 0x303, 333 => 0x103b },
	'focusstepnear' => { 331 => 0x304, 333 => 0x103c },
	'focusstepsfrominfinity' => { 239 => 0x58 },
	'focustrackinglockon' => { 307 => ['1.5','4.1'], 308 => '1.4', 315 => '0.4', 316 => '3.1', 317 => '0.4', 320 => '1.4' },
	'focuswarning' => { 132 => 0x1301 },
	'foldername' => { 186 => 0x27 },
	'foldernumber' => { 440 => 0x9a, 442 => [0x402,0x114,0x316] },
	'fontcomposite' => { 551 => [\'Fonts','FontsComposite'] },
	'fontface' => { 551 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 551 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 551 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 551 => [\'Fonts','FontsFontName'] },
	'fonts' => { 551 => 'Fonts' },
	'fonttype' => { 551 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 551 => [\'Fonts','FontsVersionString'] },
	'for' => { 404 => 'For' },
	'forcewrite' => { 125 => 'ForceWrite' },
	'format' => { 413 => "\xa9fmt", 502 => 'Format', 520 => 'format', 544 => 'Format' },
	'forwardlock' => { 541 => 'forwardlock' },
	'forwardmatrix1' => { 124 => 0xc714 },
	'forwardmatrix2' => { 124 => 0xc715 },
	'forwardmatrix3' => { 124 => 0xcd34 },
	'fossilspecimen' => { 123 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 123 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 71 => [0x2,0x4] },
	'frameheight' => { 132 => 0x3822 },
	'framenum' => { 399 => 0xd7 },
	'framenumber' => { 132 => 0x8003, 192 => 0x3c, 388 => 0x29 },
	'framerate' => { 71 => [0x1,0x6], 124 => 0xc764, 132 => 0x3820 },
	'framereadouttime' => { 407 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 132 => 0x3821 },
	'framing' => { 535 => 'framing' },
	'freebytes' => { 102 => 0x1 },
	'freememorycardimages' => { 187 => [0x37,0x54], 188 => [0x2d,0x4a], 189 => 0x32 },
	'fujiflashmode' => { 132 => 0x1010 },
	'fujimodel' => { 132 => 0x1447 },
	'fujimodel2' => { 132 => 0x1448 },
	'fullhdhighspeedrec' => { 132 => 0x3824 },
	'fullimagesize' => { 454 => 0xb02b },
	'fullpanoheightpixels' => { 505 => 'FullPanoHeightPixels', 506 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 505 => 'FullPanoWidthPixels', 506 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 420 => 0x100d },
	'fullsizeimage' => { 167 => 'data' },
	'fullsizeimagename' => { 167 => '1Name' },
	'fullsizeimagetype' => { 167 => '0Type' },
	'func1button' => { 310 => '14.1', 311 => '14.1', 321 => '14.1', 323 => 0x67, 324 => 0x63, 325 => 0x63, 326 => 0x63 },
	'func1buttonplaybackmode' => { 323 => 0x19f, 324 => 0x1a5, 325 => 0x1a5, 326 => 0x1bd },
	'func1buttonplusdials' => { 310 => '42.1', 311 => '42.1', 321 => '42.1' },
	'func2button' => { 310 => '80.1', 311 => '80.1', 321 => '80.1', 323 => 0x77, 324 => 0x73, 325 => 0x73, 326 => 0x73 },
	'func2buttonplaybackmode' => { 323 => 0x1a1, 324 => 0x1a7, 325 => 0x1a7, 326 => 0x1bf },
	'func2buttonplusdials' => { 310 => '81.1' },
	'func3button' => { 310 => '83.1', 325 => 0x119, 326 => 0x131 },
	'func3buttonplaybackmode' => { 325 => 0x1a9, 326 => 0x1c1 },
	'func4button' => { 325 => 0x175, 326 => 0x18d },
	'func4buttonplaybackmode' => { 325 => 0x1af, 326 => 0x1c7 },
	'funcbutton' => { 307 => ['14.1','15.1'], 308 => '14.1', 316 => '28.1', 317 => '13.1', 320 => '14.1', 322 => '14.1' },
	'funcbuttonplusdials' => { 307 => ['14.2','15.2'], 308 => '14.2', 316 => '31.1', 320 => '42.1' },
	'functionbutton' => { 314 => '13.1', 318 => '5.2' },
	'gainbase' => { 332 => 0x610 },
	'gaincontrol' => { 124 => 0xa407, 523 => 'GainControl' },
	'gainmapmax' => { 528 => 'GainMapMax' },
	'gainmapmin' => { 528 => 'GainMapMin' },
	'gamma' => { 124 => 0xa500, 143 => 0x8fe, 339 => 'gAMA', 357 => 0x11c, 524 => 'Gamma', 528 => 'Gamma' },
	'gammablackpoint' => { 110 => 0xc },
	'gammacolortone' => { 110 => 0x3 },
	'gammacompensatedvalue' => { 138 => 0x91 },
	'gammacontrast' => { 110 => 0x2 },
	'gammacurveoutputrange' => { 110 => 0xf },
	'gammahighlight' => { 110 => 0xa },
	'gammalinear' => { 108 => 0x20200 },
	'gammamidpoint' => { 110 => 0xe },
	'gammasaturation' => { 110 => 0x4 },
	'gammashadow' => { 110 => 0x9 },
	'gammasharpnessstrength' => { 110 => 0x8 },
	'gammaunsharpmaskfineness' => { 110 => 0x6 },
	'gammaunsharpmaskstrength' => { 110 => 0x5 },
	'gammaunsharpmaskthreshold' => { 110 => 0x7 },
	'gammawhitepoint' => { 110 => 0xd },
	'garminsettings' => { 413 => 'pmcc' },
	'garminsoftware' => { 413 => 'uuid' },
	'gdalmetadata' => { 124 => 0xa480 },
	'gdalnodata' => { 124 => 0xa481 },
	'geimagesize' => { 132 => 0x1304 },
	'gemake' => { 134 => 0x300 },
	'gemodel' => { 134 => 0x207 },
	'genre' => { 405 => ['gnre',"\xa9gen"], 407 => 'genre', 413 => ['gnre',"\xa9gen"], 531 => 'Genre', 536 => 'genre', 546 => 'genre' },
	'genrecvid' => { 531 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 531 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 531 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 531 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 405 => 'geID' },
	'geography' => { 537 => 'geography' },
	'geolocate' => { 125 => 'Geolocate' },
	'geologicalcontext' => { 123 => 'GeologicalContext' },
	'geologicalcontextbed' => { 123 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 123 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 123 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 123 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 123 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 125 => 'Geosync' },
	'geotag' => { 125 => 'Geotag' },
	'geotiffasciiparams' => { 124 => 0x87b1 },
	'geotiffdirectory' => { 124 => 0x87af },
	'geotiffdoubleparams' => { 124 => 0x87b0 },
	'geotime' => { 125 => 'Geotime' },
	'giftftppriority' => { 507 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 121 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 121 => 'GimbalReverse' },
	'gimbalrolldegree' => { 121 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 121 => 'GimbalYawDegree' },
	'globalaltitude' => { 402 => 0x419 },
	'globalangle' => { 402 => 0x40d },
	'good' => { 546 => 'good' },
	'googlehostheader' => { 405 => 'gshh' },
	'googlepingmessage' => { 405 => 'gspm' },
	'googlepingurl' => { 405 => 'gspu' },
	'googleplusuploadcode' => { 124 => 0x9009 },
	'googlesourcedata' => { 405 => 'gssd' },
	'googlestarttime' => { 405 => 'gsst' },
	'googletrackduration' => { 405 => 'gstd' },
	'goprotype' => { 413 => 'GoPr' },
	'gpsaltitude' => { 135 => 0x6, 165 => 'Altitude', 523 => 'GPSAltitude' },
	'gpsaltituderef' => { 135 => 0x5, 523 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 135 => 0x1c, 523 => 'GPSAreaInformation' },
	'gpscoordinates' => { 405 => "\xa9xyz", 407 => 'location.ISO6709', 413 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 135 => 0x1d },
	'gpsdatetime' => { 165 => 'DateTime', 523 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 135 => 0x18, 165 => 'Bearing', 523 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 135 => 0x17, 523 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 135 => 0x1a, 165 => 'Distance', 523 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 135 => 0x19, 523 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 135 => 0x14, 523 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 135 => 0x13 },
	'gpsdestlongitude' => { 135 => 0x16, 523 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 135 => 0x15 },
	'gpsdifferential' => { 135 => 0x1e, 165 => 'Differential', 523 => 'GPSDifferential' },
	'gpsdop' => { 135 => 0xb, 523 => 'GPSDOP' },
	'gpshpositioningerror' => { 135 => 0x1f, 523 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 135 => 0x11, 523 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 135 => 0x10, 523 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 119 => 'GPS-GPSLatitude', 121 => 'GpsLatitude', 135 => 0x2, 165 => 'Latitude', 523 => 'GPSLatitude' },
	'gpslatituderef' => { 135 => 0x1 },
	'gpslongitude' => { 119 => 'GPS-GPSLongitude', 121 => 'GpsLongitude', 135 => 0x4, 165 => 'Longitude', 523 => 'GPSLongitude' },
	'gpslongituderef' => { 135 => 0x3 },
	'gpslongtitude' => { 121 => 'GpsLongtitude' },
	'gpsmapdatum' => { 135 => 0x12, 165 => 'Datum', 523 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 135 => 0xa, 165 => 'MeasureMode', 523 => 'GPSMeasureMode' },
	'gpsposition' => { 119 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 135 => 0x1b, 523 => 'GPSProcessingMethod' },
	'gpssatellites' => { 135 => 0x8, 165 => 'Satellites', 523 => 'GPSSatellites' },
	'gpsspeed' => { 135 => 0xd, 165 => 'Speed', 523 => 'GPSSpeed' },
	'gpsspeedref' => { 135 => 0xc, 523 => 'GPSSpeedRef' },
	'gpsstatus' => { 135 => 0x9, 523 => 'GPSStatus' },
	'gpsstring' => { 143 => 0x402 },
	'gpstimestamp' => { 135 => 0x7 },
	'gpstrack' => { 135 => 0xf, 165 => 'Heading', 523 => 'GPSTrack' },
	'gpstrackref' => { 135 => 0xe, 523 => 'GPSTrackRef' },
	'gpsversionid' => { 135 => 0x0, 523 => 'GPSVersionID' },
	'gradation' => { 328 => 0x50f },
	'gradientbasedcorractive' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 517 => 'GradientBasedCorrections', 519 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 517 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 519 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 517 => 'GrainAmount', 519 => 'GrainAmount' },
	'graineffectroughness' => { 132 => 0x1047 },
	'graineffectsize' => { 132 => 0x104c },
	'grainfrequency' => { 517 => 'GrainFrequency', 519 => 'GrainFrequency' },
	'grainseed' => { 517 => 'GrainSeed', 519 => 'GrainSeed' },
	'grainsize' => { 517 => 'GrainSize', 519 => 'GrainSize' },
	'graymixeraqua' => { 517 => 'GrayMixerAqua', 519 => 'GrayMixerAqua' },
	'graymixerblue' => { 517 => 'GrayMixerBlue', 519 => 'GrayMixerBlue' },
	'graymixergreen' => { 517 => 'GrayMixerGreen', 519 => 'GrayMixerGreen' },
	'graymixermagenta' => { 517 => 'GrayMixerMagenta', 519 => 'GrayMixerMagenta' },
	'graymixerorange' => { 517 => 'GrayMixerOrange', 519 => 'GrayMixerOrange' },
	'graymixerpurple' => { 517 => 'GrayMixerPurple', 519 => 'GrayMixerPurple' },
	'graymixerred' => { 517 => 'GrayMixerRed', 519 => 'GrayMixerRed' },
	'graymixeryellow' => { 517 => 'GrayMixerYellow', 519 => 'GrayMixerYellow' },
	'graypoint' => { 491 => 0x8021 },
	'grayresponseunit' => { 124 => 0x122 },
	'greencurvelimits' => { 113 => 0x1c4 },
	'greencurvepoints' => { 112 => 0x53, 113 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 108 => 0x20913 },
	'greenhue' => { 517 => 'GreenHue', 519 => 'GreenHue' },
	'greensaturation' => { 517 => 'GreenSaturation', 519 => 'GreenSaturation' },
	'griddisplay' => { 307 => '13.3', 308 => '4.3', 310 => '4.2', 311 => '4.2', 312 => '2.2', 316 => '10.5', 317 => '3.4', 318 => '6.1', 320 => '4.4', 321 => '4.2', 322 => '4.2' },
	'gripbatteryadload' => { 366 => 0x5 },
	'gripbatteryadnoload' => { 366 => 0x4 },
	'gripbatterypercent' => { 366 => 0x11 },
	'gripbatterystate' => { 366 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 366 => 0x12 },
	'group' => { 517 => 'Group', 519 => 'Group' },
	'groupareaafillumination' => { 308 => '46.4', 311 => '47.4', 320 => '47.4' },
	'grouping' => { 405 => ['grup',"\xa9grp"], 413 => "\xa9grp" },
	'guid' => { 405 => 'GUID' },
	'h2resetblackpixels' => { 143 => 0x18a6 },
	'h3resetblackcolumns' => { 143 => 0x18ce },
	'h3resetblackpixels' => { 143 => 0x18b0 },
	'halftonehints' => { 124 => 0x141 },
	'hardlink' => { 125 => 'HardLink' },
	'hasalternative' => { 536 => 'hasAlternative' },
	'hascorrection' => { 536 => 'hasCorrection' },
	'hascorrectiona-lang' => { 536 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 536 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 536 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 517 => 'HasCrop', 519 => 'HasCrop' },
	'hasextendedxmp' => { 548 => 'HasExtendedXMP' },
	'hassettings' => { 517 => 'HasSettings', 519 => 'HasSettings' },
	'hastranslation' => { 536 => 'hasTranslation' },
	'hasvisibleoverprint' => { 551 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 551 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 246 => 0x35a },
	'hdmioutputresolution' => { 247 => 0x710, 248 => 0x720, 249 => 0x610, 250 => 0x640, 251 => 0x6a8 },
	'hdmiviewassist' => { 325 => 0x20f, 326 => 0x227 },
	'hdr' => { 63 => 0x1, 226 => 0x4, 227 => 0x4, 245 => 0x354, 247 => 0x23a, 248 => 0x23a, 251 => 0x23a, 352 => 0x9e, 388 => 0x85, 454 => 0x200a },
	'hdrcapacitymax' => { 528 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 528 => 'HDRCapacityMin' },
	'hdreditmode' => { 517 => 'HDREditMode', 519 => 'HDREditMode' },
	'hdreffect' => { 63 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 226 => 0x5, 227 => 0x5, 245 => 0x360, 247 => 0x246, 248 => 0x246, 251 => 0x246, 442 => 0x2e, 459 => 0x17 },
	'hdrlevel2' => { 226 => 0x7 },
	'hdrplusmakernote' => { 499 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 499 => 'hdrp_makernote' },
	'hdrsetting' => { 442 => 0x2d, 459 => 0x16, 463 => 0x1148, 464 => 0x1148, 465 => 0x1124, 466 => 0x11a0, 467 => 0x117c, 468 => 0x1034, 469 => 0x22c, 470 => 0x22c, 471 => 0x21f },
	'hdrsmoothing' => { 226 => 0x6 },
	'hdvideo' => { 405 => 'hdvd' },
	'headline' => { 136 => 0x69, 531 => 'Headline', 534 => 'Headline' },
	'hiddendatalength' => { 452 => 0x1 },
	'hiddendataoffset' => { 452 => 0x0 },
	'hierarchicalkeywords' => { 176 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 176 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 176 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 176 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 176 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 176 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 176 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 509 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 123 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 245 => 0x16c, 247 => 0x48, 248 => 0x48, 250 => 0x48, 251 => 0x48 },
	'highfrequencyflickerreduction' => { 245 => 0x386, 247 => 0x27c, 248 => 0x27c, 250 => 0x27c, 251 => 0x27c },
	'highisomultiplierblue' => { 357 => 0x1a },
	'highisomultipliergreen' => { 357 => 0x19 },
	'highisomultiplierred' => { 357 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 66 => 0x5, 89 => 0x202, 241 => 0xb1, 388 => 0x71, 440 => 0x2c, 441 => 0x26, 442 => 0x26, 454 => 0x2009, 459 => 0x12, 486 => 0x42 },
	'highisonoisereduction2' => { 454 => 0xb050 },
	'highlight' => { 430 => 0xf },
	'highlight2012' => { 517 => 'Highlight2012', 519 => 'Highlight2012' },
	'highlightadj' => { 108 => 0x2030c },
	'highlightcolordistortreduct' => { 491 => 0x8026 },
	'highlightlinearitylimit' => { 427 => 0xa025 },
	'highlightprotection' => { 299 => 0x6 },
	'highlightrecovery' => { 517 => 'HighlightRecovery', 519 => 'HighlightRecovery' },
	'highlights' => { 454 => 0x2033, 511 => 'Highlights' },
	'highlights2012' => { 517 => 'Highlights2012', 519 => 'Highlights2012' },
	'highlightsadj' => { 491 => 0x9019 },
	'highlightshadow' => { 352 => 0xad },
	'highlighttone' => { 132 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 66 => 0x3, 89 => 0x203 },
	'highlightwarning' => { 352 => 0x8002 },
	'highlowkeyadj' => { 388 => 0x6c },
	'highspeedsync' => { 189 => 0x5, 323 => 0x59, 324 => 0x55, 325 => 0x55, 326 => 0x55, 440 => 0x2, 441 => 0x2 },
	'hintversion' => { 413 => 'hinv' },
	'histogramxml' => { 300 => 0x83a1a25 },
	'history' => { 534 => 'History', 547 => 'History' },
	'historyaction' => { 547 => [\'History','HistoryAction'] },
	'historychanged' => { 547 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 547 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 547 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 547 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 547 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 143 => 0xc88 },
	'holefilldeltathreshold' => { 143 => 0xc7e },
	'hometowncity' => { 118 => 0x3006, 388 => 0x23, 394 => 0x2 },
	'hometowncitycode' => { 395 => 0x1000 },
	'hometowndst' => { 388 => 0x25, 394 => '0.2' },
	'hostcomputer' => { 124 => 0x13c },
	'hostsoftwarerendering' => { 143 => 0xce7 },
	'hue' => { 194 => 0x3b, 259 => 0x3d, 260 => 0x45, 388 => 0x67 },
	'hueadj' => { 303 => 0x2f, 491 => 0x8019 },
	'hueadjust' => { 420 => 0x1016 },
	'hueadjustment' => { 187 => 0x4a, 188 => 0x40, 241 => 0x92, 258 => 0x36 },
	'hueadjustmentaqua' => { 517 => 'HueAdjustmentAqua', 519 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 517 => 'HueAdjustmentBlue', 519 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 517 => 'HueAdjustmentGreen', 519 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 517 => 'HueAdjustmentMagenta', 519 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 517 => 'HueAdjustmentOrange', 519 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 517 => 'HueAdjustmentPurple', 519 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 517 => 'HueAdjustmentRed', 519 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 517 => 'HueAdjustmentYellow', 519 => 'HueAdjustmentYellow' },
	'huesetting' => { 336 => 0x1011 },
	'humanobservation' => { 123 => 'HumanObservation' },
	'humanobservationday' => { 123 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 123 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 123 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 123 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 123 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 123 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 123 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 123 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 123 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 123 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 123 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 123 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 123 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 123 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 123 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 123 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 123 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 123 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 123 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 123 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 124 => 0x9401, 524 => 'Humidity' },
	'icc_profile' => { 125 => 'ICC_Profile' },
	'iccprofilename' => { 534 => 'ICCProfile' },
	'iconuri' => { 413 => 'icnu' },
	'idccreativestyle' => { 491 => 0x8000 },
	'idcpreviewlength' => { 491 => 0x202 },
	'idcpreviewstart' => { 491 => 0x201 },
	'identification' => { 123 => 'Identification' },
	'identificationid' => { 123 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 123 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 123 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 123 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 123 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 123 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 123 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 520 => 'identifier', 544 => 'Identifier' },
	'ifcameramodel' => { 143 => 0x9c8 },
	'illuminantdata1' => { 124 => 0xcd35 },
	'illuminantdata2' => { 124 => 0xcd36 },
	'illuminantdata3' => { 124 => 0xcd37 },
	'illumination' => { 318 => '0.5', 415 => 0x48 },
	'imageabsolutex' => { 143 => 0x3fe },
	'imageabsolutey' => { 143 => 0x3ff },
	'imageadjustment' => { 241 => 0x80, 289 => 0x5 },
	'imagealterationconstraints' => { 338 => 'ImageAlterationConstraints' },
	'imagearea' => { 231 => 0x2b, 267 => 0x2b, 275 => 0x10, 278 => 0x10 },
	'imageareaoffset' => { 388 => 0x38 },
	'imageauthentication' => { 241 => 0x20 },
	'imageboundary' => { 241 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 132 => 0x1438, 241 => 0xa5, 457 => 0x11b },
	'imagecreator' => { 338 => 'ImageCreator' },
	'imagecreatorid' => { 338 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 338 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 338 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 143 => 0x41f },
	'imagecropy' => { 143 => 0x420 },
	'imagedata' => { 504 => 'Data' },
	'imagedatasize' => { 241 => 0xa2 },
	'imagedescription' => { 124 => 0x10e, 542 => 'ImageDescription' },
	'imageduplicationconstraints' => { 338 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 300 => 0xfe443a45 },
	'imageeditcount' => { 388 => 0x41 },
	'imageediting' => { 388 => 0x32 },
	'imageeditingsoftware' => { 124 => 0xa43b, 524 => 'ImageEditingSoftware' },
	'imageeditor' => { 124 => 0xa438, 524 => 'ImageEditor' },
	'imageeffects' => { 420 => 0x1010 },
	'imagefileconstraints' => { 338 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 338 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 338 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 132 => 0x1436 },
	'imageheight' => { 124 => 0x101, 193 => 0xc, 397 => 0x10d, 502 => 'ImageHeight', 542 => 'ImageLength' },
	'imagehistory' => { 124 => 0x9213, 522 => 'ImageHistory' },
	'imageidnumber' => { 347 => 0x340 },
	'imagemimetype' => { 504 => 'Mime' },
	'imagenumber' => { 124 => 0x9211, 161 => 'ImageNumber', 187 => 0xae, 188 => 0x5e, 397 => 0x113, 440 => 0x9b, 442 => [0x400,'276.1',0x314], 514 => 'ImageNumber' },
	'imagenumber2' => { 188 => 0x62 },
	'imageoptimization' => { 241 => 0xa9 },
	'imageorientation' => { 136 => 0x83 },
	'imageprocessing' => { 241 => 0x1a },
	'imageprocessingfiledatecreated' => { 143 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 143 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 332 => 0x0 },
	'imagequality' => { 161 => 'ImageQuality', 277 => '723.2', 278 => '732.2', 286 => '708.1', 352 => 0x1 },
	'imagequality2' => { 328 => 0x603 },
	'imagerank' => { 507 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 143 => 0x600 },
	'imagerboardversion' => { 143 => 0x439 },
	'imagercols' => { 143 => 0x17d4 },
	'imageref' => { 529 => 'ImageRef' },
	'imageregion' => { 531 => 'ImageRegion' },
	'imageregionboundary' => { 531 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 531 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 531 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 531 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 531 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 531 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 531 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 531 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 531 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 531 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 143 => 0x944 },
	'imageresolutionjpg' => { 143 => 0x945 },
	'imagereview' => { 309 => '0.4', 318 => '0.4' },
	'imagereviewmonitorofftime' => { 308 => '21.1', 310 => '21.1', 311 => '21.1', 315 => '20.1', 320 => '21.1', 321 => '21.1', 323 => 0x3b, 324 => 0x39, 325 => 0x39, 326 => 0x39 },
	'imagereviewtime' => { 307 => '25.1', 309 => '2.1', 312 => '19.1', 313 => '20.1', 314 => '20.1', 316 => '9.2', 317 => '20.1', 322 => '21.2' },
	'imagerfiledatecreated' => { 143 => 0x9c5 },
	'imagerfileproductionlevel' => { 143 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 143 => 0x9c7 },
	'imagerotated' => { 156 => 0x2a },
	'imagerpowerondelaymsec' => { 143 => 0x5fd },
	'imagerrows' => { 143 => 0x17de },
	'imagesegmentlines' => { 143 => 0x184d },
	'imagesegmentstartline' => { 143 => 0x184c },
	'imagesequenceinfo' => { 124 => 0xcd44 },
	'imagesize' => { 167 => 'ImageSize' },
	'imagesizeraw' => { 241 => 0x3e },
	'imagesizerestriction' => { 539 => 'imageSizeRestriction' },
	'imagesourcedata' => { 124 => 0x935c },
	'imagespace' => { 143 => 0x909 },
	'imagestabilization' => { 36 => 0x22, 118 => 0x3020, 132 => 0x1422, 161 => 'ImageStabilization', 187 => 0xbd, 188 => 0x71, 189 => 0x57, 190 => 0x0, 191 => [0x18,0x107,0x113], 192 => 0x49c2, 241 => 0xac, 328 => 0x604, 331 => 0x1600, 352 => 0x1a, 445 => 0x12, 446 => 0x11, 454 => 0xb026 },
	'imagestabilization2' => { 444 => 0xa },
	'imagestabilizationsetting' => { 192 => 0x14, 440 => 0x3d, 441 => 0x3d, 451 => 0x14 },
	'imagestats' => { 124 => 0xcd46 },
	'imagestyle' => { 440 => 0x2d, 441 => 0x27 },
	'imagesupplier' => { 338 => 'ImageSupplier' },
	'imagesupplierid' => { 338 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 338 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 338 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 126 => 0x1 },
	'imagetemperaturemin' => { 126 => 0x2 },
	'imagetitle' => { 124 => 0xa436, 524 => 'ImageTitle' },
	'imagetone' => { 388 => 0x4f },
	'imagetype' => { 136 => 0x82, 338 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 68 => 0x28, 124 => 0xa420, 522 => 'ImageUniqueID', 523 => 'ImageUniqueID', 524 => 'ImageUniqueID' },
	'imagewidth' => { 124 => 0x100, 193 => 0xe, 397 => 0x10c, 502 => 'ImageWidth', 542 => 'ImageWidth' },
	'inclinationangle' => { 491 => 0x900f },
	'inclinationcorrection' => { 491 => 0x900e },
	'incrementaltemperature' => { 517 => 'IncrementalTemperature', 519 => 'IncrementalTemperature' },
	'incrementaltint' => { 517 => 'IncrementalTint', 519 => 'IncrementalTint' },
	'industry' => { 536 => 'industry', 537 => 'industry' },
	'infobuttonwhenshooting' => { 89 => 0x409 },
	'information' => { 407 => 'information', 413 => "\xa9inf" },
	'infourl' => { 413 => 'infu' },
	'infraredilluminator' => { 414 => 0x28 },
	'ingredientexclusion' => { 538 => 'ingredientExclusion' },
	'ingredients' => { 547 => 'Ingredients' },
	'ingredientsalternatepaths' => { 547 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 547 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 547 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 547 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 547 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 547 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 547 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 547 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 547 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 547 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 547 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 547 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 547 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 547 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 547 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 547 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 547 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 547 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 547 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 547 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 547 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 547 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 547 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 89 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 505 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 505 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 184 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 505 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 505 => 'InitialViewHeadingDegrees', 506 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 505 => 'InitialViewPitchDegrees', 506 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 505 => 'InitialViewRollDegrees', 506 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 307 => '4.4' },
	'initialzoomsetting' => { 307 => '9.3', 316 => '27.3' },
	'inkset' => { 124 => 0x14c },
	'inputprofile' => { 143 => 0x1389 },
	'instanceid' => { 547 => 'InstanceID' },
	'instantplaybacksetup' => { 189 => 0x3e },
	'instantplaybacktime' => { 189 => 0x3d },
	'instructions' => { 534 => 'Instructions' },
	'instrument' => { 546 => 'instrument' },
	'integrationtime' => { 143 => 0x423 },
	'intellectualgenre' => { 530 => 'IntellectualGenre' },
	'intelligentauto' => { 454 => 0xb052, 482 => 0xd, 483 => 0xe, 484 => 0xd },
	'intelligentcontrast' => { 55 => 0x4 },
	'intelligentd-range' => { 352 => 0x79 },
	'intelligentexposure' => { 352 => 0x5d },
	'intelligentresolution' => { 352 => 0x70 },
	'interchangecolorspace' => { 138 => 0x40 },
	'intergraphmatrix' => { 124 => 0x8480 },
	'internalflash' => { 186 => 0x2b, 307 => '23.1', 309 => '8.1', 312 => '22.1', 314 => '23.1', 318 => '8.1', 322 => '24.1', 331 => 0x1208 },
	'internalflashae1' => { 333 => 0x1021 },
	'internalflashae1_0' => { 333 => 0x101d },
	'internalflashae2' => { 333 => 0x1022 },
	'internalflashae2_0' => { 333 => 0x101e },
	'internalflashmode' => { 375 => 0x1 },
	'internalflashstrength' => { 375 => 0x3 },
	'internalflashtable' => { 333 => 0x1024 },
	'internallensserialnumber' => { 427 => 0xa005 },
	'internalndfilter' => { 352 => 0x9d },
	'internalserialnumber' => { 68 => 0x96, 80 => 0x9, 132 => 0x10, 192 => 0x49dc, 327 => 0x18, 329 => 0x102, 349 => 0x500, 352 => 0x25, 367 => 0x4, 420 => 0x5, 473 => [0x7c,0xf0], 474 => 0x88, 475 => [0x88,0x8a], 476 => 0x38 },
	'interopindex' => { 124 => 0x1, 524 => 'InteroperabilityIndex' },
	'interopversion' => { 124 => 0x2 },
	'interval' => { 265 => 0x20 },
	'intervaldurationhours' => { 245 => 0x1dc, 246 => 0xa0, 247 => 0xb8, 248 => 0xb8 },
	'intervaldurationminutes' => { 245 => 0x1e0, 246 => 0xa4, 247 => 0xbc, 248 => 0xbc },
	'intervaldurationseconds' => { 245 => 0x1e4, 246 => 0xa8, 247 => 0xc0, 248 => 0xc0 },
	'intervalexposuresmoothing' => { 230 => 0x184, 245 => 0x1f4, 246 => 0xb8, 247 => 0xd0, 248 => 0xd0 },
	'intervalframe' => { 265 => 0x24 },
	'intervallength' => { 186 => 0x10 },
	'intervalmode' => { 186 => 0x26 },
	'intervalnumber' => { 186 => 0x11 },
	'intervalpriority' => { 230 => 0x186, 245 => 0x1f6, 246 => 0xba, 247 => 0xd2, 248 => 0xd2 },
	'intervals' => { 230 => 0x17c, 245 => 0x1ec, 246 => 0xb0, 247 => 0xc8, 248 => 0xc8, 249 => 0xbc, 250 => 0xcc, 251 => 0xcc },
	'intervalshooting' => { 231 => 0x24, 267 => 0x24, 268 => 0x28, 388 => 0x92 },
	'introtime' => { 546 => 'introTime' },
	'introtimescale' => { 546 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 546 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 143 => 0xdae },
	'ipfcameramodel' => { 143 => 0xe4d },
	'iptc' => { 125 => 'IPTC' },
	'iptc-naa' => { 124 => 0x83bb, 357 => 0x83bb },
	'iptcbitspersample' => { 138 => 0x56 },
	'iptcdigest' => { 402 => 0x425 },
	'iptcimageheight' => { 138 => 0x1e },
	'iptcimagerotation' => { 138 => 0x66 },
	'iptcimagewidth' => { 138 => 0x14 },
	'iptclastedited' => { 531 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 138 => 0xa },
	'iptcpixelheight' => { 138 => 0x32 },
	'iptcpixelwidth' => { 138 => 0x28 },
	'isalternativeof' => { 536 => 'isAlternativeOf' },
	'isbn' => { 536 => 'isbn' },
	'iscorrectionof' => { 536 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 114 => 0x3 },
	'ismergedhdr' => { 514 => 'IsMergedHDR' },
	'ismergedpanorama' => { 514 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 117 => 0x14, 118 => [0x3014,0x14], 124 => 0x8827, 142 => 0xfd06, 143 => 0x1784, 145 => 0x60, 147 => [0xfa2e,0xfa46], 148 => [0x27,0x28], 149 => 0xf105, 152 => 0x14, 154 => 0x4e, 156 => 0x1e, 157 => 0x1a, 159 => 0x34, 161 => 'ISO', 186 => 0x8, 192 => 0x49ba, 229 => 0x0, 241 => 0x2, 352 => 0xd1, 357 => [0x17,0x37], 388 => [0x8b,0x14], 395 => 0x14, 397 => 0x105, 427 => 0xa014, 430 => 0x86, 451 => 0x6f, 459 => [0x1f,0x21,0x25], 523 => 'ISOSpeedRatings' },
	'iso2' => { 229 => 0x6, 272 => 0x265, 273 => 0x25c, 274 => 0x265, 275 => 0x221, 276 => 0x25d, 277 => 0x256, 278 => 0x25d, 281 => 0x2b5, 284 => 0x265, 288 => 0x2b5 },
	'isoauto' => { 368 => '14.4' },
	'isoautoflashlimit' => { 247 => 0x156, 248 => 0x156, 249 => 0x146, 250 => 0x15a, 251 => 0x15a },
	'isoautohilimit' => { 228 => 0x5, 245 => 0x28a, 247 => 0x154, 248 => 0x154, 249 => 0x144, 250 => 0x158, 251 => 0x158, 270 => 0x5, 280 => 0x18eb },
	'isoautomax' => { 453 => 0x4 },
	'isoautomin' => { 453 => 0x2 },
	'isoautominspeed' => { 388 => 0x7a },
	'isoautoshuttertime' => { 228 => 0x4, 247 => 0x15e, 248 => 0x15e, 249 => 0x14e, 250 => 0x162, 251 => 0x162, 270 => 0x4, 280 => 0x18ea },
	'isobutton' => { 251 => 0x796 },
	'isocalibrationgain' => { 143 => 0x89f },
	'isodisplay' => { 310 => '4.1', 311 => '4.1', 312 => '2.3', 313 => '3.3', 314 => '3.3', 317 => '3.3', 320 => '4.3', 321 => '4.1', 322 => '4.3' },
	'isoexpansion' => { 89 => 0x103, 90 => 0x7, 91 => 0x8, 94 => 0x8, 229 => 0x4 },
	'isoexpansion2' => { 229 => 0xa },
	'isofloor' => { 368 => 0x6 },
	'isoselected' => { 351 => 0x359 },
	'isoselection' => { 241 => 0xf },
	'isosensitivitystep' => { 315 => '6.2', 317 => '6.2' },
	'isosetting' => { 145 => 0x5e, 157 => 0x14, 161 => 'ISOSetting', 186 => 0x24, 187 => 0x26, 188 => 0x1c, 189 => 0x13, 194 => 0x6, 241 => 0x13, 368 => '17.3', 419 => 0x27, 440 => 0x16, 441 => 0x14, 442 => 0x2, 451 => 0x6d, 453 => 0x0 },
	'isospeed' => { 124 => 0x8833, 524 => 'ISOSpeed' },
	'isospeedexpansion' => { 88 => 0x3 },
	'isospeedincrements' => { 89 => 0x102 },
	'isospeedlatitudeyyy' => { 124 => 0x8834, 524 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 124 => 0x8835, 524 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 89 => 0x103 },
	'isostepsize' => { 307 => '6.1', 308 => '7.2', 310 => '7.2', 311 => '7.2', 316 => '4.1', 320 => '7.2', 321 => '7.2', 323 => 0x14d, 324 => 0x15d, 325 => 0x15d, 326 => 0x175 },
	'isovalue' => { 333 => 0x1001 },
	'isrc' => { 405 => 'xid ' },
	'isrccode' => { 413 => "\xa9isr" },
	'issn' => { 536 => 'issn' },
	'issueidentifier' => { 536 => 'issueIdentifier' },
	'issuename' => { 536 => 'issueName' },
	'issueteaser' => { 536 => 'issueTeaser' },
	'issuetype' => { 536 => 'issueType' },
	'istranslationof' => { 536 => 'isTranslationOf' },
	'itemsubtype' => { 183 => 'ItemSubType' },
	'itunesu' => { 405 => 'itnu' },
	'jobid' => { 136 => 0xb8 },
	'jobname' => { 525 => 'JobName' },
	'jobref' => { 545 => 'JobRef' },
	'jobrefid' => { 545 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 545 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 545 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 525 => 'JobStatus' },
	'jpeg-heifswitch' => { 454 => 0x2039 },
	'jpeghandling' => { 517 => 'JPEGHandling', 519 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 352 => 0x43, 354 => 0x3034, 454 => 0xb047 },
	'jpegsize' => { 354 => 0x303a },
	'jpgcompression' => { 232 => 0x24, 241 => 0x44, 275 => '671.1' },
	'jpgfromraw' => { 102 => 0x2007, 119 => 'Exif-JpgFromRaw', 357 => 0x2e },
	'jpgfromrawlength' => { 124 => [0x117,0x202] },
	'jpgfromrawstart' => { 124 => [0x111,0x201] },
	'jpgrecordedpixels' => { 368 => '14.1' },
	'jurisdiction' => { 515 => 'jurisdiction' },
	'jxldecodespeed' => { 124 => 0xcd4b },
	'jxldistance' => { 124 => 0xcd49 },
	'jxleffort' => { 124 => 0xcd4a },
	'keepexposure' => { 324 => 0x237, 325 => 0x237, 326 => 0x24f },
	'kelvinwb_01' => { 376 => 0x5 },
	'kelvinwb_02' => { 376 => 0x9 },
	'kelvinwb_03' => { 376 => 0xd },
	'kelvinwb_04' => { 376 => 0x11 },
	'kelvinwb_05' => { 376 => 0x15 },
	'kelvinwb_06' => { 376 => 0x19 },
	'kelvinwb_07' => { 376 => 0x1d },
	'kelvinwb_08' => { 376 => 0x21 },
	'kelvinwb_09' => { 376 => 0x25 },
	'kelvinwb_10' => { 376 => 0x29 },
	'kelvinwb_11' => { 376 => 0x2d },
	'kelvinwb_12' => { 376 => 0x31 },
	'kelvinwb_13' => { 376 => 0x35 },
	'kelvinwb_14' => { 376 => 0x39 },
	'kelvinwb_15' => { 376 => 0x3d },
	'kelvinwb_16' => { 376 => 0x41 },
	'kelvinwb_daylight' => { 376 => 0x1 },
	'kerneldenominators' => { 143 => 0x933 },
	'key' => { 546 => 'key' },
	'keystonecompensation' => { 332 => 0x1900 },
	'keystonedirection' => { 332 => 0x1901 },
	'keystonevalue' => { 332 => 0x1906 },
	'keyword' => { 405 => 'keyw', 536 => 'keyword' },
	'keywordinfo' => { 176 => 'Keywords' },
	'keywords' => { 136 => 0x19, 162 => 'Keywords', 337 => 'Keywords', 404 => 'Keywords', 407 => 'keywords', 512 => 'keywords', 533 => 'Keywords', 544 => 'Keywords' },
	'killdate' => { 536 => 'killDate' },
	'killdatea-platform' => { 536 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 536 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 142 => 0xf908, 145 => 0xe, 147 => [0xfa1e,0xfa52], 153 => 0x70 },
	'kodakimagewidth' => { 142 => 0xf907, 145 => 0xc, 147 => [0xfa1d,0xfa51], 153 => 0x6c },
	'kodakinfotype' => { 142 => 0xfa00 },
	'kodaklook' => { 143 => 0xe4c },
	'kodaklookprofile' => { 143 => 0x138a },
	'kodakmaker' => { 153 => 0x8 },
	'kodakmodel' => { 145 => 0x0, 153 => 0x28 },
	'kodaktag' => { 143 => 0x3ea },
	'kodakversion' => { 143 => 0x0 },
	'label' => { 341 => 'Label', 544 => 'Label' },
	'labelname1' => { 529 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 529 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 352 => 0x6f },
	'landscapeoutputhighlightpoint' => { 114 => 0x26 },
	'landscapeoutputshadowpoint' => { 114 => 0x27 },
	'landscaperawcolortone' => { 114 => 0x1f },
	'landscaperawcontrast' => { 114 => 0x21 },
	'landscaperawhighlight' => { 114 => 0x77 },
	'landscaperawhighlightpoint' => { 114 => 0x24 },
	'landscaperawlinear' => { 114 => 0x22 },
	'landscaperawsaturation' => { 114 => 0x20 },
	'landscaperawshadow' => { 114 => 0x80 },
	'landscaperawshadowpoint' => { 114 => 0x25 },
	'landscaperawsharpness' => { 114 => 0x23 },
	'landscapeunsharpmaskfineness' => { 114 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 114 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 114 => 0xa2 },
	'language' => { 245 => 0x8fc, 247 => 0x6a2, 248 => 0x6a2, 249 => 0x592, 250 => 0x5c2, 251 => 0x5da, 520 => 'language' },
	'languageidentifier' => { 136 => 0x87 },
	'largestvalidinteriorrectheight' => { 505 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 505 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 505 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 505 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 186 => 0x1b },
	'lastkeywordiptc' => { 183 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 183 => 'LastKeywordXMP' },
	'lastphotodate' => { 505 => 'LastPhotoDate' },
	'lasturl' => { 547 => 'LastURL' },
	'lateralchromaticaberration' => { 454 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 514 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 123 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 123 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 123 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 123 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 123 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 121 => 'Latitude' },
	'lc1' => { 378 => 0x2 },
	'lc10' => { 378 => 0xb },
	'lc11' => { 378 => 0xc },
	'lc12' => { 378 => 0xd },
	'lc14' => { 378 => 0xf },
	'lc15' => { 378 => 0x10 },
	'lc3' => { 378 => 0x4 },
	'lc4' => { 378 => 0x5 },
	'lc5' => { 378 => 0x6 },
	'lc6' => { 378 => 0x7 },
	'lc7' => { 378 => 0x8 },
	'lc8' => { 378 => 0x9 },
	'lcddisplayatpoweron' => { 89 => 0x811, 93 => 0xa },
	'lcddisplayreturntoshoot' => { 94 => 0x12 },
	'lcdillumination' => { 307 => '17.5', 308 => '5.2', 310 => '5.1', 311 => '5.1', 316 => '10.3', 317 => '4.2', 320 => '5.2', 321 => '5.1', 322 => '5.4', 323 => 0xf1, 324 => 0x101, 325 => 0x101, 326 => 0x117 },
	'lcdilluminationduringbulb' => { 89 => 0x408 },
	'lcdmatrix' => { 143 => 0xe74 },
	'lcdmatrixchickfix' => { 143 => 0xe75 },
	'lcdmatrixmarvin' => { 143 => 0xe76 },
	'lcdpanels' => { 88 => 0x8 },
	'lcheditor' => { 300 => 0x8ae85e },
	'legacyiptcdigest' => { 534 => 'LegacyIPTCDigest' },
	'legalcode' => { 515 => 'legalcode' },
	'lens' => { 124 => 0xfdea, 241 => 0x84, 514 => 'Lens' },
	'lensafstopbutton' => { 87 => 0x11, 88 => 0x13, 89 => 0x506, 90 => 0x10, 91 => 0x12, 94 => 0x13, 95 => 0x9 },
	'lensaperturerange' => { 430 => [0x30,0x48] },
	'lensblur' => { 517 => 'LensBlur', 519 => 'LensBlur' },
	'lensbluractive' => { 517 => [\'LensBlur','LensBlurActive'], 519 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 517 => [\'LensBlur','LensBlurBlurAmount'], 519 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 517 => [\'LensBlur','LensBlurBokehAspect'], 519 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 517 => [\'LensBlur','LensBlurBokehRotation'], 519 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 517 => [\'LensBlur','LensBlurBokehShape'], 519 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 517 => [\'LensBlur','LensBlurBokehShapeDetail'], 519 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 517 => [\'LensBlur','LensBlurCatEyeAmount'], 519 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 517 => [\'LensBlur','LensBlurCatEyeScale'], 519 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 517 => [\'LensBlur','LensBlurFocalRange'], 519 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 517 => [\'LensBlur','LensBlurFocalRangeSource'], 519 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 517 => [\'LensBlur','LensBlurHighlightsBoost'], 519 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 517 => [\'LensBlur','LensBlurHighlightsThreshold'], 519 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 517 => [\'LensBlur','LensBlurSampledArea'], 519 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 517 => [\'LensBlur','LensBlurSampledRange'], 519 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 517 => [\'LensBlur','LensBlurSphericalAberration'], 519 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 517 => [\'LensBlur','LensBlurSubjectRange'], 519 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 517 => [\'LensBlur','LensBlurVersion'], 519 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 323 => 0xb1, 324 => 0xad, 325 => 0xad, 326 => 0xad },
	'lenscorrectionsettings' => { 522 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 514 => 'LensDistortInfo' },
	'lensdistortionparams' => { 333 => 0x206 },
	'lensdriveend' => { 239 => 0x56 },
	'lensdrivenoaf' => { 89 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 442 => 0x3f0, 490 => 0xd },
	'lensfirmware' => { 421 => 0x20, 427 => 0xa004 },
	'lensfirmwareversion' => { 239 => 0x34, 329 => 0x204, 352 => 0x60, 442 => 0x3f3, 490 => 0x14 },
	'lensfocallength' => { 108 => 0xf0512, 378 => 0x9 },
	'lensfocalrange' => { 430 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 308 => '55.1', 310 => '52.1', 311 => '52.1', 320 => '52.1', 321 => '52.1' },
	'lensformat' => { 467 => 0x1891, 469 => 0x18bd, 470 => 0x18ed, 471 => 0x17f1, 473 => 0x106, 474 => 0x106, 485 => 0x603, 486 => 0x5d },
	'lensfstops' => { 233 => 0x7, 234 => 0xc, 235 => 0xd, 239 => 0xe, 241 => 0x8b, 378 => '0.3' },
	'lensfunc1button' => { 323 => 0xa3, 324 => 0x9f, 325 => 0x9f, 326 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 248 => 0x80a, 251 => 0x810 },
	'lensfunc2button' => { 323 => 0xab, 324 => 0xa7, 325 => 0xa7, 326 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 248 => 0x80c, 251 => 0x812 },
	'lensid' => { 239 => 0x30, 514 => 'LensID' },
	'lensidnumber' => { 233 => 0x6, 234 => 0xb, 235 => 0xc, 239 => 0xd },
	'lensinfo' => { 124 => 0xa432, 384 => 0x2a, 514 => 'LensInfo', 524 => 'LensSpecification' },
	'lenskind' => { 378 => 0x1 },
	'lensmake' => { 124 => 0xa433, 168 => 'Make', 524 => 'LensMake' },
	'lensmanualdistortionamount' => { 517 => 'LensManualDistortionAmount', 519 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 183 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 430 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 68 => 0x95, 124 => 0xa434, 168 => 'Model', 183 => 'LensModel', 236 => 0x18a, 237 => 0x18b, 238 => 0x2ac, 329 => 0x203, 384 => 0xc, 397 => 0x412, 524 => 'LensModel' },
	'lensmodulationoptimizer' => { 132 => 0x1045 },
	'lensmount' => { 442 => 0x99, 467 => 0x1892, 469 => 0x18be, 470 => 0x18ee, 471 => 0x17f2, 473 => 0x105, 474 => 0x105, 485 => 0x604, 486 => 0x5e },
	'lensmount2' => { 490 => 0x8 },
	'lensmounttype' => { 239 => 0x5f },
	'lenspositionabsolute' => { 239 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 517 => 'LensProfileChromaticAberrationScale', 519 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 517 => 'LensProfileDigest', 519 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 517 => 'LensProfileDistortionScale', 519 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 517 => 'LensProfileEnable', 519 => 'LensProfileEnable' },
	'lensprofilefilename' => { 517 => 'LensProfileFilename', 519 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 517 => 'LensProfileIsEmbedded', 519 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 517 => 'LensProfileMatchKeyCameraModelName', 519 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 517 => 'LensProfileMatchKeyExifMake', 519 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 517 => 'LensProfileMatchKeyExifModel', 519 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 517 => 'LensProfileMatchKeyIsRaw', 519 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 517 => 'LensProfileMatchKeyLensID', 519 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 517 => 'LensProfileMatchKeyLensInfo', 519 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 517 => 'LensProfileMatchKeyLensName', 519 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 517 => 'LensProfileMatchKeySensorFormatFactor', 519 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 351 => 0x370, 517 => 'LensProfileName', 519 => 'LensProfileName' },
	'lensprofilesetup' => { 517 => 'LensProfileSetup', 519 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 517 => 'LensProfileVignettingScale', 519 => 'LensProfileVignettingScale' },
	'lensproperties' => { 329 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 34 => 0x16b, 64 => 0x0, 124 => 0xa435, 168 => 'SerialNumber', 329 => 0x202, 350 => 0x321, 352 => 0x52, 413 => 'LENS', 421 => 0x30, 514 => 'LensSerialNumber', 524 => 'LensSerialNumber' },
	'lensshutterlock' => { 189 => 0x4a },
	'lensspec' => { 437 => 0x0, 438 => 0x0, 439 => 0x0, 454 => 0xb02a },
	'lensspecfeatures' => { 473 => [0x115,0x116], 474 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 333 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 36 => 0x16, 191 => 0x10c, 192 => 0x49bd, 241 => 0x83, 329 => 0x201, 343 => 0x16, 347 => 0x310, 349 => 0x303, 350 => 0x303, 352 => 0x51, 354 => 0x3405, 379 => 0x0, 380 => 0x0, 381 => 0x1, 382 => 0x1, 383 => 0x1, 385 => 0x0, 427 => 0xa003, 430 => 0x27, 454 => 0xb027, 467 => 0x1896, 469 => 0x18c2, 470 => 0x18f2, 471 => 0x17f6, 473 => 0x109, 474 => 0x109, 485 => 0x608, 486 => 0x62 },
	'lenstype2' => { 442 => 0x3f7, 467 => 0x1893, 469 => 0x18bf, 470 => 0x18ef, 471 => 0x17f3, 473 => 0x107, 474 => 0x107, 485 => 0x605, 486 => 0x60 },
	'lenstype3' => { 490 => 0x9 },
	'lenstypemake' => { 352 => 0xc4 },
	'lenstypemodel' => { 352 => [0xc5,0xe4] },
	'lenszoomposition' => { 482 => 0x19, 483 => 0x1e, 486 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 360 => 0x15 },
	'levelmeter' => { 413 => ['Lvlm','lvlm'] },
	'levelorientation' => { 386 => 0x0 },
	'license' => { 515 => 'license' },
	'licensee' => { 338 => 'Licensee' },
	'licenseeid' => { 338 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 338 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 338 => 'LicenseeImageNotes' },
	'licenseename' => { 338 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 338 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 338 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 338 => 'LicenseeTransactionID' },
	'licenseid' => { 338 => 'LicenseID' },
	'licensestartdate' => { 338 => 'LicenseStartDate' },
	'licensetransactiondate' => { 338 => 'LicenseTransactionDate' },
	'licensetype' => { 521 => 'licensetype' },
	'licensor' => { 338 => 'Licensor' },
	'licensorcity' => { 338 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 338 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 338 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 338 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 338 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 338 => 'LicensorImageID' },
	'licensorname' => { 338 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 338 => 'LicensorNotes' },
	'licensorpostalcode' => { 338 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 338 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 338 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 338 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 338 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 338 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 338 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 338 => 'LicensorTransactionID' },
	'licensorurl' => { 338 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 333 => 0x1009 },
	'lightingmode' => { 118 => 0x302a },
	'lightreading' => { 388 => 0x15 },
	'lightsource' => { 124 => 0x9208, 241 => 0x90, 336 => 0x1000, 523 => 'LightSource' },
	'lightsourcespecial' => { 429 => 0x21d },
	'lightswitch' => { 320 => '0.1', 322 => '0.1' },
	'lightvaluecenter' => { 333 => 0x103d },
	'lightvalueperiphery' => { 333 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 323 => 0x143, 324 => 0x153, 325 => 0x153, 326 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 323 => 0x141, 324 => 0x151, 325 => 0x151, 326 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 323 => 0x140, 324 => 0x150, 325 => 0x150, 326 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 323 => 0x13f, 324 => 0x14f, 325 => 0x14f, 326 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 323 => 0x11, 324 => 0x11, 325 => 0x11, 326 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 323 => 0x14, 324 => 0x14, 325 => 0x14, 326 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 323 => 0x13, 324 => 0x13, 325 => 0x13, 326 => 0x13 },
	'limitafareamodeselauto' => { 323 => 0x15, 324 => 0x15, 325 => 0x15, 326 => 0x15 },
	'limitafareamodeselection' => { 308 => '51.1', 310 => '49.1', 311 => '49.1', 320 => '49.1', 321 => '49.1' },
	'limitreleasemodeselc120' => { 325 => '269.4', 326 => '293.4' },
	'limitreleasemodeselc30' => { 325 => '269.3', 326 => '293.3' },
	'limitreleasemodeselch' => { 325 => '269.2', 326 => '293.2' },
	'limitreleasemodeselcl' => { 325 => '269.1', 326 => '293.1' },
	'limitreleasemodeselself' => { 325 => '269.5', 326 => '293.5' },
	'limitselectableimagearea16to9' => { 323 => 0x4d, 324 => 0x47, 325 => 0x47, 326 => 0x47 },
	'limitselectableimagearea1to1' => { 323 => 0x4c, 324 => 0x46, 325 => 0x46, 326 => 0x46 },
	'limitselectableimageareadx' => { 323 => 0x4b, 324 => 0x45, 325 => 0x45, 326 => 0x45 },
	'linearitylimitblue' => { 357 => 0x10 },
	'linearitylimitgreen' => { 357 => 0xf },
	'linearitylimitred' => { 357 => 0xe },
	'linearityuppermargin' => { 43 => 0x32c, 44 => 0x282, 45 => 0x296, 48 => [0x2ba,0x2d1,0x2d5], 50 => 0x1e5, 51 => [0x1fe,0x2de], 52 => [0x232,0x310], 53 => 0x31e },
	'linearizationtable' => { 124 => 0xc618 },
	'linearresponselimit' => { 124 => 0xc62e },
	'link' => { 536 => 'link' },
	'linkaetoafpoint' => { 368 => '14.2' },
	'linkedencodedrightsexpr' => { 531 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 531 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 531 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 531 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 245 => 0x3ec },
	'linlogcoring' => { 143 => 0x904 },
	'lithostratigraphicterms' => { 123 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 407 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 407 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 407 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 363 => 0x1fa, 370 => 0x3 },
	'liveviewaf' => { 312 => '32.1', 322 => '34.1' },
	'liveviewafareamode' => { 317 => '34.1' },
	'liveviewafmethod' => { 459 => 0x20 },
	'liveviewafmode' => { 317 => '34.2' },
	'liveviewafsetting' => { 442 => 0x36 },
	'liveviewbuttonoptions' => { 308 => '50.2', 310 => '48.2', 311 => '48.2', 320 => '48.2', 321 => '48.2' },
	'liveviewexposuresimulation' => { 89 => 0x810 },
	'liveviewfocusmode' => { 442 => [0x8b,0x28b] },
	'liveviewmetering' => { 442 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 308 => '21.2', 310 => '21.2', 311 => '21.2', 313 => '20.2', 314 => '20.2', 315 => '20.2', 317 => '20.2', 320 => '21.2', 321 => '21.2' },
	'liveviewshooting' => { 60 => 0x13 },
	'livingspecimen' => { 123 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 123 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 136 => 0x79 },
	'localizedcameramodel' => { 124 => 0xc615 },
	'locallocationname' => { 427 => 0x30 },
	'location' => { 240 => 0x9, 352 => 0x67, 510 => 'Location', 530 => 'Location', 535 => 'location', 536 => 'location' },
	'locationaccuracyhorizontal' => { 407 => 'location.accuracy.horizontal' },
	'locationareacode' => { 516 => 'lac' },
	'locationbody' => { 407 => 'location.body' },
	'locationcreated' => { 531 => 'LocationCreated' },
	'locationcreatedcity' => { 531 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 531 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 531 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 531 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 531 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 531 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 531 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 531 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 531 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 531 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 531 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 531 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 531 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 407 => 'location.date' },
	'locationinformation' => { 413 => 'loci' },
	'locationinfoversion' => { 240 => 0x0 },
	'locationname' => { 407 => 'location.name', 427 => 0x31 },
	'locationnote' => { 407 => 'location.note' },
	'locationrole' => { 407 => 'location.role' },
	'locationshown' => { 531 => 'LocationShown' },
	'locationshowncity' => { 531 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 531 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 531 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 531 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 531 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 531 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 531 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 531 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 531 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 531 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 531 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 531 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 531 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 89 => 0x709 },
	'logcomment' => { 546 => 'logComment' },
	'logscale' => { 143 => 0x902 },
	'longdescription' => { 405 => 'ldes' },
	'longexposurenoisereduction' => { 66 => 0x4, 89 => 0x201, 90 => 0x1, 91 => 0x2, 92 => 0x1, 93 => 0x1, 94 => 0x2, 95 => 0x1, 352 => 0x49, 440 => 0x2b, 441 => 0x25, 442 => 0x25, 454 => 0x2008, 459 => 0x11, 486 => 0x44 },
	'longexposurenoisereduction2' => { 60 => 0x8 },
	'longexposurenrused' => { 352 => 0xbe },
	'longitude' => { 121 => 'Longitude' },
	'look' => { 517 => 'Look', 519 => 'Look' },
	'lookamount' => { 517 => [\'Look','LookAmount'], 519 => [\'Look','LookAmount'] },
	'lookcluster' => { 517 => [\'Look','LookCluster'], 519 => [\'Look','LookCluster'] },
	'lookcopyright' => { 517 => [\'Look','LookCopyright'], 519 => [\'Look','LookCopyright'] },
	'lookgroup' => { 517 => [\'Look','LookGroup'], 519 => [\'Look','LookGroup'] },
	'lookname' => { 517 => 'LookName', 519 => 'LookName' },
	'lookparameters' => { 517 => [\'Look','LookParameters'], 519 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 517 => [\'Look','LookParametersCameraProfile'], 519 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 517 => [\'Look','LookParametersClarity2012'], 519 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 517 => [\'Look','LookParametersConvertToGrayscale'], 519 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 517 => [\'Look','LookParametersHighlights2012'], 519 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 517 => [\'Look','LookParametersLookTable'], 519 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 517 => [\'Look','LookParametersProcessVersion'], 519 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 517 => [\'Look','LookParametersShadows2012'], 519 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 517 => [\'Look','LookParametersToneCurvePV2012'], 519 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 517 => [\'Look','LookParametersToneCurvePV2012Blue'], 519 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 517 => [\'Look','LookParametersToneCurvePV2012Green'], 519 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 517 => [\'Look','LookParametersToneCurvePV2012Red'], 519 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 517 => [\'Look','LookParametersVersion'], 519 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 517 => [\'Look','LookSupportsAmount'], 519 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 517 => [\'Look','LookSupportsMonochrome'], 519 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 517 => [\'Look','LookSupportsOutputReferred'], 519 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 517 => [\'Look','LookUUID'], 519 => [\'Look','LookUUID'] },
	'loop' => { 546 => 'loop' },
	'loopstyle' => { 413 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 123 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 517 => 'LuminanceAdjustmentAqua', 519 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 517 => 'LuminanceAdjustmentBlue', 519 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 517 => 'LuminanceAdjustmentGreen', 519 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 517 => 'LuminanceAdjustmentMagenta', 519 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 517 => 'LuminanceAdjustmentOrange', 519 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 517 => 'LuminanceAdjustmentPurple', 519 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 517 => 'LuminanceAdjustmentRed', 519 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 517 => 'LuminanceAdjustmentYellow', 519 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 113 => 0x150 },
	'luminancecurvepoints' => { 113 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 108 => 0x20600, 114 => 0x5f, 430 => 0x1b },
	'luminancenoisereductioncontrast' => { 517 => 'LuminanceNoiseReductionContrast', 519 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 517 => 'LuminanceNoiseReductionDetail', 519 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 114 => 0x6d },
	'luminancesmoothing' => { 517 => 'LuminanceSmoothing', 519 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 89 => [0x40b,0x40c] },
	'lyrics' => { 405 => "\xa9lyr", 413 => "\xa9lyr", 546 => 'lyrics' },
	'lyricsuri' => { 413 => 'lrcu' },
	'm16cversion' => { 347 => 0x333 },
	'macatom' => { 518 => 'macAtom' },
	'macatomapplicationcode' => { 518 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 518 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 518 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 123 => 'MachineObservation' },
	'machineobservationday' => { 123 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 123 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 123 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 123 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 123 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 123 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 123 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 123 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 123 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 123 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 123 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 123 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 123 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 123 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 123 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 123 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 123 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 123 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 123 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 123 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 132 => 0x1020, 134 => 0x202, 156 => 0x2b, 333 => 0x202, 419 => 0x21, 429 => 0x202, 454 => 0xb040 },
	'macroled' => { 331 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 60 => 0x10 },
	'macromode' => { 36 => 0x1, 186 => 0xb, 328 => 0x300, 352 => 0x1c, 420 => 0x1009 },
	'magentahsl' => { 108 => 0x20917 },
	'magicfilter' => { 328 => 0x52c },
	'magnifiedview' => { 91 => 0x11, 93 => 0x9 },
	'mainboardversion' => { 143 => 0x438 },
	'maindialexposurecomp' => { 318 => '0.6' },
	'mainingredient' => { 538 => 'mainIngredient' },
	'majorbrand' => { 407 => 'major_brand' },
	'majorversion' => { 508 => 'MajorVersion' },
	'make' => { 103 => 0x0, 120 => 0x1, 124 => 0x10f, 161 => 'Make', 341 => 'Make', 357 => 0x10f, 407 => 'make', 413 => ['@mak',"\xa9mak"], 535 => 'make', 542 => 'Make' },
	'makernote' => { 523 => 'MakerNote' },
	'makernoteapple' => { 122 => 'MakN', 124 => 0x927c },
	'makernotecanon' => { 86 => 'CMT3', 122 => 'MakN', 124 => 0x927c },
	'makernotecasio' => { 122 => 'MakN', 124 => 0x927c },
	'makernotecasio2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotedji' => { 122 => 'MakN', 124 => 0x927c },
	'makernotedjiinfo' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteflir' => { 122 => 'MakN', 124 => 0x927c },
	'makernotefujifilm' => { 122 => 'MakN', 124 => 0x927c },
	'makernotege' => { 122 => 'MakN', 124 => 0x927c },
	'makernotege2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehasselblad' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotehp6' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteisl' => { 122 => 'MakN', 124 => 0x927c },
	'makernotejvc' => { 122 => 'MakN', 124 => 0x927c },
	'makernotejvctext' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak10' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak11' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak12' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak1a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak1b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak5' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak6a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak6b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak7' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak8a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak8b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak8c' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodak9' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekodakunknown' => { 122 => 'MakN', 124 => 0x927c },
	'makernotekyocera' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica10' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica2' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica3' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica4' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica5' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica6' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica7' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica8' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteleica9' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteminolta' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteminolta2' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteminolta3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotemotorola' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenikon' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenikon2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenikon3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotenintendo' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteoffset' => { 429 => 0xff },
	'makernoteolympus' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteolympus2' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteolympus3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepanasonic' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepanasonic2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepanasonic3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax5' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentax6' => { 122 => 'MakN', 124 => 0x927c },
	'makernotepentaxunknown' => { 413 => 'PXMN' },
	'makernotephaseone' => { 122 => 'MakN', 124 => 0x927c },
	'makernotereconyx' => { 122 => 'MakN', 124 => 0x927c },
	'makernotereconyx2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotereconyx3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericoh' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericoh2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericohpentax' => { 122 => 'MakN', 124 => 0x927c },
	'makernotericohtext' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesafety' => { 124 => 0xc635 },
	'makernotesamsung1a' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesamsung1b' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesamsung2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesanyo' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesanyoc4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesanyopatch' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesigma' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony2' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony3' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony4' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesony5' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesonyericsson' => { 122 => 'MakN', 124 => 0x927c },
	'makernotesonysrf' => { 122 => 'MakN', 124 => 0x927c },
	'makernotetype' => { 420 => 0x1 },
	'makernoteunknown' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteunknownbinary' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteunknowntext' => { 122 => 'MakN', 124 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 191 => 0x0, 241 => 0x1, 333 => 0x0, 352 => 0x8000, 424 => 0x0, 427 => 0x1, 430 => [0x1d,0x1f], 443 => 0x2000 },
	'makerurl' => { 413 => "\xa9mal" },
	'managedfrom' => { 547 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 547 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 547 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 547 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 547 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 547 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 547 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 547 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 547 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 547 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 547 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 547 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 547 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 547 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 547 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 547 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 547 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 547 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 547 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 547 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 547 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 547 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 547 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 547 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 547 => 'Manager' },
	'managervariant' => { 547 => 'ManagerVariant' },
	'manageto' => { 547 => 'ManageTo' },
	'manageui' => { 547 => 'ManageUI' },
	'manifest' => { 547 => 'Manifest' },
	'manifestlinkform' => { 547 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 547 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 547 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 547 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 547 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 547 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 547 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 547 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 547 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 547 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 547 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 547 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 547 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 547 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 547 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 547 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 547 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 547 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 547 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 547 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 547 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 547 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 547 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 547 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 547 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 547 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 547 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 547 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 328 => 0x900, 352 => 0x86 },
	'manometerreading' => { 328 => 0x901 },
	'manualafpointselectpattern' => { 89 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 331 => 0x1209 },
	'manualflashoutput' => { 36 => 0x29, 309 => '8.2', 312 => '22.2', 313 => '23.1', 314 => '23.2', 316 => '16.2', 317 => '23.2', 318 => '8.2', 319 => '23.2', 322 => '24.2', 420 => 0x100c },
	'manualflashstrength' => { 328 => 0x406 },
	'manualfocusdistance' => { 241 => 0x85, 333 => 0x100c, 429 => 0x223 },
	'manualfocuspointillumination' => { 323 => 0x17, 324 => 0x17, 325 => 0x17, 326 => 0x17 },
	'manualfocusringinafmode' => { 323 => 0x1b, 324 => 0x1a, 325 => 0x1a, 326 => 0x1a },
	'manualtv' => { 88 => 0x5, 89 => 0x705 },
	'manufacturedate' => { 196 => 0x6705, 367 => 0x1 },
	'manufacturedate1' => { 422 => 0x4 },
	'manufacturedate2' => { 422 => 0x5 },
	'manufacturer' => { 502 => 'Manufacturer', 535 => 'manufacturer' },
	'mariahchromablursize' => { 143 => 0xf0d },
	'mariahmaphithreshold' => { 143 => 0xf0c },
	'mariahmaplothreshold' => { 143 => 0xf0b },
	'mariahsigmathreshold' => { 143 => 0xf0e },
	'mariahtexturethreshold' => { 143 => 0xf0a },
	'marked' => { 533 => 'Marked', 550 => 'Marked' },
	'markers' => { 546 => 'markers' },
	'markerscomment' => { 546 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 546 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 546 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 546 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 546 => [\'markers','markersCuePointType'] },
	'markersduration' => { 546 => [\'markers','markersDuration'] },
	'markerslocation' => { 546 => [\'markers','markersLocation'] },
	'markersname' => { 546 => [\'markers','markersName'] },
	'markersprobability' => { 546 => [\'markers','markersProbability'] },
	'markersspeaker' => { 546 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 546 => [\'markers','markersStartTime'] },
	'markerstarget' => { 546 => [\'markers','markersTarget'] },
	'markerstype' => { 546 => [\'markers','markersType'] },
	'maskedareas' => { 124 => 0xc68e },
	'maskgroupbasedcorractive' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 517 => 'MaskGroupBasedCorrections', 519 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 517 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 519 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 136 => 0xb9 },
	'mastergain' => { 266 => 0x50 },
	'materialsample' => { 123 => 'MaterialSample' },
	'materialsampleid' => { 123 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 308 => '50.1', 310 => '48.1', 311 => '48.1', 320 => '48.1', 321 => '48.1', 324 => 0x233, 325 => 0x233, 326 => 0x24b },
	'matrixselectk' => { 143 => 0x91b },
	'matrixselectthreshold' => { 143 => 0x91a },
	'matrixselectthreshold1' => { 143 => 0x91e },
	'matrixselectthreshold2' => { 143 => 0x91f },
	'matrixstructure' => { 412 => 0xa },
	'maxaperture' => { 36 => 0x1a, 143 => 0x3f9, 149 => 0x6103, 168 => 'MaxAperture', 186 => 0x17, 192 => 0x49c5, 239 => 0x36, 329 => 0x20a, 378 => '14.1' },
	'maxapertureatmaxfocal' => { 132 => 0x1407, 168 => 'MaxApertureAtMaxFocal', 233 => 0xb, 234 => 0x10, 235 => 0x11, 239 => 0x12, 329 => 0x206 },
	'maxapertureatminfocal' => { 132 => 0x1406, 233 => 0xa, 234 => 0xf, 235 => 0x10, 239 => 0x11, 329 => 0x205 },
	'maxaperturevalue' => { 124 => 0x9205, 397 => 0x414, 523 => 'MaxApertureValue' },
	'maxavailheight' => { 531 => 'MaxAvailHeight' },
	'maxavailwidth' => { 531 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 307 => 0xb, 308 => 0xc, 310 => '12.1', 311 => '12.1', 316 => 0xc, 317 => 0xb, 320 => '12.1', 321 => '12.1', 323 => 0x41, 324 => 0x3d, 325 => 0x3d, 326 => 0x3d },
	'maxfaces' => { 332 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 36 => 0x17, 132 => 0x1405, 168 => 'MaxFocalLength', 233 => 0x9, 234 => 0xe, 235 => 0xf, 239 => 0x10, 329 => 0x208, 467 => 0x127c, 468 => 0x1138, 469 => 0x330, 470 => 0x330, 471 => 0x30e },
	'maxfocallength2' => { 65 => 0x9 },
	'maximumdensityrange' => { 138 => 0x8c },
	'maxpagesize' => { 551 => 'MaxPageSize' },
	'maxpagesizeh' => { 551 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 551 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 551 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 143 => 0xc7d },
	'maxsamplevalue' => { 124 => 0x119 },
	'maxstorage' => { 541 => 'maxstorage' },
	'mb-d10batteries' => { 307 => '12.6' },
	'mb-d10batterytype' => { 316 => '13.3' },
	'mb-d11batterytype' => { 317 => '2.3' },
	'mb-d12batterytype' => { 320 => '3.2' },
	'mb-d80batteries' => { 318 => '6.5' },
	'mb-d80batterytype' => { 322 => '3.2' },
	'mcuversion' => { 233 => 0xc, 234 => 0x11, 235 => 0x12, 239 => 0x13 },
	'md5digest' => { 169 => 'zmd5' },
	'mditemfindercomment' => { 178 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 178 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 178 => 'MDItemFSLabel' },
	'mditemusertags' => { 178 => 'MDItemUserTags' },
	'meal' => { 538 => 'meal' },
	'measuredev' => { 28 => 0x9, 81 => 0x3, 102 => 0x1814, 161 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 81 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 192 => 0x690, 347 => 0x312, 350 => 0x312, 351 => 0x312, 354 => 0x3407 },
	'measuredrggb' => { 69 => 0x1 },
	'measuredrggbdata' => { 47 => 0x287 },
	'measurementaccuracy' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 123 => 'MeasurementOrFact' },
	'measurementremarks' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 123 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 502 => 'MeasureType' },
	'mechanicalshuttercount' => { 241 => 0x37 },
	'mediaclassprimaryid' => { 184 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 184 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 338 => 'MediaConstraints' },
	'mediacreatedate' => { 409 => 0x1 },
	'mediaeventiddate' => { 507 => 'MediaEventIdDate' },
	'mediamodifydate' => { 409 => 0x2 },
	'mediasummarycode' => { 338 => 'MediaSummaryCode' },
	'mediatype' => { 405 => 'stik' },
	'memoaudioquality' => { 89 => 0x812 },
	'memorycardconfiguration' => { 446 => 0x16 },
	'memorycardnumber' => { 218 => 0x2 },
	'menubuttondisplayposition' => { 87 => 0xb, 90 => 0xa, 91 => 0xb, 94 => 0xb },
	'menubuttonreturn' => { 95 => 0xb },
	'menumonitorofftime' => { 307 => '26.1', 308 => '22.1', 310 => '22.1', 311 => '22.1', 315 => '21.1', 316 => '8.2', 317 => '21.1', 320 => '22.1', 321 => '22.1', 322 => '22.1', 323 => 0x39, 324 => 0x35, 325 => 0x35, 326 => 0x35 },
	'mergedimages' => { 352 => 0x76 },
	'metadataauthority' => { 531 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 531 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 531 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 544 => 'MetadataDate' },
	'metadataeditingsoftware' => { 124 => 0xa43c, 524 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 531 => 'metadataLastEdited' },
	'metadatalasteditor' => { 531 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 531 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 531 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 546 => 'metadataModDate' },
	'metaversion' => { 462 => 0x34 },
	'meterinfo1row1' => { 455 => 0x0, 456 => 0x0 },
	'meterinfo1row2' => { 455 => 0x6c, 456 => 0x5a },
	'meterinfo1row3' => { 455 => 0xd8, 456 => 0xb4 },
	'meterinfo1row4' => { 455 => 0x144, 456 => 0x10e },
	'meterinfo1row5' => { 455 => 0x1b0, 456 => 0x168 },
	'meterinfo1row6' => { 455 => 0x21c, 456 => 0x1c2 },
	'meterinfo1row7' => { 455 => 0x288, 456 => 0x21c },
	'meterinfo2row1' => { 455 => 0x2f4, 456 => 0x276 },
	'meterinfo2row2' => { 455 => 0x378, 456 => 0x2e4 },
	'meterinfo2row3' => { 455 => 0x3fc, 456 => 0x352 },
	'meterinfo2row4' => { 455 => 0x480, 456 => 0x3c0 },
	'meterinfo2row5' => { 455 => 0x504, 456 => 0x42e },
	'meterinfo2row6' => { 455 => 0x588, 456 => 0x49c },
	'meterinfo2row7' => { 455 => 0x60c, 456 => 0x50a },
	'meterinfo2row8' => { 455 => 0x690, 456 => 0x578 },
	'meterinfo2row9' => { 455 => 0x714, 456 => 0x5e6 },
	'metering' => { 309 => '6.1' },
	'meteringmode' => { 36 => 0x11, 124 => 0x9207, 145 => 0x1c, 186 => 0x7, 187 => 0x25, 189 => 0x12, 328 => 0x202, 388 => 0x17, 430 => 0x9, 440 => 0x15, 441 => 0x13, 442 => 0x7, 459 => 0x3, 463 => 0x1174, 464 => 0x1178, 465 => 0x1154, 466 => 0x11d0, 467 => 0x11ac, 468 => 0x1064, 469 => 0x25c, 470 => 0x25c, 471 => 0x24b, 523 => 'MeteringMode' },
	'meteringmode2' => { 368 => '2.1', 454 => 0x202c },
	'meteringmode3' => { 368 => '16.1' },
	'meteringoffscaleindicator' => { 189 => 0x53 },
	'meteringtime' => { 307 => '22.2', 309 => '3.2', 312 => '17.1', 313 => '18.1', 316 => '7.3', 317 => '18.1', 318 => '3.2', 322 => '19.1' },
	'micro1version' => { 415 => 0x1f },
	'micro2version' => { 415 => 0x2d },
	'microphoneattenuator' => { 247 => 0x34e, 248 => 0x34e, 249 => 0x2d2, 250 => 0x2fa, 251 => 0x2fa },
	'microphonefrequencyresponse' => { 247 => 0x350, 248 => 0x350, 249 => 0x2d4, 250 => 0x2fc, 251 => 0x2fc },
	'microphonejackpower' => { 247 => 0x376, 248 => 0x376, 249 => 0x2fa, 250 => 0x322, 251 => 0x322 },
	'microphonesensitivity' => { 247 => 0x34c, 248 => 0x34c, 249 => 0x2d0, 250 => 0x2f8, 251 => 0x2f8 },
	'microvideo' => { 499 => 'MicroVideo' },
	'microvideooffset' => { 499 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 499 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 499 => 'MicroVideoVersion' },
	'midrangesharpness' => { 260 => 0x3b },
	'mieversion' => { 169 => '0Vers' },
	'mime' => { 502 => 'Mime' },
	'minaperture' => { 36 => 0x1b, 143 => 0x3f8, 168 => 'MinAperture', 378 => '0.2' },
	'minaperturevalue' => { 397 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 36 => 0x18, 132 => 0x1404, 168 => 'MinFocalLength', 233 => 0x8, 234 => 0xd, 235 => 0xe, 239 => 0xf, 329 => 0x207, 467 => 0x127a, 468 => 0x1136, 469 => 0x32e, 470 => 0x32e, 471 => 0x30c },
	'minfocallength2' => { 65 => 0x8 },
	'minfocusdistance' => { 378 => 0x3 },
	'minimumiso' => { 352 => 0xe8 },
	'minintegrationrows' => { 143 => 0x1874 },
	'minoltadate' => { 186 => 0x15 },
	'minoltaimagesize' => { 186 => 0x4, 187 => 0xc, 188 => 0x2, 191 => 0x103 },
	'minoltamodelid' => { 186 => 0x25 },
	'minoltaquality' => { 186 => 0x5, 187 => 0xd, 188 => 0x3, 191 => [0x102,0x103] },
	'minoltatime' => { 186 => 0x16 },
	'minormodelagedisclosure' => { 338 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 407 => 'minor_version', 508 => 'MinorVersion' },
	'minsamplevalue' => { 124 => 0x118 },
	'mirrorlockup' => { 87 => 0xc, 88 => 0xc, 89 => 0x60f, 90 => 0xb, 91 => 0xc, 92 => 0x6, 93 => 0x6, 94 => 0xc, 95 => 0x3 },
	'mobilecountrycode' => { 516 => 'mcc' },
	'mobilenetworkcode' => { 516 => 'mnc' },
	'moddate' => { 341 => 'modify-date', 533 => 'ModDate' },
	'modedialposition' => { 446 => 0x14 },
	'model' => { 103 => 0x6, 124 => 0x110, 161 => 'Model', 341 => 'Model', 357 => 0x110, 388 => 0x23f, 407 => 'model', 413 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 430 => 0x84, 502 => 'Model', 535 => 'model', 542 => 'Model' },
	'modelage' => { 531 => 'ModelAge' },
	'modelid' => { 327 => 0x0 },
	'modelingflash' => { 307 => '21.4', 308 => '31.1', 310 => '31.1', 311 => '31.1', 316 => '26.4', 317 => '30.2', 318 => '7.4', 319 => '30.1', 320 => '31.1', 321 => '31.1', 322 => '31.3', 323 => 0x61, 324 => 0x5d, 325 => 0x5d, 326 => 0x5d },
	'modelreleaseid' => { 338 => 'ModelReleaseID' },
	'modelreleasestatus' => { 338 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 477 => 0x52, 478 => 0x46, 479 => 0x53 },
	'modeltiepoint' => { 124 => 0x8482 },
	'modeltransform' => { 124 => 0x85d8 },
	'modelyear' => { 535 => 'modelYear' },
	'modificationdate' => { 536 => 'modificationDate' },
	'modifiedcolortemp' => { 70 => 0x9 },
	'modifieddigitalgain' => { 70 => 0xb },
	'modifiedparamflag' => { 61 => 0x1 },
	'modifiedpicturestyle' => { 70 => 0xa },
	'modifiedsaturation' => { 328 => 0x504 },
	'modifiedsensorbluelevel' => { 70 => 0x5 },
	'modifiedsensorredlevel' => { 70 => 0x4 },
	'modifiedsharpness' => { 70 => 0x2 },
	'modifiedsharpnessfreq' => { 70 => 0x3 },
	'modifiedtonecurve' => { 70 => 0x1 },
	'modifiedwhitebalance' => { 70 => 0x8 },
	'modifiedwhitebalanceblue' => { 70 => 0x7 },
	'modifiedwhitebalancered' => { 70 => 0x6 },
	'modifydate' => { 124 => 0x132, 162 => 'ModifyDate', 337 => 'ModDate', 339 => 'tIME', 404 => 'ModDate', 410 => 0x2, 544 => 'ModifyDate' },
	'moirefilter' => { 124 => 0xfe58, 517 => 'MoireFilter', 519 => 'MoireFilter' },
	'monitorbrightness' => { 245 => 0x904, 247 => 0x69a, 248 => 0x6aa, 249 => 0x59a, 250 => 0x5ca, 251 => 0x5e2 },
	'monitordisplayoff' => { 189 => 0x4c },
	'monitormatrix' => { 143 => 0x8fc },
	'monitorofftime' => { 307 => '18.2', 309 => '3.1', 318 => '3.1' },
	'monochromecolor' => { 328 => 0x53b },
	'monochromecontrast' => { 114 => 0x3c },
	'monochromefiltereffect' => { 108 => 0x20307, 114 => 0x3a, 352 => 0xac, 388 => 0x73 },
	'monochromegraineffect' => { 352 => 0xd2 },
	'monochromelinear' => { 114 => 0x3d },
	'monochromeoutputhighlightpoint' => { 114 => 0x41 },
	'monochromeoutputshadowpoint' => { 114 => 0x42 },
	'monochromeprofilesettings' => { 328 => 0x537 },
	'monochromerawhighlight' => { 114 => 0x7a },
	'monochromerawhighlightpoint' => { 114 => 0x3f },
	'monochromerawshadow' => { 114 => 0x83 },
	'monochromerawshadowpoint' => { 114 => 0x40 },
	'monochromesharpness' => { 114 => 0x3e },
	'monochrometoning' => { 388 => 0x74 },
	'monochrometoningeffect' => { 108 => 0x20306, 114 => 0x3b },
	'monochromeunsharpmaskfineness' => { 114 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 114 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 114 => 0xb4 },
	'monochromevignetting' => { 328 => 0x53a },
	'monthdaycreated' => { 145 => 0x12, 154 => 0xe },
	'mood' => { 184 => 'WM/Mood' },
	'moonphase' => { 414 => 0x12, 415 => 0x43, 416 => 0x4c },
	'morepermissions' => { 515 => 'morePermissions' },
	'motionphoto' => { 499 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 499 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 499 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 408 => 'mpvd' },
	'motionsensitivity' => { 414 => 0x29, 416 => 0x60 },
	'movementcount' => { 405 => "\xa9mvc" },
	'movementname' => { 405 => "\xa9mvn" },
	'movementnumber' => { 405 => "\xa9mvi" },
	'movieactived-lighting' => { 246 => 0x238, 247 => 0x334, 248 => 0x334, 249 => 0x2b8, 250 => 0x2e0, 251 => 0x2e0 },
	'movieaelockbuttonassignment' => { 320 => '40.1' },
	'movieaf-onbutton' => { 323 => 0xd3, 324 => 0xcb, 325 => 0xcb, 326 => 0xcb },
	'movieafareamode' => { 247 => 0x342, 248 => 0x342, 249 => 0x2c6, 250 => 0x2ee, 251 => 0x2ee, 324 => 0x203, 325 => 0x203, 326 => 0x21b },
	'movieafspeed' => { 323 => 0xe5, 324 => 0xdd, 325 => 0xdd, 326 => 0xdd },
	'movieafspeedapply' => { 323 => 0xe7, 324 => 0xdf, 325 => 0xdf, 326 => 0xdf },
	'movieaftrackingsensitivity' => { 323 => 0xe9, 324 => 0xe1, 325 => 0xe1, 326 => 0xe1 },
	'movieaperturelock' => { 324 => 0x259, 325 => 0x259, 326 => 0x271 },
	'movieautodistortioncontrol' => { 246 => 0x242 },
	'moviediffractioncompensation' => { 246 => 0x241 },
	'moviedxcropalert' => { 247 => 0x377, 248 => 0x377, 249 => 0x2fb, 250 => 0x323, 251 => 0x323 },
	'movieelectronicvr' => { 247 => 0x348, 248 => 0x348, 249 => 0x2cc, 250 => 0x2f4, 251 => 0x2f4 },
	'movieevfgrid' => { 324 => 0x21d, 325 => 0x21d, 326 => 0x235 },
	'movieflickerreduction' => { 247 => 0x33c, 248 => 0x33c, 249 => 0x2c0, 250 => 0x2e8, 251 => 0x2e8 },
	'moviefocusmode' => { 246 => 0x248, 247 => 0x340, 248 => 0x340, 249 => 0x2c4, 250 => 0x2ec, 251 => 0x2ec },
	'moviefocuspointlock' => { 324 => 0x226, 325 => 0x226, 326 => 0x23e },
	'movieframerate' => { 245 => 0x48c, 246 => 0x1f8, 247 => 0x374, 248 => 0x370, 249 => 0x2f4, 250 => 0x31c, 251 => 0x31c },
	'movieframesize' => { 245 => 0x48a, 246 => 0x1f6, 247 => 0x372, 248 => 0x36e, 249 => 0x2f2, 250 => 0x31a, 251 => 0x31a },
	'moviefunc1button' => { 310 => '41.1', 311 => '41.1', 321 => '41.1', 323 => 0xc7, 324 => 0xc3, 325 => 0xc3, 326 => 0xc3 },
	'moviefunc2button' => { 323 => 0xcd, 324 => 0xc7, 325 => 0xc7, 326 => 0xc7 },
	'moviefunc3button' => { 325 => 0x127, 326 => 0x13f },
	'moviefunctionbutton' => { 308 => '41.1', 320 => '41.1' },
	'moviefunctionbuttonplusdials' => { 308 => '52.1' },
	'moviehighisonoisereduction' => { 246 => 0x23c, 247 => 0x336, 248 => 0x336, 249 => 0x2ba, 250 => 0x2e2, 251 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 324 => 0x215, 325 => 0x215, 326 => 0x22d },
	'moviehighreszoom' => { 247 => 0x380, 248 => 0x380, 250 => 0x32c, 251 => 0x32c },
	'movieimagearea' => { 247 => 0x2da, 248 => 0x2da, 249 => 0x25c, 250 => 0x286, 251 => 0x286 },
	'movieisoautocontrolmanualmode' => { 247 => 0x2e8, 248 => 0x2e8, 249 => 0x26a, 250 => 0x294, 251 => 0x294 },
	'movieisoautohilimit' => { 247 => 0x2e6, 248 => 0x2e6, 249 => 0x268, 250 => 0x292, 251 => 0x292 },
	'movieisoautomanualmode' => { 246 => 0x204, 247 => 0x2ea, 248 => 0x2ea, 249 => 0x26c, 250 => 0x296, 251 => 0x296 },
	'movielenscontrolring' => { 323 => 0xdf, 324 => 0xd7, 325 => 0xd7, 326 => 0xd7 },
	'moviemeteringmode' => { 247 => 0x33e, 248 => 0x33e, 249 => 0x2c2, 250 => 0x2ea, 251 => 0x2ea },
	'moviemidtonedisplayrange' => { 324 => 0x219, 325 => 0x219, 326 => 0x231 },
	'moviemidtonedisplayvalue' => { 324 => 0x217, 325 => 0x217, 326 => 0x22f },
	'moviemultiselector' => { 323 => 0xe1, 324 => 0xd9, 325 => 0xcf, 326 => 0xcf },
	'moviepreviewbutton' => { 308 => '41.2', 310 => '41.2', 311 => '41.2', 320 => '41.2', 321 => '41.2' },
	'moviepreviewbuttonplusdials' => { 308 => '52.2' },
	'movierecordbuttonplaybackmode' => { 323 => 0x1af, 324 => 0x1b5, 325 => 0x1b5, 326 => 0x1cd },
	'movieshutterbutton' => { 308 => '38.3', 310 => '38.3', 311 => '38.3', 320 => '38.3', 321 => '38.3' },
	'movieshutterspeedlock' => { 324 => 0x225, 325 => 0x225, 326 => 0x23d },
	'movieslowmotion' => { 245 => 0x416, 246 => 0x1fa },
	'moviesoundrecording' => { 247 => 0x34a, 248 => 0x34a, 249 => 0x2ce, 250 => 0x2f6, 251 => 0x2f6 },
	'moviesubjectdetection' => { 247 => 0x378, 248 => 0x378, 249 => 0x2fc, 250 => 0x324, 251 => 0x324 },
	'moviesubselectorassignment' => { 308 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 308 => '53.1' },
	'movietonemap' => { 249 => 0x2ec, 250 => 0x314, 251 => 0x314 },
	'movietype' => { 230 => 0x2ca, 245 => 0x41a, 246 => 0x1fe, 247 => 0x2e4, 248 => 0x2e4, 249 => 0x266, 250 => 0x290, 251 => 0x290 },
	'movievibrationreduction' => { 246 => 0x24e },
	'movievibrationreductionsameasphoto' => { 246 => 0x24f },
	'movievignettecontrol' => { 246 => 0x23e, 247 => 0x1b0, 248 => 0x1b0, 249 => 0x1a0, 250 => 0x1b4, 251 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 246 => 0x240 },
	'movievrmode' => { 247 => 0x344, 248 => 0x344, 249 => 0x2c8, 250 => 0x2f0, 251 => 0x2f0 },
	'moviezebrapattern' => { 324 => 0x213, 325 => 0x213, 326 => 0x22b },
	'multiburstimageheight' => { 454 => 0x1002 },
	'multiburstimagewidth' => { 454 => 0x1001 },
	'multiburstmode' => { 454 => 0x1000 },
	'multicontrollerwhilemetering' => { 89 => 0x517 },
	'multiexposure' => { 72 => 0x1, 352 => 0xb4 },
	'multiexposureautogain' => { 253 => 0x3 },
	'multiexposurecontrol' => { 72 => 0x2 },
	'multiexposuremode' => { 253 => 0x1, 254 => 0x1 },
	'multiexposureoverlaymode' => { 254 => 0x3 },
	'multiexposureshots' => { 72 => 0x3, 245 => 0x1be, 247 => 0x9a, 248 => 0x9a, 249 => 0x8e, 250 => 0x9c, 251 => 0x9c, 253 => 0x2, 254 => 0x2 },
	'multiframenoisereduction' => { 442 => 0x35, 454 => 0x200b, 459 => 0x15 },
	'multiframenreffect' => { 454 => 0x2023 },
	'multifunctionlock' => { 89 => 0x70f },
	'multipleexposuremode' => { 245 => 0x1bc, 247 => 0x98, 248 => 0x98, 249 => 0x8c, 250 => 0x9a, 251 => 0x9a, 332 => 0x101c },
	'multipleexposureset' => { 368 => '10.1' },
	'multisample' => { 266 => 0x40 },
	'multiselector' => { 307 => '9.4', 308 => '10.3', 310 => '10.3', 311 => '10.3', 316 => '27.4', 320 => '10.3', 321 => '10.3' },
	'multiselectorliveview' => { 307 => '4.3', 310 => '37.1', 311 => '37.1', 320 => '37.1', 321 => '37.1' },
	'multiselectorliveviewmode' => { 280 => 0x18c2 },
	'multiselectorplaybackmode' => { 307 => ['13.5','9.2'], 308 => '10.2', 311 => '10.2', 316 => '27.2', 320 => '10.2', 321 => '10.2', 323 => 0xb7, 324 => 0xb3, 325 => 0xb3, 326 => 0xb3 },
	'multiselectorshootmode' => { 307 => '9.1', 308 => '10.1', 310 => '10.1', 311 => '10.1', 316 => '27.1', 320 => '10.1', 321 => '10.1', 323 => 0xb3, 324 => 0xaf, 325 => 0xaf, 326 => 0xaf },
	'multishot' => { 357 => 0x121 },
	'mute' => { 407 => 'player.movie.audio.mute' },
	'mycolormode' => { 73 => 0x2 },
	'name' => { 413 => 'name', 517 => 'Name', 519 => 'Name' },
	'narrator' => { 405 => "\xa9nrt" },
	'nationalcatalognumber' => { 536 => 'nationalCatalogNumber' },
	'nativedigest' => { 523 => 'NativeDigest', 542 => 'NativeDigest' },
	'ndfilter' => { 81 => 0x1c, 328 => 0x204, 420 => 0x1019 },
	'near' => { 502 => 'Near' },
	'nefbitdepth' => { 241 => 0xe22 },
	'nefcompression' => { 241 => 0x93, 242 => 0xa },
	'neflinearizationtable' => { 241 => 0x96 },
	'negativecachelargepreviewsize' => { 517 => 'NegativeCacheLargePreviewSize', 519 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 517 => 'NegativeCacheMaximumSize', 519 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 517 => 'NegativeCachePath', 519 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 514 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 388 => 0x88 },
	'neutraloutputhighlightpoint' => { 114 => 0x2f },
	'neutraloutputshadowpoint' => { 114 => 0x30 },
	'neutralrawcolortone' => { 114 => 0x28 },
	'neutralrawcontrast' => { 114 => 0x2a },
	'neutralrawhighlight' => { 114 => 0x78 },
	'neutralrawhighlightpoint' => { 114 => 0x2d },
	'neutralrawlinear' => { 114 => 0x2b },
	'neutralrawsaturation' => { 114 => 0x29 },
	'neutralrawshadow' => { 114 => 0x81 },
	'neutralrawshadowpoint' => { 114 => 0x2e },
	'neutralrawsharpness' => { 114 => 0x2c },
	'neutralunsharpmaskfineness' => { 114 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 114 => 0xa8 },
	'neutraunsharpmaskstrength' => { 114 => 0xa4 },
	'newlensdata' => { 239 => 0x2f },
	'newrawimagedigest' => { 124 => 0xc7a7 },
	'newsphotoversion' => { 138 => 0x0 },
	'nickname' => { 544 => 'Nickname' },
	'nikoncapturedata' => { 241 => 0xe01 },
	'nikoncaptureeditversions' => { 241 => 0xe13 },
	'nikoncaptureoffsets' => { 241 => 0xe0e },
	'nikoncaptureoutput' => { 241 => 0xe1e },
	'nikoncaptureversion' => { 241 => 0xe09 },
	'nikoniccprofile' => { 241 => 0xe1d },
	'nikonimagesize' => { 277 => '723.1', 278 => '732.1', 286 => 0x2c4 },
	'nikonmeteringmode' => { 204 => 0x17, 245 => 0x2d2, 246 => 0x146, 257 => 0x214 },
	'nikonsettings' => { 241 => 0x4e },
	'noisefilter' => { 328 => 0x527 },
	'noiseprofile' => { 124 => 0xc761 },
	'noisereduction' => { 132 => [0x100b,0x100e], 187 => 0xb0, 188 => 0x60, 189 => 0x3f, 241 => 0x95, 300 => 0x753dcbc0, 301 => 0x17, 328 => 0x50a, 333 => 0x103a, 352 => 0x2d, 388 => 0x49, 420 => 0x100f, 422 => 0x2a },
	'noisereduction2' => { 332 => 0x1010 },
	'noisereductionapplied' => { 124 => 0xc6f7 },
	'noisereductionintensity' => { 301 => 0x9 },
	'noisereductionmethod' => { 301 => 0x11 },
	'noisereductionmode' => { 491 => 0x801e },
	'noisereductionparametersatcapture' => { 143 => 0xe73 },
	'noisereductionparameterscamera' => { 143 => 0xe72 },
	'noisereductionparametershost3mp' => { 143 => 0xe71 },
	'noisereductionparametershost6mp' => { 143 => 0xe70 },
	'noisereductionparametershostrgb' => { 143 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 143 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 143 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 143 => 0xe63 },
	'noisereductionparams' => { 357 => 0x1b },
	'noisereductionsharpness' => { 301 => 0xd },
	'noisereductionstrength' => { 352 => 0xd6 },
	'noisereductionvalue' => { 491 => 0x8027 },
	'nomemorycard' => { 307 => '22.1', 308 => '4.2', 309 => '0.3', 312 => '2.4', 313 => '3.2', 314 => '3.2', 316 => '33.7', 317 => '3.2', 318 => '0.3', 320 => '4.2', 322 => '4.5' },
	'nominalmaxaperture' => { 378 => 0xa },
	'nominalminaperture' => { 378 => '10.1' },
	'noncpulens10focallength' => { 247 => 0x6c6, 248 => 0x6d6, 251 => 0x620 },
	'noncpulens10maxaperture' => { 247 => 0x6ee, 248 => 0x738, 251 => 0x670 },
	'noncpulens11focallength' => { 247 => 0x6c8, 248 => 0x6d8, 251 => 0x624 },
	'noncpulens11maxaperture' => { 247 => 0x6f0, 248 => 0x73c, 251 => 0x674 },
	'noncpulens12focallength' => { 247 => 0x6ca, 248 => 0x6da, 251 => 0x628 },
	'noncpulens12maxaperture' => { 247 => 0x6f2, 248 => 0x740, 251 => 0x678 },
	'noncpulens13focallength' => { 247 => 0x6cc, 248 => 0x6dc, 251 => 0x62c },
	'noncpulens13maxaperture' => { 247 => 0x6f4, 248 => 0x744, 251 => 0x67c },
	'noncpulens14focallength' => { 247 => 0x6ce, 248 => 0x6de, 251 => 0x630 },
	'noncpulens14maxaperture' => { 247 => 0x6f6, 248 => 0x748, 251 => 0x680 },
	'noncpulens15focallength' => { 247 => 0x6d0, 248 => 0x6e0, 251 => 0x634 },
	'noncpulens15maxaperture' => { 247 => 0x6f8, 248 => 0x74c, 251 => 0x684 },
	'noncpulens16focallength' => { 247 => 0x6d2, 248 => 0x6e2, 251 => 0x638 },
	'noncpulens16maxaperture' => { 247 => 0x6fa, 248 => 0x750, 251 => 0x688 },
	'noncpulens17focallength' => { 247 => 0x6d4, 248 => 0x6e4, 251 => 0x63c },
	'noncpulens17maxaperture' => { 247 => 0x6fc, 248 => 0x754, 251 => 0x68c },
	'noncpulens18focallength' => { 247 => 0x6d6, 248 => 0x6e6, 251 => 0x640 },
	'noncpulens18maxaperture' => { 247 => 0x6fe, 248 => 0x758, 251 => 0x690 },
	'noncpulens19focallength' => { 247 => 0x6d8, 248 => 0x6e8, 251 => 0x644 },
	'noncpulens19maxaperture' => { 247 => 0x700, 248 => 0x75c, 251 => 0x694 },
	'noncpulens1focallength' => { 247 => 0x6b4, 248 => 0x6c4, 251 => 0x5fc },
	'noncpulens1maxaperture' => { 247 => 0x6dc, 248 => 0x714, 251 => 0x64c },
	'noncpulens20focallength' => { 247 => 0x6da, 248 => 0x6ea, 251 => 0x648 },
	'noncpulens20maxaperture' => { 247 => 0x702, 248 => 0x760, 251 => 0x698 },
	'noncpulens2focallength' => { 247 => 0x6b6, 248 => 0x6c6, 251 => 0x600 },
	'noncpulens2maxaperture' => { 247 => 0x6de, 248 => 0x718, 251 => 0x650 },
	'noncpulens3focallength' => { 247 => 0x6b8, 248 => 0x6c8, 251 => 0x604 },
	'noncpulens3maxaperture' => { 247 => 0x6e0, 248 => 0x71c, 251 => 0x654 },
	'noncpulens4focallength' => { 247 => 0x6ba, 248 => 0x6ca, 251 => 0x608 },
	'noncpulens4maxaperture' => { 247 => 0x6e2, 251 => 0x658 },
	'noncpulens5focallength' => { 247 => 0x6bc, 248 => 0x6cc, 251 => 0x60c },
	'noncpulens5maxaperture' => { 247 => 0x6e4, 248 => 0x724, 251 => 0x65c },
	'noncpulens6focallength' => { 247 => 0x6be, 248 => 0x6ce, 251 => 0x610 },
	'noncpulens6maxaperture' => { 247 => 0x6e6, 248 => 0x728, 251 => 0x660 },
	'noncpulens7focallength' => { 247 => 0x6c0, 248 => 0x6d0, 251 => 0x614 },
	'noncpulens7maxaperture' => { 247 => 0x6e8, 248 => 0x72c, 251 => 0x664 },
	'noncpulens8focallength' => { 247 => 0x6c2, 248 => 0x6d2, 251 => 0x618 },
	'noncpulens8maxaperture' => { 247 => 0x6ea, 248 => 0x730, 251 => 0x668 },
	'noncpulens9focallength' => { 247 => 0x6c4, 248 => 0x6d4, 251 => 0x61c },
	'noncpulens9maxaperture' => { 247 => 0x6ec, 248 => 0x734, 251 => 0x66c },
	'normalizedcropcorners' => { 342 => 'NormalizedCropCorners' },
	'normallinetime' => { 143 => 0x186a },
	'normalwhitelevel' => { 43 => 0x32a, 44 => 0x280, 45 => 0x294, 48 => [0x2b8,0x2cf,0x2d3], 49 => 0x569, 50 => 0x1e3, 51 => [0x1fc,0x2dc], 52 => [0x230,0x30e], 53 => 0x31c },
	'notes' => { 493 => 'Notes', 512 => 'notes' },
	'npages' => { 551 => 'NPages' },
	'nullrecord' => { 102 => 0x0 },
	'numafpoints' => { 364 => 0x2 },
	'number' => { 536 => 'number' },
	'numberofbeats' => { 546 => 'numberOfBeats' },
	'numberoffocuspoints' => { 310 => '1.3', 311 => '1.3', 314 => '0.2', 315 => '0.3', 317 => '0.3' },
	'numfaceelements' => { 132 => 0x4200 },
	'numfacepositions' => { 344 => 0x0 },
	'numindexentries' => { 138 => 0x54 },
	'numwbentries' => { 358 => 0x0, 359 => 0x0 },
	'object' => { 536 => 'object' },
	'objectattributereference' => { 136 => 0x4 },
	'objectcycle' => { 136 => 0x4b, 512 => 'ObjectCycle' },
	'objectdescription' => { 535 => 'objectDescription' },
	'objectdistance' => { 117 => 0x6, 118 => 0x2022 },
	'objectname' => { 136 => 0x5 },
	'objectpreviewdata' => { 136 => 0xca },
	'objectpreviewfileformat' => { 136 => 0xc8 },
	'objectpreviewfileversion' => { 136 => 0xc9 },
	'objectsubtype' => { 535 => 'objectSubtype' },
	'objecttype' => { 535 => 'objectType' },
	'objecttypereference' => { 136 => 0x3 },
	'occurrence' => { 123 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 123 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 123 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 123 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 123 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 123 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 123 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 123 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 123 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 123 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 123 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 123 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 123 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 123 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 123 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 123 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 123 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 123 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 123 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 123 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 123 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 123 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 123 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 123 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 123 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 123 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 123 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 123 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 123 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 123 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 523 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 523 => [\'OECF','OECFNames'] },
	'oecfrows' => { 523 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 523 => [\'OECF','OECFValues'] },
	'offsaledate' => { 536 => 'offSaleDate' },
	'offsaledatea-platform' => { 536 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 536 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 143 => 0x190a },
	'offsethdr' => { 528 => 'OffsetHDR' },
	'offsetschema' => { 124 => 0xea1d },
	'offsetsdr' => { 528 => 'OffsetSDR' },
	'offsettime' => { 124 => 0x9010 },
	'offsettimedigitized' => { 124 => 0x9012 },
	'offsettimeoriginal' => { 124 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 317 => '15.1', 322 => '16.1' },
	'oldsubfiletype' => { 124 => 0xff },
	'olympusimageheight' => { 333 => 0x102f },
	'olympusimagewidth' => { 333 => 0x102e },
	'omenatcapturestrength' => { 143 => 0xa60 },
	'omenautostrength' => { 143 => 0xa5f },
	'omenearlystrength' => { 143 => 0xa5e },
	'omenfocallengthlimit' => { 143 => 0xa62 },
	'omeninitialipfstrength' => { 143 => 0xa5d },
	'omensurfaceindex' => { 143 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 333 => 0x302 },
	'onsaledate' => { 536 => 'onSaleDate' },
	'onsaledatea-platform' => { 536 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 536 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 536 => 'onSaleDay' },
	'onsaledaya-platform' => { 536 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 536 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 124 => 0xc740 },
	'opcodelist2' => { 124 => 0xc741 },
	'opcodelist3' => { 124 => 0xc74e },
	'opticalzoom' => { 147 => 0xfa3d, 149 => [0x6006,0xf006], 150 => 0x1000, 151 => 0xf, 154 => 0x1e, 156 => 0x20, 157 => 0x1c, 168 => 'OpticalZoom' },
	'opticalzoomcode' => { 81 => 0xa },
	'opticalzoommode' => { 352 => 0x34 },
	'opticalzoomon' => { 429 => 0x219 },
	'optionenddate' => { 539 => 'optionEndDate' },
	'opto-electricconvfactor' => { 523 => 'OECF' },
	'orangehsl' => { 108 => 0x20911 },
	'ordernumber' => { 132 => 0x8002 },
	'organisationinimagecode' => { 531 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 531 => 'OrganisationInImageName' },
	'organism' => { 123 => 'Organism' },
	'organismassociatedoccurrences' => { 123 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 123 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 123 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 123 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 123 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 123 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 123 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 536 => 'organization' },
	'orientation' => { 124 => 0x112, 357 => 0x112, 535 => 'orientation', 542 => 'Orientation' },
	'orientation2' => { 459 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 89 => 0x516 },
	'originalalbumtitle' => { 184 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 184 => 'WM/OriginalArtist', 405 => "\xa9ope" },
	'originalbestqualitysize' => { 124 => 0xc792 },
	'originalcreatedatetime' => { 507 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 119 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 68 => 0x83 },
	'originaldefaultcropsize' => { 124 => 0xc793 },
	'originaldefaultfinalsize' => { 124 => 0xc791 },
	'originaldirectory' => { 349 => 0x408 },
	'originaldocumentid' => { 547 => 'OriginalDocumentID' },
	'originalfilename' => { 102 => 0x816, 143 => 0x3e9, 155 => 0x20, 349 => 0x407, 507 => 'OriginalFilename' },
	'originalimagehash' => { 496 => 'OriginalImageHash' },
	'originalimagehashtype' => { 496 => 'OriginalImageHashType' },
	'originalimageheight' => { 83 => 0xc, 128 => 0x1 },
	'originalimagemd5' => { 496 => 'OriginalImageMD5' },
	'originalimagesize' => { 167 => 'OriginalImageSize' },
	'originalimagewidth' => { 83 => 0xb, 128 => 0x0 },
	'originallyricist' => { 184 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 124 => 0xc68c },
	'originalrawfiledigest' => { 124 => 0xc71d },
	'originalrawfilename' => { 124 => 0xc68b },
	'originaltransmissionreference' => { 136 => 0x67 },
	'originatingprogram' => { 136 => 0x41, 512 => 'OriginatingProgram' },
	'originplatform' => { 536 => 'originPlatform' },
	'os' => { 521 => 'os' },
	'otherconditions' => { 338 => 'OtherConditions' },
	'otherconstraints' => { 338 => 'OtherConstraints' },
	'otherimage' => { 119 => 'Exif-OtherImage' },
	'otherimageinfo' => { 338 => 'OtherImageInfo' },
	'otherimagelength' => { 124 => 0x202 },
	'otherimagestart' => { 124 => 0x201 },
	'otherlicensedocuments' => { 338 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 338 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 338 => 'OtherLicenseRequirements' },
	'outcue' => { 546 => 'outCue' },
	'outcuescale' => { 546 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 546 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 205 => 0x3 },
	'outputimagewidth' => { 205 => 0x2 },
	'outputlut' => { 352 => 0xa7 },
	'outputprofile' => { 143 => 0x138b },
	'outputresolution' => { 205 => 0x4 },
	'overclockcols' => { 143 => 0x189c },
	'overclockrows' => { 143 => 0x18c4 },
	'overridelookvignette' => { 517 => 'OverrideLookVignette', 519 => 'OverrideLookVignette' },
	'owner' => { 405 => 'ownr', 550 => 'Owner' },
	'ownerid' => { 136 => 0xbc },
	'ownername' => { 15 => 0x10f, 68 => 0x9, 102 => 0x810, 124 => [0xa430,0xfde8], 161 => 'OwnerName', 514 => 'OwnerName', 524 => 'CameraOwnerName' },
	'padding' => { 124 => 0xea1c },
	'pagecount' => { 536 => 'pageCount' },
	'pageimage' => { 544 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 544 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 544 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 544 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 544 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 544 => 'PageInfo' },
	'pagename' => { 124 => 0x11d },
	'pagenumber' => { 124 => 0x129 },
	'pageprogressiondirection' => { 536 => 'pageProgressionDirection' },
	'pagerange' => { 536 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 517 => 'PaintBasedCorrections', 519 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 517 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 519 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 355 => 0x0 },
	'panasonicexifversion' => { 352 => 0x26 },
	'panasonicimageheight' => { 352 => 0x4c },
	'panasonicimagewidth' => { 352 => 0x4b },
	'panasonicrawversion' => { 357 => 0x1 },
	'panasonictitle' => { 124 => 0xc6d2 },
	'panasonictitle2' => { 124 => 0xc6d3 },
	'panoramaangle' => { 132 => 0x1153 },
	'panoramacropbottom' => { 460 => 0x7 },
	'panoramacropleft' => { 460 => 0x4 },
	'panoramacropright' => { 460 => 0x6 },
	'panoramacroptop' => { 460 => 0x5 },
	'panoramadirection' => { 76 => 0x5, 132 => 0x1154, 460 => 0x3 },
	'panoramaframeheight' => { 460 => 0x9 },
	'panoramaframenumber' => { 76 => 0x2 },
	'panoramaframewidth' => { 460 => 0x8 },
	'panoramafullheight' => { 460 => 0x2 },
	'panoramafullwidth' => { 460 => 0x1 },
	'panoramamode' => { 145 => 0x3c, 328 => 0x601 },
	'panoramasize3d' => { 442 => 0x38 },
	'panoramasourceheight' => { 460 => 0xb },
	'panoramasourcewidth' => { 460 => 0xa },
	'panoramicstitchcameramotion' => { 181 => 'PanoramicStitchCameraMotion', 182 => 0x1 },
	'panoramicstitchmaptype' => { 181 => 'PanoramicStitchMapType', 182 => 0x2 },
	'panoramicstitchphi0' => { 181 => 'PanoramicStitchPhi0', 182 => 0x5 },
	'panoramicstitchphi1' => { 181 => 'PanoramicStitchPhi1', 182 => 0x6 },
	'panoramicstitchtheta0' => { 181 => 'PanoramicStitchTheta0', 182 => 0x3 },
	'panoramicstitchtheta1' => { 181 => 'PanoramicStitchTheta1', 182 => 0x4 },
	'panoramicstitchversion' => { 182 => 0x0 },
	'pantry' => { 547 => 'Pantry' },
	'pantryinstanceid' => { 547 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 132 => 0xb211, 327 => 0x28 },
	'parameters' => { 341 => 'parameters' },
	'parametricdarks' => { 517 => 'ParametricDarks', 519 => 'ParametricDarks' },
	'parametrichighlights' => { 517 => 'ParametricHighlights', 519 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 517 => 'ParametricHighlightSplit', 519 => 'ParametricHighlightSplit' },
	'parametriclights' => { 517 => 'ParametricLights', 519 => 'ParametricLights' },
	'parametricmidtonesplit' => { 517 => 'ParametricMidtoneSplit', 519 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 517 => 'ParametricShadows', 519 => 'ParametricShadows' },
	'parametricshadowsplit' => { 517 => 'ParametricShadowSplit', 519 => 'ParametricShadowSplit' },
	'parentalrating' => { 184 => 'WM/ParentalRating' },
	'parentid' => { 531 => 'parentId' },
	'parentmediaeventid' => { 507 => 'ParentMediaEventID' },
	'parentmeid' => { 507 => 'ParentMEID' },
	'parentproductid' => { 405 => '@ppi' },
	'parentreference1' => { 529 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 529 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 405 => '@PST' },
	'parenttitle' => { 405 => '@pti' },
	'partialactivecols1' => { 143 => 0x17e8 },
	'partialactivecols2' => { 143 => 0x17f2 },
	'partialactiverows1' => { 143 => 0x17fc },
	'partialactiverows2' => { 143 => 0x1806 },
	'partofcompilation' => { 546 => 'partOfCompilation' },
	'patientbirthdate' => { 494 => 'PatientDOB' },
	'patientid' => { 494 => 'PatientID' },
	'patientname' => { 494 => 'PatientName' },
	'patientsex' => { 494 => 'PatientSex' },
	'patternareaheight' => { 143 => 0x963 },
	'patternareawidth' => { 143 => 0x962 },
	'patterncorrectionfactorscale' => { 143 => 0x969 },
	'patterncropcols1' => { 143 => 0x96c },
	'patterncropcols2' => { 143 => 0x96d },
	'patterncroprows1' => { 143 => 0x96a },
	'patterncroprows2' => { 143 => 0x96b },
	'patternimagerheight' => { 143 => 0x961 },
	'patternimagerwidth' => { 143 => 0x960 },
	'patternx' => { 143 => 0x966 },
	'patterny' => { 143 => 0x967 },
	'pdfversion' => { 533 => 'PDFVersion' },
	'pentaximagesize' => { 388 => 0x9 },
	'pentaxmodelid' => { 367 => 0x0, 388 => 0x5 },
	'pentaxmodeltype' => { 388 => 0x1 },
	'pentaxversion' => { 388 => 0x0 },
	'people' => { 497 => 'People', 510 => 'People' },
	'perchannelblacklevel' => { 43 => 0x157, 44 => 0x16b, 45 => 0x17f, 47 => 0xc4, 48 => [0x2b4,0x2cb,0x2cf], 49 => [0x108,0x14d], 50 => 0x1df, 51 => [0x1f8,0x2d8], 52 => [0x22c,0x30a], 53 => 0x149 },
	'performer' => { 405 => 'perf', 413 => 'perf' },
	'performerkeywords' => { 413 => "\xa9prk" },
	'performers' => { 413 => "\xa9prf" },
	'performerurl' => { 413 => "\xa9prl" },
	'period' => { 184 => 'WM/Period' },
	'peripheralillumcentralradius' => { 491 => 0x8030 },
	'peripheralillumcentralvalue' => { 491 => 0x8031 },
	'peripheralillumination' => { 108 => 0x20702, 114 => 0x68 },
	'peripheralilluminationcorr' => { 66 => 0x1, 377 => 0x2 },
	'peripheralilluminationon' => { 108 => '0x20702.0', 114 => 0x64 },
	'peripheralillumperiphvalue' => { 491 => 0x8032 },
	'peripherallighting' => { 83 => 0x2, 132 => 0x3804 },
	'peripherallightingsetting' => { 84 => 0x5 },
	'peripherallightingvalue' => { 83 => 0x6 },
	'permissions' => { 539 => 'permissions' },
	'permits' => { 515 => 'permits' },
	'person' => { 536 => 'person' },
	'personality' => { 507 => 'Personality' },
	'personheard' => { 531 => 'PersonHeard' },
	'personheardidentifier' => { 531 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 531 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 531 => 'PersonInImage' },
	'personinimagecharacteristic' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 531 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 531 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 517 => 'PerspectiveAspect', 519 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 517 => 'PerspectiveHorizontal', 519 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 517 => 'PerspectiveRotate', 519 => 'PerspectiveRotate' },
	'perspectivescale' => { 517 => 'PerspectiveScale', 519 => 'PerspectiveScale' },
	'perspectiveupright' => { 517 => 'PerspectiveUpright', 519 => 'PerspectiveUpright' },
	'perspectivevertical' => { 517 => 'PerspectiveVertical', 519 => 'PerspectiveVertical' },
	'perspectivex' => { 517 => 'PerspectiveX', 519 => 'PerspectiveX' },
	'perspectivey' => { 517 => 'PerspectiveY', 519 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 97 => 0x1 },
	'pf10retainprogramshift' => { 97 => 0xb },
	'pf13drivepriority' => { 97 => 0xe },
	'pf14disablefocussearch' => { 97 => 0xf },
	'pf15disableafassistbeam' => { 97 => 0x10 },
	'pf16autofocuspointshoot' => { 97 => 0x11 },
	'pf17disableafpointsel' => { 97 => 0x12 },
	'pf18enableautoafpointsel' => { 97 => 0x13 },
	'pf19continuousshootspeed' => { 97 => 0x14 },
	'pf19shootingspeedhigh' => { 96 => 0xa },
	'pf19shootingspeedlow' => { 96 => 0x9 },
	'pf1disableshootingmodes' => { 97 => 0x2 },
	'pf1value' => { 96 => 0x1 },
	'pf20limitcontinousshots' => { 97 => 0x15 },
	'pf20maxcontinousshots' => { 96 => 0xb },
	'pf21enablequietoperation' => { 97 => 0x16 },
	'pf23felocktime' => { 96 => 0xd },
	'pf23postreleasetime' => { 96 => 0xe },
	'pf23settimerlengths' => { 97 => 0x18 },
	'pf23shutterbuttontime' => { 96 => 0xc },
	'pf24lightlcdduringbulb' => { 97 => 0x19 },
	'pf25aemode' => { 96 => 0xf },
	'pf25afmode' => { 96 => 0x12 },
	'pf25afpointsel' => { 96 => 0x13 },
	'pf25colormatrix' => { 96 => 0x17 },
	'pf25defaultclearsettings' => { 97 => 0x1a },
	'pf25drivemode' => { 96 => 0x11 },
	'pf25imagesize' => { 96 => 0x14 },
	'pf25meteringmode' => { 96 => 0x10 },
	'pf25parameters' => { 96 => 0x16 },
	'pf25wbmode' => { 96 => 0x15 },
	'pf26shortenreleaselag' => { 97 => 0x1b },
	'pf27reversedialrotation' => { 97 => 0x1c },
	'pf27value' => { 96 => 0x18 },
	'pf28noquickdialexpcomp' => { 97 => 0x1d },
	'pf29quickdialswitchoff' => { 97 => 0x1e },
	'pf2disablemeteringmodes' => { 97 => 0x3 },
	'pf2value' => { 96 => 0x2 },
	'pf30enlargementmode' => { 97 => 0x1f },
	'pf31originaldecisiondata' => { 97 => 0x20 },
	'pf3manualexposuremetering' => { 97 => 0x4 },
	'pf3value' => { 96 => 0x3 },
	'pf4exposuretimelimits' => { 97 => 0x5 },
	'pf4exposuretimemax' => { 96 => 0x5 },
	'pf4exposuretimemin' => { 96 => 0x4 },
	'pf5aperturelimits' => { 97 => 0x6 },
	'pf5aperturemax' => { 96 => 0x7 },
	'pf5aperturemin' => { 96 => 0x6 },
	'pf6presetshootingmodes' => { 97 => 0x7 },
	'pf7bracketcontinuousshoot' => { 97 => 0x8 },
	'pf8bracketshots' => { 96 => 0x8 },
	'pf8setbracketshots' => { 97 => 0x9 },
	'pf9changebracketsequence' => { 97 => 0xa },
	'phasedetectaf' => { 198 => 0x6 },
	'phonenumber' => { 162 => 'Phone' },
	'photoeffect' => { 36 => 0x28 },
	'photoeffecthistoryxml' => { 300 => 0xe9651831 },
	'photoeffects' => { 300 => 0xab5eca5e },
	'photoeffectsblue' => { 302 => 0x8 },
	'photoeffectsgreen' => { 302 => 0x6 },
	'photoeffectsred' => { 302 => 0x4 },
	'photoeffectstype' => { 302 => 0x0 },
	'photographer' => { 124 => 0xa437, 524 => 'Photographer' },
	'photographicsensitivity' => { 524 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 307 => '17.6', 316 => '33.6' },
	'photometricinterpretation' => { 124 => 0x106, 542 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 247 => 0x11e, 248 => 0x11e, 249 => 0x112, 250 => 0x122, 251 => 0x122, 252 => 0x24, 270 => 0x0 },
	'photoshootingmenubankimagearea' => { 244 => 0x6dd, 247 => 0x144, 248 => 0x144, 249 => 0x134, 250 => 0x148, 251 => 0x148, 270 => '7.1' },
	'photoshopbgrthumbnail' => { 402 => 0x409 },
	'photoshopquality' => { 401 => 0x0 },
	'photoshopthumbnail' => { 402 => 0x40c },
	'photostyle' => { 352 => 0x89 },
	'picasawebgphotoid' => { 522 => 'picasawebGPhotoId' },
	'pick' => { 546 => 'pick' },
	'picklabel' => { 522 => 'PickLabel' },
	'pictinfo' => { 429 => 0x208 },
	'picturecontrol' => { 300 => 0xe2173c47 },
	'picturecontrolactive' => { 303 => 0x0 },
	'picturecontroladjust' => { 258 => 0x30, 259 => 0x30, 260 => 0x36 },
	'picturecontrolbase' => { 258 => 0x18, 259 => 0x18, 260 => 0x1c },
	'picturecontroldata' => { 241 => [0xbd,0x23] },
	'picturecontrolmode' => { 303 => 0x13 },
	'picturecontrolname' => { 258 => 0x4, 259 => 0x4, 260 => 0x8 },
	'picturecontrolquickadjust' => { 258 => 0x31, 259 => 0x31, 260 => 0x37 },
	'pictureeffect' => { 454 => 0x200e },
	'pictureeffect2' => { 463 => 0x1163, 464 => 0x1167, 465 => 0x1143, 466 => 0x11bf, 467 => 0x119b, 468 => 0x1053, 469 => 0x24b, 470 => 0x24b, 471 => 0x23c, 486 => 0x46 },
	'picturefinish' => { 187 => 0x71 },
	'picturemode' => { 132 => 0x1031, 328 => 0x520, 388 => [0xb,0x33], 430 => 0x3d },
	'picturemode2' => { 368 => 0x0 },
	'picturemodebwfilter' => { 328 => 0x525 },
	'picturemodecontrast' => { 328 => 0x523 },
	'picturemodeeffect' => { 328 => 0x52d },
	'picturemodehue' => { 328 => 0x522 },
	'picturemodesaturation' => { 328 => 0x521 },
	'picturemodesharpness' => { 328 => 0x524 },
	'picturemodetone' => { 328 => 0x526 },
	'pictureprofile' => { 463 => [0x115e,0x115f], 464 => [0x1162,0x1163], 465 => [0x113e,0x113f], 466 => [0x11ba,0x11bb], 467 => [0x1196,0x1197], 468 => [0x104e,0x104f], 469 => [0x246,0x247], 470 => [0x246,0x247], 471 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 78 => 0xa, 108 => 0x20301, 114 => 0x2 },
	'picturestylepc' => { 68 => 0x4009 },
	'picturestyleuserdef' => { 68 => 0x4008 },
	'picturewizard' => { 427 => 0x21 },
	'picturewizardcolor' => { 426 => 0x1 },
	'picturewizardcontrast' => { 426 => 0x4 },
	'picturewizardmode' => { 426 => 0x0 },
	'picturewizardsaturation' => { 426 => 0x2 },
	'picturewizardsharpness' => { 426 => 0x3 },
	'pipelineversion' => { 181 => 'PipelineVersion' },
	'pitch' => { 120 => 0x6, 308 => '4.1', 320 => '4.1', 413 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 65 => 0x5, 256 => 0x4, 328 => 0x904, 342 => 'PitchAngle', 352 => 0x91, 386 => 0x2, 387 => 0x5, 425 => 0x1 },
	'pitchshift' => { 407 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 406 => 'pasp' },
	'pixelclockfrequency' => { 143 => 0x40b },
	'pixelcorrectionoffset' => { 143 => 0x972 },
	'pixelcorrectionscale' => { 143 => 0x971 },
	'pixelscale' => { 124 => 0x830e },
	'pixelshiftdelay' => { 245 => 0x38c, 248 => 0x802 },
	'pixelshiftinfo' => { 454 => 0x202f },
	'pixelshiftinterval' => { 245 => 0x38e },
	'pixelshiftnumbershots' => { 245 => 0x38a, 248 => 0x800 },
	'pixelshiftoffset' => { 132 => 0x1106 },
	'pixelshiftresolution' => { 389 => 0x0 },
	'pixelshiftshooting' => { 245 => 0x388, 248 => 0x7fe },
	'pixelshiftshots' => { 132 => 0x1105 },
	'pixelsperunitx' => { 340 => 0x0 },
	'pixelsperunity' => { 340 => 0x4 },
	'pixelunits' => { 340 => 0x8 },
	'planarconfiguration' => { 124 => 0x11c, 542 => 'PlanarConfiguration' },
	'plane' => { 495 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 495 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 495 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 495 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 495 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 495 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 495 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 495 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 495 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 495 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 495 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 495 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 495 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 495 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 495 => 'Planes' },
	'planningref' => { 531 => 'PlanningRef' },
	'planningrefidentifier' => { 531 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 531 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 531 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 551 => 'PlateNames' },
	'platform' => { 536 => 'platform' },
	'playallframes' => { 413 => 'AllF' },
	'playbackbutton' => { 248 => 0x804, 251 => 0x808 },
	'playbackbuttonplaybackmode' => { 248 => 0x80e, 251 => 0x814 },
	'playbackflickdown' => { 323 => 0x149, 324 => 0x159, 325 => 0x159, 326 => 0x171 },
	'playbackflickup' => { 323 => 0x145, 324 => 0x155, 325 => 0x155, 326 => 0x16d },
	'playbackmenustime' => { 312 => '20.1', 313 => '21.1', 314 => '21.1' },
	'playbackmonitorofftime' => { 307 => '25.2', 308 => '36.1', 310 => '36.1', 311 => '36.1', 315 => '35.1', 316 => '8.1', 317 => '35.1', 320 => '36.1', 321 => '36.1', 322 => '21.1', 323 => 0x37, 324 => 0x33, 325 => 0x33, 326 => 0x33 },
	'playbackzoom' => { 308 => '37.1' },
	'playdisplay' => { 189 => 0x4e },
	'playerversion' => { 407 => 'player.version' },
	'playgap' => { 405 => 'pgap' },
	'playmode' => { 413 => 'SDLN' },
	'playselection' => { 413 => 'SelO' },
	'plusversion' => { 338 => 'Version' },
	'pmversion' => { 400 => 'PMVersion' },
	'pngwarning' => { 341 => 'Warning' },
	'podcast' => { 405 => 'pcst' },
	'podcasturl' => { 405 => 'purl' },
	'poilevel' => { 240 => 0x8 },
	'portraitimpressionbalance' => { 245 => 0x378, 247 => 0x26e, 248 => 0x26e, 261 => 0xa0 },
	'portraitnote' => { 499 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 114 => 0x1d },
	'portraitoutputshadowpoint' => { 114 => 0x1e },
	'portraitrawcolortone' => { 114 => 0x16 },
	'portraitrawcontrast' => { 114 => 0x18 },
	'portraitrawhighlight' => { 114 => 0x76 },
	'portraitrawhighlightpoint' => { 114 => 0x1b },
	'portraitrawlinear' => { 114 => 0x19 },
	'portraitrawsaturation' => { 114 => 0x17 },
	'portraitrawshadow' => { 114 => 0x7f },
	'portraitrawshadowpoint' => { 114 => 0x1c },
	'portraitrawsharpness' => { 114 => 0x1a },
	'portraitrefiner' => { 118 => 0x302b },
	'portraitrequest' => { 499 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 114 => 0x9a },
	'portraitunsharpmaskstrength' => { 114 => 0x98 },
	'portraitunsharpmaskthreshold' => { 114 => 0x9c },
	'portraitversion' => { 499 => 'PortraitVersion' },
	'pose' => { 495 => 'Pose' },
	'poseheadingdegrees' => { 505 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 505 => 'PosePitchDegrees' },
	'posepositionx' => { 495 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 495 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 495 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 505 => 'PoseRollDegrees' },
	'poserotationw' => { 495 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 495 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 495 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 495 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 495 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 535 => 'positionDescriptor' },
	'postalcode' => { 166 => 'PostalCode' },
	'postcropvignetteamount' => { 517 => 'PostCropVignetteAmount', 519 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 517 => 'PostCropVignetteFeather', 519 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 517 => 'PostCropVignetteHighlightContrast', 519 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 517 => 'PostCropVignetteMidpoint', 519 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 517 => 'PostCropVignetteRoundness', 519 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 517 => 'PostCropVignetteStyle', 519 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 352 => 0xbf },
	'postreleaseburstlength' => { 250 => 0x714, 251 => 0x784, 324 => 0x289 },
	'potentialface1position' => { 450 => 0xb },
	'potentialface2position' => { 450 => 0x15 },
	'potentialface3position' => { 450 => 0x1f },
	'potentialface4position' => { 450 => 0x29 },
	'potentialface5position' => { 450 => 0x33 },
	'potentialface6position' => { 450 => 0x3d },
	'potentialface7position' => { 450 => 0x47 },
	'potentialface8position' => { 450 => 0x51 },
	'poweravailable' => { 366 => '0.2' },
	'powersource' => { 366 => '0.1' },
	'poweruptime' => { 241 => 0xb6 },
	'preaf' => { 131 => '0.2' },
	'precaptureframes' => { 333 => 0x300 },
	'predictor' => { 124 => 0x13d },
	'preflashreturnstrength' => { 278 => 0x28a },
	'prefs' => { 136 => 0xdd, 400 => 'Prefs' },
	'prereadfastresetcount' => { 143 => 0x187e },
	'prereleaseburstlength' => { 250 => 0x712, 251 => 0x782, 324 => 0x287 },
	'preservedfilename' => { 547 => 'PreservedFileName' },
	'preservedspecimen' => { 123 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 123 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 517 => 'PresetType', 519 => 'PresetType' },
	'presetwhitebalance' => { 189 => 0x24, 491 => 0x8002 },
	'presetwhitebalanceadj' => { 491 => 0x8014 },
	'pressure' => { 124 => 0x9402, 524 => 'Pressure' },
	'previewapplicationname' => { 124 => 0xc716 },
	'previewapplicationversion' => { 124 => 0xc717 },
	'previewbutton' => { 307 => ['14.1','15.1'], 308 => '15.1', 310 => '15.1', 311 => '15.1', 316 => '29.1', 317 => '14.1', 320 => '15.1', 321 => '15.1' },
	'previewbuttonplusdials' => { 307 => ['14.2','15.2'], 308 => '15.2', 310 => '43.1', 311 => '43.1', 316 => '31.2', 320 => '43.1', 321 => '43.1' },
	'previewcolorspace' => { 124 => 0xc71a },
	'previewcropbottom' => { 399 => 0xef },
	'previewcropleft' => { 399 => 0xec },
	'previewcropright' => { 399 => 0xee },
	'previewcroptop' => { 399 => 0xed },
	'previewdate' => { 411 => 0x0 },
	'previewdatetime' => { 124 => 0xc71b },
	'previewimage' => { 118 => 0x2000, 119 => 'Exif-PreviewImage', 125 => 'PreviewImage', 127 => 0x4, 171 => 'data', 191 => 0x81, 333 => 0x280, 350 => 0x300, 405 => 'snal', 413 => 'mcvr', 454 => 0x2001 },
	'previewimageborders' => { 388 => 0x3e },
	'previewimageheight' => { 77 => 0x4, 147 => 0xfa58 },
	'previewimagelength' => { 77 => 0x2, 118 => 0x3, 124 => [0x117,0x202], 191 => 0x89, 262 => 0x202, 328 => 0x102, 333 => 0x1037, 388 => 0x3, 419 => 0x1e, 424 => 0x3, 430 => [0x1b,0x1d], 443 => 0x202 },
	'previewimagename' => { 171 => '1Name' },
	'previewimagesize' => { 118 => 0x2, 152 => 0x2, 171 => 'ImageSize', 388 => 0x2, 430 => [0x1c,0x1e], 454 => 0xb02c, 491 => 0x9012 },
	'previewimagestart' => { 77 => 0x5, 118 => 0x4, 124 => [0x111,0x201], 191 => 0x88, 262 => 0x201, 328 => 0x101, 333 => 0x1036, 388 => 0x4, 419 => 0x1c, 424 => 0x2, 430 => [0x1a,0x1c], 443 => 0x201 },
	'previewimagetype' => { 171 => '0Type' },
	'previewimagevalid' => { 328 => 0x100, 333 => 0x1035 },
	'previewimagewidth' => { 77 => 0x3, 147 => 0xfa57 },
	'previewquality' => { 77 => 0x1 },
	'previewsettingsdigest' => { 124 => 0xc719 },
	'previewsettingsname' => { 124 => 0xc718 },
	'primaryafpoint' => { 198 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 124 => 0x13f, 542 => 'PrimaryChromaticities' },
	'primaryftp' => { 507 => 'PrimaryFTP' },
	'primaryslot' => { 252 => 0x25, 270 => 0x2 },
	'printim' => { 124 => 0xc4a5 },
	'prioritysetinawb' => { 454 => 0x202b },
	'prioritysetupshutterrelease' => { 189 => 0x1d, 440 => 0x28 },
	'privatertkinfo' => { 509 => 'privateRTKInfo' },
	'processbordercolsleft' => { 143 => 0xc61 },
	'processbordercolsright' => { 143 => 0xc62 },
	'processborderrowsbottom' => { 143 => 0xc64 },
	'processborderrowstop' => { 143 => 0xc63 },
	'processingsoftware' => { 124 => 0xb },
	'processversion' => { 517 => 'ProcessVersion', 519 => 'ProcessVersion' },
	'producer' => { 184 => 'WM/Producer', 337 => 'Producer', 405 => "\xa9prd", 407 => 'producer', 413 => "\xa9prd", 533 => 'Producer' },
	'producerkeywords' => { 413 => "\xa9pdk" },
	'productcode' => { 536 => 'productCode' },
	'productid' => { 137 => 0x32, 405 => 'prID', 535 => 'productID' },
	'productidtype' => { 535 => 'productIDType' },
	'productinimage' => { 531 => 'ProductInImage' },
	'productinimagedescription' => { 531 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 531 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 531 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 531 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 367 => 0x2 },
	'productorserviceconstraints' => { 338 => 'ProductOrServiceConstraints' },
	'productversion' => { 405 => 'VERS' },
	'profession' => { 536 => 'profession' },
	'profile' => { 495 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 124 => 0xc6f4 },
	'profilecameraindices' => { 495 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 124 => 0xc6fe },
	'profiledynamicrange' => { 124 => 0xcd47 },
	'profileembedpolicy' => { 124 => 0xc6fd },
	'profilegaintablemap' => { 124 => 0xcd2d },
	'profilegaintablemap2' => { 124 => 0xcd40 },
	'profilegroupname' => { 124 => 0xcd48 },
	'profilehuesatmapdata1' => { 124 => 0xc6fa },
	'profilehuesatmapdata2' => { 124 => 0xc6fb },
	'profilehuesatmapdata3' => { 124 => 0xcd39 },
	'profilehuesatmapdims' => { 124 => 0xc6f9 },
	'profilehuesatmapencoding' => { 124 => 0xc7a3 },
	'profilelooktabledata' => { 124 => 0xc726 },
	'profilelooktabledims' => { 124 => 0xc725 },
	'profilelooktableencoding' => { 124 => 0xc7a4 },
	'profilename' => { 124 => 0xc6f8, 339 => 'iCCP-name' },
	'profiles' => { 495 => 'Profiles' },
	'profiletonecurve' => { 124 => 0xc6fc },
	'profiletype' => { 495 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 352 => 0x3c },
	'programline' => { 368 => '1.1' },
	'programmode' => { 194 => 0x5 },
	'programshift' => { 241 => 0xd },
	'programversion' => { 136 => 0x46 },
	'prohibits' => { 515 => 'prohibits' },
	'projectiontype' => { 505 => 'ProjectionType', 506 => 'ProjectionType' },
	'projectname' => { 546 => 'projectName' },
	'projectref' => { 546 => 'projectRef' },
	'projectrefpath' => { 546 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 546 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 184 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 338 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 338 => 'PropertyReleaseStatus' },
	'provider' => { 184 => 'WM/Provider' },
	'province-state' => { 136 => 0x5f },
	'publicationdate' => { 536 => 'publicationDate' },
	'publicationdatea-platform' => { 536 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 536 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 536 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 536 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 536 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 531 => 'PublicationEvent' },
	'publicationeventdate' => { 531 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 531 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 531 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 536 => 'publicationName' },
	'publisher' => { 184 => 'WM/Publisher', 405 => "\xa9pub", 407 => 'publisher', 520 => 'publisher' },
	'publishingfrequency' => { 536 => 'publishingFrequency' },
	'pulldown' => { 546 => 'pullDown' },
	'purchasedate' => { 405 => 'purd' },
	'purplehsl' => { 108 => 0x20916 },
	'pxshiftperiphedgenr' => { 491 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 491 => 0x9014 },
	'quality' => { 0 => 0x1, 36 => 0x3, 117 => 0x2, 118 => 0x3002, 132 => 0x1000, 145 => 0x9, 241 => 0x4, 289 => 0x3, 333 => 0x201, 347 => 0x300, 388 => 0x8, 395 => 0x2, 430 => 0x16, 440 => 0x56, 441 => 0x56, 442 => 0xb, 454 => [0x102,0x202e] },
	'quality2' => { 463 => 0x1170, 464 => 0x1174, 465 => 0x1150, 467 => 0x11a8, 468 => 0x1060, 469 => 0x258, 470 => 0x258, 471 => 0x247, 477 => 0x29, 478 => 0x25, 479 => 0x2a },
	'qualitybutton' => { 325 => 0x17d, 326 => 0x195 },
	'qualitybuttonplaybackmode' => { 325 => 0x1bf, 326 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 118 => 0x8 },
	'quantizationmethod' => { 138 => 0x78 },
	'quickadjust' => { 303 => 0x2a },
	'quickcontroldialinmeter' => { 89 => 0x703 },
	'quickfix' => { 300 => 0x416391c6 },
	'quickshot' => { 429 => 0x213 },
	'quiettime' => { 143 => 0x188a },
	'radialdistortioncoefficient1' => { 216 => 0x14 },
	'radialdistortioncoefficient2' => { 216 => 0x1c },
	'radialdistortioncoefficient3' => { 216 => 0x24 },
	'rads' => { 413 => 'rads' },
	'rangefinder' => { 312 => '4.1', 313 => '5.1', 314 => '5.1' },
	'rangemask' => { 517 => 'RangeMaskMapInfo', 519 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 517 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 519 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 517 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 519 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 517 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 519 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 517 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 519 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 517 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 519 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 517 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 519 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 136 => 0x7d },
	'rating' => { 108 => 0x10100, 124 => 0x4746, 132 => 0x1431, 399 => 0xdf, 405 => 'rtng', 413 => 'rtng', 454 => 0x2002, 512 => 'rating', 521 => 'rating', 531 => 'Rating', 536 => 'rating', 544 => 'Rating' },
	'ratingpercent' => { 124 => 0x4749, 183 => 'Rating', 405 => 'rate', 544 => 'RatingPercent' },
	'ratingregion' => { 531 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 531 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 531 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 531 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 531 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 531 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 531 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 531 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 531 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 531 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 531 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 531 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 531 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 531 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 531 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 531 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 531 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 531 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 531 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 87 => 0x8, 191 => 0x109, 368 => 0xd },
	'rawbrightnessadj' => { 108 => 0x20001, 113 => 0x38 },
	'rawburstimagecount' => { 79 => 0x2 },
	'rawburstimagenum' => { 79 => 0x1 },
	'rawcoloradj' => { 113 => 0x2e },
	'rawcropbottom' => { 399 => 0xd4 },
	'rawcropleft' => { 399 => 0xd1 },
	'rawcropright' => { 399 => 0xd3 },
	'rawcroptop' => { 399 => 0xd2 },
	'rawcustomsaturation' => { 113 => 0x30 },
	'rawcustomtone' => { 113 => 0x34 },
	'rawdata' => { 427 => 0xa048 },
	'rawdatabyteorder' => { 427 => 0x40 },
	'rawdatacfapattern' => { 427 => 0x50 },
	'rawdatauniqueid' => { 124 => 0xc65d },
	'rawdepth' => { 193 => 0x10 },
	'rawdevartfilter' => { 335 => 0x121 },
	'rawdevautogradation' => { 335 => 0x119 },
	'rawdevcolorspace' => { 334 => 0x108, 335 => 0x109 },
	'rawdevcontrastvalue' => { 334 => 0x106, 335 => 0x105 },
	'rawdeveditstatus' => { 334 => 0x10b },
	'rawdevelopingsoftware' => { 124 => 0xa43a, 524 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 388 => 0x62 },
	'rawdevengine' => { 334 => 0x109, 335 => 0x10b },
	'rawdevexposurebiasvalue' => { 334 => 0x100, 335 => 0x100 },
	'rawdevgradation' => { 335 => 0x112 },
	'rawdevgraypoint' => { 334 => 0x103, 335 => 0x104 },
	'rawdevmemorycoloremphasis' => { 334 => 0x105, 335 => 0x108 },
	'rawdevnoisereduction' => { 334 => 0x10a, 335 => 0x10a },
	'rawdevpicturemode' => { 335 => 0x10c },
	'rawdevpm_bwfilter' => { 335 => 0x110 },
	'rawdevpmcontrast' => { 335 => 0x10e },
	'rawdevpmnoisefilter' => { 335 => 0x120 },
	'rawdevpmpicturetone' => { 335 => 0x111 },
	'rawdevpmsaturation' => { 335 => 0x10d },
	'rawdevpmsharpness' => { 335 => 0x10f },
	'rawdevsaturation3' => { 335 => 0x113 },
	'rawdevsaturationemphasis' => { 334 => 0x104, 335 => 0x107 },
	'rawdevsettings' => { 334 => 0x10c },
	'rawdevsharpnessvalue' => { 334 => 0x107, 335 => 0x106 },
	'rawdevversion' => { 334 => 0x0, 335 => 0x0 },
	'rawdevwbfineadjustment' => { 334 => 0x102, 335 => 0x103 },
	'rawdevwhitebalance' => { 335 => 0x101 },
	'rawdevwhitebalancevalue' => { 334 => 0x101, 335 => 0x102 },
	'rawfile' => { 124 => 0xfe4c },
	'rawfilename' => { 517 => 'RawFileName', 519 => 'RawFileName' },
	'rawfiletype' => { 454 => 0x2029 },
	'rawformat' => { 357 => 0x2d, 397 => 0x10e },
	'rawimagecenter' => { 241 => 0x99 },
	'rawimagedigest' => { 124 => 0xc71c },
	'rawimagesize' => { 388 => 0x39 },
	'rawinfoversion' => { 336 => 0x0 },
	'rawjpgheight' => { 104 => 0x4 },
	'rawjpgquality' => { 60 => 0x6, 104 => 0x1 },
	'rawjpgsize' => { 60 => 0x7, 104 => 0x2 },
	'rawjpgwidth' => { 104 => 0x3 },
	'rawmeasuredrggb' => { 46 => 0x26a, 48 => 0x280, 50 => 0x194, 51 => [0x1ad,0x26b] },
	'rawrppused' => { 512 => 'rawrppused' },
	'rawtopreviewgain' => { 124 => 0xc7a8 },
	'readouttypeactual' => { 143 => 0x1903 },
	'readouttyperequested' => { 143 => 0x1902 },
	'reardisplay' => { 307 => '12.3', 308 => '6.2' },
	'recdevice' => { 531 => 'RecDevice' },
	'recdeviceattlensdescription' => { 531 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 531 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 531 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 531 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 531 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 538 => 'recipeEndingPage' },
	'recipepagerange' => { 538 => 'recipePageRange' },
	'recipesource' => { 538 => 'recipeSource' },
	'recipestartingpage' => { 538 => 'recipeStartingPage' },
	'recipetitle' => { 538 => 'recipeTitle' },
	'recognizedface1age' => { 345 => 0x20 },
	'recognizedface1name' => { 345 => 0x4 },
	'recognizedface1position' => { 345 => 0x18 },
	'recognizedface2age' => { 345 => 0x50 },
	'recognizedface2name' => { 345 => 0x34 },
	'recognizedface2position' => { 345 => 0x48 },
	'recognizedface3age' => { 345 => 0x80 },
	'recognizedface3name' => { 345 => 0x64 },
	'recognizedface3position' => { 345 => 0x78 },
	'recognizedfaceflags' => { 352 => 0x63 },
	'recommendedexposureindex' => { 124 => 0x8832, 524 => 'RecommendedExposureIndex' },
	'record' => { 123 => 'Record' },
	'recordbasisofrecord' => { 123 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 123 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 123 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 123 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 123 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 123 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 189 => 0x4d },
	'recorddynamicproperties' => { 123 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 102 => 0x1804 },
	'recordinformationwithheld' => { 123 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 413 => "\xa9phg" },
	'recordingformat' => { 420 => 0x1000 },
	'recordingmode' => { 117 => 0x1, 395 => 0x1 },
	'recordinstitutioncode' => { 123 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 123 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 413 => "\xa9lab" },
	'recordlabelurl' => { 413 => "\xa9lal" },
	'recordlocationdata' => { 249 => 0x660, 250 => 0x690, 251 => 0x6f8 },
	'recordmode' => { 36 => 0x9, 118 => 0x3000 },
	'recordownerinstitutioncode' => { 123 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 429 => 0x217 },
	'redbalance' => { 333 => 0x1017, 357 => 0x11, 388 => 0x1c },
	'redcurvelimits' => { 113 => 0x18a },
	'redcurvepoints' => { 112 => 0x2d, 113 => 0x160 },
	'redeyecorrection' => { 304 => 0x0 },
	'redeyeinfo' => { 517 => 'RedEyeInfo', 519 => 'RedEyeInfo' },
	'redeyereduction' => { 189 => 0x41, 440 => 0x6a, 442 => 0x28 },
	'redeyeremoval' => { 352 => 0xb9 },
	'redhsl' => { 108 => 0x20910 },
	'redhue' => { 517 => 'RedHue', 519 => 'RedHue' },
	'redsaturation' => { 517 => 'RedSaturation', 519 => 'RedSaturation' },
	'reductionmatrix1' => { 124 => 0xc625 },
	'reductionmatrix2' => { 124 => 0xc626 },
	'reductionmatrix3' => { 124 => 0xcd3a },
	'reelname' => { 124 => 0xc789, 413 => 'reel' },
	'reference1' => { 529 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 529 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 124 => 0x214, 542 => 'ReferenceBlackWhite' },
	'referencedate' => { 136 => 0x2f },
	'referencenumber' => { 136 => 0x32 },
	'references' => { 162 => 'References' },
	'referenceservice' => { 136 => 0x2d },
	'regionappliedtodimensions' => { 177 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 177 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 177 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 177 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 177 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 177 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 177 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 177 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 177 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 177 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 177 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 177 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 338 => 'RegionConstraints' },
	'regiondescription' => { 177 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 177 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 177 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 177 => 'Regions' },
	'regioninfoacdsee' => { 492 => 'Regions' },
	'regioninfodateregionsvalid' => { 180 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 180 => 'RegionInfo' },
	'regioninforegions' => { 180 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 177 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 177 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 180 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 180 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 180 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 180 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 180 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 177 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 177 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 177 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 531 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 531 => 'RegistryId' },
	'registryitemid' => { 531 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 531 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 160 => 'data' },
	'relatedaudiofilename' => { 160 => '1Name' },
	'relatedaudiofiletype' => { 160 => '0Type' },
	'relatedimagefileformat' => { 124 => 0x1000 },
	'relatedimageheight' => { 124 => 0x1002 },
	'relatedimagewidth' => { 124 => 0x1001 },
	'relatedresourceid' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 124 => 0xa004, 523 => 'RelatedSoundFile' },
	'relatedvideofile' => { 174 => 'data' },
	'relatedvideofilename' => { 174 => '1Name' },
	'relatedvideofiletype' => { 174 => '0Type' },
	'relation' => { 520 => 'relation' },
	'relationshipaccordingto' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 123 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 121 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 546 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 546 => 'relativeTimestamp' },
	'relativetimestampscale' => { 546 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 546 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 307 => '17.8', 308 => '18.5', 310 => '18.4', 311 => '18.4', 316 => '33.8', 317 => '17.6', 320 => '18.5', 321 => '18.4' },
	'releasedate' => { 136 => 0x1e, 405 => 'rldt', 512 => 'ReleaseDate', 546 => 'releaseDate' },
	'releasemode' => { 118 => 0x3001, 246 => 0x5c, 280 => 0x184d, 454 => 0xb049 },
	'releasemode2' => { 463 => 0x112c, 464 => [0x112c,0x8], 465 => [0x1108,0x8], 466 => [0x1184,0x8], 467 => [0x1160,0x8], 468 => [0x4,0x1018], 469 => [0x4,0x210], 470 => [0x4,0x210], 471 => [0x4,0x208], 473 => [0x67,0x3f], 474 => [0x6b,0x6d,0x73,0x4b], 475 => [0x6b,0x4b], 476 => 0x1f, 477 => 0x10, 478 => 0x10, 479 => 0x9, 486 => 0x34 },
	'releasemode3' => { 463 => 0x1128, 464 => 0x1128, 465 => 0x1104, 466 => 0x1180, 467 => 0x115c, 468 => 0x1014, 469 => 0x20c, 470 => 0x20c, 471 => 0x204 },
	'releaseready' => { 531 => 'ReleaseReady' },
	'releasesetting' => { 102 => 0x1016 },
	'releasetime' => { 136 => 0x23, 512 => 'ReleaseTime' },
	'remoteonduration' => { 309 => '3.4', 312 => '17.2', 313 => '18.2', 314 => '18.2', 315 => '18.2', 317 => '18.2', 318 => '4.3', 322 => '19.2' },
	'renditionclass' => { 547 => 'RenditionClass' },
	'renditionof' => { 547 => 'RenditionOf' },
	'renditionofalternatepaths' => { 547 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 547 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 547 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 547 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 547 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 547 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 547 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 547 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 547 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 547 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 547 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 547 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 547 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 547 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 547 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 547 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 547 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 547 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 547 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 547 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 547 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 547 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 547 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 547 => 'RenditionParams' },
	'repeatingflashcount' => { 219 => 0xd, 220 => 0xe, 221 => 0xe, 222 => 0xe, 223 => 0xe, 224 => 0xe, 316 => '17.2', 317 => '24.2', 318 => '9.2', 319 => '24.2', 322 => '25.2' },
	'repeatingflashcountbuilt-in' => { 287 => 0x4db },
	'repeatingflashcountexternal' => { 287 => 0x4c3 },
	'repeatingflashoutput' => { 316 => '17.1', 317 => '24.1', 318 => '9.1', 319 => '24.1', 322 => '25.1' },
	'repeatingflashoutputexternal' => { 287 => 0x4c0 },
	'repeatingflashrate' => { 219 => 0xc, 220 => 0xd, 221 => 0xd, 222 => 0xd, 223 => 0xd, 224 => 0xd, 316 => '18.1', 317 => '25.1', 318 => '10.1', 319 => '25.1', 322 => '26.1' },
	'repeatingflashratebuilt-in' => { 287 => 0x4da },
	'repeatingflashrateexternal' => { 287 => 0x4c2 },
	'requirements' => { 413 => "\xa9req" },
	'requires' => { 515 => 'requires' },
	'resampleparams' => { 546 => 'resampleParams' },
	'resampleparamsquality' => { 546 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 143 => 0xe50 },
	'resamplingkerneldenominators067' => { 143 => 0xe4f },
	'resamplingkerneldenominators100' => { 143 => 0xe51 },
	'resaved' => { 429 => 0x21e },
	'resetblacksegrows' => { 143 => 0x181a },
	'resolution' => { 167 => 'Resolution' },
	'resolutionmode' => { 430 => [0x87,0x4] },
	'resolutionunit' => { 124 => 0x128, 139 => 0x2, 542 => 'ResolutionUnit' },
	'resourceid' => { 123 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 123 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 123 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 89 => 0x612 },
	'restrictions' => { 539 => 'restrictions' },
	'retouchareafeather' => { 517 => [\'RetouchAreas','RetouchAreasFeather'], 519 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 517 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 519 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 517 => [\'RetouchAreas','RetouchAreasMasksAngle'], 519 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 517 => [\'RetouchAreas','RetouchAreasMasksBottom'], 519 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 517 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 519 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 517 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 519 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 517 => [\'RetouchAreas','RetouchAreasMasksDabs'], 519 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 517 => [\'RetouchAreas','RetouchAreasMasksFeather'], 519 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 517 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 519 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 517 => [\'RetouchAreas','RetouchAreasMasksFlow'], 519 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 517 => [\'RetouchAreas','RetouchAreasMasksFullX'], 519 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 517 => [\'RetouchAreas','RetouchAreasMasksFullY'], 519 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 517 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 519 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 517 => [\'RetouchAreas','RetouchAreasMasksLeft'], 519 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasks'], 519 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 517 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 519 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 517 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 519 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 517 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 519 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 517 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 519 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 517 => [\'RetouchAreas','RetouchAreasMasksRadius'], 519 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 517 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 519 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 517 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 519 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 517 => [\'RetouchAreas','RetouchAreasMasksRight'], 519 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 517 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 519 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 517 => [\'RetouchAreas','RetouchAreasMasks'], 519 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 517 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 519 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 517 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 519 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 517 => [\'RetouchAreas','RetouchAreasMasksTop'], 519 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 517 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 519 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 517 => [\'RetouchAreas','RetouchAreasMasksVersion'], 519 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 517 => [\'RetouchAreas','RetouchAreasMasksWhat'], 519 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 517 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 519 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 517 => [\'RetouchAreas','RetouchAreasMasksX'], 519 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 517 => [\'RetouchAreas','RetouchAreasMasksY'], 519 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 517 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 519 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 517 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 519 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 517 => [\'RetouchAreas','RetouchAreasMethod'], 519 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 517 => [\'RetouchAreas','RetouchAreasOffsetY'], 519 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 517 => [\'RetouchAreas','RetouchAreasOpacity'], 519 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 517 => 'RetouchAreas', 519 => 'RetouchAreas' },
	'retouchareaseed' => { 517 => [\'RetouchAreas','RetouchAreasSeed'], 519 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 517 => [\'RetouchAreas','RetouchAreasSourceState'], 519 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 517 => [\'RetouchAreas','RetouchAreasSourceX'], 519 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 517 => [\'RetouchAreas','RetouchAreasSpotType'], 519 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 241 => 0x9e },
	'retouchinfo' => { 517 => 'RetouchInfo', 519 => 'RetouchInfo' },
	'retouchnefprocessing' => { 264 => 0x5 },
	'retractlensonpoweroff' => { 89 => 0x814 },
	'reuse' => { 338 => 'Reuse' },
	'reuseallowed' => { 549 => 'ReuseAllowed' },
	'reuseprohibited' => { 539 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 314 => '5.2' },
	'reversefocusring' => { 324 => 0x163, 325 => 0x163, 326 => 0x17b },
	'reverseindicators' => { 307 => '12.1', 308 => '6.1', 310 => '6.1', 311 => '6.1', 312 => '4.3', 313 => '5.2', 314 => '5.4', 316 => '33.5', 317 => '5.1', 320 => '6.1', 321 => '6.1', 322 => '6.2', 323 => 0xc5, 324 => 0xc1, 325 => 0xc1, 326 => 0xc1 },
	'reverseshutterspeedaperture' => { 314 => '5.3' },
	'revision' => { 521 => 'revision' },
	'rflensmffocusringsensitivity' => { 89 => 0x714 },
	'rflenstype' => { 60 => 0x3d },
	'rgbcurvelimits' => { 113 => 0x238 },
	'rgbcurvepoints' => { 112 => 0x7, 113 => 0x20e },
	'rgbtables' => { 124 => 0xcd3f },
	'richtextcomment' => { 526 => 'RichTextComment' },
	'ricohdate' => { 419 => 0x6 },
	'ricohimageheight' => { 419 => 0x2 },
	'ricohimagewidth' => { 419 => 0x0 },
	'rightalbedo' => { 508 => 'RightAlbedo' },
	'rightascension' => { 170 => 'RightAscension' },
	'rights' => { 520 => 'rights' },
	'rightsagent' => { 539 => 'rightsAgent' },
	'rightsowner' => { 539 => 'rightsOwner' },
	'roll' => { 120 => 0x8, 413 => ['roll',"\xa9frl"] },
	'rollangle' => { 65 => 0x4, 132 => 0x144d, 256 => 0x0, 328 => 0x903, 342 => 'RollAngle', 352 => 0x90, 386 => 0x1, 387 => 0x3, 425 => 0x2 },
	'romoperationmode' => { 102 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 101 => 0x3, 108 => 0x10002, 113 => 0x26e, 119 => 'QuickTime-Rotation', 128 => 0x4, 170 => 'Rotation', 187 => [0x65,0x50], 188 => 0x46, 189 => 0x5a, 192 => 0x10, 265 => 0x1a, 280 => 0x3693, 286 => '590.1', 300 => 0x76a43207, 352 => 0x30, 368 => '17.2', 399 => 0xd8, 406 => 'irot', 440 => 0x3f, 441 => 0x3f, 451 => 0x10 },
	'routedto' => { 525 => 'RoutedTo' },
	'routing' => { 404 => 'Routing' },
	'routingdestinations' => { 507 => 'RoutingDestinations' },
	'routingexclusions' => { 507 => 'RoutingExclusions' },
	'routingnotes' => { 525 => 'RoutingNotes' },
	'rowsperstrip' => { 124 => 0x116 },
	'rpp' => { 512 => 'rpp' },
	'rtkflag' => { 121 => 'RtkFlag' },
	'rtkstdhgt' => { 121 => 'RtkStdHgt' },
	'rtkstdlat' => { 121 => 'RtkStdLat' },
	'rtkstdlon' => { 121 => 'RtkStdLon' },
	'safetyshift' => { 89 => 0x108 },
	'safetyshiftinavortv' => { 87 => 0x10, 88 => 0x10, 90 => 0xf, 91 => 0x10, 94 => 0x10 },
	'sameexposurefornewaperture' => { 89 => 0x112 },
	'samplebits' => { 160 => 'SampleBits' },
	'samplepagerange' => { 536 => 'samplePageRange' },
	'samplerate' => { 160 => 'SampleRate' },
	'samplesperpixel' => { 124 => 0x115, 357 => 0x8, 542 => 'SamplesPerPixel' },
	'samplestructure' => { 138 => 0x5a },
	'samsungmodelid' => { 427 => 0x3 },
	'sanyoquality' => { 429 => 0x201 },
	'sanyothumbnail' => { 429 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 36 => 0xe, 54 => 0x1, 67 => 0x7, 117 => 0xd, 118 => [0x3013,0x1f], 124 => [0xa409,0xfe55], 132 => 0x1003, 161 => 'Saturation', 186 => 0x1f, 187 => 0x32, 188 => 0x28, 189 => 0x1a, 194 => 0x1, 241 => 0xaa, 258 => 0x35, 259 => 0x3b, 260 => 0x43, 352 => 0x40, 354 => 0x300d, 388 => 0x1f, 395 => 0xd, 414 => 0x27, 416 => 0x58, 419 => 0x28, 420 => 0x1013, 430 => 0x10, 440 => 0x1e, 441 => 0x1b, 454 => 0x2005, 517 => 'Saturation', 519 => 'Saturation', 523 => 'Saturation' },
	'saturationadj' => { 108 => 0x20901, 113 => 0x116, 241 => 0x94, 299 => 0x1, 303 => 0x2e, 491 => 0x8016 },
	'saturationadjustmentaqua' => { 517 => 'SaturationAdjustmentAqua', 519 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 517 => 'SaturationAdjustmentBlue', 519 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 517 => 'SaturationAdjustmentGreen', 519 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 517 => 'SaturationAdjustmentMagenta', 519 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 517 => 'SaturationAdjustmentOrange', 519 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 517 => 'SaturationAdjustmentPurple', 519 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 517 => 'SaturationAdjustmentRed', 519 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 517 => 'SaturationAdjustmentYellow', 519 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 75 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 74 => 0x68, 75 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 74 => 0x38, 75 => 0x38 },
	'saturationmonochrome' => { 74 => 0x80, 75 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 74 => 0x50, 75 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 74 => 0x20, 75 => 0x20 },
	'saturationsetting' => { 336 => 0x1010, 442 => 0x11, 459 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 74 => 0x8, 75 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 74 => 0x98, 75 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 74 => 0xb0, 75 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 74 => 0xc8, 75 => 0xe0 },
	'savefocusposition' => { 245 => 0x9b0 },
	'saveid' => { 547 => 'SaveID' },
	'sbaanalysiscomplete' => { 143 => 0xc35 },
	'sbablack' => { 143 => 0xc25 },
	'sbagmoffset' => { 143 => 0xc4a },
	'sbagray' => { 143 => 0xc26 },
	'sbagreenmagentabal' => { 143 => 0xc33 },
	'sbahighgray' => { 143 => 0xc46 },
	'sbailloffset' => { 143 => 0xc49 },
	'sbailluminantbal' => { 143 => 0xc34 },
	'sbalowgray' => { 143 => 0xc47 },
	'sbaneutralbal' => { 143 => 0xc32 },
	'sbawhite' => { 143 => 0xc27 },
	'scaletype' => { 546 => 'scaleType' },
	'scalingfactorheight' => { 342 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 266 => 0x60 },
	'scanningdirection' => { 138 => 0x64 },
	'scene' => { 413 => 'scen', 530 => 'Scene', 546 => 'scene' },
	'scenearea' => { 331 => 0x211, 333 => 0x1031 },
	'sceneassist' => { 241 => 0x9c },
	'scenecapturetype' => { 124 => 0xa406, 523 => 'SceneCaptureType' },
	'scenedetect' => { 331 => 0x210, 333 => 0x1030 },
	'scenedetectdata' => { 331 => 0x212, 333 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 147 => 0xfa02, 191 => 0x100, 241 => 0x8f, 328 => 0x509, 333 => 0x403, 352 => 0x8001, 361 => 0xf, 454 => 0xb023 },
	'scenemodeused' => { 149 => [0x6002,0xf002] },
	'scenerecognition' => { 132 => 0x1425 },
	'scenereferred' => { 527 => 'scene_referred' },
	'sceneselect' => { 429 => 0x21f },
	'scenetype' => { 124 => 0xa301, 523 => 'SceneType' },
	'screentips' => { 307 => '12.7', 308 => '5.3', 316 => '13.1', 317 => '4.4', 320 => '5.4', 322 => '5.1' },
	'scriptversion' => { 143 => 0x1770 },
	'sdrblend' => { 517 => 'SDRBlend', 519 => 'SDRBlend' },
	'sdrbrightness' => { 517 => 'SDRBrightness', 519 => 'SDRBrightness' },
	'sdrcontrast' => { 517 => 'SDRContrast', 519 => 'SDRContrast' },
	'sdrhighlights' => { 517 => 'SDRHighlights', 519 => 'SDRHighlights' },
	'sdrshadows' => { 517 => 'SDRShadows', 519 => 'SDRShadows' },
	'sdrwhites' => { 517 => 'SDRWhites', 519 => 'SDRWhites' },
	'season' => { 531 => 'Season', 535 => 'season' },
	'seasonidentifier' => { 531 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 531 => [\'Season','SeasonName'] },
	'seasonnumber' => { 531 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 507 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 245 => 0x35a, 247 => 0x240, 248 => 0x240, 249 => 0x22c, 250 => 0x240, 251 => 0x240, 269 => 0x13c, 280 => 0x1d0 },
	'section' => { 536 => 'section' },
	'securityclassification' => { 124 => 0x9212 },
	'selectableafpoint' => { 89 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 89 => 0x512 },
	'selfdata' => { 121 => 'SelfData' },
	'selftimer' => { 36 => 0x2, 352 => 0x2e, 429 => 0x214, 463 => 0x1134, 464 => 0x1134, 465 => 0x1110, 466 => 0x118c, 467 => 0x1168, 468 => 0x1020, 469 => 0x218, 470 => 0x218, 471 => 0x210 },
	'selftimer2' => { 81 => 0x1d },
	'selftimerinterval' => { 317 => '19.2' },
	'selftimermode' => { 124 => 0x882b },
	'selftimershotcount' => { 308 => '20.2', 310 => '20.3', 311 => '20.3', 312 => '18.2', 313 => '19.2', 314 => '19.2', 315 => '19.3', 317 => '19.3', 320 => '20.3', 321 => '20.3', 322 => '20.2', 323 => 0x31, 324 => 0x2d, 325 => 0x2d, 326 => 0x2d },
	'selftimershotinterval' => { 308 => '20.3', 310 => '20.2', 311 => '20.2', 315 => '19.2', 320 => '20.2', 321 => '20.2', 323 => 0x35, 324 => 0x31, 325 => 0x31, 326 => 0x31 },
	'selftimertime' => { 102 => 0x1806, 189 => 0x1f, 307 => '18.1', 308 => '20.1', 309 => '3.3', 310 => '20.1', 311 => '20.1', 312 => '18.1', 313 => '19.1', 314 => '19.1', 315 => '19.1', 316 => '7.2', 317 => '19.1', 318 => '3.3', 320 => '20.1', 321 => '20.1', 322 => '20.1', 323 => 0x2d, 324 => 0x2b, 325 => 0x2b, 326 => 0x2b },
	'sellingagency' => { 536 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 124 => 0x8546 },
	'sensingmethod' => { 124 => 0xa217, 523 => 'SensingMethod' },
	'sensitivityadjust' => { 388 => 0x40 },
	'sensitivitysteps' => { 368 => ['14.3','17.4'], 370 => 0x1 },
	'sensitivitytype' => { 124 => 0x8830, 524 => 'SensitivityType' },
	'sensor' => { 196 => 0x665e },
	'sensorarea' => { 333 => 0x400 },
	'sensorareas' => { 427 => 0xa010 },
	'sensorbitdepth' => { 354 => 0x312d },
	'sensorbluelevel' => { 78 => 0x5 },
	'sensorcalibration' => { 332 => 0x805 },
	'sensorcleaning' => { 95 => 0xd },
	'sensorfullheight' => { 142 => 0xf904 },
	'sensorfullwidth' => { 142 => 0xf903 },
	'sensorheight' => { 142 => 0xf901, 147 => 0xfa21, 193 => 0x8, 354 => 0x312c, 397 => 0x109, 420 => 0x1602 },
	'sensorimageheight' => { 143 => 0x3ee },
	'sensorimagewidth' => { 143 => 0x3ed },
	'sensorleftborder' => { 143 => 0x3eb },
	'sensorleftmargin' => { 397 => 0x10a },
	'sensorpixelsize' => { 241 => 0x9a },
	'sensorredlevel' => { 78 => 0x4 },
	'sensorserialnumber' => { 143 => 0x9ce },
	'sensorshield' => { 247 => 0x76b, 248 => 0x77b, 249 => 0x66d, 250 => 0x69d, 251 => 0x705 },
	'sensorsize' => { 161 => 'SensorSize', 388 => 0x35 },
	'sensortemperature' => { 331 => 0x1500, 333 => 0x1007, 393 => 0xc, 397 => 0x210, 430 => [0x39,0x55] },
	'sensortemperature2' => { 393 => 0xe, 397 => 0x211 },
	'sensortopborder' => { 143 => 0x3ec },
	'sensortopmargin' => { 397 => 0x10b },
	'sensortype' => { 352 => 0xca },
	'sensorwidth' => { 142 => 0xf900, 147 => 0xfa20, 193 => 0xa, 354 => 0x312b, 397 => 0x108, 420 => 0x1601 },
	'sequence' => { 414 => 0x7, 415 => 0x35, 416 => 0x36 },
	'sequencefilenumber' => { 464 => 0x4, 465 => 0x4, 466 => 0x4, 467 => 0x4, 477 => 0xc, 478 => 0xc, 479 => 0x1a },
	'sequenceimagenumber' => { 464 => 0x0, 465 => 0x0, 466 => 0x0, 467 => 0x0, 477 => 0x8, 478 => 0x8, 479 => 0x12, 486 => 0x24 },
	'sequencelength' => { 477 => 0x22, 478 => 0x1e, 479 => [0x16,0x1e] },
	'sequencename' => { 535 => 'sequenceName' },
	'sequencenumber' => { 81 => 0x9, 118 => 0x301c, 132 => 0x1101, 145 => 0x1d, 287 => 0x51c, 352 => 0x2b, 442 => [0x10c,0x30c], 454 => 0xb04a, 535 => 'sequenceNumber' },
	'sequenceshotinterval' => { 429 => 0x224 },
	'sequencetotalnumber' => { 535 => 'sequenceTotalNumber' },
	'sequentialshot' => { 429 => 0x20e },
	'serialnumber' => { 68 => 0xc, 102 => 0x180b, 124 => [0xa431,0xfde9], 142 => 0xfa04, 144 => 0xfa00, 146 => 0xc354, 147 => 0xfa19, 158 => 0x0, 161 => 'SerialNumber', 196 => 0x5501, 241 => [0xa0,0x1d], 329 => 0x101, 333 => [0x404,0x101a], 347 => 0x303, 349 => 0x305, 354 => 0x3103, 388 => 0x229, 397 => 0x102, 398 => 0x407, 413 => ['SNum','slno'], 414 => 0x15, 415 => 0x4b, 416 => 0x7e, 420 => 0x5, 427 => 0xa002, 430 => 0x2, 454 => 0x2031, 514 => 'SerialNumber', 524 => 'BodySerialNumber' },
	'serialnumberformat' => { 68 => 0x15, 102 => 0x183b },
	'serialnumberhash' => { 413 => 'CAME' },
	'series' => { 531 => 'Series' },
	'seriesdatetime' => { 494 => 'SeriesDateTime' },
	'seriesdescription' => { 494 => 'SeriesDescription' },
	'seriesidentifier' => { 531 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 494 => 'SeriesModality' },
	'seriesname' => { 531 => [\'Series','SeriesName'] },
	'seriesnumber' => { 494 => 'SeriesNumber', 536 => 'seriesNumber' },
	'seriestitle' => { 536 => 'seriesTitle' },
	'serviceidentifier' => { 137 => 0x1e },
	'servingsize' => { 538 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 92 => 0x0, 93 => 0x0 },
	'setbuttonwhenshooting' => { 87 => 0x1, 89 => 0x704, 95 => 0xc },
	'setclockfromlocationdata' => { 249 => 0x61d, 250 => 0x64d, 251 => 0x6b5 },
	'setfunctionwhenshooting' => { 90 => 0x0, 91 => 0x1, 94 => 0x1 },
	'setting' => { 535 => 'setting' },
	'shadingcompensation' => { 328 => 0x50c, 352 => 0x8a },
	'shadingcompensation2' => { 332 => 0x1012 },
	'shadow' => { 430 => 0xe },
	'shadowadj' => { 108 => 0x2030b },
	'shadowcorrection' => { 388 => 0x79 },
	'shadowprotection' => { 299 => 0x0 },
	'shadows' => { 124 => 0xfe52, 454 => 0x2032, 511 => 'Shadows', 517 => 'Shadows', 519 => 'Shadows' },
	'shadows2012' => { 517 => 'Shadows2012', 519 => 'Shadows2012' },
	'shadowsadj' => { 491 => 0x901a },
	'shadowscale' => { 124 => 0xc633 },
	'shadowtint' => { 517 => 'ShadowTint', 519 => 'ShadowTint' },
	'shadowtone' => { 132 => 0x1040 },
	'shakereduction' => { 390 => 0x1, 391 => 0x1 },
	'shareduserrating' => { 184 => 'WM/SharedUserRating' },
	'sharpendetail' => { 517 => 'SharpenDetail', 519 => 'SharpenDetail' },
	'sharpenedgemasking' => { 517 => 'SharpenEdgeMasking', 519 => 'SharpenEdgeMasking' },
	'sharpening' => { 354 => 0x300b },
	'sharpeningadj' => { 303 => 0x2b },
	'sharpeningkernel' => { 143 => 0x92f },
	'sharpenradius' => { 517 => 'SharpenRadius', 519 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 36 => 0xf, 67 => 0x6, 78 => 0x2, 117 => 0xb, 118 => [0x3011,0x21], 124 => [0xa40a,0xfe56], 132 => 0x1001, 145 => 0x6b, 154 => 0x37, 161 => 'Sharpness', 186 => 0x21, 187 => 0x30, 188 => 0x26, 189 => 0x18, 194 => 0x3, 241 => 0x6, 258 => 0x32, 259 => 0x33, 260 => 0x39, 333 => 0x100f, 352 => 0x41, 388 => 0x21, 395 => 0xb, 414 => 0x26, 416 => 0x56, 419 => 0x22, 420 => [0x1003,0x1014], 430 => 0x11, 440 => 0x1c, 441 => 0x19, 454 => 0x2006, 486 => 0x52, 517 => 'Sharpness', 519 => 'Sharpness', 523 => 'Sharpness' },
	'sharpnessadj' => { 108 => 0x20310, 113 => 0x25a, 491 => 0x801a },
	'sharpnessadjon' => { 108 => '0x20310.0' },
	'sharpnessauto' => { 75 => 0x94 },
	'sharpnessfactor' => { 333 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 74 => 0x64, 75 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 78 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 74 => 0x34, 75 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 74 => 0x7c, 75 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 74 => 0x4c, 75 => 0x4c },
	'sharpnessovershoot' => { 491 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 74 => 0x1c, 75 => 0x1c },
	'sharpnessrange' => { 454 => 0x2035 },
	'sharpnesssetting' => { 328 => 0x506, 336 => 0x1013, 442 => 0x12, 459 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 74 => 0x4, 75 => 0x4 },
	'sharpnessstrength' => { 108 => 0x20311 },
	'sharpnessthreshold' => { 491 => 0x801d },
	'sharpnessundershoot' => { 491 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 74 => 0x94, 75 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 74 => 0xac, 75 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 74 => 0xc4, 75 => 0xdc },
	'shiftcols' => { 143 => 0xc70 },
	'shootid' => { 535 => 'shootID' },
	'shootingdistance' => { 108 => 0x20701 },
	'shootinginfodisplay' => { 307 => '13.2', 308 => '5.1', 316 => '10.2', 317 => '4.1', 320 => '5.1', 322 => '5.3' },
	'shootinginfomonitorofftime' => { 307 => '26.2', 308 => '22.2', 310 => '22.2', 311 => '22.2', 315 => '21.2', 316 => '9.1', 317 => '21.2', 320 => '22.2', 321 => '22.2', 322 => '22.2', 323 => 0x3d, 324 => 0x37, 325 => 0x37, 326 => 0x37 },
	'shootingmode' => { 161 => 'ShootingMode', 241 => 0x89, 352 => 0x1f },
	'shootingmodesetting' => { 309 => '5.1' },
	'shortdescription' => { 521 => 'shortdescription' },
	'shortdocumentid' => { 136 => 0xba },
	'shortname' => { 517 => 'ShortName', 519 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 89 => 0x80d },
	'shorttitle' => { 405 => '@sti' },
	'shotdate' => { 546 => 'shotDate' },
	'shotday' => { 546 => 'shotDay' },
	'shotlocation' => { 546 => 'shotLocation' },
	'shotlogdata' => { 499 => 'shot_log_data' },
	'shotname' => { 413 => 'shot', 546 => 'shotName' },
	'shotnumber' => { 546 => 'shotNumber' },
	'shotnumbersincepowerup' => { 458 => 0x44e, 477 => 0x1a, 478 => 0x16, 479 => 0xa },
	'shotnumbersincepowerup2' => { 442 => 0x200 },
	'shotsize' => { 546 => 'shotSize' },
	'shotsperinterval' => { 230 => 0x180, 245 => 0x1f0, 246 => 0xb4, 247 => 0xcc, 248 => 0xcc, 249 => 0xc0, 250 => 0xd0, 251 => 0xd0 },
	'showmovement' => { 405 => 'shwm' },
	'shownevent' => { 531 => 'EventExt' },
	'showneventidentifier' => { 531 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 531 => [\'EventExt','EventExtName'] },
	'shutter' => { 473 => 0x20, 474 => 0x26, 475 => 0x26 },
	'shutter-aelock' => { 87 => 0x4, 89 => 0x701, 90 => 0x3, 91 => 0x4, 92 => 0x3, 93 => 0x3, 94 => 0x4, 95 => 0x2 },
	'shutteraelbutton' => { 88 => 0x4 },
	'shutterbuttonafonbutton' => { 89 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 60 => 0x1, 241 => 0xa7, 271 => [0x6a,0x157,0x24d], 272 => 0x286, 273 => 0x279, 274 => 0x284, 275 => 0x242, 276 => 0x280, 277 => 0x276, 278 => [0x27d,0x27f], 279 => 0x246, 281 => 0x2d6, 282 => 0x321, 283 => 0xbd8, 284 => 0x287, 285 => 0x320, 286 => 0x24a, 287 => 0x5fb, 288 => 0x2d5, 388 => 0x5d, 451 => 0x846, 457 => [0x125,0x14a], 473 => 0x32, 474 => 0x3a, 475 => 0x3a, 476 => 0xa },
	'shuttercount2' => { 473 => 0x4c, 474 => [0x50,0x52,0x58], 475 => 0x50 },
	'shuttercount3' => { 473 => [0x1a0,0x1aa,0x1bd], 474 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 87 => 0xf, 88 => 0xf, 89 => 0x305, 90 => 0xe, 91 => 0xf, 92 => 0x8, 93 => 0x8, 94 => 0xf, 95 => 0x8 },
	'shuttermode' => { 60 => 0x17, 145 => 0x1b, 241 => 0x34 },
	'shutterreleasebuttonae-l' => { 307 => '17.7', 308 => '18.4', 310 => '78.4', 311 => '78.4', 312 => '16.1', 313 => '17.1', 314 => '17.1', 315 => '17.1', 316 => '7.1', 317 => '17.5', 320 => '18.4', 321 => '78.4', 322 => '18.2', 323 => 0x2b, 324 => 0x29, 325 => 0x29, 326 => 0x29 },
	'shutterreleasemethod' => { 102 => 0x1010 },
	'shutterreleasenocfcard' => { 87 => 0x2, 88 => 0x2, 95 => 0xf },
	'shutterreleasetiming' => { 102 => 0x1011 },
	'shutterreleasewithoutlens' => { 89 => 0x711 },
	'shutterspeedlock' => { 308 => '38.1', 310 => '38.1', 311 => '38.1', 320 => '38.1', 321 => '38.1', 323 => 0xbb, 324 => 0xb7, 325 => 0xb7, 326 => 0xb7 },
	'shutterspeedrange' => { 89 => 0x10c },
	'shutterspeedsetting' => { 189 => 0x6, 440 => 0x2f, 441 => 0x28, 442 => 0x0 },
	'shutterspeedvalue' => { 98 => 0x1, 124 => 0x9201, 333 => 0x1000, 397 => 0x400, 523 => 'ShutterSpeedValue' },
	'shuttertype' => { 132 => 0x1050, 352 => 0x9f, 388 => 0x87, 479 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 534 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 143 => 0xe0d },
	'sigmascalingfactorcamera' => { 143 => 0xe0c },
	'sigmascalingfactorlowres' => { 143 => 0xe0b },
	'sigmasizetable' => { 143 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 241 => 0xbf, 245 => 0x9b7 },
	'similarityindex' => { 136 => 0xe4 },
	'singleframebracketing' => { 189 => 0x21 },
	'skilllevel' => { 538 => 'skillLevel' },
	'skintonecorrection' => { 388 => 0x95 },
	'skiplinetime' => { 143 => 0x184e },
	'slaveflashmeteringsegments' => { 388 => 0x20b },
	'slideshowname' => { 535 => 'slideshowName' },
	'slideshownumber' => { 535 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 535 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 245 => 0x364, 247 => 0x24a, 248 => 0x24a, 251 => 0x24a },
	'slowshutter' => { 81 => 0x8 },
	'slowsync' => { 132 => 0x1030 },
	'smartalbumcolor' => { 427 => 0x20 },
	'smartrange' => { 427 => 0xa012 },
	'smileshutter' => { 442 => 0x31 },
	'smileshuttermode' => { 442 => 0x27 },
	'smoothness' => { 124 => 0xfe57, 517 => 'Smoothness', 519 => 'Smoothness' },
	'snapshot' => { 531 => 'SnapshotLink' },
	'snapshotformat' => { 531 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 531 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 531 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 531 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 531 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 512 => 'Snapshots' },
	'snapshotusedvideoframe' => { 531 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 531 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 531 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 531 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 531 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 454 => 0x200f },
	'software' => { 124 => 0x131, 162 => 'Software', 341 => 'Software', 397 => 0x203, 407 => 'software', 430 => 0x18, 502 => 'Software', 542 => 'Software' },
	'softwareversion' => { 413 => ['@swr',"\xa9swr"], 429 => 0x207 },
	'soloist' => { 405 => "\xa9sol" },
	'songwriter' => { 413 => "\xa9swf" },
	'songwriterkeywords' => { 413 => "\xa9swk" },
	'sonycropsize' => { 124 => 0x74c8 },
	'sonycroptopleft' => { 124 => 0x74c7 },
	'sonydatetime' => { 462 => 0x6, 464 => 0x1b6, 465 => 0x210, 466 => 0x1fe, 467 => 0x22c },
	'sonydatetime2' => { 473 => 0x51 },
	'sonyexposuretime' => { 473 => 0x3a, 474 => 0x46, 475 => [0x66,0x46], 476 => 0x1a },
	'sonyexposuretime2' => { 486 => 0xe },
	'sonyfnumber' => { 473 => 0x3c, 474 => 0x48, 475 => [0x68,0x48], 476 => 0x1c, 486 => 0x14 },
	'sonyimageheight' => { 462 => 0x1a, 477 => 0x44, 478 => 0x3f },
	'sonyimageheightmax' => { 486 => 0x40 },
	'sonyimagesize' => { 189 => 0x3b, 440 => 0x54, 441 => 0x54, 442 => 0x9 },
	'sonyimagewidth' => { 462 => 0x1c },
	'sonyimagewidthmax' => { 486 => 0x3e },
	'sonyiso' => { 464 => 0x1218, 465 => 0x11f4, 466 => 0x1270, 467 => [0x1254,0x1258,0x1280], 468 => 0x113c, 469 => 0x344, 470 => 0x346, 471 => 0x320, 486 => 0x4 },
	'sonymaxaperture' => { 473 => 0x0, 474 => 0x0 },
	'sonymaxaperturevalue' => { 486 => 0x16 },
	'sonyminaperture' => { 473 => 0x1, 474 => 0x1 },
	'sonymodelid' => { 454 => 0xb001 },
	'sonyquality' => { 189 => 0x3c },
	'sonyrawimagesize' => { 124 => 0x7038 },
	'sonytimeminsec' => { 474 => 0x61 },
	'sortalbum' => { 405 => 'soal' },
	'sortalbumartist' => { 405 => 'soaa' },
	'sortartist' => { 405 => 'soar' },
	'sortcomposer' => { 405 => 'soco' },
	'sortname' => { 405 => 'sonm', 517 => 'SortName', 519 => 'SortName' },
	'sortshow' => { 405 => 'sosn' },
	'soundengineer' => { 405 => "\xa9sne" },
	'source' => { 136 => 0x73, 341 => 'Source', 520 => 'source', 521 => 'source', 534 => 'Source' },
	'sourcecount' => { 506 => 'SourceCount' },
	'sourcecredits' => { 413 => "\xa9src" },
	'sourcedirectoryindex' => { 374 => 0x0 },
	'sourcefileindex' => { 374 => 0x2 },
	'sourcephotoscount' => { 505 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 143 => 0x1390 },
	'spatialfrequencyresponse' => { 523 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 523 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 523 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 523 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 523 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 546 => 'speakerPlacement' },
	'specialeffectlevel' => { 118 => 0x3030 },
	'specialeffectmode' => { 118 => 0x2076 },
	'specialeffectsetting' => { 118 => 0x3031 },
	'specialinstructions' => { 136 => 0x28 },
	'specialmode' => { 333 => 0x200, 429 => 0x200 },
	'specialoccasion' => { 538 => 'specialOccasion' },
	'specialtypeid' => { 499 => 'SpecialTypeID' },
	'spectralsensitivity' => { 124 => 0x8824, 523 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => 0x32b, 44 => 0x281, 45 => 0x295, 48 => [0x2b9,0x2d0,0x2d4], 49 => [0x56a,0x296], 50 => 0x1e4, 51 => [0x1fd,0x2dd], 52 => [0x231,0x30f], 53 => 0x31d },
	'speedx' => { 120 => 0x3, 413 => "\xa9xsp" },
	'speedy' => { 120 => 0x4, 413 => "\xa9ysp" },
	'speedz' => { 120 => 0x5, 413 => "\xa9zsp" },
	'spherical' => { 506 => 'Spherical' },
	'sphericalvideoxml' => { 125 => 'SphericalVideoXML' },
	'splitcolumn' => { 397 => 0x222 },
	'splittoningbalance' => { 517 => 'SplitToningBalance', 519 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 517 => 'SplitToningHighlightHue', 519 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 517 => 'SplitToningHighlightSaturation', 519 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 517 => 'SplitToningShadowHue', 519 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 517 => 'SplitToningShadowSaturation', 519 => 'SplitToningShadowSaturation' },
	'sport' => { 536 => 'sport' },
	'spotfocuspointx' => { 186 => 0x2d },
	'spotfocuspointy' => { 186 => 0x2e },
	'spotmeteringmode' => { 36 => 0x27 },
	'spotmeterlinktoafpoint' => { 89 => 0x107 },
	'sractive' => { 368 => '17.1' },
	'srawquality' => { 36 => 0x2e },
	'srfocallength' => { 390 => 0x3 },
	'srgbrendering' => { 339 => 'sRGB' },
	'srhalfpresstime' => { 390 => 0x2 },
	'srresult' => { 390 => 0x0, 391 => 0x0 },
	'stackedimage' => { 328 => 0x804 },
	'standardmatrixcustom' => { 143 => 0x7d4 },
	'standardmatrixdaylight' => { 143 => 0x7d0 },
	'standardmatrixflash' => { 143 => 0x7d3 },
	'standardmatrixfluorescent' => { 143 => 0x7d2 },
	'standardmatrixtungsten' => { 143 => 0x7d1 },
	'standardoutputhighlightpoint' => { 114 => 0x14 },
	'standardoutputsensitivity' => { 124 => 0x8831, 524 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 114 => 0x15 },
	'standardrawcolortone' => { 114 => 0xd },
	'standardrawcontrast' => { 114 => 0xf },
	'standardrawhighlight' => { 114 => 0x75 },
	'standardrawhighlightpoint' => { 114 => 0x12 },
	'standardrawlinear' => { 114 => 0x10 },
	'standardrawsaturation' => { 114 => 0xe },
	'standardrawshadow' => { 114 => 0x7e },
	'standardrawshadowpoint' => { 114 => 0x13 },
	'standardrawsharpness' => { 114 => 0x11 },
	'standardunsharpmaskfineness' => { 114 => 0x94 },
	'standardunsharpmaskstrength' => { 114 => 0x92 },
	'standardunsharpmaskthreshold' => { 114 => 0x96 },
	'standardwhitecustom' => { 143 => 0x838 },
	'standardwhitedaylight' => { 143 => 0x834 },
	'standardwhiteflash' => { 143 => 0x837 },
	'standardwhitefluorescent' => { 143 => 0x836 },
	'standardwhitetungsten' => { 143 => 0x835 },
	'standbytimer' => { 308 => '19.1', 310 => '19.1', 311 => '19.1', 314 => '18.1', 315 => '18.1', 320 => '19.1', 321 => '19.1' },
	'starlightview' => { 324 => 0x249, 325 => 0x249, 326 => 0x261 },
	'startingpage' => { 536 => 'startingPage' },
	'startmovieshooting' => { 89 => 0x70d },
	'starttimecode' => { 413 => "\xa9TIM", 546 => 'startTimecode' },
	'starttimecodetimeformat' => { 546 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 546 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 546 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 413 => "\xa9TSZ", 546 => 'startTimeSampleSize' },
	'starttimescale' => { 413 => "\xa9TSC", 546 => 'startTimeScale' },
	'state' => { 166 => 'State', 352 => 0x6b, 534 => 'State' },
	'status' => { 497 => 'Status', 510 => 'Status' },
	'stereomode' => { 506 => 'StereoMode' },
	'stitched' => { 506 => 'Stitched' },
	'stitchingsoftware' => { 505 => 'StitchingSoftware', 506 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 463 => 0x113e, 464 => 0x113e, 465 => 0x111a, 466 => 0x1196, 467 => 0x1172, 468 => 0x102a, 469 => 0x222, 470 => 0x222, 471 => 0x217, 486 => 0xa },
	'storagemethod' => { 193 => 0x12 },
	'storebyorientation' => { 308 => '46.3', 310 => '47.3', 311 => '47.3', 320 => '47.3', 321 => '47.3', 323 => 0xd, 324 => 0xd, 325 => 0xd, 326 => 0xd },
	'storedescription' => { 405 => 'sdes' },
	'storylineidentifier' => { 531 => 'StorylineIdentifier' },
	'straightenangle' => { 300 => 0x2fc08431 },
	'streamready' => { 531 => 'StreamReady' },
	'streamtype' => { 181 => 'StreamType' },
	'stretchmode' => { 546 => 'stretchMode' },
	'studydatetime' => { 494 => 'StudyDateTime' },
	'studydescription' => { 494 => 'StudyDescription' },
	'studyid' => { 494 => 'StudyID' },
	'studyphysician' => { 494 => 'StudyPhysician' },
	'styleperiod' => { 531 => 'StylePeriod' },
	'sub-location' => { 136 => 0x5c },
	'subcommanddialframeadvancezoom' => { 251 => 0x806 },
	'subcommanddialplaybackmode' => { 324 => 0x1cf, 325 => 0x1cf, 326 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 324 => 0x1d1, 326 => 0x1e9 },
	'subfiledata' => { 169 => 'data' },
	'subfiledirectory' => { 169 => '1Directory' },
	'subfilemimetype' => { 169 => '2MIME' },
	'subfilename' => { 169 => '1Name' },
	'subfileresource' => { 169 => 'rsrc' },
	'subfiletype' => { 124 => 0xfe, 169 => '0Type' },
	'subject' => { 337 => 'Subject', 404 => 'Subject', 520 => 'subject', 533 => 'Subject', 547 => 'subject' },
	'subjectarea' => { 124 => 0x9214, 523 => 'SubjectArea' },
	'subjectcode' => { 530 => 'SubjectCode' },
	'subjectdetection' => { 245 => 0x36e, 247 => 0x252, 248 => 0x252, 249 => 0x23e, 250 => 0x252, 251 => 0x252 },
	'subjectdetectionareamf' => { 245 => 0x3ea },
	'subjectdistance' => { 124 => 0x9206, 145 => 0x3e, 523 => 'SubjectDistance' },
	'subjectdistancerange' => { 124 => 0xa40c, 523 => 'SubjectDistanceRange' },
	'subjectlocation' => { 124 => 0xa214, 523 => 'SubjectLocation' },
	'subjectmotion' => { 310 => '78.2', 311 => '78.2', 321 => '78.2', 324 => 0x103, 325 => 0x103, 326 => 0x119 },
	'subjectprogram' => { 186 => 0x22 },
	'subjectreference' => { 136 => 0xc },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 529 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 529 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 119 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 119 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 119 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 124 => 0x9290 },
	'subsectimedigitized' => { 124 => 0x9292 },
	'subsectimeoriginal' => { 124 => 0x9291 },
	'subsection1' => { 536 => 'subsection1' },
	'subsection2' => { 536 => 'subsection2' },
	'subsection3' => { 536 => 'subsection3' },
	'subsection4' => { 536 => 'subsection4' },
	'subselector' => { 308 => '49.1', 310 => '71.1', 311 => '71.1', 321 => '71.1', 323 => 0x93, 324 => 0x8f, 325 => 0x8f, 326 => 0x8f },
	'subselectorassignment' => { 308 => '48.1' },
	'subselectorcenter' => { 310 => '72.1', 311 => '72.1', 321 => '72.1' },
	'subselectorplusdials' => { 308 => '49.2', 310 => '73.1', 311 => '73.1', 321 => '73.1' },
	'subtitle' => { 184 => 'WM/SubTitle', 405 => "\xa9st3", 413 => "\xa9snm", 536 => 'subtitle' },
	'subtitlekeywords' => { 413 => "\xa9snk" },
	'subversionfilename' => { 529 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 529 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 529 => 'SubVersions' },
	'superimposeddisplay' => { 87 => 0xa, 89 => 0x510, 90 => 0x9, 91 => 0xa, 94 => 0xa, 95 => 0xe },
	'supermacro' => { 68 => 0x1a },
	'supplementalcategories' => { 136 => 0x14, 534 => 'SupplementalCategories' },
	'supplementaltype' => { 138 => 0x37 },
	'supplementdisplayid' => { 536 => 'supplementDisplayID' },
	'supplementstartingpage' => { 536 => 'supplementStartingPage' },
	'supplementtitle' => { 536 => 'supplementTitle' },
	'supplychainsource' => { 531 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 531 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 531 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 517 => 'SupportsAmount', 519 => 'SupportsAmount' },
	'supportscolor' => { 517 => 'SupportsColor', 519 => 'SupportsColor' },
	'supportshighdynamicrange' => { 517 => 'SupportsHighDynamicRange', 519 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 517 => 'SupportsMonochrome', 519 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 517 => 'SupportsNormalDynamicRange', 519 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 517 => 'SupportsOutputReferred', 519 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 517 => 'SupportsSceneReferred', 519 => 'SupportsSceneReferred' },
	'svisosetting' => { 368 => 0x14 },
	'swatchcoloranta' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 551 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 551 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 551 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 551 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 551 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 352 => 0x93, 442 => 0x33 },
	'sweeppanoramafieldofview' => { 352 => 0x94 },
	'sweeppanoramasize' => { 442 => 0x32 },
	'switchtoregisteredafpoint' => { 88 => 0x12, 89 => 0x50a },
	'symlink' => { 125 => 'SymLink' },
	'syncreleasemode' => { 310 => '77.1', 311 => '77.1', 321 => '77.1', 323 => 0x45, 324 => 0x41, 325 => 0x41, 326 => 0x41 },
	'system' => { 397 => 0x204 },
	'tagged' => { 399 => 0xdd, 400 => 'Tagged', 512 => 'tagged' },
	'tagslist' => { 522 => 'TagsList' },
	'tagstructure' => { 529 => 'TagStructure' },
	'takenumber' => { 546 => 'takeNumber' },
	'tapename' => { 546 => 'tapeName' },
	'targetaperture' => { 81 => 0x4 },
	'targetaspectratio' => { 342 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 100 => 0x1 },
	'targetdistancesetting' => { 102 => 0x1807 },
	'targetexposuretime' => { 81 => 0x5 },
	'targetimagetype' => { 102 => 0x100a },
	'targetprinter' => { 124 => 0x151 },
	'taxon' => { 123 => 'Taxon' },
	'taxonacceptednameusage' => { 123 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 123 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 123 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 123 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 123 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 123 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 123 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 123 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 123 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 123 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 123 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 123 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 123 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 123 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 123 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 123 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 123 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 123 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 123 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 123 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 123 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 123 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 123 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 123 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 123 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 123 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 123 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 123 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 123 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 123 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 123 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 123 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 123 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 123 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 143 => 0x196f },
	'tda1edgepolarity' => { 143 => 0x1971 },
	'tda1gain' => { 143 => 0x1970 },
	'tda1offset' => { 143 => 0x196e },
	'tda2bandwidth' => { 143 => 0x1979 },
	'tda2edgepolarity' => { 143 => 0x197b },
	'tda2gain' => { 143 => 0x197a },
	'tda2offset' => { 143 => 0x1978 },
	'tda3bandwidth' => { 143 => 0x1983 },
	'tda3edgepolarity' => { 143 => 0x1985 },
	'tda3gain' => { 143 => 0x1984 },
	'tda3offset' => { 143 => 0x1982 },
	'tda4bandwidth' => { 143 => 0x198d },
	'tda4edgepolarity' => { 143 => 0x198f },
	'tda4gain' => { 143 => 0x198e },
	'tda4offset' => { 143 => 0x198c },
	'teaser' => { 536 => 'teaser' },
	'teleconverter' => { 191 => 0x105, 454 => 0x105 },
	'tempampgainx100' => { 143 => 0x1914 },
	'tempo' => { 546 => 'tempo' },
	'temporalcoverage' => { 531 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 531 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 531 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 338 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 338 => 'TermsAndConditionsURL' },
	'testname' => { 125 => 'TestName' },
	'textencoding' => { 240 => 0x4 },
	'textlayername' => { 534 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 534 => 'TextLayers' },
	'textlayertext' => { 534 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 352 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 517 => 'Texture', 519 => 'Texture' },
	'three-dtrackingfacedetection' => { 310 => '1.4', 311 => '1.4', 321 => '1.4' },
	'three-dtrackingwatcharea' => { 310 => '78.1', 311 => '78.1', 321 => '78.1' },
	'thresholding' => { 124 => 0x107 },
	'thumbnailfilename' => { 102 => 0x817 },
	'thumbnailformat' => { 544 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 147 => 0xfa55, 544 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 102 => 0x2008, 119 => 'Exif-ThumbnailImage', 127 => 0x3, 172 => 'data', 333 => 0x100, 405 => 'tnal', 413 => 'thmb', 544 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 172 => '1Name' },
	'thumbnailimagesize' => { 172 => 'ImageSize' },
	'thumbnailimagetype' => { 172 => '0Type' },
	'thumbnailimagevalidarea' => { 68 => 0x13 },
	'thumbnaillength' => { 124 => 0x202 },
	'thumbnailoffset' => { 124 => 0x201 },
	'thumbnailpng' => { 413 => 'thmb' },
	'thumbnails' => { 544 => 'Thumbnails' },
	'thumbnailwidth' => { 147 => 0xfa54, 544 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 536 => 'ticker' },
	'tiffhandling' => { 517 => 'TIFFHandling', 519 => 'TIFFHandling' },
	'tiffmeteringimage' => { 192 => 0x104c, 451 => 0x1110 },
	'tilelength' => { 124 => 0x143 },
	'tilewidth' => { 124 => 0x142 },
	'time' => { 143 => 0x401, 388 => 0x7 },
	'timecodes' => { 124 => 0xc763 },
	'timecreated' => { 136 => 0x3c, 145 => 0x14, 154 => 0x10, 400 => 'TimeCreated' },
	'timelapseshotnumber' => { 355 => 0x10 },
	'timeperiod' => { 536 => 'timePeriod' },
	'timerfunctionbutton' => { 309 => '5.2', 312 => '12.1', 313 => '13.1' },
	'timerlength' => { 89 => 0x80c },
	'timerrecording' => { 352 => 0x96 },
	'timescaleparams' => { 546 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 546 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 546 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 546 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 137 => 0x50 },
	'timeshot' => { 507 => 'TimeShot' },
	'timesignature' => { 546 => 'timeSignature' },
	'timesincepoweron' => { 352 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 327 => 0x8, 341 => 'TimeStamp', 352 => 0xaf, 506 => 'Timestamp', 513 => 'Timestamp', 529 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 82 => 0x1, 245 => 0x8fe, 247 => 0x694, 248 => 0x6a4, 249 => 0x594, 250 => 0x5c4, 251 => 0x5dc, 292 => 0x0, 423 => 0xa },
	'timezonecity' => { 82 => 0x2 },
	'timezonecode' => { 105 => 0x1 },
	'timezoneinfo' => { 105 => 0x2 },
	'timezoneoffset' => { 124 => 0x882a },
	'tint' => { 407 => 'player.movie.visual.tint', 517 => 'Tint', 519 => 'Tint' },
	'title' => { 162 => 'Title', 337 => 'Title', 341 => 'Title', 352 => 0x65, 404 => 'Title', 405 => ['titl',"\xa9nam"], 407 => 'title', 413 => ['titl',"\xa9nam"], 520 => 'title', 533 => 'Title', 544 => 'Title' },
	'togglestyleamount' => { 517 => 'ToggleStyleAmount', 519 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 517 => 'ToggleStyleDigest', 519 => 'ToggleStyleDigest' },
	'tonecomp' => { 241 => 0x81 },
	'tonecurve' => { 78 => 0x1, 388 => 0x402, 517 => 'ToneCurve', 519 => 'ToneCurve' },
	'tonecurveactive' => { 113 => 0x110 },
	'tonecurveadobergb' => { 427 => 0xa043 },
	'tonecurveadobergbdefault' => { 427 => 0xa041 },
	'tonecurveblue' => { 517 => 'ToneCurveBlue', 519 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 491 => 0x9003 },
	'tonecurvebluey' => { 491 => 0x9007 },
	'tonecurvebrightness' => { 108 => 0x20410 },
	'tonecurvebrightnessx' => { 491 => 0x9000 },
	'tonecurvebrightnessy' => { 491 => 0x9004 },
	'tonecurvecolorspace' => { 112 => 0x0 },
	'tonecurvecontrast' => { 108 => 0x20411 },
	'tonecurvegreen' => { 517 => 'ToneCurveGreen', 519 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 491 => 0x9002 },
	'tonecurvegreeny' => { 491 => 0x9006 },
	'tonecurveinputrange' => { 112 => 0x3 },
	'tonecurveinterpolation' => { 113 => 0x159 },
	'tonecurvemode' => { 113 => 0x113 },
	'tonecurvename' => { 517 => 'ToneCurveName', 519 => 'ToneCurveName' },
	'tonecurvename2012' => { 517 => 'ToneCurveName2012', 519 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 108 => '0x20400.1' },
	'tonecurveoutputrange' => { 112 => 0x5 },
	'tonecurveprofilename' => { 143 => 0x1391 },
	'tonecurveproperty' => { 113 => 0x3c },
	'tonecurvepv2012' => { 517 => 'ToneCurvePV2012', 519 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 517 => 'ToneCurvePV2012Blue', 519 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 517 => 'ToneCurvePV2012Green', 519 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 517 => 'ToneCurvePV2012Red', 519 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 517 => 'ToneCurveRed', 519 => 'ToneCurveRed' },
	'tonecurveredx' => { 491 => 0x9001 },
	'tonecurveredy' => { 491 => 0x9005 },
	'tonecurves' => { 388 => 0x403 },
	'tonecurveshape' => { 112 => 0x1 },
	'tonecurvesrgb' => { 427 => 0xa042 },
	'tonecurvesrgbdefault' => { 427 => 0xa040 },
	'tonecurvex' => { 112 => 0xa },
	'tonecurvey' => { 112 => 0xb },
	'tonelevel' => { 328 => 0x52e },
	'tonemap' => { 245 => 0x374, 247 => 0x26a, 248 => 0x26a },
	'tonemapstrength' => { 517 => 'ToneMapStrength', 519 => 'ToneMapStrength' },
	'toningeffect' => { 60 => 0xf, 241 => 0xb3, 258 => 0x38, 259 => 0x40, 260 => 0x48, 420 => 0x1015 },
	'toningeffectauto' => { 75 => 0xa4 },
	'toningeffectfaithful' => { 74 => 0x74, 75 => 0x74 },
	'toningeffectlandscape' => { 74 => 0x44, 75 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 74 => 0x8c, 75 => 0x8c },
	'toningeffectneutral' => { 74 => 0x5c, 75 => 0x5c },
	'toningeffectportrait' => { 74 => 0x2c, 75 => 0x2c },
	'toningeffectstandard' => { 74 => 0x14, 75 => 0x14 },
	'toningeffectuserdef1' => { 74 => 0xa4, 75 => 0xbc },
	'toningeffectuserdef2' => { 74 => 0xbc, 75 => 0xd4 },
	'toningeffectuserdef3' => { 74 => 0xd4, 75 => 0xec },
	'toningsaturation' => { 258 => 0x39, 259 => 0x41, 260 => 0x49 },
	'totalzoom' => { 145 => 0x62 },
	'touchae' => { 352 => 0xab },
	'touchfn' => { 323 => 0x154 },
	'touchfnareatall' => { 323 => 0x15b },
	'touchfnareawide' => { 323 => 0x159 },
	'touchfnrole' => { 323 => 0x155 },
	'track' => { 405 => "\xa9trk", 413 => "\xa9trk" },
	'trackcreatedate' => { 412 => 0x1 },
	'trackmodifydate' => { 412 => 0x2 },
	'tracknumber' => { 405 => 'trkn', 546 => 'trackNumber' },
	'tracks' => { 546 => 'Tracks' },
	'tracksframerate' => { 546 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 546 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 546 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 546 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 546 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 546 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 546 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 546 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 546 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 546 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 546 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 546 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 546 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 546 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 546 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 546 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 546 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 413 => 'kgtt' },
	'trailer' => { 125 => 'Trailer' },
	'trailersignature' => { 169 => 'zmie' },
	'transcript' => { 531 => 'Transcript' },
	'transcriptlink' => { 531 => 'TranscriptLink' },
	'transcriptlinklink' => { 531 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 531 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 124 => 0x12d, 542 => 'TransferFunction' },
	'transfertimenormal' => { 143 => 0x1888 },
	'transfertimetest' => { 143 => 0x1889 },
	'transform' => { 352 => [0x8012,0x59] },
	'transformation' => { 532 => 'Transformation' },
	'transmissionreference' => { 534 => 'TransmissionReference' },
	'trapped' => { 337 => 'Trapped', 533 => 'Trapped' },
	'trashbuttonfunction' => { 89 => 0x710 },
	'travelday' => { 352 => 0x36 },
	'treble' => { 407 => 'player.movie.audio.treble' },
	'triggermode' => { 414 => 0x6, 415 => 0x34, 416 => 0x34 },
	'tstop' => { 124 => 0xc772 },
	'ttl_da_adown' => { 375 => 0x5 },
	'ttl_da_aup' => { 375 => 0x4 },
	'ttl_da_bdown' => { 375 => 0x7 },
	'ttl_da_bup' => { 375 => 0x6 },
	'tungstenawb' => { 365 => 0x1 },
	'tvepisode' => { 405 => 'tves' },
	'tvepisodeid' => { 405 => 'tven' },
	'tvexposuretimesetting' => { 368 => 0x12 },
	'tvnetworkname' => { 405 => 'tvnn' },
	'tvseason' => { 405 => 'tvsn' },
	'tvshow' => { 405 => 'tvsh' },
	'type' => { 501 => 'Type', 520 => 'type', 541 => 'type' },
	'typestatus' => { 123 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 124 => 0xc614 },
	'uniquedocumentid' => { 136 => 0xbb },
	'uniquematrixauto' => { 143 => 0x7e9 },
	'uniquematrixcustom' => { 143 => 0x7e8 },
	'uniquematrixdaylight' => { 143 => 0x7e4 },
	'uniquematrixflash' => { 143 => 0x7e7 },
	'uniquematrixfluorescent' => { 143 => 0x7e6 },
	'uniquematrixtungsten' => { 143 => 0x7e5 },
	'uniqueobjectname' => { 137 => 0x64 },
	'units' => { 502 => 'Units' },
	'unknown_aacr' => { 405 => 'AACR' },
	'unknown_cdek' => { 405 => 'CDEK' },
	'unknown_cdet' => { 405 => 'CDET' },
	'unknownblock' => { 388 => 0x405 },
	'unknownblock1' => { 332 => 0x635 },
	'unknownblock2' => { 332 => 0x636 },
	'unknownblock3' => { 332 => 0x1103 },
	'unknownblock4' => { 332 => 0x1104 },
	'unknowncontrast' => { 114 => 0x45 },
	'unknowndate' => { 397 => 0x212 },
	'unknownev' => { 143 => 0x1 },
	'unknownlinear' => { 114 => 0x46 },
	'unknownnumber' => { 102 => 0x180b },
	'unknownoutputhighlightpoint' => { 114 => 0x4a },
	'unknownoutputshadowpoint' => { 114 => 0x4b },
	'unknownrawhighlight' => { 114 => 0x7b },
	'unknownrawhighlightpoint' => { 114 => 0x48 },
	'unknownrawshadow' => { 114 => 0x84 },
	'unknownrawshadowpoint' => { 114 => 0x49 },
	'unknownsharpness' => { 114 => 0x47 },
	'unknowntags' => { 413 => 'TAGS' },
	'unknowntemperature' => { 126 => 0x4 },
	'unknownthumbnail' => { 413 => 'thmb' },
	'unsharp1color' => { 305 => 0x13 },
	'unsharp1halowidth' => { 305 => 0x19 },
	'unsharp1intensity' => { 305 => 0x17 },
	'unsharp1threshold' => { 305 => 0x1b },
	'unsharp2color' => { 305 => 0x2e },
	'unsharp2halowidth' => { 305 => 0x34 },
	'unsharp2intensity' => { 305 => 0x32 },
	'unsharp2threshold' => { 305 => 0x36 },
	'unsharp3color' => { 305 => 0x49 },
	'unsharp3halowidth' => { 305 => 0x4f },
	'unsharp3intensity' => { 305 => 0x4d },
	'unsharp3threshold' => { 305 => 0x51 },
	'unsharp4color' => { 305 => 0x64 },
	'unsharp4halowidth' => { 305 => 0x6a },
	'unsharp4intensity' => { 305 => 0x68 },
	'unsharp4threshold' => { 305 => 0x6c },
	'unsharpcount' => { 305 => 0x0 },
	'unsharpmask' => { 114 => 0x90, 300 => 0x76a43200 },
	'unsharpmaskfineness' => { 78 => 0xe, 108 => 0x20309 },
	'unsharpmaskstrength' => { 108 => 0x20308 },
	'unsharpmaskthreshold' => { 78 => 0xf, 108 => 0x2030a },
	'uprightcentermode' => { 517 => 'UprightCenterMode', 519 => 'UprightCenterMode' },
	'uprightcenternormx' => { 517 => 'UprightCenterNormX', 519 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 517 => 'UprightCenterNormY', 519 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 517 => 'UprightDependentDigest', 519 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 517 => 'UprightFocalLength35mm', 519 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 517 => 'UprightFocalMode', 519 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 517 => 'UprightFourSegments_0', 519 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 517 => 'UprightFourSegments_1', 519 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 517 => 'UprightFourSegments_2', 519 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 517 => 'UprightFourSegments_3', 519 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 517 => 'UprightFourSegmentsCount', 519 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 517 => 'UprightGuidedDependentDigest', 519 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 517 => 'UprightPreview', 519 => 'UprightPreview' },
	'uprighttransform_0' => { 517 => 'UprightTransform_0', 519 => 'UprightTransform_0' },
	'uprighttransform_1' => { 517 => 'UprightTransform_1', 519 => 'UprightTransform_1' },
	'uprighttransform_2' => { 517 => 'UprightTransform_2', 519 => 'UprightTransform_2' },
	'uprighttransform_3' => { 517 => 'UprightTransform_3', 519 => 'UprightTransform_3' },
	'uprighttransform_4' => { 517 => 'UprightTransform_4', 519 => 'UprightTransform_4' },
	'uprighttransform_5' => { 517 => 'UprightTransform_5', 519 => 'UprightTransform_5' },
	'uprighttransformcount' => { 517 => 'UprightTransformCount', 519 => 'UprightTransformCount' },
	'uprightversion' => { 517 => 'UprightVersion', 519 => 'UprightVersion' },
	'urgency' => { 136 => 0xa, 534 => 'Urgency' },
	'url' => { 162 => 'URL', 341 => 'URL', 402 => 0x40b, 536 => 'url' },
	'url_list' => { 402 => 0x41e },
	'urla-platform' => { 536 => [\'url','urlA-platform'] },
	'urlurl' => { 536 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 89 => 0x10a },
	'usableshootingmodes' => { 89 => 0x109 },
	'usage' => { 537 => 'usage' },
	'usageterms' => { 550 => 'UsageTerms' },
	'usbpowerdelivery' => { 245 => 0x9ac, 247 => 0x762, 248 => 0x772, 249 => 0x664, 250 => 0x694, 251 => 0x6fc },
	'usedialwithouthold' => { 323 => 0xc3, 324 => 0xbf, 325 => 0xbf, 326 => 0xbf },
	'useguidelines' => { 515 => 'useGuidelines' },
	'usepanoramaviewer' => { 505 => 'UsePanoramaViewer' },
	'usercollection' => { 407 => 'collection.user' },
	'usercomment' => { 102 => 0x805, 124 => 0x9286, 523 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 74 => 0xd8, 75 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 74 => 0xda, 75 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 74 => 0xdc, 75 => 0xf4 },
	'userfields' => { 510 => 'UserFields' },
	'userlabel' => { 414 => 0x2b, 415 => 0x5a, 416 => 0x68 },
	'userprofile' => { 347 => 0x302, 351 => 0x34c, 354 => 0x3038 },
	'userrating' => { 407 => 'rating.user', 413 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 88 => 0x7, 89 => 0x501 },
	'uspsnumber' => { 536 => 'uspsNumber' },
	'utmeasting' => { 173 => 'Easting' },
	'utmmapdatum' => { 173 => 'Datum' },
	'utmnorthing' => { 173 => 'Northing' },
	'utmzone' => { 173 => 'Zone' },
	'uuid' => { 517 => 'UUID', 519 => 'UUID' },
	'uv-irfiltercorrection' => { 347 => 0x325 },
	'validbits' => { 332 => 0x611, 333 => 0x102c },
	'validcropcorners' => { 342 => 'ValidCropCorners' },
	'validpixeldepth' => { 336 => 0x611 },
	'variablelowpassfilter' => { 454 => 0x2028 },
	'variousmodes' => { 145 => 0x26 },
	'variousmodes2' => { 145 => 0x3a },
	'variprogram' => { 241 => 0xab },
	'varraydacnominalvalues' => { 143 => 0x191e },
	'vendor' => { 413 => 'vndr' },
	'vendorinfo' => { 495 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 495 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 495 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 495 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 123 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 132 => 0x0, 342 => 'Version', 404 => 'Version', 407 => 'version', 517 => 'Version', 519 => 'Version', 528 => 'Version' },
	'versioncreatedate' => { 491 => 0xd100 },
	'versionid' => { 547 => 'VersionID' },
	'versionidentifier' => { 536 => 'versionIdentifier' },
	'versionmodifydate' => { 491 => 0xd101 },
	'versions' => { 547 => 'Versions' },
	'versionscomments' => { 547 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 547 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 547 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 547 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 547 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 547 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 547 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 547 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 547 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 547 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 547 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 307 => '3.2', 308 => '47.2', 310 => '79.1', 325 => 0x11d, 326 => 0x135 },
	'verticalclockoverlaps' => { 143 => 0x412 },
	'verticalfuncbutton' => { 308 => '42.2', 310 => '67.1', 325 => 0x115, 326 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 325 => 0x1b7, 326 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 308 => '43.1' },
	'verticalfuncplusdials' => { 310 => '68.1' },
	'verticalisobutton' => { 251 => 0x792 },
	'verticalmovieafonbutton' => { 325 => 0x1f9, 326 => 0x211 },
	'verticalmoviefuncbutton' => { 325 => 0x1e1, 326 => 0x1f9 },
	'verticalmultiselector' => { 308 => '42.1', 310 => '66.1', 311 => '66.1', 321 => '66.1', 325 => 0x18f, 326 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 325 => 0x125, 326 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 89 => [0x510,0x51d] },
	'vibrance' => { 511 => 'Vibrance', 517 => 'Vibrance', 519 => 'Vibrance' },
	'vibrationreduction' => { 271 => [0x75,0x82,0x1ae], 279 => '586.1', 286 => '590.2', 290 => 0x4 },
	'videoalphamode' => { 546 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 546 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 546 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 546 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 531 => 'videoBitRate' },
	'videobitratemode' => { 531 => 'videoBitRateMode' },
	'videoburstmode' => { 352 => 0xbb },
	'videoburstresolution' => { 352 => 0xb3 },
	'videocodec' => { 71 => 0x74 },
	'videocolorspace' => { 546 => 'videoColorSpace' },
	'videocompression' => { 132 => 0x3806 },
	'videocompressor' => { 546 => 'videoCompressor' },
	'videodisplayaspectratio' => { 531 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 531 => 'videoEncodingProfile' },
	'videofieldorder' => { 546 => 'videoFieldOrder' },
	'videoframerate' => { 352 => 0x27, 546 => 'videoFrameRate' },
	'videoframesize' => { 546 => 'videoFrameSize' },
	'videoframesizeh' => { 546 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 546 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 546 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 546 => 'videoModDate' },
	'videopixelaspectratio' => { 546 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 546 => 'videoPixelDepth' },
	'videopreburst' => { 352 => 0xc1 },
	'videoquality' => { 118 => 0x4003 },
	'videorecordingmode' => { 132 => 0x3803 },
	'videoshottype' => { 531 => 'VideoShotType' },
	'videoshottypeidentifier' => { 531 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 531 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 531 => 'videoStreamsCount' },
	'viewfinder' => { 397 => 0x455 },
	'viewfinderdisplay' => { 307 => '12.4', 308 => '6.3' },
	'viewfinderwarning' => { 307 => '13.4', 317 => '3.5', 318 => '6.2', 322 => '4.4' },
	'viewfinderwarnings' => { 89 => 0x40a },
	'viewinfoduringexposure' => { 89 => 0x407 },
	'viewingmode' => { 442 => 0x2f, 459 => 0x18 },
	'viewingmode2' => { 442 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 251 => 0x7d2, 324 => 0x2a9 },
	'viewpoint' => { 535 => 'viewpoint' },
	'vignetteamount' => { 517 => 'VignetteAmount', 519 => 'VignetteAmount' },
	'vignettecoefficient1' => { 291 => 0x24 },
	'vignettecoefficient2' => { 291 => 0x34 },
	'vignettecoefficient3' => { 291 => 0x44 },
	'vignettecontrol' => { 241 => 0x2a, 300 => 0x76a43205 },
	'vignettecontrolintensity' => { 300 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 514 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 291 => 0x0 },
	'vignettemidpoint' => { 517 => 'VignetteMidpoint', 519 => 'VignetteMidpoint' },
	'vignetting' => { 420 => 0x1011, 427 => 0xa052 },
	'vignettingcorrection' => { 124 => 0x7031, 427 => 0xa053, 454 => 0x2011 },
	'vignettingcorrparams' => { 124 => 0x7032, 485 => 0x64a, 486 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 427 => 0xa054 },
	'virtualfocallength' => { 532 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 323 => 0x161, 324 => 0x167, 325 => 0x167, 326 => 0x17f },
	'virtualimagexcenter' => { 532 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 532 => 'VirtualImageYCenter' },
	'visualcolor' => { 531 => 'VisualColour' },
	'visualtechnique' => { 535 => 'visualTechnique' },
	'voicememo' => { 429 => 0x216 },
	'volume' => { 536 => 'volume' },
	'vr_0x66' => { 271 => 0x66 },
	'vrdoffset' => { 68 => 0xd0 },
	'vrmode' => { 245 => 0x342, 247 => 0x226, 248 => 0x226, 249 => 0x212, 250 => 0x226, 251 => 0x226, 290 => 0x6 },
	'vrtype' => { 290 => 0x8 },
	'waterdepth' => { 124 => 0x9403, 524 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 192 => 0x19a },
	'wb_bluelevel6500k' => { 192 => 0x18a },
	'wb_bluelevelcustom' => { 192 => 0x18e },
	'wb_bluelevelscloudy' => { 192 => 0x106 },
	'wb_bluelevelsdaylight' => { 192 => 0xea },
	'wb_bluelevelsflash' => { 192 => 0x122 },
	'wb_bluelevelsfluorescent' => { 192 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 192 => 0x254 },
	'wb_bluelevelsshade' => { 192 => 0x176 },
	'wb_bluelevelstungsten' => { 192 => 0xce },
	'wb_gbrglevels' => { 192 => 0xae, 195 => 0x4 },
	'wb_glevel' => { 332 => 0x11f },
	'wb_glevel3000k' => { 332 => 0x113 },
	'wb_glevel3300k' => { 332 => 0x114 },
	'wb_glevel3600k' => { 332 => 0x115 },
	'wb_glevel3900k' => { 332 => 0x116 },
	'wb_glevel4000k' => { 332 => 0x117 },
	'wb_glevel4300k' => { 332 => 0x118 },
	'wb_glevel4500k' => { 332 => 0x119 },
	'wb_glevel4800k' => { 332 => 0x11a },
	'wb_glevel5300k' => { 332 => 0x11b },
	'wb_glevel6000k' => { 332 => 0x11c },
	'wb_glevel6600k' => { 332 => 0x11d },
	'wb_glevel7500k' => { 332 => 0x11e },
	'wb_grbglevels' => { 209 => 0x0, 461 => 0x7303 },
	'wb_grbglevelsauto' => { 85 => 0x2, 461 => 0x7302 },
	'wb_grbglevelscloudy' => { 85 => 0x12 },
	'wb_grbglevelscustom1' => { 85 => 0x42 },
	'wb_grbglevelscustom2' => { 85 => 0x4a },
	'wb_grbglevelsdaylight' => { 85 => 0xa },
	'wb_grbglevelsflash' => { 85 => 0x32 },
	'wb_grbglevelsfluorescent' => { 85 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 85 => 0x2a },
	'wb_grbglevelstungsten' => { 85 => 0x1a },
	'wb_grbglevelsunderwater' => { 85 => 0x3a },
	'wb_rbgglevels' => { 206 => 0x0 },
	'wb_rblevels' => { 210 => 0x270, 241 => 0xc, 332 => 0x100 },
	'wb_rblevels1' => { 358 => 0x2 },
	'wb_rblevels2' => { 358 => 0x5 },
	'wb_rblevels3' => { 358 => 0x8 },
	'wb_rblevels3000k' => { 332 => 0x102 },
	'wb_rblevels3300k' => { 332 => 0x103 },
	'wb_rblevels3500k' => { 192 => 0x430 },
	'wb_rblevels3600k' => { 332 => 0x104 },
	'wb_rblevels3900k' => { 332 => 0x105 },
	'wb_rblevels4' => { 358 => 0xb },
	'wb_rblevels4000k' => { 332 => 0x106 },
	'wb_rblevels4300k' => { 332 => 0x107 },
	'wb_rblevels4500k' => { 332 => 0x108 },
	'wb_rblevels4800k' => { 332 => 0x109 },
	'wb_rblevels5' => { 358 => 0xe },
	'wb_rblevels5300k' => { 332 => 0x10a },
	'wb_rblevels6' => { 358 => 0x11 },
	'wb_rblevels6000k' => { 332 => 0x10b },
	'wb_rblevels6500k' => { 192 => 0x420 },
	'wb_rblevels6600k' => { 332 => 0x10c },
	'wb_rblevels7' => { 358 => 0x14 },
	'wb_rblevels7500k' => { 332 => 0x10d },
	'wb_rblevelsauto' => { 210 => 0x272, 336 => 0x110 },
	'wb_rblevelscloudy' => { 192 => 0x3f0, 194 => 0x10, 210 => 0x296, 336 => 0x121 },
	'wb_rblevelscoolwhitef' => { 192 => 0x308, 194 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 336 => 0x132 },
	'wb_rblevelscustom' => { 192 => 0x424, 194 => 0x1c },
	'wb_rblevelscwb1' => { 332 => 0x10e },
	'wb_rblevelscwb2' => { 332 => 0x10f },
	'wb_rblevelscwb3' => { 332 => 0x110 },
	'wb_rblevelscwb4' => { 332 => 0x111 },
	'wb_rblevelsdaylight' => { 192 => [0x3ec,0x528], 194 => 0xc, 210 => 0x274 },
	'wb_rblevelsdaylightf' => { 194 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 336 => 0x130 },
	'wb_rblevelsdaywhitef' => { 194 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 336 => 0x131 },
	'wb_rblevelseveningsunlight' => { 336 => 0x124 },
	'wb_rblevelsfineweather' => { 336 => 0x122 },
	'wb_rblevelsflash' => { 192 => [0x3f4,0x304], 194 => 0x18, 210 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 210 => 0x290 },
	'wb_rblevelsincandescent' => { 210 => 0x282 },
	'wb_rblevelsshade' => { 192 => 0x418, 194 => 0x20, 210 => 0x2b2, 336 => 0x120 },
	'wb_rblevelstungsten' => { 192 => 0x3e8, 194 => 0x8, 336 => 0x123 },
	'wb_rblevelsused' => { 336 => 0x100 },
	'wb_rblevelswhitef' => { 194 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 336 => 0x133 },
	'wb_redlevel3500k' => { 192 => 0x198 },
	'wb_redlevel6500k' => { 192 => 0x188 },
	'wb_redlevelcustom' => { 192 => 0x18c },
	'wb_redlevelscloudy' => { 192 => 0xf8 },
	'wb_redlevelsdaylight' => { 192 => 0xdc },
	'wb_redlevelsflash' => { 192 => 0x114 },
	'wb_redlevelsfluorescent' => { 192 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 192 => 0x1be },
	'wb_redlevelsshade' => { 192 => 0x168 },
	'wb_redlevelstungsten' => { 192 => 0xc0 },
	'wb_rgbglevels' => { 208 => 0x0 },
	'wb_rgblevels' => { 192 => [0x546,0x96], 348 => 0xd, 349 => 0x413, 354 => 0x3036, 397 => 0x107, 463 => 0x117c, 464 => 0x1180, 465 => 0x115c, 466 => 0x11d8, 467 => 0x11b4, 468 => 0x106c, 469 => 0x264, 470 => 0x264, 471 => 0x252 },
	'wb_rgblevels1' => { 359 => 0x2 },
	'wb_rgblevels2' => { 359 => 0x6 },
	'wb_rgblevels2500k' => { 461 => 0x782d },
	'wb_rgblevels3' => { 359 => 0xa },
	'wb_rgblevels3200k' => { 461 => 0x782c },
	'wb_rgblevels4' => { 359 => 0xe },
	'wb_rgblevels4500k' => { 461 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 359 => 0x12 },
	'wb_rgblevels6' => { 359 => 0x16 },
	'wb_rgblevels6000k' => { 461 => 0x782b },
	'wb_rgblevels7' => { 359 => 0x1a },
	'wb_rgblevels8500k' => { 461 => 0x782a },
	'wb_rgblevelsauto' => { 431 => 0x0 },
	'wb_rgblevelscloudy' => { 461 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 431 => 0x15 },
	'wb_rgblevelscustom2' => { 431 => 0x18 },
	'wb_rgblevelscustom3' => { 431 => 0x1b },
	'wb_rgblevelsdaylight' => { 431 => 0x3, 461 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 431 => 0x12, 461 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 431 => 0xf, 461 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 461 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 461 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 461 => 0x7828 },
	'wb_rgblevelsincandescent' => { 431 => 0xc },
	'wb_rgblevelsovercast' => { 431 => 0x9 },
	'wb_rgblevelsshade' => { 431 => 0x6, 461 => 0x7825 },
	'wb_rgblevelstungsten' => { 461 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 432 => 0x0 },
	'wb_rgblevelsunknown1' => { 432 => 0x3 },
	'wb_rgblevelsunknown2' => { 432 => 0x6 },
	'wb_rgblevelsunknown3' => { 432 => 0x9 },
	'wb_rgblevelsunknown4' => { 432 => 0xc },
	'wb_rgblevelsunknown5' => { 432 => 0xf },
	'wb_rgblevelsunknown6' => { 432 => 0x12 },
	'wb_rgblevelsunknown7' => { 432 => 0x15 },
	'wb_rgblevelsunknown8' => { 432 => 0x18 },
	'wb_rgblevelsunknown9' => { 432 => 0x1b },
	'wb_rgbmuldaylight' => { 143 => 0x852 },
	'wb_rgbmulflash' => { 143 => 0x855 },
	'wb_rgbmulfluorescent' => { 143 => 0x854 },
	'wb_rgbmultungsten' => { 143 => 0x853 },
	'wb_rggbblacklevels' => { 37 => 0x25 },
	'wb_rggblevels' => { 124 => 0x7313, 195 => 0x4, 207 => 0x0, 211 => 0x13e8, 212 => 0x38, 461 => 0x7313 },
	'wb_rggblevelsasshot' => { 40 => 0x0, 41 => 0x0, 42 => 0x19, 43 => 0x55, 44 => 0x69, 45 => 0x69, 46 => 0x22, 47 => 0x3f, 50 => 0x3f, 51 => 0x3f, 52 => 0x3f, 53 => 0x47 },
	'wb_rggblevelsauto' => { 37 => 0x1, 40 => 0x5, 41 => 0x8, 42 => 0x1e, 43 => 0x5a, 44 => 0x6e, 46 => 0x18, 47 => 0x44, 50 => 0x44, 51 => 0x44, 52 => 0x44, 53 => 0x4c, 211 => 0x1478, 212 => 0x114, 427 => 0xa022, 461 => 0x7312 },
	'wb_rggblevelsblack' => { 427 => 0xa028 },
	'wb_rggblevelscloudy' => { 37 => 0xd, 40 => 0x1e, 41 => 0x30, 42 => 0x2d, 43 => 0xa0, 44 => 0xd7, 45 => 0x78, 46 => 0x31, 47 => 0x58, 50 => 0x71, 51 => 0x8a, 52 => 0x8f, 53 => 0x92, 211 => 0x1408, 212 => 0x60, 388 => 0x20f, 396 => 0x14 },
	'wb_rggblevelscustom' => { 37 => 0x1d, 47 => 0x80, 211 => 0x1468, 212 => 0x100 },
	'wb_rggblevelscustom1' => { 42 => 0x41 },
	'wb_rggblevelscustom2' => { 42 => 0x46 },
	'wb_rggblevelsdaylight' => { 37 => 0x5, 40 => 0x14, 41 => 0x20, 42 => 0x23, 43 => 0x96, 44 => 0xcd, 45 => 0x6e, 46 => 0x27, 47 => 0x4e, 50 => 0x67, 51 => 0x80, 52 => 0x85, 53 => 0x88, 211 => 0x13f8, 212 => 0x4c, 388 => 0x20d, 396 => 0x2 },
	'wb_rggblevelsflash' => { 37 => 0x19, 40 => 0x32, 41 => 0x50, 42 => 0x3c, 43 => 0xb4, 44 => 0xeb, 45 => 0x87, 46 => 0x45, 47 => 0x6c, 50 => 0x85, 51 => 0x9e, 52 => 0xa3, 53 => 0xa6, 211 => 0x1448, 388 => 0x214, 396 => 0x41 },
	'wb_rggblevelsfluorescent' => { 37 => 0x15, 40 => 0x28, 41 => 0x40, 42 => 0x37, 43 => 0xaa, 44 => 0xe1, 45 => 0x82, 46 => 0x3b, 47 => 0x62, 50 => 0x7b, 51 => 0x94, 52 => 0x99, 53 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 212 => 0xc4, 388 => 0x211, 396 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 396 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 212 => 0xb0, 388 => 0x212, 396 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 211 => 0x1438, 212 => 0x9c, 388 => 0x213, 396 => 0x38 },
	'wb_rggblevelshtmercury' => { 212 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 427 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 427 => 0xa024 },
	'wb_rggblevelskelvin' => { 37 => 0x21, 40 => 0x2d, 41 => 0x48, 43 => 0xaf, 44 => 0xe6, 46 => 0x40, 47 => 0x67, 50 => 0x80, 51 => 0x99, 52 => 0x9e, 53 => 0xa1 },
	'wb_rggblevelsmeasured' => { 40 => 0xa, 41 => 0x10, 43 => 0x5f, 44 => 0x73, 47 => 0x49, 50 => 0x49, 51 => 0x49, 52 => 0x49, 53 => 0x51 },
	'wb_rggblevelspc1' => { 46 => 0x90, 47 => 0x71 },
	'wb_rggblevelspc2' => { 46 => 0x95, 47 => 0x76 },
	'wb_rggblevelspc3' => { 46 => 0x9a, 47 => 0x7b },
	'wb_rggblevelsshade' => { 37 => 0x9, 40 => 0x19, 41 => 0x28, 42 => 0x28, 43 => 0x9b, 44 => 0xd2, 45 => 0x73, 46 => 0x2c, 47 => 0x53, 50 => 0x6c, 51 => 0x85, 52 => 0x8a, 53 => 0x8d, 212 => 0x74, 388 => 0x20e, 396 => 0xb },
	'wb_rggblevelstungsten' => { 37 => 0x11, 40 => 0x23, 41 => 0x38, 42 => 0x32, 43 => 0xa5, 44 => 0xdc, 45 => 0x7d, 46 => 0x36, 47 => 0x5d, 50 => 0x76, 51 => 0x8f, 52 => 0x94, 53 => 0x97, 211 => 0x1428, 212 => 0x88, 388 => 0x210, 396 => 0x1d },
	'wb_rggblevelsuncorrected' => { 427 => 0xa021 },
	'wb_rggblevelsunknown' => { 40 => 0xf, 41 => 0x18, 43 => 0x64, 44 => 0x78, 46 => 0x1d, 50 => 0x4e, 51 => 0x4e, 52 => 0x4e, 53 => 0x56, 396 => 0x53 },
	'wb_rggblevelsunknown10' => { 40 => 0x5f, 41 => 0x98, 43 => 0x91, 44 => 0xa5, 45 => 0xb4, 46 => 0x72, 50 => 0x9e, 51 => 0x7b, 52 => 0x7b, 53 => 0x83 },
	'wb_rggblevelsunknown11' => { 40 => 0x64, 41 => 0xa0, 43 => 0xb9, 44 => [0xaa,0xaf], 45 => 0xb9, 46 => 0x77, 50 => 0xa3, 51 => 0xa3, 52 => 0x80, 53 => 0xab },
	'wb_rggblevelsunknown12' => { 40 => 0x69, 41 => 0xa8, 43 => 0xbe, 44 => 0xb4, 45 => 0xbe, 46 => 0x7c, 50 => 0xa8, 51 => 0xa8, 52 => 0xa8, 53 => 0xb0 },
	'wb_rggblevelsunknown13' => { 40 => 0x6e, 41 => 0xb0, 43 => 0xc3, 44 => 0xb9, 45 => 0xc3, 46 => 0x81, 50 => 0xad, 51 => 0xad, 52 => 0xad, 53 => 0xb5 },
	'wb_rggblevelsunknown14' => { 43 => 0xc8, 44 => 0xbe, 45 => 0xc8, 46 => 0x86, 50 => 0xb2, 51 => 0xb2, 52 => 0xb2, 53 => 0xba },
	'wb_rggblevelsunknown15' => { 43 => 0xcd, 44 => 0xc3, 45 => 0xcd, 46 => 0x8b, 50 => 0xb7, 51 => 0xb7, 52 => 0xb7, 53 => 0xbf },
	'wb_rggblevelsunknown16' => { 43 => 0xd2, 44 => 0xc8, 45 => 0xd2, 46 => 0x9f, 51 => 0xbc, 52 => 0xbc, 53 => 0xc4 },
	'wb_rggblevelsunknown17' => { 43 => 0xd7, 44 => 0xf0, 45 => 0xd7, 51 => 0xc1, 52 => 0xc1, 53 => 0xc9 },
	'wb_rggblevelsunknown18' => { 43 => 0xdc, 44 => 0xf5, 45 => 0xdc, 51 => 0xc6, 52 => 0xc6, 53 => 0xce },
	'wb_rggblevelsunknown19' => { 43 => 0xe1, 44 => 0xfa, 45 => 0xe1, 51 => 0xcb, 52 => 0xcb, 53 => 0xd3 },
	'wb_rggblevelsunknown2' => { 40 => 0x37, 41 => 0x58, 43 => 0x69, 44 => 0x7d, 45 => 0x8c, 46 => 0x4a, 50 => 0x53, 51 => 0x53, 52 => 0x53, 53 => 0x5b },
	'wb_rggblevelsunknown20' => { 43 => 0xe6, 44 => 0xff, 45 => 0xe6, 51 => 0xd0, 52 => 0xd0, 53 => 0xd8 },
	'wb_rggblevelsunknown21' => { 43 => 0xeb, 44 => 0x104, 45 => 0xeb, 52 => 0xd5, 53 => 0xdd },
	'wb_rggblevelsunknown22' => { 43 => 0xf0, 44 => 0x109, 45 => 0xf0, 52 => 0xda, 53 => 0xe2 },
	'wb_rggblevelsunknown23' => { 43 => 0xf5, 44 => 0x10e, 45 => 0xf5, 52 => 0xdf, 53 => 0xe7 },
	'wb_rggblevelsunknown24' => { 43 => 0xfa, 44 => 0x113, 45 => 0xfa, 52 => 0xe4, 53 => 0xec },
	'wb_rggblevelsunknown25' => { 43 => 0xff, 44 => 0x118, 45 => 0xff, 52 => 0xe9, 53 => 0xf1 },
	'wb_rggblevelsunknown26' => { 43 => 0x104, 44 => 0x11d, 45 => 0x104, 52 => 0xee, 53 => 0xf6 },
	'wb_rggblevelsunknown27' => { 43 => 0x109, 44 => 0x122, 45 => 0x109, 52 => 0xf3, 53 => 0xfb },
	'wb_rggblevelsunknown28' => { 43 => 0x10e, 45 => 0x10e, 52 => 0xf8, 53 => 0x100 },
	'wb_rggblevelsunknown29' => { 43 => 0x113, 45 => 0x113, 52 => 0xfd, 53 => 0x105 },
	'wb_rggblevelsunknown3' => { 40 => 0x3c, 41 => 0x60, 43 => 0x6e, 44 => 0x82, 45 => 0x91, 46 => 0x4f, 50 => 0x58, 51 => 0x58, 52 => 0x58, 53 => 0x60 },
	'wb_rggblevelsunknown30' => { 45 => 0x118, 52 => 0x102 },
	'wb_rggblevelsunknown31' => { 45 => 0x11d },
	'wb_rggblevelsunknown32' => { 45 => 0x122 },
	'wb_rggblevelsunknown33' => { 45 => 0x127 },
	'wb_rggblevelsunknown4' => { 40 => 0x41, 41 => 0x68, 43 => 0x73, 44 => 0x87, 45 => 0x96, 46 => 0x54, 50 => 0x5d, 51 => 0x5d, 52 => 0x5d, 53 => 0x65 },
	'wb_rggblevelsunknown5' => { 40 => 0x46, 41 => 0x70, 43 => 0x78, 44 => 0x8c, 45 => 0x9b, 46 => 0x59, 50 => 0x62, 51 => 0x62, 52 => 0x62, 53 => 0x6a },
	'wb_rggblevelsunknown6' => { 40 => 0x4b, 41 => 0x78, 43 => 0x7d, 44 => 0x91, 45 => 0xa0, 46 => 0x5e, 50 => 0x8a, 51 => 0x67, 52 => 0x67, 53 => 0x6f },
	'wb_rggblevelsunknown7' => { 40 => 0x50, 41 => 0x80, 43 => 0x82, 44 => 0x96, 45 => 0xa5, 46 => 0x63, 50 => 0x8f, 51 => 0x6c, 52 => 0x6c, 53 => 0x74 },
	'wb_rggblevelsunknown8' => { 40 => 0x55, 41 => 0x88, 43 => 0x87, 44 => 0x9b, 45 => 0xaa, 46 => 0x68, 50 => 0x94, 51 => 0x71, 52 => 0x71, 53 => 0x79 },
	'wb_rggblevelsunknown9' => { 40 => 0x5a, 41 => 0x90, 43 => 0x8c, 44 => 0xa0, 45 => 0xaf, 46 => 0x6d, 50 => 0x99, 51 => 0x76, 52 => 0x76, 53 => 0x7e },
	'wb_rggblevelsuserselected' => { 396 => 0x5c },
	'wbadjblueamber' => { 108 => 0x20106 },
	'wbadjbluebalance' => { 306 => 0x8 },
	'wbadjcolortemp' => { 108 => 0x20102, 113 => 0x1a },
	'wbadjlighting' => { 306 => 0x14 },
	'wbadjmagentagreen' => { 108 => 0x20105 },
	'wbadjmode' => { 306 => 0x10 },
	'wbadjredbalance' => { 306 => 0x0 },
	'wbadjrggblevels' => { 108 => 0x20125, 113 => 0x6 },
	'wbadjtemperature' => { 306 => 0x18 },
	'wbadjtint' => { 306 => 0x25 },
	'wbbluelevel' => { 347 => 0x324, 352 => 0x8006, 357 => 0x26 },
	'wbbracketingsteps' => { 203 => 0x10, 204 => 0x10, 280 => 0x174d },
	'wbbracketmode' => { 60 => 0x9 },
	'wbbracketshotnumber' => { 192 => 0x2b, 420 => 0x101a },
	'wbbracketvalueab' => { 60 => 0xc },
	'wbbracketvaluegm' => { 60 => 0xd },
	'wbbutton' => { 248 => 0x806, 251 => 0x80a },
	'wbbuttonplaybackmode' => { 324 => 0x1c5 },
	'wbfinetuneactive' => { 113 => 0x24 },
	'wbfinetunesaturation' => { 113 => 0x28 },
	'wbfinetunetone' => { 113 => 0x2c },
	'wbgreenlevel' => { 347 => 0x323, 352 => 0x8005, 357 => 0x25 },
	'wbmediaimagesizesetting' => { 89 => 0x708 },
	'wbmode' => { 194 => 0x4, 333 => 0x1015 },
	'wbredlevel' => { 347 => 0x322, 352 => 0x8004, 357 => 0x24 },
	'wbscale' => { 195 => 0x0 },
	'wbshiftab' => { 78 => 0xc, 352 => 0x46, 369 => 0x10 },
	'wbshiftab_gm' => { 454 => 0x2014 },
	'wbshiftab_gm_precise' => { 454 => 0x2026 },
	'wbshiftcreativecontrol' => { 352 => 0x92 },
	'wbshiftgm' => { 78 => 0xd, 352 => 0x47, 369 => 0x11 },
	'wbshiftintelligentauto' => { 352 => 0x8b },
	'wbtype1' => { 358 => 0x1, 359 => 0x1 },
	'wbtype2' => { 358 => 0x4, 359 => 0x5 },
	'wbtype3' => { 358 => 0x7, 359 => 0x9 },
	'wbtype4' => { 358 => 0xa, 359 => 0xd },
	'wbtype5' => { 358 => 0xd, 359 => 0x11 },
	'wbtype6' => { 358 => 0x10, 359 => 0x15 },
	'wbtype7' => { 358 => 0x13, 359 => 0x19 },
	'webstatement' => { 550 => 'WebStatement' },
	'weightedflatsubject' => { 509 => 'weightedFlatSubject' },
	'what' => { 517 => 'What', 519 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 78 => 0x8, 81 => 0x7, 117 => 0x7, 118 => [0x19,0x2012], 124 => [0xa403,0xfe4e], 132 => 0x1002, 143 => 0x3fc, 144 => 0xfa0d, 145 => 0x40, 156 => 0x1a, 186 => 0x3, 187 => 0xe, 188 => 0x4, 189 => 0xb, 191 => 0x115, 241 => 0x5, 289 => 0x7, 347 => 0x304, 352 => 0x3, 354 => 0x3033, 388 => 0x19, 395 => 0x7, 419 => 0x26, 420 => 0x1003, 430 => [0x88,0x3c,0x7,0x58], 440 => 0xf, 441 => 0xe, 454 => [0x115,0xb054], 517 => 'WhiteBalance', 519 => 'WhiteBalance', 523 => 'WhiteBalance' },
	'whitebalance0' => { 181 => 'WhiteBalance0' },
	'whitebalance1' => { 181 => 'WhiteBalance1' },
	'whitebalance2' => { 181 => 'WhiteBalance2', 328 => 0x500 },
	'whitebalanceadj' => { 108 => 0x20101, 113 => 0x18, 300 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 365 => 0x0 },
	'whitebalancebias' => { 118 => 0x2011, 333 => 0x304, 352 => 0x23 },
	'whitebalanceblue' => { 78 => 0x7 },
	'whitebalancebracket' => { 328 => 0x502, 333 => 0x303 },
	'whitebalancebracketing' => { 189 => 0x22, 192 => 0x2c, 451 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 325 => 0x1c5, 326 => 0x1dd },
	'whitebalancecomp' => { 336 => 0x1001 },
	'whitebalancedetected' => { 143 => 0x3fb },
	'whitebalancefinetune' => { 132 => 0x100a, 189 => 0x38, 191 => 0x112, 241 => [0xb,0x3f], 420 => 0x1004, 440 => 0x6, 441 => 0x5, 454 => 0x112 },
	'whitebalancemode' => { 143 => 0x3fa, 388 => 0x1a },
	'whitebalancered' => { 78 => 0x6 },
	'whitebalanceset' => { 368 => 0xa },
	'whitebalancesetting' => { 189 => 0x23, 440 => 0x5, 441 => 0x4, 442 => 0x16, 459 => 0xd },
	'whitebalancesetup' => { 427 => 0x41 },
	'whitebalancetemperature' => { 328 => 0x501 },
	'whiteboard' => { 333 => 0x301 },
	'whitelevel' => { 124 => 0xc61d, 388 => 0x7e, 461 => 0x787f },
	'whitepoint' => { 124 => 0x13e, 351 => 0x35d, 388 => 0x201, 542 => 'WhitePoint' },
	'whites2012' => { 517 => 'Whites2012', 519 => 'Whites2012' },
	'whitesadj' => { 491 => 0x9017 },
	'wideadapter' => { 420 => 0x1017 },
	'widefocuszone' => { 186 => 0x2f },
	'widerange' => { 429 => 0x20f },
	'windmode' => { 143 => 0x3f4 },
	'windnoisereduction' => { 247 => 0x352, 248 => 0x352, 249 => 0x2d6, 250 => 0x2fe, 251 => 0x2fe },
	'windowlocation' => { 413 => 'WLOC' },
	'windowsatom' => { 518 => 'windowsAtom' },
	'windowsatomextension' => { 518 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 518 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 518 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 536 => 'wordCount' },
	'work' => { 405 => "\xa9wrk" },
	'workcolorspace' => { 108 => 0x10200, 113 => 0x270 },
	'workflowtag' => { 531 => 'WorkflowTag' },
	'workflowtagcvid' => { 531 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 531 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 531 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 531 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 525 => 'WorkToDo' },
	'worldtimelocation' => { 352 => 0x3a, 388 => 0x22, 394 => '0.1' },
	'writer' => { 184 => 'WM/Writer' },
	'writer-editor' => { 136 => 0x7a },
	'x3filllight' => { 430 => 0x12 },
	'xattrmditemwherefroms' => { 179 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 179 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 407 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 407 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 124 => 0x9a00 },
	'xiaomipreviewvideocover' => { 407 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 124 => 0x9999 },
	'xilinxversion' => { 143 => 0x414 },
	'xml' => { 141 => 'xml ' },
	'xmp' => { 111 => 0xffff00f6, 125 => 'XMP' },
	'xmptoolkit' => { 543 => 'xmptk' },
	'xpauthor' => { 124 => 0x9c9d },
	'xpcomment' => { 124 => 0x9c9c },
	'xpkeywords' => { 124 => 0x9c9e },
	'xposition' => { 124 => 0x11e },
	'xpsubject' => { 124 => 0x9c9f },
	'xptitle' => { 124 => 0x9c9b },
	'xresolution' => { 124 => 0x11a, 139 => 0x3, 403 => 0x0, 542 => 'XResolution' },
	'xyresolution' => { 128 => 0x3 },
	'yaw' => { 120 => 0x7, 413 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 256 => 0x8, 425 => 0x0 },
	'ycbcrcoefficients' => { 124 => 0x211, 542 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 124 => 0x213, 542 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 124 => 0x212, 542 => 'YCbCrSubSampling' },
	'year' => { 405 => 'yrrc', 407 => 'year', 413 => 'yrrc' },
	'yearcreated' => { 145 => 0x10, 154 => 0xc },
	'yellowhsl' => { 108 => 0x20912 },
	'yield' => { 538 => 'yield' },
	'yposition' => { 124 => 0x11f },
	'yresolution' => { 124 => 0x11b, 139 => 0x5, 403 => 0x4, 542 => 'YResolution' },
	'zebrapatterntonerange' => { 324 => 0x211, 325 => 0x211, 326 => 0x229 },
	'zoneidentifier' => { 125 => 'ZoneIdentifier' },
	'zonematching' => { 191 => 0x10a, 194 => [0x3a,0x4a], 454 => 0xb024 },
	'zonematchingmode' => { 189 => 0x14 },
	'zonematchingon' => { 188 => 0x75 },
	'zonematchingvalue' => { 440 => 0x1f },
	'zoomedpreviewlength' => { 333 => 0xf05 },
	'zoomedpreviewsize' => { 333 => 0xf06 },
	'zoomedpreviewstart' => { 333 => 0xf04 },
	'zoomsourcewidth' => { 36 => 0x24 },
	'zoomstepcount' => { 331 => 0x300, 333 => 0x100d },
	'zoomtargetwidth' => { 36 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligo_json' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2024, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
