/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;

public class MethylScore
implements LocusScore {
    String chr;
    int start;
    int end;
    Strand strand;
    float percentMethylated;
    int totalCount;

    public MethylScore(String chr, int start, int end, Strand strand, float percentMethylated, int totalCount) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.strand = strand;
        this.percentMethylated = percentMethylated;
        this.totalCount = totalCount;
    }

    public String getChr() {
        return this.chr;
    }

    public String getContig() {
        return this.chr;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public float getScore() {
        return this.percentMethylated;
    }

    public int getCount() {
        return this.totalCount;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        return this.percentMethylated + "% [" + this.totalCount + "]" + (this.strand == Strand.POSITIVE ? " (+)" : (this.strand == Strand.NEGATIVE ? " (-)" : ""));
    }
}

