/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.hash;

import gnu.java.security.hash.BaseHash;
import gnu.java.security.util.Util;

public class Sha256
extends BaseHash {
    private static final int[] k = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int BLOCK_SIZE = 64;
    private static final String DIGEST0 = "BA7816BF8F01CFEA414140DE5DAE2223B00361A396177A9CB410FF61F20015AD";
    private static final int[] w = new int[64];
    private static Boolean valid;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int h5;
    private int h6;
    private int h7;

    public static final int[] G(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, int n9) {
        return Sha256.sha(n, n2, n3, n4, n5, n6, n7, n8, byArray, n9);
    }

    public Object clone() {
        return new Sha256(this);
    }

    protected void transform(byte[] byArray, int n) {
        int[] nArray = Sha256.sha(this.h0, this.h1, this.h2, this.h3, this.h4, this.h5, this.h6, this.h7, byArray, n);
        this.h0 = nArray[0];
        this.h1 = nArray[1];
        this.h2 = nArray[2];
        this.h3 = nArray[3];
        this.h4 = nArray[4];
        this.h5 = nArray[5];
        this.h6 = nArray[6];
        this.h7 = nArray[7];
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int n2 = n < 56 ? 56 - n : 120 - n;
        byte[] byArray = new byte[n2 + 8];
        byArray[0] = -128;
        long l = this.count << 3;
        byArray[n2++] = (byte)(l >>> 56);
        byArray[n2++] = (byte)(l >>> 48);
        byArray[n2++] = (byte)(l >>> 40);
        byArray[n2++] = (byte)(l >>> 32);
        byArray[n2++] = (byte)(l >>> 24);
        byArray[n2++] = (byte)(l >>> 16);
        byArray[n2++] = (byte)(l >>> 8);
        byArray[n2] = (byte)l;
        return byArray;
    }

    protected byte[] getResult() {
        return new byte[]{(byte)(this.h0 >>> 24), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 8), (byte)this.h0, (byte)(this.h1 >>> 24), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 8), (byte)this.h1, (byte)(this.h2 >>> 24), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 8), (byte)this.h2, (byte)(this.h3 >>> 24), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 8), (byte)this.h3, (byte)(this.h4 >>> 24), (byte)(this.h4 >>> 16), (byte)(this.h4 >>> 8), (byte)this.h4, (byte)(this.h5 >>> 24), (byte)(this.h5 >>> 16), (byte)(this.h5 >>> 8), (byte)this.h5, (byte)(this.h6 >>> 24), (byte)(this.h6 >>> 16), (byte)(this.h6 >>> 8), (byte)this.h6, (byte)(this.h7 >>> 24), (byte)(this.h7 >>> 16), (byte)(this.h7 >>> 8), (byte)this.h7};
    }

    protected void resetContext() {
        this.h0 = 1779033703;
        this.h1 = -1150833019;
        this.h2 = 1013904242;
        this.h3 = -1521486534;
        this.h4 = 1359893119;
        this.h5 = -1694144372;
        this.h6 = 528734635;
        this.h7 = 1541459225;
    }

    public boolean selfTest() {
        if (valid == null) {
            Sha256 sha256 = new Sha256();
            sha256.update((byte)97);
            sha256.update((byte)98);
            sha256.update((byte)99);
            String string = Util.toString(sha256.digest());
            valid = new Boolean(DIGEST0.equals(string));
        }
        return valid;
    }

    private static final synchronized int[] sha(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, int n9) {
        int n10;
        int n11;
        int n12 = n;
        int n13 = n2;
        int n14 = n3;
        int n15 = n4;
        int n16 = n5;
        int n17 = n6;
        int n18 = n7;
        int n19 = n8;
        int n20 = 0;
        while (n20 < 16) {
            Sha256.w[n20] = byArray[n9++] << 24 | (byArray[n9++] & 0xFF) << 16 | (byArray[n9++] & 0xFF) << 8 | byArray[n9++] & 0xFF;
            ++n20;
        }
        n20 = 16;
        while (n20 < 64) {
            n11 = w[n20 - 2];
            n10 = w[n20 - 15];
            Sha256.w[n20] = ((n11 >>> 17 | n11 << 15) ^ (n11 >>> 19 | n11 << 13) ^ n11 >>> 10) + w[n20 - 7] + ((n10 >>> 7 | n10 << 25) ^ (n10 >>> 18 | n10 << 14) ^ n10 >>> 3) + w[n20 - 16];
            ++n20;
        }
        n20 = 0;
        while (n20 < 64) {
            n11 = n19 + ((n16 >>> 6 | n16 << 26) ^ (n16 >>> 11 | n16 << 21) ^ (n16 >>> 25 | n16 << 7)) + (n16 & n17 ^ ~n16 & n18) + k[n20] + w[n20];
            n10 = ((n12 >>> 2 | n12 << 30) ^ (n12 >>> 13 | n12 << 19) ^ (n12 >>> 22 | n12 << 10)) + (n12 & n13 ^ n12 & n14 ^ n13 & n14);
            n19 = n18;
            n18 = n17;
            n17 = n16;
            n16 = n15 + n11;
            n15 = n14;
            n14 = n13;
            n13 = n12;
            n12 = n11 + n10;
            ++n20;
        }
        return new int[]{n + n12, n2 + n13, n3 + n14, n4 + n15, n5 + n16, n6 + n17, n7 + n18, n8 + n19};
    }

    public Sha256() {
        super("sha-256", 32, 64);
    }

    private Sha256(Sha256 sha256) {
        this();
        this.h0 = sha256.h0;
        this.h1 = sha256.h1;
        this.h2 = sha256.h2;
        this.h3 = sha256.h3;
        this.h4 = sha256.h4;
        this.h5 = sha256.h5;
        this.h6 = sha256.h6;
        this.h7 = sha256.h7;
        this.count = sha256.count;
        this.buffer = (byte[])sha256.buffer.clone();
    }
}

