/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Shape;
import java.awt.Stroke;
import java.util.Arrays;

public class BasicStroke
implements Stroke {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private final float width;
    private final int cap;
    private final int join;
    private final float limit;
    private final float[] dash;
    private final float phase;

    public Shape createStrokedShape(Shape shape) {
        throw new Error("not implemented");
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.limit;
    }

    public float[] getDashArray() {
        return this.dash;
    }

    public float getDashPhase() {
        return this.phase;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.width);
        n ^= this.cap;
        n ^= this.join;
        n ^= Float.floatToIntBits(this.limit);
        if (this.dash != null) {
            int n2 = 0;
            while (n2 < this.dash.length) {
                n ^= Float.floatToIntBits(this.dash[n2]);
                ++n2;
            }
        }
        return n ^= Float.floatToIntBits(this.phase);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicStroke)) {
            return false;
        }
        BasicStroke basicStroke = (BasicStroke)object;
        boolean bl = false;
        if (this.width == basicStroke.width && this.cap == basicStroke.cap && this.join == basicStroke.join && this.limit == basicStroke.limit && Arrays.equals(this.dash, basicStroke.dash) && this.phase == basicStroke.phase) {
            bl = true;
        }
        return bl;
    }

    public BasicStroke(float f, int n, int n2, float f2, float[] fArray, float f3) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("width " + f + " < 0");
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("cap " + n + " out of range [0..2]");
        }
        if (f2 < 1.0f && n2 == 0) {
            throw new IllegalArgumentException("miterlimit " + f2 + " < 1.0f while join == JOIN_MITER");
        }
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("join " + n2 + " out of range [0..2]");
        }
        if (f3 < 0.0f && fArray != null) {
            throw new IllegalArgumentException("dashPhase " + f3 + " < 0.0f while dash != null");
        }
        if (fArray != null) {
            if (fArray.length == 0) {
                throw new IllegalArgumentException("dash.length is 0");
            }
            boolean bl = true;
            int n3 = 0;
            while (n3 < fArray.length) {
                if (fArray[n3] != 0.0f) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                throw new IllegalArgumentException("all dashes are 0.0f");
            }
        }
        this.width = f;
        this.cap = n;
        this.join = n2;
        this.limit = f2;
        this.dash = fArray == null ? null : (float[])fArray.clone();
        this.phase = f3;
    }

    public BasicStroke(float f, int n, int n2, float f2) {
        this(f, n, n2, f2, null, 0.0f);
    }

    public BasicStroke(float f, int n, int n2) {
        this(f, n, n2, 10.0f, null, 0.0f);
    }

    public BasicStroke(float f) {
        this(f, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }
}

