/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class ParseCmdLine{

  public ParseCmdLine(){} //parseCommandLine(cmdLineSwitches); //String[] cmdLineSwitches
    
    public static boolean parseCommandLine(String[] args){
      // we parse the parameters
      // maybe a good idea to restrict the length and characters of the parameter string
        Main.noSplash = false; // setNoSplash(false); // noSplash ist private
        boolean parseSuccess = false;
        Main.language = null;
        if(args.length == 0) return true;
        String[] dummy = new String[0];
        try { // we exit on exception
            for(int i = 0; i < args.length; i++) { // loop for switches (+: e.g. PathToSettings, ReadOnly,)
              String argu = args[i].toLowerCase();
              parseSuccess = false;
              
              // DEBUG
              if(argu.equals("-d1") ||argu.equals("-debug1")){ // doesn't do much: DEBUG is only seldom used atm
                Main.DEBUG1 = !Main.DEBUG1;
if(Main.DEBUG1)d.b.g("Toggled DEBUG1 (common) to " + Main.DEBUG1);
                parseSuccess = true;
                continue;
              }
              
              // DEBUG2 toggle hardcoded value (when switch -validate) / temporary toggle value from ini file
              if(argu.equals("-d2") || argu.equals("-debug2")){  // -validate needs to be the last switch!
                Main.DEBUG2 = !Main.DEBUG2; // if we validate from command line, this is enough
                                  // if not toggled here, we assign in GS the value from the ini file
                Main.dbg2ToggledFromCLI = true; // 
if(Main.DEBUG1)d.b.g("Toggled DEBUG2 (sfg, parser) to " + Main.DEBUG2);
                parseSuccess = true;
                continue;
              }
              
              // DEBUG4 temporary toggles value from ini file (but: we don't pass controller/probdata, when switch -validate)
              if(argu.equals("-d4") || argu.equals("-debug4")){
                Main.DEBUG4 = !Main.DEBUG4;  // if not toggled here, we assign in GS the value from the ini file
                Main.dbg4ToggledFromCLI = true;
if(Main.DEBUG1)d.b.g("Toggled DEBUG4 (sfg, controller + data) to " + Main.DEBUG4); //
                parseSuccess = true;
                continue;
              }
              
              // DEFAULTLANGUAGE (here or in messages is a worm hidden) // could shorten to -lang or -l
              if(argu.startsWith("defaultlanguage") || 
               /*OR*/ argu.startsWith("-defaultlanguage") || 
               /*OR*/ argu.startsWith("-language") || 
               /*OR*/ argu.startsWith("-l=") ||
               /*OR*/ argu.equals("-l") ) { // simpler for the user
                parseSuccess = Messages.parseLanguage(args[i]);
 //d.b.g("\n language: " + language);
                if (parseSuccess) continue; // parsed succesfully the language switch;
                else break; // no parse success, so we end parsing here
              }
              
              // HELP
              if(argu.equals("-?") || 
          /*OR*/ argu.equals("-h") ||
          /*OR*/ argu.equals("-help")){ // 
                parseSuccess = false; // not really a mistake - just to show the help
                break;                // we don't expect more switches
              }
              
              // NOSPLASH
              if(argu.equals("nosplash") || 
          /*OR*/ argu.equals("-nosplash")){ // simpler for the user
                Main.noSplash = true;
                parseSuccess = true;
                continue;
              }
              
              // PORTABLE
              if (argu.equals("-p") || 
                /*OR*/ argu.equals("-portable")){
                Main.pathToSettings = Main.thisProgsFolder;
                Main.PORTABLE = true;
                parseSuccess = true;
                continue;
              }
              
              // STRINGS (translation helper)
              if (argu.equals("strings") || 
                /*OR*/ argu.equals("-strings")){
                try{
                  new GoGrinder.tests.StringChecker();
                  System.exit(0);
                }
                catch(Exception e){
                  System.out.println("Error while processing the resource files.\n"
                                   + "See " + Main.commonLogFilePath);
                  e.printStackTrace();
                  new ExceptionHandler().logSilent(e);
                  System.exit(0);
                }
              }
              
              // SYSINFO
              if(argu.equals("sysinfo") || argu.equals("-sysinfo")){
                new SysInfo(0); // + EXIT // 0 = for console
              }
              
              if(argu.equals("test") || argu.equals("-test")){
                Main.TEST = !Main.TEST;
 d.b.g("Toggled TEST to " + Main.TEST);
                parseSuccess = true;
                continue;
              }
              
              // VALIDATE (parse sgf for errors) ExceptionInInitializerError // could shorten to -val
              if (argu.equals("validate") || 
                /*OR*/ argu.equals("-validate")){ // test, how this is tokenized, when 
                                                                   // e.g. -validate="c:\My Files\Problems\" is handed over
                // would be nice to use one of the free sgf parsers here
                GoGrinder.sgf.Validator.setValidateFromCLI(true);
                GoGrinder.ui.ProbFrame.onValidate();
                //new Validator().main(folderName[0]); // how about handing over a folder to the parser
                try { Thread.sleep(500); } catch(Exception e){};
                System.exit(0);
              }
              
              System.out.println("Error in the command line: " + args[i]);
              return false; // we jump out of the loop here and show the help
            } // end loop through arguments
          
        }
        catch(Exception e) {
            String msg = "What was that? An exception while parsing the command line!" + Main.NL
                         + e.getMessage() + Main.NL + "See grind-log.txt .";
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            new ExceptionHandler().logSilent(e, msg);
            System.exit(-1);
        }
        return parseSuccess;
    }


}