/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class Unpack
extends Task {
    protected File source;
    protected File dest;

    public void setSrc(String src) {
        this.log("DEPRECATED - The setSrc(String) method has been deprecated. Use setSrc(File) instead.");
        this.setSrc(this.project.resolveFile(src));
    }

    public void setDest(String dest) {
        this.log("DEPRECATED - The setDest(String) method has been deprecated. Use setDest(File) instead.");
        this.setDest(this.project.resolveFile(dest));
    }

    public void setSrc(File src) {
        this.source = src;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    private void validate() throws BuildException {
        if (this.source == null) {
            throw new BuildException("No Src specified", this.location);
        }
        if (!this.source.exists()) {
            throw new BuildException("Src doesn't exist", this.location);
        }
        if (this.source.isDirectory()) {
            throw new BuildException("Cannot expand a directory", this.location);
        }
        if (this.dest == null) {
            this.dest = new File(this.source.getParent());
        }
        if (this.dest.isDirectory()) {
            String defaultExtension = this.getDefaultExtension();
            this.createDestFile(defaultExtension);
        }
    }

    private void createDestFile(String defaultExtension) {
        String sourceName = this.source.getName();
        int len = sourceName.length();
        this.dest = defaultExtension != null && len > defaultExtension.length() && defaultExtension.equalsIgnoreCase(sourceName.substring(len - defaultExtension.length())) ? new File(this.dest, sourceName.substring(0, len - defaultExtension.length())) : new File(this.dest, sourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File savedDest = this.dest;
        try {
            this.validate();
            this.extract();
        }
        finally {
            this.dest = savedDest;
        }
    }

    protected abstract String getDefaultExtension();

    protected abstract void extract();
}

