/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.util.OS;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public final class SkinProgressBarUI
extends BasicProgressBarUI {
    private Skin skin = SkinLookAndFeel.getSkin();
    private Rectangle boxRect;

    public void paint(Graphics g, JComponent c) {
        if (OS.isOneDotFourOrMore() && this.progressBar.isIndeterminate()) {
            this.skin.getProgress().paintIndeterminateProgress(g, this.progressBar, this.getBox(this.boxRect));
        } else {
            this.skin.getProgress().paintProgress(g, this.progressBar);
        }
        int barRectX = 0;
        int barRectY = 0;
        int barRectWidth = this.progressBar.getWidth();
        int barRectHeight = this.progressBar.getHeight();
        Insets b = this.progressBar.getInsets();
        int amountFull = this.getAmountFull(b, barRectWidth -= b.right + (barRectX += b.left), barRectHeight -= b.bottom + (barRectY += b.top));
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, barRectX, barRectY, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.progressBar.setBorder(null);
        this.progressBar.setOpaque(true);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setMinimumSize(this.skin.getProgress().getMinimumSize(this.progressBar));
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (OS.isOneDotFour() && this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setIndeterminate(true);
        }
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.progressBar.setOpaque(true);
        this.progressBar.setBorderPainted(true);
    }

    public static ComponentUI createUI(JComponent x) {
        return new SkinProgressBarUI();
    }
}

