/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gmptogtp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import net.sf.gogui.gmptogtp.GmpToGtp;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.ProcessUtils;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 0;
        Process process = null;
        CommPort commPort = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            Object object;
            String[] stringArray2 = new String[]{"baud:", "color:", "config:", "device:", "flow:", "help", "list", "simple", "size:", "verbose", "wait", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                String string = "Usage: java -jar gmptogtp.jar [options]\n\n-baud    speed of serial device (default 2400)\n-color   color (black|white)\n-config  config file\n-device  serial device file\n-flow    flow control (none|rtscts(default)|xonxoff)\n-help    display this help and exit\n-list    list serial devices and exit\n-simple  use simple version of the protocol\n-size    board size\n-verbose print logging messages\n-version print version and exit\n-wait    wait for first newgame command\n";
                System.out.print(string);
                return;
            }
            if (options.isSet("version")) {
                System.out.println("GmpToGtp " + Version.get());
                return;
            }
            if (options.isSet("list")) {
                Main.listDevices();
                return;
            }
            String string = options.getString("color", "");
            if (!(string.equals("") || string.equalsIgnoreCase("black") || string.equalsIgnoreCase("white"))) {
                throw new Exception("invalid color");
            }
            String string2 = options.getString("device", "");
            int n2 = options.getInteger("size", 19);
            if (n2 < 1 || n2 > 22) {
                throw new Exception("invalid size");
            }
            int n3 = options.getInteger("baud", 2400);
            if (n3 <= 0) {
                throw new Exception("invalid baud value");
            }
            boolean bl = options.isSet("verbose");
            boolean bl2 = options.isSet("simple");
            boolean bl3 = options.isSet("wait");
            String string3 = null;
            ArrayList arrayList = options.getArguments();
            if (arrayList.size() == 1) {
                string3 = (String)arrayList.get(0);
            } else if (arrayList.size() > 1) {
                System.err.println("Only one program argument allowed");
                System.exit(-1);
            } else if (string2.equals("")) {
                System.err.println("Missing program argument");
                System.exit(-1);
            }
            String string4 = "Go Modem ";
            String string5 = options.getString("flow", "rtscts");
            if (string2.equals("")) {
                Runtime runtime = Runtime.getRuntime();
                process = runtime.exec(StringUtils.splitArguments(string3));
                object = new ProcessUtils.StdErrThread(process);
                ((Thread)object).start();
                string4 = string4 + string3;
                inputStream = process.getInputStream();
                outputStream = process.getOutputStream();
            } else {
                commPort = Main.openPort(string2, n3, string5);
                string4 = string4 + string2;
                inputStream = commPort.getInputStream();
                outputStream = commPort.getOutputStream();
            }
            int n4 = 0;
            if (!string.equals("")) {
                if (string.equalsIgnoreCase("black")) {
                    n4 = 1;
                } else if (string.equalsIgnoreCase("white")) {
                    n4 = 2;
                }
            }
            object = new GmpToGtp(string4, inputStream, outputStream, bl, n2, n4, bl3, bl2);
            ((GtpEngine)object).mainLoop(System.in, System.out);
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            n = -1;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                StringUtils.printException(iOException);
            }
            if (process != null) {
                process.destroy();
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted");
                }
            }
            if (commPort != null) {
                commPort.close();
            }
        }
        System.exit(n);
    }

    private Main() {
    }

    private static void listDevices() {
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            System.out.println(commPortIdentifier.getName());
        }
    }

    private static SerialPort openPort(String string, int n, String string2) throws Error, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier(string);
        SerialPort serialPort = (SerialPort)commPortIdentifier.open("GmpToGtp", 5000);
        serialPort.setSerialPortParams(n, 8, 1, 0);
        if (string2.equals("rtscts")) {
            serialPort.setFlowControlMode(3);
        } else if (string2.equals("xonxoff")) {
            serialPort.setFlowControlMode(12);
        } else if (string2.equals("none")) {
            serialPort.setFlowControlMode(0);
        } else {
            throw new Error("Unknown flow control mode \"" + string2 + "\"");
        }
        return serialPort;
    }
}

