/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.requestfactory.shared.ProxyStore;
import com.google.web.bindery.requestfactory.shared.impl.MessageFactoryHolder;
import com.google.web.bindery.requestfactory.shared.messages.OperationMessage;
import java.util.HashMap;
import java.util.Map;

public class DefaultProxyStore
implements ProxyStore {
    private static final String EXPECTED_VERSION = "211";
    private final AutoBean<OperationMessage> messageBean;
    private final Map<String, Splittable> map;
    private int nextId;

    public DefaultProxyStore() {
        this.messageBean = MessageFactoryHolder.FACTORY.operation();
        this.map = new HashMap<String, Splittable>();
        OperationMessage message = this.messageBean.as();
        message.setPropertyMap(this.map);
        message.setVersion(EXPECTED_VERSION);
    }

    public DefaultProxyStore(String payload) throws IllegalArgumentException {
        this.messageBean = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, OperationMessage.class, payload);
        OperationMessage message = this.messageBean.as();
        if (!EXPECTED_VERSION.equals(message.getVersion())) {
            throw new IllegalArgumentException("Unexpected version string in payload " + message.getVersion());
        }
        this.map = message.getPropertyMap();
        this.nextId = message.getSyntheticId() - 1;
        if (this.nextId < 0) {
            this.nextId = this.map.size();
        }
    }

    public String encode() {
        assert (this.nextId >= 0);
        this.messageBean.as().setSyntheticId(this.nextId + 1);
        return AutoBeanCodex.encode(this.messageBean).getPayload();
    }

    @Override
    public Splittable get(String key) {
        return this.map.get(key);
    }

    @Override
    public int nextId() {
        return this.nextId++;
    }

    @Override
    public void put(String key, Splittable value) {
        this.map.put(key, value);
    }
}

