/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safecss.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.HashMap;
import java.util.Stack;

public class SafeStylesHostedModeUtils {
    public static final String FORCE_CHECK_VALID_STYLES = "com.google.gwt.safecss.ForceCheckValidStyles";
    private static boolean forceCheck;

    @VisibleForTesting
    public static String isValidStyleName(String name) {
        if (name == null || name.isEmpty()) {
            return "Style property names cannot be null or empty";
        }
        char firstReal = name.charAt(0);
        if (firstReal == '-' && name.length() > 0) {
            firstReal = name.charAt(1);
        }
        if (firstReal >= '0' && firstReal <= '9') {
            return "Style property names cannot start with a digit or a hyphen followed by a digit: " + name;
        }
        if (name.startsWith("--")) {
            return "Style property names cannot start with a double hyphen: " + name;
        }
        if (name.indexOf(59) >= 0) {
            return "Style property names cannot contain a semi-colon: " + name;
        }
        if (name.indexOf(58) >= 0) {
            return "Style property names cannot contain a colon: " + name;
        }
        return null;
    }

    @VisibleForTesting
    public static String isValidStyleValue(String value) {
        if (value == null || value.length() == 0) {
            return "Style property values cannot be null or empty";
        }
        HashMap<Character, Character> pairs = new HashMap<Character, Character>();
        pairs.put(Character.valueOf('('), Character.valueOf(')'));
        pairs.put(Character.valueOf('['), Character.valueOf(']'));
        pairs.put(Character.valueOf('{'), Character.valueOf('}'));
        Stack<Character> pairsStack = new Stack<Character>();
        Stack<Integer> pairsPos = new Stack<Integer>();
        Character inQuote = null;
        int inQuotePos = -1;
        boolean inUrl = false;
        boolean ignoreNext = false;
        for (int i = 0; i < value.length(); ++i) {
            if (ignoreNext) {
                ignoreNext = false;
                continue;
            }
            char ch = value.charAt(i);
            if (ch == '\\') {
                ignoreNext = true;
                continue;
            }
            if (inUrl) {
                if (ch == ')') {
                    inUrl = false;
                    continue;
                }
                if (ch != '(') continue;
                return "Unescaped parentheses within a url at index " + i + ": " + value;
            }
            if (inQuote != null) {
                if (ch != inQuote.charValue()) continue;
                inQuote = null;
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                inQuote = Character.valueOf(ch);
                inQuotePos = i;
                continue;
            }
            if ((ch == 'u' || ch == 'U') && value.length() >= i + 4 && value.substring(i, i + 4).equalsIgnoreCase("url(")) {
                inUrl = true;
                i += 3;
                continue;
            }
            if (pairs.containsKey(Character.valueOf(ch))) {
                pairsStack.push(Character.valueOf(ch));
                pairsPos.push(i);
                continue;
            }
            if (pairs.values().contains(Character.valueOf(ch))) {
                if (pairsStack.isEmpty() || ((Character)pairs.get(pairsStack.pop())).charValue() != ch) {
                    return "Style property value contains unpaired '" + ch + "' at index " + i + ": " + value;
                }
                pairsPos.pop();
                continue;
            }
            if (ch == ';') {
                return "Style property values cannot contain a semi-colon (except within quotes): " + value;
            }
            if (ch != ':') continue;
            return "Style property values cannot contain a colon (except within quotes): " + value;
        }
        if (inQuote != null) {
            return "Style property value contains unpaired open quote at index " + inQuotePos + ": " + value;
        }
        if (inUrl) {
            return "Style property value contains an unterminated url: " + value;
        }
        if (!pairsStack.isEmpty()) {
            char openToken = ((Character)pairsStack.pop()).charValue();
            int index = (Integer)pairsPos.pop();
            return "Style property value contains unpaired '" + openToken + "' at index " + index + ": " + value;
        }
        if (ignoreNext) {
            return "Style property values cannot end in an escape character: " + value;
        }
        return null;
    }

    public static void maybeCheckValidStyleName(String name) {
        if (GWT.isClient() || forceCheck) {
            String errorText = SafeStylesHostedModeUtils.isValidStyleName(name);
            Preconditions.checkArgument(errorText == null, errorText);
        } else assert (SafeStylesHostedModeUtils.isValidStyleName(name) == null) : SafeStylesHostedModeUtils.isValidStyleName(name);
    }

    public static void maybeCheckValidStyleValue(String value) {
        if (GWT.isClient() || forceCheck) {
            String errorText = SafeStylesHostedModeUtils.isValidStyleValue(value);
            Preconditions.checkArgument(errorText == null, errorText);
        } else assert (SafeStylesHostedModeUtils.isValidStyleValue(value) == null) : SafeStylesHostedModeUtils.isValidStyleValue(value);
    }

    public static void setForceCheckValidStyle(boolean check) {
        forceCheck = check;
    }

    static void setForceCheckValidStyleFromProperty() {
        forceCheck = System.getProperty(FORCE_CHECK_VALID_STYLES) != null;
    }

    static {
        SafeStylesHostedModeUtils.setForceCheckValidStyleFromProperty();
    }
}

