/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=pa

/**
 * Localized names for the "pa" locale.
 */
public class LocalizedNamesImpl_pa extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AZ",
        "AF",
        "AS",
        "AR",
        "AW",
        "DZ",
        "AL",
        "SV",
        "AX",
        "AC",
        "AI",
        "AO",
        "AQ",
        "AD",
        "IE",
        "IM",
        "IS",
        "QO",
        "AM",
        "AT",
        "AU",
        "EC",
        "IL",
        "IT",
        "ET",
        "IQ",
        "ER",
        "EE",
        "ID",
        "IR",
        "UZ",
        "UY",
        "KP",
        "MP",
        "AG",
        "OM",
        "KZ",
        "QA",
        "HR",
        "CP",
        "CD",
        "CG",
        "CU",
        "KG",
        "KE",
        "KI",
        "CK",
        "CW",
        "KW",
        "CF",
        "IC",
        "CV",
        "KY",
        "CA",
        "CM",
        "BQ",
        "CC",
        "CI",
        "KM",
        "CO",
        "CR",
        "XK",
        "CX",
        "KH",
        "GG",
        "GM",
        "GA",
        "GN",
        "GW",
        "GT",
        "GP",
        "GU",
        "GY",
        "GL",
        "GR",
        "GD",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JM",
        "DE",
        "JE",
        "ZM",
        "ZW",
        "DJ",
        "JP",
        "GE",
        "GI",
        "JO",
        "TN",
        "TL",
        "TV",
        "TK",
        "TG",
        "TO",
        "TT",
        "DG",
        "DK",
        "DM",
        "DO",
        "TZ",
        "TW",
        "TJ",
        "TM",
        "TC",
        "TR",
        "TA",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "NE",
        "NG",
        "NR",
        "NA",
        "NO",
        "NC",
        "NZ",
        "NI",
        "NU",
        "NL",
        "NP",
        "NF",
        "PA",
        "PW",
        "PS",
        "PK",
        "PG",
        "PR",
        "PN",
        "PT",
        "PE",
        "PY",
        "PL",
        "EH",
        "FK",
        "FJ",
        "FI",
        "PH",
        "FO",
        "FR",
        "GF",
        "PF",
        "TF",
        "BM",
        "BN",
        "BS",
        "BH",
        "BB",
        "BF",
        "BI",
        "BG",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BW",
        "BO",
        "BA",
        "BV",
        "BR",
        "VG",
        "IO",
        "BD",
        "IN",
        "GQ",
        "BT",
        "MO",
        "MY",
        "FM",
        "YT",
        "MQ",
        "MH",
        "MT",
        "MV",
        "MW",
        "ML",
        "MM",
        "EG",
        "MK",
        "MX",
        "MG",
        "MS",
        "MZ",
        "ME",
        "MC",
        "MR",
        "MA",
        "MD",
        "MU",
        "MN",
        "YE",
        "GB",
        "UM",
        "VI",
        "UA",
        "UG",
        "US",
        "EU",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LS",
        "LB",
        "VU",
        "WF",
        "VN",
        "VE",
        "VA",
        "ES",
        "RS",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "CY",
        "ST",
        "SA",
        "WS",
        "SL",
        "EA",
        "SG",
        "SX",
        "SY",
        "SD",
        "SR",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "SN",
        "SC",
        "KN",
        "PM",
        "SM",
        "SO",
        "SB",
        "LK",
        "AE",
        "HM",
        "HK",
        "HT",
        "HN",
        "HU",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ਵਿਸ਼ਵ");
    namesMap.put("002", "ਅਫ਼ਰੀਕਾ");
    namesMap.put("003", "ਉੱਤਰ ਅਮਰੀਕਾ");
    namesMap.put("005", "ਦੱਖਣ ਅਮਰੀਕਾ");
    namesMap.put("009", "ਓਸ਼ਨਿਆ");
    namesMap.put("011", "ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("013", "ਕੇਂਦਰੀ ਅਮਰੀਕਾ");
    namesMap.put("014", "ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("015", "ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("017", "ਮੱਧਮ ਅਫ਼ਰੀਕਾ");
    namesMap.put("018", "ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("019", "ਅਮਰੀਕਾ");
    namesMap.put("021", "ਉੱਤਰੀ ਅਮਰੀਕਾ");
    namesMap.put("029", "ਕੈਰੇਬੀਅਨ");
    namesMap.put("030", "ਪੂਰਬੀ ਏਸ਼ੀਆ");
    namesMap.put("034", "ਦੱਖਣੀ ਏਸ਼ੀਆ");
    namesMap.put("035", "ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ");
    namesMap.put("039", "ਦੱਖਣੀ ਯੂਰਪ");
    namesMap.put("053", "ਔਸਟ੍ਰਾਲੇਸ਼ੀਆ");
    namesMap.put("054", "ਮੈਲਾਨੇਸ਼ੀਆ");
    namesMap.put("057", "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਖੇਤਰ");
    namesMap.put("061", "ਪੋਲਿਨੇਸ਼ੀਆ");
    namesMap.put("142", "ਏਸ਼ੀਆ");
    namesMap.put("143", "ਕੇਂਦਰੀ ਏਸ਼ੀਆ");
    namesMap.put("145", "ਪੱਛਮੀ ਏਸ਼ੀਆ");
    namesMap.put("150", "ਯੂਰਪ");
    namesMap.put("151", "ਪੂਰਬੀ ਯੂਰਪ");
    namesMap.put("154", "ਉੱਤਰੀ ਯੂਰਪ");
    namesMap.put("155", "ਪੱਛਮੀ ਯੂਰਪ");
    namesMap.put("419", "ਲੈਟਿਨ ਅਮਰੀਕਾ");
    namesMap.put("AC", "ਅਸੈਂਸ਼ਨ ਆਈਲੈਂਡ");
    namesMap.put("AD", "ਅੰਡੋਰਾ");
    namesMap.put("AE", "ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ");
    namesMap.put("AF", "ਅਫ਼ਗਾਨਿਸਤਾਨ");
    namesMap.put("AG", "ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ");
    namesMap.put("AI", "ਅੰਗੁਇਲਾ");
    namesMap.put("AL", "ਅਲਬਾਨੀਆ");
    namesMap.put("AM", "ਆਰਮੀਨਿਆ");
    namesMap.put("AO", "ਅੰਗੋਲਾ");
    namesMap.put("AQ", "ਅੰਟਾਰਕਟਿਕਾ");
    namesMap.put("AR", "ਅਰਜਨਟੀਨਾ");
    namesMap.put("AS", "ਅਮੈਰੀਕਨ ਸਮੋਆ");
    namesMap.put("AT", "ਆਸਟਰੀਆ");
    namesMap.put("AU", "ਆਸਟ੍ਰੇਲੀਆ");
    namesMap.put("AW", "ਅਰੂਬਾ");
    namesMap.put("AX", "ਅਲੈਂਡ ਆਈਲੈਂਡਸ");
    namesMap.put("AZ", "ਅਜ਼ਰਬੈਜਾਨ");
    namesMap.put("BA", "ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ");
    namesMap.put("BB", "ਬਾਰਬਾਡੋਸ");
    namesMap.put("BD", "ਬੰਗਲਾਦੇਸ਼");
    namesMap.put("BE", "ਬੈਲਜੀਅਮ");
    namesMap.put("BF", "ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ");
    namesMap.put("BG", "ਬੁਲਗਾਰਿਆ");
    namesMap.put("BH", "ਬਹਿਰੀਨ");
    namesMap.put("BI", "ਬੁਰੁੰਡੀ");
    namesMap.put("BJ", "ਬੇਨਿਨ");
    namesMap.put("BL", "ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ");
    namesMap.put("BM", "ਬਰਮੂਡਾ");
    namesMap.put("BN", "ਬਰੂਨੇਈ");
    namesMap.put("BO", "ਬੋਲੀਵੀਆ");
    namesMap.put("BQ", "ਕੈਰੇਬੀਅਨ ਨੀਦਰਲੈਂਡ");
    namesMap.put("BR", "ਬ੍ਰਾਜ਼ੀਲ");
    namesMap.put("BS", "ਬਹਾਮਾਸ");
    namesMap.put("BT", "ਭੂਟਾਨ");
    namesMap.put("BV", "ਬੌਵੇਟ ਆਈਲੈਂਡ");
    namesMap.put("BW", "ਬੋਟਸਵਾਨਾ");
    namesMap.put("BY", "ਬੇਲਾਰੂਸ");
    namesMap.put("BZ", "ਬੇਲੀਜ਼");
    namesMap.put("CA", "ਕੈਨੇਡਾ");
    namesMap.put("CC", "ਕੋਕੋਜ਼ (ਕੀਲਿੰਗ) ਆਈਲੈਂਡਸ");
    namesMap.put("CD", "ਕਾਂਗੋ - ਕਿਂਸ਼ਾਸਾ");
    namesMap.put("CF", "ਕੇਂਦਰੀ ਅਫਰੀਕੀ ਗਣਰਾਜ");
    namesMap.put("CG", "ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ");
    namesMap.put("CH", "ਸਵਿਟਜ਼ਰਲੈਂਡ");
    namesMap.put("CI", "ਕੋਟ ਡੀਵੋਆਰ");
    namesMap.put("CK", "ਕੁਕ ਆਈਲੈਂਡਸ");
    namesMap.put("CL", "ਚਿਲੀ");
    namesMap.put("CM", "ਕੈਮਰੂਨ");
    namesMap.put("CN", "ਚੀਨ");
    namesMap.put("CO", "ਕੋਲੰਬੀਆ");
    namesMap.put("CP", "ਕਲਿਪਰਟਨ ਆਈਲੈਂਡ");
    namesMap.put("CR", "ਕੋਸਟਾ ਰੀਕਾ");
    namesMap.put("CU", "ਕਿਊਬਾ");
    namesMap.put("CV", "ਕੇਪ ਵਰਡ");
    namesMap.put("CW", "ਕੁਰਾਕਾਓ");
    namesMap.put("CX", "ਕ੍ਰਿਸਮਸ ਆਈਲੈਂਡ");
    namesMap.put("CY", "ਸਾਇਪਰਸ");
    namesMap.put("CZ", "ਚੈਕ ਗਣਰਾਜ");
    namesMap.put("DE", "ਜਰਮਨੀ");
    namesMap.put("DG", "ਡੀਗੋ ਗਾਰਸ਼ੀਆ");
    namesMap.put("DJ", "ਜ਼ੀਬੂਤੀ");
    namesMap.put("DK", "ਡੈਨਮਾਰਕ");
    namesMap.put("DM", "ਡੋਮੀਨਿਕਾ");
    namesMap.put("DO", "ਡੌਮਿਨਿਕਨ ਗਣਰਾਜ");
    namesMap.put("DZ", "ਅਲਜੀਰੀਆ");
    namesMap.put("EA", "ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ");
    namesMap.put("EC", "ਇਕਵੇਡੋਰ");
    namesMap.put("EE", "ਇਸਟੋਨੀਆ");
    namesMap.put("EG", "ਮਿਸਰ");
    namesMap.put("EH", "ਪੱਛਮੀ ਸਹਾਰਾ");
    namesMap.put("ER", "ਇਰੀਟ੍ਰਿਆ");
    namesMap.put("ES", "ਸਪੇਨ");
    namesMap.put("ET", "ਇਥੋਪੀਆ");
    namesMap.put("EU", "ਯੂਰੋਪੀਅਨ ਯੂਨਿਅਨ");
    namesMap.put("FI", "ਫਿਨਲੈਂਡ");
    namesMap.put("FJ", "ਫ਼ਿਜੀ");
    namesMap.put("FK", "ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ");
    namesMap.put("FM", "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ");
    namesMap.put("FO", "ਫੈਰੋ ਆਇਲੈਂਡਸ");
    namesMap.put("FR", "ਫ੍ਰਾਂਸ");
    namesMap.put("GA", "ਗਾਬੋਨ");
    namesMap.put("GB", "ਯੁਨਾਇਟੇਡ ਕਿੰਗਡਮ");
    namesMap.put("GD", "ਗ੍ਰੇਨਾਡਾ");
    namesMap.put("GE", "ਜਾਰਜਿਆ");
    namesMap.put("GF", "ਫ੍ਰੈਂਚ ਗੁਏਨਾ");
    namesMap.put("GG", "ਗਰਨਸੀ");
    namesMap.put("GH", "ਘਾਨਾ");
    namesMap.put("GI", "ਜਿਬਰਾਲਟਰ");
    namesMap.put("GL", "ਗ੍ਰੀਨਲੈਂਡ");
    namesMap.put("GM", "ਗਾਂਬੀਆ");
    namesMap.put("GN", "ਗਿਨੀ");
    namesMap.put("GP", "ਗੁਆਡੇਲੋਪ");
    namesMap.put("GQ", "ਭੂ-ਖੰਡੀ ਗਿਨੀ");
    namesMap.put("GR", "ਗ੍ਰੀਸ");
    namesMap.put("GS", "ਦੱਖਣੀ ਜਾਰਜਿਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਆਇਲੈਂਡਸ");
    namesMap.put("GT", "ਗੁਆਟੇਮਾਲਾ");
    namesMap.put("GU", "ਗੁਆਮ");
    namesMap.put("GW", "ਗਿਨੀ-ਬਿਸਾਉ");
    namesMap.put("GY", "ਗੁਯਾਨਾ");
    namesMap.put("HK", "ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ");
    namesMap.put("HM", "ਹਰਡ ਆਈਲੈਂਡ ਅਤੇ ਮੈਕਡੋਨਾਲਡ ਆਈਲੈਂਡਸ");
    namesMap.put("HN", "ਹਾਨਡੂਰਸ");
    namesMap.put("HR", "ਕਰੋਏਸ਼ੀਆ");
    namesMap.put("HT", "ਹਾਈਟੀ");
    namesMap.put("HU", "ਹੰਗਰੀ");
    namesMap.put("IC", "ਕੇਨੇਰੀ ਆਈਲੈਂਡਜ਼");
    namesMap.put("ID", "ਇੰਡੋਨੇਸ਼ੀਆ");
    namesMap.put("IE", "ਆਇਰਲੈਂਡ");
    namesMap.put("IL", "ਇਜ਼ਰਾਈਲ");
    namesMap.put("IM", "ਆਇਲ ਆਫ ਮੈਨ");
    namesMap.put("IN", "ਭਾਰਤ");
    namesMap.put("IO", "ਬ੍ਰਿਟਿਸ਼ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਟੈਰਿਟਰੀ");
    namesMap.put("IQ", "ਇਰਾਕ");
    namesMap.put("IR", "ਈਰਾਨ");
    namesMap.put("IS", "ਆਈਸਲੈਂਡ");
    namesMap.put("IT", "ਇਟਲੀ");
    namesMap.put("JE", "ਜਰਸੀ");
    namesMap.put("JM", "ਜਮਾਇਕਾ");
    namesMap.put("JO", "ਜੌਰਡਨ");
    namesMap.put("JP", "ਜਾਪਾਨ");
    namesMap.put("KE", "ਕੀਨੀਆ");
    namesMap.put("KG", "ਕਿਰਗਿਜ਼ਸਤਾਨ");
    namesMap.put("KH", "ਕੰਬੋਡੀਆ");
    namesMap.put("KI", "ਕੀਰੀਬਾਟੀ");
    namesMap.put("KM", "ਕੋਮੋਰੋਸ");
    namesMap.put("KN", "ਸੈਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ");
    namesMap.put("KP", "ਉੱਤਰੀ ਕੋਰੀਆ");
    namesMap.put("KR", "ਦੱਖਣੀ ਕੋਰੀਆ");
    namesMap.put("KW", "ਕੁਵੈਤ");
    namesMap.put("KY", "ਕੇਮੈਨ ਆਈਲੈਂਡਸ");
    namesMap.put("KZ", "ਕਜ਼ਾਕਸਤਾਨ");
    namesMap.put("LA", "ਲਾਓਸ");
    namesMap.put("LB", "ਲੈਬਨਾਨ");
    namesMap.put("LC", "ਸੇਂਟ ਲੂਸੀਆ");
    namesMap.put("LI", "ਲਿਕਟਨਸਟਾਇਨ");
    namesMap.put("LK", "ਸ੍ਰੀ ਲੰਕਾ");
    namesMap.put("LR", "ਲਾਈਬੀਰੀਆ");
    namesMap.put("LS", "ਲੇਸੋਥੋ");
    namesMap.put("LT", "ਲਿਥੁਆਨੀਆ");
    namesMap.put("LU", "ਲਕਜ਼ਮਬਰਗ");
    namesMap.put("LV", "ਲਾਟਵਿਆ");
    namesMap.put("LY", "ਲੀਬੀਆ");
    namesMap.put("MA", "ਮੋਰੱਕੋ");
    namesMap.put("MC", "ਮੋਨਾਕੋ");
    namesMap.put("MD", "ਮੋਲਡੋਵਾ");
    namesMap.put("ME", "ਮੋਨਟੇਨੇਗਰੋ");
    namesMap.put("MF", "ਸੇਂਟ ਮਾਰਟਿਨ");
    namesMap.put("MG", "ਮੈਡਾਗਾਸਕਰ");
    namesMap.put("MH", "ਮਾਰਸ਼ਲ ਆਈਲੈਂਡਸ");
    namesMap.put("MK", "ਮੈਕਡੋਨੀਆ");
    namesMap.put("ML", "ਮਾਲੀ");
    namesMap.put("MM", "ਮਿਆਂਮਾਰ");
    namesMap.put("MN", "ਮੰਗੋਲੀਆ");
    namesMap.put("MO", "ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ");
    namesMap.put("MP", "ਉੱਤਰੀ ਮਰੀਆਨਾ ਆਈਲੈਂਡ");
    namesMap.put("MQ", "ਮਾਰਟੀਨਿਕ");
    namesMap.put("MR", "ਮੋਰਿਟਾਨੀਆ");
    namesMap.put("MS", "ਮੋਂਟਸੇਰਾਤ");
    namesMap.put("MT", "ਮਾਲਟਾ");
    namesMap.put("MU", "ਮੌਰਿਸ਼ਸ");
    namesMap.put("MV", "ਮਾਲਦੀਵ");
    namesMap.put("MW", "ਮਾਲਾਵੀ");
    namesMap.put("MX", "ਮੈਕਸਿਕੋ");
    namesMap.put("MY", "ਮਲੇਸ਼ੀਆ");
    namesMap.put("MZ", "ਮੋਜ਼ਾਮਬੀਕ");
    namesMap.put("NA", "ਨਾਮੀਬੀਆ");
    namesMap.put("NC", "ਨਿਊ ਕੈਲੇਡੋਨਿਆ");
    namesMap.put("NE", "ਨਾਇਜਰ");
    namesMap.put("NF", "ਨੋਰਫੌਕ ਆਈਲੈਂਡ");
    namesMap.put("NG", "ਨਾਇਜੀਰੀਆ");
    namesMap.put("NI", "ਨਿਕਾਰਾਗੁਆ");
    namesMap.put("NL", "ਨੀਦਰਲੈਂਡਸ");
    namesMap.put("NO", "ਨਾਰਵੇ");
    namesMap.put("NP", "ਨੇਪਾਲ");
    namesMap.put("NR", "ਨਾਉਰੂ");
    namesMap.put("NU", "ਨਿਯੂ");
    namesMap.put("NZ", "ਨਿਊਜ਼ੀਲੈਂਡ");
    namesMap.put("OM", "ਓਮਾਨ");
    namesMap.put("PA", "ਪਨਾਮਾ");
    namesMap.put("PE", "ਪੇਰੂ");
    namesMap.put("PF", "ਫ੍ਰੈਂਚ ਪੋਲਿਨੇਸ਼ੀਆ");
    namesMap.put("PG", "ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ");
    namesMap.put("PH", "ਫਿਲਿਪੀਨੀਜ਼");
    namesMap.put("PK", "ਪਾਕਿਸਤਾਨ");
    namesMap.put("PL", "ਪੋਲੈਂਡ");
    namesMap.put("PM", "ਸੈਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ");
    namesMap.put("PN", "ਪਿਟਕੈਰਨ ਆਈਲੈਂਡਸ");
    namesMap.put("PR", "ਪਿਊਰਟੋ ਰਿਕੋ");
    namesMap.put("PS", "ਪਲੈਸਟਿਨੀ ਪ੍ਰਦੇਸ਼");
    namesMap.put("PT", "ਪੁਰਤਗਾਲ");
    namesMap.put("PW", "ਪਲਾਉ");
    namesMap.put("PY", "ਪੈਰਾਗਵੇ");
    namesMap.put("QA", "ਕਤਰ");
    namesMap.put("QO", "ਆਊਟਲਾਇੰਗ ਓਸ਼ਨੀਆ");
    namesMap.put("RE", "ਰਿਯੂਨਿਅਨ");
    namesMap.put("RO", "ਰੋਮਾਨੀਆ");
    namesMap.put("RS", "ਸਰਬੀਆ");
    namesMap.put("RU", "ਰੂਸ");
    namesMap.put("RW", "ਰਵਾਂਡਾ");
    namesMap.put("SA", "ਸਾਉਦੀ ਅਰਬ");
    namesMap.put("SB", "ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ");
    namesMap.put("SC", "ਸੇਸ਼ਲਸ");
    namesMap.put("SD", "ਸੁਡਾਨ");
    namesMap.put("SE", "ਸਵੀਡਨ");
    namesMap.put("SG", "ਸਿੰਗਾਪੁਰ");
    namesMap.put("SH", "ਸੇਂਟ ਹੇਲੇਨਾ");
    namesMap.put("SI", "ਸਲੋਵੇਨੀਆ");
    namesMap.put("SJ", "ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ");
    namesMap.put("SK", "ਸਲੋਵਾਕੀਆ");
    namesMap.put("SL", "ਸਿਏਰਾ ਲਿਓਨ");
    namesMap.put("SM", "ਸੈਨ ਮਰੀਨੋ");
    namesMap.put("SN", "ਸੇਨੇਗਲ");
    namesMap.put("SO", "ਸੋਮਾਲੀਆ");
    namesMap.put("SR", "ਸੂਰੀਨਾਮ");
    namesMap.put("SS", "ਦੱਖਣੀ ਸੁਡਾਨ");
    namesMap.put("ST", "ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ");
    namesMap.put("SV", "ਅਲ ਸਲਵਾਡੋਰ");
    namesMap.put("SX", "ਸਿੰਟ ਮਾਰਟੀਨ");
    namesMap.put("SY", "ਸੀਰੀਆ");
    namesMap.put("SZ", "ਸਵਾਜ਼ੀਲੈਂਡ");
    namesMap.put("TA", "ਤ੍ਰਿਸਟਾਨ ਡਾ ਕੁਨਾ");
    namesMap.put("TC", "ਤੁਰਕਸ ਐਂਡ ਕੇਕੋਸ ਆਈਲੈਂਡਸ");
    namesMap.put("TD", "ਚਾਡ");
    namesMap.put("TF", "ਫ੍ਰੈਂਚ ਸਾਉਦਰਨ ਟੈਰੀਟਰੀਜ਼");
    namesMap.put("TG", "ਟੋਗੋ");
    namesMap.put("TH", "ਥਾਈਲੈਂਡ");
    namesMap.put("TJ", "ਤਾਜਿਕਿਸਤਾਨ");
    namesMap.put("TK", "ਟੋਕੇਲਾਉ");
    namesMap.put("TL", "ਟੀਮੁਰ-ਲੀਸਟੀ");
    namesMap.put("TM", "ਤੁਰਕਮੇਨਿਸਤਾਨ");
    namesMap.put("TN", "ਟਿਉਨੀਸ਼ੀਆ");
    namesMap.put("TO", "ਟੌਂਗਾ");
    namesMap.put("TR", "ਤੁਰਕੀ");
    namesMap.put("TT", "ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ");
    namesMap.put("TV", "ਟੁਵਾਲੂ");
    namesMap.put("TW", "ਤਾਇਵਾਨ");
    namesMap.put("TZ", "ਤਨਜ਼ਾਨੀਆ");
    namesMap.put("UA", "ਯੂਕਰੇਨ");
    namesMap.put("UG", "ਯੂਗਾਂਡਾ");
    namesMap.put("UM", "ਯੂ.ਐਸ. ਆਊਟਲਾਇੰਗ ਆਈਲੈਂਡਸ");
    namesMap.put("US", "ਯੂਨਾਇਟੇਡ ਸਟੇਟਸ");
    namesMap.put("UY", "ਉਰੂਗਵੇ");
    namesMap.put("UZ", "ਉਜ਼ਬੇਕਿਸਤਾਨ");
    namesMap.put("VA", "ਵੈਟਿਕਨ ਸਿਟੀ");
    namesMap.put("VC", "ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ");
    namesMap.put("VE", "ਵੇਨੇਜ਼ੂਏਲਾ");
    namesMap.put("VG", "ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਆਈਲੈਂਡਸ");
    namesMap.put("VI", "ਯੂ ਐਸ ਵਰਜਿਨ ਆਈਲੈਂਡਸ");
    namesMap.put("VN", "ਵਿਯਤਨਾਮ");
    namesMap.put("VU", "ਵਾਨੂਆਟੂ");
    namesMap.put("WF", "ਵਾਲਿਸ ਐਂਡ ਫਯੁਚੁਨਾ");
    namesMap.put("WS", "ਸਾਮੋਆ");
    namesMap.put("XK", "ਕੋਸੋਵੋ");
    namesMap.put("YE", "ਯਮਨ");
    namesMap.put("YT", "ਮਾਯੋਟੀ");
    namesMap.put("ZA", "ਦੱਖਣੀ ਅਫਰੀਕਾ");
    namesMap.put("ZM", "ਜ਼ਾਮਬੀਆ");
    namesMap.put("ZW", "ਜ਼ਿੰਬਾਬਵੇ");
    namesMap.put("ZZ", "ਅਗਿਆਤ ਖੇਤਰ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ਵਿਸ਼ਵ",
        "002": "ਅਫ਼ਰੀਕਾ",
        "003": "ਉੱਤਰ ਅਮਰੀਕਾ",
        "005": "ਦੱਖਣ ਅਮਰੀਕਾ",
        "009": "ਓਸ਼ਨਿਆ",
        "011": "ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ",
        "013": "ਕੇਂਦਰੀ ਅਮਰੀਕਾ",
        "014": "ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ",
        "015": "ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ",
        "017": "ਮੱਧਮ ਅਫ਼ਰੀਕਾ",
        "018": "ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ",
        "019": "ਅਮਰੀਕਾ",
        "021": "ਉੱਤਰੀ ਅਮਰੀਕਾ",
        "029": "ਕੈਰੇਬੀਅਨ",
        "030": "ਪੂਰਬੀ ਏਸ਼ੀਆ",
        "034": "ਦੱਖਣੀ ਏਸ਼ੀਆ",
        "035": "ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ",
        "039": "ਦੱਖਣੀ ਯੂਰਪ",
        "053": "ਔਸਟ੍ਰਾਲੇਸ਼ੀਆ",
        "054": "ਮੈਲਾਨੇਸ਼ੀਆ",
        "057": "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਖੇਤਰ",
        "061": "ਪੋਲਿਨੇਸ਼ੀਆ",
        "142": "ਏਸ਼ੀਆ",
        "143": "ਕੇਂਦਰੀ ਏਸ਼ੀਆ",
        "145": "ਪੱਛਮੀ ਏਸ਼ੀਆ",
        "150": "ਯੂਰਪ",
        "151": "ਪੂਰਬੀ ਯੂਰਪ",
        "154": "ਉੱਤਰੀ ਯੂਰਪ",
        "155": "ਪੱਛਮੀ ਯੂਰਪ",
        "419": "ਲੈਟਿਨ ਅਮਰੀਕਾ",
        "AC": "ਅਸੈਂਸ਼ਨ ਆਈਲੈਂਡ",
        "AD": "ਅੰਡੋਰਾ",
        "AE": "ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ",
        "AF": "ਅਫ਼ਗਾਨਿਸਤਾਨ",
        "AG": "ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ",
        "AI": "ਅੰਗੁਇਲਾ",
        "AL": "ਅਲਬਾਨੀਆ",
        "AM": "ਆਰਮੀਨਿਆ",
        "AO": "ਅੰਗੋਲਾ",
        "AQ": "ਅੰਟਾਰਕਟਿਕਾ",
        "AR": "ਅਰਜਨਟੀਨਾ",
        "AS": "ਅਮੈਰੀਕਨ ਸਮੋਆ",
        "AT": "ਆਸਟਰੀਆ",
        "AU": "ਆਸਟ੍ਰੇਲੀਆ",
        "AW": "ਅਰੂਬਾ",
        "AX": "ਅਲੈਂਡ ਆਈਲੈਂਡਸ",
        "AZ": "ਅਜ਼ਰਬੈਜਾਨ",
        "BA": "ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ",
        "BB": "ਬਾਰਬਾਡੋਸ",
        "BD": "ਬੰਗਲਾਦੇਸ਼",
        "BE": "ਬੈਲਜੀਅਮ",
        "BF": "ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ",
        "BG": "ਬੁਲਗਾਰਿਆ",
        "BH": "ਬਹਿਰੀਨ",
        "BI": "ਬੁਰੁੰਡੀ",
        "BJ": "ਬੇਨਿਨ",
        "BL": "ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ",
        "BM": "ਬਰਮੂਡਾ",
        "BN": "ਬਰੂਨੇਈ",
        "BO": "ਬੋਲੀਵੀਆ",
        "BQ": "ਕੈਰੇਬੀਅਨ ਨੀਦਰਲੈਂਡ",
        "BR": "ਬ੍ਰਾਜ਼ੀਲ",
        "BS": "ਬਹਾਮਾਸ",
        "BT": "ਭੂਟਾਨ",
        "BV": "ਬੌਵੇਟ ਆਈਲੈਂਡ",
        "BW": "ਬੋਟਸਵਾਨਾ",
        "BY": "ਬੇਲਾਰੂਸ",
        "BZ": "ਬੇਲੀਜ਼",
        "CA": "ਕੈਨੇਡਾ",
        "CC": "ਕੋਕੋਜ਼ (ਕੀਲਿੰਗ) ਆਈਲੈਂਡਸ",
        "CD": "ਕਾਂਗੋ - ਕਿਂਸ਼ਾਸਾ",
        "CF": "ਕੇਂਦਰੀ ਅਫਰੀਕੀ ਗਣਰਾਜ",
        "CG": "ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ",
        "CH": "ਸਵਿਟਜ਼ਰਲੈਂਡ",
        "CI": "ਕੋਟ ਡੀਵੋਆਰ",
        "CK": "ਕੁਕ ਆਈਲੈਂਡਸ",
        "CL": "ਚਿਲੀ",
        "CM": "ਕੈਮਰੂਨ",
        "CN": "ਚੀਨ",
        "CO": "ਕੋਲੰਬੀਆ",
        "CP": "ਕਲਿਪਰਟਨ ਆਈਲੈਂਡ",
        "CR": "ਕੋਸਟਾ ਰੀਕਾ",
        "CU": "ਕਿਊਬਾ",
        "CV": "ਕੇਪ ਵਰਡ",
        "CW": "ਕੁਰਾਕਾਓ",
        "CX": "ਕ੍ਰਿਸਮਸ ਆਈਲੈਂਡ",
        "CY": "ਸਾਇਪਰਸ",
        "CZ": "ਚੈਕ ਗਣਰਾਜ",
        "DE": "ਜਰਮਨੀ",
        "DG": "ਡੀਗੋ ਗਾਰਸ਼ੀਆ",
        "DJ": "ਜ਼ੀਬੂਤੀ",
        "DK": "ਡੈਨਮਾਰਕ",
        "DM": "ਡੋਮੀਨਿਕਾ",
        "DO": "ਡੌਮਿਨਿਕਨ ਗਣਰਾਜ",
        "DZ": "ਅਲਜੀਰੀਆ",
        "EA": "ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ",
        "EC": "ਇਕਵੇਡੋਰ",
        "EE": "ਇਸਟੋਨੀਆ",
        "EG": "ਮਿਸਰ",
        "EH": "ਪੱਛਮੀ ਸਹਾਰਾ",
        "ER": "ਇਰੀਟ੍ਰਿਆ",
        "ES": "ਸਪੇਨ",
        "ET": "ਇਥੋਪੀਆ",
        "EU": "ਯੂਰੋਪੀਅਨ ਯੂਨਿਅਨ",
        "FI": "ਫਿਨਲੈਂਡ",
        "FJ": "ਫ਼ਿਜੀ",
        "FK": "ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ",
        "FM": "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ",
        "FO": "ਫੈਰੋ ਆਇਲੈਂਡਸ",
        "FR": "ਫ੍ਰਾਂਸ",
        "GA": "ਗਾਬੋਨ",
        "GB": "ਯੁਨਾਇਟੇਡ ਕਿੰਗਡਮ",
        "GD": "ਗ੍ਰੇਨਾਡਾ",
        "GE": "ਜਾਰਜਿਆ",
        "GF": "ਫ੍ਰੈਂਚ ਗੁਏਨਾ",
        "GG": "ਗਰਨਸੀ",
        "GH": "ਘਾਨਾ",
        "GI": "ਜਿਬਰਾਲਟਰ",
        "GL": "ਗ੍ਰੀਨਲੈਂਡ",
        "GM": "ਗਾਂਬੀਆ",
        "GN": "ਗਿਨੀ",
        "GP": "ਗੁਆਡੇਲੋਪ",
        "GQ": "ਭੂ-ਖੰਡੀ ਗਿਨੀ",
        "GR": "ਗ੍ਰੀਸ",
        "GS": "ਦੱਖਣੀ ਜਾਰਜਿਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਆਇਲੈਂਡਸ",
        "GT": "ਗੁਆਟੇਮਾਲਾ",
        "GU": "ਗੁਆਮ",
        "GW": "ਗਿਨੀ-ਬਿਸਾਉ",
        "GY": "ਗੁਯਾਨਾ",
        "HK": "ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ",
        "HM": "ਹਰਡ ਆਈਲੈਂਡ ਅਤੇ ਮੈਕਡੋਨਾਲਡ ਆਈਲੈਂਡਸ",
        "HN": "ਹਾਨਡੂਰਸ",
        "HR": "ਕਰੋਏਸ਼ੀਆ",
        "HT": "ਹਾਈਟੀ",
        "HU": "ਹੰਗਰੀ",
        "IC": "ਕੇਨੇਰੀ ਆਈਲੈਂਡਜ਼",
        "ID": "ਇੰਡੋਨੇਸ਼ੀਆ",
        "IE": "ਆਇਰਲੈਂਡ",
        "IL": "ਇਜ਼ਰਾਈਲ",
        "IM": "ਆਇਲ ਆਫ ਮੈਨ",
        "IN": "ਭਾਰਤ",
        "IO": "ਬ੍ਰਿਟਿਸ਼ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਟੈਰਿਟਰੀ",
        "IQ": "ਇਰਾਕ",
        "IR": "ਈਰਾਨ",
        "IS": "ਆਈਸਲੈਂਡ",
        "IT": "ਇਟਲੀ",
        "JE": "ਜਰਸੀ",
        "JM": "ਜਮਾਇਕਾ",
        "JO": "ਜੌਰਡਨ",
        "JP": "ਜਾਪਾਨ",
        "KE": "ਕੀਨੀਆ",
        "KG": "ਕਿਰਗਿਜ਼ਸਤਾਨ",
        "KH": "ਕੰਬੋਡੀਆ",
        "KI": "ਕੀਰੀਬਾਟੀ",
        "KM": "ਕੋਮੋਰੋਸ",
        "KN": "ਸੈਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ",
        "KP": "ਉੱਤਰੀ ਕੋਰੀਆ",
        "KR": "ਦੱਖਣੀ ਕੋਰੀਆ",
        "KW": "ਕੁਵੈਤ",
        "KY": "ਕੇਮੈਨ ਆਈਲੈਂਡਸ",
        "KZ": "ਕਜ਼ਾਕਸਤਾਨ",
        "LA": "ਲਾਓਸ",
        "LB": "ਲੈਬਨਾਨ",
        "LC": "ਸੇਂਟ ਲੂਸੀਆ",
        "LI": "ਲਿਕਟਨਸਟਾਇਨ",
        "LK": "ਸ੍ਰੀ ਲੰਕਾ",
        "LR": "ਲਾਈਬੀਰੀਆ",
        "LS": "ਲੇਸੋਥੋ",
        "LT": "ਲਿਥੁਆਨੀਆ",
        "LU": "ਲਕਜ਼ਮਬਰਗ",
        "LV": "ਲਾਟਵਿਆ",
        "LY": "ਲੀਬੀਆ",
        "MA": "ਮੋਰੱਕੋ",
        "MC": "ਮੋਨਾਕੋ",
        "MD": "ਮੋਲਡੋਵਾ",
        "ME": "ਮੋਨਟੇਨੇਗਰੋ",
        "MF": "ਸੇਂਟ ਮਾਰਟਿਨ",
        "MG": "ਮੈਡਾਗਾਸਕਰ",
        "MH": "ਮਾਰਸ਼ਲ ਆਈਲੈਂਡਸ",
        "MK": "ਮੈਕਡੋਨੀਆ",
        "ML": "ਮਾਲੀ",
        "MM": "ਮਿਆਂਮਾਰ",
        "MN": "ਮੰਗੋਲੀਆ",
        "MO": "ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ",
        "MP": "ਉੱਤਰੀ ਮਰੀਆਨਾ ਆਈਲੈਂਡ",
        "MQ": "ਮਾਰਟੀਨਿਕ",
        "MR": "ਮੋਰਿਟਾਨੀਆ",
        "MS": "ਮੋਂਟਸੇਰਾਤ",
        "MT": "ਮਾਲਟਾ",
        "MU": "ਮੌਰਿਸ਼ਸ",
        "MV": "ਮਾਲਦੀਵ",
        "MW": "ਮਾਲਾਵੀ",
        "MX": "ਮੈਕਸਿਕੋ",
        "MY": "ਮਲੇਸ਼ੀਆ",
        "MZ": "ਮੋਜ਼ਾਮਬੀਕ",
        "NA": "ਨਾਮੀਬੀਆ",
        "NC": "ਨਿਊ ਕੈਲੇਡੋਨਿਆ",
        "NE": "ਨਾਇਜਰ",
        "NF": "ਨੋਰਫੌਕ ਆਈਲੈਂਡ",
        "NG": "ਨਾਇਜੀਰੀਆ",
        "NI": "ਨਿਕਾਰਾਗੁਆ",
        "NL": "ਨੀਦਰਲੈਂਡਸ",
        "NO": "ਨਾਰਵੇ",
        "NP": "ਨੇਪਾਲ",
        "NR": "ਨਾਉਰੂ",
        "NU": "ਨਿਯੂ",
        "NZ": "ਨਿਊਜ਼ੀਲੈਂਡ",
        "OM": "ਓਮਾਨ",
        "PA": "ਪਨਾਮਾ",
        "PE": "ਪੇਰੂ",
        "PF": "ਫ੍ਰੈਂਚ ਪੋਲਿਨੇਸ਼ੀਆ",
        "PG": "ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ",
        "PH": "ਫਿਲਿਪੀਨੀਜ਼",
        "PK": "ਪਾਕਿਸਤਾਨ",
        "PL": "ਪੋਲੈਂਡ",
        "PM": "ਸੈਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ",
        "PN": "ਪਿਟਕੈਰਨ ਆਈਲੈਂਡਸ",
        "PR": "ਪਿਊਰਟੋ ਰਿਕੋ",
        "PS": "ਪਲੈਸਟਿਨੀ ਪ੍ਰਦੇਸ਼",
        "PT": "ਪੁਰਤਗਾਲ",
        "PW": "ਪਲਾਉ",
        "PY": "ਪੈਰਾਗਵੇ",
        "QA": "ਕਤਰ",
        "QO": "ਆਊਟਲਾਇੰਗ ਓਸ਼ਨੀਆ",
        "RE": "ਰਿਯੂਨਿਅਨ",
        "RO": "ਰੋਮਾਨੀਆ",
        "RS": "ਸਰਬੀਆ",
        "RU": "ਰੂਸ",
        "RW": "ਰਵਾਂਡਾ",
        "SA": "ਸਾਉਦੀ ਅਰਬ",
        "SB": "ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ",
        "SC": "ਸੇਸ਼ਲਸ",
        "SD": "ਸੁਡਾਨ",
        "SE": "ਸਵੀਡਨ",
        "SG": "ਸਿੰਗਾਪੁਰ",
        "SH": "ਸੇਂਟ ਹੇਲੇਨਾ",
        "SI": "ਸਲੋਵੇਨੀਆ",
        "SJ": "ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ",
        "SK": "ਸਲੋਵਾਕੀਆ",
        "SL": "ਸਿਏਰਾ ਲਿਓਨ",
        "SM": "ਸੈਨ ਮਰੀਨੋ",
        "SN": "ਸੇਨੇਗਲ",
        "SO": "ਸੋਮਾਲੀਆ",
        "SR": "ਸੂਰੀਨਾਮ",
        "SS": "ਦੱਖਣੀ ਸੁਡਾਨ",
        "ST": "ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ",
        "SV": "ਅਲ ਸਲਵਾਡੋਰ",
        "SX": "ਸਿੰਟ ਮਾਰਟੀਨ",
        "SY": "ਸੀਰੀਆ",
        "SZ": "ਸਵਾਜ਼ੀਲੈਂਡ",
        "TA": "ਤ੍ਰਿਸਟਾਨ ਡਾ ਕੁਨਾ",
        "TC": "ਤੁਰਕਸ ਐਂਡ ਕੇਕੋਸ ਆਈਲੈਂਡਸ",
        "TD": "ਚਾਡ",
        "TF": "ਫ੍ਰੈਂਚ ਸਾਉਦਰਨ ਟੈਰੀਟਰੀਜ਼",
        "TG": "ਟੋਗੋ",
        "TH": "ਥਾਈਲੈਂਡ",
        "TJ": "ਤਾਜਿਕਿਸਤਾਨ",
        "TK": "ਟੋਕੇਲਾਉ",
        "TL": "ਟੀਮੁਰ-ਲੀਸਟੀ",
        "TM": "ਤੁਰਕਮੇਨਿਸਤਾਨ",
        "TN": "ਟਿਉਨੀਸ਼ੀਆ",
        "TO": "ਟੌਂਗਾ",
        "TR": "ਤੁਰਕੀ",
        "TT": "ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ",
        "TV": "ਟੁਵਾਲੂ",
        "TW": "ਤਾਇਵਾਨ",
        "TZ": "ਤਨਜ਼ਾਨੀਆ",
        "UA": "ਯੂਕਰੇਨ",
        "UG": "ਯੂਗਾਂਡਾ",
        "UM": "ਯੂ.ਐਸ. ਆਊਟਲਾਇੰਗ ਆਈਲੈਂਡਸ",
        "US": "ਯੂਨਾਇਟੇਡ ਸਟੇਟਸ",
        "UY": "ਉਰੂਗਵੇ",
        "UZ": "ਉਜ਼ਬੇਕਿਸਤਾਨ",
        "VA": "ਵੈਟਿਕਨ ਸਿਟੀ",
        "VC": "ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ",
        "VE": "ਵੇਨੇਜ਼ੂਏਲਾ",
        "VG": "ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਆਈਲੈਂਡਸ",
        "VI": "ਯੂ ਐਸ ਵਰਜਿਨ ਆਈਲੈਂਡਸ",
        "VN": "ਵਿਯਤਨਾਮ",
        "VU": "ਵਾਨੂਆਟੂ",
        "WF": "ਵਾਲਿਸ ਐਂਡ ਫਯੁਚੁਨਾ",
        "WS": "ਸਾਮੋਆ",
        "XK": "ਕੋਸੋਵੋ",
        "YE": "ਯਮਨ",
        "YT": "ਮਾਯੋਟੀ",
        "ZA": "ਦੱਖਣੀ ਅਫਰੀਕਾ",
        "ZM": "ਜ਼ਾਮਬੀਆ",
        "ZW": "ਜ਼ਿੰਬਾਬਵੇ",
        "ZZ": "ਅਗਿਆਤ ਖੇਤਰ"
    };
  }-*/;
}
