/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class Base64BinaryType
extends AtomicSimpleType {
    static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static final String B16 = "AEIMQUYcgkosw048";
    static final String B04 = "AQgw";
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        try {
            int n2 = n - 1;
            while (n2 >= 0) {
                char c;
                char c2;
                char c3;
                char c4;
                if ((c4 = string.charAt(n2--)) == ' ') {
                    c4 = string.charAt(n2--);
                }
                if ((c3 = string.charAt(n2--)) == ' ') {
                    c3 = string.charAt(n2--);
                }
                if ((c2 = string.charAt(n2--)) == ' ') {
                    c2 = string.charAt(n2--);
                }
                if ((c = string.charAt(n2--)) == ' ') {
                    c = string.charAt(n2--);
                }
                if (c4 == '=' ? (c3 == '=' ? B04.indexOf(c2) != -1 && B64.indexOf(c) != -1 : B16.indexOf(c3) != -1 && B64.indexOf(c2) != -1 && B64.indexOf(c) != -1) : B64.indexOf(c4) != -1) continue;
                throw new DatatypeException(n2, "illegal BASE64");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DatatypeException("illegal BASE64");
        }
    }

    Base64BinaryType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"), TypeLibrary.ANY_SIMPLE_TYPE);
    }
}

