/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.PositionedObject;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.run.Balancer;
import br.arca.morcego.run.Feeder;
import br.arca.morcego.run.Rotator;
import br.arca.morcego.structure.GraphElement;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import br.arca.morcego.transport.Transport;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.MouseInputListener;

public class Graph
extends Component
implements MouseInputListener,
PositionedObject,
Runnable {
    private static final long serialVersionUID = -4592004647118214474L;
    private Vector visibleNodes;
    private Vector visibleLinks;
    private Vector visibleElements;
    private Vector elements;
    private Vector nodes;
    private Hashtable nodesFromId = new Hashtable();
    private Node centerNode;
    private Rotator rotator;
    private Vector3D orientation;
    private Balancer balancer;
    private Feeder feeder;
    private int dragSpeedX;
    private int dragSpeedY;
    private boolean focusFixed = false;
    private GraphElement oldFocus;
    private GraphElement focus;
    private int previousX;
    private int previousY;

    public Graph() {
        this.elements = new Vector();
        this.nodes = new Vector();
        this.visibleElements = new Vector();
        this.visibleNodes = new Vector();
        this.visibleLinks = new Vector();
        this.orientation = new Vector3D(1.0f, 0.0f, 0.0f);
    }

    public void addElement(GraphElement e) {
        e.setGraph(this);
        this.elements.add(e);
    }

    public void addNode(Node node) {
        if (this.getNodeById(node.getId()) == null) {
            this.addElement(node);
            this.nodes.add(node);
            this.nodesFromId.put(node.getId(), node);
            Enumeration e = node.getLinks();
            while (e.hasMoreElements()) {
                Link link = (Link)e.nextElement();
                this.addLink(link);
            }
        }
        if (this.centerNode == null && node.getId().equals(this.getCenterId())) {
            this.center(node);
        }
    }

    public void addLink(Link link) {
        if (!this.elements.contains(link)) {
            this.addElement(link);
            if (link.getNode1().isVisible() && link.getNode2().isVisible()) {
                this.visibleLinks.add(link);
                this.visibleElements.add(link);
            }
        }
    }

    public boolean isVisible(GraphElement element) {
        return this.visibleElements.contains(element);
    }

    public void showNode(Node node) {
        if (!this.elements.contains(node)) {
            this.addNode(node);
        }
        if (!this.isVisible(node)) {
            this.visibleElements.add(node);
            this.visibleNodes.add(node);
            Enumeration e = node.getLinks();
            while (e.hasMoreElements()) {
                Link link = (Link)e.nextElement();
                if (!link.getOther(node).isVisible() || this.isVisible(link)) continue;
                this.visibleElements.add(link);
                this.visibleLinks.add(link);
            }
        }
        this.notifyBalancer();
    }

    public void hideNode(Node node) {
        node.hideDescription();
        this.visibleElements.remove(node);
        this.visibleNodes.remove(node);
        Enumeration e = node.getLinks();
        while (e.hasMoreElements()) {
            Link link = (Link)e.nextElement();
            link.hideDescription();
            this.visibleElements.remove(link);
            this.visibleLinks.remove(link);
        }
    }

    public void removeNode(Node node) {
        this.elements.remove(node);
        this.nodes.remove(node);
        this.visibleElements.remove(node);
        this.visibleNodes.remove(node);
        this.nodesFromId.remove(node.getId());
        Enumeration e = node.getLinks();
        while (e.hasMoreElements()) {
            Link link = (Link)e.nextElement();
            this.elements.remove(link);
            this.visibleElements.remove(link);
            this.visibleLinks.remove(link);
        }
        if (this.focus == node) {
            this.focus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void order() {
        Vector vector = this.visibleElements;
        synchronized (vector) {
            Collections.sort(this.visibleElements, new RenderingStrategy());
        }
    }

    public void navigateTo(Node node) {
        this.center(node);
        this.notifyFeeder();
        this.notifyBalancer();
    }

    public void center(Node newCenter) {
        if (this.centerNode != null) {
            this.centerNode.unCenter();
        }
        this.centerNode = newCenter;
        newCenter.center();
    }

    public void calculateDistances() {
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            ((Node)e.nextElement()).setCenterDistance(null);
        }
        Vector<Node> nodeQueue = new Vector<Node>();
        nodeQueue.add(this.centerNode);
        int distance = 0;
        while (!nodeQueue.isEmpty()) {
            int size = nodeQueue.size();
            int i = 0;
            while (i < size) {
                Node node = (Node)nodeQueue.remove(0);
                node.setCenterDistance(new Integer(distance));
                Enumeration e2 = node.getLinks();
                while (e2.hasMoreElements()) {
                    Node neighbour = ((Link)e2.nextElement()).getOther(node);
                    if (nodeQueue.contains(neighbour) || neighbour.getCenterDistance() != null) continue;
                    nodeQueue.add(neighbour);
                }
                ++i;
            }
            ++distance;
        }
    }

    public Node getNodeById(String nodeId) {
        Node node = (Node)this.nodesFromId.get(nodeId);
        return node;
    }

    public Node getCenterNode() {
        return this.centerNode;
    }

    private void savePosition(MouseEvent e) {
        this.previousX = e.getX();
        this.previousY = e.getY();
    }

    public boolean contains(MouseEvent e) {
        if (this.focusFixed) {
            return true;
        }
        this.order();
        boolean contains = false;
        int i = this.visibleElements.size() - 1;
        while (i >= 0 && !contains) {
            GraphElement component = (GraphElement)this.visibleElements.elementAt(i);
            if (component.visible() && component.contains(e)) {
                this.oldFocus = this.focus;
                this.focus = component;
                contains = true;
            }
            --i;
        }
        if (!contains) {
            this.oldFocus = this.focus;
            this.focus = null;
        }
        if (this.focus != this.oldFocus) {
            if (this.focus != null) {
                this.focus.mouseEntered(e);
            }
            if (this.oldFocus != null) {
                this.oldFocus.mouseExited(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Vector vector = this.visibleElements;
        synchronized (vector) {
            this.order();
            Enumeration e = this.visibleElements.elements();
            while (e.hasMoreElements()) {
                GraphElement element = (GraphElement)e.nextElement();
                if (!element.visible()) continue;
                element.paint(g);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.rotator.stop();
        if (this.contains(e) && this.focus != null) {
            this.focus.mouseClicked(e);
        }
        this.savePosition(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.rotator.stop();
        if (this.focus != null) {
            this.focus.mousePressed(e);
        }
        this.savePosition(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.focus != null) {
            this.focus.mouseReleased(e);
        } else if (Math.abs(this.dragSpeedX) + Math.abs(this.dragSpeedY) > 4) {
            this.rotator.spin(this.dragSpeedY / 5, -this.dragSpeedX / 5);
        }
        this.savePosition(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.focus != null) {
            this.focus.mouseDragged(e);
        } else {
            this.dragSpeedX = e.getX() - this.previousX;
            this.dragSpeedY = e.getY() - this.previousY;
            this.rotate(this.dragSpeedY, -this.dragSpeedX);
        }
        Morcego.notifyRenderer();
        this.savePosition(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.contains(e) && this.focus != null) {
            this.focus.mouseMoved(e);
        }
        this.savePosition(e);
    }

    public Vector getVisibleNodes() {
        return this.visibleNodes;
    }

    public Vector getVisibleLinks() {
        return this.visibleLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFeeder() {
        Feeder feeder = this.feeder;
        synchronized (feeder) {
            this.feeder.notifyFeeder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBalancer() {
        if (this.balancer != null) {
            Balancer balancer = this.balancer;
            synchronized (balancer) {
                this.balancer.awake();
            }
        }
    }

    public void run() {
        Class transportClass = null;
        Transport transport = null;
        try {
            transportClass = Config.getTransportClass();
            transport = (Transport)transportClass.newInstance();
            transport.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.feeder = new Feeder(this, transport);
        this.balancer = new Balancer(this);
        this.rotator = new Rotator(this);
        Thread feedingThread = new Thread(this.feeder);
        Thread balanceThread = new Thread(this.balancer);
        Thread spinningThread = new Thread(this.rotator);
        feedingThread.start();
        spinningThread.start();
        balanceThread.start();
    }

    public void finish() {
        if (this.feeder != null) {
            this.feeder.finish();
        }
        if (this.balancer != null) {
            this.balancer.finish();
        }
        if (this.rotator != null) {
            this.rotator.finish();
        }
    }

    public void fixFocus() {
        this.focusFixed = true;
    }

    public void releaseFocus() {
        this.focusFixed = false;
        this.focus = null;
    }

    public Vector3D getOrientation() {
        return this.orientation;
    }

    public synchronized void rotate(float xTheta, float yTheta) {
        Enumeration e = this.getVisibleNodes().elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            node.rotate(xTheta, yTheta);
        }
        this.getOrientation().rotate(xTheta, yTheta);
        Morcego.getCamera().adjustPosition(this);
    }

    public Node getFocus() {
        return (Node)this.focus;
    }

    public Vector getVisibleElements() {
        return this.visibleElements;
    }

    public String getCenterId() {
        if (this.centerNode != null) {
            return this.centerNode.getId();
        }
        return Config.getString("morcego.startNode");
    }

    public void hideFarNodes() {
        Enumeration e = this.getNodes().elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            if (node.getCenterDistance() <= Config.getInteger("morcego.navigationDepth")) continue;
            this.hideNode(node);
        }
    }

    private Vector getNodes() {
        return this.nodes;
    }

    private final class RenderingStrategy
    implements Comparator {
        private RenderingStrategy() {
        }

        public int compare(Object o1, Object o2) {
            if (((GraphElement)o1).getDepth() > ((GraphElement)o2).getDepth()) {
                return -1;
            }
            if (((GraphElement)o1).getDepth() == ((GraphElement)o2).getDepth()) {
                return 0;
            }
            return 1;
        }
    }
}

