<?php

/**
 * BaseTimesheet
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                       $timesheetId                                    Type: integer, primary key
 * @property int                                       $employeeId                                     Type: integer
 * @property string                                    $state                                          Type: string(255)
 * @property string                                    $startDate                                      Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                                    $endDate                                        Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property Doctrine_Collection|TimesheetItem[]       $TimesheetItem                                  
 * @property Doctrine_Collection|TimesheetActionLog[]  $TimesheetActionLog                             
 *  
 * @method int                                         getTimesheetid()                                Type: integer, primary key
 * @method int                                         getEmployeeid()                                 Type: integer
 * @method string                                      getState()                                      Type: string(255)
 * @method string                                      getStartdate()                                  Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                                      getEnddate()                                    Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method Doctrine_Collection|TimesheetItem[]         getTimesheetItem()                              
 * @method Doctrine_Collection|TimesheetActionLog[]    getTimesheetActionLog()                         
 *  
 * @method Timesheet                                   setTimesheetid(int $val)                        Type: integer, primary key
 * @method Timesheet                                   setEmployeeid(int $val)                         Type: integer
 * @method Timesheet                                   setState(string $val)                           Type: string(255)
 * @method Timesheet                                   setStartdate(string $val)                       Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method Timesheet                                   setEnddate(string $val)                         Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method Timesheet                                   setTimesheetItem(Doctrine_Collection $val)      
 * @method Timesheet                                   setTimesheetActionLog(Doctrine_Collection $val) 
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseTimesheet extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_timesheet');
        $this->hasColumn('timesheet_id as timesheetId', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('employee_id as employeeId', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('state', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 255,
             ));
        $this->hasColumn('start_date as startDate', 'date', null, array(
             'type' => 'date',
             'notnull' => true,
             ));
        $this->hasColumn('end_date as endDate', 'date', null, array(
             'type' => 'date',
             'notnull' => true,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('TimesheetItem', array(
             'local' => 'timesheetId',
             'foreign' => 'timesheetId'));

        $this->hasMany('TimesheetActionLog', array(
             'local' => 'timesheetId',
             'foreign' => 'timesheet_id'));
    }
}