require 'runit/testcase'
require 'digit-0'

class TestDigit < RUNIT::TestCase

  def test_value
    assert_equals( 10, Digit::new( '10' ).value )
    assert_equals( 16, Digit::new( '0x10' ).value )
  end

  def test_to_s
    assert_equals( '16', Digit::new( '0x10' ).to_s( 10 ) )
    assert_equals( '0xA', Digit::new( '10' ).to_s( 16 ) )
  end

end
