/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MathMLConverter {
    private boolean bSupportMathML;

    public MathMLConverter(boolean bSupportMathML) {
        this.bSupportMathML = bSupportMathML;
    }

    public void convert(Node onode, Node hnode) {
        if (this.bSupportMathML) {
            this.convertNode(onode, hnode);
        } else {
            Document htmlDOM = hnode.getOwnerDocument();
            NodeList annotationList = ((Element)onode).getElementsByTagName("math:annotation");
            if (annotationList.getLength() > 0 && annotationList.item(0).hasChildNodes()) {
                Element kbd = htmlDOM.createElement("kbd");
                hnode.appendChild(kbd);
                NodeList list = annotationList.item(0).getChildNodes();
                int nLen = list.getLength();
                int i = 0;
                while (i < nLen) {
                    Node child = list.item(i);
                    if (child.getNodeType() == 3) {
                        kbd.appendChild(htmlDOM.createTextNode(child.getNodeValue()));
                    }
                    ++i;
                }
            } else {
                hnode.appendChild(htmlDOM.createTextNode("[Warning: formula ignored]"));
            }
        }
    }

    public void convertNode(Node onode, Node hnode) {
        if (onode.getNodeType() == 1) {
            if (onode.getNodeName().equals("math:semantics")) {
                this.convertNodeList(onode.getChildNodes(), hnode);
            } else if (!onode.getNodeName().equals("math:annotation")) {
                String sElementName = this.stripNamespace(onode.getNodeName());
                Element newNode = hnode.getOwnerDocument().createElement(sElementName);
                hnode.appendChild(newNode);
                if (onode.hasAttributes()) {
                    NamedNodeMap attr = onode.getAttributes();
                    int nLen = attr.getLength();
                    int i = 0;
                    while (i < nLen) {
                        String sName = attr.item(i).getNodeName();
                        sName = sName.equals("xmlns:math") ? "xmlns" : this.stripNamespace(sName);
                        String sValue = attr.item(i).getNodeValue();
                        newNode.setAttribute(sName, sValue);
                        ++i;
                    }
                }
                this.convertNodeList(onode.getChildNodes(), newNode);
            }
        } else if (onode.getNodeType() == 3) {
            hnode.appendChild(hnode.getOwnerDocument().createTextNode(onode.getNodeValue()));
        }
    }

    private void convertNodeList(NodeList list, Node hnode) {
        if (list == null) {
            return;
        }
        int nLen = list.getLength();
        int i = 0;
        while (i < nLen) {
            this.convertNode(list.item(i), hnode);
            ++i;
        }
    }

    private String stripNamespace(String s) {
        int nPos = s.indexOf(58);
        return s.substring(nPos + 1);
    }
}

