.TH GRAY2CLR 1 25-Jun-90
.CM 3
.SH NAME
gray2clr, unmap \- add a colormap to a grayscale image, unmap a color image
.SH SYNOPSIS
.nf
gray2clr [ -<type> ] [ -u ] < gray > color	or
.br
unmap [ -<type> ] < gray > color
.fi
.SH DESCRIPTION
.PP
Adds a colormap to an 8bit grayscale image, allowing it to be displayed
on a frame buffer.  The image will still be black and white, of course.
.sp
If invoked as
.I unmap,
or with the
.B -u
option, the output is given as RGB values instead of mapped color.
This routine can be used to convert mapped color to unmapped color as
well.  This must be done before
.I fbext
is used to resize a mapped color image.  Then the result can be
remapped using
.I fbquant.
.SH OPTIONS
.TP
.BR -u
.I unmap,
makes the output a 3 plane image, instead of a mapped imsage.
This must be done before the image can be resized (with fbext(1)) or
quantized (with fbquant(1)).
.SH EXAMPLE
Add a colormap to a grayscale file for viewing on a frame buffer:
.sp
    % gray2clr -S < foo.8bit > foo.clr
.sp
Convert a mapped color image to unmapped and then adjust the aspect
ratio:
.sp
    % gray2clr -u < foo.gif | fbext -a1 > foo.fbm
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Apr-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.91) mlm@cs.cmu.edu
