/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmdeflts.h,v 1.3 2004/01/17 04:05:41 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.3 $
 * $Name: OpenRM-1-5-2-RC3 $
 * $Log: rmdeflts.h,v $
 * Revision 1.3  2004/01/17 04:05:41  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.7  2003/01/16 22:21:15  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.6  2002/08/29 22:21:13  wes
 * Massive upgrade to accommodate dynamic object reallocation within
 * the component manager, and within the context cache. Use the
 * debug #define DEBUG_LEVEL DEBUG_REALLOC_TRACE to get a printf
 * whenever a realloc occurs. With this upgrade, there are no
 * OpenRM limits on the size of the scene graph. There will be external
 * limits, such as the amount of RAM and the amount of space available
 * to your OpenGL implementation.
 *
 * Revision 1.5  2002/08/17 15:17:54  wes
 * Removed #define RM_COMPONENT_POOL_SIZE. This is now a global variable
 * defined in rm/rmglobal.c. The new #define is called DEFAULT_COMPONENT_POOL_SIZE.
 *
 * Revision 1.4  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.3  2000/04/20 17:41:46  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:23  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmdeflts_h
#define _rmdeflts_h

#include <rm/rmdefs.h>

/*
 * the size of the component pool affects the maximum possible scene
 * graph size before all resources are exhausted. that limit is defined
 * by the value of DEFAULT_COMPONENT_POOL_SIZE.
 *
 * for the time being, this is a hard limit on the maximum amount of
 * scene graph nodes, images, textures, etc. that are available to any
 * application. in the future, we will reimplement a realloc scheme so
 * the hard limit goes away.
 *
 * This #define removed in 1.4.3. Look in rmcmpmgr.h for new infrastructure.
 *
 */
/*#define DEFAULT_COMPONENT_POOL_SIZE             4096 */

/* defaults for postscript printing - 8.5 x 11, portrait orientation, 1/2 inch min margin */
#define RM_PS_DEFAULT_PAGE_WIDTH_POINTS       	612
#define RM_PS_DEFAULT_PAGE_HEIGHT_POINTS      	792
#define RM_PS_DEFAULT_ORIENTATION             	RM_PS_PORTRAIT
#define RM_PS_DEFAULT_MIN_MARGIN              	36

#define RM_DEFAULT_RENDERMODE			RM_SHADER_SMOOTH

#define RM_DEFAULT_VIEWPORT_XMIN 		0.0
#define RM_DEFAULT_VIEWPORT_YMIN 		0.0
#define RM_DEFAULT_VIEWPORT_XMAX 		1.0
#define RM_DEFAULT_VIEWPORT_YMAX 		1.0

#endif /* _rmdeflts_h */
/* EOF */
