require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_RISCV_PMAP_H_)) {
    eval 'sub _RISCV_PMAP_H_ () {1;}' unless defined(&_RISCV_PMAP_H_);
    if(defined(&_KERNEL_OPT)) {
	require './riscv/opt_modular.ph';
    }
    if(!defined(&_MODULE)) {
	require 'sys/cdefs.ph';
	require 'sys/types.ph';
	require 'sys/pool.ph';
	require 'sys/evcnt.ph';
	require 'uvm/uvm_physseg.ph';
	require 'uvm/pmap/vmpagemd.ph';
	require 'riscv/pte.ph';
	require 'riscv/sysreg.ph';
	eval 'sub PMAP_SEGTABSIZE () { &NPTEPG;}' unless defined(&PMAP_SEGTABSIZE);
	eval 'sub PMAP_PDETABSIZE () { &NPTEPG;}' unless defined(&PMAP_PDETABSIZE);
	if(defined(&_LP64)) {
	    eval 'sub PTPSHIFT () {3;}' unless defined(&PTPSHIFT);
	    eval 'sub XSEGSHIFT () {( &SEGSHIFT +  &SEGLENGTH);}' unless defined(&XSEGSHIFT);
	    eval 'sub NBXSEG () {(1 <<  &XSEGSHIFT);}' unless defined(&NBXSEG);
	    eval 'sub XSEGOFSET () {( &NBXSEG - 1);}' unless defined(&XSEGOFSET);
	    eval 'sub XSEGLENGTH () {( &PGSHIFT - 3);}' unless defined(&XSEGLENGTH);
	    eval 'sub NXSEGPG () {(1<<  &XSEGLENGTH);}' unless defined(&NXSEGPG);
	} else {
	    eval 'sub PTPSHIFT () {2;}' unless defined(&PTPSHIFT);
	    eval 'sub XSEGSHIFT () { &SEGSHIFT;}' unless defined(&XSEGSHIFT);
	}
	eval 'sub SEGLENGTH () {( &PGSHIFT -  &PTPSHIFT);}' unless defined(&SEGLENGTH);
	eval 'sub SEGSHIFT () {( &SEGLENGTH +  &PGSHIFT);}' unless defined(&SEGSHIFT);
	eval 'sub NBSEG () {(1<<  &SEGSHIFT);}' unless defined(&NBSEG);
	eval 'sub SEGOFSET () {( &NBSEG - 1);}' unless defined(&SEGOFSET);
	eval 'sub KERNEL_PID () {0;}' unless defined(&KERNEL_PID);
	eval 'sub PMAP_HWPAGEWALKER () {1;}' unless defined(&PMAP_HWPAGEWALKER);
	eval 'sub PMAP_TLB_MAX () {1;}' unless defined(&PMAP_TLB_MAX);
	eval 'sub PMAP_TLB_ALWAYS_ASIDS () { &false;}' unless defined(&PMAP_TLB_ALWAYS_ASIDS);
	if(defined(&_LP64)) {
	    eval 'sub PMAP_INVALID_PDETAB_ADDRESS () {(( &pmap_pdetab_t *)( &VM_MIN_KERNEL_ADDRESS -  &PAGE_SIZE));}' unless defined(&PMAP_INVALID_PDETAB_ADDRESS);
	    eval 'sub PMAP_INVALID_SEGTAB_ADDRESS () {(( &pmap_segtab_t *)( &VM_MIN_KERNEL_ADDRESS -  &PAGE_SIZE));}' unless defined(&PMAP_INVALID_SEGTAB_ADDRESS);
	} else {
	    eval 'sub PMAP_INVALID_PDETAB_ADDRESS () {(( &pmap_pdetab_t *)0xdeadbeef);}' unless defined(&PMAP_INVALID_PDETAB_ADDRESS);
	    eval 'sub PMAP_INVALID_SEGTAB_ADDRESS () {(( &pmap_segtab_t *)0xdeadbeef);}' unless defined(&PMAP_INVALID_SEGTAB_ADDRESS);
	}
	eval 'sub PMAP_TLB_NUM_PIDS () {( &__SHIFTOUT_MASK( &SATP_ASID) + 1);}' unless defined(&PMAP_TLB_NUM_PIDS);
	eval 'sub PMAP_TLB_BITMAP_LENGTH () { &PMAP_TLB_NUM_PIDS;}' unless defined(&PMAP_TLB_BITMAP_LENGTH);
	eval 'sub PMAP_TLB_FLUSH_ASID_ON_RESET () { &true;}' unless defined(&PMAP_TLB_FLUSH_ASID_ON_RESET);
	eval 'sub pmap_phys_address {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&pmap_phys_address);
	unless(defined(&__BSD_PTENTRY_T__)) {
	    eval 'sub __BSD_PTENTRY_T__ () {1;}' unless defined(&__BSD_PTENTRY_T__);
	    if(defined(&_LP64)) {
		eval 'sub PRIxPTE () { &PRIx64;}' unless defined(&PRIxPTE);
	    } else {
		eval 'sub PRIxPTE () { &PRIx32;}' unless defined(&PRIxPTE);
	    }
	}
	eval 'sub PMAP_NEED_PROCWR () {1;}' unless defined(&PMAP_NEED_PROCWR);
	eval 'sub pmap_procwr {
	    my($p,$va,$len) = @_;
    	    eval q({  &__asm  &__volatile(\\"fence\\\\trw,rw; fence.i\\" ::: \\"memory\\"); });
	}' unless defined(&pmap_procwr);
	require 'uvm/pmap/tlb.ph';
	require 'uvm/pmap/pmap_devmap.ph';
	require 'uvm/pmap/pmap_tlb.ph';
	require 'uvm/pmap/pmap_synci.ph';
	eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
	if(defined(&_KERNEL)) {
	    eval 'sub __HAVE_PMAP_MD () {1;}' unless defined(&__HAVE_PMAP_MD);
	    eval 'sub pmap_md_icache_sync_all {
	        my($void) = @_;
    		eval q({ });
	    }' unless defined(&pmap_md_icache_sync_all);
	    eval 'sub pmap_md_icache_sync_range_index {
	        my($va,$size) = @_;
    		eval q({ });
	    }' unless defined(&pmap_md_icache_sync_range_index);
	    if(defined(&_LP64)) {
		eval 'sub PMAP_DIRECT_MAP {
		    my($pa) = @_;
    		    eval q( &RISCV_PA_TO_KVA($pa));
		}' unless defined(&PMAP_DIRECT_MAP);
		eval 'sub PMAP_DIRECT_UNMAP {
		    my($va) = @_;
    		    eval q( &RISCV_KVA_TO_PA($va));
		}' unless defined(&PMAP_DIRECT_UNMAP);
		eval 'sub POOL_PHYSTOV {
		    my($pa) = @_;
    		    eval q( &RISCV_PA_TO_KVA(( &paddr_t)($pa)));
		}' unless defined(&POOL_PHYSTOV);
		eval 'sub POOL_VTOPHYS {
		    my($va) = @_;
    		    eval q( &RISCV_KVA_TO_PA(( &vaddr_t)($va)));
		}' unless defined(&POOL_VTOPHYS);
	    }
	    eval 'sub MEGAPAGE_TRUNC {
	        my($x) = @_;
    		eval q((($x) & ~ &SEGOFSET));
	    }' unless defined(&MEGAPAGE_TRUNC);
	    eval 'sub MEGAPAGE_ROUND {
	        my($x) = @_;
    		eval q( &MEGAPAGE_TRUNC(($x) +  &SEGOFSET));
	    }' unless defined(&MEGAPAGE_ROUND);
	    eval 'sub PMAP_DEV () { &__BIT(29);}' unless defined(&PMAP_DEV);
	    eval 'sub DEVMAP_ALIGN {
	        my($x) = @_;
    		eval q( &MEGAPAGE_TRUNC(($x)));
	    }' unless defined(&DEVMAP_ALIGN);
	    eval 'sub DEVMAP_SIZE {
	        my($x) = @_;
    		eval q( &MEGAPAGE_ROUND(($x)));
	    }' unless defined(&DEVMAP_SIZE);
	    eval 'sub DEVMAP_FLAGS () { &PMAP_DEV;}' unless defined(&DEVMAP_FLAGS);
	    if(defined(&__PMAP_PRIVATE)) {
		eval 'sub pmap_md_tlb_check_entry {
		    my($ctx,$va,$asid,$pte) = @_;
    		    eval q({  &false; });
		}' unless defined(&pmap_md_tlb_check_entry);
		eval 'sub pmap_md_page_syncicache {
		    my($mdpg,$onproc) = @_;
    		    eval q({  &__asm  &__volatile(\\"fence\\\\trw,rw; fence.i\\" ::: \\"memory\\"); });
		}' unless defined(&pmap_md_page_syncicache);
		eval 'sub pmap_md_vca_remove {
		    my($mdpg,$va) = @_;
    		    eval q({ });
		}' unless defined(&pmap_md_vca_remove);
		eval 'sub pmap_md_vca_clean {
		    my($mdpg,$va,$op) = @_;
    		    eval q({ });
		}' unless defined(&pmap_md_vca_clean);
		eval 'sub pmap_md_tlb_asid_max {
		    my($void) = @_;
    		    eval q({  &const  &register_t  &satp =  &csr_satp_read();  &const  &register_t  &test =  &satp |  &SATP_ASID;  &csr_satp_write( &test);  &const  &register_t  &ret =  &__SHIFTOUT( &csr_satp_read(),  &SATP_ASID);  &csr_satp_write( &satp);  &KASSERT( &ret <  &PMAP_TLB_NUM_PIDS);  &ret; });
		}' unless defined(&pmap_md_tlb_asid_max);
		eval 'sub pmap_md_nptep {
		    my($ptep) = @_;
    		    eval q({ $ptep + 1; });
		}' unless defined(&pmap_md_nptep);
	    }
	}
	require 'uvm/pmap/pmap.ph';
    }
    if(defined(&MODULAR) || defined(&_MODULE)) {
	unless(defined(&__HAVE_VM_PAGE_MD)) {
	    eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	}
    }
}
1;
