require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SOUNDCARD_H_)) {
    eval 'sub _SOUNDCARD_H_ () {1;}' unless defined(&_SOUNDCARD_H_);
    unless(defined(&SOUND_VERSION)) {
	eval 'sub SOUND_VERSION () {0x30001;}' unless defined(&SOUND_VERSION);
    }
    eval 'sub SNDCTL_DSP_RESET () { &_IO (ord(\'P\'), 0);}' unless defined(&SNDCTL_DSP_RESET);
    eval 'sub SNDCTL_DSP_SYNC () { &_IO (ord(\'P\'), 1);}' unless defined(&SNDCTL_DSP_SYNC);
    eval 'sub SNDCTL_DSP_SPEED () { &_IOWR(ord(\'P\'), 2, \'int\');}' unless defined(&SNDCTL_DSP_SPEED);
    eval 'sub SOUND_PCM_READ_RATE () { &_IOR (ord(\'P\'), 2, \'int\');}' unless defined(&SOUND_PCM_READ_RATE);
    eval 'sub SNDCTL_DSP_STEREO () { &_IOWR(ord(\'P\'), 3, \'int\');}' unless defined(&SNDCTL_DSP_STEREO);
    eval 'sub SNDCTL_DSP_GETBLKSIZE () { &_IOWR(ord(\'P\'), 4, \'int\');}' unless defined(&SNDCTL_DSP_GETBLKSIZE);
    eval 'sub SNDCTL_DSP_SETFMT () { &_IOWR(ord(\'P\'), 5, \'int\');}' unless defined(&SNDCTL_DSP_SETFMT);
    eval 'sub AFMT_QUERY () {0x;}' unless defined(&AFMT_QUERY);
    eval 'sub AFMT_MU_LAW () {0x1;}' unless defined(&AFMT_MU_LAW);
    eval 'sub AFMT_A_LAW () {0x2;}' unless defined(&AFMT_A_LAW);
    eval 'sub AFMT_IMA_ADPCM () {0x4;}' unless defined(&AFMT_IMA_ADPCM);
    eval 'sub AFMT_U8 () {0x8;}' unless defined(&AFMT_U8);
    eval 'sub AFMT_S16_LE () {0x10;}' unless defined(&AFMT_S16_LE);
    eval 'sub AFMT_S16_BE () {0x20;}' unless defined(&AFMT_S16_BE);
    eval 'sub AFMT_S8 () {0x40;}' unless defined(&AFMT_S8);
    eval 'sub AFMT_U16_LE () {0x80;}' unless defined(&AFMT_U16_LE);
    eval 'sub AFMT_U16_BE () {0x100;}' unless defined(&AFMT_U16_BE);
    eval 'sub AFMT_MPEG () {0x200;}' unless defined(&AFMT_MPEG);
    eval 'sub AFMT_AC3 () {0x400;}' unless defined(&AFMT_AC3);
    eval 'sub AFMT_S24_LE () {0x800;}' unless defined(&AFMT_S24_LE);
    eval 'sub AFMT_S24_BE () {0x1000;}' unless defined(&AFMT_S24_BE);
    eval 'sub AFMT_S32_LE () {0x2000;}' unless defined(&AFMT_S32_LE);
    eval 'sub AFMT_S32_BE () {0x4000;}' unless defined(&AFMT_S32_BE);
    eval 'sub AFMT_FLOAT () {0x10000;}' unless defined(&AFMT_FLOAT);
    eval 'sub AFMT_SPDIF_RAW () {0x20000;}' unless defined(&AFMT_SPDIF_RAW);
    eval 'sub AFMT_S24_PACKED () {0x40000;}' unless defined(&AFMT_S24_PACKED);
    eval 'sub AFMT_VORBIS () {0x80000;}' unless defined(&AFMT_VORBIS);
    eval 'sub SNDCTL_DSP_SAMPLESIZE () { &SNDCTL_DSP_SETFMT;}' unless defined(&SNDCTL_DSP_SAMPLESIZE);
    eval 'sub SOUND_PCM_READ_BITS () { &_IOR (ord(\'P\'), 5, \'int\');}' unless defined(&SOUND_PCM_READ_BITS);
    eval 'sub SNDCTL_DSP_CHANNELS () { &_IOWR(ord(\'P\'), 6, \'int\');}' unless defined(&SNDCTL_DSP_CHANNELS);
    eval 'sub SOUND_PCM_WRITE_CHANNELS () { &SNDCTL_DSP_CHANNELS;}' unless defined(&SOUND_PCM_WRITE_CHANNELS);
    eval 'sub SOUND_PCM_READ_CHANNELS () { &_IOR (ord(\'P\'), 6, \'int\');}' unless defined(&SOUND_PCM_READ_CHANNELS);
    eval 'sub SOUND_PCM_WRITE_FILTER () { &_IOWR(ord(\'P\'), 7, \'int\');}' unless defined(&SOUND_PCM_WRITE_FILTER);
    eval 'sub SOUND_PCM_READ_FILTER () { &_IOR (ord(\'P\'), 7, \'int\');}' unless defined(&SOUND_PCM_READ_FILTER);
    eval 'sub SNDCTL_DSP_POST () { &_IO (ord(\'P\'), 8);}' unless defined(&SNDCTL_DSP_POST);
    eval 'sub SNDCTL_DSP_SUBDIVIDE () { &_IOWR(ord(\'P\'), 9, \'int\');}' unless defined(&SNDCTL_DSP_SUBDIVIDE);
    eval 'sub SNDCTL_DSP_SETFRAGMENT () { &_IOWR(ord(\'P\'), 10, \'int\');}' unless defined(&SNDCTL_DSP_SETFRAGMENT);
    eval 'sub SNDCTL_DSP_GETFMTS () { &_IOR (ord(\'P\'), 11, \'int\');}' unless defined(&SNDCTL_DSP_GETFMTS);
    eval 'sub SNDCTL_DSP_GETOSPACE () { &_IOR (ord(\'P\'),12, \'struct audio_buf_info\');}' unless defined(&SNDCTL_DSP_GETOSPACE);
    eval 'sub SNDCTL_DSP_GETISPACE () { &_IOR (ord(\'P\'),13, \'struct audio_buf_info\');}' unless defined(&SNDCTL_DSP_GETISPACE);
    eval 'sub SNDCTL_DSP_NONBLOCK () { &_IO (ord(\'P\'),14);}' unless defined(&SNDCTL_DSP_NONBLOCK);
    eval 'sub SNDCTL_DSP_GETCAPS () { &_IOR (ord(\'P\'),15, \'int\');}' unless defined(&SNDCTL_DSP_GETCAPS);
    eval 'sub DSP_CAP_REVISION () { &PCM_CAP_REVISION;}' unless defined(&DSP_CAP_REVISION);
    eval 'sub DSP_CAP_DUPLEX () { &PCM_CAP_DUPLEX;}' unless defined(&DSP_CAP_DUPLEX);
    eval 'sub DSP_CAP_REALTIME () { &PCM_CAP_REALTIME;}' unless defined(&DSP_CAP_REALTIME);
    eval 'sub DSP_CAP_BATCH () { &PCM_CAP_BATCH;}' unless defined(&DSP_CAP_BATCH);
    eval 'sub DSP_CAP_COPROC () { &PCM_CAP_COPROC;}' unless defined(&DSP_CAP_COPROC);
    eval 'sub DSP_CAP_TRIGGER () { &PCM_CAP_TRIGGER;}' unless defined(&DSP_CAP_TRIGGER);
    eval 'sub DSP_CAP_MMAP () { &PCM_CAP_MMAP;}' unless defined(&DSP_CAP_MMAP);
    eval 'sub DSP_CAP_INPUT () { &PCM_CAP_INPUT;}' unless defined(&DSP_CAP_INPUT);
    eval 'sub DSP_CAP_OUTPUT () { &PCM_CAP_OUTPUT;}' unless defined(&DSP_CAP_OUTPUT);
    eval 'sub DSP_CAP_MODEM () { &PCM_CAP_MODEM;}' unless defined(&DSP_CAP_MODEM);
    eval 'sub DSP_CAP_HIDDEN () { &PCM_CAP_HIDDEN;}' unless defined(&DSP_CAP_HIDDEN);
    eval 'sub DSP_CAP_VIRTUAL () { &PCM_CAP_VIRTUAL;}' unless defined(&DSP_CAP_VIRTUAL);
    eval 'sub DSP_CAP_ANALOGOUT () { &PCM_CAP_ANALOGOUT;}' unless defined(&DSP_CAP_ANALOGOUT);
    eval 'sub DSP_CAP_ANALOGIN () { &PCM_CAP_ANALOGIN;}' unless defined(&DSP_CAP_ANALOGIN);
    eval 'sub DSP_CAP_DIGITALOUT () { &PCM_CAP_DIGITALOUT;}' unless defined(&DSP_CAP_DIGITALOUT);
    eval 'sub DSP_CAP_DIGITALIN () { &PCM_CAP_DIGITALIN;}' unless defined(&DSP_CAP_DIGITALIN);
    eval 'sub DSP_CAP_ADMASK () { &PCM_CAP_ADMASK;}' unless defined(&DSP_CAP_ADMASK);
    eval 'sub DSP_CAP_FREERATE () { &PCM_CAP_FREERATE;}' unless defined(&DSP_CAP_FREERATE);
    eval 'sub DSP_CAP_MULTI () { &PCM_CAP_MULTI;}' unless defined(&DSP_CAP_MULTI);
    eval 'sub DSP_CAP_BIND () { &PCM_CAP_BIND;}' unless defined(&DSP_CAP_BIND);
    eval 'sub DSP_CAP_SHADOW () { &PCM_CAP_SHADOW;}' unless defined(&DSP_CAP_SHADOW);
    eval 'sub PCM_CAP_REVISION () {0xff;}' unless defined(&PCM_CAP_REVISION);
    eval 'sub PCM_CAP_DUPLEX () {0x100;}' unless defined(&PCM_CAP_DUPLEX);
    eval 'sub PCM_CAP_REALTIME () {0x200;}' unless defined(&PCM_CAP_REALTIME);
    eval 'sub PCM_CAP_BATCH () {0x400;}' unless defined(&PCM_CAP_BATCH);
    eval 'sub PCM_CAP_COPROC () {0x800;}' unless defined(&PCM_CAP_COPROC);
    eval 'sub PCM_CAP_TRIGGER () {0x1000;}' unless defined(&PCM_CAP_TRIGGER);
    eval 'sub PCM_CAP_MMAP () {0x2000;}' unless defined(&PCM_CAP_MMAP);
    eval 'sub PCM_CAP_INPUT () {0x4000;}' unless defined(&PCM_CAP_INPUT);
    eval 'sub PCM_CAP_OUTPUT () {0x8000;}' unless defined(&PCM_CAP_OUTPUT);
    eval 'sub PCM_CAP_MODEM () {0x10000;}' unless defined(&PCM_CAP_MODEM);
    eval 'sub PCM_CAP_HIDDEN () {0x20000;}' unless defined(&PCM_CAP_HIDDEN);
    eval 'sub PCM_CAP_VIRTUAL () {0x40000;}' unless defined(&PCM_CAP_VIRTUAL);
    eval 'sub PCM_CAP_MULTI () {0x80000;}' unless defined(&PCM_CAP_MULTI);
    eval 'sub PCM_CAP_ANALOGOUT () {0x100000;}' unless defined(&PCM_CAP_ANALOGOUT);
    eval 'sub PCM_CAP_ANALOGIN () {0x200000;}' unless defined(&PCM_CAP_ANALOGIN);
    eval 'sub PCM_CAP_DIGITALOUT () {0x400000;}' unless defined(&PCM_CAP_DIGITALOUT);
    eval 'sub PCM_CAP_DIGITALIN () {0x800000;}' unless defined(&PCM_CAP_DIGITALIN);
    eval 'sub PCM_CAP_ADMASK () {0xf00000;}' unless defined(&PCM_CAP_ADMASK);
    eval 'sub PCM_CAP_SPECIAL () {0x1000000;}' unless defined(&PCM_CAP_SPECIAL);
    eval 'sub PCM_CAP_FREERATE () {0x10000000;}' unless defined(&PCM_CAP_FREERATE);
    eval 'sub PCM_CAP_SHADOW () {0x40000000;}' unless defined(&PCM_CAP_SHADOW);
    eval 'sub PCM_CAP_BIND () {0x80000000;}' unless defined(&PCM_CAP_BIND);
    eval 'sub DSP_CH_ANY () {0x;}' unless defined(&DSP_CH_ANY);
    eval 'sub DSP_CH_MONO () {0x2000000;}' unless defined(&DSP_CH_MONO);
    eval 'sub DSP_CH_STEREO () {0x4000000;}' unless defined(&DSP_CH_STEREO);
    eval 'sub DSP_CH_MULTI () {0x6000000;}' unless defined(&DSP_CH_MULTI);
    eval 'sub DSP_CH_MASK () {0x6000000;}' unless defined(&DSP_CH_MASK);
    eval 'sub SNDCTL_DSP_GETTRIGGER () { &_IOR (ord(\'P\'), 16, \'int\');}' unless defined(&SNDCTL_DSP_GETTRIGGER);
    eval 'sub SNDCTL_DSP_SETTRIGGER () { &_IOW (ord(\'P\'), 16, \'int\');}' unless defined(&SNDCTL_DSP_SETTRIGGER);
    eval 'sub PCM_ENABLE_INPUT () {0x1;}' unless defined(&PCM_ENABLE_INPUT);
    eval 'sub PCM_ENABLE_OUTPUT () {0x2;}' unless defined(&PCM_ENABLE_OUTPUT);
    eval 'sub SNDCTL_DSP_GETIPTR () { &_IOR (ord(\'P\'), 17, \'struct count_info\');}' unless defined(&SNDCTL_DSP_GETIPTR);
    eval 'sub SNDCTL_DSP_GETOPTR () { &_IOR (ord(\'P\'), 18, \'struct count_info\');}' unless defined(&SNDCTL_DSP_GETOPTR);
    eval 'sub SNDCTL_DSP_MAPINBUF () { &_IOR (ord(\'P\'), 19, \'struct buffmem_desc\');}' unless defined(&SNDCTL_DSP_MAPINBUF);
    eval 'sub SNDCTL_DSP_MAPOUTBUF () { &_IOR (ord(\'P\'), 20, \'struct buffmem_desc\');}' unless defined(&SNDCTL_DSP_MAPOUTBUF);
    eval 'sub SNDCTL_DSP_SETSYNCRO () { &_IO (ord(\'P\'), 21);}' unless defined(&SNDCTL_DSP_SETSYNCRO);
    eval 'sub SNDCTL_DSP_SETDUPLEX () { &_IO (ord(\'P\'), 22);}' unless defined(&SNDCTL_DSP_SETDUPLEX);
    eval 'sub SNDCTL_DSP_PROFILE () { &_IOW (ord(\'P\'), 23, \'int\');}' unless defined(&SNDCTL_DSP_PROFILE);
    eval 'sub SNDCTL_DSP_GETODELAY () { &_IOR (ord(\'P\'), 23, \'int\');}' unless defined(&SNDCTL_DSP_GETODELAY);
    eval 'sub APF_NORMAL () {0;}' unless defined(&APF_NORMAL);
    eval 'sub APF_NETWORK () {1;}' unless defined(&APF_NETWORK);
    eval 'sub APF_CPUINTENS () {2;}' unless defined(&APF_CPUINTENS);
    require 'machine/endian_machdep.ph';
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub AFMT_U16_NE () { &AFMT_U16_LE;}' unless defined(&AFMT_U16_NE);
	eval 'sub AFMT_U16_OE () { &AFMT_U16_BE;}' unless defined(&AFMT_U16_OE);
	eval 'sub AFMT_S16_NE () { &AFMT_S16_LE;}' unless defined(&AFMT_S16_NE);
	eval 'sub AFMT_S16_OE () { &AFMT_S16_BE;}' unless defined(&AFMT_S16_OE);
	eval 'sub AFMT_S24_NE () { &AFMT_S24_LE;}' unless defined(&AFMT_S24_NE);
	eval 'sub AFMT_S24_OE () { &AFMT_S24_BE;}' unless defined(&AFMT_S24_OE);
	eval 'sub AFMT_S32_NE () { &AFMT_S32_LE;}' unless defined(&AFMT_S32_NE);
	eval 'sub AFMT_S32_OE () { &AFMT_S32_BE;}' unless defined(&AFMT_S32_OE);
    } else {
	eval 'sub AFMT_U16_NE () { &AFMT_U16_BE;}' unless defined(&AFMT_U16_NE);
	eval 'sub AFMT_U16_OE () { &AFMT_U16_LE;}' unless defined(&AFMT_U16_OE);
	eval 'sub AFMT_S16_NE () { &AFMT_S16_BE;}' unless defined(&AFMT_S16_NE);
	eval 'sub AFMT_S16_OE () { &AFMT_S16_LE;}' unless defined(&AFMT_S16_OE);
	eval 'sub AFMT_S24_NE () { &AFMT_S24_BE;}' unless defined(&AFMT_S24_NE);
	eval 'sub AFMT_S24_OE () { &AFMT_S24_LE;}' unless defined(&AFMT_S24_OE);
	eval 'sub AFMT_S32_NE () { &AFMT_S32_BE;}' unless defined(&AFMT_S32_NE);
	eval 'sub AFMT_S32_OE () { &AFMT_S32_LE;}' unless defined(&AFMT_S32_OE);
    }
    eval 'sub SOUND_PCM_WRITE_BITS () { &SNDCTL_DSP_SETFMT;}' unless defined(&SOUND_PCM_WRITE_BITS);
    eval 'sub SOUND_PCM_WRITE_RATE () { &SNDCTL_DSP_SPEED;}' unless defined(&SOUND_PCM_WRITE_RATE);
    eval 'sub SOUND_PCM_POST () { &SNDCTL_DSP_POST;}' unless defined(&SOUND_PCM_POST);
    eval 'sub SOUND_PCM_RESET () { &SNDCTL_DSP_RESET;}' unless defined(&SOUND_PCM_RESET);
    eval 'sub SOUND_PCM_SYNC () { &SNDCTL_DSP_SYNC;}' unless defined(&SOUND_PCM_SYNC);
    eval 'sub SOUND_PCM_SUBDIVIDE () { &SNDCTL_DSP_SUBDIVIDE;}' unless defined(&SOUND_PCM_SUBDIVIDE);
    eval 'sub SOUND_PCM_SETFRAGMENT () { &SNDCTL_DSP_SETFRAGMENT;}' unless defined(&SOUND_PCM_SETFRAGMENT);
    eval 'sub SOUND_PCM_GETFMTS () { &SNDCTL_DSP_GETFMTS;}' unless defined(&SOUND_PCM_GETFMTS);
    eval 'sub SOUND_PCM_SETFMT () { &SNDCTL_DSP_SETFMT;}' unless defined(&SOUND_PCM_SETFMT);
    eval 'sub SOUND_PCM_GETOSPACE () { &SNDCTL_DSP_GETOSPACE;}' unless defined(&SOUND_PCM_GETOSPACE);
    eval 'sub SOUND_PCM_GETISPACE () { &SNDCTL_DSP_GETISPACE;}' unless defined(&SOUND_PCM_GETISPACE);
    eval 'sub SOUND_PCM_NONBLOCK () { &SNDCTL_DSP_NONBLOCK;}' unless defined(&SOUND_PCM_NONBLOCK);
    eval 'sub SOUND_PCM_GETCAPS () { &SNDCTL_DSP_GETCAPS;}' unless defined(&SOUND_PCM_GETCAPS);
    eval 'sub SOUND_PCM_GETTRIGGER () { &SNDCTL_DSP_GETTRIGGER;}' unless defined(&SOUND_PCM_GETTRIGGER);
    eval 'sub SOUND_PCM_SETTRIGGER () { &SNDCTL_DSP_SETTRIGGER;}' unless defined(&SOUND_PCM_SETTRIGGER);
    eval 'sub SOUND_PCM_SETSYNCRO () { &SNDCTL_DSP_SETSYNCRO;}' unless defined(&SOUND_PCM_SETSYNCRO);
    eval 'sub SOUND_PCM_GETIPTR () { &SNDCTL_DSP_GETIPTR;}' unless defined(&SOUND_PCM_GETIPTR);
    eval 'sub SOUND_PCM_GETOPTR () { &SNDCTL_DSP_GETOPTR;}' unless defined(&SOUND_PCM_GETOPTR);
    eval 'sub SOUND_PCM_MAPINBUF () { &SNDCTL_DSP_MAPINBUF;}' unless defined(&SOUND_PCM_MAPINBUF);
    eval 'sub SOUND_PCM_MAPOUTBUF () { &SNDCTL_DSP_MAPOUTBUF;}' unless defined(&SOUND_PCM_MAPOUTBUF);
    eval 'sub SOUND_MIXER_FIRST () {0;}' unless defined(&SOUND_MIXER_FIRST);
    eval 'sub SOUND_MIXER_NRDEVICES () {25;}' unless defined(&SOUND_MIXER_NRDEVICES);
    eval 'sub SOUND_MIXER_VOLUME () {0;}' unless defined(&SOUND_MIXER_VOLUME);
    eval 'sub SOUND_MIXER_BASS () {1;}' unless defined(&SOUND_MIXER_BASS);
    eval 'sub SOUND_MIXER_TREBLE () {2;}' unless defined(&SOUND_MIXER_TREBLE);
    eval 'sub SOUND_MIXER_SYNTH () {3;}' unless defined(&SOUND_MIXER_SYNTH);
    eval 'sub SOUND_MIXER_PCM () {4;}' unless defined(&SOUND_MIXER_PCM);
    eval 'sub SOUND_MIXER_SPEAKER () {5;}' unless defined(&SOUND_MIXER_SPEAKER);
    eval 'sub SOUND_MIXER_LINE () {6;}' unless defined(&SOUND_MIXER_LINE);
    eval 'sub SOUND_MIXER_MIC () {7;}' unless defined(&SOUND_MIXER_MIC);
    eval 'sub SOUND_MIXER_CD () {8;}' unless defined(&SOUND_MIXER_CD);
    eval 'sub SOUND_MIXER_IMIX () {9;}' unless defined(&SOUND_MIXER_IMIX);
    eval 'sub SOUND_MIXER_ALTPCM () {10;}' unless defined(&SOUND_MIXER_ALTPCM);
    eval 'sub SOUND_MIXER_RECLEV () {11;}' unless defined(&SOUND_MIXER_RECLEV);
    eval 'sub SOUND_MIXER_IGAIN () {12;}' unless defined(&SOUND_MIXER_IGAIN);
    eval 'sub SOUND_MIXER_OGAIN () {13;}' unless defined(&SOUND_MIXER_OGAIN);
    eval 'sub SOUND_MIXER_LINE1 () {14;}' unless defined(&SOUND_MIXER_LINE1);
    eval 'sub SOUND_MIXER_LINE2 () {15;}' unless defined(&SOUND_MIXER_LINE2);
    eval 'sub SOUND_MIXER_LINE3 () {16;}' unless defined(&SOUND_MIXER_LINE3);
    eval 'sub SOUND_MIXER_DIGITAL1 () {17;}' unless defined(&SOUND_MIXER_DIGITAL1);
    eval 'sub SOUND_MIXER_DIGITAL2 () {18;}' unless defined(&SOUND_MIXER_DIGITAL2);
    eval 'sub SOUND_MIXER_DIGITAL3 () {19;}' unless defined(&SOUND_MIXER_DIGITAL3);
    eval 'sub SOUND_MIXER_PHONEIN () {20;}' unless defined(&SOUND_MIXER_PHONEIN);
    eval 'sub SOUND_MIXER_PHONEOUT () {21;}' unless defined(&SOUND_MIXER_PHONEOUT);
    eval 'sub SOUND_MIXER_VIDEO () {22;}' unless defined(&SOUND_MIXER_VIDEO);
    eval 'sub SOUND_MIXER_RADIO () {23;}' unless defined(&SOUND_MIXER_RADIO);
    eval 'sub SOUND_MIXER_MONITOR () {24;}' unless defined(&SOUND_MIXER_MONITOR);
    eval 'sub SOUND_ONOFF_MIN () {28;}' unless defined(&SOUND_ONOFF_MIN);
    eval 'sub SOUND_ONOFF_MAX () {30;}' unless defined(&SOUND_ONOFF_MAX);
    eval 'sub SOUND_MIXER_NONE () {31;}' unless defined(&SOUND_MIXER_NONE);
    eval 'sub SOUND_DEVICE_LABELS () {{"Vol  ", "Bass ", "Trebl", "Synth", "Pcm  ", "Spkr ", "Line ", "Mic  ", "CD   ", "Mix  ", "Pcm2 ", "Rec  ", "IGain", "OGain", "Line1", "Line2", "Line3", "Digital1", "Digital2", "Digital3", "PhoneIn", "PhoneOut", "Video", "Radio", "Monitor"};}' unless defined(&SOUND_DEVICE_LABELS);
    eval 'sub SOUND_DEVICE_NAMES () {{"vol", "bass", "treble", "synth", "pcm", "speaker", "line", "mic", "cd", "mix", "pcm2", "rec", "igain", "ogain", "line1", "line2", "line3", "dig1", "dig2", "dig3", "phin", "phout", "video", "radio", "monitor"};}' unless defined(&SOUND_DEVICE_NAMES);
    eval 'sub SOUND_MIXER_RECSRC () {0xff;}' unless defined(&SOUND_MIXER_RECSRC);
    eval 'sub SOUND_MIXER_DEVMASK () {0xfe;}' unless defined(&SOUND_MIXER_DEVMASK);
    eval 'sub SOUND_MIXER_RECMASK () {0xfd;}' unless defined(&SOUND_MIXER_RECMASK);
    eval 'sub SOUND_MIXER_CAPS () {0xfc;}' unless defined(&SOUND_MIXER_CAPS);
    eval 'sub SOUND_CAP_EXCL_INPUT () {1;}' unless defined(&SOUND_CAP_EXCL_INPUT);
    eval 'sub SOUND_MIXER_STEREODEVS () {0xfb;}' unless defined(&SOUND_MIXER_STEREODEVS);
    eval 'sub MIXER_READ {
        my($dev) = @_;
	    eval q( &_IOR(ord(\'M\'), $dev, \'int\'));
    }' unless defined(&MIXER_READ);
    eval 'sub SOUND_MIXER_READ_RECSRC () { &MIXER_READ( &SOUND_MIXER_RECSRC);}' unless defined(&SOUND_MIXER_READ_RECSRC);
    eval 'sub SOUND_MIXER_READ_DEVMASK () { &MIXER_READ( &SOUND_MIXER_DEVMASK);}' unless defined(&SOUND_MIXER_READ_DEVMASK);
    eval 'sub SOUND_MIXER_READ_RECMASK () { &MIXER_READ( &SOUND_MIXER_RECMASK);}' unless defined(&SOUND_MIXER_READ_RECMASK);
    eval 'sub SOUND_MIXER_READ_STEREODEVS () { &MIXER_READ( &SOUND_MIXER_STEREODEVS);}' unless defined(&SOUND_MIXER_READ_STEREODEVS);
    eval 'sub SOUND_MIXER_READ_CAPS () { &MIXER_READ( &SOUND_MIXER_CAPS);}' unless defined(&SOUND_MIXER_READ_CAPS);
    eval 'sub SOUND_MIXER_READ_VOLUME () { &MIXER_READ( &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MIXER_READ_VOLUME);
    eval 'sub SOUND_MIXER_READ_BASS () { &MIXER_READ( &SOUND_MIXER_BASS);}' unless defined(&SOUND_MIXER_READ_BASS);
    eval 'sub SOUND_MIXER_READ_TREBLE () { &MIXER_READ( &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MIXER_READ_TREBLE);
    eval 'sub SOUND_MIXER_READ_SYNTH () { &MIXER_READ( &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MIXER_READ_SYNTH);
    eval 'sub SOUND_MIXER_READ_PCM () { &MIXER_READ( &SOUND_MIXER_PCM);}' unless defined(&SOUND_MIXER_READ_PCM);
    eval 'sub SOUND_MIXER_READ_SPEAKER () { &MIXER_READ( &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MIXER_READ_SPEAKER);
    eval 'sub SOUND_MIXER_READ_LINE () { &MIXER_READ( &SOUND_MIXER_LINE);}' unless defined(&SOUND_MIXER_READ_LINE);
    eval 'sub SOUND_MIXER_READ_MIC () { &MIXER_READ( &SOUND_MIXER_MIC);}' unless defined(&SOUND_MIXER_READ_MIC);
    eval 'sub SOUND_MIXER_READ_CD () { &MIXER_READ( &SOUND_MIXER_CD);}' unless defined(&SOUND_MIXER_READ_CD);
    eval 'sub SOUND_MIXER_READ_IMIX () { &MIXER_READ( &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MIXER_READ_IMIX);
    eval 'sub SOUND_MIXER_READ_ALTPCM () { &MIXER_READ( &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MIXER_READ_ALTPCM);
    eval 'sub SOUND_MIXER_READ_RECLEV () { &MIXER_READ( &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MIXER_READ_RECLEV);
    eval 'sub SOUND_MIXER_READ_IGAIN () { &MIXER_READ( &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MIXER_READ_IGAIN);
    eval 'sub SOUND_MIXER_READ_OGAIN () { &MIXER_READ( &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MIXER_READ_OGAIN);
    eval 'sub SOUND_MIXER_READ_LINE1 () { &MIXER_READ( &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MIXER_READ_LINE1);
    eval 'sub SOUND_MIXER_READ_LINE2 () { &MIXER_READ( &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MIXER_READ_LINE2);
    eval 'sub SOUND_MIXER_READ_LINE3 () { &MIXER_READ( &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MIXER_READ_LINE3);
    eval 'sub MIXER_WRITE {
        my($dev) = @_;
	    eval q( &_IOW (ord(\'M\'), $dev, \'int\'));
    }' unless defined(&MIXER_WRITE);
    eval 'sub MIXER_WRITE_R {
        my($dev) = @_;
	    eval q( &_IOWR(ord(\'M\'), $dev, \'int\'));
    }' unless defined(&MIXER_WRITE_R);
    eval 'sub SOUND_MIXER_WRITE_RECSRC () { &MIXER_WRITE( &SOUND_MIXER_RECSRC);}' unless defined(&SOUND_MIXER_WRITE_RECSRC);
    eval 'sub SOUND_MIXER_WRITE_R_RECSRC () { &MIXER_WRITE_R( &SOUND_MIXER_RECSRC);}' unless defined(&SOUND_MIXER_WRITE_R_RECSRC);
    eval 'sub SOUND_MIXER_WRITE_VOLUME () { &MIXER_WRITE( &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MIXER_WRITE_VOLUME);
    eval 'sub SOUND_MIXER_WRITE_BASS () { &MIXER_WRITE( &SOUND_MIXER_BASS);}' unless defined(&SOUND_MIXER_WRITE_BASS);
    eval 'sub SOUND_MIXER_WRITE_TREBLE () { &MIXER_WRITE( &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MIXER_WRITE_TREBLE);
    eval 'sub SOUND_MIXER_WRITE_SYNTH () { &MIXER_WRITE( &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MIXER_WRITE_SYNTH);
    eval 'sub SOUND_MIXER_WRITE_PCM () { &MIXER_WRITE( &SOUND_MIXER_PCM);}' unless defined(&SOUND_MIXER_WRITE_PCM);
    eval 'sub SOUND_MIXER_WRITE_SPEAKER () { &MIXER_WRITE( &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MIXER_WRITE_SPEAKER);
    eval 'sub SOUND_MIXER_WRITE_LINE () { &MIXER_WRITE( &SOUND_MIXER_LINE);}' unless defined(&SOUND_MIXER_WRITE_LINE);
    eval 'sub SOUND_MIXER_WRITE_MIC () { &MIXER_WRITE( &SOUND_MIXER_MIC);}' unless defined(&SOUND_MIXER_WRITE_MIC);
    eval 'sub SOUND_MIXER_WRITE_CD () { &MIXER_WRITE( &SOUND_MIXER_CD);}' unless defined(&SOUND_MIXER_WRITE_CD);
    eval 'sub SOUND_MIXER_WRITE_IMIX () { &MIXER_WRITE( &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MIXER_WRITE_IMIX);
    eval 'sub SOUND_MIXER_WRITE_ALTPCM () { &MIXER_WRITE( &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MIXER_WRITE_ALTPCM);
    eval 'sub SOUND_MIXER_WRITE_RECLEV () { &MIXER_WRITE( &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MIXER_WRITE_RECLEV);
    eval 'sub SOUND_MIXER_WRITE_IGAIN () { &MIXER_WRITE( &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MIXER_WRITE_IGAIN);
    eval 'sub SOUND_MIXER_WRITE_OGAIN () { &MIXER_WRITE( &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MIXER_WRITE_OGAIN);
    eval 'sub SOUND_MIXER_WRITE_LINE1 () { &MIXER_WRITE( &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MIXER_WRITE_LINE1);
    eval 'sub SOUND_MIXER_WRITE_LINE2 () { &MIXER_WRITE( &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MIXER_WRITE_LINE2);
    eval 'sub SOUND_MIXER_WRITE_LINE3 () { &MIXER_WRITE( &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MIXER_WRITE_LINE3);
    eval 'sub SOUND_MASK_VOLUME () {(1<<  &SOUND_MIXER_VOLUME);}' unless defined(&SOUND_MASK_VOLUME);
    eval 'sub SOUND_MASK_BASS () {(1<<  &SOUND_MIXER_BASS);}' unless defined(&SOUND_MASK_BASS);
    eval 'sub SOUND_MASK_TREBLE () {(1<<  &SOUND_MIXER_TREBLE);}' unless defined(&SOUND_MASK_TREBLE);
    eval 'sub SOUND_MASK_SYNTH () {(1<<  &SOUND_MIXER_SYNTH);}' unless defined(&SOUND_MASK_SYNTH);
    eval 'sub SOUND_MASK_PCM () {(1<<  &SOUND_MIXER_PCM);}' unless defined(&SOUND_MASK_PCM);
    eval 'sub SOUND_MASK_SPEAKER () {(1<<  &SOUND_MIXER_SPEAKER);}' unless defined(&SOUND_MASK_SPEAKER);
    eval 'sub SOUND_MASK_LINE () {(1<<  &SOUND_MIXER_LINE);}' unless defined(&SOUND_MASK_LINE);
    eval 'sub SOUND_MASK_MIC () {(1<<  &SOUND_MIXER_MIC);}' unless defined(&SOUND_MASK_MIC);
    eval 'sub SOUND_MASK_CD () {(1<<  &SOUND_MIXER_CD);}' unless defined(&SOUND_MASK_CD);
    eval 'sub SOUND_MASK_IMIX () {(1<<  &SOUND_MIXER_IMIX);}' unless defined(&SOUND_MASK_IMIX);
    eval 'sub SOUND_MASK_ALTPCM () {(1<<  &SOUND_MIXER_ALTPCM);}' unless defined(&SOUND_MASK_ALTPCM);
    eval 'sub SOUND_MASK_RECLEV () {(1<<  &SOUND_MIXER_RECLEV);}' unless defined(&SOUND_MASK_RECLEV);
    eval 'sub SOUND_MASK_IGAIN () {(1<<  &SOUND_MIXER_IGAIN);}' unless defined(&SOUND_MASK_IGAIN);
    eval 'sub SOUND_MASK_OGAIN () {(1<<  &SOUND_MIXER_OGAIN);}' unless defined(&SOUND_MASK_OGAIN);
    eval 'sub SOUND_MASK_LINE1 () {(1<<  &SOUND_MIXER_LINE1);}' unless defined(&SOUND_MASK_LINE1);
    eval 'sub SOUND_MASK_LINE2 () {(1<<  &SOUND_MIXER_LINE2);}' unless defined(&SOUND_MASK_LINE2);
    eval 'sub SOUND_MASK_LINE3 () {(1<<  &SOUND_MIXER_LINE3);}' unless defined(&SOUND_MASK_LINE3);
    eval 'sub SOUND_MASK_DIGITAL1 () {(1<<  &SOUND_MIXER_DIGITAL1);}' unless defined(&SOUND_MASK_DIGITAL1);
    eval 'sub SOUND_MASK_DIGITAL2 () {(1<<  &SOUND_MIXER_DIGITAL2);}' unless defined(&SOUND_MASK_DIGITAL2);
    eval 'sub SOUND_MASK_DIGITAL3 () {(1<<  &SOUND_MIXER_DIGITAL3);}' unless defined(&SOUND_MASK_DIGITAL3);
    eval 'sub SOUND_MASK_PHONEIN () {(1<<  &SOUND_MIXER_PHONEIN);}' unless defined(&SOUND_MASK_PHONEIN);
    eval 'sub SOUND_MASK_PHONEOUT () {(1<<  &SOUND_MIXER_PHONEOUT);}' unless defined(&SOUND_MASK_PHONEOUT);
    eval 'sub SOUND_MASK_VIDEO () {(1<<  &SOUND_MIXER_VIDEO);}' unless defined(&SOUND_MASK_VIDEO);
    eval 'sub SOUND_MASK_RADIO () {(1<<  &SOUND_MIXER_RADIO);}' unless defined(&SOUND_MASK_RADIO);
    eval 'sub SOUND_MASK_MONITOR () {(1<<  &SOUND_MIXER_MONITOR);}' unless defined(&SOUND_MASK_MONITOR);
    eval 'sub SOUND_MIXER_INFO () { &_IOR(ord(\'M\'), 101,  &mixer_info);}' unless defined(&SOUND_MIXER_INFO);
    eval 'sub SOUND_OLD_MIXER_INFO () { &_IOR(ord(\'M\'), 101,  &_old_mixer_info);}' unless defined(&SOUND_OLD_MIXER_INFO);
    eval 'sub OSS_GETVERSION () { &_IOR (ord(\'M\'), 118, \'int\');}' unless defined(&OSS_GETVERSION);
    eval 'sub OSS_OPEN_READ () { &PCM_ENABLE_INPUT;}' unless defined(&OSS_OPEN_READ);
    eval 'sub OSS_OPEN_WRITE () { &PCM_ENABLE_OUTPUT;}' unless defined(&OSS_OPEN_WRITE);
    eval 'sub OSS_OPEN_READWRITE () {( &OSS_OPEN_READ| &OSS_OPEN_WRITE);}' unless defined(&OSS_OPEN_READWRITE);
    eval 'sub OSS_DEVNODE_SIZE () {32;}' unless defined(&OSS_DEVNODE_SIZE);
    eval 'sub OSS_LABEL_SIZE () {16;}' unless defined(&OSS_LABEL_SIZE);
    eval 'sub OSS_LONGNAME_SIZE () {64;}' unless defined(&OSS_LONGNAME_SIZE);
    eval 'sub OSS_MAX_AUDIO_DEVS () {64;}' unless defined(&OSS_MAX_AUDIO_DEVS);
    eval 'sub SNDCTL_DSP_GETPLAYVOL () { &_IOR (ord(\'P\'),27, \'uint\');}' unless defined(&SNDCTL_DSP_GETPLAYVOL);
    eval 'sub SNDCTL_DSP_SETPLAYVOL () { &_IOW (ord(\'P\'),28, \'uint\');}' unless defined(&SNDCTL_DSP_SETPLAYVOL);
    eval 'sub SNDCTL_DSP_GETRECVOL () { &_IOR (ord(\'P\'),29, \'uint\');}' unless defined(&SNDCTL_DSP_GETRECVOL);
    eval 'sub SNDCTL_DSP_SETRECVOL () { &_IOW (ord(\'P\'),30, \'uint\');}' unless defined(&SNDCTL_DSP_SETRECVOL);
    eval 'sub SNDCTL_DSP_SKIP () { &_IO (ord(\'P\'),31);}' unless defined(&SNDCTL_DSP_SKIP);
    eval 'sub SNDCTL_DSP_SILENCE () { &_IO (ord(\'P\'),32);}' unless defined(&SNDCTL_DSP_SILENCE);
    eval 'sub SNDCTL_DSP_COOKEDMODE () { &_IOW (ord(\'P\'),33, \'int\');}' unless defined(&SNDCTL_DSP_COOKEDMODE);
    eval 'sub SNDCTL_DSP_GETERROR () { &_IOR (ord(\'P\'),34, \'struct audio_errinfo\');}' unless defined(&SNDCTL_DSP_GETERROR);
    eval 'sub SNDCTL_DSP_CURRENT_IPTR () { &_IOR (ord(\'P\'),35,  &oss_count_t);}' unless defined(&SNDCTL_DSP_CURRENT_IPTR);
    eval 'sub SNDCTL_DSP_CURRENT_OPTR () { &_IOR (ord(\'P\'),36,  &oss_count_t);}' unless defined(&SNDCTL_DSP_CURRENT_OPTR);
    eval 'sub SNDCTL_DSP_GET_RECSRC_NAMES () { &_IOR (ord(\'P\'),37,  &oss_mixer_enuminfo);}' unless defined(&SNDCTL_DSP_GET_RECSRC_NAMES);
    eval 'sub SNDCTL_DSP_GET_RECSRC () { &_IOR (ord(\'P\'),38, \'int\');}' unless defined(&SNDCTL_DSP_GET_RECSRC);
    eval 'sub SNDCTL_DSP_SET_RECSRC () { &_IOWR (ord(\'P\'),38, \'int\');}' unless defined(&SNDCTL_DSP_SET_RECSRC);
    eval 'sub SNDCTL_DSP_GET_PLAYTGT_NAMES () { &_IOR (ord(\'P\'),39,  &oss_mixer_enuminfo);}' unless defined(&SNDCTL_DSP_GET_PLAYTGT_NAMES);
    eval 'sub SNDCTL_DSP_GET_PLAYTGT () { &_IOR (ord(\'P\'),40, \'int\');}' unless defined(&SNDCTL_DSP_GET_PLAYTGT);
    eval 'sub SNDCTL_DSP_SET_PLAYTGT () { &_IOWR (ord(\'P\'),40, \'int\');}' unless defined(&SNDCTL_DSP_SET_PLAYTGT);
    eval 'sub SNDCTL_DSP_GET_CHNORDER () { &_IOR (ord(\'P\'),42, \'unsigned long long\');}' unless defined(&SNDCTL_DSP_GET_CHNORDER);
    eval 'sub SNDCTL_DSP_SET_CHNORDER () { &_IOWR (ord(\'P\'),42, \'unsigned long long\');}' unless defined(&SNDCTL_DSP_SET_CHNORDER);
    eval 'sub SNDCTL_DSP_HALT_OUTPUT () { &_IO (ord(\'P\'),70);}' unless defined(&SNDCTL_DSP_HALT_OUTPUT);
    eval 'sub SNDCTL_DSP_RESET_OUTPUT () { &SNDCTL_DSP_HALT_OUTPUT;}' unless defined(&SNDCTL_DSP_RESET_OUTPUT);
    eval 'sub SNDCTL_DSP_HALT_INPUT () { &_IO (ord(\'P\'),71);}' unless defined(&SNDCTL_DSP_HALT_INPUT);
    eval 'sub SNDCTL_DSP_RESET_INPUT () { &SNDCTL_DSP_HALT_INPUT;}' unless defined(&SNDCTL_DSP_RESET_INPUT);
    eval 'sub CHID_UNDEF () {0;}' unless defined(&CHID_UNDEF);
    eval 'sub CHID_L () {1;}' unless defined(&CHID_L);
    eval 'sub CHID_R () {2;}' unless defined(&CHID_R);
    eval 'sub CHID_C () {3;}' unless defined(&CHID_C);
    eval 'sub CHID_LFE () {4;}' unless defined(&CHID_LFE);
    eval 'sub CHID_LS () {5;}' unless defined(&CHID_LS);
    eval 'sub CHID_RS () {6;}' unless defined(&CHID_RS);
    eval 'sub CHID_LR () {7;}' unless defined(&CHID_LR);
    eval 'sub CHID_RR () {8;}' unless defined(&CHID_RR);
    eval 'sub CHNORDER_UNDEF () {0x;}' unless defined(&CHNORDER_UNDEF);
    eval 'sub CHNORDER_NORMAL () {0x87654321;}' unless defined(&CHNORDER_NORMAL);
    eval 'sub OSS_MAX_SAMPLE_RATES () {20;}' unless defined(&OSS_MAX_SAMPLE_RATES);
    eval 'sub SNDCTL_SYSINFO () { &_IOR (ord(\'X\'), 1,  &oss_sysinfo);}' unless defined(&SNDCTL_SYSINFO);
    eval 'sub OSS_SYSINFO () { &SNDCTL_SYSINFO;}' unless defined(&OSS_SYSINFO);
    eval 'sub SNDCTL_MIX_NRMIX () { &_IOR (ord(\'X\'),2, \'int\');}' unless defined(&SNDCTL_MIX_NRMIX);
    eval 'sub SNDCTL_MIX_NREXT () { &_IOWR (ord(\'X\'),3, \'int\');}' unless defined(&SNDCTL_MIX_NREXT);
    eval 'sub SNDCTL_MIX_EXTINFO () { &_IOWR (ord(\'X\'),4,  &oss_mixext);}' unless defined(&SNDCTL_MIX_EXTINFO);
    eval 'sub SNDCTL_MIX_READ () { &_IOWR (ord(\'X\'),5,  &oss_mixer_value);}' unless defined(&SNDCTL_MIX_READ);
    eval 'sub SNDCTL_MIX_WRITE () { &_IOWR (ord(\'X\'),6,  &oss_mixer_value);}' unless defined(&SNDCTL_MIX_WRITE);
    eval 'sub SNDCTL_AUDIOINFO () { &_IOWR (ord(\'X\'),7,  &oss_audioinfo);}' unless defined(&SNDCTL_AUDIOINFO);
    eval 'sub SNDCTL_MIX_ENUMINFO () { &_IOWR (ord(\'X\'),8,  &oss_mixer_enuminfo);}' unless defined(&SNDCTL_MIX_ENUMINFO);
    eval 'sub SNDCTL_MIXERINFO () { &_IOWR (ord(\'X\'),10,  &oss_mixerinfo);}' unless defined(&SNDCTL_MIXERINFO);
    eval 'sub SNDCTL_CARDINFO () { &_IOWR (ord(\'X\'),11,  &oss_card_info);}' unless defined(&SNDCTL_CARDINFO);
    eval 'sub SNDCTL_ENGINEINFO () { &_IOWR (ord(\'X\'),12,  &oss_audioinfo);}' unless defined(&SNDCTL_ENGINEINFO);
    eval 'sub SNDCTL_AUDIOINFO_EX () { &_IOWR (ord(\'X\'),13,  &oss_audioinfo);}' unless defined(&SNDCTL_AUDIOINFO_EX);
    eval 'sub SNDCTL_MIX_DESCRIPTION () { &_IOWR (ord(\'X\'),14,  &oss_mixer_enuminfo);}' unless defined(&SNDCTL_MIX_DESCRIPTION);
    eval 'sub MIXT_DEVROOT () {0;}' unless defined(&MIXT_DEVROOT);
    eval 'sub MIXT_GROUP () {1;}' unless defined(&MIXT_GROUP);
    eval 'sub MIXT_ONOFF () {2;}' unless defined(&MIXT_ONOFF);
    eval 'sub MIXT_ENUM () {3;}' unless defined(&MIXT_ENUM);
    eval 'sub MIXT_MONOSLIDER () {4;}' unless defined(&MIXT_MONOSLIDER);
    eval 'sub MIXT_STEREOSLIDER () {5;}' unless defined(&MIXT_STEREOSLIDER);
    eval 'sub MIXT_MESSAGE () {6;}' unless defined(&MIXT_MESSAGE);
    eval 'sub MIXT_MONOVU () {7;}' unless defined(&MIXT_MONOVU);
    eval 'sub MIXT_STEREOVU () {8;}' unless defined(&MIXT_STEREOVU);
    eval 'sub MIXT_MONOPEAK () {9;}' unless defined(&MIXT_MONOPEAK);
    eval 'sub MIXT_STEREOPEAK () {10;}' unless defined(&MIXT_STEREOPEAK);
    eval 'sub MIXT_RADIOGROUP () {11;}' unless defined(&MIXT_RADIOGROUP);
    eval 'sub MIXT_MARKER () {12;}' unless defined(&MIXT_MARKER);
    eval 'sub MIXT_VALUE () {13;}' unless defined(&MIXT_VALUE);
    eval 'sub MIXT_HEXVALUE () {14;}' unless defined(&MIXT_HEXVALUE);
    eval 'sub MIXT_MONODB () {15;}' unless defined(&MIXT_MONODB);
    eval 'sub MIXT_STEREODB () {16;}' unless defined(&MIXT_STEREODB);
    eval 'sub MIXT_SLIDER () {17;}' unless defined(&MIXT_SLIDER);
    eval 'sub MIXT_3D () {18;}' unless defined(&MIXT_3D);
    eval 'sub MIXT_MONOSLIDER16 () {19;}' unless defined(&MIXT_MONOSLIDER16);
    eval 'sub MIXT_STEREOSLIDER16 () {20;}' unless defined(&MIXT_STEREOSLIDER16);
    eval 'sub MIXT_MUTE () {21;}' unless defined(&MIXT_MUTE);
    eval 'sub MIXT_ENUM_MULTI () {22;}' unless defined(&MIXT_ENUM_MULTI);
    eval 'sub MIXF_READABLE () {0x1;}' unless defined(&MIXF_READABLE);
    eval 'sub MIXF_WRITEABLE () {0x2;}' unless defined(&MIXF_WRITEABLE);
    eval 'sub MIXF_POLL () {0x4;}' unless defined(&MIXF_POLL);
    eval 'sub MIXF_HZ () {0x8;}' unless defined(&MIXF_HZ);
    eval 'sub MIXF_STRING () {0x10;}' unless defined(&MIXF_STRING);
    eval 'sub MIXF_DYNAMIC () {0x10;}' unless defined(&MIXF_DYNAMIC);
    eval 'sub MIXF_OKFAIL () {0x20;}' unless defined(&MIXF_OKFAIL);
    eval 'sub MIXF_FLAT () {0x40;}' unless defined(&MIXF_FLAT);
    eval 'sub MIXF_LEGACY () {0x80;}' unless defined(&MIXF_LEGACY);
    eval 'sub MIXF_CENTIBEL () {0x100;}' unless defined(&MIXF_CENTIBEL);
    eval 'sub MIXF_DECIBEL () {0x200;}' unless defined(&MIXF_DECIBEL);
    eval 'sub MIXF_MAINVOL () {0x400;}' unless defined(&MIXF_MAINVOL);
    eval 'sub MIXF_PCMVOL () {0x800;}' unless defined(&MIXF_PCMVOL);
    eval 'sub MIXF_RECVOL () {0x1000;}' unless defined(&MIXF_RECVOL);
    eval 'sub MIXF_MONVOL () {0x2000;}' unless defined(&MIXF_MONVOL);
    eval 'sub MIXF_WIDE () {0x4000;}' unless defined(&MIXF_WIDE);
    eval 'sub MIXF_DESCR () {0x8000;}' unless defined(&MIXF_DESCR);
    eval 'sub MIXF_DISABLED () {0x10000;}' unless defined(&MIXF_DISABLED);
    eval 'sub MIXER_CAP_VIRTUAL () {0x1;}' unless defined(&MIXER_CAP_VIRTUAL);
    eval 'sub MIXER_CAP_LAYOUT_B () {0x2;}' unless defined(&MIXER_CAP_LAYOUT_B);
    eval 'sub MIXER_CAP_NARROW () {0x4;}' unless defined(&MIXER_CAP_NARROW);
    eval 'sub OSS_ID_SIZE () {16;}' unless defined(&OSS_ID_SIZE);
    eval 'sub OSS_DEVNODE_SIZE () {32;}' unless defined(&OSS_DEVNODE_SIZE);
    eval 'sub OSS_HANDLE_SIZE () {32;}' unless defined(&OSS_HANDLE_SIZE);
    eval 'sub OSS_LONGNAME_SIZE () {64;}' unless defined(&OSS_LONGNAME_SIZE);
    eval 'sub OSS_LABEL_SIZE () {16;}' unless defined(&OSS_LABEL_SIZE);
    eval 'sub OSS_ENUM_MAXVALUE () {255;}' unless defined(&OSS_ENUM_MAXVALUE);
    eval 'sub OSS_ENUM_STRINGSIZE () {3000;}' unless defined(&OSS_ENUM_STRINGSIZE);
    eval 'sub SNDCTL_SETSONG () { &_IOW (ord(\'Y\'),2, \'oss_longname_t\');}' unless defined(&SNDCTL_SETSONG);
    eval 'sub SNDCTL_GETSONG () { &_IOR (ord(\'Y\'),2, \'oss_longname_t\');}' unless defined(&SNDCTL_GETSONG);
    eval 'sub SNDCTL_SETNAME () { &_IOW (ord(\'Y\'),3, \'oss_longname_t\');}' unless defined(&SNDCTL_SETNAME);
    eval 'sub SNDCTL_SETLABEL () { &_IOW (ord(\'Y\'),4,  &oss_label_t);}' unless defined(&SNDCTL_SETLABEL);
    eval 'sub SNDCTL_GETLABEL () { &_IOR (ord(\'Y\'),4,  &oss_label_t);}' unless defined(&SNDCTL_GETLABEL);
    eval 'sub ioctl () { &_oss_ioctl;}' unless defined(&ioctl);
    unless(defined(&_SYS_IOCTL_H_)) {
	require 'sys/ioctl.ph';
    } else {
    }
}
1;
