/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.flexdock.docking.state.PersistenceException;
import org.flexdock.perspective.persist.PersistenceHandler;
import org.flexdock.perspective.persist.Persister;
import org.flexdock.perspective.persist.PerspectiveModel;
import org.flexdock.perspective.persist.xml.XMLPersister;

public class FilePersistenceHandler
implements PersistenceHandler {
    public static final File DEFAULT_PERSPECTIVE_DIR = new File(System.getProperty("user.home") + "/flexdock/perspectives");
    protected File defaultPerspectiveFile;
    protected Persister m_persister = null;

    public FilePersistenceHandler(String absolutePath) {
        this(new File(absolutePath), null);
    }

    public FilePersistenceHandler(File file) {
        this(file, null);
    }

    public FilePersistenceHandler(String absolutePath, Persister persister) {
        this(new File(absolutePath), persister);
    }

    public FilePersistenceHandler(File defaultFile, Persister persister) {
        this.defaultPerspectiveFile = defaultFile;
        if (persister == null) {
            persister = this.createDefaultPersister();
        }
        this.m_persister = persister;
    }

    public static FilePersistenceHandler createDefault(String fileName) {
        String path = DEFAULT_PERSPECTIVE_DIR.getAbsolutePath() + "/" + fileName;
        return new FilePersistenceHandler(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(String persistenceKey, PerspectiveModel perspectiveModel) throws IOException, PersistenceException {
        File file = this.getPerspectiveFile(persistenceKey);
        this.validatePerspectiveFile(file);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            boolean bl = this.m_persister.store(fos, perspectiveModel);
            return bl;
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerspectiveModel load(String persistenceKey) throws IOException, PersistenceException {
        File file = this.getPerspectiveFile(persistenceKey);
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            PerspectiveModel perspectiveModel;
            PerspectiveModel perspectiveModel2 = perspectiveModel = this.m_persister.load(fis);
            return perspectiveModel2;
        }
        finally {
            fis.close();
        }
    }

    protected void validatePerspectiveFile(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public File getPerspectiveFile(String persistenceKey) {
        if (persistenceKey == null) {
            return this.defaultPerspectiveFile;
        }
        String filePath = persistenceKey;
        if (filePath.indexOf(47) == -1 && filePath.indexOf(92) == -1) {
            filePath = DEFAULT_PERSPECTIVE_DIR.getAbsolutePath() + "/" + filePath;
        }
        return new File(filePath);
    }

    public void setDefaultPerspectiveFile(File file) {
        this.defaultPerspectiveFile = file;
    }

    public void setDefaultPerspectiveFile(String absolutePath) {
        this.defaultPerspectiveFile = new File(absolutePath);
    }

    public Persister createDefaultPersister() {
        return XMLPersister.newDefaultInstance();
    }
}

