/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpadapter;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Stack;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtils;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.utils.StringUtils;

public class GtpAdapter
extends GtpEngine {
    private boolean m_emuHandicap;
    private boolean m_emuLoadsgf;
    private boolean m_fillPasses;
    private boolean m_lowerCase;
    private boolean m_noScore;
    private boolean m_resign;
    private boolean m_version1;
    private int m_size;
    private int m_boardSize;
    private int m_resignScore;
    private Board m_board;
    private final GtpClient m_gtp;
    private final Stack m_passInserted = new Stack();
    private String m_name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpAdapter(String string, PrintStream printStream, String string2, boolean bl) throws Exception {
        super(printStream);
        if (string.equals("")) {
            throw new Exception("No program set");
        }
        this.m_gtp = new GtpClient(string, bl, null);
        if (string2 != null) {
            this.sendGtpFile(string2);
        }
        this.init();
    }

    public GtpAdapter(GtpClient gtpClient, PrintStream printStream) throws GtpError {
        super(printStream);
        this.m_gtp = gtpClient;
        this.init();
    }

    public void close() {
        this.m_gtp.close();
        this.m_gtp.waitForExit();
    }

    public void handleCommand(GtpCommand gtpCommand) throws GtpError {
        if (gtpCommand.getCommand().equals("black")) {
            this.cmdPlay(GoColor.BLACK, gtpCommand);
        } else if (gtpCommand.getCommand().equals("boardsize")) {
            this.cmdBoardsize(gtpCommand);
        } else if (gtpCommand.getCommand().equals("clear_board")) {
            this.cmdClearBoard();
        } else if (gtpCommand.getCommand().equals("final_score") && this.m_noScore) {
            this.cmdUnknown();
        } else if (gtpCommand.getCommand().equals("final_status_list") && this.m_noScore) {
            this.cmdUnknown();
        } else if (gtpCommand.getCommand().equals("genmove")) {
            this.cmdGenmove(gtpCommand);
        } else if (gtpCommand.getCommand().equals("genmove_black")) {
            this.cmdGenmove(GoColor.BLACK, gtpCommand);
        } else if (gtpCommand.getCommand().equals("genmove_white")) {
            this.cmdGenmove(GoColor.WHITE, gtpCommand);
        } else if (gtpCommand.getCommand().equals("gg-undo")) {
            this.cmdGGUndo(gtpCommand);
        } else if (gtpCommand.getCommand().equals("gtpadapter_showboard")) {
            this.cmdGtpAdapterShowBoard(gtpCommand);
        } else if (gtpCommand.getCommand().equals("help")) {
            this.cmdListCommands(gtpCommand);
        } else if (gtpCommand.getCommand().equals("list_commands")) {
            this.cmdListCommands(gtpCommand);
        } else if (gtpCommand.getCommand().equals("loadsgf")) {
            this.cmdLoadsgf(gtpCommand);
        } else if (gtpCommand.getCommand().equals("name") && this.m_name != null) {
            this.cmdName(gtpCommand);
        } else if (gtpCommand.getCommand().equals("place_free_handicap") && this.m_emuHandicap) {
            this.cmdPlaceFreeHandicap(gtpCommand);
        } else if (gtpCommand.getCommand().equals("play")) {
            this.cmdPlay(gtpCommand);
        } else if (gtpCommand.getCommand().equals("protocol_version")) {
            gtpCommand.getResponse().append(this.m_version1 ? "1" : "2");
        } else if (gtpCommand.getCommand().equals("quit")) {
            this.cmdQuit();
        } else if (gtpCommand.getCommand().equals("set_free_handicap") && this.m_emuHandicap) {
            this.cmdSetFreeHandicap(gtpCommand);
        } else if (gtpCommand.getCommand().equals("version") && this.m_name != null) {
            this.cmdVersion(gtpCommand);
        } else if (gtpCommand.getCommand().equals("undo")) {
            this.cmdUndo(gtpCommand);
        } else if (gtpCommand.getCommand().equals("white")) {
            this.cmdPlay(GoColor.WHITE, gtpCommand);
        } else {
            this.send(gtpCommand.getLine(), gtpCommand.getResponse());
        }
    }

    public void interruptProgram(GtpClient gtpClient) {
        try {
            if (gtpClient.isInterruptSupported()) {
                gtpClient.sendInterrupt();
            }
        }
        catch (GtpError gtpError) {
            System.err.println(gtpError);
        }
    }

    public void interruptCommand() {
        this.interruptProgram(this.m_gtp);
    }

    public void setEmuLoadSgf() {
        this.m_emuLoadsgf = true;
    }

    public void setEmuHandicap() {
        this.m_emuHandicap = true;
    }

    public void setFillPasses() {
        this.m_fillPasses = true;
    }

    public void setFixedSize(int n) {
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > 25) {
            throw new AssertionError();
        }
        this.m_size = n;
        this.m_boardSize = n;
        this.m_board = new Board(this.m_boardSize);
    }

    public void setLowerCase() {
        this.m_lowerCase = true;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setNoScore() {
        this.m_noScore = true;
    }

    public void setResign(int n) {
        this.m_resign = true;
        this.m_resignScore = Math.abs(n);
    }

    public void setVersion1() {
        this.m_version1 = true;
    }

    private boolean checkResign(GoColor goColor, StringBuffer stringBuffer) {
        if (!this.m_resign) {
            return false;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this.send("estimate_score", stringBuffer2);
        }
        catch (GtpError gtpError) {
            return false;
        }
        boolean bl = false;
        double d = 0.0;
        String[] stringArray = StringUtils.splitArguments(stringBuffer2.toString());
        if (stringArray.length > 0) {
            String string = stringArray[0];
            try {
                if (!string.equals("?")) {
                    if (string.indexOf("B+") >= 0) {
                        d = Double.parseDouble(string.substring(2));
                    } else if (string.indexOf("W+") >= 0) {
                        d = -Double.parseDouble(string.substring(2));
                    }
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = goColor == GoColor.BLACK;
            if (bl2 && d < (double)(-this.m_resignScore) || !bl2 && d > (double)this.m_resignScore) {
                stringBuffer.append("resign");
                return true;
            }
        }
        return false;
    }

    private void cmdBoardsize(GtpCommand gtpCommand) throws GtpError {
        int n = gtpCommand.getIntArg();
        if (n < 1) {
            throw new GtpError("Invalid board size");
        }
        if (this.m_size > 0 && n != this.m_size) {
            throw new GtpError("Boardsize must be " + this.m_size);
        }
        String string = this.m_gtp.getCommandBoardsize(n);
        if (string != null) {
            this.send(string);
        }
        this.m_boardSize = n;
        this.m_board = new Board(this.m_boardSize);
        this.m_passInserted.clear();
        string = this.m_gtp.getCommandClearBoard(this.m_boardSize);
        this.send(string);
    }

    private void cmdClearBoard() throws GtpError {
        this.send(this.m_gtp.getCommandClearBoard(this.m_boardSize));
        this.m_board = new Board(this.m_boardSize);
        this.m_passInserted.clear();
    }

    private void cmdGenmove(GtpCommand gtpCommand) throws GtpError {
        this.cmdGenmove(gtpCommand.getColorArg(), gtpCommand);
    }

    private void cmdGenmove(GoColor goColor, GtpCommand gtpCommand) throws GtpError {
        String string;
        if (this.checkResign(goColor, gtpCommand.getResponse())) {
            return;
        }
        String string2 = this.m_gtp.getCommandGenmove(goColor);
        this.fillPass(goColor);
        try {
            string = this.send(string2);
        }
        catch (GtpError gtpError) {
            this.undoFillPass();
            throw gtpError;
        }
        if (string.toLowerCase().trim().equals("resign")) {
            return;
        }
        GoPoint goPoint = GtpUtils.parsePoint(string, this.m_boardSize);
        this.m_board.play(goPoint, goColor);
        gtpCommand.setResponse(string);
    }

    private void cmdGGUndo(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArgLessEqual(1);
        int n = 1;
        if (gtpCommand.getNuArg() == 1) {
            n = gtpCommand.getIntArg(0, 1, this.m_board.getMoveNumber());
        }
        int n2 = 0;
        Stack<Boolean> stack = new Stack<Boolean>();
        for (int i = 0; i < n; ++i) {
            ++n2;
            if (!this.m_fillPasses) continue;
            Boolean bl = (Boolean)this.m_passInserted.pop();
            stack.push(bl);
            if (!bl.booleanValue()) continue;
            ++n2;
        }
        try {
            this.send("gg-undo " + n2);
        }
        catch (GtpError gtpError) {
            while (!stack.empty()) {
                this.m_passInserted.push(stack.pop());
            }
            return;
        }
        this.m_board.undo(n2);
    }

    private void cmdGtpAdapterShowBoard(GtpCommand gtpCommand) throws GtpError {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        BoardUtils.print(this.m_board, printStream, true);
        gtpCommand.getResponse().append("\n");
        gtpCommand.getResponse().append(((Object)byteArrayOutputStream).toString());
    }

    private void cmdListCommands(GtpCommand gtpCommand) throws GtpError {
        ArrayList arrayList = this.m_gtp.getSupportedCommands();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string.equals("boardsize") || string.equals("black") || string.equals("clear_board") || string.equals("genmove") || string.equals("genmove_black") || string.equals("genmove_white") || string.equals("help") || string.equals("list_commands") || string.equals("play") || string.equals("protocol_version") || string.equals("quit") || string.equals("white") || (string.equals("set_free_handicap") || string.equals("get_free_handicap")) && this.m_emuHandicap || string.equals("loadsgf") && this.m_emuLoadsgf || this.m_noScore && (string.equals("final_score") || string.equals("final_status_list"))) continue;
            gtpCommand.getResponse().append(string);
            gtpCommand.getResponse().append("\n");
        }
        gtpCommand.getResponse().append("boardsize\n");
        gtpCommand.getResponse().append("protocol_version\n");
        gtpCommand.getResponse().append("quit\n");
        if (this.m_version1) {
            gtpCommand.getResponse().append("black\n");
            gtpCommand.getResponse().append("help\n");
            gtpCommand.getResponse().append("genmove_white\n");
            gtpCommand.getResponse().append("genmove_black\n");
            gtpCommand.getResponse().append("white\n");
        } else {
            gtpCommand.getResponse().append("clear_board\n");
            gtpCommand.getResponse().append("genmove\n");
            gtpCommand.getResponse().append("list_commands\n");
            gtpCommand.getResponse().append("play\n");
        }
        if (this.m_emuHandicap) {
            gtpCommand.getResponse().append("set_free_handicap\n");
            gtpCommand.getResponse().append("get_free_handicap\n");
        }
        if (this.m_emuLoadsgf) {
            gtpCommand.getResponse().append("loadsgf\n");
        }
        gtpCommand.getResponse().append("gtpadapter_showboard\n");
    }

    private void cmdLoadsgf(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArgLessEqual(2);
        String string = gtpCommand.getArg(0);
        String string2 = "loadsgf " + string;
        int n = -1;
        if (gtpCommand.getNuArg() == 2) {
            n = gtpCommand.getIntArg(1);
        }
        if (!this.m_emuLoadsgf) {
            this.send(string2);
        }
        GoColor goColor = GoColor.EMPTY;
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            SgfReader sgfReader = new SgfReader(fileInputStream, string, null, 0L);
            GameTree gameTree = sgfReader.getGameTree();
            this.m_boardSize = gameTree.getGameInformation().m_boardSize;
            this.m_board = new Board(this.m_boardSize);
            this.m_passInserted.clear();
            if (this.m_emuLoadsgf) {
                this.m_gtp.sendBoardsize(this.m_boardSize);
                this.m_gtp.sendClearBoard(this.m_boardSize);
            }
            int n2 = 0;
            for (Node node = gameTree.getRoot(); node != null && (node.getMove() == null || n < 0 || ++n2 < n); node = node.getChild()) {
                ArrayList arrayList = NodeUtils.getAllAsMoves(node);
                for (int i = 0; i < arrayList.size(); ++i) {
                    Move move = (Move)arrayList.get(i);
                    if (this.m_emuLoadsgf) {
                        this.play(move.getColor(), move.getPoint());
                        continue;
                    }
                    this.m_board.play(move);
                }
                goColor = node.getToMove();
            }
            if (goColor != GoColor.EMPTY && goColor != this.m_board.getToMove()) {
                if (this.m_emuLoadsgf) {
                    this.play(this.m_board.getToMove(), null);
                } else {
                    this.m_board.setToMove(goColor);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GtpError("File not found");
        }
        catch (SgfReader.SgfError sgfError) {
            throw new GtpError("Could not read file");
        }
    }

    private void cmdName(GtpCommand gtpCommand) throws GtpError {
        if (!$assertionsDisabled && this.m_name == null) {
            throw new AssertionError();
        }
        int n = this.m_name.indexOf(58);
        if (n < 0) {
            gtpCommand.setResponse(this.m_name);
        } else {
            gtpCommand.setResponse(this.m_name.substring(0, n));
        }
    }

    private void cmdPlaceFreeHandicap(GtpCommand gtpCommand) throws GtpError {
        int n = gtpCommand.getIntArg();
        ArrayList arrayList = Board.getHandicapStones(this.m_boardSize, n);
        if (arrayList == null) {
            throw new GtpError("Invalid number of handicap stones");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = 0; i < arrayList.size(); ++i) {
            GoPoint goPoint = (GoPoint)arrayList.get(i);
            this.play(GoColor.BLACK, goPoint);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(goPoint);
        }
        gtpCommand.setResponse(stringBuffer.toString());
    }

    private void cmdPlay(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(2);
        GoColor goColor = gtpCommand.getColorArg(0);
        GoPoint goPoint = gtpCommand.getPointArg(1, this.m_boardSize);
        this.play(goColor, goPoint);
    }

    private void cmdPlay(GoColor goColor, GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(1);
        this.play(goColor, gtpCommand.getPointArg(0, this.m_boardSize));
    }

    private void cmdQuit() throws GtpError {
        this.send("quit");
    }

    private void cmdSetFreeHandicap(GtpCommand gtpCommand) throws GtpError {
        for (int i = 0; i < gtpCommand.getNuArg(); ++i) {
            this.play(GoColor.BLACK, gtpCommand.getPointArg(i, this.m_boardSize));
        }
    }

    private void cmdUndo(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        this.undo();
    }

    private void cmdUnknown() throws GtpError {
        throw new GtpError("Unknown command");
    }

    private void cmdVersion(GtpCommand gtpCommand) throws GtpError {
        if (!$assertionsDisabled && this.m_name == null) {
            throw new AssertionError();
        }
        int n = this.m_name.indexOf(58);
        if (n >= 0) {
            gtpCommand.setResponse(this.m_name.substring(n + 1));
        }
    }

    private void fillPass(GoColor goColor) throws GtpError {
        if (!this.m_fillPasses) {
            return;
        }
        GoColor goColor2 = this.m_board.getToMove();
        if (goColor == goColor2) {
            this.m_passInserted.push(Boolean.FALSE);
            return;
        }
        String string = this.m_gtp.getCommandPlay(Move.getPass(goColor2));
        try {
            this.send(string);
            this.m_passInserted.push(Boolean.TRUE);
        }
        catch (GtpError gtpError) {
            this.m_passInserted.push(Boolean.FALSE);
            throw gtpError;
        }
    }

    private void init() throws GtpError {
        this.m_gtp.queryProtocolVersion();
        this.m_gtp.querySupportedCommands();
        this.m_boardSize = 19;
        this.m_board = new Board(this.m_boardSize);
        this.m_size = -1;
        this.m_name = null;
        this.m_resign = false;
        this.m_fillPasses = false;
    }

    private void play(GoColor goColor, GoPoint goPoint) throws GtpError {
        this.fillPass(goColor);
        Move move = Move.get(goPoint, goColor);
        String string = this.m_gtp.getCommandPlay(move);
        if (this.m_lowerCase) {
            string = string.toLowerCase();
        }
        this.send(string);
        this.m_board.play(move);
    }

    private String send(String string) throws GtpError {
        return this.m_gtp.send(string);
    }

    private void send(String string, StringBuffer stringBuffer) throws GtpError {
        stringBuffer.append(this.m_gtp.send(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendGtpFile(String var1_1) {
        try {
            var2_2 = new FileReader(new File(var1_1));
        }
        catch (FileNotFoundException var3_3) {
            System.err.println("File not found: " + var1_1);
            return;
        }
        var3_4 = new BufferedReader(var2_2);
        try {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    if ((var4_5 = var3_4.readLine()) == null) {
                        var3_4.close();
                        return;
                    }
                    if ((var4_5 = var4_5.trim()).equals("") || var4_5.startsWith("#")) continue;
                    try {
                        this.send(var4_5);
                        continue;
                    }
                    catch (GtpError var5_8) {
                        System.err.println("Sending commands aborted:" + var5_8.getMessage());
                        return;
                    }
                    break;
                }
            }
            catch (IOException var4_6) {
                System.err.println("Sending commands aborted:" + var4_6.getMessage());
                return;
            }
            {
                ** while (true)
            }
        }
        finally {
            try {
                var3_4.close();
            }
            catch (IOException var4_7) {}
        }
    }

    private void undo() throws GtpError {
        this.send("undo");
        this.m_board.undo();
        this.undoFillPass();
    }

    private void undoFillPass() throws GtpError {
        if (!this.m_fillPasses) {
            return;
        }
        Boolean bl = (Boolean)this.m_passInserted.pop();
        if (bl.booleanValue()) {
            this.send("undo");
        }
    }

    static {
        $assertionsDisabled = !GtpAdapter.class.desiredAssertionStatus();
    }
}

