/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.geolocation.client;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.PartialSupport;
import com.google.gwt.geolocation.client.Position;
import com.google.gwt.geolocation.client.PositionError;
import com.google.gwt.geolocation.client.PositionImpl;

@PartialSupport
public class Geolocation {
    private static GeolocationSupportDetector detector;
    private static Geolocation impl;

    public static Geolocation getIfSupported() {
        if (!Geolocation.isSupported()) {
            return null;
        }
        if (impl == null) {
            impl = new Geolocation();
        }
        return impl;
    }

    public static boolean isSupported() {
        if (detector == null) {
            detector = (GeolocationSupportDetector)GWT.create(GeolocationSupportDetector.class);
        }
        return detector.isSupported();
    }

    private static void handleFailure(Callback<Position, PositionError> callback, int code, String msg) {
        callback.onFailure(new PositionError(code, msg));
    }

    private static void handleSuccess(Callback<Position, PositionError> callback, PositionImpl pos) {
        callback.onSuccess(pos);
    }

    private static native JavaScriptObject toJso(PositionOptions var0);

    protected Geolocation() {
    }

    public native void clearWatch(int var1);

    public void getCurrentPosition(Callback<Position, PositionError> callback) {
        this.getCurrentPosition(callback, null);
    }

    public native void getCurrentPosition(Callback<Position, PositionError> var1, PositionOptions var2);

    public int watchPosition(Callback<Position, PositionError> callback) {
        return this.watchPosition(callback, null);
    }

    public native int watchPosition(Callback<Position, PositionError> var1, PositionOptions var2);

    public static class PositionOptions {
        private boolean enableHighAccuracy = false;
        private int timeout = -1;
        private int maximumAge = 0;

        public PositionOptions setHighAccuracyEnabled(boolean enabled) {
            this.enableHighAccuracy = enabled;
            return this;
        }

        public PositionOptions setMaximumAge(int maximumAge) {
            this.maximumAge = maximumAge;
            return this;
        }

        public PositionOptions setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    private static class GeolocationSupportDetectorNo
    extends GeolocationSupportDetector {
        private GeolocationSupportDetectorNo() {
        }

        @Override
        public boolean isSupported() {
            return false;
        }
    }

    private static class GeolocationSupportDetector {
        private boolean supported = GeolocationSupportDetector.detectSupport();

        private GeolocationSupportDetector() {
        }

        private static native boolean detectSupport();

        public boolean isSupported() {
            return this.supported;
        }
    }
}

