/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.BaseCipher;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class Rijndael
extends BaseCipher {
    private static final boolean DEBUG = false;
    private static final int debuglevel = 9;
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int DEFAULT_KEY_SIZE = 16;
    private static final String SS = "\u637c\u777b\uf26b\u6fc5\u3001\u672b\ufed7\uab76\uca82\uc97d\ufa59\u47f0\uadd4\ua2af\u9ca4\u72c0\ub7fd\u9326\u363f\uf7cc\u34a5\ue5f1\u71d8\u3115\u04c7\u23c3\u1896\u059a\u0712\u80e2\ueb27\ub275\u0983\u2c1a\u1b6e\u5aa0\u523b\ud6b3\u29e3\u2f84\u53d1\u00ed\u20fc\ub15b\u6acb\ube39\u4a4c\u58cf\ud0ef\uaafb\u434d\u3385\u45f9\u027f\u503c\u9fa8\u51a3\u408f\u929d\u38f5\ubcb6\uda21\u10ff\uf3d2\ucd0c\u13ec\u5f97\u4417\uc4a7\u7e3d\u645d\u1973\u6081\u4fdc\u222a\u9088\u46ee\ub814\ude5e\u0bdb\ue032\u3a0a\u4906\u245c\uc2d3\uac62\u9195\ue479\ue7c8\u376d\u8dd5\u4ea9\u6c56\uf4ea\u657a\uae08\uba78\u252e\u1ca6\ub4c6\ue8dd\u741f\u4bbd\u8b8a\u703e\ub566\u4803\uf60e\u6135\u57b9\u86c1\u1d9e\ue1f8\u9811\u69d9\u8e94\u9b1e\u87e9\uce55\u28df\u8ca1\u890d\ubfe6\u4268\u4199\u2d0f\ub054\ubb16";
    private static final byte[] S = new byte[256];
    private static final byte[] Si = new byte[256];
    private static final int[] T1 = new int[256];
    private static final int[] T2 = new int[256];
    private static final int[] T3 = new int[256];
    private static final int[] T4 = new int[256];
    private static final int[] T5 = new int[256];
    private static final int[] T6 = new int[256];
    private static final int[] T7 = new int[256];
    private static final int[] T8 = new int[256];
    private static final int[] U1 = new int[256];
    private static final int[] U2 = new int[256];
    private static final int[] U3 = new int[256];
    private static final int[] U4 = new int[256];
    private static final byte[] rcon = new byte[30];
    private static final int[][][] shifts = new int[][][]{new int[][]{new int[2], {1, 3}, {2, 2}, {3, 1}}, new int[][]{new int[2], {1, 5}, {2, 4}, {3, 3}}, new int[][]{new int[2], {1, 7}, {3, 5}, {4, 4}}};
    private static final byte[] KAT_KEY = Util.toBytesFromString("0000000000000000000000010000000000000000000000000000000000000000");
    private static final byte[] KAT_CT = Util.toBytesFromString("E44429474D6FC3084EB2A6B8B46AF754");
    private static Boolean valid;

    public static final int getRounds(int n, int n2) {
        switch (n) {
            case 16: {
                return n2 == 16 ? 10 : (n2 == 24 ? 12 : 14);
            }
            case 24: {
                return n2 != 32 ? 12 : 14;
            }
        }
        return 14;
    }

    private static final void rijndaelEncrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[0];
        int n4 = n3 / 4;
        int n5 = nArray.length - 1;
        int n6 = 0;
        if (n4 != 4) {
            int n7 = 0;
            if (n4 == 6) {
                n7 = 1;
            }
            n6 = 2 - n7;
        }
        int n8 = n6;
        int n9 = shifts[n8][1][0];
        int n10 = shifts[n8][2][0];
        int n11 = shifts[n8][3][0];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int n12 = 0;
        while (n12 < n4) {
            nArray3[n12] = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n12];
            ++n12;
        }
        int n13 = 1;
        while (n13 < n5) {
            n12 = 0;
            while (n12 < n4) {
                nArray2[n12] = T1[nArray3[n12] >>> 24] ^ T2[nArray3[(n12 + n9) % n4] >>> 16 & 0xFF] ^ T3[nArray3[(n12 + n10) % n4] >>> 8 & 0xFF] ^ T4[nArray3[(n12 + n11) % n4] & 0xFF] ^ nArray[n13][n12];
                ++n12;
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n4);
            ++n13;
        }
        n12 = 0;
        while (n12 < n4) {
            int n14 = nArray[n5][n12];
            byArray2[n2++] = (byte)(S[nArray3[n12] >>> 24] ^ n14 >>> 24);
            byArray2[n2++] = (byte)(S[nArray3[(n12 + n9) % n4] >>> 16 & 0xFF] ^ n14 >>> 16);
            byArray2[n2++] = (byte)(S[nArray3[(n12 + n10) % n4] >>> 8 & 0xFF] ^ n14 >>> 8);
            byArray2[n2++] = (byte)(S[nArray3[(n12 + n11) % n4] & 0xFF] ^ n14);
            ++n12;
        }
    }

    private static final void rijndaelDecrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[1];
        int n4 = n3 / 4;
        int n5 = nArray.length - 1;
        int n6 = 0;
        if (n4 != 4) {
            int n7 = 0;
            if (n4 == 6) {
                n7 = 1;
            }
            n6 = 2 - n7;
        }
        int n8 = n6;
        int n9 = shifts[n8][1][1];
        int n10 = shifts[n8][2][1];
        int n11 = shifts[n8][3][1];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int n12 = 0;
        while (n12 < n4) {
            nArray3[n12] = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n12];
            ++n12;
        }
        int n13 = 1;
        while (n13 < n5) {
            n12 = 0;
            while (n12 < n4) {
                nArray2[n12] = T5[nArray3[n12] >>> 24] ^ T6[nArray3[(n12 + n9) % n4] >>> 16 & 0xFF] ^ T7[nArray3[(n12 + n10) % n4] >>> 8 & 0xFF] ^ T8[nArray3[(n12 + n11) % n4] & 0xFF] ^ nArray[n13][n12];
                ++n12;
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n4);
            ++n13;
        }
        n12 = 0;
        while (n12 < n4) {
            int n14 = nArray[n5][n12];
            byArray2[n2++] = (byte)(Si[nArray3[n12] >>> 24] ^ n14 >>> 24);
            byArray2[n2++] = (byte)(Si[nArray3[(n12 + n9) % n4] >>> 16 & 0xFF] ^ n14 >>> 16);
            byArray2[n2++] = (byte)(Si[nArray3[(n12 + n10) % n4] >>> 8 & 0xFF] ^ n14 >>> 8);
            byArray2[n2++] = (byte)(Si[nArray3[(n12 + n11) % n4] & 0xFF] ^ n14);
            ++n12;
        }
    }

    private static final void aesEncrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        int[][] nArray = (int[][])((Object[])object)[0];
        int n3 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n4 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n5 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n6 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n7 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        int n8 = 1;
        while (n8 < n3) {
            nArray2 = nArray[n8];
            int n9 = T1[n4 >>> 24] ^ T2[n5 >>> 16 & 0xFF] ^ T3[n6 >>> 8 & 0xFF] ^ T4[n7 & 0xFF] ^ nArray2[0];
            int n10 = T1[n5 >>> 24] ^ T2[n6 >>> 16 & 0xFF] ^ T3[n7 >>> 8 & 0xFF] ^ T4[n4 & 0xFF] ^ nArray2[1];
            int n11 = T1[n6 >>> 24] ^ T2[n7 >>> 16 & 0xFF] ^ T3[n4 >>> 8 & 0xFF] ^ T4[n5 & 0xFF] ^ nArray2[2];
            int n12 = T1[n7 >>> 24] ^ T2[n4 >>> 16 & 0xFF] ^ T3[n5 >>> 8 & 0xFF] ^ T4[n6 & 0xFF] ^ nArray2[3];
            n4 = n9;
            n5 = n10;
            n6 = n11;
            n7 = n12;
            ++n8;
        }
        nArray2 = nArray[n3];
        n8 = nArray2[0];
        byArray2[n2++] = (byte)(S[n4 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(S[n5 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(S[n6 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(S[n7 & 0xFF] ^ n8);
        n8 = nArray2[1];
        byArray2[n2++] = (byte)(S[n5 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(S[n6 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(S[n7 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(S[n4 & 0xFF] ^ n8);
        n8 = nArray2[2];
        byArray2[n2++] = (byte)(S[n6 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(S[n7 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(S[n4 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(S[n5 & 0xFF] ^ n8);
        n8 = nArray2[3];
        byArray2[n2++] = (byte)(S[n7 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(S[n4 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(S[n5 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(S[n6 & 0xFF] ^ n8);
    }

    private static final void aesDecrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        int[][] nArray = (int[][])((Object[])object)[1];
        int n3 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n4 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n5 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n6 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n7 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        int n8 = 1;
        while (n8 < n3) {
            nArray2 = nArray[n8];
            int n9 = T5[n4 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ nArray2[0];
            int n10 = T5[n5 >>> 24] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ nArray2[1];
            int n11 = T5[n6 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ nArray2[2];
            int n12 = T5[n7 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ nArray2[3];
            n4 = n9;
            n5 = n10;
            n6 = n11;
            n7 = n12;
            ++n8;
        }
        nArray2 = nArray[n3];
        n8 = nArray2[0];
        byArray2[n2++] = (byte)(Si[n4 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n7 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n6 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(Si[n5 & 0xFF] ^ n8);
        n8 = nArray2[1];
        byArray2[n2++] = (byte)(Si[n5 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n4 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n7 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(Si[n6 & 0xFF] ^ n8);
        n8 = nArray2[2];
        byArray2[n2++] = (byte)(Si[n6 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n5 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n4 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(Si[n7 & 0xFF] ^ n8);
        n8 = nArray2[3];
        byArray2[n2++] = (byte)(Si[n7 >>> 24] ^ n8 >>> 24);
        byArray2[n2++] = (byte)(Si[n6 >>> 16 & 0xFF] ^ n8 >>> 16);
        byArray2[n2++] = (byte)(Si[n5 >>> 8 & 0xFF] ^ n8 >>> 8);
        byArray2[n2++] = (byte)(Si[n4 & 0xFF] ^ n8);
    }

    public final Object clone() {
        Rijndael rijndael = new Rijndael();
        rijndael.currentBlockSize = this.currentBlockSize;
        return rijndael;
    }

    public final Iterator blockSizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(16));
        arrayList.add(new Integer(24));
        arrayList.add(new Integer(32));
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public final Iterator keySizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(16));
        arrayList.add(new Integer(24));
        arrayList.add(new Integer(32));
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public final Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        int n2;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        if (n != 16 && n != 24 && n != 32) {
            throw new IllegalArgumentException();
        }
        int n3 = Rijndael.getRounds(byArray.length, n);
        int n4 = n / 4;
        int[][] nArray = new int[n3 + 1][n4];
        int[][] nArray2 = new int[n3 + 1][n4];
        int n5 = (n3 + 1) * n4;
        int n6 = byArray.length / 4;
        int[] nArray3 = new int[n6];
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            nArray3[n7++] = byArray[n8++] << 24 | (byArray[n8++] & 0xFF) << 16 | (byArray[n8++] & 0xFF) << 8 | byArray[n8++] & 0xFF;
        }
        int n9 = 0;
        n8 = 0;
        while (n8 < n6 && n9 < n5) {
            nArray[n9 / n4][n9 % n4] = nArray3[n8];
            nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
            ++n8;
            ++n9;
        }
        int n10 = 0;
        while (n9 < n5) {
            n2 = nArray3[n6 - 1];
            nArray3[0] = nArray3[0] ^ ((S[n2 >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n2 & 0xFF] & 0xFF) << 8 ^ S[n2 >>> 24] & 0xFF ^ rcon[n10++] << 24);
            if (n6 != 8) {
                n7 = 1;
                n8 = 0;
                while (n7 < n6) {
                    int n11 = n7++;
                    nArray3[n11] = nArray3[n11] ^ nArray3[n8++];
                }
            } else {
                n7 = 1;
                n8 = 0;
                while (n7 < n6 / 2) {
                    int n12 = n7++;
                    nArray3[n12] = nArray3[n12] ^ nArray3[n8++];
                }
                n2 = nArray3[n6 / 2 - 1];
                int n13 = n6 / 2;
                nArray3[n13] = nArray3[n13] ^ (S[n2 & 0xFF] & 0xFF ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >>> 16 & 0xFF] & 0xFF) << 16 ^ S[n2 >>> 24 & 0xFF] << 24);
                n8 = n6 / 2;
                n7 = n8 + 1;
                while (n7 < n6) {
                    int n14 = n7++;
                    nArray3[n14] = nArray3[n14] ^ nArray3[n8++];
                }
            }
            n8 = 0;
            while (n8 < n6 && n9 < n5) {
                nArray[n9 / n4][n9 % n4] = nArray3[n8];
                nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
                ++n8;
                ++n9;
            }
        }
        int n15 = 1;
        while (n15 < n3) {
            n8 = 0;
            while (n8 < n4) {
                n2 = nArray2[n15][n8];
                nArray2[n15][n8] = U1[n2 >>> 24] ^ U2[n2 >>> 16 & 0xFF] ^ U3[n2 >>> 8 & 0xFF] ^ U4[n2 & 0xFF];
                ++n8;
            }
            ++n15;
        }
        return new Object[]{nArray, nArray2};
    }

    public final void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16 && n3 != 24 && n3 != 32) {
            throw new IllegalArgumentException();
        }
        if (n3 == 16) {
            Rijndael.aesEncrypt(byArray, n, byArray2, n2, object);
        } else {
            Rijndael.rijndaelEncrypt(byArray, n, byArray2, n2, object, n3);
        }
    }

    public final void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16 && n3 != 24 && n3 != 32) {
            throw new IllegalArgumentException();
        }
        if (n3 == 16) {
            Rijndael.aesDecrypt(byArray, n, byArray2, n2, object);
        } else {
            Rijndael.rijndaelDecrypt(byArray, n, byArray2, n2, object, n3);
        }
    }

    public final boolean selfTest() {
        if (valid == null) {
            boolean bl = super.selfTest();
            if (bl) {
                bl = this.testKat(KAT_KEY, KAT_CT);
            }
            valid = new Boolean(bl);
        }
        return valid;
    }

    public Rijndael() {
        super("rijndael", 16, 16);
    }

    static {
        long l = System.currentTimeMillis();
        int n = 283;
        boolean bl = false;
        int n2 = 0;
        while (n2 < 256) {
            int n3;
            int n4;
            int n5;
            char c = SS.charAt(n2 >>> 1);
            Rijndael.S[n2] = (byte)((n2 & 1) == 0 ? c >>> 8 : c & 0xFF);
            int n6 = S[n2] & 0xFF;
            Rijndael.Si[n6] = (byte)n2;
            int n7 = n6 << 1;
            if (n7 >= 256) {
                n7 ^= n;
            }
            int n8 = n7 ^ n6;
            int n9 = n2 << 1;
            if (n9 >= 256) {
                n9 ^= n;
            }
            if ((n5 = n9 << 1) >= 256) {
                n5 ^= n;
            }
            if ((n4 = n5 << 1) >= 256) {
                n4 ^= n;
            }
            int n10 = n4 ^ n2;
            int n11 = n10 ^ n9;
            int n12 = n10 ^ n5;
            int n13 = n4 ^ n5 ^ n9;
            Rijndael.T1[n2] = n3 = n7 << 24 | n6 << 16 | n6 << 8 | n8;
            Rijndael.T2[n2] = n3 >>> 8 | n3 << 24;
            Rijndael.T3[n2] = n3 >>> 16 | n3 << 16;
            Rijndael.T4[n2] = n3 >>> 24 | n3 << 8;
            Rijndael.U1[n2] = n3 = n13 << 24 | n10 << 16 | n12 << 8 | n11;
            Rijndael.T5[n6] = n3;
            Rijndael.T6[n6] = Rijndael.U2[n2] = n3 >>> 8 | n3 << 24;
            Rijndael.T7[n6] = Rijndael.U3[n2] = n3 >>> 16 | n3 << 16;
            Rijndael.T8[n6] = Rijndael.U4[n2] = n3 >>> 24 | n3 << 8;
            ++n2;
        }
        int n14 = 1;
        Rijndael.rcon[0] = 1;
        n2 = 1;
        while (n2 < 30) {
            if ((n14 <<= 1) >= 256) {
                n14 ^= n;
            }
            Rijndael.rcon[n2] = (byte)n14;
            ++n2;
        }
        l = System.currentTimeMillis() - l;
    }
}

