/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.HashSet;
import java.util.Vector;
import javax.sound.midi.MidiEvent;

public class Track {
    Vector events;
    private HashSet eventSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(MidiEvent midiEvent) {
        Vector vector = this.events;
        synchronized (vector) {
            if (this.eventSet.contains(midiEvent)) {
                return false;
            }
            this.eventSet.add(midiEvent);
            long l = midiEvent.getTick();
            int n = this.events.size() - 1;
            while (n >= 0 && ((MidiEvent)this.events.get(n)).getTick() > l) {
                --n;
            }
            this.events.add(n + 1, midiEvent);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(MidiEvent midiEvent) {
        Vector vector = this.events;
        synchronized (vector) {
            if (!this.eventSet.remove(midiEvent)) {
                return false;
            }
            int n = this.events.indexOf(midiEvent);
            if (n >= 0) {
                this.events.remove(n);
                return true;
            }
            throw new InternalError("event in set but not list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MidiEvent get(int n) throws ArrayIndexOutOfBoundsException {
        Vector vector = this.events;
        synchronized (vector) {
            try {
                return (MidiEvent)this.events.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (ArrayIndexOutOfBoundsException)new ArrayIndexOutOfBoundsException().initCause(indexOutOfBoundsException);
            }
        }
    }

    public int size() {
        return this.events.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long ticks() {
        Vector vector = this.events;
        synchronized (vector) {
            int n = this.events.size();
            return ((MidiEvent)this.events.get(n - 1)).getTick();
        }
    }

    Track() {
    }
}

