/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_DIALOG_H__
#define __SG_DIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "sg_property_dialog.h"

#define GTK_TYPE_SG_DIALOG                  (sg_dialog_get_type ())
#define SG_DIALOG(obj) (GTK_CHECK_CAST ((obj), GTK_TYPE_SG_DIALOG, SGdialog))

typedef enum {
  SG_BUTTON_NONE	= 0,
  SG_BUTTON_OK 		= 1 << 0,
  SG_BUTTON_APPLY 	= 1 << 1,
  SG_BUTTON_CANCEL 	= 1 << 2,
  SG_BUTTON_CLOSE 	= 1 << 3,
  SG_BUTTON_YES 	= 1 << 4,
  SG_BUTTON_NO	 	= 1 << 5,
  SG_BUTTON_BACK 	= 1 << 6,
  SG_BUTTON_NEXT	= 1 << 7
} SGdialogButton;

typedef struct
{
  GtkWindow window;

  SGpropertyDialog  *dialog;
  GtkObject *parent;
  gboolean running;

  GtkWidget *box;
  GtkWidget *button_box;
  GtkWidget *button_ok;
  GtkWidget *button_apply;
  GtkWidget *button_yes;
  GtkWidget *button_no;
  GtkWidget *button_back;
  GtkWidget *button_next;
  GtkWidget *button_cancel;

} SGdialog;

typedef struct
{
  GtkWindowClass parent_class;
} SGdialogClass;


GtkType		sg_dialog_get_type		();
GtkWidget* 	sg_dialog_new			(const gchar *title,
						 GtkOrientation orient,
						 guint button_mask,
						 GtkButtonBoxStyle layout);
void		sg_dialog_add			(GtkWidget *dialog,
						 SGpropertyDialog *child);
SGdialogButton	sg_dialog_run			(GtkWidget *dialog,
						 GtkObject *parent);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_DIALOG_H__ */
