/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import java.lang.reflect.Field;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ConfigTest
extends TestCase {
    public void setUp() throws Exception {
        super.setUp();
        Config.init();
    }

    public void testStoreRetrieve() {
        Object obj = new Object();
        Config.setValue("TestConfig", obj);
        Assert.assertEquals((Object)obj, (Object)Config.getValue("TestConfig"));
    }

    public void testListConfigVars() {
        Enumeration e = Config.listConfigVars();
        int count = 0;
        while (e.hasMoreElements()) {
            ++count;
            e.nextElement();
        }
        Config.setValue("TestConfigUniqueString", new Object());
        e = Config.listConfigVars();
        int newCount = 0;
        boolean foundNew = false;
        while (e.hasMoreElements()) {
            ++newCount;
            String key = (String)e.nextElement();
            if (!key.equals(new String("TestConfig"))) continue;
            foundNew = true;
        }
        Assert.assertEquals((String)"Element count should increase one with new value", (int)newCount, (int)(count + 1));
        Assert.assertTrue((String)"New config var should have been listed", (boolean)foundNew);
    }

    public void testConsistency() throws ClassNotFoundException {
        Class<?> configClass = Class.forName("br.arca.morcego.Config");
        Field[] fields = configClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            try {
                Object obj = Config.getValue((String)field.get(null));
                Assert.assertNotNull((String)("All public fields in config must be configuration keys:" + (String)field.get(null)), (Object)obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }
}

