/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqssl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.wiztools.restclient.bean.SSLHostnameVerifier;
import org.wiztools.restclient.bean.SSLKeyStore;
import org.wiztools.restclient.bean.SSLReq;
import org.wiztools.restclient.bean.SSLReqBean;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqssl.KeyStorePanel;
import org.wiztools.restclient.ui.reqssl.ReqSSLPanel;

public class ReqSSLPanelImpl
extends JPanel
implements ReqSSLPanel {
    @Inject
    RESTView view;
    @Inject
    RESTUserInterface rest_ui;
    private final JCheckBox jcb_disable_hostname_verifier = new JCheckBox("Disable hostname verification? ");
    private final JCheckBox jcb_ssl_trust_self_signed_cert = new JCheckBox("Ignore cert errors (self-signed, expired, etc.)? ");
    @Inject
    private KeyStorePanel jp_truststore;
    @Inject
    private KeyStorePanel jp_keystore;

    private SSLHostnameVerifier getSelectedHostnameVerifier() {
        return this.jcb_disable_hostname_verifier.isSelected() ? SSLHostnameVerifier.ALLOW_ALL : SSLHostnameVerifier.STRICT;
    }

    @Override
    public SSLReq getSslReq() {
        SSLReqBean out = new SSLReqBean();
        out.setHostNameVerifier(this.getSelectedHostnameVerifier());
        out.setTrustAllCerts(this.jcb_ssl_trust_self_signed_cert.isSelected());
        SSLKeyStore trustStore = this.jp_truststore.getKeyStore();
        out.setTrustStore(trustStore);
        SSLKeyStore keyStore = this.jp_keystore.getKeyStore();
        out.setKeyStore(keyStore);
        return out;
    }

    @Override
    public void setSslReq(SSLReq sslReq) {
        switch (sslReq.getHostNameVerifier()) {
            case ALLOW_ALL: {
                this.jcb_disable_hostname_verifier.setSelected(true);
                break;
            }
            default: {
                this.jcb_disable_hostname_verifier.setSelected(false);
            }
        }
        this.jcb_ssl_trust_self_signed_cert.setSelected(sslReq.isTrustAllCerts());
        this.jp_truststore.setKeyStore(sslReq.getTrustStore());
        this.jp_keystore.setKeyStore(sslReq.getKeyStore());
    }

    @Override
    public void clear() {
        this.jcb_disable_hostname_verifier.setSelected(false);
        this.jcb_ssl_trust_self_signed_cert.setSelected(false);
        this.jp_truststore.clear();
        this.jp_keystore.clear();
    }

    @PostConstruct
    protected void init() {
        this.setLayout(new BorderLayout(5, 2));
        JTabbedPane jtp_ssl = new JTabbedPane();
        JPanel jpGrid = new JPanel(new GridLayout(2, 1));
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout(0));
        jp.add(this.jcb_ssl_trust_self_signed_cert);
        jpGrid.add(jp);
        jp = new JPanel();
        jp.setLayout(new FlowLayout(0));
        jp.add(this.jcb_disable_hostname_verifier);
        jpGrid.add(jp);
        jtp_ssl.addTab("General", UIUtil.getFlowLayoutPanelLeftAligned(jpGrid));
        this.jp_truststore.setLabel("Truststore:");
        this.jp_truststore.setTitle("Enter Truststore Details");
        this.jp_keystore.setLabel("Keystore:");
        this.jp_keystore.setTitle("Enter Keystore Details");
        JPanel jp_grid = new JPanel(new GridLayout(2, 1));
        jp_grid.add(this.jp_truststore);
        jp_grid.add(this.jp_keystore);
        jtp_ssl.addTab("Truststore / Keystore", UIUtil.getFlowLayoutPanelLeftAligned(jp_grid));
        this.add(jtp_ssl);
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

