require 'test/unit'

module Borges;end
require 'Borges/Callback/Callback'

class CallbackTest < Test::Unit::TestCase

  def setup
    @callback = Borges::Callback.new
  end

  def test_action_callback?
    assert((not @callback.action_callback?), "Not an action callback")
  end

  def test_dispatch_callback?
    assert((not @callback.dispatch_callback?), "Not an dispatch callback")
  end

  def test_value_callback?
    assert((not @callback.value_callback?), "Not an value callback")
  end

  def test_abstract_class
    assert_raises(NoMethodError, "Callback is abstract") do
      @callback.evaluate nil, nil
    end
  end

end # class CallbackTest


