#
# protect.rb
#
#   Copyright (c) 1999-2002 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#
#   $Id: protect.rb,v 1.2 2002/01/05 06:19:34 aamine Exp $
#

def protect( place = nil )
  begin
    yield
  rescue StandardError, ScriptError
    $stderr.puts 'Error in ' + place if place
    print_backtrace $!
    nil
  end
end

def print_backtrace( err )
  $stderr.print err.to_s, " (#{err.type})\n"
  err.backtrace.each {|i| $stderr.puts i }
end
