#!/usr/bin/env ruby

# This file is a sample based on AmazonSearchServiceClient.rb, which can be
# generated by WSDL file and wsdl2ruby.rb.
#
# $ wsdl2ruby.rb --type client --force \
#   --wsdl http://soap.amazon.com/schemas3/AmazonWebServices.wsdl
#
# See wsdlDriver.rb to use WSDL file directly (slow).
require 'AmazonSearchDriver.rb'

endpoint_url = ARGV.shift
obj = AmazonSearchPort.new(endpoint_url)

# Uncomment the below line to see SOAP wiredumps.
# obj.wiredump_dev = STDERR

# SYNOPSIS
#   KeywordSearchRequest(keywordSearchRequest)
#
# ARGS
#   keywordSearchRequest		KeywordRequest - {urn:PI/DevCentral/SoapService}KeywordRequest
#
# RETURNS
#   return		ProductInfo - {urn:PI/DevCentral/SoapService}ProductInfo
#
# RAISES
#    N/A
#
keywordSearchRequest = KeywordRequest.new("Ruby Object", "1", "books", "webservices-20", "lite", "", "+salesrank")
obj.keywordSearchRequest(keywordSearchRequest).Details.each do |detail|
  puts "== #{detail.ProductName}"
  puts "Author: #{detail.Authors.join(", ")}"
  puts "Release date: #{detail.ReleaseDate}"
  puts "List price: #{detail.ListPrice}, our price: #{detail.OurPrice}"
  puts
end
