module AcceptanceTests
  module Matchers
    # rubocop:disable Naming/PredicateName
    def have_output(output)
      HaveOutputMatcher.new(output)
    end
    # rubocop:enable Naming/PredicateName

    class HaveOutputMatcher
      def initialize(output)
        @output = output
      end

      def matches?(runner)
        @runner = runner
        runner.has_output?(output)
      end

      def failure_message
        "Expected command to have output, but did not.\n\n" +
          "Command: #{runner.formatted_command}\n\n" +
          "Expected output:\n" +
          output.inspect + "\n\n" +
          "Actual output:\n" +
          runner.output
      end

      protected

      attr_reader :output, :runner
    end
  end
end
