'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH sunrpc n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
sunrpc \- Call and probe selected Sun RPC services.
.BE

.SH DESCRIPTION
The \fBsunrpc\fR command allows to call and probe selected Sun RPC
(RFC 1831, RFC 1832) services.

.SH SUNRPC COMMAND
.TP
.B sunrpc info \fIhost\fR
The \fBsunrpc info\fR command returns a list of all registered Sun RPC
services on \fIhost\fR. Each list element contains the program number,
the program version, the protocol name, the port number and the name
of the RPC service. The command fails, if \fIhost\fR is unknown or if
the portmapper does not respond to our request.
.TP
.B sunrcp probe \fIhost\fR \fIprogram\fR \fIversion\fR \fIprotocol\fR
The \fBsunrcp probe\fR command tests a Sun RPC service identified by
\fIprogram\fR \fIversion\fR \fIprotocol\fR on \fIhost\fR by calling
procedure 0. This procedure returns a list of two elements. The first
element is the time needed to complete the RPC call and the second
element is a string which describes if the probe was successful.
.TP
.B sunrpc stat \fIhost\fR
The \fBsunrpc stat\fR command makes an rstat RPC call to \fIhost\fR
and returns a list of name type value triples describing the status of
the machine. This command fails if \fIhost\fR is not reachable or does
not support the rstat service.
.TP
.B sunrpc mount \fIhost\fR
The \fBsunrpc mount\fR command retrieves a list of all NFS file systems 
currently mounted from \fIhost\fR. Each element of this list includes
the directory name and the host which exports the directory.
.TP
.B sunrpc exports \fIhost\fR
The \fBsunrpc exports\fR command retrieves a list of all NFS file
systems exported by \fIhost\fR. Each element of this list contains the
exported directory name and the list of hosts that are allowed to
mount the exported directory. An empty host list means that an
exported directory can be mounted by everyone.
.TP
.B sunrpc ether \fIhost\fR \fBopen
.ns
.TP
.B sunrpc ether \fIhost\fR
.ns
.TP
.B sunrpc ether \fIhost\fR \fBclose
The \fBsunrpc ether\fR command allows to query an etherd daemon for
ethernet statistics. You first have to register at the remote etherd
using the \fBopen\fR command option. Afterwards, you can query the
etherd which will return a list of name type value triples describing
the packets counted since the last query. You should unregister at the
remote etherd using the \fBclose\fR option once you are no longer
interested in ethernet statistics.
.TP
.B sunrpc pcnfs \fIhost\fB info \fR[\fIarray\fR]
.ns
.TP
.B sunrpc pcnfs \fIhost\fB list \fR[\fIarray\fR]
.ns
.TP
.B sunrpc pcnfs \fIhost\fB queue \fIprinter\fB \fR[\fIarray\fR]
.ns
.TP
.B sunrpc pcnfs \fIhost\fB status \fIprinter\fB \fIarray\fR
The \fBsunrpc pcnfs\fR command allows to retrieve printer status
information provided by the pcnfsd daemon. The first command retrieves
the daemon identification. The optional \fIarray\fR variable will be
filled with details about the supported procedures. The second command
returns the list of all printer names known by the pcnsfd daemon on
\fIhost\fR. The optional \fIarray\fR is indexed by printer name and
contains additional information about each printer. The queue
subcommand retrieves the \fIprinter\fR queue and returns the actual
queue length. Information about queued print jobs is written to the
\fIarray\fR variable if given. The array is indexed by the queue
position and contains information about the print job in key value
pairs. The last pcnfs command retrieves \fIprinter\fR specific status
information about the printer itself. The status is written into the
\fIarray\fR variable.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
