package Lirs;

use strict;
use vars qw(@ISA);
use Container::Item;
use DateTime::Format;

@ISA = qw(Container::Item);

attributes qw();

################################################################
sub SetByLine($$)
{
    my ($self, $line) = @_;

    chomp $line;
    # LIRS쥳ɥإå,(Last-ModifiedGMT),(Last-DetectedGMT),оݥȤGMTȤθ(),оݥȤ(Content-LengthХ),оݥȤURL,оݥȤΥȥ,оݥȤδ̾,ȤURL,(ĥ...),(\r)\n
    my ($head, $lm, $lmd, $tz_sec, $cl, $url, $title, $author, $remote, $keyword) = split(/,/, $line);
    $self->Set('Last-Modified', time2str_gen($lm, 'GMT'));
    $self->Set('Last-Modified-Detected', time2str_gen($lmd, 'GMT'));
    $self->Set('Expire', time2str_gen($lmd+ 3*3600, 'GMT')); # yet
    $self->Set('Content-Length', $cl);
    $self->Set('Url', $url);
    $self->Set('Title', $title);
    $self->Set('Author-Name', $author);
    $self->Set('Keyword', $keyword);
    $self->Set('Authorized-Url', $remote);

#    print "$line: $title, $url, $lm\n";
}
sub AsLirs($)
{
    my $self = shift;

    sprintf("LIRS,%d,%d,32400,%d,%s,%s,%s,%s,%s\r\n", # yet JST
	    str2time($self->Value('Last-Modified')),
	    str2time($self->Value('Last-Modified-Detected')),
	    $self->Value('Content-Length'),
	    $self->Value('Url'),
	    $self->Value('Title'),
	    $self->Value('Author-Name'),
	    $self->Value('Authorized-Url'),
	    $self->Value('Keyword'));
}
1;
