/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CLASS_REPOSITORY_H
#define CLASS_REPOSITORY_H

#include "jni.h"
#include "ClazzFile.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct class_list class_list;

  /* some function prototypes */

  extern void initialize_class_repository(JavaVM *vm);
  extern void destroy_class_repository(JavaVM *vm);
  extern void add_class_to_repository(JNIEnv *env, ClazzFile *classfile, char *name);
  extern void delete_class_from_repository(JNIEnv *env, char *name);
  extern ClazzFile *find_class_in_repository(JNIEnv *env, char *name);

  jint get_num_loaded_classes(JNIEnv *env);
  void get_loaded_classes(JNIEnv *env, jclass *classes);

  /* useful for garbage collection */
  typedef void (*repository_entry_func)(void *arg);
  void map_over_repository(JavaVM *vm, repository_entry_func func);

  void dump_class_repository(JNIEnv *env);

#ifdef __cplusplus
};
#endif

#endif /* CLASS_REPOSITORY_H */

