"""DICOM private dictionary auto-generated by generate_private_dict.py.

Data generated from GDCM project's private dictionary.

The outer dictionary key is the Private Creator name ("owner"), while the inner
dictionary key is a map of DICOM tag to (VR, VM, name, is_retired).
"""
from typing import Dict, Tuple


private_dictionaries: Dict[str, Dict[str, Tuple[str, str, str, str]]] = {
    '1.2.840.113663.1': {
        '0029xx00': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('US', '1', 'Unknown', ''),  # noqa
    },
    '1.2.840.113681': {
        '0019xx10': ('ST', '1', 'CR Image Params Common', ''),  # noqa
        '0019xx11': ('ST', '1', 'CR Image IP Params Single', ''),  # noqa
        '0019xx12': ('ST', '1', 'CR Image IP Params Left', ''),  # noqa
        '0019xx13': ('ST', '1', 'CR Image IP Params Right', ''),  # noqa
    },
    '1.2.840.113708.794.1.1.2.0': {
        '0087xx10': ('CS', '1', 'Media Type', ''),  # noqa
        '0087xx20': ('CS', '1', 'Media Location', ''),  # noqa
        '0087xx30': ('ST', '1', 'Storage File ID', ''),  # noqa
        '0087xx40': ('DS', '1', 'Study or Image Size in MB', ''),  # noqa
        '0087xx50': ('IS', '1', 'Estimated Retrieve Time', ''),  # noqa
    },
    '2.16.840.1.114059.1.1.6.1.50.1': {
        '0029xx20': ('LT', '1', 'Description', ''),  # noqa
        '0029xx21': ('ST', '1', 'Orientation', ''),  # noqa
        '0029xx22': ('ST', '1', 'Parameter 1', ''),  # noqa
        '0029xx23': ('ST', '1', 'Parameter 2', ''),  # noqa
        '0029xx24': ('LO', '1', 'Teeth', ''),  # noqa
        '0029xx25': ('LO', '1', 'Jaw', ''),  # noqa
        '0029xx26': ('LO', '1', 'Quadrant', ''),  # noqa
        '0029xx27': ('LO', '1', 'CRC', ''),  # noqa
    },
    'A.L.I. Technologies, Inc.': {
        '3711xx01': ('LO', '1', 'Filename', ''),  # noqa
        '3711xx02': ('OB', '1', 'Data Blob of a Visit', ''),  # noqa
        '3711xx03': ('US', '1', 'Revision Number', ''),  # noqa
        '3711xx04': ('UL', '1', 'Unix Timestamp', ''),  # noqa
        '3711xx05': ('IS', '1', 'Bag ID', ''),  # noqa
        '3711xx0c': ('UI', '1', 'Original Study UID', ''),  # noqa
        '3711xx0d': ('US', '1', 'Overlay Grayscale Value', ''),  # noqa
        '3711xx0e': ('CS', '1', 'Anonymization Status', ''),  # noqa
    },
    'ACUSON': {
        '0009xx00': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx01': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx02': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx03': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx04': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx05': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx06': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx07': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx08': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xx09': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xx0a': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx0b': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx0c': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx0d': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx0e': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx0f': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx10': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx11': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx12': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx13': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx14': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xx15': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'ACUSON: 1.2.840.11386.1.0': {
        '7fdfxx00': ('IS', '1', 'Lossy Compression Ratio', ''),  # noqa
        '7fdfxx01': ('US', '1', 'Image Format', ''),  # noqa
        '7fdfxx02': ('US', '1', 'Acuson Region Type', ''),  # noqa
        '7fdfxx0b': ('UL', '1', 'Acuson Image Apex X', ''),  # noqa
        '7fdfxx0c': ('UL', '1', 'Acuson Image Apex Y', ''),  # noqa
        '7fdfxx0d': ('IS', '1', 'B-Color-On Flag', ''),  # noqa
    },
    'ACUSON:1.2.840.113680.1.0:0921': {
        '0009xx20': ('UN', '1', 'View Name', ''),  # noqa
        '0009xx2a': ('UN', '1', 'View List', ''),  # noqa
    },
    'ACUSON:1.2.840.113680.1.0:7f10': {
        '7fdfxx00': ('UN', '1', 'Lossy Compression Ratio', ''),  # noqa
        '7fdfxx01': ('UN', '1', 'Image Format', ''),  # noqa
        '7fdfxx02': ('UN', '1', 'Acuson Region Type', ''),  # noqa
        '7fdfxx0b': ('UN', '1', 'Acuson Image Apex X', ''),  # noqa
        '7fdfxx0c': ('UN', '1', 'Acuson Image Apex Y', ''),  # noqa
        '7fdfxx0d': ('UN', '1', 'B-Color-On Flag', ''),  # noqa
        '7fdfxx0e': ('UN', '1', 'Acuson Mechanical Apex X', ''),  # noqa
        '7fdfxx0f': ('UN', '1', 'Acuson Mechanical Apex Y', ''),  # noqa
        '7fdfxx10': ('UN', '1', 'Acquisition Type:', ''),  # noqa
        '7fdfxx18': ('UN', '1', 'Transformation Matrix Sequence', ''),  # noqa
        '7fdfxx20': ('UN', '1', 'Left angle', ''),  # noqa
        '7fdfxx22': ('UN', '1', 'Right angle', ''),  # noqa
        '7fdfxx24': ('UN', '1', 'Color Map Family', ''),  # noqa
        '7fdfxx25': ('UN', '1', 'Full Colormap.', ''),  # noqa
        '7fdfxx26': ('UN', '1', 'Color Invert', ''),  # noqa
        '7fdfxx27': ('UN', '1', 'Color Baseline', ''),  # noqa
        '7fdfxx28': ('UN', '1', 'CD Color Mix Points X1', ''),  # noqa
        '7fdfxx29': ('UN', '1', 'CD Color Mix Points Y1', ''),  # noqa
        '7fdfxx2a': ('UN', '1', 'CD Color Mix Points X2', ''),  # noqa
        '7fdfxx2b': ('UN', '1', 'CD Color Mix Points Y2', ''),  # noqa
        '7fdfxx2c': ('UN', '1', 'Color Accent', ''),  # noqa
        '7fdfxx30': ('UN', '1', 'Persistence SQ', ''),  # noqa
        '7fdfxx31': ('UN', '1', 'Persistence Mode', ''),  # noqa
        '7fdfxx32': ('UN', '1', 'Persistence Coefficient Mode', ''),  # noqa
        '7fdfxx33': ('UN', '1', 'Alpha coefficient', ''),  # noqa
        '7fdfxx34': ('UN', '1', 'Gamma coefficient', ''),  # noqa
        '7fdfxx35': ('UN', '1', 'Persistence Time Flag', ''),  # noqa
        '7fdfxx36': ('UN', '1', 'Persistence adaptive flag', ''),  # noqa
        '7fdfxx37': ('UN', '1', 'Persistence Frame Rate', ''),  # noqa
        '7fdfxx38': ('UN', '1', 'Persistence ID', ''),  # noqa
        '7fdfxx40': ('UN', '1', 'Observation Date Time SQ', ''),  # noqa
        '7fdfxx50': ('UN', '1', 'Capture Type Name', ''),  # noqa
        '7fdfxx52': ('UN', '1', 'Capture Type Number', ''),  # noqa
        '7fdfxx54': ('UN', '1', 'Number of Capture Types', ''),  # noqa
        '7fdfxx60': ('UN', '1', 'CD Steering Angle', ''),  # noqa
        '7fdfxx61': ('UN', '1', 'CD PRI', ''),  # noqa
        '7fdfxx62': ('UN', '1', 'CD Dynamic Range', ''),  # noqa
        '7fdfxx63': ('UN', '1', 'CD Velocity Scale Min', ''),  # noqa
        '7fdfxx64': ('UN', '1', 'CD Velocity Scale Max', ''),  # noqa
        '7fdfxx65': ('UN', '1', 'CD Color Mode', ''),  # noqa
        '7fdfxx66': ('UN', '1', 'CD Frequency', ''),  # noqa
        '7fdfxx67': ('UN', '1', 'CD Balance', ''),  # noqa
        '7fdfxx68': ('UN', '1', 'CD Delta', ''),  # noqa
        '7fdfxx69': ('UN', '1', 'CD Pan Box Min X0', ''),  # noqa
        '7fdfxx6a': ('UN', '1', 'CD Pan Box Min Y0', ''),  # noqa
        '7fdfxx6b': ('UN', '1', 'CD Pan Box Min X1', ''),  # noqa
        '7fdfxx6c': ('UN', '1', 'CD Pan Box Min Y1', ''),  # noqa
        '7fdfxx6d': ('UN', '1', 'CPS Map Type', ''),  # noqa
        '7fdfxx6e': ('UN', '1', 'CPS Map Data', ''),  # noqa
        '7fdfxx6f': ('UN', '1', 'CPS Balance Setting', ''),  # noqa
        '7fdfxx70': ('UN', '1', '3DCard Step Angle', ''),  # noqa
        '7fdfxx71': ('UN', '1', '3DCard Xdcr Angle', ''),  # noqa
        '7fdfxx72': ('UN', '1', 'B-mode Frequency', ''),  # noqa
        '7fdfxx73': ('UN', '1', 'B-mode Dynamic Range', ''),  # noqa
        '7fdfxx74': ('UN', '1', 'B-mode Frame Rate', ''),  # noqa
        '7fdfxx75': ('UN', '1', 'B-mode Space Time', ''),  # noqa
        '7fdfxx76': ('UN', '1', 'B-mode Persistence', ''),  # noqa
        '7fdfxx77': ('UN', '1', 'B-mode Display Depth Start', ''),  # noqa
        '7fdfxx78': ('UN', '1', 'B-mode Display Depth End', ''),  # noqa
        '7fdfxx79': ('UN', '1', 'B-mode Res Mode', ''),  # noqa
        '7fdfxx7a': ('UN', '1', 'B-mode Preset Application', ''),  # noqa
        '7fdfxx7b': ('UN', '1', 'Image Spec Name', ''),  # noqa
        '7fdfxx7c': ('UN', '1', 'B Preset Image Look', ''),  # noqa
        '7fdfxx7d': ('UN', '1', 'B-mode Post Processing', ''),  # noqa
        '7fdfxx7e': ('UN', '1', 'B Edge', ''),  # noqa
        '7fdfxx7f': ('UN', '1', 'B Delta', ''),  # noqa
        '7fdfxx80': ('UN', '1', 'B-mode 1D Post Processing Curve', ''),  # noqa
        '7fdfxx81': ('UN', '1', 'B-mode Delta (ECRI) Map Diagonal', ''),  # noqa
        '7fdfxx82': ('UN', '1', 'Bytes Per Timestamp', ''),  # noqa
        '7fdfxx83': ('UN', '1', 'Microseconds in unit timestamp', ''),  # noqa
        '7fdfxx84': ('UN', '1', 'Start Stopwatch Timestamp', ''),  # noqa
        '7fdfxx85': ('UN', '1', 'Acoustic Frame Timestamp', ''),  # noqa
        '7fdfxx86': ('UN', '1', 'R-Wave Timestamp', ''),  # noqa
        '7fdfxx87': ('UN', '1', 'Last Destruction Timestamp', ''),  # noqa
        '7fdfxx88': ('UN', '1', 'Pixels Per Second', ''),  # noqa
        '7fdfxx89': ('UN', '1', 'ECG Reference Timestamp', ''),  # noqa
        '7fdfxx8a': ('UN', '1', 'ECG Sampling Interval (milliseconds)', ''),  # noqa
        '7fdfxx8b': ('UN', '1', 'ECG Sample Count', ''),  # noqa
        '7fdfxx8c': ('UN', '1', 'ECG Sample Size', ''),  # noqa
        '7fdfxx8d': ('UN', '1', 'ECG Data Value', ''),  # noqa
        '7fdfxx8e': ('UN', '1', 'Contrast/Active Image Indicator', ''),  # noqa
        '7fdfxx8f': ('UN', '1', 'Live Dual Mode Indicator', ''),  # noqa
        '7fdfxx90': ('UN', '1', '3DCard Clipset ID', ''),  # noqa
        '7fdfxx91': ('UN', '1', '3DCard HRWave Min', ''),  # noqa
        '7fdfxx92': ('UN', '1', '3DCard HRWave Max', ''),  # noqa
        '7fdfxx93': ('UN', '1', 'Perspective Capture Type', ''),  # noqa
        '7fdfxxf1': ('UN', '1', 'Trigger Mask.', ''),  # noqa
        '7fdfxxf2': ('UN', '1', 'Study Directory', ''),  # noqa
        '7fdfxxf3': ('UN', '1', 'Last Modify Date', ''),  # noqa
        '7fdfxxf4': ('UN', '1', 'Last Modify Time', ''),  # noqa
        '7fdfxxf5': ('UN', '1', 'Teaching Study', ''),  # noqa
        '7fdfxxf6': ('UN', '1', 'Series Base UID', ''),  # noqa
    },
    'ACUSON:1.2.840.113680.1.0:7ffe': {
        '7fdfxx00': ('UN', '1', 'Data Padding', ''),  # noqa
    },
    'ADAC_IMG': {
        '0019xx02': ('IS', '1', 'Ver200 ADAC Pegasys File Size', ''),  # noqa
        '0019xx10': ('LO', '2', 'ADAC Header Signature', ''),  # noqa
        '0019xx11': ('US', '1', 'Number of ADAC Headers', ''),  # noqa
        '0019xx12': ('IS', '1-n', 'ADAC Header/Image Sizes', ''),  # noqa
        '0019xx20': ('OB', '1', 'ADAC Pegasys Headers', ''),  # noqa
        '0019xx21': ('US', '1', 'Ver200 Number of ADAC Headers', ''),  # noqa
        '0019xx41': ('IS', '1-n', 'Ver200 ADAC Header/Image Size', ''),  # noqa
        '0019xx61': ('OB', '1', 'Ver200 ADAC Pegasys Headers', ''),  # noqa
        '7043xx00': ('SH', '1', 'Cardiac Stress State', ''),  # noqa
        '7043xx10': ('LO', '1', 'Philips NM Private Group', ''),  # noqa
    },
    'AEGIS_DICOM_2.00': {
        '0003xx00': ('US', '1-n', 'Unknown', ''),  # noqa
        '0005xx00': ('US', '1-n', 'Unknown', ''),  # noqa
        '0009xx00': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx00': ('US', '1-n', 'Unknown', ''),  # noqa
        '0029xx00': ('US', '1-n', 'Unknown', ''),  # noqa
        '1369xx00': ('US', '1-n', 'Unknown', ''),  # noqa
    },
    'AGFA': {
        '0009xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx11': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx13': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx14': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx15': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx10': ('SH', '1', 'Private Identification Code', ''),  # noqa
        '0019xx11': ('LO', '3', 'Identification Data (Note 2)', ''),  # noqa
        '0019xx13': ('LO', '1', 'Sensitometry Name', ''),  # noqa
        '0019xx14': ('ST', '3', 'Window/Level List (Note 3)', ''),  # noqa
        '0019xx15': ('LO', '1', 'Dose Monitoring List', ''),  # noqa
        '0019xx16': ('LO', '3', 'Other Info (Note 5)', ''),  # noqa
        '0019xx1a': ('LO', '1', 'Clipped Exposure Deviation', ''),  # noqa
        '0019xx1b': ('LO', '1', 'Logarithmic PLT Full Scale', ''),  # noqa
        '0019xx60': ('US', '1', 'Total number of series', ''),  # noqa
        '0019xx61': ('SH', '1', 'Session Number', ''),  # noqa
        '0019xx62': ('SH', '1', 'ID Station name', ''),  # noqa
        '0019xx65': ('US', '1', 'Number of images in study to be transmitted (only sent with autoverify: on)', ''),  # noqa
        '0019xx70': ('US', '1', 'Total number of images', ''),  # noqa
        '0019xx80': ('ST', '1', 'Geometrical Transformations', ''),  # noqa
        '0019xx81': ('ST', '1', 'Roam Origin', ''),  # noqa
        '0019xx82': ('US', '1', 'Zoom factor', ''),  # noqa
        '0019xx93': ('CS', '1', 'Status', ''),  # noqa
    },
    'AGFA PACS Archive Mirroring 1.0': {
        '0031xx00': ('CS', '1', 'Unknown', ''),  # noqa
        '0031xx01': ('UL', '1', 'Unknown', ''),  # noqa
    },
    'AGFA-AG_HPState': {
        '0071xx18': ('SQ', '1', 'Unknown', ''),  # noqa
        '0071xx19': ('SQ', '1', 'Unknown', ''),  # noqa
        '0071xx1a': ('SQ', '1', 'Unknown', ''),  # noqa
        '0071xx1c': ('SQ', '1', 'Unknown', ''),  # noqa
        '0071xx1e': ('SQ', '1', 'Unknown', ''),  # noqa
        '0071xx20': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0071xx21': ('FD', '1-n', 'Unknown', ''),  # noqa
        '0071xx22': ('FD', '1-n', 'Unknown', ''),  # noqa
        '0071xx23': ('FD', '1-n', 'Unknown', ''),  # noqa
        '0071xx24': ('FD', '1', 'Unknown', ''),  # noqa
        '0073xx23': ('SH', '1', 'Unknown', ''),  # noqa
        '0073xx24': ('SQ', '1', 'Unknown', ''),  # noqa
        '0073xx28': ('SQ', '1', 'Unknown', ''),  # noqa
        '0073xx80': ('FL', '1', 'Unknown', ''),  # noqa
        '0075xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0087xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '0087xx02': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'AGFA_ADC_Compact': {
        '0019xx05': ('ST', '1', 'Data stream from cassette', ''),  # noqa
        '0019xx10': ('LO', '1', 'Private Identification Code', ''),  # noqa
        '0019xx30': ('ST', '1', 'Set of destination types', ''),  # noqa
        '0019xx40': ('ST', '1', 'Set of destination Ids', ''),  # noqa
        '0019xx50': ('ST', '1', 'Set of processing codes', ''),  # noqa
        '0019xx60': ('US', '1', 'Number of series in study', ''),  # noqa
        '0019xx61': ('US', '1', 'Session Number', ''),  # noqa
        '0019xx62': ('SH', '1', 'ID station name', ''),  # noqa
        '0019xx70': ('US', '1', 'Number of images in series', ''),  # noqa
        '0019xx71': ('US', '1', 'Break condition', ''),  # noqa
        '0019xx72': ('US', '1', 'Wait (or Hold) flag', ''),  # noqa
        '0019xx73': ('US', '1', 'ScanRes flag', ''),  # noqa
        '0019xx74': ('SH', '1', 'Operation code', ''),  # noqa
        '0019xx95': ('CS', '1', 'Image quality', ''),  # noqa
    },
    'ALOKA:1.2.392.200039.103.2': {
        '0009xx00': ('SH', '1', 'Unknown', ''),  # noqa
        '0009xx04': ('US', '1-n', 'Unknown', ''),  # noqa
        '0009xx06': ('US', '1-n', 'Unknown', ''),  # noqa
        '0009xx0a': ('SH', '1', 'Unknown', ''),  # noqa
        '0009xx20': ('CS', '1', 'Unknown', ''),  # noqa
        '0009xx22': ('CS', '1', 'Unknown', ''),  # noqa
        '0009xx24': ('CS', '1', 'Unknown', ''),  # noqa
        '0009xx26': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx28': ('IS', '1', 'Unknown', ''),  # noqa
        '0009xx2a': ('DS', '1', 'Unknown', ''),  # noqa
        '0009xx30': ('FD', '1', 'Unknown', ''),  # noqa
        '0009xx32': ('DS', '1', 'Unknown', ''),  # noqa
        '0009xx34': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx08': ('FD', '1', 'Unknown', ''),  # noqa
        '0019xx0c': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx0e': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx18': ('SL', '1', 'Unknown', ''),  # noqa
        '0019xx1a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('SS', '1', 'Unknown', ''),  # noqa
        '0019xx46': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx50': ('SL', '1', 'Unknown', ''),  # noqa
        '0019xx52': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx54': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx56': ('FD', '1', 'Unknown', ''),  # noqa
    },
    'AMI Annotations_01': {
        '3101xx10': ('SQ', '1', 'AMI Annotation Sequence (RET)', ''),  # noqa
    },
    'AMI Annotations_02': {
        '3101xx20': ('SQ', '1', 'AMI Annotation Sequence (RET)', ''),  # noqa
    },
    'AMI ImageContextExt_01': {
        '3107xxa0': ('CS', '1', 'AMI Window Function (RET)', ''),  # noqa
        '3107xxb0': ('DS', '1', 'AMI Window Slope (RET)', ''),  # noqa
    },
    'AMI ImageContext_01': {
        '3109xx10': ('CS', '1', 'AMI Window Invert (RET)', ''),  # noqa
        '3109xx20': ('IS', '1', 'AMI Window Center (RET)', ''),  # noqa
        '3109xx30': ('IS', '1', 'AMI Window Widith (RET)', ''),  # noqa
        '3109xx40': ('CS', '1', 'AMI Pixel Aspect Ratio Swap (RET)', ''),  # noqa
        '3109xx50': ('CS', '1', 'AMI Enable Averaging (RET)', ''),  # noqa
        '3109xx60': ('CS', '1', 'AMI Quality (RET)', ''),  # noqa
        '3109xx70': ('CS', '1', 'AMI Viewport Annotation Level (RET)', ''),  # noqa
        '3109xx80': ('CS', '1', 'AMI Show Image Annotation (RET)', ''),  # noqa
        '3109xx90': ('CS', '1', 'AMI Show Image Overlay (RET)', ''),  # noqa
    },
    'AMI ImageTransform_01': {
        '3107xx10': ('DS', '1', 'AMI Transformation Matrix (RET)', ''),  # noqa
        '3107xx20': ('DS', '1', 'AMI Center Offset (RET)', ''),  # noqa
        '3107xx30': ('DS', '1', 'AMI Magnification (RET)', ''),  # noqa
        '3107xx40': ('CS', '1', 'AMI Magnification Type (RET)', ''),  # noqa
        '3107xx50': ('DS', '1', 'AMI Displayed Area (RET)', ''),  # noqa
        '3107xx60': ('DS', '1', 'AMI Calibration Factor (RET)', ''),  # noqa
    },
    'AMI Sequence AnnotElements_01': {
        '3105xx10': ('DS', '1', 'AMI Annotation Element Position', ''),  # noqa
        '3105xx20': ('LT', '1', 'AMI Annotation Element Text', ''),  # noqa
    },
    'AMI Sequence Annotations_01': {
        '3103xx10': ('CS', '1', 'AMI Annotation Sequence (RET)', ''),  # noqa
        '3103xx20': ('UI', '1', 'AMI Annotation UID (RET)', ''),  # noqa
        '3103xx30': ('US', '1', 'AMI Annotation Color (RET)', ''),  # noqa
        '3103xx40': ('FD', '1', 'FontSize', ''),  # noqa
        '3103xx50': ('CS', '1', 'AMI Annotation Line Style (RET)', ''),  # noqa
        '3103xx60': ('SQ', '1', 'AMI Annotation Elements (RET)', ''),  # noqa
        '3103xx70': ('SH', '1', 'AMI Annotation Label (RET)', ''),  # noqa
        '3103xx80': ('PN', '1', 'AMI Annotation Creator (RET)', ''),  # noqa
        '3103xx90': ('PN', '1', 'AMI Annotation Modifiers (RET)', ''),  # noqa
        '3103xxa0': ('DA', '1', 'AMI Annotation Creation Date (RET)', ''),  # noqa
        '3103xxb0': ('TM', '1', 'AMI Annotation Creation Time (RET)', ''),  # noqa
        '3103xxc0': ('DA', '1', 'AMI Annotation Modification Dates (RET)', ''),  # noqa
        '3103xxd0': ('TM', '1', 'AMI Annotation Modification Times (RET)', ''),  # noqa
        '3103xxe0': ('US', '1', 'AMI Annotation Frame Number (RET)', ''),  # noqa
    },
    'AMI Sequence Annotations_02': {
        '3103xx10': ('CS', '1', 'AMI Annotation Sequence (RET)', ''),  # noqa
        '3103xx20': ('UI', '1', 'AMI Annotation UID (RET)', ''),  # noqa
        '3103xx30': ('US', '1', 'AMI Annotation Color (RET)', ''),  # noqa
        '3103xx50': ('CS', '1', 'AMI Annotation Line Style (RET)', ''),  # noqa
        '3103xx60': ('SQ', '1', 'AMI Annotation Elements (RET)', ''),  # noqa
        '3103xx70': ('SH', '1', 'AMI Annotation Label (RET)', ''),  # noqa
        '3103xx80': ('PN', '1', 'AMI Annotation Creator (RET)', ''),  # noqa
        '3103xx90': ('PN', '1', 'AMI Annotation Modifiers (RET)', ''),  # noqa
        '3103xxa0': ('DA', '1', 'AMI Annotation Creation Date (RET)', ''),  # noqa
        '3103xxb0': ('TM', '1', 'AMI Annotation Creation Time (RET)', ''),  # noqa
        '3103xxc0': ('DA', '1', 'AMI Annotation Modification Dates (RET)', ''),  # noqa
        '3103xxd0': ('TM', '1', 'AMI Annotation Modification Times (RET)', ''),  # noqa
        '3103xxe0': ('US', '1', 'AMI Annotation Frame Number (RET)', ''),  # noqa
    },
    'AMI StudyExtensions_01': {
        '3111xx01': ('UL', '1', 'AMI Last Released Annot Label (RET)', ''),  # noqa
    },
    'AMICAS0': {
        '0023xx01': ('UI', '1', '', ''),  # noqa
        '0023xx08': ('US', '1', '', ''),  # noqa
        '0023xx10': ('US', '1', '', ''),  # noqa
        '0023xx16': ('SL', '1', '', ''),  # noqa
    },
    'APEX_PRIVATE': {
        '0027xx10': ('LO', '1', 'Private Creator', ''),  # noqa
        '0027xx11': ('DS', '1', 'Bed Position', ''),  # noqa
    },
    'ATL HDI V1.0': {
        '0009xx00': ('UN', '1', 'Private', ''),  # noqa
        '0009xx10': ('UN', '1', 'Private', ''),  # noqa
        '0009xx20': ('UN', '1', 'Private', ''),  # noqa
        '0009xx30': ('UN', '1', 'Private', ''),  # noqa
        '0009xx40': ('UN', '1', 'Private', ''),  # noqa
        '0009xx50': ('UN', '1', 'Private', ''),  # noqa
        '0009xx60': ('UN', '1', 'Private', ''),  # noqa
        '0009xx70': ('UN', '1', 'Private', ''),  # noqa
        '0009xx80': ('UN', '1', 'Private', ''),  # noqa
        '0009xx90': ('UN', '1', 'Private', ''),  # noqa
        '0009xx91': ('UN', '1', 'Private', ''),  # noqa
        '0029xx30': ('UN', '1', 'Loop Mode', ''),  # noqa
        '0029xx31': ('UN', '1', 'Trigger mode', ''),  # noqa
        '0029xx32': ('UN', '1', 'Number of Loops', ''),  # noqa
        '0029xx33': ('UN', '1', 'Loop Indexes', ''),  # noqa
        '0029xx34': ('UN', '1', 'Loop Heart Rates', ''),  # noqa
        '0029xx35': ('UN', '1', 'Medications', ''),  # noqa
    },
    'ATL PRIVATE TAGS': {
        '0029xx30': ('UL', '1', 'Loop Mode', ''),  # noqa
        '0029xx31': ('UL', '1', 'Trigger mode', ''),  # noqa
        '0029xx32': ('UL', '1', 'Number of Loops', ''),  # noqa
        '0029xx33': ('DS', '1-n', 'Loop Indexes', ''),  # noqa
        '0029xx34': ('DS', '1-n', 'Loop Heart Rates', ''),  # noqa
        '0029xx35': ('LO', '1', 'Medications', ''),  # noqa
    },
    'Acuson X500': {
        '0009xx20': ('UN', '1', '(a)View Name', ''),  # noqa
        '0009xx2a': ('UN', '1', 'View List', ''),  # noqa
        '0011xx10': ('UN', '1', 'Siemens Medical', ''),  # noqa
        '0011xx11': ('UN', '1', 'DIMAQ Software', ''),  # noqa
        '0011xx20': ('UN', '1', 'Private Data', ''),  # noqa
        '0011xx21': ('UN', '1', 'Private Data', ''),  # noqa
        '0013xx10': ('UN', '1', 'Siemens Medical', ''),  # noqa
        '0013xx11': ('UN', '1', 'DIMAQ Software', ''),  # noqa
        '0013xx20': ('UN', '1', 'Private Data', ''),  # noqa
        '0015xx10': ('UN', '1', 'Siemens Medical', ''),  # noqa
        '0015xx11': ('UN', '1', 'DIMAQ Software', ''),  # noqa
        '0015xx20': ('UN', '1', 'Private Data', ''),  # noqa
        '0017xx10': ('UN', '1', 'Siemens Medical', ''),  # noqa
        '0017xx11': ('UN', '1', 'DIMAQ Software', ''),  # noqa
        '0017xx20': ('UN', '1', 'Private Data', ''),  # noqa
        '0019xx20': ('UN', '1', 'Import Structured', ''),  # noqa
    },
    'Agfa ADC NX': {
        '0019xx09': ('SQ', '1', 'Unknown', ''),  # noqa
        '0019xxf5': ('CS', '1', 'Cassette Orientation', ''),  # noqa
        '0019xxf6': ('DS', '1', 'Plate Sensitivity', ''),  # noqa
        '0019xxf7': ('DS', '1', 'Plate Erasability', ''),  # noqa
        '0019xxf8': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxfe': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'AgilityRuntime': {
        '0029xx11': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx12': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx13': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx14': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx1f': ('US', '1', 'Unknown', ''),  # noqa
    },
    'Applicare/Centricity Radiology Web/Version 1.0': {
        '4109xx01': ('SH', '1', 'Mammography Laterality', ''),  # noqa
        '4109xx02': ('SH', '1', 'Mammography View Name', ''),  # noqa
        '4109xx03': ('SH', '1', 'Mammography View Modifier', ''),  # noqa
    },
    'Applicare/Centricity Radiology Web/Version 2.0': {
        '4111xx01': ('CS', '1', 'Secondary Spine Label', ''),  # noqa
        '4111xx02': ('IS', '1', 'Additional tags for Presentation State', ''),  # noqa
    },
    'Applicare/Print/Version 5.1': {
        '4101xx01': ('UL', '1', '<internal', ''),  # noqa
        '4101xx02': ('SQ', '1', '<internal', ''),  # noqa
        '4101xx03': ('LO', '1', '<internal', ''),  # noqa
        '4101xx04': ('UL', '1', '<internal', ''),  # noqa
        '4101xx05': ('FD', '1', '<internal', ''),  # noqa
        '4101xx06': ('US', '1', '<internal', ''),  # noqa
        '4101xx07': ('US', '1', '<internal', ''),  # noqa
        '4101xx08': ('US', '1', '<internal', ''),  # noqa
        '4101xx09': ('US', '1', '<internal', ''),  # noqa
    },
    'Applicare/RadStore/Version 1.0': {
        '3113xx01': ('SL', '1', 'OBSOLETE', ''),  # noqa
        '3113xx02': ('SL', '1', 'Id1', ''),  # noqa
        '3113xx03': ('SL', '1', 'Id2', ''),  # noqa
        '3113xx04': ('SL', '1', 'Id3', ''),  # noqa
        '3113xx11': ('LO', '1', 'OBSOLETE', ''),  # noqa
        '3113xx12': ('CS', '1', 'State', ''),  # noqa
        '3113xx13': ('DT', '1', 'DateLastModified', ''),  # noqa
        '3113xx14': ('DT', '1', 'DateLastAccessed', ''),  # noqa
        '3113xx15': ('CS', '1', 'OBSOLETE', ''),  # noqa
        '3113xx16': ('FD', '1', 'ByteSize', ''),  # noqa
        '3113xx17': ('LO', '1', 'LibraryId', ''),  # noqa
        '3113xx18': ('LO', '1', 'Pathnames', ''),  # noqa
        '3113xx19': ('LO', '1', 'DriverPath', ''),  # noqa
        '3113xx1a': ('LO', '1', 'Source', ''),  # noqa
        '3113xx1b': ('LO', '1', 'Destination', ''),  # noqa
        '3113xx1c': ('SL', '1', 'MediumId', ''),  # noqa
        '3113xx1d': ('LO', '1', 'ArchiveId', ''),  # noqa
        '3113xx1e': ('LO', '1', 'Origin', ''),  # noqa
        '3113xx21': ('SL', '1', 'Version', ''),  # noqa
        '3113xx22': ('SL', '1', 'OBSOLETE', ''),  # noqa
        '3113xx23': ('ST', '1', 'InstanceFileLocation', ''),  # noqa
        '3113xx31': ('IS', '1', 'OBSOLETE', ''),  # noqa
        '3113xx32': ('IS', '1', 'OBSOLETE', ''),  # noqa
        '3113xx33': ('IS', '1', 'OBSOLETE', ''),  # noqa
        '3113xx35': ('LO', '1', 'ImageMediumLocation', ''),  # noqa
        '3113xx36': ('LO', '1', 'ImageMediumLabel', ''),  # noqa
        '3113xx37': ('CS', '1', 'ImageMediumState', ''),  # noqa
        '3113xx38': ('LO', '1', 'SeriesMediumLocation', ''),  # noqa
        '3113xx39': ('LO', '1', 'SeriesMediumLabel', ''),  # noqa
        '3113xx3a': ('CS', '1', 'SeriesMediumState', ''),  # noqa
        '3113xx3b': ('LO', '1', 'StudyMediumLocation', ''),  # noqa
        '3113xx3c': ('LO', '1', 'StudyMediumLabel', ''),  # noqa
        '3113xx3d': ('CS', '1', 'StudyMediumState', ''),  # noqa
        '3113xx52': ('CS', '1', 'StudyState', ''),  # noqa
        '3113xx53': ('CS', '1', 'SeriesState', ''),  # noqa
        '3113xx55': ('CS', '1', 'ImageStateText', ''),  # noqa
        '3113xx56': ('CS', '1', 'SeriesStateText', ''),  # noqa
        '3113xx57': ('CS', '1', 'StudyStateText', ''),  # noqa
        '3113xx60': ('DT', '1', 'Expiration', ''),  # noqa
        '3113xx69': ('AT', '1', 'DeletedTags', ''),  # noqa
    },
    'Applicare/RadWorks/Version 5.0': {
        '3109xx01': ('ST', '1', '<internal', ''),  # noqa
        '3109xx02': ('SH', '1', 'NEW/SEEN Status', ''),  # noqa
        '3109xx03': ('CS', '1', 'Delete Lock', ''),  # noqa
        '3109xx04': ('CS', '1', '<internal', ''),  # noqa
        '3109xx05': ('CS', '1', '<internal', ''),  # noqa
        '3109xx06': ('CS', '1', '<internal', ''),  # noqa
        '3109xx07': ('UL', '1', '<internal', ''),  # noqa
        '3109xx08': ('LO', '1', 'Receive Origin', ''),  # noqa
        '3109xx09': ('LO', '1', 'Folder', ''),  # noqa
        '3109xx0a': ('DA', '1', 'Receive Date', ''),  # noqa
        '3109xx0b': ('TM', '1', 'Receive Time', ''),  # noqa
        '3109xx0c': ('CS', '1', 'Prior', ''),  # noqa
        '3109xx0d': ('CS', '1', 'STAT Study', ''),  # noqa
        '3109xx0e': ('CS', '1', '<internal', ''),  # noqa
        '3109xx10': ('CS', '1', '<internal', ''),  # noqa
        '3109xx11': ('LO', '1', '<internal', ''),  # noqa
        '3109xx12': ('LO', '1', '<internal', ''),  # noqa
        '3109xx13': ('DA', '1', '<internal', ''),  # noqa
        '3109xx14': ('TM', '1', '<internal', ''),  # noqa
        '3109xx19': ('LO', '1', '<internal', ''),  # noqa
        '3109xx20': ('UI', '1', '<internal', ''),  # noqa
        '3109xx21': ('CS', '1', '<internal', ''),  # noqa
        '3109xx22': ('AE', '1', '<internal', ''),  # noqa
        '3109xx23': ('US', '1', '<internal', ''),  # noqa
        '3109xx24': ('LO', '1', '<internal', ''),  # noqa
        '3109xx25': ('LO', '1', '<internal', ''),  # noqa
        '3109xx26': ('UI', '1', '<internal', ''),  # noqa
        '3109xx27': ('SQ', '1', '<internal', ''),  # noqa
        '3109xx28': ('LO', '1', '<internal', ''),  # noqa
        '3109xx29': ('LO', '1', '<internal', ''),  # noqa
        '3109xx2a': ('LO', '1', 'Send Flag', ''),  # noqa
        '3109xx2b': ('LO', '1', 'Print Flag', ''),  # noqa
        '3109xx2c': ('LO', '1', 'Archive Flag', ''),  # noqa
        '3109xx30': ('LO', '1', '<internal', ''),  # noqa
        '3109xx31': ('CS', '1', '<internal', ''),  # noqa
        '3109xx32': ('CS', '1', '<internal', ''),  # noqa
        '3109xx33': ('CS', '1', 'Request Storage Commitment', ''),  # noqa
        '3109xx34': ('CS', '1', 'Requested Compression', ''),  # noqa
        '3109xx35': ('SQ', '1', '<internal', ''),  # noqa
        '3109xx36': ('LO', '1', '<internal', ''),  # noqa
        '3109xx37': ('UI', '1', '<internal', ''),  # noqa
        '3109xx38': ('SH', '1', '<internal', ''),  # noqa
        '3109xx39': ('SH', '1', '<internal', ''),  # noqa
        '3109xx40': ('IS', '1', '<internal', ''),  # noqa
        '3109xx41': ('CS', '1', '<internal', ''),  # noqa
        '3109xx42': ('CS', '1', '<internal', ''),  # noqa
        '3109xx43': ('CS', '1', 'Archive Status', ''),  # noqa
        '3109xxee': ('UI', '1', '<internal', ''),  # noqa
        '3109xxef': ('CS', '1', '<internal', ''),  # noqa
    },
    'Applicare/RadWorks/Version 6.0': {
        '4103xx01': ('AT', '1', 'Internal: non-existent tags', ''),  # noqa
        '4103xx02': ('UI', '1', 'Internal: non-existent objects', ''),  # noqa
        '4105xx01': ('CS', '1', 'Annotation Type', ''),  # noqa
        '4105xx02': ('DS', '1', 'Annotation Value', ''),  # noqa
        '4105xx03': ('UI', '1', 'Cutline Image UID', ''),  # noqa
        '4105xx04': ('UI', '1', 'Cutline Set UID', ''),  # noqa
        '4105xx05': ('US', '1', 'Annotation Color', ''),  # noqa
        '4105xx06': ('CS', '1', 'Annotation Line Style', ''),  # noqa
        '4105xx07': ('SH', '1', 'Annotation Label', ''),  # noqa
        '4105xx08': ('PN', '1', 'Annotation Creator', ''),  # noqa
        '4105xx09': ('DA', '1', 'Annotation Creation Date', ''),  # noqa
        '4105xx0a': ('TM', '1', 'Annotation Creation Time', ''),  # noqa
        '4105xx0b': ('SQ', '1', 'Annotation Modification Sequence', ''),  # noqa
        '4105xx0c': ('PN', '1', 'Annotation Modifier', ''),  # noqa
        '4105xx0d': ('DA', '1', 'Annotation Modification Date', ''),  # noqa
        '4105xx0e': ('TM', '1', 'Annotation Modification Time', ''),  # noqa
        '4105xx0f': ('LO', '1', 'Palette Color LUT Name', ''),  # noqa
        '4105xx10': ('US', '1', 'Annotation Number', ''),  # noqa
        '4107xx01': ('SQ', '1', 'Requested Palette Color LUT', ''),  # noqa
    },
    'Applicare/RadWorks/Version 6.0/Summary': {
        '3109xx11': ('ST', '1', 'Receive Origin Description', ''),  # noqa
        '3109xx12': ('ST', '1', 'Receive Origin Description', ''),  # noqa
    },
    'Applicare/Workflow/Version 1.0': {
        '3113xx01': ('CS', '1', '<internal', ''),  # noqa
        '3113xx10': ('SH', '1', '<internal', ''),  # noqa
        '3113xx11': ('SH', '1', '<internal', ''),  # noqa
        '3113xx12': ('LO', '1', '<internal', ''),  # noqa
        '3113xx15': ('SH', '1', '<internal', ''),  # noqa
        '3113xx16': ('SH', '1', '<internal', ''),  # noqa
        '3113xx17': ('LO', '1', '<internal', ''),  # noqa
        '3113xx20': ('SH', '1', '<internal', ''),  # noqa
        '3113xx21': ('SH', '1', '<internal', ''),  # noqa
        '3113xx22': ('LO', '1', '<internal', ''),  # noqa
        '3113xx25': ('SH', '1', '<internal', ''),  # noqa
        '3113xx26': ('SH', '1', '<internal', ''),  # noqa
        '3113xx27': ('LO', '1', '<internal', ''),  # noqa
        '3113xx30': ('UI', '1', '<internal', ''),  # noqa
        '3113xx31': ('UI', '1', '<internal', ''),  # noqa
        '3113xxe0': ('CS', '1', '<internal', ''),  # noqa
        '3113xxe1': ('CS', '1', '<internal', ''),  # noqa
        '3113xxe2': ('CS', '1', '<internal', ''),  # noqa
    },
    'BRIT Systems, Inc.': {
        '0021xx00': ('SQ', '1', 'Person Information Sequence', ''),  # noqa
        '0021xx01': ('LO', '1', 'Person ID', ''),  # noqa
        '0021xx02': ('PN', '1', 'Person Name', ''),  # noqa
        '0021xx03': ('LO', '1', 'Person Role', ''),  # noqa
        '0021xx04': ('SH', '1', 'Person Home Phone', ''),  # noqa
        '0021xx05': ('SH', '1', 'Person Work Phone', ''),  # noqa
        '0021xx06': ('SH', '1', 'Person Cell Phone', ''),  # noqa
        '0021xx07': ('SH', '1', 'Person Pager Phone', ''),  # noqa
        '0021xx08': ('SH', '1', 'Person Fax Phone', ''),  # noqa
        '0021xx09': ('LO', '1', 'Person EMail', ''),  # noqa
        '0021xx0a': ('ST', '1', 'Person Address', ''),  # noqa
        '0021xx0b': ('LO', '1', 'Person Password', ''),  # noqa
        '0021xx0c': ('SH', '1', 'Person Emergency Phone', ''),  # noqa
        '0021xx0d': ('LO', '1', 'Physician ID', ''),  # noqa
        '0021xx11': ('LO', '1', 'Original Patient ID', ''),  # noqa
        '0021xx12': ('UI', '1', 'Original Study Instance UID', ''),  # noqa
        '0021xx13': ('UI', '1', 'Original Series Instance UID', ''),  # noqa
        '0021xx14': ('LO', '1', 'Master Accession Number', ''),  # noqa
        '0021xx15': ('LO', '1', 'Order Category', ''),  # noqa
        '0021xx16': ('LO', '1', 'Patient ICN', ''),  # noqa
        '0021xx17': ('LO', '1', 'Patient DFS', ''),  # noqa
        '0021xx18': ('LO', '1', 'Patient Class', ''),  # noqa
        '0021xx19': ('LO', '1', 'Patient Type', ''),  # noqa
        '0021xx1f': ('LT', '1', 'Generic String', ''),  # noqa
        '0021xx20': ('LO', '1', 'QC Study Assigned By', ''),  # noqa
        '0021xx21': ('LO', '1', 'QC Study Split By', ''),  # noqa
        '0021xx22': ('LO', '1', 'QC Study Moved By', ''),  # noqa
        '0021xx23': ('LO', '1', 'QC Study Edited By', ''),  # noqa
        '0021xx24': ('LO', '1', 'QC Series Split By', ''),  # noqa
        '0021xx25': ('LO', '1', 'QC Series Moved By', ''),  # noqa
        '0021xx26': ('LO', '1', 'QC Series Edited By', ''),  # noqa
        '0021xx27': ('LO', '1', 'QC Image Moved By', ''),  # noqa
        '0021xx28': ('LO', '1', 'QC Image Edited By', ''),  # noqa
        '0021xx30': ('LO', '1', 'QC Done Time', ''),  # noqa
        '0021xx31': ('LO', '1', 'QC Last Modification Time', ''),  # noqa
        '0021xx32': ('LO', '1', 'QC Image Accepted By', ''),  # noqa
        '0021xx33': ('LO', '1', 'QC Image Rejected By', ''),  # noqa
        '0021xx34': ('DA', '1', 'QC Done Date', ''),  # noqa
        '0021xx50': ('LO', '1', 'QC Deletion Requested', ''),  # noqa
        '0021xx90': ('AE', '1', 'Original Sender AE Title', ''),  # noqa
        '0021xx91': ('LO', '1', 'Software Title', ''),  # noqa
        '0021xx92': ('SH', '1', 'Software Version', ''),  # noqa
        '0021xx93': ('LO', '1', 'Serial Number', ''),  # noqa
        '0021xxa0': ('SQ', '1', 'Object Action Sequence', ''),  # noqa
        '0021xxa1': ('ST', '1', 'Object Action', ''),  # noqa
        '0021xxa2': ('DA', '1', 'Object Action Date', ''),  # noqa
        '0021xxa3': ('TM', '1', 'Object Action Time', ''),  # noqa
        '0021xxa5': ('AE', '1', 'Local AE Title', ''),  # noqa
        '0021xxa6': ('SH', '1', 'Local IP Address', ''),  # noqa
        '0021xxa7': ('AE', '1', 'Remote AE Title', ''),  # noqa
        '0021xxa8': ('SH', '1', 'Remote IP Address', ''),  # noqa
    },
    'BioPri': {
        '0009xx00': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx01': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx02': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx03': ('LO', '1-n', 'Unknown', ''),  # noqa
        '0009xx04': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx05': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx07': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx08': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx09': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx10': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'BioPri3D': {
        '001110xx': ('UN', '1', 'Private Segmentation Data', ''),  # noqa
        '006310xx': ('UN', '1', 'Private Creator', ''),  # noqa
    },
    'BrainLAB_BeamProfile': {
        '3411xx01': ('SQ', '1', 'Beam Profile Sequence', ''),  # noqa
        '3411xx02': ('IS', '1', 'Beam Profile Number', ''),  # noqa
        '3411xx03': ('SQ', '1', 'Beam Parameter Sequence', ''),  # noqa
        '3411xx04': ('UT', '1', 'Parameter Description', ''),  # noqa
        '3411xx05': ('OB', '1', 'Parameter Data', ''),  # noqa
        '3411xx06': ('IS', '1', 'Referenced Beam Profile Number', ''),  # noqa
    },
    'BrainLAB_Conversion': {
        '0009xx01': ('LO', '1', 'Export Platform Name', ''),  # noqa
        '0009xx02': ('OB', '1', 'Export Platform Data', ''),  # noqa
    },
    'BrainLAB_PatientSetup': {
        '3273xx00': ('DS', '3', 'Isocenter Position', ''),  # noqa
        '3273xx01': ('CS', '1', 'Patient Position', ''),  # noqa
    },
    'CAMTRONICS': {
        '0029xx10': ('LT', '1', 'Commentline', ''),  # noqa
        '0029xx20': ('DS', '1', 'Edge Enhancement Coefficient', ''),  # noqa
        '0029xx50': ('LT', '1', 'Scene Text', ''),  # noqa
        '0029xx60': ('LT', '1', 'Image Text', ''),  # noqa
        '0029xx70': ('IS', '1', 'Pixel Shift Horizontal', ''),  # noqa
        '0029xx80': ('IS', '1', 'Pixel Shift Vertical', ''),  # noqa
        '0029xx90': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'CAMTRONICS IP': {
        '0029xx10': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx20': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx30': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx40': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'CARDIO-D.R. 1.0': {
        '0009xx00': ('UL', '1', 'File Location', ''),  # noqa
        '0009xx01': ('UL', '1', 'File Size', ''),  # noqa
        '0009xx40': ('SQ', '1', 'Alternate Image Sequence', ''),  # noqa
        '0019xx00': ('CS', '1-2', 'Image Blanking Shape', ''),  # noqa
        '0019xx02': ('IS', '1', 'Image Blanking Left Vertical Edge', ''),  # noqa
        '0019xx04': ('IS', '1', 'Image Blanking Right Vertical Edge', ''),  # noqa
        '0019xx06': ('IS', '1', 'Image Blanking Upper Horizontal Edge', ''),  # noqa
        '0019xx08': ('IS', '1', 'Image Blanking Lower Horizontal Edge', ''),  # noqa
        '0019xx10': ('IS', '2', 'Center Of Circular Image Blanking', ''),  # noqa
        '0019xx12': ('IS', '1', 'Radius Of Circular Image Blanking', ''),  # noqa
        '0019xx30': ('UL', '1', 'Maximum Frame Size', ''),  # noqa
        '0021xx13': ('IS', '1', 'Image Sequence Number', ''),  # noqa
        '0029xx00': ('SQ', '1', 'Standard Edge Enhancement Sequence', ''),  # noqa
        '0029xx01': ('US', '2', 'Convolution Kernel Size', ''),  # noqa
        '0029xx02': ('US', '1-n', 'Convolution Kernel Coefficients', ''),  # noqa
        '0029xx03': ('FL', '1', 'Edge Enhancement Gain', ''),  # noqa
    },
    'CARDIO-SMS 1.0': {
        '0009xx02': ('OB', '1', 'Private Data', ''),  # noqa
        '0009xx03': ('OB', '1', 'Private Data', ''),  # noqa
        '0009xx04': ('OB', '1', 'Private Data', ''),  # noqa
        '0009xx05': ('OB', '1', 'Private Data', ''),  # noqa
        '0009xx06': ('OB', '1', 'Private Data', ''),  # noqa
        '0009xx08': ('OB', '1', 'ACOM flags', ''),  # noqa
        '0009xx0a': ('UN', '1', 'Private Data', ''),  # noqa
        '0009xx0b': ('UN', '1', 'Private Data', ''),  # noqa
        '0009xx0c': ('UN', '1', 'Private Data', ''),  # noqa
        '0029xx80': ('SQ', '1', 'Private Data', ''),  # noqa
        '0031xx01': ('UN', '1', 'Private Data stream', ''),  # noqa
    },
    'CEMAX-ICON': {
        '0019xx00': ('LT', '1', 'CR Processing Parameters', ''),  # noqa
        '0019xx10': ('LO', '1', 'CR Exposure Menu Code', ''),  # noqa
        '0019xx20': ('LO', '1', 'CR Exposure Menu String', ''),  # noqa
        '0019xx30': ('LO', '1', 'CR EDR Mode', ''),  # noqa
        '0019xx40': ('LO', '1', 'CR Latitude', ''),  # noqa
        '0019xx50': ('LO', '1', 'CR Group Number', ''),  # noqa
        '0019xx60': ('LO', '1', 'CR Equipment ID', ''),  # noqa
        '0019xx70': ('LO', '1', 'CR Image Serial Number', ''),  # noqa
        '0019xx80': ('LO', '1', 'CR Bar Code Number', ''),  # noqa
        '0019xx90': ('LO', '1', 'CR Film Output Exposure', ''),  # noqa
        '0029xx00': ('LO', '1', 'Key Image', ''),  # noqa
        '0029xx10': ('LT', '1-n', 'Note', ''),  # noqa
        '0029xx20': ('SQ', '1', 'Annotation Sequence', ''),  # noqa
        '0029xx30': ('IS', '1', 'X Start Position', ''),  # noqa
        '0029xx40': ('IS', '1', 'Y Start Position', ''),  # noqa
        '0029xx50': ('IS', '1', 'X End Position', ''),  # noqa
        '0029xx60': ('IS', '1', 'Y End Position', ''),  # noqa
        '0029xx70': ('LO', '1', 'Annotation Text', ''),  # noqa
        '0029xx80': ('IS', '1', 'Which Marker', ''),  # noqa
        '0029xx90': ('SQ', '1', 'Annotation Sequence', ''),  # noqa
        '0029xx91': ('IS', '1-n', 'X Coordinates', ''),  # noqa
        '0029xx92': ('IS', '1-n', 'Y Coordinates', ''),  # noqa
        '0029xx93': ('IS', '1', 'Annotation Type', ''),  # noqa
        '0029xx94': ('IS', '1', 'Number of points', ''),  # noqa
        '0029xx95': ('IS', '1', 'Fill Type', ''),  # noqa
        '3033xx00': ('CS', '1', 'Study Priority Status', ''),  # noqa
    },
    'Canon Inc.': {
        '0019xx10': ('OB', '1', 'Canon Internal Data 1', ''),  # noqa
        '0019xx13': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx15': ('DS', '2', 'Unknown', ''),  # noqa
        '0019xx16': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx17': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx18': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx19': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx1a': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx1b': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx1c': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx1e': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx1f': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx21': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx60': ('US', '1', 'Performed number of series', ''),  # noqa
        '0019xx70': ('US', '1', 'Performed number of images', ''),  # noqa
        '0019xx7f': ('OB', '1', 'Canon Internal Data 111', ''),  # noqa
    },
    'DIDI TO PCR 1.1': {
        '0019xx00': ('LT', '1', 'Post Mode String', ''),  # noqa
        '0019xx01': ('LT', '1', 'Post Data', ''),  # noqa
        '0019xx10': ('LT', '1', 'Image Header', ''),  # noqa
        '0019xx22': ('LO', '1', 'Route AET', ''),  # noqa
        '0019xx23': ('DS', '1', 'PCR Print Scale', ''),  # noqa
        '0019xx24': ('ST', '1', 'PCR Print Job End', ''),  # noqa
        '0019xx25': ('IS', '1', 'PCR No Film Copies', ''),  # noqa
        '0019xx26': ('IS', '1', 'PCR Film Layout Position', ''),  # noqa
        '0019xx27': ('ST', '1', 'PCR Print Report Name', ''),  # noqa
        '0019xx70': ('ST', '1', 'RAD Protocol Printer', ''),  # noqa
        '0019xx71': ('ST', '1', 'RAD Protocol Medium', ''),  # noqa
        '0019xx80': ('LO', '1', 'Original Filename', ''),  # noqa
        '0019xx81': ('SH', '1', 'Filter Type', ''),  # noqa
        '0019xx82': ('LT', '1', 'Stitching', ''),  # noqa
        '0019xx89': ('IS', '1', 'Exposure Index', ''),  # noqa
        '0019xx8a': ('IS', '1', 'Collimator X', ''),  # noqa
        '0019xx8b': ('IS', '1', 'Collimator Y', ''),  # noqa
        '0019xx8c': ('LO', '1', 'Print Marker', ''),  # noqa
        '0019xx8d': ('LO', '1', 'RGDV Name', ''),  # noqa
        '0019xx8e': ('LO', '1', 'Acqd Sensitivity', ''),  # noqa
        '0019xx8f': ('LO', '1', 'Processing Category', ''),  # noqa
        '0019xx90': ('LO', '1', 'Unprocessed Flag', ''),  # noqa
        '0019xx91': ('DS', '2', 'Key Values', ''),  # noqa
        '0019xx92': ('LO', '1', 'Destination Postprocessing Function', ''),  # noqa
        '0019xxa0': ('LO', '1', 'Version', ''),  # noqa
        '0019xxa1': ('LO', '1', 'Ranging Mode', ''),  # noqa
        '0019xxa2': ('DS', '1', 'Abdomen Brightness', ''),  # noqa
        '0019xxa3': ('DS', '1', 'Fixed Brightness', ''),  # noqa
        '0019xxa4': ('DS', '1', 'Detail Contrast', ''),  # noqa
        '0019xxa5': ('DA', '1', 'Contrast Balance', ''),  # noqa
        '0019xxa6': ('DS', '1', 'Structure Boost', ''),  # noqa
        '0019xxa7': ('DS', '1', 'Structure Preference', ''),  # noqa
        '0019xxa8': ('DS', '1', 'Noise Robustness', ''),  # noqa
        '0019xxa9': ('DS', '1', 'Noise Dose Limit', ''),  # noqa
        '0019xxaa': ('DS', '1', 'Noise Dose Step', ''),  # noqa
        '0019xxab': ('DS', '1', 'Noise Frequency Limit', ''),  # noqa
        '0019xxac': ('DS', '1', 'Weak Contrast Limit', ''),  # noqa
        '0019xxad': ('DS', '1', 'Strong Contrast Limit', ''),  # noqa
        '0019xxae': ('DS', '1', 'Structure Boost Offset', ''),  # noqa
        '0019xxaf': ('LO', '1', 'Smooth Gain', ''),  # noqa
        '0019xxb0': ('LO', '1', 'Measure Field 1', ''),  # noqa
        '0019xxb1': ('LO', '1', 'Measure Field 2', ''),  # noqa
        '0019xxb2': ('IS', '1', 'Key Percentile 1', ''),  # noqa
        '0019xxb3': ('IS', '1', 'Key Percentile 2', ''),  # noqa
        '0019xxb4': ('IS', '1', 'Density LUT', ''),  # noqa
        '0019xxb5': ('DS', '1', 'Brightness', ''),  # noqa
        '0019xxb6': ('DS', '1', 'Gamma', ''),  # noqa
        '0089xx10': ('SQ', '1', 'Stamp Image Sequence', ''),  # noqa
    },
    'DIGISCAN IMAGE': {
        '0029xx31': ('US', '1-n', 'Unknown', ''),  # noqa
        '0029xx32': ('US', '1-n', 'Unknown', ''),  # noqa
        '0029xx33': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx34': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'DLX_ANNOT_01': {
        '70xxxx04': ('ST', '1', 'Text_annotation', ''),  # noqa
        '70xxxx05': ('IS', '2', 'Box', ''),  # noqa
        '70xxxx07': ('IS', '2', 'Arrow end', ''),  # noqa
    },
    'DLX_EXAMS_01': {
        '0015xx01': ('DS', '1', 'Stenos_calibr_ratio;', ''),  # noqa
        '0015xx02': ('DS', '1', 'Stenos_magnification;', ''),  # noqa
        '0015xx03': ('DS', '1', 'Cardiac_calibr_ratio;', ''),  # noqa
    },
    'DLX_LKUP_01': {
        '60xxxx01': ('LT', '3', 'Gray Palette color lookup table descriptor', ''),  # noqa
        '60xxxx02': ('LT', '1', 'Gray Palette color lookup table data', ''),  # noqa
    },
    'DLX_PATNT_01': {
        '0011xx01': ('LT', '1', 'patient DOB', ''),  # noqa
    },
    'DLX_SERIE_01': {
        '0019xx01': ('DS', '1', 'Angle Value 1', ''),  # noqa
        '0019xx02': ('DS', '1', 'Angle Value 2', ''),  # noqa
        '0019xx03': ('DS', '1', 'Angle Value 3', ''),  # noqa
        '0019xx04': ('CS', '1', 'Angle Label 1', ''),  # noqa
        '0019xx05': ('CS', '1', 'Angle Label 2', ''),  # noqa
        '0019xx06': ('CS', '1', 'Angle Label 3', ''),  # noqa
        '0019xx07': ('ST', '1', 'Adx Procedure Name', ''),  # noqa
        '0019xx08': ('ST', '1', 'Adx Exam Name', ''),  # noqa
        '0019xx09': ('SH', '1', 'Adx Patient Size', ''),  # noqa
        '0019xx0a': ('IS', '1', 'Adx Record View', ''),  # noqa
        '0019xx10': ('DS', '1', 'Adx Injector Delay', ''),  # noqa
        '0019xx11': ('CS', '1', 'Adx Auto Inject', ''),  # noqa
        '0019xx14': ('IS', '1', 'Adx Acq Mode', ''),  # noqa
        '0019xx15': ('CS', '1', 'Adx Camera Rotation Enable', ''),  # noqa
        '0019xx16': ('CS', '1', 'Adx Reverse Sweep', ''),  # noqa
        '0019xx17': ('IS', '1', 'User Spatial Filter Strength', ''),  # noqa
        '0019xx18': ('IS', '1', 'User Zoom Factor', ''),  # noqa
        '0019xx19': ('IS', '1', 'X Zoom', ''),  # noqa
        '0019xx1a': ('IS', '1', 'Y Zoom', ''),  # noqa
        '0019xx1b': ('DS', '1', 'Adx Focus', ''),  # noqa
        '0019xx1c': ('CS', '1', 'Adx Dose', ''),  # noqa
        '0019xx1d': ('IS', '1', 'Side Mark', ''),  # noqa
        '0019xx1e': ('IS', '1', 'Percent Landscape', ''),  # noqa
        '0019xx1f': ('DS', '1', 'Adx Exposure Duration', ''),  # noqa
        '0019xx20': ('SH', '1', 'Ip Address', ''),  # noqa
        '0019xx21': ('DS', '1', 'Table Vertical Position', ''),  # noqa
        '0019xx22': ('DS', '1', 'Table Longitudinal Position', ''),  # noqa
        '0019xx23': ('DS', '1', 'Table Lateral Position', ''),  # noqa
        '0019xx24': ('DS', '1', 'Lambda cm Pincushion Distortion', ''),  # noqa
        '0019xx25': ('DS', '1', 'Slope LV Regression', ''),  # noqa
        '0019xx26': ('DS', '1', 'Intercept LV Regression', ''),  # noqa
        '0019xx27': ('DS', '1', 'Image chain FWHM psf mm min', ''),  # noqa
        '0019xx28': ('DS', '1', 'Image chain FWHM psf mm max', ''),  # noqa
    },
    'DL_INTERNAL_USE': {
        '0015xx8f': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'DR Systems, Inc.': {
        '4453xx01': ('LO', '1', 'DR Exam ID', ''),  # noqa
        '4453xx02': ('LO', '1', 'DR Image Type', ''),  # noqa
        '4453xx04': ('LO', '1', 'DR File Type', ''),  # noqa
        '4453xx05': ('LO', '1', 'DR File Suffix', ''),  # noqa
        '4453xx0a': ('UN', '1', 'DR Annotation Type', ''),  # noqa
        '4453xx0c': ('SQ', '1', 'DR Original Instance UID Sequence', ''),  # noqa
    },
    'DicomUtils 20100512': {
        '00090001': ('SQ', '1', 'DICOMUTILS_PROCESSING_METHODS', ''),  # noqa
    },
    'ELGEMS_XPERT': {
        '7fa1xx00': ('OB', '1', 'XPert Composite Report Item buffer', ''),  # noqa
        '7fa1xx10': ('OB', '1', 'Xpert Composite Report Item Identificator', ''),  # noqa
    },
    'ELSCINT1': {
        '0003xx01': ('OW', '1', 'Offset List Structure', ''),  # noqa
        '00e1xx01': ('US', '1', 'Data Dictionary Version', ''),  # noqa
        '00e1xx05': ('IS', '1', 'Unknown', ''),  # noqa
        '00e1xx06': ('IS', '1', 'Unknown', ''),  # noqa
        '00e1xx07': ('IS', '1', 'Unknown', ''),  # noqa
        '00e1xx14': ('CS', '1', 'Unknown', ''),  # noqa
        '00e1xx18': ('OB', '1', 'Unknown', ''),  # noqa
        '00e1xx21': ('DS', '1', 'Unknown', ''),  # noqa
        '00e1xx22': ('DS', '2', 'Presentation Relative Center', ''),  # noqa
        '00e1xx23': ('DS', '2', 'Presentation Relative Part', ''),  # noqa
        '00e1xx24': ('CS', '1', 'Presentation Horizontal Invert', ''),  # noqa
        '00e1xx25': ('CS', '1', 'Unknown', ''),  # noqa
        '00e1xx2a': ('DS', '1', 'Unknown', ''),  # noqa
        '00e1xx30': ('UI', '1', 'Unknown', ''),  # noqa
        '00e1xx31': ('CS', '1', 'Unknown', ''),  # noqa
        '00e1xx32': ('US', '2', 'Unknown', ''),  # noqa
        '00e1xx37': ('DS', '1', 'Unknown', ''),  # noqa
        '00e1xx39': ('SQ', '1', 'Unknown', ''),  # noqa
        '00e1xx3f': ('CS', '1', 'Unknown', ''),  # noqa
        '00e1xx40': ('SH', '1', 'Image Label', ''),  # noqa
        '00e1xx41': ('DS', '1', 'Unknown', ''),  # noqa
        '00e1xx42': ('LO', '1', 'Unknown', ''),  # noqa
        '00e1xx43': ('IS', '1', 'Unknown', ''),  # noqa
        '00e1xx50': ('DS', '1', 'Acquisition Duration', ''),  # noqa
        '00e1xx51': ('SH', '1', 'Unknown', ''),  # noqa
        '00e1xx60': ('CS', '1', 'Unknown', ''),  # noqa
        '00e1xx61': ('LO', '1', 'Protocol File Name', ''),  # noqa
        '00e1xx62': ('CS', '1', 'Unknown', ''),  # noqa
        '00e1xx63': ('SH', '1', 'Patient Language', ''),  # noqa
        '00e1xx65': ('LO', '1', 'Patient Data Modification Date', ''),  # noqa
        '00e1xx6a': ('IS', '1', 'Unknown', ''),  # noqa
        '00e1xx6b': ('IS', '1', 'Unknown', ''),  # noqa
        '00e1xxa0': ('LO', '1', 'Unknown', ''),  # noqa
        '00e1xxc2': ('UI', '1', 'Unknown', ''),  # noqa
        '00e3xx00': ('OB', '1', 'Unknown', ''),  # noqa
        '00e3xx18': ('OB', '1', 'Unknown', ''),  # noqa
        '00e3xx1f': ('OB', '1', 'Unknown', ''),  # noqa
        '01e1xx18': ('OB', '1', 'Unknown', ''),  # noqa
        '01e1xx21': ('ST', '1', 'Unknown', ''),  # noqa
        '01e1xx34': ('IS', '1', 'Unknown', ''),  # noqa
        '01f1xx01': ('CS', '1', 'Acquisition Type', ''),  # noqa
        '01f1xx02': ('CS', '1', 'Unknown', ''),  # noqa
        '01f1xx03': ('CS', '1', 'Concurrent Slices Generation', ''),  # noqa
        '01f1xx04': ('CS', '1', 'Angular Sampling Density', ''),  # noqa
        '01f1xx05': ('DS', '1', 'Reconstruction Arc', ''),  # noqa
        '01f1xx06': ('DS', '1', 'Unknown', ''),  # noqa
        '01f1xx07': ('DS', '1', 'Table Velocity', ''),  # noqa
        '01f1xx08': ('DS', '1', 'Acquisition Length', ''),  # noqa
        '01f1xx0a': ('US', '1', 'Edge Enhancement Weight', ''),  # noqa
        '01f1xx0b': ('CS', '2', 'Unknown', ''),  # noqa
        '01f1xx0c': ('DS', '2', 'Scanner Relative Center', ''),  # noqa
        '01f1xx0d': ('DS', '1', 'Rotation Angle', ''),  # noqa
        '01f1xx0e': ('FL', '1', 'Unknown', ''),  # noqa
        '01f1xx26': ('DS', '1', 'Pitch', ''),  # noqa
        '01f1xx27': ('DS', '1', 'Rotation Time', ''),  # noqa
        '01f1xx28': ('DS', '1', 'Unknown', ''),  # noqa
        '01f1xx30': ('US', '1', 'Unknown', ''),  # noqa
        '01f1xx32': ('CS', '1', 'Image View Convention', ''),  # noqa
        '01f1xx33': ('DS', '1', 'Unknown', ''),  # noqa
        '01f1xx36': ('CS', '1', 'Unknown', ''),  # noqa
        '01f1xx37': ('DS', '1', 'Unknown', ''),  # noqa
        '01f1xx38': ('LO', '1', 'Unknown', ''),  # noqa
        '01f1xx39': ('LO', '1', 'Unknown', ''),  # noqa
        '01f1xx40': ('CS', '1', 'Unknown', ''),  # noqa
        '01f1xx42': ('SH', '1', 'Unknown', ''),  # noqa
        '01f1xx43': ('LO', '1', 'Unknown', ''),  # noqa
        '01f1xx44': ('OW', '1', 'Unknown', ''),  # noqa
        '01f1xx45': ('IS', '1', 'Unknown', ''),  # noqa
        '01f1xx46': ('FL', '1', 'Unknown', ''),  # noqa
        '01f1xx47': ('SH', '1', 'Unknown', ''),  # noqa
        '01f1xx49': ('DS', '1', 'Unknown', ''),  # noqa
        '01f1xx4a': ('SH', '1', 'Unknown', ''),  # noqa
        '01f1xx4b': ('SH', '1', 'Unknown', ''),  # noqa
        '01f1xx4c': ('SH', '1', 'Unknown', ''),  # noqa
        '01f1xx4d': ('SH', '1', 'Unknown', ''),  # noqa
        '01f1xx4e': ('LO', '1', 'Unknown', ''),  # noqa
        '01f1xx53': ('SH', '1', 'Unknown', ''),  # noqa
        '01f3xx01': ('SQ', '1', 'Unknown', ''),  # noqa
        '01f3xx02': ('SS', '1', 'Unknown', ''),  # noqa
        '01f3xx03': ('FL', '2', 'Unknown', ''),  # noqa
        '01f3xx04': ('FL', '1', 'Unknown', ''),  # noqa
        '01f3xx11': ('SQ', '1', 'PS Sequence', ''),  # noqa
        '01f3xx12': ('SS', '1', 'Unknown', ''),  # noqa
        '01f3xx13': ('FL', '2', 'Unknown', ''),  # noqa
        '01f3xx14': ('FL', '1', 'Unknown', ''),  # noqa
        '01f3xx15': ('US', '1', 'Unknown', ''),  # noqa
        '01f3xx16': ('FL', '1', 'Unknown', ''),  # noqa
        '01f3xx17': ('FL', '1', 'Unknown', ''),  # noqa
        '01f3xx18': ('SH', '1', 'Unknown', ''),  # noqa
        '01f3xx19': ('FL', '1', 'Unknown', ''),  # noqa
        '01f3xx23': ('US', '1', 'Unknown', ''),  # noqa
        '01f3xx24': ('IS', '2', 'Unknown', ''),  # noqa
        '01f7xx10': ('OB', '1', 'Unknown', ''),  # noqa
        '01f7xx11': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx13': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx14': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx15': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx16': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx17': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx18': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx19': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx1a': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx1b': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx1c': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx1e': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx1f': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx22': ('UI', '1', 'Unknown', ''),  # noqa
        '01f7xx23': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx25': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx26': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx27': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx28': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx29': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx2b': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx2c': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx2d': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx2e': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx30': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx31': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx70': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx73': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx74': ('OW', '1', 'Unknown', ''),  # noqa
        '01f7xx75': ('OW', '1', 'Unknown', ''),  # noqa
        '0601xx00': ('SH', '1', 'Implementation Version', ''),  # noqa
        '0601xx20': ('DS', '1', 'Relative Table Position', ''),  # noqa
        '0601xx21': ('DS', '1', 'Relative Table Height', ''),  # noqa
        '0601xx30': ('SH', '1', 'Surview Direction', ''),  # noqa
        '0601xx31': ('DS', '1', 'Surview Length', ''),  # noqa
        '0601xx50': ('SH', '1', 'Image View Type', ''),  # noqa
        '0601xx70': ('DS', '1', 'Batch Number', ''),  # noqa
        '0601xx71': ('DS', '1', 'Batch Size', ''),  # noqa
        '0601xx72': ('DS', '1', 'Batch Slice Number', ''),  # noqa
        '07a1xx01': ('UL', '1', 'number of series in study', ''),  # noqa
        '07a1xx02': ('UL', '1', 'number of images in series', ''),  # noqa
        '07a1xx03': ('UL', '1', 'last update time', ''),  # noqa
        '07a1xx04': ('UL', '1', 'last update date', ''),  # noqa
        '07a1xx07': ('US', '3', 'Unknown', ''),  # noqa
        '07a1xx08': ('DS', '1-n', 'Unknown', ''),  # noqa
        '07a1xx09': ('OW', '1', 'Unknown', ''),  # noqa
        '07a1xx0a': ('OB', '1', 'Tamar Compressed Pixel Data', ''),  # noqa
        '07a1xx0c': ('US', '1', 'Unknown', ''),  # noqa
        '07a1xx10': ('LO', '1', 'Tamar Software Version', ''),  # noqa
        '07a1xx11': ('CS', '1', 'Tamar Compression Type', ''),  # noqa
        '07a1xx12': ('FL', '1-n', 'Unknown', ''),  # noqa
        '07a1xx13': ('UL', '1', 'Unknown', ''),  # noqa
        '07a1xx14': ('LO', '1', 'protection flag', ''),  # noqa
        '07a1xx16': ('FL', '1-n', 'Unknown', ''),  # noqa
        '07a1xx18': ('SQ', '1', 'Unknown', ''),  # noqa
        '07a1xx19': ('FL', '1', 'Unknown', ''),  # noqa
        '07a1xx1c': ('FL', '1-n', 'Unknown', ''),  # noqa
        '07a1xx2a': ('CS', '1', 'Tamar Study Status', ''),  # noqa
        '07a1xx2b': ('CS', '1', 'Unknown', ''),  # noqa
        '07a1xx36': ('AE', '1', 'Tamar Source Ae', ''),  # noqa
        '07a1xx40': ('CS', '1', 'Tamar Study Body Part', ''),  # noqa
        '07a1xx43': ('IS', '1', 'Unknown', ''),  # noqa
        '07a1xx50': ('US', '1', 'Tamar Site Id', ''),  # noqa
        '07a1xx56': ('US', '1', 'Unknown', ''),  # noqa
        '07a1xx75': ('LO', '2', 'Unknown', ''),  # noqa
        '07a1xx85': ('UL', '1', 'Tamar Translate Flags', ''),  # noqa
        '07a1xx9f': ('CS', '1', 'Unknown', ''),  # noqa
        '07a3xx01': ('LO', '1', 'Tamar Exe Software Version', ''),  # noqa
        '07a3xx03': ('CS', '1', 'Tamar Study Has Sticky Note', ''),  # noqa
        '07a3xx05': ('CS', '1', 'Unknown', ''),  # noqa
        '07a3xx06': ('CS', '1', 'Unknown', ''),  # noqa
        '07a3xx10': ('LO', '1', 'Tamar Original Curve Desc', ''),  # noqa
        '07a3xx34': ('SH', '1', 'Tamar Study Age', ''),  # noqa
        '07a3xx43': ('DS', '1-n', 'Unknown', ''),  # noqa
        '07a3xx55': ('SH', '1', 'Unknown', ''),  # noqa
        '07a3xx61': ('LT', '1', 'Unknown', ''),  # noqa
        '07a3xx62': ('SQ', '1', 'Unknown', ''),  # noqa
        '07a3xx63': ('SQ', '1', 'Unknown', ''),  # noqa
        '07a3xx64': ('IS', '1-n', 'Unknown', ''),  # noqa
        '07a3xx66': ('IS', '1', 'Unknown', ''),  # noqa
        '07a3xx99': ('CS', '1', 'Unknown', ''),  # noqa
        '07a3xx9c': ('CS', '1', 'Unknown', ''),  # noqa
        '07a3xx9f': ('CS', '1', 'Unknown', ''),  # noqa
        '5001xx70': ('SQ', '1', 'Unknown', ''),  # noqa
        '5001xx71': ('SH', '1', 'Unknown', ''),  # noqa
        '5001xx80': ('SQ', '1', 'Unknown', ''),  # noqa
        '5001xx81': ('SH', '1', 'Unknown', ''),  # noqa
        '5001xx82': ('US', '3', 'Unknown', ''),  # noqa
        '5001xx83': ('FL', '1-n', 'Unknown', ''),  # noqa
        '5001xx84': ('SQ', '1', 'Unknown', ''),  # noqa
        '6001xx10': ('CS', '1', 'Text Overlay Flag', ''),  # noqa
        '7fdfxxf0': ('OB', '1', 'Unknown', ''),  # noqa
        '7fdfxxff': ('SH', '1', 'Unknown', ''),  # noqa
    },
    'EMAGEON JPEG2K INFO': {
        '0009xx00': ('SQ', '1', 'Unknown', ''),  # noqa
        '0009xx01': ('DT', '1', 'Unknown', ''),  # noqa
    },
    'EMAGEON STUDY HOME': {
        '0009xx00': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx01': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Eclipse 60': {
        '0029xx30': ('UL', '1', 'Private data', ''),  # noqa
        '0029xx31': ('UL', '1', 'Private data', ''),  # noqa
        '0029xx32': ('UL', '1', 'Private data', ''),  # noqa
        '0029xx33': ('DS', '1', 'Private data', ''),  # noqa
        '0029xx34': ('DS', '1', 'Private data', ''),  # noqa
        '0029xx36': ('SL', '1', 'Private data', ''),  # noqa
        '0029xx40': ('CS', '1', 'Private data', ''),  # noqa
        '0029xx50': ('CS', '1', 'Private data', ''),  # noqa
        '0029xx51': ('UL', '1', 'Private data', ''),  # noqa
        '0029xx52': ('UL', '1', 'Private data', ''),  # noqa
        '0029xx53': ('DS', '1', 'Private data', ''),  # noqa
        '0029xx54': ('UL', '1', 'Private data', ''),  # noqa
        '0029xx55': ('FL', '1', 'Private data', ''),  # noqa
        '0029xx56': ('US', '1', 'Private data', ''),  # noqa
        '0029xx60': ('LO', '1', 'Private data', ''),  # noqa
        '0031xx30': ('UL', '1', 'Private data', ''),  # noqa
        '0031xx31': ('UL', '1', 'Private data', ''),  # noqa
        '0031xx32': ('LO', '1', 'Private data', ''),  # noqa
        '0031xx33': ('UL', '1', 'Private data', ''),  # noqa
        '0031xx34': ('UL', '1', 'Private data', ''),  # noqa
        '0031xx35': ('UL', '1', 'Private data', ''),  # noqa
        '200dxx01': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx02': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx03': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx04': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx05': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx06': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx07': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx08': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx09': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx0a': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx0b': ('OB', '1', 'Private data', ''),  # noqa
        '200dxx0c': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx0d': ('UL', '1', 'Private data', ''),  # noqa
        '200dxx0e': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx0f': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx10': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx11': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx12': ('OB', '1', 'Private data', ''),  # noqa
        '200dxx13': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx14': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx15': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx1a': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx1b': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx20': ('SQ', '1', 'Private data', ''),  # noqa
        '200dxx27': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx28': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx30': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx31': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx32': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx33': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx34': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx35': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx36': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx37': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx38': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx39': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx3a': ('LO', '1', 'Private data', ''),  # noqa
        '200dxx50': ('CS', '1', 'Private data', ''),  # noqa
        '200dxx51': ('CS', '1', 'Private data', ''),  # noqa
        '200dxx52': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx53': ('CS', '1', 'Private data', ''),  # noqa
        '200dxx54': ('CS', '1', 'Private data', ''),  # noqa
        '200dxx55': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx56': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx57': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx58': ('IS', '1', 'Private data', ''),  # noqa
        '200dxx59': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx5a': ('FD', '1', 'Private data', ''),  # noqa
        '200dxx5d': ('CS', '1', 'Private data', ''),  # noqa
        '200dxx5e': ('CS', '1', 'Private data', ''),  # noqa
        '200dxxff': ('IS', '1', 'Private data', ''),  # noqa
        '7777xx01': ('DA', '1', 'Private data', ''),  # noqa
        '7777xx02': ('CS', '1', 'Private data', ''),  # noqa
        '7777xx03': ('LO', '1', 'Private data', ''),  # noqa
        '7777xx10': ('LO', '1', 'Private data', ''),  # noqa
        '7777xx14': ('LT', '1', 'Private data', ''),  # noqa
    },
    'FDMS 1.0': {
        '0009xx04': ('SH', '1', 'Image Control Unit', ''),  # noqa
        '0009xx05': ('OW', '1', 'Image UID', ''),  # noqa
        '0009xx06': ('OW', '1', 'Route Image UID', ''),  # noqa
        '0009xx08': ('UL', '1', 'Image Display Information Version No.', ''),  # noqa
        '0009xx09': ('UL', '1', 'Patient Information Version No.', ''),  # noqa
        '0009xx0c': ('OW', '1', 'Film UID', ''),  # noqa
        '0009xx10': ('CS', '1', 'Exposure Unit Type Code', ''),  # noqa
        '0009xx80': ('LO', '1', 'Kanji Hospital Name', ''),  # noqa
        '0009xx90': ('ST', '1', 'Distribution Code', ''),  # noqa
        '0009xx92': ('SH', '1', 'Kanji Department Name', ''),  # noqa
        '0009xxf0': ('CS', '1', 'Blackening Process Flag', ''),  # noqa
        '0009xxf1': ('ST', '1', 'Processing Information Flag', ''),  # noqa
        '0019xx15': ('LO', '1', 'Kanji Body Part for Exposure', ''),  # noqa
        '0019xx30': ('LO', '1', 'Menu Character String', ''),  # noqa
        '0019xx32': ('LO', '1', 'Kanji Menu Name', ''),  # noqa
        '0019xx40': ('CS', '1', 'Image Processing Type', ''),  # noqa
        '0019xx50': ('CS', '1', 'EDR Mode', ''),  # noqa
        '0019xx60': ('SH', '1', "Radiographer's Code", ''),  # noqa
        '0019xx70': ('IS', '1', 'Split Exposure Format', ''),  # noqa
        '0019xx71': ('IS', '1', 'No. of Split Exposure Frames', ''),  # noqa
        '0019xx80': ('IS', '1', 'Reading Position Specification', ''),  # noqa
        '0019xx81': ('IS', '1', 'Reading Sensitivity Center', ''),  # noqa
        '0019xx90': ('SH', '1', 'Film Annotation Character String 1', ''),  # noqa
        '0019xx91': ('SH', '1', 'Film Annotation Character String 2', ''),  # noqa
        '0019xxa0': ('SQ', '1', 'Exposure Status Sequence', ''),  # noqa
        '0019xxa1': ('CS', '1', 'Exposure Status', ''),  # noqa
        '0019xxa2': ('CS', '1', 'Exposure Kind', ''),  # noqa
        '0021xx10': ('CS', '1', 'FCR Image ID', ''),  # noqa
        '0021xx30': ('CS', '1', 'Set No.', ''),  # noqa
        '0021xx40': ('IS', '1', 'Image No. in the Set', ''),  # noqa
        '0021xx50': ('CS', '1', 'Pair Processing Information', ''),  # noqa
        '0021xx70': ('IS', '1', 'Film Number within the Series', ''),  # noqa
        '0021xx80': ('OB', '1', 'Equipment Type-Specific Information', ''),  # noqa
        '0021xx90': ('CS', '1', 'LUT Number', ''),  # noqa
        '0023xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '0023xx20': ('SQ', '1', 'Unknown', ''),  # noqa
        '0023xx30': ('SQ', '1', 'Unknown', ''),  # noqa
        '0025xx10': ('US', '1', 'Relative Light Emission Amount Sk', ''),  # noqa
        '0025xx11': ('US', '1', 'Term of Correction for Each IP Type St', ''),  # noqa
        '0025xx12': ('US', '1', 'Reading Gain Gp', ''),  # noqa
        '0025xx13': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx15': ('CS', '1', 'Unknown', ''),  # noqa
        '0025xx20': ('US', '2', 'Unknown', ''),  # noqa
        '0025xx21': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx30': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx31': ('SS', '1', 'Unknown', ''),  # noqa
        '0025xx32': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx33': ('SS', '1', 'Unknown', ''),  # noqa
        '0025xx34': ('SS', '1', 'Unknown', ''),  # noqa
        '0025xx40': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx41': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx42': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx43': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx50': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx51': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx52': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx53': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx60': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx61': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx62': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx63': ('CS', '1', 'Unknown', ''),  # noqa
        '0025xx70': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx71': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx72': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx73': ('US', '6', 'Unknown', ''),  # noqa
        '0025xx74': ('US', '6', 'Unknown', ''),  # noqa
        '0025xx80': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx81': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx82': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx83': ('US', '6', 'Unknown', ''),  # noqa
        '0025xx84': ('US', '6', 'Unknown', ''),  # noqa
        '0025xx90': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx91': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx92': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx93': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx94': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx95': ('US', '1', 'Unknown', ''),  # noqa
        '0025xx96': ('CS', '1', 'Unknown', ''),  # noqa
        '0025xxa0': ('US', '1', 'Unknown', ''),  # noqa
        '0025xxa1': ('SS', '1', 'Unknown', ''),  # noqa
        '0025xxa2': ('US', '1', 'Unknown', ''),  # noqa
        '0025xxa3': ('SS', '1', 'Unknown', ''),  # noqa
        '0027xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xx20': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xx30': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xx40': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xx50': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xx60': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xx70': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xx80': ('SQ', '1', 'Unknown', ''),  # noqa
        '0027xxa0': ('IS', '1', 'Unknown', ''),  # noqa
        '0027xxa1': ('CS', '2', 'Unknown', ''),  # noqa
        '0027xxa2': ('CS', '2', 'Unknown', ''),  # noqa
        '0027xxa3': ('SS', '1-n', 'Unknown', ''),  # noqa
        '0029xx20': ('CS', '1', 'Image Scanning Direction', ''),  # noqa
        '0029xx25': ('CS', '1', 'Image Rotation/Reversal Information', ''),  # noqa
        '0029xx30': ('CS', '1', 'Extended Reading Size Value', ''),  # noqa
        '0029xx34': ('US', '1', 'Mag./Reduc. Ratio', ''),  # noqa
        '0029xx44': ('CS', '1', 'Line Density Code', ''),  # noqa
        '0029xx50': ('CS', '1', 'Data Compression Code', ''),  # noqa
        '0032xx32': ('PN', '1', 'Requesting Physician', ''),  # noqa
        '0032xx33': ('LO', '1', 'Requesting Service', ''),  # noqa
        '2011xx00': ('CS', '1', 'Trim Density', ''),  # noqa
        '2011xx01': ('IS', '1', 'Trim Width', ''),  # noqa
        '2011xx02': ('CS', '1', 'Image Mag./Reduc. Range', ''),  # noqa
        '2011xx10': ('CS', '1', 'Image Display Format', ''),  # noqa
        '2011xx11': ('CS', '1', 'Image Position Specifying Flag', ''),  # noqa
        '2011xx20': ('OW', '1', 'Interpolation A-VRS System Format', ''),  # noqa
        '50f1xx06': ('CS', '1', 'Energy Subtraction Param.', ''),  # noqa
        '50f1xx07': ('CS', '1', 'Subtraction Registration Result', ''),  # noqa
        '50f1xx08': ('CS', '1', 'Energy Subtraction Param. 2', ''),  # noqa
        '50f1xx09': ('SL', '1', 'Afin Conversion Coefficient', ''),  # noqa
        '50f1xx0a': ('SH', '1', 'FNC Parameters', ''),  # noqa
        '50f1xx10': ('CS', '1', 'Film Output Format', ''),  # noqa
        '50f1xx20': ('CS', '1', 'Image Processing Modification Flag', ''),  # noqa
    },
    'FFP DATA': {
        '0009xx01': ('UN', '1', 'CR Header Information', ''),  # noqa
    },
    'GDCM CONFORMANCE TESTS': {
        '4d4dxx01': ('SQ', '1', 'Array Container Sequence', ''),  # noqa
        '4d4dxx02': ('OB', '1', '0-Filled Array', ''),  # noqa
    },
    'GE ??? From Adantage Review CS': {
        '0019xx30': ('LO', '1', 'CR EDR Mode', ''),  # noqa
        '0019xx40': ('LO', '1', 'CR Latitude', ''),  # noqa
        '0019xx50': ('LO', '1', 'CR Group Number', ''),  # noqa
        '0019xx70': ('LO', '1', 'CR Image Serial Number', ''),  # noqa
        '0019xx80': ('LO', '1', 'CR Bar Code Number', ''),  # noqa
        '0019xx90': ('LO', '1', 'CR Film Output Exposures', ''),  # noqa
    },
    'GE LUT Asymmetry Parameter': {
        '0045xx67': ('DS', '1', 'LUT Assymetry', ''),  # noqa
    },
    'GEHC_CT_ADVAPP_001': {
        '0053xx20': ('IS', '1', 'ShuttleFlag', ''),  # noqa
        '0053xx21': ('IS', '1', 'TableSpeedNotReachesTargetFlag', ''),  # noqa
        '0053xx40': ('SH', '1', 'IterativeReconAnnotation', ''),  # noqa
        '0053xx41': ('SH', '1', 'IterativeReconMode', ''),  # noqa
        '0053xx42': ('LO', '1', 'IterativeReconConfiguration', ''),  # noqa
        '0053xx43': ('SH', '1', 'IterativeReconLevel', ''),  # noqa
        '0053xx60': ('SH', '1', 'reconFlipRotateAnno', ''),  # noqa
        '0053xx61': ('SH', '1', 'highResolutionFlag', ''),  # noqa
        '0053xx62': ('SH', '1', 'RespiratoryFlag', ''),  # noqa
    },
    'GEIIS': {
        '0009xx10': ('SQ', '1', 'GE IIS Thumbnail Sequence', ''),  # noqa
        '0009xx12': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('UL', '1', 'Shift Count', ''),  # noqa
        '0029xx12': ('UL', '1', 'Offset', ''),  # noqa
        '0029xx14': ('UL', '1', 'Actual Frame Number', ''),  # noqa
        '004bxx13': ('IS', '1', 'Unknown', ''),  # noqa
        '004bxx15': ('LT', '1', 'Unknown', ''),  # noqa
        '0905xx30': ('LO', '1', 'Assigning Authority For Patient ID', ''),  # noqa
        '0907xx10': ('UI', '1', 'Original Study Instance UID', ''),  # noqa
        '0907xx20': ('UI', '1', 'Original Series Instance UID', ''),  # noqa
        '0907xx30': ('UI', '1', 'Original SOP Instance UID', ''),  # noqa
        '7fd1xx10': ('UL', '1', 'GE IIS Compression ID', ''),  # noqa
        '7fd1xx20': ('UL', '1', 'GE IIS Multiframe Offsets', ''),  # noqa
        '7fd1xx30': ('UL', '1', 'Unknown', ''),  # noqa
        '7fd1xx40': ('UL', '1-n', 'Unknown', ''),  # noqa
        '7fd1xx50': ('UL', '1-n', 'Unknown', ''),  # noqa
        '7fd1xx60': ('UL', '1-n', 'Unknown', ''),  # noqa
    },
    'GEIIS PACS': {
        '0903xx10': ('US', '1', 'Reject Image Flag', ''),  # noqa
        '0903xx11': ('US', '1', 'Significant Flag', ''),  # noqa
        '0903xx12': ('US', '1', 'Confidential Flag', ''),  # noqa
        '0903xx20': ('CS', '1', 'Unknown', ''),  # noqa
        '0907xx21': ('US', '1', 'GEIIS_PREFETCH_ALGORITHM', ''),  # noqa
        '0907xx22': ('US', '1', 'GEIIS_LIMIT_RECENT_STUDIES', ''),  # noqa
        '0907xx23': ('US', '1', 'GEIIS_LIMIT_OLDEST_STUDIES', ''),  # noqa
        '0907xx24': ('US', '1', 'GEIIS_LIMIT_RECENT_MONTHS', ''),  # noqa
        '0907xx31': ('UI', '1-n', 'GEIIS_EXCLUDE_STUDY_UIDS', ''),  # noqa
    },
    'GEMS-IT/Centricity RA600/7.0': {
        '4113xx10': ('UI', '1', 'Number of images in study', ''),  # noqa
    },
    'GEMS_0039': {
        '0039xx95': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_3DSTATE_001': {
        '0047xxd6': ('ST', '1', 'General Description', ''),  # noqa
        '0047xxd7': ('CS', '1', 'TDRT', ''),  # noqa
        '0047xxd8': ('US', '1', 'NVRP', ''),  # noqa
        '0047xxd9': ('US', '1', 'CVRPN', ''),  # noqa
        '0047xxda': ('SQ', '1', 'Volume Rendering Presets Sequence', ''),  # noqa
        '0047xxdb': ('LO', '1', 'Preset Name', ''),  # noqa
        '0047xxdc': ('SS', '1-n', 'Opacity Curve X', ''),  # noqa
        '0047xxdd': ('FL', '1-n', 'Opacity Curve Y', ''),  # noqa
        '0047xxde': ('US', '1', 'NOCP', ''),  # noqa
        '0047xxdf': ('SS', '1-n', 'Color Curve X', ''),  # noqa
        '0047xxe1': ('US', '1', 'NCCP', ''),  # noqa
        '0047xxe2': ('CS', '1', 'GSA', ''),  # noqa
        '0047xxe3': ('CS', '1', 'VRSF', ''),  # noqa
        '0047xxe4': ('FL', '1', 'AF', ''),  # noqa
        '0047xxe5': ('FL', '1', 'DF', ''),  # noqa
        '0047xxe6': ('FL', '1', 'SCF', ''),  # noqa
        '0047xxe7': ('FL', '1', 'SPF', ''),  # noqa
        '0047xxe8': ('FL', '24', 'Orthogonal Clipping Planes', ''),  # noqa
        '0047xxe9': ('FL', '3', 'CP', ''),  # noqa
        '0047xxea': ('DS', '3', 'CFP', ''),  # noqa
        '0047xxeb': ('DS', '3', 'CVU', ''),  # noqa
        '0047xxec': ('FL', '1', 'RFOV', ''),  # noqa
        '0047xxed': ('CS', '1', 'PPRP', ''),  # noqa
        '0047xxee': ('DS', '1', '3DWW', ''),  # noqa
        '0047xxef': ('DS', '1', '3DWL', ''),  # noqa
        '0047xxf0': ('CS', '1', 'BBV', ''),  # noqa
        '0047xxf1': ('CS', '1', 'ERF', ''),  # noqa
        '0047xxf2': ('US', '1', 'TDRMS', ''),  # noqa
        '0047xxf3': ('FL', '1', 'TDSSS', ''),  # noqa
    },
    'GEMS_ACQU_01': {
        '0009xx24': ('DS', '1', 'Unknown', ''),  # noqa
        '0009xx25': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx3e': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx3f': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx42': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx43': ('US', '1', 'Unknown', ''),  # noqa
        '0009xxf8': ('US', '1', 'Unknown', ''),  # noqa
        '0009xxfb': ('IS', '1', 'Unknown', ''),  # noqa
        '001910xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0019xx01': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx02': ('SL', '1', 'Detector Channel', ''),  # noqa
        '0019xx03': ('DS', '1', 'Cell number at Theta', ''),  # noqa
        '0019xx04': ('DS', '1', 'Cell spacing', ''),  # noqa
        '0019xx05': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx06': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx0e': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx0f': ('DS', '1', 'Horiz. Frame of ref.', ''),  # noqa
        '0019xx11': ('SS', '1', 'Series contrast', ''),  # noqa
        '0019xx12': ('SS', '1', 'Last pseq', ''),  # noqa
        '0019xx13': ('SS', '1', 'Start number for baseline', ''),  # noqa
        '0019xx14': ('SS', '1', 'End number for baseline', ''),  # noqa
        '0019xx15': ('SS', '1', 'Start number for enhanced scans', ''),  # noqa
        '0019xx16': ('SS', '1', 'End number for enhanced scans', ''),  # noqa
        '0019xx17': ('SS', '1', 'Series plane', ''),  # noqa
        '0019xx18': ('LO', '1', 'First scan ras', ''),  # noqa
        '0019xx19': ('DS', '1', 'First scan location', ''),  # noqa
        '0019xx1a': ('LO', '1', 'Last scan ras', ''),  # noqa
        '0019xx1b': ('DS', '1', 'Last scan loc', ''),  # noqa
        '0019xx1e': ('DS', '1', 'Display field of view', ''),  # noqa
        '0019xx20': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx22': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx23': ('DS', '1', 'Table Speed [mm/rotation]', ''),  # noqa
        '0019xx24': ('DS', '1', 'Mid Scan Time [sec]', ''),  # noqa
        '0019xx25': ('SS', '1', 'Mid scan flag', ''),  # noqa
        '0019xx26': ('SL', '1', 'Tube Azimuth [degree]', ''),  # noqa
        '0019xx27': ('DS', '1', 'Rotation Speed [msec]', ''),  # noqa
        '0019xx2a': ('DS', '1', 'x-ray On position', ''),  # noqa
        '0019xx2b': ('DS', '1', 'x-ray Off position', ''),  # noqa
        '0019xx2c': ('SL', '1', 'Number of triggers', ''),  # noqa
        '0019xx2d': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx2e': ('DS', '1', 'Angle of first view', ''),  # noqa
        '0019xx2f': ('DS', '1', 'Trigger frequency', ''),  # noqa
        '0019xx39': ('SS', '1', 'SFOV Type', ''),  # noqa
        '0019xx3a': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx3b': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx3c': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx3e': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx3f': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('SS', '1', 'Stat recon flag', ''),  # noqa
        '0019xx41': ('SS', '1', 'Compute type', ''),  # noqa
        '0019xx42': ('SS', '1', 'Segment Number', ''),  # noqa
        '0019xx43': ('SS', '1', 'Total Segments Required', ''),  # noqa
        '0019xx44': ('DS', '1', 'Interscan delay', ''),  # noqa
        '0019xx47': ('SS', '1', 'View compression factor', ''),  # noqa
        '0019xx48': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx49': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx4a': ('SS', '1', 'Total no. of ref channels', ''),  # noqa
        '0019xx4b': ('SL', '1', 'Data size for scan data', ''),  # noqa
        '0019xx52': ('SS', '1', 'Recon post proc. Flag', ''),  # noqa
        '0019xx54': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx57': ('SS', '1', 'CT water number', ''),  # noqa
        '0019xx58': ('SS', '1', 'CT bone number', ''),  # noqa
        '0019xx5a': ('FL', '1', 'Acquisition Duration', ''),  # noqa
        '0019xx5d': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx5e': ('SL', '1', 'Number of channels (1...512)', ''),  # noqa
        '0019xx5f': ('SL', '1', 'Increment between channels', ''),  # noqa
        '0019xx60': ('SL', '1', 'Starting view', ''),  # noqa
        '0019xx61': ('SL', '1', 'Number of views', ''),  # noqa
        '0019xx62': ('SL', '1', 'Increment between views', ''),  # noqa
        '0019xx6a': ('SS', '1', 'Dependent on #views processed', ''),  # noqa
        '0019xx6b': ('SS', '1', 'Field of view in detector cells', ''),  # noqa
        '0019xx70': ('SS', '1', 'Value of back projection button', ''),  # noqa
        '0019xx71': ('SS', '1', 'Set if fatq estimates were used', ''),  # noqa
        '0019xx72': ('DS', '1', 'Z chan avg over views', ''),  # noqa
        '0019xx73': ('DS', '1', 'Avg of left ref chans over views', ''),  # noqa
        '0019xx74': ('DS', '1', 'Max left chan over views', ''),  # noqa
        '0019xx75': ('DS', '1', 'Avg of right ref chans over views', ''),  # noqa
        '0019xx76': ('DS', '1', 'Max right chan over views', ''),  # noqa
        '0019xx7d': ('DS', '1', 'Second echo', ''),  # noqa
        '0019xx7e': ('SS', '1', 'Number of echoes', ''),  # noqa
        '0019xx7f': ('DS', '1', 'Table delta', ''),  # noqa
        '0019xx81': ('SS', '1', 'Contiguous', ''),  # noqa
        '0019xx82': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx83': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx84': ('DS', '1', 'Peak SAR', ''),  # noqa
        '0019xx85': ('SS', '1', 'Monitor SAR', ''),  # noqa
        '0019xx86': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx87': ('DS', '1', 'Cardiac repetition time', ''),  # noqa
        '0019xx88': ('SS', '1', 'Images per cardiac cycle', ''),  # noqa
        '0019xx8a': ('SS', '1', 'Actual receive gain analog', ''),  # noqa
        '0019xx8b': ('SS', '1', 'Actual receive gain digital', ''),  # noqa
        '0019xx8d': ('DS', '1', 'Delay after trigger', ''),  # noqa
        '0019xx8f': ('SS', '1', 'Swappf', ''),  # noqa
        '0019xx90': ('SS', '1', 'Pause Interval', ''),  # noqa
        '0019xx91': ('DS', '1', 'Pause Time', ''),  # noqa
        '0019xx92': ('SL', '1', 'Slice offset on freq axis', ''),  # noqa
        '0019xx93': ('DS', '1', 'Auto Prescan Center Frequency', ''),  # noqa
        '0019xx94': ('SS', '1', 'Auto Prescan Transmit Gain', ''),  # noqa
        '0019xx95': ('SS', '1', 'Auto Prescan Analog receiver gain', ''),  # noqa
        '0019xx96': ('SS', '1', 'Auto Prescan Digital receiver gain', ''),  # noqa
        '0019xx97': ('SL', '1', 'Bitmap defining CVs', ''),  # noqa
        '0019xx98': ('SS', '1', 'Center freq. Method', ''),  # noqa
        '0019xx99': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx9b': ('SS', '1', 'Pulse Sequence Mode', ''),  # noqa
        '0019xx9c': ('LO', '1', 'Pulse Sequence Name', ''),  # noqa
        '0019xx9d': ('DT', '1', 'Pulse Sequence Date', ''),  # noqa
        '0019xx9e': ('LO', '1', 'Internal Pulse Sequence Name', ''),  # noqa
        '0019xx9f': ('SS', '1', 'Transmitting Coil Type', ''),  # noqa
        '0019xxa0': ('SS', '1', 'Surface Coil Type', ''),  # noqa
        '0019xxa1': ('SS', '1', 'Extremity Coil flag', ''),  # noqa
        '0019xxa2': ('SL', '1', 'Raw data run number', ''),  # noqa
        '0019xxa3': ('UL', '1', 'Calibrated Field strength', ''),  # noqa
        '0019xxa4': ('SS', '1', 'SAT fat/water/bone', ''),  # noqa
        '0019xxa5': ('DS', '1', 'Receive bandwidth', ''),  # noqa
        '0019xxa7': ('DS', '1', 'User data 0', ''),  # noqa
        '0019xxa8': ('DS', '1', 'User data 1', ''),  # noqa
        '0019xxa9': ('DS', '1', 'User data 2', ''),  # noqa
        '0019xxaa': ('DS', '1', 'User data 3', ''),  # noqa
        '0019xxab': ('DS', '1', 'User data 4', ''),  # noqa
        '0019xxac': ('DS', '1', 'User data 5', ''),  # noqa
        '0019xxad': ('DS', '1', 'User data 6', ''),  # noqa
        '0019xxae': ('DS', '1', 'User data 7', ''),  # noqa
        '0019xxaf': ('DS', '1', 'User data 8', ''),  # noqa
        '0019xxb0': ('DS', '1', 'User data 9', ''),  # noqa
        '0019xxb1': ('DS', '1', 'User data 10', ''),  # noqa
        '0019xxb2': ('DS', '1', 'User data 11', ''),  # noqa
        '0019xxb3': ('DS', '1', 'User data 12', ''),  # noqa
        '0019xxb4': ('DS', '1', 'User data 13', ''),  # noqa
        '0019xxb5': ('DS', '1', 'User data 14', ''),  # noqa
        '0019xxb6': ('DS', '1', 'User data 15', ''),  # noqa
        '0019xxb7': ('DS', '1', 'User data 16', ''),  # noqa
        '0019xxb8': ('DS', '1', 'User data 17', ''),  # noqa
        '0019xxb9': ('DS', '1', 'User data 18', ''),  # noqa
        '0019xxba': ('DS', '1', 'User data 19', ''),  # noqa
        '0019xxbb': ('DS', '1', 'User data 20', ''),  # noqa
        '0019xxbc': ('DS', '1', 'User data 21', ''),  # noqa
        '0019xxbd': ('DS', '1', 'User data 22', ''),  # noqa
        '0019xxbe': ('DS', '1', 'Projection angle', ''),  # noqa
        '0019xxc0': ('SS', '1', 'Saturation planes', ''),  # noqa
        '0019xxc1': ('SS', '1', 'Surface coil intensity', ''),  # noqa
        '0019xxc2': ('SS', '1', 'SAT location R', ''),  # noqa
        '0019xxc3': ('SS', '1', 'SAT location L', ''),  # noqa
        '0019xxc4': ('SS', '1', 'SAT location A', ''),  # noqa
        '0019xxc5': ('SS', '1', 'SAT location P', ''),  # noqa
        '0019xxc6': ('SS', '1', 'SAT location H', ''),  # noqa
        '0019xxc7': ('SS', '1', 'SAT location F', ''),  # noqa
        '0019xxc8': ('SS', '1', 'SAT thickness R/L', ''),  # noqa
        '0019xxc9': ('SS', '1', 'SAT thickness A/P', ''),  # noqa
        '0019xxca': ('SS', '1', 'SAT thickness H/F', ''),  # noqa
        '0019xxcb': ('SS', '1', 'Phase Contrast flow axis', ''),  # noqa
        '0019xxcc': ('SS', '1', 'Velocity encoding', ''),  # noqa
        '0019xxcd': ('SS', '1', 'Thickness disclaimer', ''),  # noqa
        '0019xxce': ('SS', '1', 'Prescan type', ''),  # noqa
        '0019xxcf': ('SS', '1', 'Prescan status', ''),  # noqa
        '0019xxd0': ('SH', '1', 'Raw data type', ''),  # noqa
        '0019xxd2': ('SS', '1', 'Projection Algorithm', ''),  # noqa
        '0019xxd3': ('SH', '1', 'Projection Algorithm Name', ''),  # noqa
        '0019xxd4': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxd5': ('SS', '1', 'Fractional echo', ''),  # noqa
        '0019xxd6': ('SS', '1', 'Prep pulse', ''),  # noqa
        '0019xxd7': ('SS', '1', 'Cardiac phase number', ''),  # noqa
        '0019xxd8': ('SS', '1', 'Variable echoflag', ''),  # noqa
        '0019xxd9': ('DS', '1', 'Concatenated SAT {# DTI Diffusion Dir., release 9.0 & below}', ''),  # noqa
        '0019xxda': ('SS', '1', 'Reference channel used', ''),  # noqa
        '0019xxdb': ('DS', '1', 'Back projector coefficient', ''),  # noqa
        '0019xxdc': ('SS', '1', 'Primary speed correction used', ''),  # noqa
        '0019xxdd': ('SS', '1', 'Overrange correction used', ''),  # noqa
        '0019xxde': ('DS', '1', 'Dynamic Z alpha value', ''),  # noqa
        '0019xxdf': ('DS', '1', 'User data 23 {# DTI Diffusion Dir., release 9.0 & below}', ''),  # noqa
        '0019xxe0': ('DS', '1', 'User data 24 {# DTI Diffusion Dir., release 10.0 & above}', ''),  # noqa
        '0019xxe1': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxe2': ('DS', '1', 'Velocity Encode Scale', ''),  # noqa
        '0019xxe3': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xxe4': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xxe5': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxe6': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxe8': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxe9': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxeb': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxec': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxf0': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xxf1': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xxf2': ('SS', '1', 'Fast phases', ''),  # noqa
        '0019xxf3': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xxf4': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xxf9': ('DS', '1', 'Transmit gain', ''),  # noqa
    },
    'GEMS_ACRQA_1.0 BLOCK1': {
        '0023xx00': ('LO', '1', 'CR Exposure Menu Code', ''),  # noqa
        '0023xx10': ('LO', '1', 'CR Exposure Menu String', ''),  # noqa
        '0023xx20': ('LO', '1', 'CR EDR Mode', ''),  # noqa
        '0023xx30': ('LO', '1', 'CR Latitude', ''),  # noqa
        '0023xx40': ('LO', '1', 'CR Group Number', ''),  # noqa
        '0023xx50': ('US', '1', 'CR Image Serial Number', ''),  # noqa
        '0023xx60': ('LO', '1', 'CR Bar Code Number', ''),  # noqa
        '0023xx70': ('LO', '1', 'CR Film Output Exposure', ''),  # noqa
        '0023xx80': ('LO', '1', 'CR Film Format', ''),  # noqa
        '0023xx90': ('LO', '1', 'CR S-Shift String', ''),  # noqa
    },
    'GEMS_ACRQA_1.0 BLOCK2': {
        '0023xx00': ('US', '1', 'CR S-Shift', ''),  # noqa
        '0023xx10': ('DS', '1', 'CR C-Shift', ''),  # noqa
        '0023xx20': ('DS', '1', 'CR GT', ''),  # noqa
        '0023xx30': ('DS', '1', 'CR GA', ''),  # noqa
        '0023xx40': ('DS', '1', 'CR GC', ''),  # noqa
        '0023xx50': ('DS', '1', 'CR GS', ''),  # noqa
        '0023xx60': ('DS', '1', 'CR RT', ''),  # noqa
        '0023xx70': ('DS', '1', 'CR RE', ''),  # noqa
        '0023xx80': ('US', '1', 'CR RN', ''),  # noqa
        '0023xx90': ('DS', '1', 'CR DRT', ''),  # noqa
    },
    'GEMS_ACRQA_1.0 BLOCK3': {
        '0023xx00': ('DS', '1', 'CR DRE', ''),  # noqa
        '0023xx10': ('US', '1', 'CR DRN', ''),  # noqa
        '0023xx20': ('DS', '1', 'CR ORE', ''),  # noqa
        '0023xx30': ('US', '1', 'CR ORN', ''),  # noqa
        '0023xx40': ('US', '1', 'CR ORD', ''),  # noqa
        '0023xx50': ('LO', '1', 'CR Cassette Size', ''),  # noqa
        '0023xx60': ('LO', '1', 'CR Machine ID', ''),  # noqa
        '0023xx70': ('LO', '1', 'CR Machine Type', ''),  # noqa
        '0023xx80': ('LO', '1', 'CR Technician Code', ''),  # noqa
        '0023xx90': ('LO', '1', 'CR ES Parameters', ''),  # noqa
    },
    'GEMS_ACRQA_2.0 BLOCK1': {
        '0023xx00': ('LO', '1', 'CR Exposure Menu Code', ''),  # noqa
        '0023xx10': ('LO', '1', 'CR Exposure Menu String', ''),  # noqa
        '0023xx20': ('LO', '1', 'CR EDR Mode', ''),  # noqa
        '0023xx30': ('LO', '1', 'CR Latitude', ''),  # noqa
        '0023xx40': ('LO', '1', 'CR Group Number', ''),  # noqa
        '0023xx50': ('US', '1', 'CR Image Serial Number', ''),  # noqa
        '0023xx60': ('LO', '1', 'CR Bar Code Number', ''),  # noqa
        '0023xx70': ('LO', '1', 'CR Film Output Exposure', ''),  # noqa
        '0023xx80': ('LO', '1', 'CR Film Format', ''),  # noqa
        '0023xx90': ('LO', '1', 'CR S Shift String', ''),  # noqa
    },
    'GEMS_ACRQA_2.0 BLOCK2': {
        '0023xx00': ('US', '1', 'CR S Shift', ''),  # noqa
        '0023xx10': ('LO', '1', 'CR C Shift', ''),  # noqa
        '0023xx20': ('LO', '1', 'CR GT', ''),  # noqa
        '0023xx30': ('DS', '1', 'CR GA', ''),  # noqa
        '0023xx40': ('DS', '1', 'CR GC', ''),  # noqa
        '0023xx50': ('DS', '1', 'CR GS', ''),  # noqa
        '0023xx60': ('LO', '1', 'CR RT', ''),  # noqa
        '0023xx70': ('DS', '1', 'CR RE', ''),  # noqa
        '0023xx80': ('US', '1', 'CR RN', ''),  # noqa
        '0023xx90': ('DS', '1', 'CR DRT', ''),  # noqa
    },
    'GEMS_ACRQA_2.0 BLOCK3': {
        '0023xx00': ('DS', '1', 'CR DRE', ''),  # noqa
        '0023xx10': ('US', '1', 'CR DRN', ''),  # noqa
        '0023xx20': ('DS', '1', 'CR ORE', ''),  # noqa
        '0023xx30': ('US', '1', 'CR ORN', ''),  # noqa
        '0023xx40': ('US', '1', 'CR ORD', ''),  # noqa
        '0023xx50': ('LO', '1', 'CR Cassette Size', ''),  # noqa
        '0023xx60': ('LO', '1', 'CR Machine ID', ''),  # noqa
        '0023xx70': ('LO', '1', 'CR Machine Type', ''),  # noqa
        '0023xx80': ('LO', '1', 'CR Technician Code', ''),  # noqa
        '0023xx90': ('LO', '1', 'CR Energy Subtraction Parameters', ''),  # noqa
        '0023xxf0': ('LO', '1', 'CR Distribution Code', ''),  # noqa
        '0023xxff': ('US', '1', 'CR Shutters Applied', ''),  # noqa
    },
    'GEMS_ADWSoft_3D1': {
        '0047xx01': ('SQ', '1', 'Reconstruction Parameters Sequence', ''),  # noqa
        '0047xx49': ('UL', '3-n', 'Volume Color', ''),  # noqa
        '0047xx50': ('UL', '1', 'Volume Voxel Count', ''),  # noqa
        '0047xx51': ('UL', '1-n', 'Volume Segment Count', ''),  # noqa
        '0047xx53': ('US', '1', 'Volume Slice Size', ''),  # noqa
        '0047xx54': ('US', '1', 'Volume Slice Count', ''),  # noqa
        '0047xx55': ('SL', '1', 'Volume Threshold Value', ''),  # noqa
        '0047xx57': ('DS', '1', 'Volume Voxel Ratio', ''),  # noqa
        '0047xx58': ('DS', '1', 'Volume Voxel Size', ''),  # noqa
        '0047xx59': ('US', '1', 'Volume Z Position Size', ''),  # noqa
        '0047xx60': ('DS', '9', 'Volume Base Line', ''),  # noqa
        '0047xx61': ('DS', '3', 'Volume Center Point', ''),  # noqa
        '0047xx63': ('SL', '1', 'Volume Skew Base', ''),  # noqa
        '0047xx64': ('DS', '9', 'Volume Registration Transform Rotation Matrix', ''),  # noqa
        '0047xx65': ('DS', '3', 'Volume Registration Transform Translation Vector', ''),  # noqa
        '0047xx66': ('DS', '1', 'Volume Tilt', ''),  # noqa
        '0047xx70': ('DS', '1-n', 'KPV List', ''),  # noqa
        '0047xx71': ('IS', '1-n', 'X-Ray Tube Current List', ''),  # noqa
        '0047xx72': ('IS', '1-n', 'Exposure List', ''),  # noqa
        '0047xx80': ('LO', '1', 'Acquisition DLX Identifier', ''),  # noqa
        '0047xx81': ('IS', '1', 'Acquisition DLX 2D Series Count', ''),  # noqa
        '0047xx85': ('SQ', '1', 'Acquisition DLX 2D Series Sequence', ''),  # noqa
        '0047xx89': ('DS', '1-n', 'Contrast Agent Volume List', ''),  # noqa
        '0047xx8a': ('US', '1', 'Number Of Injections', ''),  # noqa
        '0047xx8b': ('US', '1', 'Frame Count', ''),  # noqa
        '0047xx91': ('LO', '1', 'XA 3D Reconstruction Algorithm Name', ''),  # noqa
        '0047xx92': ('CS', '1', 'XA 3D Reconstruction Algorithm Version', ''),  # noqa
        '0047xx93': ('DA', '1', 'DLX Calibration Date', ''),  # noqa
        '0047xx94': ('TM', '1', 'DLX Calibration Time', ''),  # noqa
        '0047xx95': ('CS', '1', 'DLX Calibration Status', ''),  # noqa
        '0047xx96': ('IS', '1-n', 'Used Frames', ''),  # noqa
        '0047xx98': ('US', '1', 'Transform Count', ''),  # noqa
        '0047xx99': ('SQ', '1', 'Transform Sequence', ''),  # noqa
        '0047xx9a': ('DS', '9', 'Transform Rotation Matrix', ''),  # noqa
        '0047xx9b': ('DS', '3', 'Transform Translation Vector', ''),  # noqa
        '0047xx9c': ('LO', '1', 'Transform Label', ''),  # noqa
        '0047xxb0': ('SQ', '1', 'Wireframe List', ''),  # noqa
        '0047xxb1': ('US', '1', 'Wireframe Count', ''),  # noqa
        '0047xxb2': ('US', '1', 'Location System', ''),  # noqa
        '0047xxb5': ('LO', '1', 'Wireframe Name', ''),  # noqa
        '0047xxb6': ('LO', '1', 'Wireframe Group Name', ''),  # noqa
        '0047xxb7': ('LO', '1', 'Wireframe Color', ''),  # noqa
        '0047xxb8': ('SL', '1', 'Wireframe Attributes', ''),  # noqa
        '0047xxb9': ('SL', '1', 'Wireframe Point Count', ''),  # noqa
        '0047xxba': ('SL', '1', 'Wireframe Timestamp', ''),  # noqa
        '0047xxbb': ('SQ', '1', 'Wireframe Point List', ''),  # noqa
        '0047xxbc': ('DS', '3', 'Wireframe Points Coordinates', ''),  # noqa
        '0047xxc0': ('DS', '3', 'Volume Upper Left High Corner RAS', ''),  # noqa
        '0047xxc1': ('DS', '9', 'Volume Slice To RAS Rotation Matrix', ''),  # noqa
        '0047xxc2': ('DS', '1', 'Volume Upper Left High Corner TLOC', ''),  # noqa
        '0047xxd1': ('OB', '1', 'Volume Segment List', ''),  # noqa
        '0047xxd2': ('OB', '1', 'Volume Gradient List', ''),  # noqa
        '0047xxd3': ('OB', '1', 'Volume Density List', ''),  # noqa
        '0047xxd4': ('OB', '1', 'Volume Z Position List', ''),  # noqa
        '0047xxd5': ('OB', '1', 'Volume Original Index List', ''),  # noqa
        '0047xxf4': ('LO', '1-n', 'Volume Name(s)', ''),  # noqa
        '0047xxf5': ('DS', '1-n', 'Min original density', ''),  # noqa
        '0047xxf6': ('DS', '1-n', 'Max original density', ''),  # noqa
        '0047xxf7': ('DS', '1-n', 'Min Converted Density', ''),  # noqa
        '0047xxf8': ('DS', '1-n', 'Max Converted Density', ''),  # noqa
        '0047xxf9': ('LO', '1', 'Protocol Film Name', ''),  # noqa
        '0047xxfa': ('US', '1', 'Protocol Resolution', ''),  # noqa
        '0047xxfb': ('US', '1', 'Phase Number (percent)', ''),  # noqa
        '0047xxfc': ('OB', '1', 'Volume midscan times list', ''),  # noqa
        '0047xxfd': ('OB', '1', 'Volume Registered Phases List', ''),  # noqa
        '0047xxfe': ('LO', '1', 'Protocol Name', ''),  # noqa
        '0047xxff': ('LO', '1', 'Protocol Title', ''),  # noqa
    },
    'GEMS_ADWSoft_3D2': {
        '0057xx01': ('OB', '1', 'Cardiac Reconstruction Algorithm List', ''),  # noqa
        '0057xx02': ('OB', '1', 'Average Heart Rate for Image List', ''),  # noqa
        '0057xx03': ('OB', '1', 'Temporal Resolution List', ''),  # noqa
        '0057xx04': ('LT', '1', 'Layout View Preset', ''),  # noqa
    },
    'GEMS_ADWSoft_DPO': {
        '0039xx80': ('IS', '1', 'Private Entity Number', ''),  # noqa
        '0039xx85': ('DA', '1', 'Private Entity Date', ''),  # noqa
        '0039xx90': ('TM', '1', 'Private Entity Time', ''),  # noqa
        '0039xx95': ('LO', '1', 'Private Entity Launch Command', ''),  # noqa
        '0039xxaa': ('CS', '1', 'Private Entity Type', ''),  # noqa
    },
    'GEMS_ADWSoft_DPO1': {
        '0039xx80': ('IS', '1', 'Private Entity Number', ''),  # noqa
        '0039xx85': ('DA', '1', 'Private Entity Date', ''),  # noqa
        '0039xx90': ('TM', '1', 'Private Entity Time', ''),  # noqa
        '0039xx95': ('LO', '1', 'Private Entity Launch Command', ''),  # noqa
        '0039xxaa': ('CS', '1', 'Private Entity Type', ''),  # noqa
    },
    'GEMS_AWSOFT_CD1': {
        '0039xx65': ('UI', '1', 'Reference to Study UID', ''),  # noqa
        '0039xx70': ('UI', '1', 'Reference to Series UID', ''),  # noqa
        '0039xx75': ('IS', '1', 'Reference to Original Instance', ''),  # noqa
        '0039xx80': ('IS', '1', 'DPO Number', ''),  # noqa
        '0039xx85': ('DA', '1', 'DPO Date', ''),  # noqa
        '0039xx90': ('TM', '1', 'DPO Time', ''),  # noqa
        '0039xx95': ('LO', '1', 'DPO Invocation String', ''),  # noqa
        '0039xxaa': ('CS', '1', 'DPO type', ''),  # noqa
        '0039xxff': ('OB', '1', 'DPO data', ''),  # noqa
    },
    'GEMS_AWSoft_SB1': {
        '0039xx50': ('UI', '1', 'Reference to Study UID', ''),  # noqa
        '0039xx51': ('UI', '1', 'Reference to Series UID', ''),  # noqa
        '0039xx52': ('IS', '1', 'Reference to Original Instance Number', ''),  # noqa
        '0039xx95': ('LO', '1', 'Private Entity Launch Command', ''),  # noqa
    },
    'GEMS_CTHD_01': {
        '0033xx02': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_CT_CARDIAC_001': {
        '0049xx01': ('SQ', '1', 'CT Cardiac Sequence', ''),  # noqa
        '0049xx02': ('CS', '1', 'HeartRateAtConfirm', ''),  # noqa
        '0049xx03': ('FL', '1', 'AvgHeartRatePriorToConfirm', ''),  # noqa
        '0049xx04': ('CS', '1', 'MinHeartRatePriorToConfirm', ''),  # noqa
        '0049xx05': ('CS', '1', 'MaxHeartRatePriorToConfirm', ''),  # noqa
        '0049xx06': ('FL', '1', 'StdDevHeartRatePriorToConfirm', ''),  # noqa
        '0049xx07': ('US', '1', 'NumHeartRateSamplesPriorToConfirm', ''),  # noqa
        '0049xx08': ('CS', '1', 'AutoHeartRateDetectPredict', ''),  # noqa
        '0049xx09': ('CS', '1', 'SystemOptimizedHeartRate', ''),  # noqa
        '0049xx0a': ('ST', '1', 'EkgMonitorType', ''),  # noqa
        '0049xx0b': ('CS', '1', 'NumReconSectors', ''),  # noqa
        '0049xx0c': ('FL', '256', 'RpeakTimeStamps', ''),  # noqa
    },
    'GEMS_CT_HINO_01': {
        '004bxx01': ('DS', '1-n', 'Beam Thickess', ''),  # noqa
        '004bxx02': ('DS', '1-n', 'R Time', ''),  # noqa
        '004bxx03': ('IS', '1', 'HBC Number', ''),  # noqa
    },
    'GEMS_CT_VES_01': {
        '0051xx01': ('SQ', '1', 'CTVESSequence', ''),  # noqa
    },
    'GEMS_DLX_DOSE_01': {
        '0027xx01': ('SQ', '1', 'Private Radiation Dose Sequence', ''),  # noqa
        '0027xx02': ('IS', '1', 'Run Number', ''),  # noqa
        '0027xx03': ('TM', '1', 'Run Time', ''),  # noqa
        '0027xx04': ('IS', '1', 'Number of Frames', ''),  # noqa
        '0027xx05': ('DS', '1', 'Frames per Second', ''),  # noqa
        '0027xx06': ('CS', '1', 'Plane', ''),  # noqa
        '0027xx07': ('DS', '1', 'KV', ''),  # noqa
        '0027xx08': ('DS', '1', 'MA', ''),  # noqa
        '0027xx09': ('DS', '1', 'Mas', ''),  # noqa
        '0027xx10': ('DS', '1', 'Ms', ''),  # noqa
        '0027xx11': ('DS', '1', 'Angulation', ''),  # noqa
        '0027xx12': ('DS', '1', 'Rotation', ''),  # noqa
        '0027xx13': ('DS', '1', 'Focal Distance', ''),  # noqa
        '0027xx14': ('DS', '1', 'Image Intensifier Mode', ''),  # noqa
    },
    'GEMS_DL_FRAME_01': {
        '0025xx02': ('IS', '1', 'Frame Id', ''),  # noqa
        '0025xx03': ('DS', '1', 'Distance Source To Detector', ''),  # noqa
        '0025xx04': ('DS', '1', 'Distance Source To Patient', ''),  # noqa
        '0025xx05': ('DS', '1', 'Distance Source To Skin', ''),  # noqa
        '0025xx06': ('DS', '1', 'Positioner Primary Angle', ''),  # noqa
        '0025xx07': ('DS', '1', 'Positioner Secondary Angle', ''),  # noqa
        '0025xx08': ('IS', '1', 'Beam Orientation', ''),  # noqa
        '0025xx09': ('DS', '1', 'Larm Angle', ''),  # noqa
        '0025xx0a': ('SQ', '1', 'Frame Sequence', ''),  # noqa
        '0025xx0b': ('DS', '1', 'Target Cnr', ''),  # noqa
        '0025xx10': ('DS', '1', 'Pivot Angle', ''),  # noqa
        '0025xx1a': ('DS', '1', 'Arc Angle', ''),  # noqa
        '0025xx1b': ('DS', '1', 'Table Vertical Position', ''),  # noqa
        '0025xx1c': ('DS', '1', 'Table Longitudinal Position', ''),  # noqa
        '0025xx1d': ('DS', '1', 'Table Lateral Position', ''),  # noqa
        '0025xx1e': ('IS', '1', 'Beam Cover Area', ''),  # noqa
        '0025xx1f': ('DS', '1', 'Kvp Actual', ''),  # noqa
        '0025xx20': ('DS', '1', 'Mas Actual', ''),  # noqa
        '0025xx21': ('DS', '1', 'Pw Actual', ''),  # noqa
        '0025xx22': ('DS', '1', 'Kvp Commanded', ''),  # noqa
        '0025xx23': ('DS', '1', 'Mas Commanded', ''),  # noqa
        '0025xx24': ('DS', '1', 'Pw Commanded', ''),  # noqa
        '0025xx25': ('CS', '1', 'Grid', ''),  # noqa
        '0025xx26': ('DS', '1', 'Sensor Feedback', ''),  # noqa
        '0025xx27': ('DS', '1', 'Target Entrance Dose', ''),  # noqa
        '0025xx28': ('DS', '1', 'Cnr Commanded', ''),  # noqa
        '0025xx29': ('DS', '1', 'Contrast Commanded', ''),  # noqa
        '0025xx2a': ('DS', '1', 'Ept Actual', ''),  # noqa
        '0025xx2b': ('IS', '1', 'Spectral Filter Znb', ''),  # noqa
        '0025xx2c': ('DS', '1', 'Spectral Filter Weight', ''),  # noqa
        '0025xx2d': ('DS', '1', 'Spectral Filter Density', ''),  # noqa
        '0025xx2e': ('IS', '1', 'Spectral Filter Thickness', ''),  # noqa
        '0025xx2f': ('IS', '1', 'Spectral Filter Status', ''),  # noqa
        '0025xx30': ('IS', '1', 'Fov Dimension', ''),  # noqa
        '0025xx33': ('IS', '1', 'Fov Origin', ''),  # noqa
        '0025xx34': ('IS', '1', 'Collimator Left Vertical Edge', ''),  # noqa
        '0025xx35': ('IS', '1', 'Collimator Right Vertical Edge', ''),  # noqa
        '0025xx36': ('IS', '1', 'Collimator Up Horizontal Edge', ''),  # noqa
        '0025xx37': ('IS', '1', 'Collimator Low Horizontal Edge', ''),  # noqa
        '0025xx38': ('IS', '1', 'Vertices Polygonal Collimator', ''),  # noqa
        '0025xx39': ('IS', '1', 'Contour Filter Distance', ''),  # noqa
        '0025xx3a': ('UL', '1', 'Contour Filter Angle', ''),  # noqa
        '0025xx3b': ('CS', '1', 'Table Rotation Status', ''),  # noqa
        '0025xx3c': ('CS', '1', 'Internal Label Frame', ''),  # noqa
    },
    'GEMS_DL_IMG_01': {
        '0019xx0b': ('DS', '1', 'Fov Dimension Double', ''),  # noqa
        '0019xx0c': ('FL', '2-2n', 'LV Diastolic contour', ''),  # noqa
        '0019xx0d': ('FL', '2-2n', 'LV Systolic contour', ''),  # noqa
        '0019xx2b': ('FL', '1', 'Distance to table top', ''),  # noqa
        '0019xx30': ('LO', '1', 'Image File Name', ''),  # noqa
        '0019xx31': ('IS', '1', 'Default Spatial Filter Family', ''),  # noqa
        '0019xx32': ('IS', '1', 'Default Spatial Filter Strength', ''),  # noqa
        '0019xx33': ('DS', '1', 'Min Saturation Dose', ''),  # noqa
        '0019xx34': ('DS', '1', 'Detector Gain', ''),  # noqa
        '0019xx35': ('DS', '1', 'Patient Dose Limit', ''),  # noqa
        '0019xx36': ('DS', '1', 'Preproc Image Rate Max', ''),  # noqa
        '0019xx37': ('CS', '1', 'Sensor Roi Shape', ''),  # noqa
        '0019xx38': ('DS', '1', 'Sensor Roi x Position', ''),  # noqa
        '0019xx39': ('DS', '1', 'Sensor Roi y Position', ''),  # noqa
        '0019xx3a': ('DS', '1', 'Sensor Roi x Size', ''),  # noqa
        '0019xx3b': ('DS', '1', 'Sensor Roi y Size', ''),  # noqa
        '0019xx3d': ('DS', '1', 'Noise Sensitivity', ''),  # noqa
        '0019xx3e': ('DS', '1', 'Sharp Sensitivity', ''),  # noqa
        '0019xx3f': ('DS', '1', 'Contrast Sensitivity', ''),  # noqa
        '0019xx40': ('DS', '1', 'Lag Sensitivity', ''),  # noqa
        '0019xx41': ('CS', '1', 'Tube', ''),  # noqa
        '0019xx42': ('US', '1', 'Detector Size Rows', ''),  # noqa
        '0019xx43': ('US', '1', 'Detector Size Columns', ''),  # noqa
        '0019xx44': ('DS', '1', 'Min Object Size', ''),  # noqa
        '0019xx45': ('DS', '1', 'Max Object Size', ''),  # noqa
        '0019xx46': ('DS', '1', 'Max Object Speed', ''),  # noqa
        '0019xx47': ('CS', '1', 'Object Back Motion', ''),  # noqa
        '0019xx48': ('UL', '1', 'Exposure Trajectory Family', ''),  # noqa
        '0019xx49': ('DS', '1', 'Window Time Duration', ''),  # noqa
        '0019xx4a': ('CS', '1', 'Positioner Angle Display Mode', ''),  # noqa
        '0019xx4b': ('IS', '1', 'Detector Origin', ''),  # noqa
        '0019xx4c': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx4e': ('DS', '1', 'Default Brightness Contrast', ''),  # noqa
        '0019xx4f': ('DS', '1', 'User Brightness Contrast', ''),  # noqa
        '0019xx50': ('IS', '1', 'Source Series Number', ''),  # noqa
        '0019xx51': ('IS', '1', 'Source Image Number', ''),  # noqa
        '0019xx52': ('IS', '1', 'Source Frame Number', ''),  # noqa
        '0019xx53': ('UI', '1', 'Source Series Item Id', ''),  # noqa
        '0019xx54': ('UI', '1', 'Source Image Item Id', ''),  # noqa
        '0019xx55': ('UI', '1', 'Source Frame Item Id', ''),  # noqa
        '0019xx80': ('DS', '1', 'Image Dose', ''),  # noqa
        '0019xx81': ('US', '1', 'Calibration Frame', ''),  # noqa
        '0019xx82': ('CS', '1', 'Calibration Object', ''),  # noqa
        '0019xx83': ('DS', '1', 'Calibration Object Size mm', ''),  # noqa
        '0019xx84': ('FL', '1', 'Calibration Factor', ''),  # noqa
        '0019xx85': ('DA', '1', 'Calibration Date', ''),  # noqa
        '0019xx86': ('TM', '1', 'Calibration Time', ''),  # noqa
        '0019xx87': ('US', '1', 'Calibration Accuracy', ''),  # noqa
        '0019xx88': ('CS', '1', 'Calibration Extended', ''),  # noqa
        '0019xx89': ('US', '1', 'Calibration Image Original', ''),  # noqa
        '0019xx8a': ('US', '1', 'Calibration Frame Original', ''),  # noqa
        '0019xx8b': ('US', '1', 'Calibration Number Of Points Uif', ''),  # noqa
        '0019xx8c': ('US', '1', 'Calibration Points Row', ''),  # noqa
        '0019xx8d': ('US', '1', 'Calibration Points Column', ''),  # noqa
        '0019xx8e': ('FL', '1', 'Calibration Magnification Ratio', ''),  # noqa
        '0019xx8f': ('LO', '1', 'Calibration Sw Version', ''),  # noqa
        '0019xx90': ('LO', '1', 'Extend Calibration Sw Version', ''),  # noqa
        '0019xx91': ('IS', '1', 'Calibration Return Code', ''),  # noqa
        '0019xx92': ('DS', '1', 'Detector Rotation Angle', ''),  # noqa
        '0019xx93': ('CS', '1', 'Spatial Change', ''),  # noqa
        '0019xx94': ('CS', '1', 'Inconsistent Flag', ''),  # noqa
        '0019xx95': ('CS', '1', 'Image Sweep', ''),  # noqa
        '0019xx96': ('CS', '1', 'Internal Label Image', ''),  # noqa
        '0019xx97': ('DS', '1', 'Angle 1 Increment', ''),  # noqa
        '0019xx98': ('DS', '1', 'Angle 2 Increment', ''),  # noqa
        '0019xx99': ('DS', '1', 'Angle 3 Increment', ''),  # noqa
        '0019xx9a': ('DS', '1', 'Sensor Feedback', ''),  # noqa
        '0019xx9b': ('CS', '1', 'Grid', ''),  # noqa
        '0019xx9c': ('FL', '1', 'Default Mask Pixel Shift', ''),  # noqa
        '0019xx9d': ('CS', '1', 'Applicable Review Mode', ''),  # noqa
        '0019xx9e': ('DS', '1', 'Log Lut Control Points', ''),  # noqa
        '0019xx9f': ('DS', '1', 'Exp Lut Control Points', ''),  # noqa
        '0019xxa0': ('DS', '1', 'ABD Value', ''),  # noqa
        '0019xxa1': ('DS', '1', 'Sub Window Center', ''),  # noqa
        '0019xxa2': ('DS', '1', 'Sub Window Width', ''),  # noqa
        '0019xxa3': ('DS', '1', 'Image Rotation', ''),  # noqa
        '0019xxa4': ('CS', '1', 'Auto Injection Enabled', ''),  # noqa
        '0019xxa5': ('CS', '1', 'Injection Phase', ''),  # noqa
        '0019xxa6': ('DS', '1', 'Injection Delay', ''),  # noqa
        '0019xxa7': ('IS', '1', 'Reference Injection Frame Number', ''),  # noqa
        '0019xxa8': ('DS', '1', 'Injection Duration', ''),  # noqa
        '0019xxa9': ('DS', '1', 'EPT', ''),  # noqa
        '0019xxaa': ('CS', '1', 'Can Downscan 512', ''),  # noqa
        '0019xxab': ('IS', '1', 'Current Spatial Filter Strength', ''),  # noqa
        '0019xxac': ('DS', '1', 'Brightness Sensitivity', ''),  # noqa
        '0019xxad': ('DS', '1', 'Exp Lut NOSUB Control Points', ''),  # noqa
        '0019xxae': ('LO', '1-n', 'SUB operator LUTs names', ''),  # noqa
        '0019xxaf': ('DS', '1-n', 'kVp actual vector', ''),  # noqa
        '0019xxb0': ('DS', '1-n', 'mAs actual vector', ''),  # noqa
        '0019xxb1': ('LO', '1', 'Acquisition Mode Description', ''),  # noqa
        '0019xxb2': ('LO', '1', 'Acquisition Mode Display Label', ''),  # noqa
        '0019xxb3': ('LO', '1', 'Acquisition Protocol User Name', ''),  # noqa
        '0019xxb8': ('FL', '1', 'Recommended display frame rate float', ''),  # noqa
        '0019xxb9': ('FL', '1-n', 'ABD Vector', ''),  # noqa
        '0019xxba': ('CS', '1', 'Acquisition region', ''),  # noqa
        '0019xxbb': ('CS', '1', 'Acquisition SUB mode', ''),  # noqa
        '0019xxbc': ('FL', '1', 'Unknown', ''),  # noqa
        '0019xxbd': ('CS', '1-n', 'Table rotation status vector', ''),  # noqa
        '0019xxbe': ('FL', '1-n', 'Source to image distance per frame vector', ''),  # noqa
        '0019xxc2': ('DS', '1-n', 'pw actual vector', ''),  # noqa
        '0019xxc4': ('IS', '1', 'Spectral filter thickness', ''),  # noqa
        '0019xxc5': ('FL', '1', 'Preselected pivot rotation speed', ''),  # noqa
        '0019xxc7': ('CS', '1', 'Patient position per image', ''),  # noqa
        '0019xxc8': ('CS', '1', '3D structure of interest', ''),  # noqa
        '0019xxc9': ('CS', '1', '3D calibration out of date flag', ''),  # noqa
        '0019xxca': ('IS', '1', '3Dspin expected number of frames', ''),  # noqa
        '0019xxd4': ('FL', '1', 'Detection gain value', ''),  # noqa
        '0019xxd5': ('FL', '1', 'mR mAs calibration value', ''),  # noqa
        '0019xxdc': ('LO', '1', 'DRM LUT file name', ''),  # noqa
        '0019xxdd': ('DS', '1-n', 'DRM Strength', ''),  # noqa
        '0019xxde': ('CS', '1', 'Acquisition Plane', ''),  # noqa
        '0019xxdf': ('FL', '1-n', 'LP off longitudinal position Z', ''),  # noqa
        '0019xxe0': ('FL', '1', 'DAP of current record', ''),  # noqa
        '0019xxe1': ('FL', '1', 'Pivot Lateral Angle', ''),  # noqa
        '0019xxe2': ('FL', '1', 'Carm Lateral Angle', ''),  # noqa
        '0019xxe3': ('FL', '1-n', 'Pivot Lateral Angle increment', ''),  # noqa
        '0019xxe4': ('FL', '1-n', 'Carm Lateral Angle increment', ''),  # noqa
        '0019xxe7': ('FL', '1', 'LP off long pos Z first frame', ''),  # noqa
        '0019xxe8': ('FL', '1-n', 'LP off long pos Z increment', ''),  # noqa
        '0019xxe9': ('FL', '1-n', 'Source to detector distance per frame vector', ''),  # noqa
        '0019xxea': ('FL', '1', 'Unknown', ''),  # noqa
        '0019xxeb': ('FL', '1', 'Unknown', ''),  # noqa
        '0019xxec': ('FL', '1', 'Unknown', ''),  # noqa
        '0019xxed': ('FL', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_DL_PATNT_01': {
        '0011xx80': ('UI', '1', 'Patient Instance Uid', ''),  # noqa
        '0011xx81': ('IS', '1', 'Last Study Number', ''),  # noqa
        '0011xx82': ('CS', '1', 'Patient Repaired', ''),  # noqa
        '0011xx83': ('CS', '1', 'Lock Demographics', ''),  # noqa
    },
    'GEMS_DL_SERIES': {
        '0015xx87': ('IS', '1', 'Number of images', ''),  # noqa
        '0019xx0b': ('DS', '1-2', 'fov dimension double', ''),  # noqa
        '0019xx31': ('IS', '1', 'default spatial filter family', ''),  # noqa
        '0019xx32': ('IS', '1', 'default spatial filter strength', ''),  # noqa
        '0019xx4b': ('IS', '2', 'Detector origin', ''),  # noqa
        '0019xx4e': ('DS', '2', 'def_bright_contr', ''),  # noqa
        '0019xx4f': ('DS', '2', 'user_bright_contr', ''),  # noqa
        '0019xx81': ('US', '1', 'Calibration frame', ''),  # noqa
        '0019xx82': ('CS', '1', 'Calibration object', ''),  # noqa
        '0019xx83': ('DS', '1', 'Calibration object size mm', ''),  # noqa
        '0019xx84': ('FL', '1', 'Calibration factor', ''),  # noqa
        '0019xx85': ('DA', '1', 'Calibration date', ''),  # noqa
        '0019xx86': ('TM', '1', 'Calibration time', ''),  # noqa
        '0019xx87': ('US', '1', 'Calibration accuracy', ''),  # noqa
        '0019xx88': ('CS', '1', 'Calibration extended', ''),  # noqa
        '0019xx89': ('US', '1', 'Calibration image original', ''),  # noqa
        '0019xx8a': ('US', '1', 'Calibration frame original', ''),  # noqa
        '0019xx8b': ('US', '1', 'Calibration nb points uif', ''),  # noqa
        '0019xx8c': ('US', '1-n', 'Calibration points row', ''),  # noqa
        '0019xx8d': ('US', '1-n', 'Calibration points column', ''),  # noqa
        '0019xx8e': ('FL', '1', 'Calibration mag ratio', ''),  # noqa
        '0019xx8f': ('LO', '1', 'Calibration sw version', ''),  # noqa
        '0019xx90': ('LO', '1', 'Extend calib sw version', ''),  # noqa
        '0019xx91': ('IS', '1', 'Calibration return code', ''),  # noqa
        '0019xx92': ('DS', '1', 'detector_rot_angle', ''),  # noqa
        '0019xx93': ('CS', '1', 'Spatial change', ''),  # noqa
        '0019xx95': ('CS', '2', 'Image sweep', ''),  # noqa
        '0019xx97': ('DS', '1-n', 'Angle 1 increment', ''),  # noqa
        '0019xx98': ('DS', '1-n', 'Angle 2 increment', ''),  # noqa
        '0019xx99': ('DS', '1-n', 'Angle 3 increment', ''),  # noqa
        '0019xx9a': ('DS', '1-n', 'sensor feedback', ''),  # noqa
        '0019xx9d': ('CS', '1', 'applicable review mode', ''),  # noqa
        '0019xx9e': ('DS', '1-n', 'log LUT control points', ''),  # noqa
        '0019xx9f': ('DS', '1-n', 'exp LUT SUB control points', ''),  # noqa
        '0019xxa0': ('DS', '1', 'ABD value', ''),  # noqa
        '0019xxa1': ('DS', '1', 'Sub window center', ''),  # noqa
        '0019xxa2': ('DS', '1', 'Sub window width', ''),  # noqa
        '0019xxa4': ('CS', '1', 'Auto injection enabled', ''),  # noqa
        '0019xxa5': ('CS', '1', 'injection phase', ''),  # noqa
        '0019xxa6': ('DS', '1', 'injection delay', ''),  # noqa
        '0019xxa7': ('IS', '1', 'reference injection frame number', ''),  # noqa
        '0019xxa9': ('DS', '1-n', 'EPT', ''),  # noqa
        '0019xxaa': ('CS', '1', 'can downscan 512', ''),  # noqa
        '0019xxab': ('IS', '1', 'current spatial filter strength', ''),  # noqa
        '0019xxad': ('DS', '1-n', 'exp LUT NOSUB control points', ''),  # noqa
        '0019xxae': ('LO', '1-n', 'SUB operator LUTs names', ''),  # noqa
        '0019xxc4': ('IS', '1', 'Default spatial filter family', ''),  # noqa
        '0019xxc5': ('FL', '1', 'Preselected pivot rotation speed', ''),  # noqa
        '0019xxc7': ('CS', '1', 'Patient position per image', ''),  # noqa
        '0019xxc8': ('CS', '1', '3D structure of interest', ''),  # noqa
        '0019xxc9': ('CS', '1', '3D calibration out of date flag', ''),  # noqa
        '0019xxca': ('IS', '1', '3Dspin expected number of frames', ''),  # noqa
        '0019xxd4': ('FL', '1', 'Detection gain value', ''),  # noqa
        '0019xxd5': ('FL', '1', 'mR mAs calibration value', ''),  # noqa
        '0019xxdc': ('LO', '1', 'DRM LUT file name', ''),  # noqa
        '0019xxdd': ('DS', '1-n', 'DRM Strength', ''),  # noqa
    },
    'GEMS_DL_SERIES_01': {
        '0015xx85': ('LO', '1', 'Series File Name', ''),  # noqa
        '0015xx87': ('IS', '1', 'Number Of Images', ''),  # noqa
        '0015xx8c': ('CS', '1', 'Sent Flag', ''),  # noqa
        '0015xx8d': ('US', '1', 'Item Locked', ''),  # noqa
        '0019xx4c': ('CS', '1', 'internal label', ''),  # noqa
        '0019xx4d': ('CS', '1', 'browser hide', ''),  # noqa
    },
    'GEMS_DL_STUDY_01': {
        '0015xx80': ('DS', '1', 'Study Dose', ''),  # noqa
        '0015xx81': ('DS', '1', 'Study Total Dap', ''),  # noqa
        '0015xx82': ('DS', '1', 'Study Fluoro Dap', ''),  # noqa
        '0015xx83': ('IS', '1', 'Study Fluoro Time', ''),  # noqa
        '0015xx84': ('DS', '1', 'Study Record Dap', ''),  # noqa
        '0015xx85': ('IS', '1', 'Study Record Time', ''),  # noqa
        '0015xx86': ('IS', '1', 'Last Xa Number', ''),  # noqa
        '0015xx88': ('PN', '1', 'Default Operator Name', ''),  # noqa
        '0015xx89': ('PN', '1', 'Default Performing Physician Name', ''),  # noqa
        '0015xx8a': ('CS', '1', 'Default Patient Orientation', ''),  # noqa
        '0015xx8b': ('IS', '1', 'Last Sc Number', ''),  # noqa
        '0015xx8e': ('UI', '1', 'Common Series Instance Uid', ''),  # noqa
        '0015xx8f': ('IS', '1', 'Study Number', ''),  # noqa
        '0015xx92': ('FL', '1', 'Study dose Frontal', ''),  # noqa
        '0015xx93': ('FL', '1', 'Study total dap Frontal', ''),  # noqa
        '0015xx94': ('FL', '1', 'Study fluoro dap frontal', ''),  # noqa
        '0015xx95': ('IS', '1', 'Study fluoro time frontal', ''),  # noqa
        '0015xx96': ('FL', '1', 'Study record dap frontal', ''),  # noqa
        '0015xx97': ('IS', '1', 'Study record time frontal', ''),  # noqa
        '0015xx98': ('FL', '1', 'Study dose lateral', ''),  # noqa
        '0015xx99': ('FL', '1', 'Study total dap lateral', ''),  # noqa
        '0015xx9a': ('FL', '1', 'Study fluoro dap lateral', ''),  # noqa
        '0015xx9b': ('IS', '1', 'Study fluoro time lateral', ''),  # noqa
        '0015xx9c': ('FL', '1', 'Study record dap leteral', ''),  # noqa
        '0015xx9d': ('IS', '1', 'Study record time lateral', ''),  # noqa
    },
    'GEMS_DRS_1': {
        '0037xx10': ('LO', '1', 'Referring Department', ''),  # noqa
        '0037xx20': ('US', '1', 'Screen Number', ''),  # noqa
        '0037xx40': ('SH', '1', 'Left Orientation', ''),  # noqa
        '0037xx42': ('SH', '1', 'Right Orientation', ''),  # noqa
        '0037xx50': ('CS', '1', 'Inversion', ''),  # noqa
        '0037xx60': ('US', '1', 'DSA', ''),  # noqa
    },
    'GEMS_FALCON_03': {
        '0045xx55': ('DS', '8', 'A_Coefficients', ''),  # noqa
        '0045xx62': ('IS', '1', 'User Window Center', ''),  # noqa
        '0045xx63': ('IS', '1', 'User Window Width', ''),  # noqa
        '0045xx65': ('IS', '1', 'Requested Detector Entrance Dose', ''),  # noqa
        '0045xx67': ('DS', '3', 'VOI LUT Assymmetry parameter beta', ''),  # noqa
        '0045xx69': ('IS', '1', 'Collimator rotation', ''),  # noqa
        '0045xx72': ('DS', '1', 'Collimator Width', ''),  # noqa
        '0045xx73': ('DS', '1', 'Collimator Height', ''),  # noqa
    },
    'GEMS_FUNCTOOL_01': {
        '0051xx01': ('LO', '1', 'Functional Proc Group Name', ''),  # noqa
        '0051xx02': ('LO', '1', 'Functional Processing Name', ''),  # noqa
        '0051xx03': ('SL', '1', 'Bias of Functional Image', ''),  # noqa
        '0051xx04': ('FL', '1', 'Scale of Functional Image', ''),  # noqa
        '0051xx05': ('SL', '1', 'Length of Parameters String', ''),  # noqa
        '0051xx06': ('LT', '1', 'Store Parameters string, delimited by character ESC=0x1B (27)', ''),  # noqa
        '0051xx07': ('LO', '1', 'Functional Image Version', ''),  # noqa
        '0051xx08': ('SL', '1', 'Store Color Ramp', ''),  # noqa
        '0051xx09': ('SL', '1', 'Store Width of Functional Image', ''),  # noqa
        '0051xx0a': ('SL', '1', 'Store level of Functional Image', ''),  # noqa
        '0051xx0b': ('FL', '1', 'Store B-Value with Functional Image', ''),  # noqa
        '0051xx0c': ('LO', '1', 'Analysis Package', ''),  # noqa
    },
    'GEMS_GDXE_ATHENAV2_INTERNAL_USE': {
        '7fdfxx10': ('LT', '1', 'PPS Stream', ''),  # noqa
        '7fdfxx11': ('LT', '1', 'Pixel Data References (temporary)', ''),  # noqa
        '7fdfxx20': ('SS', '1', 'Auto Push Tag', ''),  # noqa
        '7fdfxx25': ('CS', '1', 'PPS Status', ''),  # noqa
    },
    'GEMS_GDXE_FALCON_04': {
        '0011xx03': ('UI', '1', 'Processed Series UID', ''),  # noqa
        '0011xx04': ('CS', '1', 'Acquisition Type', ''),  # noqa
        '0011xx05': ('UI', '1', 'Acquisition UID', ''),  # noqa
        '0011xx06': ('DS', '1', 'Image Dose', ''),  # noqa
        '0011xx07': ('FL', '1', 'Study Dose', ''),  # noqa
        '0011xx08': ('FL', '1', 'Study DAP', ''),  # noqa
        '0011xx09': ('SL', '1', 'Non-Digital Exposures', ''),  # noqa
        '0011xx10': ('SL', '1', 'Total Exposures', ''),  # noqa
        '0011xx11': ('LT', '1', 'ROI', ''),  # noqa
        '0011xx12': ('LT', '1', 'Patient Size String', ''),  # noqa
        '0011xx13': ('UI', '1', 'SPS UID', ''),  # noqa
        '0011xx14': ('UI', '1', 'Unknown', ''),  # noqa
        '0011xx15': ('DS', '1', 'Detector ARC Gain', ''),  # noqa
        '0011xx16': ('LT', '1', 'Processing Debug Info', ''),  # noqa
        '0011xx17': ('CS', '1', 'Override mode', ''),  # noqa
        '0011xx19': ('DS', '1', 'Film Speed Selection', ''),  # noqa
        '0011xx27': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx28': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx29': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx30': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx31': ('IS', '8', 'Detected Field of View', ''),  # noqa
        '0011xx32': ('IS', '8', 'Adjusted Field of View', ''),  # noqa
        '0011xx33': ('DS', '1', 'Detected Exposure Index', ''),  # noqa
        '0011xx34': ('DS', '1', 'Compensated Detector Exposure', ''),  # noqa
        '0011xx35': ('DS', '1', 'Uncompensated Detector Exposure', ''),  # noqa
        '0011xx36': ('DS', '1', 'Median Anatomy Count Value', ''),  # noqa
        '0011xx37': ('DS', '2', 'DEI lower and upper limit values', ''),  # noqa
        '0011xx38': ('SL', '6', 'Shift Vector for Pasting', ''),  # noqa
        '0011xx39': ('CS', '1', 'Image Number in Pasting', ''),  # noqa
        '0011xx40': ('SL', '1', 'Pasting Overlap', ''),  # noqa
        '0011xx41': ('IS', '24', 'Sub-image Collimator Vertices', ''),  # noqa
        '0011xx42': ('LO', '1', 'View IP', ''),  # noqa
        '0011xx43': ('IS', '24', 'Key-stone Co-ordinates', ''),  # noqa
        '0011xx44': ('CS', '1', 'Receptor Type', ''),  # noqa
        '0011xx46': ('LO', '1-n', 'Unknown', ''),  # noqa
        '0011xx47': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_GENIE_1': {
        '0009xx01': ('SH', '1', 'Unknown', ''),  # noqa
        '0009xx10': ('LO', '1', 'Study Name', ''),  # noqa
        '0009xx11': ('SL', '1', 'Study Flags', ''),  # noqa
        '0009xx12': ('SL', '1', 'Study Type', ''),  # noqa
        '0009xx1e': ('UI', '1', 'Dataset UID', ''),  # noqa
        '0009xx20': ('LO', '1', 'Series Object Name', ''),  # noqa
        '0009xx21': ('SL', '1', 'Series Flags', ''),  # noqa
        '0009xx22': ('SH', '1', 'User Orientation', ''),  # noqa
        '0009xx23': ('SL', '1', 'Initiation Type', ''),  # noqa
        '0009xx24': ('SL', '1', 'Initiation Delay', ''),  # noqa
        '0009xx25': ('SL', '1', 'Initiation Count Rate', ''),  # noqa
        '0009xx26': ('SL', '1', 'Number Energy Sets', ''),  # noqa
        '0009xx27': ('SL', '1', 'Number Detectors', ''),  # noqa
        '0009xx28': ('SL', '1', 'Number RR Windows', ''),  # noqa
        '0009xx29': ('SL', '1', 'Number MG Time Slots', ''),  # noqa
        '0009xx2a': ('SL', '1', 'Number View Sets', ''),  # noqa
        '0009xx2b': ('LO', '1', 'Trigger History UID', ''),  # noqa
        '0009xx2c': ('LO', '1', 'Series Comments', ''),  # noqa
        '0009xx2d': ('SL', '1', 'Track Beat Average', ''),  # noqa
        '0009xx2e': ('FD', '1', 'Distance Prescribed', ''),  # noqa
        '0009xx2f': ('SL', '1', 'Table Direction', ''),  # noqa
        '0009xx30': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx33': ('FD', '1', 'Rotational Continuous Speed', ''),  # noqa
        '0009xx34': ('SL', '1', 'Gantry Motion Type (retired)', ''),  # noqa
        '0009xx35': ('SL', '1', 'Gantry Locus Type', ''),  # noqa
        '0009xx37': ('SL', '1', 'Starting Heart Rate', ''),  # noqa
        '0009xx38': ('SL', '1', 'RR Window Width', ''),  # noqa
        '0009xx39': ('SL', '1', 'RR Window Offset', ''),  # noqa
        '0009xx3a': ('SL', '1', 'Percent Cycle Imaged', ''),  # noqa
        '0009xx40': ('PN', '1', 'Patient Object Name', ''),  # noqa
        '0009xx41': ('SL', '1', 'Patient Flags', ''),  # noqa
        '0009xx42': ('DA', '1', 'Patient Creation Date', ''),  # noqa
        '0009xx43': ('TM', '1', 'Patient Creation Time', ''),  # noqa
        '0009xx44': ('SL', '1', 'Num Views Acquired (retired)', ''),  # noqa
        '0009xx45': ('LT', '1', 'Unknown', ''),  # noqa
        '0011xx0a': ('SL', '1', 'Series Type', ''),  # noqa
        '0011xx0b': ('SL', '1', 'Effective Series Duration', ''),  # noqa
        '0011xx0c': ('SL', '1', 'Num Beats', ''),  # noqa
        '0011xx0d': ('LO', '1', 'Radio Nuclide Name', ''),  # noqa
        '0011xx10': ('LO', '1', 'Dataset Object Name', ''),  # noqa
        '0011xx11': ('IS', '1', 'Dataset Modified', ''),  # noqa
        '0011xx12': ('LO', '1-n', 'Dataset Name', ''),  # noqa
        '0011xx13': ('SL', '1', 'Dataset Type', ''),  # noqa
        '0011xx14': ('SH', '1', 'Completion Time', ''),  # noqa
        '0011xx15': ('SL', '1', 'Detector Number', ''),  # noqa
        '0011xx16': ('SL', '1', 'Energy Number', ''),  # noqa
        '0011xx17': ('SL', '1', 'RR Interval Window Number', ''),  # noqa
        '0011xx18': ('SL', '1', 'MG Bin Number', ''),  # noqa
        '0011xx19': ('FD', '1', 'Radius Of Rotation', ''),  # noqa
        '0011xx1a': ('SL', '1', 'Detector Count Zone', ''),  # noqa
        '0011xx1b': ('SL', '1', 'Num Energy Windows', ''),  # noqa
        '0011xx1c': ('SL', '4', 'Energy Offset', ''),  # noqa
        '0011xx1d': ('SL', '1', 'Energy Range', ''),  # noqa
        '0011xx1e': ('SL', '4', 'Energy Width (retired)', ''),  # noqa
        '0011xx1f': ('SL', '1', 'Image Orientation', ''),  # noqa
        '0011xx21': ('DS', '1', 'Acq Zoom (retired)', ''),  # noqa
        '0011xx22': ('DS', '1', 'Acq Pan (retired)', ''),  # noqa
        '0011xx23': ('SL', '1', 'Use FOV Mask', ''),  # noqa
        '0011xx24': ('SL', '1', 'FOV Mask Y Cutoff Distance', ''),  # noqa
        '0011xx25': ('SL', '1', 'FOV Mask Cutoff Angle', ''),  # noqa
        '0011xx26': ('SL', '1', 'Table Orientation', ''),  # noqa
        '0011xx27': ('SL', '2', 'ROI Top Left', ''),  # noqa
        '0011xx28': ('SL', '2', 'ROI Bottom Right', ''),  # noqa
        '0011xx29': ('SL', '1', 'Uniformity Mean', ''),  # noqa
        '0011xx2a': ('FD', '1', 'Phase Duration (retired)', ''),  # noqa
        '0011xx2c': ('FD', '1', 'View X Adjustment', ''),  # noqa
        '0011xx2d': ('FD', '1', 'View Y Adjustment', ''),  # noqa
        '0011xx2e': ('SL', '1', 'Pixel Overflow Flag', ''),  # noqa
        '0011xx2f': ('SL', '1', 'Overflow Level', ''),  # noqa
        '0011xx30': ('LO', '1', 'Picture Object Name', ''),  # noqa
        '0011xx31': ('LO', '1', 'Acquisition Parent UID', ''),  # noqa
        '0011xx32': ('LO', '1', 'Processing Parent UID', ''),  # noqa
        '0011xx33': ('LO', '1', 'Energy Correct Name', ''),  # noqa
        '0011xx34': ('LO', '1', 'Spatial Correct Name', ''),  # noqa
        '0011xx35': ('LO', '1', 'Tuning Calib Name', ''),  # noqa
        '0011xx36': ('LO', '1', 'Uniformity Correct Name', ''),  # noqa
        '0011xx37': ('LT', '1', 'Acquisition Specific Correction Name', ''),  # noqa
        '0011xx38': ('SL', '1', 'Byte Order', ''),  # noqa
        '0011xx39': ('SL', '1', 'Compression Type', ''),  # noqa
        '0011xx3a': ('SL', '1', 'Picture Format', ''),  # noqa
        '0011xx3b': ('FD', '1', 'Pixel Scale', ''),  # noqa
        '0011xx3c': ('FD', '1', 'Pixel Offset', ''),  # noqa
        '0011xx3d': ('SL', '4', 'Energy Peak (retired)', ''),  # noqa
        '0011xx3e': ('SL', '1', 'FOV Shape', ''),  # noqa
        '0011xx3f': ('SL', '1', 'Dataset Flags', ''),  # noqa
        '0011xx40': ('LO', '1', 'Viewing Object Name', ''),  # noqa
        '0011xx41': ('SL', '1', 'Orientation Angle', ''),  # noqa
        '0011xx42': ('FD', '1', 'Rotation Angle', ''),  # noqa
        '0011xx43': ('SL', '1', 'Window Inverse Flag', ''),  # noqa
        '0011xx44': ('FD', '1', 'Threshold Center', ''),  # noqa
        '0011xx45': ('FD', '1', 'Threshold Width', ''),  # noqa
        '0011xx46': ('SL', '1', 'Interpolation Type', ''),  # noqa
        '0011xx50': ('LO', '1', 'Where Object Name', ''),  # noqa
        '0011xx55': ('FD', '1', 'Period', ''),  # noqa
        '0011xx56': ('FD', '1', 'Elapsed Time', ''),  # noqa
        '0011xx57': ('FD', '2', 'FOV', ''),  # noqa
        '0011xx61': ('SL', '1', 'Image Size', ''),  # noqa
        '0011xx62': ('FD', '1', 'Linear FOV', ''),  # noqa
        '0011xx63': ('FD', '1', 'Spatial Offset', ''),  # noqa
        '0011xx64': ('FD', '1', 'Spatial Orientation', ''),  # noqa
        '0011xx65': ('LO', '1', 'Reference Dataset UID', ''),  # noqa
        '0011xx66': ('SH', '1', 'Starcam Reference Dataset', ''),  # noqa
        '0011xx67': ('SL', '1', 'Reference Frame Number', ''),  # noqa
        '0011xx68': ('SL', '1', 'Cursor Length', ''),  # noqa
        '0011xx69': ('SL', '1', 'Number of Cursors', ''),  # noqa
        '0011xx6a': ('SL', '1', 'Cursor Coordinates', ''),  # noqa
        '0011xx6b': ('SL', '1', 'Recon Options Flag', ''),  # noqa
        '0011xx6c': ('FD', '1', 'Motion Threshold', ''),  # noqa
        '0011xx6d': ('UI', '1', 'Motion Curve UID', ''),  # noqa
        '0011xx6e': ('SL', '1', 'Recon Type', ''),  # noqa
        '0011xx6f': ('SL', '1', 'Pre Filter Type', ''),  # noqa
        '0011xx71': ('SL', '1', 'Back Proj Filter Type', ''),  # noqa
        '0011xx72': ('SL', '1', 'Recon Arc', ''),  # noqa
        '0011xx73': ('FD', '1', 'Recon Pan AP Offset', ''),  # noqa
        '0011xx74': ('FD', '1', 'Recon Pan LR Offset', ''),  # noqa
        '0011xx75': ('FD', '1', 'Recon Area', ''),  # noqa
        '0011xx76': ('SL', '1', 'Start View', ''),  # noqa
        '0011xx77': ('SL', '1', 'Attenuation Type', ''),  # noqa
        '0011xx78': ('SL', '1', 'Dual Energy Processing', ''),  # noqa
        '0011xx79': ('SH', '1', 'Pre Filter Param', ''),  # noqa
        '0011xx7a': ('SH', '1', 'Pre Filter Param 2', ''),  # noqa
        '0011xx7b': ('SH', '1', 'Back Proj Filter Param', ''),  # noqa
        '0011xx7c': ('SH', '1', 'Back Proj Filter Param 2', ''),  # noqa
        '0011xx7d': ('SH', '1', 'Attenuation Coef', ''),  # noqa
        '0011xx7e': ('SL', '1', 'Ref Slice Width', ''),  # noqa
        '0011xx7f': ('FD', '1', 'Ref Trans Pixel Volume', ''),  # noqa
        '0011xx81': ('SH', '1', 'Attenuation Threshold', ''),  # noqa
        '0011xx82': ('FD', '1', 'Interpolation Distance', ''),  # noqa
        '0011xx83': ('FD', '1', 'Interpolation Center X', ''),  # noqa
        '0011xx84': ('FD', '1', 'Interpolation Center Y', ''),  # noqa
        '0011xx85': ('SL', '1', 'Quant Filter Flag', ''),  # noqa
        '0011xx86': ('SL', '1', 'Head Conversion', ''),  # noqa
        '0011xx87': ('SL', '1', 'Slice Width Pixels', ''),  # noqa
        '0011xx88': ('SL', '1', 'Rfmtr Trans Ref', ''),  # noqa
        '0011xx89': ('FD', '1', 'Rfmtr Trans Ref mm', ''),  # noqa
        '0011xx8a': ('SL', '1', 'Two Line Trans Ref', ''),  # noqa
        '0011xx8b': ('SL', '1', 'Three-D Zero', ''),  # noqa
        '0011xx8c': ('SL', '1', 'Three-D Zero Length', ''),  # noqa
        '0011xx8d': ('SL', '1', 'Three-D Zero In', ''),  # noqa
        '0013xx10': ('FD', '2', 'Digital FOV', ''),  # noqa
        '0013xx11': ('SL', '1', 'Source Translator', ''),  # noqa
        '0013xx12': ('UL', '1', 'RAL Flags', ''),  # noqa
        '0013xx13': ('SQ', '1', 'Xeleris Frame Sequence', ''),  # noqa
        '0013xx14': ('SL', '1', 'Original Image Num', ''),  # noqa
        '0013xx15': ('FD', '1', 'Fscalar', ''),  # noqa
        '0013xx16': ('SL', '1', 'AutoTrack Peak', ''),  # noqa
        '0013xx17': ('SL', '1', 'AutoTrack Width', ''),  # noqa
        '0013xx18': ('FD', '1', 'Transmission Scan Time', ''),  # noqa
        '0013xx19': ('FD', '1', 'Transmission Mask Width', ''),  # noqa
        '0013xx1a': ('FD', '1', 'Copper Attenuator Thickness', ''),  # noqa
        '0013xx1b': ('FD', '1', 'Det Ang Separation', ''),  # noqa
        '0013xx1c': ('SL', '1', 'Axial Acceptance Angle', ''),  # noqa
        '0013xx1d': ('SL', '1', 'Theta Acceptance Value', ''),  # noqa
        '0013xx1e': ('FD', '1-n', 'Tomo View Offset', ''),  # noqa
        '0013xx20': ('FD', '1', 'Accepted Beats Time', ''),  # noqa
        '0013xx21': ('FD', '2', 'Threshold', ''),  # noqa
        '0013xx22': ('FD', '2', 'Linear Depth', ''),  # noqa
        '0013xx23': ('LO', '1', 'Unif Date Time', ''),  # noqa
        '0013xx24': ('SL', '1', 'Series Accepted Beats', ''),  # noqa
        '0013xx25': ('SL', '1', 'Series Rejected Beats', ''),  # noqa
        '0013xx26': ('LT', '1', 'Study Comments', ''),  # noqa
        '0015xx10': ('SL', '1', 'Frame Termination Condition', ''),  # noqa
        '0015xx11': ('SL', '1', 'Frame Termination Value', ''),  # noqa
        '0015xx12': ('SL', '1', 'Num ECT Phases', ''),  # noqa
        '0015xx13': ('SL', '1', 'Num WB Scans', ''),  # noqa
        '0015xx14': ('SL', '1', 'ECT Phase Num', ''),  # noqa
        '0015xx15': ('SL', '1', 'WB Scan Num', ''),  # noqa
        '0015xx16': ('SL', '1', 'Comb Head Number', ''),  # noqa
        '0015xx17': ('UL', '1', 'Preceding Beat', ''),  # noqa
        '0019xx5f': ('SQ', '1', 'Unknown', ''),  # noqa
        '0033xx07': ('SQ', '1-n', 'Orig SOP Instance UID', ''),  # noqa
        '0033xx08': ('CS', '1', 'Xeleris Data Object Type', ''),  # noqa
        '0033xx10': ('SL', '1', 'Modified', ''),  # noqa
        '0033xx11': ('LO', '1', 'Name', ''),  # noqa
        '0033xx16': ('LO', '1', 'ProtocolDataUID', ''),  # noqa
        '0033xx17': ('SH', '1', 'Date', ''),  # noqa
        '0033xx18': ('SH', '1', 'Time', ''),  # noqa
        '0033xx19': ('UL', '1', 'ProtocoldataFlags', ''),  # noqa
        '0033xx1a': ('UL', '1', 'ProtocolName', ''),  # noqa
        '0033xx1b': ('LO', '1', 'RelevantDataUID', ''),  # noqa
        '0033xx1c': ('LO', '1', 'BulkData', ''),  # noqa
        '0033xx1d': ('SL', '1-n', 'IntData', ''),  # noqa
        '0033xx1e': ('FD', '1-n', 'DoubleData', ''),  # noqa
        '0033xx1f': ('OB', '1', 'StringData', ''),  # noqa
        '0033xx20': ('LT', '1-n', 'BulkDataFormat', ''),  # noqa
        '0033xx21': ('LT', '1-n', 'IntDataFormat', ''),  # noqa
        '0033xx22': ('LT', '1-n', 'DoubleDataFormat', ''),  # noqa
        '0033xx23': ('LT', '1-n', 'StringDataFormat', ''),  # noqa
        '0033xx24': ('LT', '1', 'Description', ''),  # noqa
        '0033xx30': ('UL', '1', 'Allocate trigger buffer', ''),  # noqa
        '0033xx33': ('UL', '1', 'Number of triggers', ''),  # noqa
        '0033xx34': ('UL', '1', 'Trigger size', ''),  # noqa
        '0033xx35': ('UL', '1', 'Trigger data size', ''),  # noqa
        '0033xx36': ('OB', '1-n', 'Trigger data', ''),  # noqa
        '0035xx01': ('FD', '1-n', 'Start Angle', ''),  # noqa
        '0055xx12': ('SQ', '1', 'Xeleris Energy Window Information Sequence', ''),  # noqa
        '0055xx13': ('SQ', '1', 'Xeleris Energy Window Range Sequence', ''),  # noqa
        '0055xx22': ('SQ', '1', 'Xeleris Detector Information Sequence', ''),  # noqa
        '0055xx52': ('SQ', '1', 'Xeleris Rotation Information Sequence', ''),  # noqa
        '0055xx62': ('SQ', '1', 'Xeleris Gated Information Sequence', ''),  # noqa
        '0055xx63': ('SQ', '1', 'Xeleris Data Information Sequence', ''),  # noqa
        '0055xx64': ('SQ', '1', 'SDODoubleData SQ', ''),  # noqa
        '0055xx65': ('SQ', '1', 'Unknown', ''),  # noqa
        '5001xx01': ('SL', '1', 'Modified', ''),  # noqa
        '5001xx02': ('LO', '1', 'Name', ''),  # noqa
        '5001xx03': ('SL', '1', 'Cid', ''),  # noqa
        '5001xx04': ('SL', '1', 'Srid', ''),  # noqa
        '5001xx05': ('LO', '1', 'SOPClassUID', ''),  # noqa
        '5001xx06': ('LO', '1', 'SOPInstanceUID', ''),  # noqa
        '5001xx07': ('SL', '1', 'CurveType', ''),  # noqa
        '5001xx08': ('SL', '1', 'GraphType', ''),  # noqa
        '5001xx09': ('LO', '1', 'Legend', ''),  # noqa
        '5001xx0a': ('LO', '1', 'XUnits', ''),  # noqa
        '5001xx0b': ('LO', '1', 'YUnits', ''),  # noqa
        '5001xx0c': ('SL', '1', 'Edit', ''),  # noqa
        '5001xx0d': ('SL', '1', 'Suspend', ''),  # noqa
        '5001xx0e': ('SL', '1', 'StyleLine', ''),  # noqa
        '5001xx0f': ('SL', '1', 'StyleFill', ''),  # noqa
        '5001xx10': ('LO', '1', 'StyleColour', ''),  # noqa
        '5001xx11': ('SL', '1', 'StyleWidth', ''),  # noqa
        '5001xx12': ('SL', '1', 'StylePoint', ''),  # noqa
        '5001xx13': ('LO', '1', 'StylePColour', ''),  # noqa
        '5001xx14': ('SL', '1', 'StylePSize', ''),  # noqa
        '5001xx15': ('SL', '1', 'Segments', ''),  # noqa
        '5001xx16': ('SL', '1', 'SegType', ''),  # noqa
        '5001xx17': ('FD', '1-n', 'SegStart', ''),  # noqa
        '5001xx18': ('FD', '1-n', 'SegEnd', ''),  # noqa
        '5001xx19': ('SL', '1-n', 'SegStyleLine', ''),  # noqa
        '5001xx1a': ('SL', '1-n', 'SegStyleFill', ''),  # noqa
        '5001xx1b': ('LO', '1', 'SegStyleColour', ''),  # noqa
        '5001xx1c': ('SL', '1-n', 'SegStyleWidth', ''),  # noqa
        '5001xx1d': ('SL', '1-n', 'SegStylePoint', ''),  # noqa
        '5001xx1e': ('SL', '1', 'SegStylePColour', ''),  # noqa
        '5001xx1f': ('SL', '1', 'SegStylePSize', ''),  # noqa
        '5001xx20': ('LO', '1', 'SegName', ''),  # noqa
        '5001xx21': ('SL', '1-n', 'SegAllowDirInt', ''),  # noqa
        '5001xx22': ('SL', '1', 'TextAnnots', ''),  # noqa
        '5001xx23': ('FD', '1-n', 'TxtX', ''),  # noqa
        '5001xx24': ('FD', '1-n', 'TxtY', ''),  # noqa
        '5001xx25': ('LO', '1', 'TxtText', ''),  # noqa
        '5001xx26': ('LO', '1', 'TxtName', ''),  # noqa
        '5001xx30': ('LO', '1', 'ROIName', ''),  # noqa
        '5001xx31': ('LO', '1', 'DerivedFromImageUID', ''),  # noqa
        '5001xx32': ('SL', '1-n', 'DerivedFromImages', ''),  # noqa
        '5001xx33': ('UL', '1', 'CurveFlags', ''),  # noqa
        '5001xx34': ('LO', '1', 'CurveName', ''),  # noqa
        '5001xx35': ('LO', '1', 'DatasetName', ''),  # noqa
        '5001xx36': ('LO', '1', 'CurveUID', ''),  # noqa
        '5001xx37': ('FD', '1', 'ROIArea', ''),  # noqa
        '5001xx38': ('SL', '1', 'Modified', ''),  # noqa
        '5001xx39': ('LO', '1', 'Name', ''),  # noqa
        '5001xx3a': ('LO', '1', 'Software version', ''),  # noqa
        '5001xx3b': ('SH', '1', 'StartDate', ''),  # noqa
        '5001xx3c': ('SH', '1', 'CompletionDate', ''),  # noqa
        '5001xx3d': ('LO', '1', 'DetectorName', ''),  # noqa
        '5001xx41': ('SL', '1', 'Modified', ''),  # noqa
        '5001xx42': ('LO', '1', 'Name', ''),  # noqa
        '5001xx43': ('SL', '1', 'Name', ''),  # noqa
        '5001xx44': ('SL', '1', 'Name', ''),  # noqa
        '5001xx45': ('LO', '1', 'SOPClassUID', ''),  # noqa
        '5001xx46': ('LO', '1', 'SOPInstanceUID', ''),  # noqa
        '5001xx47': ('LO', '1', 'NormalColor', ''),  # noqa
        '5001xx48': ('LT', '1', 'NameFont', ''),  # noqa
        '5001xx49': ('SL', '1', 'FillPattern', ''),  # noqa
        '5001xx4a': ('SL', '1', 'LineStyle', ''),  # noqa
        '5001xx4b': ('SL', '1', 'LineDashLength', ''),  # noqa
        '5001xx4c': ('SL', '1', 'LineThickness', ''),  # noqa
        '5001xx4d': ('SL', '1', 'Interactivity', ''),  # noqa
        '5001xx4e': ('SL', '1', 'NamePos', ''),  # noqa
        '5001xx4f': ('SL', '1', 'NameDisplay', ''),  # noqa
        '5001xx50': ('LO', '1', 'Label', ''),  # noqa
        '5001xx51': ('SL', '1-n', 'BpSeg', ''),  # noqa
        '5001xx52': ('US', '1-n', 'BpSegPairs', ''),  # noqa
        '5001xx53': ('SL', '1', 'SeedSpace', ''),  # noqa
        '5001xx54': ('FD', '1-n', 'Seeds', ''),  # noqa
        '5001xx55': ('SL', '1-n', 'Shape', ''),  # noqa
        '5001xx56': ('FD', '1-n', 'ShapeTilt', ''),  # noqa
        '5001xx59': ('SL', '1-n', 'ShapePtsSpace', ''),  # noqa
        '5001xx5a': ('SL', '1-n', 'ShapeCtrlPtsCounts', ''),  # noqa
        '5001xx5b': ('FD', '1-n', 'ShapeCtrlPts', ''),  # noqa
        '5001xx5c': ('SL', '1', 'ShapeCPSpace', ''),  # noqa
        '5001xx5d': ('SL', '1', 'ROIFlags', ''),  # noqa
        '5001xx5e': ('SL', '1', 'FrameNumber', ''),  # noqa
        '5001xx5f': ('SL', '1', 'Id', ''),  # noqa
        '5001xx60': ('LO', '1-n', 'DatasetROIMapping', ''),  # noqa
    },
    'GEMS_GNHD_01': {
        '0033xx01': ('UN', '1', 'Unknown', ''),  # noqa
        '0033xx02': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_HELIOS_01': {
        '0045xx01': ('SS', '1', 'Number of Macro Rows in Detector', ''),  # noqa
        '0045xx02': ('FL', '1', 'Macro width at ISO Center', ''),  # noqa
        '0045xx03': ('SS', '1', 'DAS type', ''),  # noqa
        '0045xx04': ('SS', '1', 'DAS gain', ''),  # noqa
        '0045xx05': ('SS', '1', 'DAS Temperature', ''),  # noqa
        '0045xx06': ('CS', '1', 'Table Direction', ''),  # noqa
        '0045xx07': ('FL', '1', 'Z smoothing Factor', ''),  # noqa
        '0045xx08': ('SS', '1', 'View Weighting Mode', ''),  # noqa
        '0045xx09': ('SS', '1', 'Sigma Row number', ''),  # noqa
        '0045xx0a': ('FL', '1', 'Minimum DAS value', ''),  # noqa
        '0045xx0b': ('FL', '1', 'Maximum Offset Value', ''),  # noqa
        '0045xx0c': ('SS', '1', 'Number of Views shifted', ''),  # noqa
        '0045xx0d': ('SS', '1', 'Z tracking Flag', ''),  # noqa
        '0045xx0e': ('FL', '1', 'Mean Z error', ''),  # noqa
        '0045xx0f': ('FL', '1', 'Z tracking Error', ''),  # noqa
        '0045xx10': ('SS', '1', 'Start View 2A', ''),  # noqa
        '0045xx11': ('SS', '1', 'Number of Views 2A', ''),  # noqa
        '0045xx12': ('SS', '1', 'Start View 1A', ''),  # noqa
        '0045xx13': ('SS', '1', 'Sigma Mode', ''),  # noqa
        '0045xx14': ('SS', '1', 'Number of Views 1A', ''),  # noqa
        '0045xx15': ('SS', '1', 'Start View 2B', ''),  # noqa
        '0045xx16': ('SS', '1', 'Number Views 2B', ''),  # noqa
        '0045xx17': ('SS', '1', 'Start View 1B', ''),  # noqa
        '0045xx18': ('SS', '1', 'Number of Views 1B', ''),  # noqa
        '0045xx19': ('SS', '1', 'Air Calibration Date', ''),  # noqa
        '0045xx1a': ('SS', '1', 'Air Calibration Time', ''),  # noqa
        '0045xx1b': ('SS', '1', 'Phantom Calibration Date', ''),  # noqa
        '0045xx1c': ('SS', '1', 'Phantom Calibration Time', ''),  # noqa
        '0045xx1d': ('SS', '1', 'Z Slope Calibration Date', ''),  # noqa
        '0045xx1e': ('SS', '1', 'Z Slope Calibration Time', ''),  # noqa
        '0045xx1f': ('SS', '1', 'Cross Talk Calibration Date', ''),  # noqa
        '0045xx20': ('SS', '1', 'Cross Talk Calibration Time', ''),  # noqa
        '0045xx21': ('SS', '1', 'Iterbone Flag', ''),  # noqa
        '0045xx22': ('SS', '1', 'Perisstaltic Flag', ''),  # noqa
        '0045xx30': ('CS', '1', 'CardiacReconAlgorithm', ''),  # noqa
        '0045xx31': ('CS', '1', 'AvgHeartRateForImage', ''),  # noqa
        '0045xx32': ('FL', '1', 'TemporalResolution', ''),  # noqa
        '0045xx33': ('CS', '1', 'PctRpeakDelay', ''),  # noqa
        '0045xx34': ('CS', '1', 'ActualPctRpeakDelay', ''),  # noqa
        '0045xx36': ('CS', '1', 'EkgFullMaStartPhase', ''),  # noqa
        '0045xx37': ('CS', '1', 'EkgFullMaEndPhase', ''),  # noqa
        '0045xx38': ('CS', '1', 'EkgModulationMaxMa', ''),  # noqa
        '0045xx39': ('CS', '1', 'EkgModulationMinMa', ''),  # noqa
        '0045xx3b': ('LO', '1', 'NoiseReductionImageFilterDesc', ''),  # noqa
    },
    'GEMS_HINO_CT_01': {
        '004bxx01': ('DS', '1-n', 'Beam Thickness', ''),  # noqa
        '004bxx02': ('DS', '1-n', 'R Time', ''),  # noqa
        '004bxx03': ('IS', '1', 'HBC number', ''),  # noqa
    },
    'GEMS_IDEN_01': {
        '000910xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0009xx01': ('LO', '1', 'Full fidelity', ''),  # noqa
        '0009xx02': ('SH', '1', 'Suite id', ''),  # noqa
        '0009xx04': ('SH', '1', 'Product id', ''),  # noqa
        '0009xx17': ('LT', '1', 'Series Description', ''),  # noqa
        '0009xx1a': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx20': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx27': ('SL', '1', 'Image actual date', ''),  # noqa
        '0009xx2f': ('SH', '1', 'Unknown', ''),  # noqa
        '0009xx30': ('SH', '1', 'Service id', ''),  # noqa
        '0009xx31': ('SH', '1', 'Mobile location number', ''),  # noqa
        '0009xxe2': ('LT', '1-n', 'Image Type (ORIGINAL\\PROSPECTIVE ...)', ''),  # noqa
        '0009xxe3': ('UI', '1', 'Equipment UID', ''),  # noqa
        '0009xxe6': ('SH', '1', 'Genesis Version - now', ''),  # noqa
        '0009xxe7': ('UL', '1', 'Exam Record checksum', ''),  # noqa
        '0009xxe8': ('SH', '1', 'Series Suite Id', ''),  # noqa
        '0009xxe9': ('SL', '1', 'Actual series data time stamp', ''),  # noqa
    },
    'GEMS_IMAG_01': {
        '002710xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0027xx06': ('SL', '1', 'Image archive flag', ''),  # noqa
        '0027xx10': ('SS', '1', 'Scout Type', ''),  # noqa
        '0027xx1c': ('SL', '1', 'Vma mamp', ''),  # noqa
        '0027xx1d': ('SS', '1', 'Vma phase', ''),  # noqa
        '0027xx1e': ('SL', '1', 'Vma mod', ''),  # noqa
        '0027xx1f': ('SL', '1', 'Vma clip', ''),  # noqa
        '0027xx20': ('SS', '1', 'Smart scan ON/OFF flag', ''),  # noqa
        '0027xx30': ('SH', '1', 'Foreign Image Revision', ''),  # noqa
        '0027xx31': ('SS', '1', 'Imaging Mode', ''),  # noqa
        '0027xx32': ('SS', '1', 'Pulse Sequence', ''),  # noqa
        '0027xx33': ('SL', '1', 'Imaging Options', ''),  # noqa
        '0027xx35': ('SS', '1', 'Plane Type', ''),  # noqa
        '0027xx36': ('SL', '1', 'Oblique Plane', ''),  # noqa
        '0027xx40': ('SH', '1', 'RAS letter of image location', ''),  # noqa
        '0027xx41': ('FL', '1', 'Image location', ''),  # noqa
        '0027xx42': ('FL', '1', 'Center R coord of plane image', ''),  # noqa
        '0027xx43': ('FL', '1', 'Center A coord of plane image', ''),  # noqa
        '0027xx44': ('FL', '1', 'Center S coord of plane image', ''),  # noqa
        '0027xx45': ('FL', '1', 'Normal R coord', ''),  # noqa
        '0027xx46': ('FL', '1', 'Normal A coord', ''),  # noqa
        '0027xx47': ('FL', '1', 'Normal S coord', ''),  # noqa
        '0027xx48': ('FL', '1', 'R Coord of Top Right Corner', ''),  # noqa
        '0027xx49': ('FL', '1', 'A Coord of Top Right Corner', ''),  # noqa
        '0027xx4a': ('FL', '1', 'S Coord of Top Right Corner', ''),  # noqa
        '0027xx4b': ('FL', '1', 'R Coord of Bottom Right Corner', ''),  # noqa
        '0027xx4c': ('FL', '1', 'A Coord of Bottom Right Corner', ''),  # noqa
        '0027xx4d': ('FL', '1', 'S Coord of Bottom Right Corner', ''),  # noqa
        '0027xx50': ('FL', '1', 'Scan Start Location', ''),  # noqa
        '0027xx51': ('FL', '1', 'Scan End Location', ''),  # noqa
        '0027xx52': ('SH', '1', 'RAS letter for side of image', ''),  # noqa
        '0027xx53': ('SH', '1', 'RAS letter for anterior/posterior', ''),  # noqa
        '0027xx54': ('SH', '1', 'RAS letter for scout start loc', ''),  # noqa
        '0027xx55': ('SH', '1', 'RAS letter for scout end loc', ''),  # noqa
        '0027xx60': ('FL', '1', 'Image dimension - X', ''),  # noqa
        '0027xx61': ('FL', '1', 'Image dimension - Y', ''),  # noqa
        '0027xx62': ('FL', '1', 'Number of Excitations', ''),  # noqa
        '0029xx15': ('SL', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx16': ('SL', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx17': ('SL', '1', 'Lower range of Pixels2', ''),  # noqa
        '0029xx18': ('SL', '1', 'Upper range of Pixels2', ''),  # noqa
        '0029xx1a': ('SL', '1', 'Len of tot hdr in bytes No longer supported', ''),  # noqa
        '0029xx26': ('SS', '1', 'Version of the hdr struct', ''),  # noqa
        '0029xx34': ('SL', '1', 'Advantage comp. Overflow', ''),  # noqa
        '0029xx35': ('SL', '1', 'Advantage comp. Underflow', ''),  # noqa
    },
    'GEMS_IMPS_01': {
        '002910xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0029xx04': ('SL', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx05': ('DS', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx06': ('DS', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx07': ('SL', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx08': ('SH', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx09': ('SH', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx0a': ('SS', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx15': ('SL', '1', 'Lower range of Pixels1', ''),  # noqa
        '0029xx16': ('SL', '1', 'Upper range of Pixels1', ''),  # noqa
        '0029xx17': ('SL', '1', 'Lower range of Pixels2', ''),  # noqa
        '0029xx18': ('SL', '1', 'Upper range of Pixels2', ''),  # noqa
        '0029xx1a': ('SL', '1', 'Len of tot hdr in bytes', ''),  # noqa
        '0029xx26': ('SS', '1', 'Version of the hdr struct', ''),  # noqa
        '0029xx34': ('SL', '1', 'Advantage comp. Overflow', ''),  # noqa
        '0029xx35': ('SL', '1', 'Advantage comp. Underflow', ''),  # noqa
        '0043xx13': ('SS', '5', 'Decon kernel parameters', ''),  # noqa
    },
    'GEMS_IQTB_IDEN_47': {
        '0047xx01': ('SH', '1', 'Image Path', ''),  # noqa
        '0047xx02': ('UL', '1', 'Image Date/Time', ''),  # noqa
        '0047xx03': ('UL', '1', 'Queue Sequence Number', ''),  # noqa
        '0047xx04': ('UL', '1', 'Recon Sequence ID', ''),  # noqa
    },
    'GEMS_IT_US_REPORT': {
        '0045xx11': ('OW', '1', 'Vivid excel file', ''),  # noqa
        '0045xx12': ('OW', '1', 'Vivid CHM file', ''),  # noqa
        '0045xx13': ('OW', '1', 'Vivid PDF file', ''),  # noqa
    },
    'GEMS_LUNAR_RAW': {
        '7003xx01': ('ST', '1', 'enCORE File Name', ''),  # noqa
        '7003xx02': ('OB', '1', 'enCORE File Data', ''),  # noqa
        '7003xx03': ('UL', '1', 'enCORE File Length', ''),  # noqa
        '7003xx04': ('LO', '1', 'enCORE File Modified Time', ''),  # noqa
    },
    'GEMS_MR_RAW_01': {
        '7001xx01': ('OB', '1', 'rdb_hdr_rec', ''),  # noqa
        '7001xx02': ('OB', '1', 'rdb_hdr_per_pass_tab', ''),  # noqa
        '7001xx03': ('OB', '1', 'rdb_hdr_unlock_raw', ''),  # noqa
        '7001xx04': ('OB', '1', 'rdb_hdr_data_acq_tab', ''),  # noqa
        '7001xx05': ('OB', '1', 'rdb_hdr_nex_tab', ''),  # noqa
        '7001xx06': ('OB', '1', 'rdb_hdr_nex_abort_tab', ''),  # noqa
        '7001xx07': ('OB', '1', 'rdb_hdr_tool', ''),  # noqa
        '7001xx08': ('OB', '1', 'rdb_raw_data', ''),  # noqa
        '7001xx09': ('OB', '1', 'SSP save', ''),  # noqa
        '7001xx0a': ('OB', '1', 'UDA save', ''),  # noqa
        '7001xx0b': ('OB', '1', 'rdb_chemsat_data', ''),  # noqa
    },
    'GEMS_PARM_01': {
        '004310xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0043xx01': ('SS', '1', 'Bitmap of prescan options', ''),  # noqa
        '0043xx02': ('SS', '1', 'Gradient offset in X', ''),  # noqa
        '0043xx03': ('SS', '1', 'Gradient offset in Y', ''),  # noqa
        '0043xx04': ('SS', '1', 'Gradient offset in Z', ''),  # noqa
        '0043xx05': ('SS', '1', 'Img is original or unoriginal', ''),  # noqa
        '0043xx06': ('SS', '1', 'Number of EPI shots', ''),  # noqa
        '0043xx07': ('SS', '1', 'Views per segment', ''),  # noqa
        '0043xx08': ('SS', '1', 'Respiratory rate, bpm', ''),  # noqa
        '0043xx09': ('SS', '1', 'Respiratory trigger point', ''),  # noqa
        '0043xx0a': ('SS', '1', 'Type of receiver used', ''),  # noqa
        '0043xx0b': ('DS', '1', 'DB/dt Peak rate of change of gradient field', ''),  # noqa
        '0043xx0c': ('DS', '1', 'dB/dt Limits in units of percent', ''),  # noqa
        '0043xx0d': ('DS', '1', 'PSD estimated limit', ''),  # noqa
        '0043xx0e': ('DS', '1', 'PSD estimated limit in tesla per second', ''),  # noqa
        '0043xx0f': ('DS', '1', 'Saravghead', ''),  # noqa
        '0043xx10': ('US', '1', 'Window value', ''),  # noqa
        '0043xx11': ('US', '1', 'Total input views', ''),  # noqa
        '0043xx12': ('SS', '3', 'X-ray chain', ''),  # noqa
        '0043xx13': ('SS', '5', 'Decon kernel parameters', ''),  # noqa
        '0043xx14': ('SS', '3', 'Calibration parameters', ''),  # noqa
        '0043xx15': ('SS', '3', 'Total output views', ''),  # noqa
        '0043xx16': ('SS', '5', 'Number of overranges', ''),  # noqa
        '0043xx17': ('DS', '1', 'IBH image scale factors', ''),  # noqa
        '0043xx18': ('DS', '3', 'BBH coefficients', ''),  # noqa
        '0043xx19': ('SS', '1', 'Number of BBH chains to blend', ''),  # noqa
        '0043xx1a': ('SL', '1', 'Starting channel number', ''),  # noqa
        '0043xx1b': ('SS', '1', 'Ppscan parameters', ''),  # noqa
        '0043xx1c': ('SS', '1', 'GE image integrity', ''),  # noqa
        '0043xx1d': ('SS', '1', 'Level value', ''),  # noqa
        '0043xx1e': ('DS', '1', 'Delta Start Time [msec]', ''),  # noqa
        '0043xx1f': ('SL', '1', 'Max overranges in a view', ''),  # noqa
        '0043xx20': ('DS', '1', 'Avg overranges all views', ''),  # noqa
        '0043xx21': ('SS', '1', 'Corrected after glow terms', ''),  # noqa
        '0043xx25': ('SS', '6', 'Reference channels', ''),  # noqa
        '0043xx26': ('US', '6', 'No views ref chans blocked', ''),  # noqa
        '0043xx27': ('SH', '1', 'Scan Pitch Ratio', ''),  # noqa
        '0043xx28': ('OB', '1', 'Unique image iden', ''),  # noqa
        '0043xx29': ('OB', '1', 'Histogram tables', ''),  # noqa
        '0043xx2a': ('OB', '1', 'User defined data', ''),  # noqa
        '0043xx2b': ('SS', '4', 'Private Scan Options', ''),  # noqa
        '0043xx2c': ('SS', '1', 'Effective echo spacing', ''),  # noqa
        '0043xx2d': ('SH', '1', 'Filter Mode (String slop field 1 in legacy GE MR', ''),  # noqa
        '0043xx2e': ('SH', '1', 'String slop field 2', ''),  # noqa
        '0043xx2f': ('SS', '1', 'Image Type (real, imaginary, phase, magnitude)', ''),  # noqa
        '0043xx30': ('SS', '1', 'Vas collapse flag', ''),  # noqa
        '0043xx31': ('DS', '2', 'Recon Center Coordinates', ''),  # noqa
        '0043xx32': ('SS', '1', 'Vas flags', ''),  # noqa
        '0043xx33': ('FL', '1', 'Neg_scanspacing', ''),  # noqa
        '0043xx34': ('IS', '1', 'Offset Frequency', ''),  # noqa
        '0043xx35': ('UL', '1', 'User_usage_tag', ''),  # noqa
        '0043xx36': ('UL', '1', 'User_fill_map_MSW', ''),  # noqa
        '0043xx37': ('UL', '1', 'User_fill_map_LSW', ''),  # noqa
        '0043xx38': ('FL', '24', 'User data 25...User data 48 {User48=Effective Resolution for spiral}', ''),  # noqa
        '0043xx39': ('IS', '4', 'Slop_int_6... slop_int_9', ''),  # noqa
        '0043xx40': ('FL', '4', 'Trigger on position', ''),  # noqa
        '0043xx41': ('FL', '4', 'Degree of rotation', ''),  # noqa
        '0043xx42': ('SL', '4', 'DAS trigger source', ''),  # noqa
        '0043xx43': ('SL', '4', 'DAS fpa gain', ''),  # noqa
        '0043xx44': ('SL', '4', 'DAS output source', ''),  # noqa
        '0043xx45': ('SL', '4', 'DAS ad input', ''),  # noqa
        '0043xx46': ('SL', '4', 'DAS cal mode', ''),  # noqa
        '0043xx47': ('SL', '4', 'DAS cal frequency', ''),  # noqa
        '0043xx48': ('SL', '4', 'DAS reg xm', ''),  # noqa
        '0043xx49': ('SL', '4', 'DAS auto zero', ''),  # noqa
        '0043xx4a': ('SS', '4', 'Starting channel of view', ''),  # noqa
        '0043xx4b': ('SL', '4', 'DAS xm pattern', ''),  # noqa
        '0043xx4c': ('SS', '4', 'TGGC trigger mode', ''),  # noqa
        '0043xx4d': ('FL', '4', 'Start scan to X-ray on delay', ''),  # noqa
        '0043xx4e': ('FL', '4', 'Duration of X-ray on', ''),  # noqa
        '0043xx60': ('IS', '8', 'Slop_int_10...slop_int_17', ''),  # noqa
        '0043xx61': ('UI', '1', 'Scanner Study Entity UID', ''),  # noqa
        '0043xx62': ('SH', '1', 'Scanner Study ID', ''),  # noqa
        '0043xx63': ('SH', '1', 'Raw Data ID', ''),  # noqa
        '0043xx64': ('CS', '1-n', 'Image Filter', ''),  # noqa
        '0043xx65': ('US', '1', 'Motion Correction Indicator', ''),  # noqa
        '0043xx66': ('US', '1', 'Helical Correction Indicator', ''),  # noqa
        '0043xx67': ('US', '1', 'IBO Correction Indicator', ''),  # noqa
        '0043xx68': ('US', '1', 'XT Correction Indicator', ''),  # noqa
        '0043xx69': ('US', '1', 'Q-cal Correction Indicator', ''),  # noqa
        '0043xx6a': ('US', '1', 'AV Correction Indicator', ''),  # noqa
        '0043xx6b': ('US', '1', 'L-MDK Correction Indicator', ''),  # noqa
        '0043xx6c': ('IS', '1', 'Detector Row', ''),  # noqa
        '0043xx6d': ('IS', '1', 'Area Size', ''),  # noqa
        '0043xx6e': ('SH', '1', 'Auto mA Mode', ''),  # noqa
        '0043xx6f': ('DS', '3-4', 'Scanner Table Entry (single gradient coil systems only)/Scanner Table Entry + Gradient Coil Selected', ''),  # noqa
        '0043xx70': ('LO', '1', 'Paradigm Name', ''),  # noqa
        '0043xx71': ('ST', '1', 'Paradigm Description', ''),  # noqa
        '0043xx72': ('UI', '1', 'Paradigm UID', ''),  # noqa
        '0043xx73': ('US', '1', 'Experiment Type', ''),  # noqa
        '0043xx74': ('US', '1', '#rest volumes', ''),  # noqa
        '0043xx75': ('US', '1', '#active volumes', ''),  # noqa
        '0043xx76': ('US', '1', '#dummy scans', ''),  # noqa
        '0043xx77': ('SH', '1', 'Application Name', ''),  # noqa
        '0043xx78': ('SH', '1', 'Application Version', ''),  # noqa
        '0043xx79': ('US', '1', 'Slices Per Volume', ''),  # noqa
        '0043xx7a': ('US', '1', 'Expected Time Points', ''),  # noqa
        '0043xx7b': ('FL', '1-n', 'Regressor Values', ''),  # noqa
        '0043xx7c': ('FL', '1', 'Delay after slice group', ''),  # noqa
        '0043xx7d': ('US', '1', 'Recon mode flag word', ''),  # noqa
        '0043xx7e': ('LO', '1-n', 'PACC specific information', ''),  # noqa
        '0043xx7f': ('DS', '1-n', 'Reserved', ''),  # noqa
        '0043xx80': ('LO', '1-n', 'Coil ID Data', ''),  # noqa
        '0043xx81': ('LO', '1', 'GE Coil Name', ''),  # noqa
        '0043xx82': ('LO', '1-n', 'System Configuration Information', ''),  # noqa
        '0043xx83': ('DS', '1-2', 'Asset R Factors', ''),  # noqa
        '0043xx84': ('LO', '5', 'Additional Asset Data', ''),  # noqa
        '0043xx85': ('UT', '1', 'Debug Data (text format)', ''),  # noqa
        '0043xx86': ('OB', '1', 'Debug Data (binary format)', ''),  # noqa
        '0043xx87': ('UT', '1', 'Reserved', ''),  # noqa
        '0043xx88': ('UI', '1', 'PURE Acquisition Calibration Series UID', ''),  # noqa
        '0043xx89': ('LO', '3', 'Governing Body, dB/dt, and SAR definition', ''),  # noqa
        '0043xx8a': ('CS', '1', 'Private In-Plane Phase Encoding Direction', ''),  # noqa
        '0043xx8b': ('OB', '1', 'FMRI Binary Data Block', ''),  # noqa
        '0043xx8c': ('DS', '6', 'Voxel Location', ''),  # noqa
        '0043xx8d': ('DS', '7-7n', 'SAT Band Locations', ''),  # noqa
        '0043xx8e': ('DS', '3', 'Spectro Prescan Values', ''),  # noqa
        '0043xx8f': ('DS', '3', 'Spectro Parameters', ''),  # noqa
        '0043xx90': ('LO', '1-n', 'SAR Definition', ''),  # noqa
        '0043xx91': ('DS', '1-n', 'SAR value', ''),  # noqa
        '0043xx92': ('LO', '1', 'Image Error Text', ''),  # noqa
        '0043xx93': ('DS', '1-n', 'Spectro Quantitation Values', ''),  # noqa
        '0043xx94': ('DS', '1-n', 'Spectro Ratio Values', ''),  # noqa
        '0043xx95': ('LO', '1', 'Prescan Reuse String', ''),  # noqa
        '0043xx96': ('CS', '1', 'Content Qualification', ''),  # noqa
        '0043xx97': ('LO', '8', 'Image Filtering Parameters', ''),  # noqa
        '0043xx98': ('UI', '1', 'ASSET Acquisition Calibration Series UID', ''),  # noqa
        '0043xx99': ('LO', '1-n', 'Extended Options', ''),  # noqa
        '0043xx9a': ('IS', '1', 'Rx Stack Identification', ''),  # noqa
        '0043xx9b': ('DS', '1', 'NPW factor', ''),  # noqa
        '0043xx9c': ('OB', '1', 'Research Tag 1', ''),  # noqa
        '0043xx9d': ('OB', '1', 'Research Tag 2', ''),  # noqa
        '0043xx9e': ('OB', '1', 'Research Tag 3', ''),  # noqa
        '0043xx9f': ('OB', '1', 'Research Tag 4', ''),  # noqa
        '0043xxa0': ('SQ', '1', 'Spectroscopy Pixel Sequence', ''),  # noqa
        '0043xxa1': ('SQ', '1', 'Spectroscopy Default Display Sequence', ''),  # noqa
        '0043xxa2': ('DS', '1-n', 'MEG Data', ''),  # noqa
        '0043xxa3': ('CS', '1', 'ASL Contrast technique', ''),  # noqa
        '0043xxa4': ('LO', '1', 'Detailed text for ASL labeling technique', ''),  # noqa
        '0043xxa5': ('IS', '1', 'Duration of the label or control pulse', ''),  # noqa
        '0051xx0a': ('SL', '1', 'Store level of Functional Image', ''),  # noqa
        '0051xx0b': ('FL', '1', 'Store B-Value with Functional Image', ''),  # noqa
        '2001xx10': ('UI', '1', 'DICOM Implementation UID', ''),  # noqa
        '2001xx11': ('SH', '1', 'DICOM Implementation Version', ''),  # noqa
        '2001xx12': ('UI', '1', 'Within-DICOM-Implementation SOP Instance UID', ''),  # noqa
        '2001xx13': ('SH', '1', 'Application Name', ''),  # noqa
        '2001xx14': ('SH', '1', 'Application Version', ''),  # noqa
        '2001xx15': ('SH', '1', 'Compatibility Version', ''),  # noqa
        '2001xx21': ('UI', '1-n', 'Referenced Series UID', ''),  # noqa
        '2001xx31': ('US', '1', 'Number of Objects Averaged', ''),  # noqa
        '2001xx41': ('US', '1', 'Number of Expected Time Points', ''),  # noqa
        '2001xx51': ('US', '1', 'Number of Slices Per Volume', ''),  # noqa
        '2001xx60': ('US', '1', 'BW Image Type', ''),  # noqa
        '2001xx61': ('US', '1', 'Experiment Type', ''),  # noqa
        '2001xx71': ('UI', '1', 'Paradigm UID', ''),  # noqa
        '2001xx72': ('LO', '1', 'Paradigm Name', ''),  # noqa
        '2001xx73': ('ST', '1', 'Paradigm Description', ''),  # noqa
        '2001xx80': ('OB', '1', 'Contrast', ''),  # noqa
        '2001xx81': ('FL', '1-n', 'Regressor Values', ''),  # noqa
        '2001xx86': ('US', '1', 'Number of Degrees of Freedom', ''),  # noqa
        '2001xx8a': ('FL', '1', 'Z Threshold', ''),  # noqa
        '2001xx8b': ('FL', '1', 'p Threshold', ''),  # noqa
        '2001xx90': ('OB', '1', 'Processing parameters', ''),  # noqa
        '2001xx91': ('OB', '1', 'Motion Plot', ''),  # noqa
        '2001xx92': ('OB', '1', 'ROIs', ''),  # noqa
        '2001xx93': ('OB', '1', 'Tracts', ''),  # noqa
        '2001xx94': ('OB', '1', 'Report', ''),  # noqa
        '2001xx95': ('OB', '1', 'Response Data', ''),  # noqa
        '2001xxa0': ('FL', '1-n', 'Motion Parameters', ''),  # noqa
        '2001xxa1': ('FL', '1-n', 'Registration Parameters', ''),  # noqa
        '2001xxa2': ('FL', '1-n', 'Subject Data', ''),  # noqa
        '2001xxb0': ('OB', '1', 'DTI Parameters', ''),  # noqa
        '2001xxc0': ('OB', '1', 'Paradigm Info', ''),  # noqa
    },
    'GEMS_PATI_01': {
        '001110xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0011xx10': ('SS', '1', 'Patient Status', ''),  # noqa
    },
    'GEMS_PETD_01': {
        '0009xx01': ('LO', '2', 'GE Discovery PET Implementation Version Name', ''),  # noqa
        '0009xx02': ('LO', '1', 'PET patient_id', ''),  # noqa
        '0009xx03': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0009xx04': ('SH', '1', 'GE Advance Patient.software_version', ''),  # noqa
        '0009xx05': ('DT', '1', 'PET patient_datetime', ''),  # noqa
        '0009xx06': ('SL', '1', 'PET type', ''),  # noqa
        '0009xx07': ('UI', '1', 'PET exam_id', ''),  # noqa
        '0009xx08': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0009xx09': ('SH', '1', 'PET software_version', ''),  # noqa
        '0009xx0a': ('UI', '1', 'PET scan_id', ''),  # noqa
        '0009xx0b': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0009xx0c': ('SH', '1', 'PET software_version', ''),  # noqa
        '0009xx0d': ('DT', '1', 'PET scan_datetime', ''),  # noqa
        '0009xx0e': ('DT', '1', 'PET scan_ready', ''),  # noqa
        '0009xx0f': ('ST', '1', 'PET scan_description', ''),  # noqa
        '0009xx10': ('LO', '1', 'PET hospital_name', ''),  # noqa
        '0009xx11': ('LO', '1', 'PET scanner_desc', ''),  # noqa
        '0009xx12': ('LO', '1', 'PET manufacturer', ''),  # noqa
        '0009xx13': ('UI', '1', 'PET for_identifier', ''),  # noqa
        '0009xx14': ('LO', '1', 'PET landmark_name', ''),  # noqa
        '0009xx15': ('SH', '1', 'PET landmark_abbrev', ''),  # noqa
        '0009xx16': ('SL', '1', 'PET patient_position', ''),  # noqa
        '0009xx17': ('SL', '1', 'PET scan_perspective', ''),  # noqa
        '0009xx18': ('SL', '1', 'PET scan_type', ''),  # noqa
        '0009xx19': ('SL', '1', 'PET scan_mode', ''),  # noqa
        '0009xx1a': ('SL', '1', 'PET start_condition', ''),  # noqa
        '0009xx1b': ('SL', '1', 'PET start_cond_data', ''),  # noqa
        '0009xx1c': ('SL', '1', 'PET sel_stop_cond', ''),  # noqa
        '0009xx1d': ('SL', '1', 'PET sel_stop_cond_data', ''),  # noqa
        '0009xx1e': ('SL', '1', 'PET collect_deadtime', ''),  # noqa
        '0009xx1f': ('SL', '1', 'PET collect_singles', ''),  # noqa
        '0009xx20': ('SL', '1', 'PET collect_countrate', ''),  # noqa
        '0009xx21': ('SL', '1', 'PET countrate_period', ''),  # noqa
        '0009xx22': ('SL', '1', 'PET delayed_events', ''),  # noqa
        '0009xx23': ('SL', '1', 'PET delayed_bias', ''),  # noqa
        '0009xx24': ('SL', '1', 'PET word_size', ''),  # noqa
        '0009xx25': ('SL', '1', 'PET axial_acceptance', ''),  # noqa
        '0009xx26': ('SL', '1', 'PET axial_angle_3d', ''),  # noqa
        '0009xx27': ('SL', '1', 'PET theta_compression', ''),  # noqa
        '0009xx28': ('SL', '1', 'PET axial_compression', ''),  # noqa
        '0009xx29': ('FL', '1', 'PET gantry_tilt_angle', ''),  # noqa
        '0009xx2a': ('SL', '1', 'PET collimation', ''),  # noqa
        '0009xx2b': ('SL', '1', 'PET scan_fov', ''),  # noqa
        '0009xx2c': ('SL', '1', 'PET axial_fov', ''),  # noqa
        '0009xx2d': ('SL', '1', 'PET event_separation', ''),  # noqa
        '0009xx2e': ('SL', '1', 'PET mask_width', ''),  # noqa
        '0009xx2f': ('SL', '1', 'PET binning_mode', ''),  # noqa
        '0009xx30': ('SL', '1', 'PET trig_rej_method', ''),  # noqa
        '0009xx31': ('SL', '1', 'PET number_for_reject', ''),  # noqa
        '0009xx32': ('SL', '1', 'PET lower_reject_limit', ''),  # noqa
        '0009xx33': ('SL', '1', 'PET upper_reject_limit', ''),  # noqa
        '0009xx34': ('SL', '1', 'PET triggers_acquired', ''),  # noqa
        '0009xx35': ('SL', '1', 'PET triggers_rejected', ''),  # noqa
        '0009xx36': ('LO', '1', 'PET tracer_name', ''),  # noqa
        '0009xx37': ('LO', '1', 'PET batch_description', ''),  # noqa
        '0009xx38': ('FL', '1', 'PET tracer_activity', ''),  # noqa
        '0009xx39': ('DT', '1', 'PET meas_datetime', ''),  # noqa
        '0009xx3a': ('FL', '1', 'PET pre_inj_volume', ''),  # noqa
        '0009xx3b': ('DT', '1', 'PET admin_datetime', ''),  # noqa
        '0009xx3c': ('FL', '1', 'PET post_inj_activity', ''),  # noqa
        '0009xx3d': ('DT', '1', 'PET post_inj_datetime', ''),  # noqa
        '0009xx3e': ('SH', '1', 'PET radionuclide_name', ''),  # noqa
        '0009xx3f': ('FL', '1', 'PET half_life', ''),  # noqa
        '0009xx40': ('FL', '1', 'PET positron_fraction', ''),  # noqa
        '0009xx41': ('SL', '1', 'PET source1_holder', ''),  # noqa
        '0009xx42': ('FL', '1', 'PET source1_activity', ''),  # noqa
        '0009xx43': ('DT', '1', 'PET source1_meas_dt', ''),  # noqa
        '0009xx44': ('SH', '1', 'PET source1_radnuclide', ''),  # noqa
        '0009xx45': ('FL', '1', 'PET source1_half_life', ''),  # noqa
        '0009xx46': ('SL', '1', 'PET source2_holder', ''),  # noqa
        '0009xx47': ('FL', '1', 'PET source2_activity', ''),  # noqa
        '0009xx48': ('DT', '1', 'PET source2_meas_dt', ''),  # noqa
        '0009xx49': ('SH', '1', 'PET source2_radnuclide', ''),  # noqa
        '0009xx4a': ('FL', '1', 'PET source2_half_life', ''),  # noqa
        '0009xx4b': ('SL', '1', 'PET source_speed', ''),  # noqa
        '0009xx4c': ('FL', '1', 'PET source_location', ''),  # noqa
        '0009xx4d': ('SL', '1', 'PET emission_present', ''),  # noqa
        '0009xx4e': ('SL', '1', 'PET lower_axial_acc', ''),  # noqa
        '0009xx4f': ('SL', '1', 'PET upper_axial_acc', ''),  # noqa
        '0009xx50': ('SL', '1', 'PET lower_coinc_limit', ''),  # noqa
        '0009xx51': ('SL', '1', 'PET upper_coinc_limit', ''),  # noqa
        '0009xx52': ('SL', '1', 'PET coinc_delay_offset', ''),  # noqa
        '0009xx53': ('SL', '1', 'PET coinc_output_mode', ''),  # noqa
        '0009xx54': ('SL', '1', 'PET upper_energy_limit', ''),  # noqa
        '0009xx55': ('SL', '1', 'PET lower_energy_limit', ''),  # noqa
        '0009xx56': ('UI', '1', 'PET normal_cal_id', ''),  # noqa
        '0009xx57': ('UI', '1', 'PET normal_2d_cal_id', ''),  # noqa
        '0009xx58': ('UI', '1', 'PET blank_cal_id', ''),  # noqa
        '0009xx59': ('UI', '1', 'PET wc_cal_id', ''),  # noqa
        '0009xx5a': ('SL', '1', 'PET derived', ''),  # noqa
        '0009xx5b': ('LO', '1', 'PET contrast_agent', ''),  # noqa
        '0009xx5c': ('UI', '1', 'PET frame_id', ''),  # noqa
        '0009xx5d': ('UI', '1', 'PET scan_id', ''),  # noqa
        '0009xx5e': ('UI', '1', 'PET exam_id', ''),  # noqa
        '0009xx5f': ('LO', '1', 'PET patient_id', ''),  # noqa
        '0009xx60': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0009xx61': ('SH', '1', 'PET software_version', ''),  # noqa
        '0009xx62': ('ST', '1', 'PET where_is_frame', ''),  # noqa
        '0009xx63': ('SL', '1', 'PET frame_size', ''),  # noqa
        '0009xx64': ('SL', '1', 'PET file_exists', ''),  # noqa
        '0009xx65': ('SL', '1', 'PET patient_entry', ''),  # noqa
        '0009xx66': ('FL', '1', 'PET table_height', ''),  # noqa
        '0009xx67': ('FL', '1', 'PET table_z_position', ''),  # noqa
        '0009xx68': ('DT', '1', 'PET landmark_datetime', ''),  # noqa
        '0009xx69': ('SL', '1', 'PET slice_count', ''),  # noqa
        '0009xx6a': ('FL', '1', 'PET start_location', ''),  # noqa
        '0009xx6b': ('SL', '1', 'PET acq_delay', ''),  # noqa
        '0009xx6c': ('DT', '1', 'PET acq_start', ''),  # noqa
        '0009xx6d': ('SL', '1', 'PET acq_duration', ''),  # noqa
        '0009xx6e': ('SL', '1', 'PET acq_bin_dur', ''),  # noqa
        '0009xx6f': ('SL', '1', 'PET acq_bin_start', ''),  # noqa
        '0009xx70': ('SL', '1', 'PET actual_stop_cond', ''),  # noqa
        '0009xx71': ('FD', '1', 'PET total_prompts', ''),  # noqa
        '0009xx72': ('FD', '1', 'PET total_delays', ''),  # noqa
        '0009xx73': ('SL', '1', 'PET frame_valid', ''),  # noqa
        '0009xx74': ('SL', '1', 'PET validity_info', ''),  # noqa
        '0009xx75': ('SL', '1', 'PET archived', ''),  # noqa
        '0009xx76': ('SL', '1', 'PET compression', ''),  # noqa
        '0009xx77': ('SL', '1', 'PET uncompressed_size', ''),  # noqa
        '0009xx78': ('SL', '1', 'PET accum_bin_dur', ''),  # noqa
        '0009xx79': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0009xx7a': ('SH', '1', 'PET software_version', ''),  # noqa
        '0009xx7b': ('DT', '1', 'PET is_datetime', ''),  # noqa
        '0009xx7c': ('SL', '1', 'PET is_source', ''),  # noqa
        '0009xx7d': ('SL', '1', 'PET is_contents', ''),  # noqa
        '0009xx7e': ('SL', '1', 'PET is_type', ''),  # noqa
        '0009xx7f': ('DS', '3', 'PET is_reference', ''),  # noqa
        '0009xx80': ('SL', '1', 'PET multi_patient', ''),  # noqa
        '0009xx81': ('SL', '1', 'PET number_of_normals', ''),  # noqa
        '0009xx82': ('UI', '1', 'PET color_map_id', ''),  # noqa
        '0009xx83': ('SL', '1', 'PET window_level_type', ''),  # noqa
        '0009xx84': ('FL', '1', 'PET rotate', ''),  # noqa
        '0009xx85': ('SL', '1', 'PET flip', ''),  # noqa
        '0009xx86': ('FL', '1', 'PET zoom', ''),  # noqa
        '0009xx87': ('SL', '1', 'PET pan_x', ''),  # noqa
        '0009xx88': ('SL', '1', 'PET pan_y', ''),  # noqa
        '0009xx89': ('FL', '1', 'PET window_level_min', ''),  # noqa
        '0009xx8a': ('FL', '1', 'PET window_level_max', ''),  # noqa
        '0009xx8b': ('SL', '1', 'PET recon_method', ''),  # noqa
        '0009xx8c': ('SL', '1', 'PET attenuation', ''),  # noqa
        '0009xx8d': ('FL', '1', 'PET atten_coefficient', ''),  # noqa
        '0009xx8e': ('SL', '1', 'PET bp_filter', ''),  # noqa
        '0009xx8f': ('FL', '1', 'PET bp_filter_cutoff', ''),  # noqa
        '0009xx90': ('SL', '1', 'PET bp_filter_order', ''),  # noqa
        '0009xx91': ('FL', '1', 'PET bp_center_l', ''),  # noqa
        '0009xx92': ('FL', '1', 'PET bp_center_p', ''),  # noqa
        '0009xx93': ('SL', '1', 'PET atten_smooth', ''),  # noqa
        '0009xx94': ('SL', '1', 'PET atten_smooth_param', ''),  # noqa
        '0009xx95': ('SL', '1', 'PET angle_smooth_param', ''),  # noqa
        '0009xx96': ('UI', '1', 'PET wellcountercal_id', ''),  # noqa
        '0009xx97': ('UI', '1', 'PET trans_scan_id', ''),  # noqa
        '0009xx98': ('UI', '1', 'PET norm_cal_id', ''),  # noqa
        '0009xx99': ('UI', '1', 'PET blnk_cal_id', ''),  # noqa
        '0009xx9a': ('FL', '1', 'PET cac_edge_threshold', ''),  # noqa
        '0009xx9b': ('FL', '1', 'PET cac_skull_offset', ''),  # noqa
        '0009xx9c': ('UI', '1', 'PET emiss_sub_id', ''),  # noqa
        '0009xx9d': ('SL', '1', 'PET radial_filter_3d', ''),  # noqa
        '0009xx9e': ('FL', '1', 'PET radial_cutoff_3d', ''),  # noqa
        '0009xx9f': ('SL', '1', 'PET axial_filter_3d', ''),  # noqa
        '0009xxa0': ('FL', '1', 'PET axial_cutoff_3d', ''),  # noqa
        '0009xxa1': ('FL', '1', 'PET axial_start', ''),  # noqa
        '0009xxa2': ('FL', '1', 'PET axial_spacing', ''),  # noqa
        '0009xxa3': ('SL', '1', 'PET axial_angles_used', ''),  # noqa
        '0009xxa4': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0009xxa5': ('SH', '1', 'PET software_version', ''),  # noqa
        '0009xxa6': ('SL', '1', 'PET slice_number', ''),  # noqa
        '0009xxa7': ('FL', '1', 'PET total_counts', ''),  # noqa
        '0009xxa8': ('OB', '1', 'PET other_atts', ''),  # noqa
        '0009xxa9': ('SL', '1', 'PET other_atts_size', ''),  # noqa
        '0009xxaa': ('SL', '1', 'PET archived', ''),  # noqa
        '0009xxab': ('FL', '1', 'PET bp_center_x', ''),  # noqa
        '0009xxac': ('FL', '1', 'PET bp_center_y', ''),  # noqa
        '0009xxad': ('UI', '1', 'PET trans_frame_id', ''),  # noqa
        '0009xxae': ('UI', '1', 'PET tpluse_frame_id', ''),  # noqa
        '0009xxb1': ('FL', '1', 'PET profile_spacing', ''),  # noqa
        '0009xxb2': ('SL', '1', 'PET ir_num_iterations', ''),  # noqa
        '0009xxb3': ('SL', '1', 'PET ir_num_subsets', ''),  # noqa
        '0009xxb4': ('FL', '1', 'PET ir_recon_fov', ''),  # noqa
        '0009xxb5': ('SL', '1', 'PET ir_corr_model', ''),  # noqa
        '0009xxb6': ('SL', '1', 'PET ir_loop_filter', ''),  # noqa
        '0009xxb7': ('FL', '1', 'PET ir_pre_filt_parm', ''),  # noqa
        '0009xxb8': ('SL', '1', 'PET ir_loop_filt_parm', ''),  # noqa
        '0009xxb9': ('FL', '1', 'PET response_filt_parm', ''),  # noqa
        '0009xxba': ('SL', '1', 'PET post_filter', ''),  # noqa
        '0009xxbb': ('FL', '1', 'PET post_filt_parm', ''),  # noqa
        '0009xxbc': ('SL', '1', 'PET ir_regularize', ''),  # noqa
        '0009xxbd': ('FL', '1', 'PET regularize_parm', ''),  # noqa
        '0009xxbe': ('SL', '1', 'PET ac_bp_filter', ''),  # noqa
        '0009xxbf': ('FL', '1', 'PET ac_bp_filt_cut_off', ''),  # noqa
        '0009xxc0': ('SL', '1', 'PET ac_bp_filt_order', ''),  # noqa
        '0009xxc1': ('SL', '1', 'PET ac_img_smooth', ''),  # noqa
        '0009xxc2': ('FL', '1', 'PET ac_img_smooth_parm', ''),  # noqa
        '0009xxc3': ('SL', '1', 'PET scatter_method', ''),  # noqa
        '0009xxc4': ('SL', '1', 'PET scatter_num_iter', ''),  # noqa
        '0009xxc5': ('FL', '1', 'PET scatter_parm', ''),  # noqa
        '0009xxc6': ('FL', '1', 'PET seg_qc_parm', ''),  # noqa
        '0009xxc7': ('SL', '1', 'PET overlap', ''),  # noqa
        '0009xxc8': ('UI', '1', 'PET ovlp_frm_id', ''),  # noqa
        '0009xxc9': ('UI', '1', 'PET ovlp_trans_frm_id', ''),  # noqa
        '0009xxca': ('UI', '1', 'PET ovlp_tpulse_frm_id', ''),  # noqa
        '0009xxcb': ('FL', '1', 'PET vqc_x_axis_trans', ''),  # noqa
        '0009xxcc': ('FL', '1', 'PET vqc_x_axis_tilt', ''),  # noqa
        '0009xxcd': ('FL', '1', 'PET vqc_y_axis_trans', ''),  # noqa
        '0009xxce': ('FL', '1', 'PET vqc_y_axis_swivel', ''),  # noqa
        '0009xxcf': ('FL', '1', 'PET vqc_z_axis_trans', ''),  # noqa
        '0009xxd0': ('FL', '1', 'PET vqc_z_axis_roll', ''),  # noqa
        '0009xxd1': ('LO', '1', 'PET ctac_conv_scale', ''),  # noqa
        '0009xxd2': ('UI', '1', 'PET image_set_id', ''),  # noqa
        '0009xxd3': ('SL', '1', 'PET constrast_route', ''),  # noqa
        '0009xxd4': ('LO', '1', 'PET ctac_conv_scale', ''),  # noqa
        '0009xxd5': ('FL', '1', 'PET loop_filter_parm', ''),  # noqa
        '0009xxd6': ('FL', '1', 'PET image_one_loc', ''),  # noqa
        '0009xxd7': ('FL', '1', 'PET image_index_loc', ''),  # noqa
        '0009xxd8': ('SL', '1', 'PET frame_number', ''),  # noqa
        '0009xxd9': ('SL', '1', 'PET list_file_exists', ''),  # noqa
        '0009xxda': ('ST', '1', 'PET where_is_list_frame', ''),  # noqa
        '0009xxdb': ('SL', '1', 'PET ir_z_filter_flag', ''),  # noqa
        '0009xxdc': ('FL', '1', 'PET ir_z_filter_ratio', ''),  # noqa
        '0009xxdd': ('US', '1', 'PET num_of_rr_interval', ''),  # noqa
        '0009xxde': ('US', '1', 'PET num_of_time_slots', ''),  # noqa
        '0009xxdf': ('US', '1', 'PET num_of_slices', ''),  # noqa
        '0009xxe0': ('US', '1', 'PET num_of_time_slices', ''),  # noqa
        '0009xxe1': ('SL', '1', 'PET unlisted_scan', ''),  # noqa
        '0009xxe2': ('SL', '1', 'PET rest_stress', ''),  # noqa
        '0009xxe3': ('FL', '1', 'PET phase percentage', ''),  # noqa
        '0009xxe4': ('ST', '1', 'Recon Protocol', ''),  # noqa
        '0009xxe5': ('FL', '1', 'PET left shift', ''),  # noqa
        '0009xxe6': ('FL', '1', 'PET posterior shift', ''),  # noqa
        '0009xxe7': ('FL', '1', 'PET superior shift', ''),  # noqa
        '0009xxe8': ('SL', '1', 'PET acq_bin_num', ''),  # noqa
        '0009xxe9': ('FL', '1', 'PET acq_bin_dur_percent', ''),  # noqa
        '0009xxea': ('SL', '1', '3D Filter flag', ''),  # noqa
        '0009xxeb': ('FL', '1', '3D Filter cutoff', ''),  # noqa
        '0009xxec': ('SL', '1', '3D Filter order', ''),  # noqa
        '0009xxf0': ('UI', '1', 'Reformat group', ''),  # noqa
        '0011xx01': ('SQ', '1', 'GE Advance ROI Sequence', ''),  # noqa
        '0011xx02': ('UI', '1', 'GE Advance ROI.roi_id', ''),  # noqa
        '0011xx03': ('UI', '1', 'GE Advance ROI.image_id', ''),  # noqa
        '0011xx04': ('SH', '1', 'GE Advance ROI.compatible_version', ''),  # noqa
        '0011xx05': ('SH', '1', 'GE Advance ROI.software_version', ''),  # noqa
        '0011xx06': ('LO', '1', 'GE Advance ROI.roi_name', ''),  # noqa
        '0011xx07': ('DT', '1', 'GE Advance ROI.roi_datetime', ''),  # noqa
        '0011xx08': ('SL', '1', 'GE Advance ROI.roi_type', ''),  # noqa
        '0011xx09': ('FL', '1', 'GE Advance ROI.center_x', ''),  # noqa
        '0011xx0a': ('FL', '1', 'GE Advance ROI.center_y', ''),  # noqa
        '0011xx0b': ('FL', '1', 'GE Advance ROI.width', ''),  # noqa
        '0011xx0c': ('FL', '1', 'GE Advance ROI.height', ''),  # noqa
        '0011xx0d': ('FL', '1', 'GE Advance ROI.angle', ''),  # noqa
        '0011xx0e': ('SL', '1', 'GE Advance ROI.number_of_points', ''),  # noqa
        '0011xx0f': ('OB', '1', 'GE Advance ROI.roi_data', ''),  # noqa
        '0011xx10': ('SL', '1', 'GE Advance ROI.roi_size', ''),  # noqa
        '0011xx11': ('LO', '1', 'GE Advance ROI.color', ''),  # noqa
        '0011xx12': ('SL', '1', 'GE Advance ROI.line_type', ''),  # noqa
        '0011xx13': ('SL', '1', 'GE Advance ROI.line_width', ''),  # noqa
        '0011xx14': ('SL', '1', 'GE Advance ROI.roi_number', ''),  # noqa
        '0011xx15': ('SL', '1', 'GE Advance ROI.convex', ''),  # noqa
        '0011xx16': ('SL', '1', 'GE Advance ROI.atten_corr_flag', ''),  # noqa
        '0011xx18': ('OB', '1', 'Unknown', ''),  # noqa
        '0013xx01': ('SQ', '1', 'GE Advance Annotation Sequence', ''),  # noqa
        '0013xx02': ('UI', '1', 'GE Advance Annotation.annotation_id', ''),  # noqa
        '0013xx03': ('UI', '1', 'GE Advance Annotation.image_id', ''),  # noqa
        '0013xx04': ('SH', '1', 'GE Advance Annotation.compatible_version', ''),  # noqa
        '0013xx05': ('SH', '1', 'GE Advance Annotation.software_version', ''),  # noqa
        '0013xx06': ('SL', '1', 'GE Advance Annotation.type', ''),  # noqa
        '0013xx07': ('LO', '1', 'GE Advance Annotation.font_name', ''),  # noqa
        '0013xx08': ('SH', '1', 'GE Advance Annotation.font_size', ''),  # noqa
        '0013xx09': ('LO', '1', 'GE Advance Annotation.foreground_color', ''),  # noqa
        '0013xx0a': ('LO', '1', 'GE Advance Annotation.background_color', ''),  # noqa
        '0013xx0b': ('SL', '1', 'GE Advance Annotation.coordinate_system', ''),  # noqa
        '0013xx0c': ('FL', '1', 'GE Advance Annotation.start_x', ''),  # noqa
        '0013xx0d': ('FL', '1', 'GE Advance Annotation.start_y', ''),  # noqa
        '0013xx0e': ('FL', '1', 'GE Advance Annotation.end_x', ''),  # noqa
        '0013xx0f': ('FL', '1', 'GE Advance Annotation.end_y', ''),  # noqa
        '0013xx10': ('SL', '1', 'GE Advance Annotation.start_symbol', ''),  # noqa
        '0013xx11': ('SL', '1', 'GE Advance Annotation.end_symbol', ''),  # noqa
        '0013xx12': ('OB', '1', 'GE Advance Annotation.annotation_data', ''),  # noqa
        '0013xx13': ('SL', '1', 'GE Advance Annotation.annotation_size', ''),  # noqa
        '0013xx14': ('LO', '1', 'GE Advance Annotation.label_id', ''),  # noqa
        '0017xx01': ('UI', '1', 'PET correction_cal_id', ''),  # noqa
        '0017xx02': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0017xx03': ('SH', '1', 'PET software_version', ''),  # noqa
        '0017xx04': ('DT', '1', 'PET cal_datetime', ''),  # noqa
        '0017xx05': ('LO', '1', 'PET cal_description', ''),  # noqa
        '0017xx06': ('SL', '1', 'PET cal_type', ''),  # noqa
        '0017xx07': ('ST', '1', 'PET where_is_corr', ''),  # noqa
        '0017xx08': ('SL', '1', 'PET corr_file_size', ''),  # noqa
        '0017xx09': ('LO', '1', 'PET scan_id', ''),  # noqa
        '0017xx0a': ('DT', '1', 'PET scan_datetime', ''),  # noqa
        '0017xx0b': ('LO', '1', 'PET norm_2d_cal_id', ''),  # noqa
        '0017xx0c': ('SH', '1', 'PET hosp_identifier', ''),  # noqa
        '0017xx0d': ('SL', '1', 'PET archived', ''),  # noqa
        '0019xx01': ('UI', '1', 'PET wc_cal_id', ''),  # noqa
        '0019xx02': ('SH', '1', 'PET compatible_version', ''),  # noqa
        '0019xx03': ('SH', '1', 'PET software_version', ''),  # noqa
        '0019xx04': ('DT', '1', 'PET cal_datetime', ''),  # noqa
        '0019xx05': ('SL', '1', 'PET cal_type', ''),  # noqa
        '0019xx06': ('LO', '1', 'PET cal_description', ''),  # noqa
        '0019xx07': ('LO', '1', 'PET cal_hardware', ''),  # noqa
        '0019xx08': ('OB', '1', 'PET coefficients', ''),  # noqa
        '0019xx09': ('FL', '1', 'PET activity_factor_hr', ''),  # noqa
        '0019xx0a': ('FL', '1', 'PET activity_factor_hs', ''),  # noqa
        '0019xx0b': ('FL', '1', 'PET activity_factor_3d', ''),  # noqa
        '0019xx0c': ('LO', '1', 'PET scan_id', ''),  # noqa
        '0019xx0d': ('DT', '1', 'PET scan_datetime', ''),  # noqa
        '0019xx0e': ('SH', '1', 'PET hosp_identifier', ''),  # noqa
        '0019xx0f': ('FL', '1', 'PET meas_activity', ''),  # noqa
        '0019xx10': ('DT', '1', 'PET meas_datetime', ''),  # noqa
        '0019xx11': ('SL', '1', 'PET axial_filter_3d', ''),  # noqa
        '0019xx12': ('FL', '1', 'PET axial_cutoff_3d', ''),  # noqa
        '0019xx13': ('SL', '1', 'PET default_flag', ''),  # noqa
        '0019xx14': ('SL', '1', 'PET archived', ''),  # noqa
        '0019xx15': ('SL', '1', 'PET wc_cal_rec_method', ''),  # noqa
        '0019xx16': ('SL', '1', 'PET activity_factor_2d', ''),  # noqa
        '0019xx17': ('SL', '1', 'PET isotope', ''),  # noqa
        '0021xx01': ('US', '1', 'PET raw_data_type', ''),  # noqa
        '0021xx02': ('UL', '1', 'PET raw_data_size', ''),  # noqa
        '0023xx01': ('OB', '1', 'raw_data_blob', ''),  # noqa
        '0023xx02': ('OB', '1', 'PET raw_data_blob', ''),  # noqa
        '5001xx01': ('UI', '1', 'GE Advance Curve.curve_id', ''),  # noqa
        '5001xx02': ('SH', '1', 'GE Advance Curve.compatible_version', ''),  # noqa
        '5001xx03': ('SH', '1', 'GE Advance Curve.software_version', ''),  # noqa
        '5001xx04': ('SL', '1', 'GE Advance Curve.statistics_type', ''),  # noqa
        '5001xx05': ('LT', '1', 'GE Advance Curve.how_derived', ''),  # noqa
        '5001xx06': ('SL', '1', 'GE Advance Curve.how_derived_size', ''),  # noqa
        '5001xx07': ('SL', '1', 'GE Advance Curve.multi_patient', ''),  # noqa
        '5001xx08': ('SL', '1', 'GE Advance Curve.deadtime', ''),  # noqa
        '5003xx01': ('SQ', '1', 'GE Advance Graph Sequence', ''),  # noqa
        '5003xx02': ('UI', '1', 'GE Advance Graph.graph_id', ''),  # noqa
        '5003xx03': ('SH', '1', 'GE Advance Graph.compatible_version', ''),  # noqa
        '5003xx04': ('SH', '1', 'GE Advance Graph.software_version', ''),  # noqa
        '5003xx05': ('LO', '1', 'GE Advance Graph.title', ''),  # noqa
        '5003xx06': ('DT', '1', 'GE Advance Graph.graph_datetime', ''),  # noqa
        '5003xx07': ('ST', '1', 'GE Advance Graph.graph_description', ''),  # noqa
        '5003xx08': ('LO', '1', 'GE Advance Graph.title_font_name', ''),  # noqa
        '5003xx09': ('SH', '1', 'GE Advance Graph.title_font_size', ''),  # noqa
        '5003xx0a': ('LO', '1', 'GE Advance Graph.footer', ''),  # noqa
        '5003xx0b': ('SH', '1', 'GE Advance Graph.footer_font_size', ''),  # noqa
        '5003xx0c': ('LO', '1', 'GE Advance Graph.foreground_color', ''),  # noqa
        '5003xx0d': ('LO', '1', 'GE Advance Graph.background_color', ''),  # noqa
        '5003xx0e': ('SL', '1', 'GE Advance Graph.graph_border', ''),  # noqa
        '5003xx0f': ('SL', '1', 'GE Advance Graph.graph_width', ''),  # noqa
        '5003xx10': ('SL', '1', 'GE Advance Graph.graph_height', ''),  # noqa
        '5003xx11': ('SL', '1', 'GE Advance Graph.grid', ''),  # noqa
        '5003xx12': ('LO', '1', 'GE Advance Graph.label_font_name', ''),  # noqa
        '5003xx13': ('SH', '1', 'GE Advance Graph.label_font_size', ''),  # noqa
        '5003xx14': ('LO', '1', 'GE Advance Graph.axes_color', ''),  # noqa
        '5003xx15': ('LO', '1', 'GE Advance Graph.x_axis_label', ''),  # noqa
        '5003xx16': ('SL', '1', 'GE Advance Graph.x_axis_units', ''),  # noqa
        '5003xx17': ('FL', '1', 'GE Advance Graph.x_major_tics', ''),  # noqa
        '5003xx18': ('FL', '1', 'GE Advance Graph.x_axis_min', ''),  # noqa
        '5003xx19': ('FL', '1', 'GE Advance Graph.x_axis_max', ''),  # noqa
        '5003xx1a': ('LO', '1', 'GE Advance Graph.y_axis_label', ''),  # noqa
        '5003xx1b': ('SL', '1', 'GE Advance Graph.y_axis_units', ''),  # noqa
        '5003xx1c': ('FL', '1', 'GE Advance Graph.y_major_tics', ''),  # noqa
        '5003xx1d': ('FL', '1', 'GE Advance Graph.y_axis_min', ''),  # noqa
        '5003xx1e': ('FL', '1', 'GE Advance Graph.y_axis_max', ''),  # noqa
        '5003xx1f': ('LO', '1', 'GE Advance Graph.legend_font_name', ''),  # noqa
        '5003xx20': ('SH', '1', 'GE Advance Graph.legend_font_size', ''),  # noqa
        '5003xx21': ('SL', '1', 'GE Advance Graph.legend_location_x', ''),  # noqa
        '5003xx22': ('SL', '1', 'GE Advance Graph.legend_location_y', ''),  # noqa
        '5003xx23': ('SL', '1', 'GE Advance Graph.legend_width', ''),  # noqa
        '5003xx24': ('SL', '1', 'GE Advance Graph.legend_height', ''),  # noqa
        '5003xx25': ('SL', '1', 'GE Advance Graph.legend_border', ''),  # noqa
        '5003xx26': ('SL', '1', 'GE Advance Graph.multi_patient', ''),  # noqa
        '5005xx01': ('SQ', '1', 'GE Advance CurvePresentation Sequence', ''),  # noqa
        '5005xx02': ('UI', '1', 'GE Advance CurvePresentation.curvepresent_id', ''),  # noqa
        '5005xx03': ('UI', '1', 'GE Advance CurvePresentation.graph_id', ''),  # noqa
        '5005xx04': ('UI', '1', 'GE Advance CurvePresentation.curve_id', ''),  # noqa
        '5005xx05': ('SH', '1', 'GE Advance CurvePresentation.compatible_version', ''),  # noqa
        '5005xx06': ('SH', '1', 'GE Advance CurvePresentation.software_version', ''),  # noqa
        '5005xx07': ('LO', '1', 'GE Advance CurvePresentation.curve_label', ''),  # noqa
        '5005xx08': ('LO', '1', 'GE Advance CurvePresentation.color', ''),  # noqa
        '5005xx09': ('SL', '1', 'GE Advance CurvePresentation.line_type', ''),  # noqa
        '5005xx0a': ('SL', '1', 'GE Advance CurvePresentation.line_width', ''),  # noqa
        '5005xx0b': ('SL', '1', 'GE Advance CurvePresentation.point_symbol', ''),  # noqa
        '5005xx0c': ('SL', '1', 'GE Advance CurvePresentation.point_symbol_dim', ''),  # noqa
        '5005xx0d': ('LO', '1', 'GE Advance CurvePresentation.point_color', ''),  # noqa
    },
    'GEMS_QVA_PHOTO_01': {
        '0009xx60': ('FL', '1', 'Dodge End Diastolic Volume ml', ''),  # noqa
        '0009xx61': ('FL', '1', 'Dodge End Systolic Volume ml', ''),  # noqa
        '0009xx62': ('FL', '1', 'Dodge Stroke Volume ml', ''),  # noqa
        '0009xx63': ('IS', '1', 'Dodge Ejection Fraction', ''),  # noqa
        '0009xx64': ('FL', '1', 'Simpson End Diastolic Volume ml', ''),  # noqa
        '0009xx65': ('FL', '1', 'Simpson End Systolic Volume ml', ''),  # noqa
        '0009xx66': ('FL', '1', 'Simpson Stroke Volume ml', ''),  # noqa
        '0009xx67': ('IS', '1', 'Simpson Ejection Fraction', ''),  # noqa
        '0009xx68': ('FL', '1', 'CFX Single Hypokinesia in Region', ''),  # noqa
        '0009xx69': ('FL', '1', 'CFX Single Hyperkinesia in Opposite Region', ''),  # noqa
        '0009xx6a': ('IS', '1', 'CFX Single Total LV contour Percent', ''),  # noqa
        '0009xx6b': ('FL', '1', 'CFX Multiple Hypokinesia in Region', ''),  # noqa
        '0009xx6c': ('FL', '1', 'CFX Multiple Hyperkinesia in Opposite Region', ''),  # noqa
        '0009xx6d': ('IS', '1', 'CFX Multiple Total LV contour Percent', ''),  # noqa
        '0009xx6e': ('FL', '1', 'RCA Single Hypokinesia in Region', ''),  # noqa
        '0009xx6f': ('FL', '1', 'RCA Single Hyperkinesia in Opposite Region', ''),  # noqa
        '0009xx70': ('IS', '1', 'RCA Single Total LV contour Percent', ''),  # noqa
        '0009xx71': ('FL', '1', 'RCA Multiple Hypokinesia in Region', ''),  # noqa
        '0009xx72': ('FL', '1', 'RCA Multiple Hyperkinesia in Opposite Region', ''),  # noqa
        '0009xx73': ('IS', '1', 'RCA Multiple Total LV contour Percent', ''),  # noqa
        '0009xx74': ('FL', '1', 'LAD Single Hypokinesia in Region', ''),  # noqa
        '0009xx75': ('FL', '1', 'LAD Single Hyperkinesia in Opposite Region', ''),  # noqa
        '0009xx76': ('IS', '1', 'LAD Single Total LV contour Percent', ''),  # noqa
        '0009xx77': ('FL', '1', 'LAD Multiple Hypokinesia in Region', ''),  # noqa
        '0009xx78': ('FL', '1', 'LAD Multiple Hyperkinesia in Opposite Region', ''),  # noqa
        '0009xx79': ('IS', '1', 'LAD Multiple Total LV contour Percent', ''),  # noqa
        '0009xx7a': ('FL', '1', 'Dodge End Diastolic Volume ml/m2', ''),  # noqa
        '0009xx7c': ('FL', '1', 'Dodge End Systolic Volume ml/m2', ''),  # noqa
        '0009xx7e': ('FL', '1', 'Dodge Stroke Volume ml/m2', ''),  # noqa
        '0009xx80': ('FL', '1', 'Simpson End Diastolic Volume ml/m2', ''),  # noqa
        '0009xx82': ('FL', '1', 'Simpson End Systolic Volume ml/m2', ''),  # noqa
        '0009xx84': ('FL', '1', 'Simpson Stroke Volume ml/m2', ''),  # noqa
    },
    'GEMS_RELA_01': {
        '002110xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0021xx03': ('SS', '1', 'Series from which Prescribed', ''),  # noqa
        '0021xx05': ('SH', '1', 'Genesis Version - now', ''),  # noqa
        '0021xx07': ('UL', '1', 'Series Record checksum', ''),  # noqa
        '0021xx15': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx16': ('SS', '1', 'Unknown', ''),  # noqa
        '0021xx18': ('SH', '1', 'Genesis version - Now', ''),  # noqa
        '0021xx19': ('UL', '1', 'Acq recon record checksum', ''),  # noqa
        '0021xx20': ('DS', '1', 'Table start location', ''),  # noqa
        '0021xx35': ('SS', '1', 'Series from which prescribed', ''),  # noqa
        '0021xx36': ('SS', '1', 'Image from which prescribed', ''),  # noqa
        '0021xx37': ('SS', '1', 'Screen Format', ''),  # noqa
        '0021xx4a': ('LO', '1', 'Anatomical reference for scout', ''),  # noqa
        '0021xx4e': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx4f': ('SS', '1', 'Locations in acquisition', ''),  # noqa
        '0021xx50': ('SS', '1', 'Graphically prescribed', ''),  # noqa
        '0021xx51': ('DS', '1', 'Rotation from source x rot', ''),  # noqa
        '0021xx52': ('DS', '1', 'Rotation from source y rot', ''),  # noqa
        '0021xx53': ('DS', '1', 'Rotation from source z rot', ''),  # noqa
        '0021xx54': ('SH', '3', 'Image position', ''),  # noqa
        '0021xx55': ('SH', '6', 'Image orientation', ''),  # noqa
        '0021xx56': ('SL', '1', 'Num 3D slabs', ''),  # noqa
        '0021xx57': ('SL', '1', 'Locs per 3D slab', ''),  # noqa
        '0021xx58': ('SL', '1', 'Overlaps', ''),  # noqa
        '0021xx59': ('SL', '1', 'Image Filtering 0.5/0.2T', ''),  # noqa
        '0021xx5a': ('SL', '1', 'Diffusion direction', ''),  # noqa
        '0021xx5b': ('DS', '1', 'Tagging Flip Angle', ''),  # noqa
        '0021xx5c': ('DS', '1', 'Tagging Orientation', ''),  # noqa
        '0021xx5d': ('DS', '1', 'Tag Spacing', ''),  # noqa
        '0021xx5e': ('DS', '1', 'RTIA_timer', ''),  # noqa
        '0021xx5f': ('DS', '1', 'Fps', ''),  # noqa
        '0021xx70': ('LT', '1', 'Unknown', ''),  # noqa
        '0021xx71': ('LT', '1', 'Unknown', ''),  # noqa
        '0021xx81': ('DS', '1', 'Auto window/level alpha', ''),  # noqa
        '0021xx82': ('DS', '1', 'Auto window/level beta', ''),  # noqa
        '0021xx83': ('DS', '1', 'Auto window/level window', ''),  # noqa
        '0021xx84': ('DS', '1', 'Auto window/level level', ''),  # noqa
        '0021xx90': ('SS', '1', 'Tube focal spot position', ''),  # noqa
        '0021xx91': ('SS', '1', 'Biopsy position', ''),  # noqa
        '0021xx92': ('FL', '1', 'Biopsy T location', ''),  # noqa
        '0021xx93': ('FL', '1', 'Biopsy ref location', ''),  # noqa
    },
    'GEMS_RTEN_01': {
        '0249xx11': ('DA', '1', 'Plan Creation Date', ''),  # noqa
        '0249xx13': ('TM', '1', 'Plan Creation Time', ''),  # noqa
        '0249xx14': ('PN', '1', 'Operator Name', ''),  # noqa
        '0249xx16': ('LO', '1', 'Plan Comment', ''),  # noqa
        '0249xx18': ('SQ', '1', 'Plan Image Sequence', ''),  # noqa
        '0249xx1a': ('LO', '1', 'Exam/Series/Image Identifier', ''),  # noqa
        '0249xx1b': ('IS', '1', 'Additional Image Identifier', ''),  # noqa
        '0249xx1c': ('CS', '1', 'Build Resolution', ''),  # noqa
        '0249xx20': ('SQ', '1', 'Structure Sequence', ''),  # noqa
        '0249xx22': ('SH', '1', 'Structure Name', ''),  # noqa
        '0249xx24': ('CS', '1', 'Structure Type', ''),  # noqa
        '0249xx28': ('CS', '1', 'Structure Color', ''),  # noqa
        '0249xx30': ('SQ', '1', 'Slab Sequence', ''),  # noqa
        '0249xx32': ('SQ', '1', 'Slab Image Sequence', ''),  # noqa
        '0249xx36': ('DS', '1', 'Z Plus Thickness', ''),  # noqa
        '0249xx38': ('DS', '1', 'Z Minus Thickness', ''),  # noqa
        '0249xx3a': ('DS', '3-n', 'Slab Shape', ''),  # noqa
        '0249xx40': ('SQ', '1', 'Marker Sequence', ''),  # noqa
        '0249xx42': ('SH', '1', 'Marker Name', ''),  # noqa
        '0249xx44': ('CS', '1', 'Marker Color', ''),  # noqa
        '0249xx46': ('DS', '3', 'Marker Position', ''),  # noqa
        '0249xx50': ('SQ', '1', 'Beam Group Sequence', ''),  # noqa
        '0249xx51': ('SH', '1', 'Group Name', ''),  # noqa
        '0249xx52': ('CS', '1-n', 'Group Properties', ''),  # noqa
        '0249xx54': ('SQ', '1', 'Beam Sequence', ''),  # noqa
        '0249xx60': ('SQ', '1', 'Machine Reference Sequence', ''),  # noqa
        '0249xx62': ('SH', '1', 'Machine Name', ''),  # noqa
        '0249xx64': ('SH', '1', 'Beam Name', ''),  # noqa
        '0249xx66': ('CS', '1', 'Particle Type', ''),  # noqa
        '0249xx68': ('DS', '1', 'Nominal Particle Energy', ''),  # noqa
        '0249xx70': ('SQ', '1', 'Block Sequence', ''),  # noqa
        '0249xx72': ('LO', '1', 'Block Name', ''),  # noqa
        '0249xx74': ('DS', '2-n', 'Block Shape', ''),  # noqa
        '0249xx80': ('SQ', '1', 'Cutout Sequence', ''),  # noqa
        '0249xx82': ('LO', '1', 'Cutout Name', ''),  # noqa
        '0249xx84': ('DS', '2-n', 'Cutout Shape', ''),  # noqa
        '0249xx90': ('SH', '1', 'Collimator Name', ''),  # noqa
        '0249xx92': ('CS', '1', 'Collimator Type', ''),  # noqa
        '0249xxa0': ('SQ', '1', 'Dynamic Segment Sequence', ''),  # noqa
        '0249xxa2': ('DS', '1', 'Table Angle', ''),  # noqa
        '0249xxa4': ('DS', '1', 'Gantry Angle', ''),  # noqa
        '0249xxa6': ('DS', '1', 'Collimator Angle', ''),  # noqa
        '0249xxa8': ('DS', '3', 'Isocenter Position', ''),  # noqa
        '0249xxa9': ('DS', '1', 'Source-Surface Distance', ''),  # noqa
        '0249xxaa': ('DS', '1', 'X Symmetric Opening', ''),  # noqa
        '0249xxac': ('DS', '1', 'Y Symmetric Opening', ''),  # noqa
        '0249xxae': ('DS', '1', 'X Positive Jaw Position', ''),  # noqa
        '0249xxb0': ('DS', '1', 'X Negative Jaw Position', ''),  # noqa
        '0249xxb2': ('DS', '1', 'Y Positive Jaw Position', ''),  # noqa
        '0249xxb4': ('DS', '1', 'Y Negative Jaw Position', ''),  # noqa
        '0249xxb6': ('DS', '2-n', 'Leaf Positions', ''),  # noqa
        '0249xxd0': ('CS', '1', 'Treatment Position', ''),  # noqa
    },
    'GEMS_SENO_02': {
        '0045xx04': ('CS', '1', 'AES', ''),  # noqa
        '0045xx06': ('DS', '1', 'Stereo angle', ''),  # noqa
        '0045xx09': ('DS', '1', 'Real Magnification Factor', ''),  # noqa
        '0045xx0b': ('CS', '1', 'Senograph Type', ''),  # noqa
        '0045xx0c': ('DS', '1', 'Integration Time', ''),  # noqa
        '0045xx0d': ('DS', '1', 'ROI Origin X and Y', ''),  # noqa
        '0045xx11': ('DS', '2', 'Receptor Size cm X and Y', ''),  # noqa
        '0045xx12': ('IS', '2', 'Receptor Size Pixels X and Y', ''),  # noqa
        '0045xx13': ('ST', '1', 'Screen', ''),  # noqa
        '0045xx14': ('DS', '1', 'Pixel Pitch Microns', ''),  # noqa
        '0045xx15': ('IS', '1', 'Pixel Depth Bits', ''),  # noqa
        '0045xx16': ('IS', '2', 'Binning Factor X and Y', ''),  # noqa
        '0045xx1b': ('LO', '1', 'Clinical View', ''),  # noqa
        '0045xx1d': ('DS', '1', 'Mean Of Raw Gray Levels', ''),  # noqa
        '0045xx1e': ('DS', '1', 'Mean Of Offset Gray Levels', ''),  # noqa
        '0045xx1f': ('DS', '1', 'Mean Of Corrected Gray Levels', ''),  # noqa
        '0045xx20': ('DS', '1', 'Estimated Anat mean', ''),  # noqa
        '0045xx21': ('DS', '1', 'Mean Of Log Region Gray Levels', ''),  # noqa
        '0045xx22': ('DS', '1', 'Standard Deviation Of Raw Gray Levels', ''),  # noqa
        '0045xx23': ('DS', '1', 'Standard Deviation Of Corrected Gray Levels', ''),  # noqa
        '0045xx24': ('DS', '1', 'Standard Deviation Of Region Gray Levels', ''),  # noqa
        '0045xx25': ('DS', '1', 'Standard Deviation Of Log Region Gray Levels', ''),  # noqa
        '0045xx26': ('OB', '1', 'MAO Buffer', ''),  # noqa
        '0045xx27': ('IS', '1', 'Set Number', ''),  # noqa
        '0045xx28': ('CS', '1', 'WindowingType (LINEAR or GAMMA)', ''),  # noqa
        '0045xx29': ('DS', '2', 'Windowing parameters', ''),  # noqa
        '0045xx2a': ('IS', '1', '2DLocX', ''),  # noqa
        '0045xx2b': ('IS', '1', '2DLocY', ''),  # noqa
        '0045xx39': ('US', '1', 'Vignette Rows', ''),  # noqa
        '0045xx3a': ('US', '1', 'Vignette Columns', ''),  # noqa
        '0045xx3b': ('US', '1', 'Vignette Bits Allocated', ''),  # noqa
        '0045xx3c': ('US', '1', 'Vignette Bits Stored', ''),  # noqa
        '0045xx3d': ('US', '1', 'Vignette High Bit', ''),  # noqa
        '0045xx3e': ('US', '1', 'Vignette Pixel Representation', ''),  # noqa
        '0045xx3f': ('OB', '1', 'Vignette Pixel Data', ''),  # noqa
        '0045xx49': ('DS', '1', 'Radiological Thickness', ''),  # noqa
        '0045xx50': ('UI', '1', 'SC Instance UID', ''),  # noqa
        '0045xx51': ('UI', '1', 'SC series UID', ''),  # noqa
        '0045xx52': ('IS', '1', 'Raw Diagnostic Low', ''),  # noqa
        '0045xx53': ('IS', '1', 'Raw Diagnostic High', ''),  # noqa
        '0045xx54': ('DS', '1', 'Exponent', ''),  # noqa
        '0045xx55': ('IS', '1', 'A Coefficients', ''),  # noqa
        '0045xx56': ('DS', '1', 'Noise Reduction Sensitivity', ''),  # noqa
        '0045xx57': ('DS', '1', 'Noise Reduction Threshold', ''),  # noqa
        '0045xx58': ('DS', '1', 'mu', ''),  # noqa
        '0045xx59': ('IS', '1', 'Threshold', ''),  # noqa
        '0045xx60': ('IS', '4', 'Breast ROI X', ''),  # noqa
        '0045xx61': ('IS', '4', 'Breast ROI Y', ''),  # noqa
        '0045xx62': ('IS', '1', 'User Window Center', ''),  # noqa
        '0045xx63': ('IS', '1', 'User Window Width', ''),  # noqa
        '0045xx64': ('IS', '1', 'Segm Threshold', ''),  # noqa
        '0045xx65': ('IS', '1', 'Detector Entrance Dose', ''),  # noqa
        '0045xx66': ('IS', '1', 'Asymmetrical Collimation Information', ''),  # noqa
        '0045xx71': ('OB', '1', 'STX buffer', ''),  # noqa
        '0045xx72': ('DS', '2', 'Image Crop point', ''),  # noqa
    },
    'GEMS_SERS_01': {
        '002510xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0025xx06': ('SS', '1', 'Last pulse sequence used', ''),  # noqa
        '0025xx07': ('SL', '1', 'Images in Series', ''),  # noqa
        '0025xx10': ('SL', '1', 'Landmark Counter', ''),  # noqa
        '0025xx11': ('SS', '1', 'Number of Acquisitions', ''),  # noqa
        '0025xx14': ('SL', '1', 'Indicates no. of updates to header', ''),  # noqa
        '0025xx17': ('SL', '1', 'Series Complete Flag', ''),  # noqa
        '0025xx18': ('SL', '1', 'Number of images archived', ''),  # noqa
        '0025xx19': ('SL', '1', 'Last image number used', ''),  # noqa
        '0025xx1a': ('SH', '1', 'Primary Receiver Suite and Host', ''),  # noqa
        '0025xx1b': ('OB', '1', 'Protocol Data Block (compressed)', ''),  # noqa
    },
    'GEMS_STDY_01': {
        '002310xx': ('LO', '1', 'Private Element Creator', ''),  # noqa
        '0023xx01': ('SL', '1', 'Number of series in Study', ''),  # noqa
        '0023xx02': ('SL', '1', 'Number of unarchived Series', ''),  # noqa
        '0023xx10': ('SS', '1', 'Reference image field', ''),  # noqa
        '0023xx50': ('SS', '1', 'Summary image', ''),  # noqa
        '0023xx70': ('FD', '1', 'Start time(secs) in first axial', ''),  # noqa
        '0023xx74': ('SL', '1', 'No. of updates to header', ''),  # noqa
        '0023xx7d': ('SS', '1', 'Indicates study has complete info (DICOM/genesis)', ''),  # noqa
    },
    'GEMS_Ultrasound_ImageGroup_001': {
        '6003xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '6003xx11': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_Ultrasound_MovieGroup_001': {
        '7fe1xx01': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx02': ('LO', '1', 'Unknown', ''),  # noqa
        '7fe1xx03': ('UL', '1', 'Unknown', ''),  # noqa
        '7fe1xx08': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx12': ('LO', '1', 'Unknown', ''),  # noqa
        '7fe1xx18': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx20': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx24': ('SH', '1', 'Unknown', ''),  # noqa
        '7fe1xx26': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx36': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx37': ('UL', '1', 'Unknown', ''),  # noqa
        '7fe1xx43': ('OB', '1', 'Unknown', ''),  # noqa
        '7fe1xx48': ('FD', '1-2', 'Unknown', ''),  # noqa
        '7fe1xx49': ('UL', '1', 'Unknown', ''),  # noqa
        '7fe1xx51': ('FL', '1', 'Unknown', ''),  # noqa
        '7fe1xx52': ('FD', '1', 'Unknown', ''),  # noqa
        '7fe1xx53': ('UL', '1', 'Unknown', ''),  # noqa
        '7fe1xx54': ('SL', '1', 'Unknown', ''),  # noqa
        '7fe1xx55': ('OB', '1', 'Unknown', ''),  # noqa
        '7fe1xx57': ('LT', '1', 'Unknown', ''),  # noqa
        '7fe1xx60': ('OB', '1', 'Unknown', ''),  # noqa
        '7fe1xx61': ('OW', '1', 'Unknown', ''),  # noqa
        '7fe1xx70': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx71': ('UL', '1', 'Unknown', ''),  # noqa
        '7fe1xx72': ('LO', '1', 'Unknown', ''),  # noqa
        '7fe1xx73': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx74': ('LO', '1', 'Unknown', ''),  # noqa
        '7fe1xx75': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx77': ('FD', '1-n', 'Unknown', ''),  # noqa
        '7fe1xx79': ('SL', '1', 'Unknown', ''),  # noqa
        '7fe1xx83': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx84': ('LO', '1', 'Unknown', ''),  # noqa
        '7fe1xx85': ('SQ', '1', 'Unknown', ''),  # noqa
        '7fe1xx86': ('SL', '4', 'Unknown', ''),  # noqa
        '7fe1xx87': ('FD', '4', 'Unknown', ''),  # noqa
        '7fe1xx88': ('FD', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_VXTLSTATE_001': {
        '0057xx05': ('SQ', '1', 'Volumes_info', ''),  # noqa
        '0057xx06': ('SQ', '1', 'Image_UIDs', ''),  # noqa
        '0057xx07': ('DT', '1', 'SUV_ScanTime', ''),  # noqa
        '0057xx08': ('DT', '1', 'SUV_AdministredTime', ''),  # noqa
        '0057xx09': ('DT', '1', 'SUV_MeasuredTime', ''),  # noqa
        '0057xx10': ('DT', '1', 'SUV_PostInjectedTime', ''),  # noqa
        '0057xx11': ('FL', '1', 'SUV_TracerActivity', ''),  # noqa
        '0057xx12': ('FL', '1', 'SUV_PostInjectedActivity', ''),  # noqa
        '0057xx13': ('FL', '1', 'SUV_HalfLife', ''),  # noqa
        '0057xx14': ('LO', '1', 'SState_Version', ''),  # noqa
        '0057xx15': ('SQ', '1', 'SegList_Seq', ''),  # noqa
        '0057xx16': ('IS', '1', 'SegList_Count', ''),  # noqa
        '0057xx17': ('OB', '1', 'SegList_List', ''),  # noqa
        '0057xx18': ('LO', '1', 'SegList_Name', ''),  # noqa
        '0057xx19': ('LO', '1', 'Volume_Filename', ''),  # noqa
        '0057xx20': ('LO', '1', 'SegList_Label', ''),  # noqa
        '0057xx21': ('SQ', '1', 'Bookmark_Seq', ''),  # noqa
        '0057xx22': ('LT', '1', 'Bookmark', ''),  # noqa
        '0057xx23': ('FL', '3', 'Cursor_position', ''),  # noqa
        '0057xx24': ('UL', '3-n', 'Color_Value_Field', ''),  # noqa
        '0057xx25': ('IS', '1', 'Count', ''),  # noqa
        '0057xx26': ('SQ', '1', 'Views_info', ''),  # noqa
        '0057xx27': ('LT', '1', 'View_Slot', ''),  # noqa
        '0057xx28': ('IS', '1', 'Wireframe_Size', ''),  # noqa
        '0057xx29': ('UT', '1', 'Wireframe', ''),  # noqa
        '0057xx30': ('IS', '1', 'Annotation_Size', ''),  # noqa
        '0057xx31': ('LT', '1', 'Annotation', ''),  # noqa
        '0057xx32': ('IS', '1', 'Slider_State', ''),  # noqa
        '0057xx33': ('LO', '1', 'Proto_Name', ''),  # noqa
        '0057xx34': ('LO', '1', 'Proto_Title', ''),  # noqa
        '0057xx35': ('LO', '1', 'Proto_FilmName', ''),  # noqa
        '0057xx36': ('LO', '1', 'Proto_Step', ''),  # noqa
        '0057xx38': ('LT', '1', 'SegList_Slots', ''),  # noqa
        '0057xx39': ('IS', '1', 'VT_Points_Size', ''),  # noqa
        '0057xx40': ('LT', '1', 'VT_Points', ''),  # noqa
        '0057xx41': ('IS', '1', 'VT_Meas_Size', ''),  # noqa
        '0057xx42': ('LT', '1', 'VT_Meas', ''),  # noqa
        '0057xx43': ('IS', '1', 'VT_Tree_Size', ''),  # noqa
        '0057xx44': ('UT', '1', 'VT_Tree', ''),  # noqa
        '0057xx46': ('IS', '1', 'VT_Preset_Size', ''),  # noqa
        '0057xx47': ('LT', '1', 'VT_Preset', ''),  # noqa
        '0057xx48': ('IS', '1', 'VT_State_Size', ''),  # noqa
        '0057xx49': ('LT', '1', 'VT_State', ''),  # noqa
        '0057xx50': ('IS', '1', 'Preferences_Size', ''),  # noqa
        '0057xx51': ('LT', '1', 'Preferences', ''),  # noqa
        '0057xx52': ('IS', '1', 'Volume_ZComb_Filter', ''),  # noqa
        '0057xx53': ('IS', '1', 'HTML_Page_Size', ''),  # noqa
        '0057xx54': ('LT', '1', 'HTML_Page', ''),  # noqa
        '0057xx55': ('FL', '3', 'Camera_Position', ''),  # noqa
        '0057xx56': ('IS', '1', 'Slider_Size', ''),  # noqa
        '0057xx57': ('LT', '1', 'Slider', ''),  # noqa
        '0057xx58': ('LO', '1', 'SegList_Pretty_Name', ''),  # noqa
    },
    'GEMS_VXTL_USERDATA_01': {
        '0047xx11': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'GEMS_XELPRV_01': {
        '0033xx08': ('CS', '1', 'Object Type', ''),  # noqa
        '0033xx10': ('SL', '1', 'Modified', ''),  # noqa
        '0033xx11': ('LO', '1', 'Name', ''),  # noqa
        '0033xx14': ('LO', '1', 'StudyId', ''),  # noqa
        '0033xx16': ('LO', '1', 'ProtocolDataUID', ''),  # noqa
        '0033xx17': ('SH', '1', 'Date', ''),  # noqa
        '0033xx18': ('SH', '1', 'Time', ''),  # noqa
        '0033xx19': ('UL', '1', 'ProtocoldataFlags', ''),  # noqa
        '0033xx1a': ('LO', '1', 'ProtocolName', ''),  # noqa
        '0033xx1b': ('LO', '1', 'StudyId', ''),  # noqa
        '0033xx1c': ('OB', '1', 'BulkData', ''),  # noqa
        '0033xx1d': ('SL', '1-n', 'IntData', ''),  # noqa
        '0033xx1e': ('FD', '1-n', 'DoubleData', ''),  # noqa
        '0033xx1f': ('OB', '1', 'StringData', ''),  # noqa
        '0033xx20': ('OB', '1', 'BulkDataFormat', ''),  # noqa
        '0033xx21': ('OB', '1', 'IntDataFormat', ''),  # noqa
        '0033xx22': ('OB', '1', 'DoubleDataFormat', ''),  # noqa
        '0033xx23': ('OB', '1', 'StringDataFormat', ''),  # noqa
        '0033xx24': ('LT', '1', 'Description', ''),  # noqa
        '0033xx28': ('LO', '1', 'RTName', ''),  # noqa
        '0033xx29': ('LT', '1', 'RTSpecification', ''),  # noqa
        '0033xx2a': ('UL', '1', 'ReviewTemplatesFlags', ''),  # noqa
        '0033xx2b': ('LT', '1', 'DataValidationSpec', ''),  # noqa
        '0033xx2c': ('LT', '1', 'Description', ''),  # noqa
        '0033xx2d': ('LT', '1', 'IconDescription', ''),  # noqa
        '0033xx50': ('SQ', '1', 'ProtocoldataSQ', ''),  # noqa
        '0033xx51': ('UI', '1', 'PDOSOPClassUID', ''),  # noqa
        '0033xx52': ('UI', '1', 'PDOSOPInstanceUID', ''),  # noqa
        '0033xx60': ('SQ', '1', 'ReviewtemplateSQ', ''),  # noqa
        '0033xx61': ('UI', '1', 'RTOSOPClassUID', ''),  # noqa
        '0033xx62': ('UI', '1', 'RTOSOPInstanceUID', ''),  # noqa
        '0033xx70': ('SQ', '1', 'SeriesdataSQ', ''),  # noqa
        '0033xx71': ('UI', '1', 'SDOSOPClassUID', ''),  # noqa
        '0033xx72': ('UI', '1', 'SDOSOPInstanceUID', ''),  # noqa
        '0033xx73': ('SQ', '1', 'SDODoubleDataSQ', ''),  # noqa
        '0057xx01': ('SQ', '1', 'ROISQ', ''),  # noqa
        '0057xx02': ('UI', '1', 'SOPClassUID', ''),  # noqa
        '0057xx03': ('UI', '1', 'SOPInstanceUID', ''),  # noqa
        '0057xx10': ('IS', '1', 'ROINumber', ''),  # noqa
        '0057xx11': ('UI', '1', 'Dimensions', ''),  # noqa
        '0057xx12': ('UI', '1', 'Points', ''),  # noqa
        '0057xx13': ('UI', '1', 'Type', ''),  # noqa
        '0057xx14': ('UI', '1', 'Description', ''),  # noqa
        '0057xx15': ('UI', '1', 'Data value Representation', ''),  # noqa
        '0057xx16': ('UI', '1', 'Label', ''),  # noqa
        '0057xx17': ('UI', '1', 'Data', ''),  # noqa
        '0057xx41': ('SL', '1', 'Modified', ''),  # noqa
        '0057xx42': ('LO', '1', 'Name', ''),  # noqa
        '0057xx43': ('SL', '1', 'Rid', ''),  # noqa
        '0057xx45': ('LO', '1', 'SOPClassUID', ''),  # noqa
        '0057xx46': ('LO', '1', 'SOPInstanceUID', ''),  # noqa
        '0057xx47': ('LO', '1', 'Normal Colour', ''),  # noqa
        '0057xx48': ('LT', '1', 'NameFont', ''),  # noqa
        '0057xx49': ('SL', '1', 'FillPattern', ''),  # noqa
        '0057xx4a': ('SL', '1', 'LineStyle', ''),  # noqa
        '0057xx4b': ('SL', '1', 'LineDashLength', ''),  # noqa
        '0057xx4c': ('SL', '1', 'LineThickness', ''),  # noqa
        '0057xx4d': ('SL', '1', 'Interactivity', ''),  # noqa
        '0057xx4e': ('SL', '1', 'NamePos', ''),  # noqa
        '0057xx4f': ('SL', '1', 'NameDisplay', ''),  # noqa
        '0057xx50': ('LO', '1', 'Label', ''),  # noqa
        '0057xx51': ('SL', '1-n', 'BpSeg', ''),  # noqa
        '0057xx52': ('US', '1-n', 'BpSegpairs', ''),  # noqa
        '0057xx53': ('SL', '1', 'SeedSpace', ''),  # noqa
        '0057xx54': ('FD', '1-n', 'Seeds', ''),  # noqa
        '0057xx55': ('SL', '1-n', 'Shape', ''),  # noqa
        '0057xx56': ('FD', '1-n', 'ShapeTilt', ''),  # noqa
        '0057xx59': ('SL', '1-n', 'ShapePtsSpace', ''),  # noqa
        '0057xx5a': ('SL', '1-n', 'ShapeCtrlPtsCount', ''),  # noqa
        '0057xx5b': ('FD', '1-n', 'Shap CtrlPts', ''),  # noqa
        '0057xx5c': ('SL', '1', 'ShapeCPSpace', ''),  # noqa
        '0057xx5d': ('UL', '1-n', 'ROIFlags', ''),  # noqa
        '0057xx5e': ('UL', '1', 'FrameNumber', ''),  # noqa
        '0057xx60': ('LO', '1-n', 'DatasetROIMapping', ''),  # noqa
    },
    'GEMS_XR3DCAL_01': {
        '0021xx01': ('IS', '1', '3Dcal image rows', ''),  # noqa
        '0021xx02': ('IS', '1', '3Dcal image columns', ''),  # noqa
        '0021xx03': ('FL', '1', '3Dcal field of view', ''),  # noqa
        '0021xx04': ('DA', '1', '3Dcal acquisition date', ''),  # noqa
        '0021xx05': ('TM', '1', '3Dcal acquisition time', ''),  # noqa
        '0021xx06': ('DA', '1', '3Dcal calibration processing date', ''),  # noqa
        '0021xx07': ('TM', '1', '3Dcal calibration processing time', ''),  # noqa
        '0021xx08': ('FL', '1', '3Dcal L arm angle', ''),  # noqa
        '0021xx09': ('FL', '1-n', '3Dcal Pivot angle vector', ''),  # noqa
        '0021xx0a': ('FL', '1', '3Dcal C arm angle', ''),  # noqa
        '0021xx0b': ('SQ', '1', '3Dcal matrix sequence', ''),  # noqa
        '0021xx0c': ('LO', '1-n', '3Dcal matrix elements', ''),  # noqa
        '0021xx0d': ('LO', '1', '3Dcal algorithm version', ''),  # noqa
        '0021xx0e': ('FL', '1', '3Dcal 3D frame unit size', ''),  # noqa
        '0021xx0f': ('LO', '1', '3Dcal calibration mode', ''),  # noqa
        '0021xx10': ('FL', '1', '3Dcal image frame origin row', ''),  # noqa
        '0021xx11': ('FL', '1', '3Dcal image frame origin column', ''),  # noqa
        '0021xx12': ('IS', '1', '3Dcal positioner pivot rotation speed', ''),  # noqa
        '0021xx13': ('IS', '1', '3Dcal number of images', ''),  # noqa
        '0021xx14': ('UI', '1', '3Dcal Instance UID', ''),  # noqa
        '0021xx15': ('FL', '2', '3Dcal image pixel spacing', ''),  # noqa
        '0021xx16': ('CS', '1', '3Dcal centering mode', ''),  # noqa
    },
    'GEMS_YMHD_01': {
        '0033xx05': ('UN', '1', 'Unknown', ''),  # noqa
        '0033xx06': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'GE_GENESIS_REV3.0': {
        '0019xx39': ('SS', '1', 'Axial Type', ''),  # noqa
        '0019xx8f': ('SS', '1', 'Swap Phase / Frequency Axis', ''),  # noqa
        '0019xx9c': ('SS', '1', 'Pulse Sequence Name', ''),  # noqa
        '0019xx9f': ('SS', '1', 'Coil Type', ''),  # noqa
        '0019xxa4': ('SS', '1', 'SAT fat/water/none', ''),  # noqa
        '0019xxc0': ('SS', '1', 'Bitmap of SAT Selections', ''),  # noqa
        '0019xxc1': ('SS', '1', 'Surfacel Coil Iintensity Correction Flag', ''),  # noqa
        '0019xxcb': ('SS', '1', 'Phase Contrast Flow Axis', ''),  # noqa
        '0019xxcc': ('SS', '1', 'Phase Contrast Velocity Encoding', ''),  # noqa
        '0019xxd5': ('SS', '1', 'Fractional Echo', ''),  # noqa
        '0019xxd8': ('SS', '1', 'Variable Echo Flag', ''),  # noqa
        '0019xxd9': ('DS', '1', 'Concatenated Sat', ''),  # noqa
        '0019xxf2': ('SS', '1', 'Number of Phases', ''),  # noqa
        '0043xx1e': ('DS', '1', 'Delta Start Time', ''),  # noqa
        '0043xx27': ('SH', '1', 'Pitch Ratio', ''),  # noqa
    },
    'GE_GROUP': {
        '6005xx10': ('UT', '1', 'Unknown', ''),  # noqa
    },
    'HMC - CT - ID': {
        '0009xx00': ('UN', '1', 'Image ID Information (e.g. Patient Name, Patient ID)', ''),  # noqa
        '0009xx01': ('UN', '1', 'Image ID Information (e.g. Patient Comment)', ''),  # noqa
    },
    'HOLOGIC': {
        '0011xx00': ('LO', '1', 'Hx Questionnaire', ''),  # noqa
        '0021xx01': ('LT', '1', 'Image Analysis Data in XML', ''),  # noqa
        '0023xx00': ('LO', '1', 'Encoding Scheme Version', ''),  # noqa
        '0023xx01': ('LO', '1', 'P File Name', ''),  # noqa
        '0023xx02': ('OB', '1', 'P File Data', ''),  # noqa
        '0023xx03': ('UL', '1', 'P File Length', ''),  # noqa
        '0023xx04': ('OB', '1', 'R File Data', ''),  # noqa
        '0023xx05': ('UL', '1', 'R File Length', ''),  # noqa
    },
    'HOLOGIC, Inc.': {
        '0019xx06': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx07': ('SH', '1', 'Unknown', ''),  # noqa
        '0019xx08': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx16': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx26': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx27': ('SH', '1', 'Unknown', ''),  # noqa
        '0019xx28': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx29': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx30': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx31': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx32': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx33': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx34': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx35': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx37': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx41': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx42': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx43': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx44': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx45': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx46': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx70': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx85': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx90': ('DS', '1', 'Unknown', ''),  # noqa
        '7e01xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '7e01xx02': ('LO', '1', 'Unknown', ''),  # noqa
        '7e01xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '7e01xx11': ('SQ', '1', 'Unknown', ''),  # noqa
        '7e01xx12': ('OB', '1', 'Unknown', ''),  # noqa
        '7f01xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '7f01xx02': ('SH', '1', 'Unknown', ''),  # noqa
        '7f01xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '7f01xx12': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'Hologic': {
        '0011xx00': ('LO', '1', 'Hx Questionnaire', ''),  # noqa
        '0021xx01': ('LT', '1', 'Image Analysis Data in XML', ''),  # noqa
        '0023xx00': ('LO', '1', 'Encoding Scheme Version', ''),  # noqa
        '0023xx01': ('LO', '1', 'P File Name', ''),  # noqa
        '0023xx02': ('OB', '1', 'P File Data', ''),  # noqa
        '0023xx03': ('UL', '1', 'P File Length', ''),  # noqa
        '0023xx04': ('OB', '1', 'R File Data', ''),  # noqa
        '0023xx05': ('UL', '1', 'R File Length', ''),  # noqa
    },
    'IDEXX': {
        '0011xx00': ('LO', '1', 'Breed Name', ''),  # noqa
        '0011xx01': ('LO', '1', 'Species Name', ''),  # noqa
        '0011xx02': ('PN', '1', 'Owner', ''),  # noqa
    },
    'IMPAC': {
        '300bxx02': ('FL', '1', 'Unknown', ''),  # noqa
        '300bxx04': ('FL', '1', 'Unknown', ''),  # noqa
        '300bxx0e': ('FL', '1', 'Unknown', ''),  # noqa
    },
    'IMS s.r.l. Biopsy Private Code': {
        '1269xx01': ('IS', '1', 'Biopsy Image', ''),  # noqa
        '1269xx10': ('IS', '1-n', 'Biopsy Markers X', ''),  # noqa
        '1269xx11': ('IS', '1-n', 'Biopsy Markers Y', ''),  # noqa
        '1269xx12': ('IS', '1', 'Biopsy Markers Number', ''),  # noqa
        '1269xx20': ('IS', '1', 'Biopsy Area Left Border', ''),  # noqa
        '1269xx21': ('IS', '1', 'Biopsy Area Right Border', ''),  # noqa
        '1269xx22': ('IS', '1', 'Biopsy Area Top Border', ''),  # noqa
        '1269xx23': ('IS', '1', 'Biopsy Area Bottom Border', ''),  # noqa
    },
    'IMS s.r.l. Mammography Private Code': {
        '1271xx01': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx02': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx10': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx11': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx12': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx13': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx20': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx21': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx22': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx38': ('LO', '1', 'Unknown', ''),  # noqa
        '1271xx39': ('US', '1', 'Unknown', ''),  # noqa
        '1271xx40': ('US', '1', 'Unknown', ''),  # noqa
        '1271xx41': ('LO', '1', 'Unknown', ''),  # noqa
        '1271xx42': ('LT', '1', 'Unknown', ''),  # noqa
        '1271xx45': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx46': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx47': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx48': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx49': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx50': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx51': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx52': ('IS', '1', 'Unknown', ''),  # noqa
        '1271xx53': ('LO', '1', 'Unknown', ''),  # noqa
        '1271xx54': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'INFINITT_FMX': {
        '0015xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0015xx11': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'INTEGRIS 1.0': {
        '0009xx08': ('CS', '1', 'Exposure Channel', ''),  # noqa
        '0009xx32': ('TM', '1', 'Exposure Start Time', ''),  # noqa
        '0019xx00': ('LO', '1', 'APR Name', ''),  # noqa
        '0019xx40': ('DS', '1', 'Frame Rate', ''),  # noqa
        '0021xx12': ('IS', '1', 'Exposure Number', ''),  # noqa
        '0029xx00': ('SQ', '1', 'Edge Enhancement Sequence', ''),  # noqa
        '0029xx01': ('US', '2', 'Convolution Kernel Size', ''),  # noqa
        '0029xx02': ('US', '1-n', 'Convolution Kernel Coefficients', ''),  # noqa
        '0029xx03': ('FL', '1', 'Edge Enhancement Gain', ''),  # noqa
        '0029xx08': ('IS', '1', 'Number of Exposure Results', ''),  # noqa
        '0041xx20': ('DS', '1', 'Accumulated Fluoroscopy Dose', ''),  # noqa
        '0041xx30': ('DS', '1', 'Accumulated Exposure Dose', ''),  # noqa
        '0041xx40': ('DS', '1', 'Total Dose', ''),  # noqa
        '0041xx41': ('US', '1', 'Total Number of Frames', ''),  # noqa
        '0041xx50': ('SQ', '1', 'Exposure Information Sequence', ''),  # noqa
    },
    'INTELERAD MEDICAL SYSTEMS': {
        '3f01xx01': ('LO', '1', 'Institution Code', ''),  # noqa
        '3f01xx02': ('LO', '1', 'Routed Transfer AE', ''),  # noqa
        '3f01xx03': ('LO', '1', 'Source AE', ''),  # noqa
        '3f01xx04': ('LO', '1', 'Deferred Validation', ''),  # noqa
        '3f01xx05': ('LO', '1', 'Series Owner', ''),  # noqa
    },
    'ISG Image': {
        '0065xx11': ('UL', '1', 'Unknown', ''),  # noqa
    },
    'ISG shadow': {
        '0029xx70': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx80': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx90': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'ISI': {
        '0009xx01': ('SQ', '1', 'SIENET General Purpose IMGF', ''),  # noqa
    },
    'Image (ID, Version, Size, Dump, GUID)': {
        '8003xx00': ('LO', '1', 'ID', ''),  # noqa
        '8003xx10': ('LO', '1', 'Version', ''),  # noqa
        '8003xx20': ('UL', '1', 'Size', ''),  # noqa
        '8003xx30': ('OB', '1', 'Dump', ''),  # noqa
        '8003xx40': ('LO', '1', 'GUID', ''),  # noqa
    },
    'Imaging Dynamics Company Ltd.': {
        '4321xx05': ('UN', '1', 'Custom Tag', ''),  # noqa
        '4321xx10': ('UN', '1', 'Custom Tag', ''),  # noqa
        '4321xx41': ('CS', '1', 'Unknown', ''),  # noqa
        '4321xx42': ('US', '1', 'Unknown', ''),  # noqa
        '4321xx50': ('DS', '1', 'Custom Tag', ''),  # noqa
        '4321xx51': ('DS', '1', 'Custom Tag', ''),  # noqa
        '4321xx64': ('LO', '1', 'Custom Tag', ''),  # noqa
    },
    'KINETDX': {
        '0021xxa5': ('US', '1', 'Unknown', ''),  # noqa
        '0021xxa8': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xxaa': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'KINETDX_GRAPHICS': {
        '0021xxa4': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'KRETZ_US': {
        '7fe1xx01': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'Kodak Image Information': {
        '0029xx15': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx16': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx17': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx18': ('UT', '1', 'Unknown', ''),  # noqa
        '0029xx19': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx1a': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'LODOX_STATSCAN': {
        '0019xx01': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0019xx02': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx03': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx04': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx05': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx06': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx07': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx08': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'LORAD Selenia': {
        '0019xx06': ('OB', '1', 'Paddle ID', ''),  # noqa
        '0019xx07': ('OB', '1', 'Paddle Position', ''),  # noqa
        '0019xx08': ('OB', '1', 'Collimation Size', ''),  # noqa
        '0019xx26': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx27': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx28': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx29': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx30': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx31': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx32': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx33': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx34': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx35': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx41': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx50': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx51': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx52': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx53': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx70': ('OB', '1', 'Unknown', ''),  # noqa
        '0019xx71': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'MAROTECH Inc.': {
        '0037xx01': ('LO', '1', 'Some kind of version number', ''),  # noqa
        '0037xx21': ('US', '1', 'Icon Row', ''),  # noqa
        '0037xx22': ('US', '1', 'Icon Col', ''),  # noqa
        '0037xx23': ('OB', '1', 'JPEG Compressed Icon', ''),  # noqa
    },
    'MDS NORDION OTP ANATOMY MODELLING': {
        '3005xx00': ('SQ', '1', 'Unknown', ''),  # noqa
        '3005xx02': ('CS', '1', 'Unknown', ''),  # noqa
        '3005xx04': ('DS', '1', 'Unknown', ''),  # noqa
        '3005xx06': ('DS', '1', 'Unknown', ''),  # noqa
        '3005xx08': ('DS', '1', 'Unknown', ''),  # noqa
        '3005xx0a': ('CS', '1', 'Unknown', ''),  # noqa
        '3005xx0c': ('CS', '1', 'Unknown', ''),  # noqa
        '3005xx0e': ('CS', '1', 'Unknown', ''),  # noqa
        '3005xx10': ('DS', '1', 'Unknown', ''),  # noqa
        '3005xx12': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'MEDIFACE': {
        '0021xx01': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx10': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx11': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx12': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx21': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx22': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx30': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx31': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx40': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx41': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx42': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx50': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx51': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx52': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx60': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xxf1': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xxf2': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('DS', '1', 'Window Center', ''),  # noqa
        '0029xx11': ('DS', '1', 'Window Width', ''),  # noqa
        '0029xx20': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx22': ('DS', '2', 'Unknown', ''),  # noqa
        '0029xx30': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'MERGE TECHNOLOGIES, INC.': {
        '0009xx00': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'MITRA LINKED ATTRIBUTES 1.0': {
        '0031xx20': ('LO', '1', 'Global Patient ID', ''),  # noqa
    },
    'MITRA OBJECT ATTRIBUTES 1.0': {
        '0033xx02': ('LO', '1', 'Unknown', ''),  # noqa
        '0033xx04': ('LO', '1', 'Unknown', ''),  # noqa
        '0033xx06': ('LO', '1', 'Unknown', ''),  # noqa
        '0033xx08': ('LO', '1', 'Unknown', ''),  # noqa
        '0033xx0a': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'MITRA OBJECT DOCUMENT 1.0': {
        '0029xx00': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'MITRA OBJECT UTF8 ATTRIBUTES 1.0': {
        '0033xx02': ('PN', '1', "Patient's Name", ''),  # noqa
        '0033xx04': ('CS', '1', 'Study Description', ''),  # noqa
        '0033xx06': ('PN', '1', "Referring Physician's Name", ''),  # noqa
        '0033xx08': ('PN', '1', "Requesting Physician's Name", ''),  # noqa
        '0033xx0a': ('PN', '1', "Performing Physician's Name", ''),  # noqa
        '0033xx0c': ('LO', '1', 'Reason for Study', ''),  # noqa
        '0033xx0e': ('LT', '1', 'Study Comments', ''),  # noqa
        '0033xx13': ('PN', '1', "Patient's Name Single Byte", ''),  # noqa
        '0033xx14': ('PN', '1', "Patient's Name Ideographic", ''),  # noqa
        '0033xx15': ('PN', '1', "Patient's Name Phonetic", ''),  # noqa
        '0033xx16': ('PN', '1', "Referring Physician's Name Single Byte", ''),  # noqa
        '0033xx17': ('PN', '1', "Referring Physician's Name Ideographic", ''),  # noqa
        '0033xx18': ('PN', '1', "Referring Physician's Name Phonetic", ''),  # noqa
        '0033xx19': ('PN', '1', "Requesting Physician's Name Single Byte", ''),  # noqa
        '0033xx1a': ('PN', '1', "Requesting Physician's Name Ideographic", ''),  # noqa
        '0033xx1b': ('PN', '1', "Requesting Physician's Name Phonetic", ''),  # noqa
        '0033xx1c': ('PN', '1', "Performing Physician's Name Single Byte", ''),  # noqa
        '0033xx1d': ('PN', '1', "Performing Physician's Name Ideographic", ''),  # noqa
        '0033xx1e': ('PN', '1', "Performing Physician's Name Phonetic", ''),  # noqa
    },
    'MITRA PRESENTATION 1.0': {
        '0029xx00': ('CS', '1', 'Mitra Rotation', ''),  # noqa
        '0029xx01': ('LO', '1', 'Mitra Window Width', ''),  # noqa
        '0029xx02': ('LO', '1', 'Mitra Window Centre', ''),  # noqa
        '0029xx03': ('IS', '1', 'Mitra Invert', ''),  # noqa
        '0029xx04': ('IS', '1', 'Mitra Has Tabstop', ''),  # noqa
        '0029xx05': ('CS', '1', 'Smooth Rotation', ''),  # noqa
        '0029xx10': ('CS', '1', 'Breast Box x0', ''),  # noqa
        '0029xx11': ('CS', '1', 'Breast Box y0', ''),  # noqa
        '0029xx12': ('CS', '1', 'Breast Box x1', ''),  # noqa
        '0029xx13': ('CS', '1', 'Breast Box y1', ''),  # noqa
    },
    'MMCPrivate': {
        '0009xx48': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx4e': ('LO', '1', 'Unknown', ''),  # noqa
        '0011xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx02': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx03': ('SH', '1', 'Unknown', ''),  # noqa
        '0019xx04': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx05': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx08': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx09': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx0a': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx0b': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx0c': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx0f': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx02': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx05': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx06': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx08': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx09': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx0a': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx0b': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx0c': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx0d': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx0e': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx0f': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx11': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx12': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx13': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx14': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx15': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx16': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx17': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx18': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx1c': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx20': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx22': ('ST', '1', 'Unknown', ''),  # noqa
        '0029xx23': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx24': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx25': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx26': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx27': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx28': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx29': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx2a': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx2b': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx2c': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx2d': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx2e': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx2f': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'Mayo/IBM Archive Project': {
        '0021xx01': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx10': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx11': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx12': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx13': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx14': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx15': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx16': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx17': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx18': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx19': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx1a': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx1b': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx1c': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx1d': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx1e': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx1f': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx20': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx40': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx41': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx50': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx60': ('UN', '1', 'Unknown', ''),  # noqa
        '0021xx65': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'MeVis BreastCare': {
        '0019xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '0071xx01': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'MeVis eD: Geometry Information': {
        '0009xx11': ('UN', '1', 'GeoScannerOrigin', ''),  # noqa
        '0009xx21': ('UN', '1', 'SlicesID', ''),  # noqa
    },
    'MeVis eD: Slice Information': {
        '0009xx10': ('UN', '1', 'SlicesSOPInstanceUID', ''),  # noqa
    },
    'MeVis eD: Timepoint Information': {
        '0009xx10': ('UN', '1', 'TPDateTime', ''),  # noqa
        '0009xx11': ('UN', '1', 'TPDateTimeType', ''),  # noqa
        '0009xx12': ('UN', '1', 'TPSeriesDescription', ''),  # noqa
        '0009xx13': ('UN', '1', 'TPGradientDirections', ''),  # noqa
        '0009xx21': ('UN', '1', 'GeometryID', ''),  # noqa
    },
    'MeVis eatDicom': {
        '0009xx10': ('UN', '1', 'EatDicomVersion', ''),  # noqa
        '0009xx11': ('UN', '1', 'EatDicomOptions', ''),  # noqa
        '0009xx21': ('UN', '1', 'TimepointsID', ''),  # noqa
    },
    'MedIns HP Extensions': {
        '5473xx03': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Mitra Markup 1.0': {
        '0029xx00': ('OB', '1-n', 'Markup1', ''),  # noqa
        '0029xx01': ('OB', '1-n', 'Markup2', ''),  # noqa
        '0029xx02': ('OB', '1-n', 'Markup3', ''),  # noqa
        '0029xx03': ('OB', '1-n', 'Markup4', ''),  # noqa
        '0029xx04': ('OB', '1-n', 'Markup5', ''),  # noqa
        '0029xx05': ('OB', '1-n', 'Markup6', ''),  # noqa
        '0029xx06': ('OB', '1-n', 'Markup7', ''),  # noqa
        '0029xx07': ('OB', '1-n', 'Markup8', ''),  # noqa
        '0029xx08': ('OB', '1-n', 'Markup9', ''),  # noqa
        '0029xx09': ('OB', '1-n', 'Markup10', ''),  # noqa
        '0029xx10': ('OB', '1-n', 'Markup11', ''),  # noqa
        '0029xx11': ('OB', '1-n', 'Markup12', ''),  # noqa
        '0029xx12': ('OB', '1', 'Markup13', ''),  # noqa
        '0029xx13': ('OB', '1', 'Markup14', ''),  # noqa
        '0029xx14': ('OB', '1', 'Markup15', ''),  # noqa
    },
    'Mitra Object Document 1.0': {
        '0029xx00': ('OB', '1', 'IMPAX object document', ''),  # noqa
        '0029xx10': ('OB', '1', 'IMPAX markup XML stored', ''),  # noqa
    },
    'Mitra Presentation 1.0': {
        '0029xx00': ('CS', '1', 'Mitra Rotation', ''),  # noqa
        '0029xx01': ('LO', '1', 'Mitra Window Width', ''),  # noqa
        '0029xx02': ('LO', '1', 'Mitra Window Centre', ''),  # noqa
        '0029xx03': ('IS', '1', 'Mitra Invert', ''),  # noqa
        '0029xx04': ('IS', '1', 'Mitra Has Tabstop', ''),  # noqa
        '0029xx05': ('CS', '1', 'Smooth Rotation', ''),  # noqa
    },
    'Mortara_Inc': {
        '1455xx00': ('OW', '1', 'ELI Interpretation Vector', ''),  # noqa
        '1455xx01': ('UN', '1', 'Custom ID', ''),  # noqa
        '1455xx02': ('UT', '1', 'Race', ''),  # noqa
        '1455xx03': ('UT', '1', 'Social Security Number', ''),  # noqa
        '1455xx04': ('UT', '1', 'Attending Physician', ''),  # noqa
        '1455xx05': ('UT', '1', 'Procedural Diagnosis', ''),  # noqa
        '1455xx06': ('UT', '1', 'Note1', ''),  # noqa
        '1455xx07': ('UT', '1', 'Note2', ''),  # noqa
        '1455xx08': ('LO', '1', 'Order Request Number', ''),  # noqa
        '1455xx10': ('LO', '1', 'Manufacturer Name', ''),  # noqa
    },
    'NUD_PRIVATE': {
        '7777xx02': ('UT', '1', 'Interfile', ''),  # noqa
        '7777xx05': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'ObjectModel (ID, Version, Place, PlaceDescription)': {
        '8101xx00': ('LO', '1', 'ID', ''),  # noqa
        '8101xx10': ('LO', '1', 'Version', ''),  # noqa
    },
    'PAPYRUS': {
        '0009xx00': ('LT', '1', 'Original File Name', ''),  # noqa
        '0009xx10': ('LT', '1', 'Original File Location', ''),  # noqa
        '0009xx18': ('LT', '1', 'Data Set Identifier', ''),  # noqa
        '0041xx00': ('LT', '1-n', 'Papyrus Comments', ''),  # noqa
        '0041xx10': ('US', '1', 'Folder Type', ''),  # noqa
        '0041xx11': ('LT', '1', 'Patient Folder Data Set ID', ''),  # noqa
        '0041xx20': ('LT', '1', 'Folder Name', ''),  # noqa
        '0041xx30': ('DA', '1', 'Creation Date', ''),  # noqa
        '0041xx32': ('TM', '1', 'Creation Time', ''),  # noqa
        '0041xx34': ('DA', '1', 'Modified Date', ''),  # noqa
        '0041xx36': ('TM', '1', 'Modified Time', ''),  # noqa
        '0041xx40': ('LT', '1-n', 'Owner Name', ''),  # noqa
        '0041xx50': ('LT', '1', 'Folder Status', ''),  # noqa
        '0041xx60': ('UL', '1', 'Number of Images', ''),  # noqa
        '0041xx62': ('UL', '1', 'Number of Other', ''),  # noqa
        '0041xxa0': ('LT', '1-n', 'External Folder Element DSID', ''),  # noqa
        '0041xxa1': ('US', '1-n', 'External Folder Element Data Set Type', ''),  # noqa
        '0041xxa2': ('LT', '1-n', 'External Folder Element File Location', ''),  # noqa
        '0041xxa3': ('UL', '1-n', 'External Folder Element Length', ''),  # noqa
        '0041xxb0': ('LT', '1-n', 'Internal Folder Element DSID', ''),  # noqa
        '0041xxb1': ('US', '1-n', 'Internal Folder Element Data Set Type', ''),  # noqa
        '0041xxb2': ('UL', '1-n', 'Internal Offset To Data Set', ''),  # noqa
        '0041xxb3': ('UL', '1-n', 'Internal Offset To Image', ''),  # noqa
    },
    'PAPYRUS 3.0': {
        '0041xx00': ('LT', '1', 'Comments', ''),  # noqa
        '0041xx10': ('SQ', '1', 'Pointer Sequence', ''),  # noqa
        '0041xx11': ('UL', '1', 'Image Pointer', ''),  # noqa
        '0041xx12': ('UL', '1', 'Pixel Offset', ''),  # noqa
        '0041xx13': ('SQ', '1', 'Image Identifier Sequence', ''),  # noqa
        '0041xx14': ('SQ', '1', 'External PAPYRUS-File Reference Sequence', ''),  # noqa
        '0041xx15': ('US', '1', 'Number of images', ''),  # noqa
        '0041xx21': ('UI', '1', 'Referenced SOP Class UID', ''),  # noqa
        '0041xx22': ('UI', '1', 'Referenced SOP Instance UID', ''),  # noqa
        '0041xx31': ('LO', '1', 'Referenced File Name', ''),  # noqa
        '0041xx32': ('LO', '1-n', 'Referenced File Path', ''),  # noqa
        '0041xx41': ('UI', '1', 'Referenced Image SOP Class UID', ''),  # noqa
        '0041xx42': ('UI', '1', 'Referenced Image SOP Instance UID', ''),  # noqa
        '0041xx50': ('SQ', '1', 'Image Sequence', ''),  # noqa
        '60xxxx00': ('IS', '1', 'Overlay ID', ''),  # noqa
        '60xxxx01': ('LT', '1-n', 'Linked Overlays', ''),  # noqa
        '60xxxx10': ('US', '1', 'Overlay Rows', ''),  # noqa
        '60xxxx11': ('US', '1', 'Overlay Columns', ''),  # noqa
        '60xxxx40': ('LO', '1', 'Overlay Type', ''),  # noqa
        '60xxxx50': ('US', '1-n', 'Overlay Origin', ''),  # noqa
        '60xxxx60': ('LO', '1', 'Editable', ''),  # noqa
        '60xxxx70': ('LO', '1', 'Overlay Font', ''),  # noqa
        '60xxxx72': ('LO', '1', 'Overlay Style', ''),  # noqa
        '60xxxx74': ('US', '1', 'Overlay Font Size', ''),  # noqa
        '60xxxx76': ('LO', '1', 'Overlay Color', ''),  # noqa
        '60xxxx78': ('US', '1', 'Shadow Size', ''),  # noqa
        '60xxxx80': ('LO', '1', 'Fill Pattern', ''),  # noqa
        '60xxxx82': ('US', '1', 'Overlay Pen Size', ''),  # noqa
        '60xxxxa0': ('LO', '1', 'Label', ''),  # noqa
        '60xxxxa2': ('LT', '1', 'Post It Text', ''),  # noqa
        '60xxxxa4': ('US', '2', 'Anchor Point', ''),  # noqa
        '60xxxxb0': ('LO', '1', 'ROI Type', ''),  # noqa
        '60xxxxb2': ('LT', '1', 'Attached Annotation', ''),  # noqa
        '60xxxxba': ('US', '1-n', 'Contour Points', ''),  # noqa
        '60xxxxbc': ('US', '1-n', 'Mask Data', ''),  # noqa
        '60xxxxc0': ('SQ', '1', 'UIN Overlay Sequence', ''),  # noqa
    },
    'PHILIPS MR': {
        '0009xx10': ('LO', '1', 'SPI Release', ''),  # noqa
        '0009xx12': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'PHILIPS MR R5.5/PART': {
        '0019xx00': ('DS', '2', 'Field of View', ''),  # noqa
    },
    'PHILIPS MR R5.6/PART': {
        '0019xx00': ('DS', '1', 'Field of View', ''),  # noqa
    },
    'PHILIPS MR SPECTRO;1': {
        '0019xx01': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx02': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx03': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx04': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx05': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx06': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx07': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx08': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx09': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx10': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx12': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx13': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx14': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx15': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx16': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx17': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx18': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx20': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx21': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx22': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx23': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx24': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx25': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx26': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx27': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx28': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx29': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0019xx31': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx32': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx41': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx42': ('IS', '2', 'Unknown', ''),  # noqa
        '0019xx43': ('IS', '2', 'Unknown', ''),  # noqa
        '0019xx45': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx46': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx47': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx48': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx49': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx50': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx60': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx61': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx70': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx71': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0019xx72': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx73': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx74': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx76': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx77': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx78': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx79': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx80': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'PHILIPS MR/LAST': {
        '0019xx09': ('DS', '1', 'Main Magnetic Field', ''),  # noqa
        '0019xx0e': ('IS', '1', 'Flow Compensation', ''),  # noqa
        '0019xxb1': ('IS', '1', 'Minimum RR Interval', ''),  # noqa
        '0019xxb2': ('IS', '1', 'Maximum RR Interval', ''),  # noqa
        '0019xxb3': ('IS', '1', 'Number of Rejections', ''),  # noqa
        '0019xxb4': ('IS', '1-n', 'Number of RR Intervals', ''),  # noqa
        '0019xxb5': ('IS', '1', 'Arrhythmia Rejection', ''),  # noqa
        '0019xxb7': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxc0': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xxc6': ('IS', '1', 'Cycled Multiple Slice', ''),  # noqa
        '0019xxce': ('IS', '1', 'REST', ''),  # noqa
        '0019xxd5': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxd6': ('IS', '1', 'Fourier Interpolation', ''),  # noqa
        '0019xxd9': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0019xxe0': ('IS', '1', 'Prepulse', ''),  # noqa
        '0019xxe1': ('DS', '1', 'Prepulse Delay', ''),  # noqa
        '0019xxe2': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxe3': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxe4': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxe5': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxf0': ('LT', '1', 'WS Protocol String 1', ''),  # noqa
        '0019xxf1': ('LT', '1', 'WS Protocol String 2', ''),  # noqa
        '0019xxf2': ('LT', '1', 'WS Protocol String 3', ''),  # noqa
        '0019xxf3': ('LT', '1', 'WS Protocol String 4', ''),  # noqa
        '0021xx00': ('IS', '1', 'Unknown', ''),  # noqa
        '0021xx10': ('IS', '1', 'Unknown', ''),  # noqa
        '0021xx20': ('IS', '1', 'Unknown', ''),  # noqa
        '0021xx21': ('DS', '1', 'Slice Gap', ''),  # noqa
        '0021xx22': ('DS', '1', 'Stack Radial Angle', ''),  # noqa
        '0027xx00': ('US', '1', 'Unknown', ''),  # noqa
        '0027xx11': ('US', '1-n', 'Unknown', ''),  # noqa
        '0027xx12': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0027xx13': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0027xx14': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0027xx15': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0027xx16': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('DS', '1', 'FP Min', ''),  # noqa
        '0029xx20': ('DS', '1', 'FP Max', ''),  # noqa
        '0029xx30': ('DS', '1', 'Scaled Minimum', ''),  # noqa
        '0029xx40': ('DS', '1', 'Scaled Maximum', ''),  # noqa
        '0029xx50': ('DS', '1', 'Window Minimum', ''),  # noqa
        '0029xx60': ('DS', '1', 'Window Maximum', ''),  # noqa
        '0029xx61': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx62': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx70': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx71': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx72': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx80': ('IS', '2', 'View Center', ''),  # noqa
        '0029xx81': ('IS', '2', 'View Size', ''),  # noqa
        '0029xx82': ('IS', '1', 'View Zoom', ''),  # noqa
        '0029xx83': ('IS', '1', 'View Transform', ''),  # noqa
        '0041xx07': ('LO', '1', 'Unknown', ''),  # noqa
        '0041xx09': ('DS', '1', 'Unknown', ''),  # noqa
        '6001xx00': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'PHILIPS MR/PART': {
        '0019xx00': ('DS', '1', 'Field of View', ''),  # noqa
        '0019xx01': ('IS', '1-n', 'Stack Type', ''),  # noqa
        '0019xx02': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0019xx03': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx05': ('DS', '1', 'CC Angulation', ''),  # noqa
        '0019xx06': ('DS', '1', 'AP Angulation', ''),  # noqa
        '0019xx07': ('DS', '1', 'LR Angulation', ''),  # noqa
        '0019xx08': ('IS', '1', 'Patient Orientation 1', ''),  # noqa
        '0019xx09': ('IS', '1', 'Patient Orientation', ''),  # noqa
        '0019xx0a': ('IS', '1', 'Slice Orientation', ''),  # noqa
        '0019xx0b': ('DS', '1', 'LR Offcenter', ''),  # noqa
        '0019xx0c': ('DS', '1', 'CC Offcenter', ''),  # noqa
        '0019xx0d': ('DS', '1', 'AP Offcenter', ''),  # noqa
        '0019xx0e': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx0f': ('IS', '1', 'Number of Slices', ''),  # noqa
        '0019xx10': ('DS', '1', 'Slice Factor', ''),  # noqa
        '0019xx11': ('DS', '1-n', 'Echo Times', ''),  # noqa
        '0019xx14': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx15': ('IS', '1', 'Dynamic Study', ''),  # noqa
        '0019xx18': ('DS', '1', 'Heartbeat Interval', ''),  # noqa
        '0019xx19': ('DS', '1', 'Repetition Time FFE', ''),  # noqa
        '0019xx1a': ('DS', '1', 'FFE Flip Angle', ''),  # noqa
        '0019xx1b': ('IS', '1', 'Number of Scans', ''),  # noqa
        '0019xx1c': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx1d': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx1e': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx21': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx22': ('DS', '1', 'Dynamic Scan Time Begin', ''),  # noqa
        '0019xx23': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx24': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx25': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx26': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx27': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx28': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx29': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx30': ('LO', '1-n', 'Unknown', ''),  # noqa
        '0019xx31': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx40': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx45': ('IS', '1', 'Reconstruction Resolution', ''),  # noqa
        '0019xx50': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx51': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx52': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx53': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx54': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx55': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx56': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx57': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx58': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx59': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx60': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx61': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx62': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx63': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx64': ('DS', '1', 'Repetition Time SE', ''),  # noqa
        '0019xx65': ('DS', '1', 'Repetition Time IR', ''),  # noqa
        '0019xx66': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx67': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx69': ('IS', '1', 'Number of Phases', ''),  # noqa
        '0019xx6a': ('IS', '1', 'Cardiac Frequency', ''),  # noqa
        '0019xx6b': ('DS', '1', 'Inversion Delay', ''),  # noqa
        '0019xx6c': ('DS', '1', 'Gate Delay', ''),  # noqa
        '0019xx6d': ('DS', '1', 'Gate Width', ''),  # noqa
        '0019xx6e': ('DS', '1', 'Trigger Delay Time', ''),  # noqa
        '0019xx70': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx80': ('IS', '1', 'Number of Chemical Shifts', ''),  # noqa
        '0019xx81': ('DS', '1', 'Chemical Shift', ''),  # noqa
        '0019xx84': ('IS', '1', 'Number of Rows', ''),  # noqa
        '0019xx85': ('IS', '1', 'Number of Samples', ''),  # noqa
        '0019xx8a': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx8b': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx8c': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx8d': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx8e': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx8f': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xx94': ('LO', '1', 'Magnetization Transfer Contrast', ''),  # noqa
        '0019xx95': ('LO', '1', 'Spectral Presaturation With Inversion Recovery', ''),  # noqa
        '0019xx96': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx97': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx99': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xxa0': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxa1': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa3': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa4': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xxb4': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxb5': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxb6': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxc0': ('DS', '1', 'Trigger Delay Times', ''),  # noqa
        '0019xxc8': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxc9': ('IS', '1', 'Foldover Direction Transverse', ''),  # noqa
        '0019xxca': ('IS', '1', 'Foldover Direction Sagittal', ''),  # noqa
        '0019xxcb': ('IS', '1', 'Foldover Direction Coronal', ''),  # noqa
        '0019xxcc': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxcd': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxce': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxcf': ('IS', '1', 'Number of Echoes', ''),  # noqa
        '0019xxd0': ('IS', '1', 'Scan Resolution', ''),  # noqa
        '0019xxd1': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxd2': ('LO', '2', 'Water Fat Shift', ''),  # noqa
        '0019xxd3': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxd4': ('IS', '1', 'Artifact Reduction', ''),  # noqa
        '0019xxd5': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxd6': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxd7': ('DS', '1', 'Scan Percentage', ''),  # noqa
        '0019xxd8': ('IS', '1', 'Halfscan', ''),  # noqa
        '0019xxd9': ('IS', '1', 'EPI Factor', ''),  # noqa
        '0019xxda': ('IS', '1', 'Turbo Factor', ''),  # noqa
        '0019xxdb': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxe0': ('IS', '1', 'Percentage of Scan Completed', ''),  # noqa
        '0019xxe1': ('DS', '1', 'Prepulse Delay', ''),  # noqa
        '0019xxe3': ('DS', '1', 'Phase Contrast Velocity', ''),  # noqa
        '0019xxf0': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxf6': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xxf7': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xxf8': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xxf9': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xxfa': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xxfb': ('CS', '1', 'Unknown', ''),  # noqa
        '0019xxfc': ('IS', '1', 'Resonance Frequency', ''),  # noqa
        '0021xx00': ('IS', '1', 'Scan Date', ''),  # noqa
        '0021xx06': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx07': ('DT', '1', 'Unknown', ''),  # noqa
        '0021xx08': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx09': ('CS', '1', 'Unknown', ''),  # noqa
        '0021xx0a': ('CS', '1', 'Unknown', ''),  # noqa
        '0021xx0f': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx10': ('IS', '1', 'Image Type', ''),  # noqa
        '0021xx13': ('CS', '1', 'Unknown', ''),  # noqa
        '0021xx14': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx15': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx20': ('IS', '1', 'Slice Number', ''),  # noqa
        '0021xx21': ('IS', '1', 'Slice Gap', ''),  # noqa
        '0021xx30': ('IS', '1', 'Echo Number', ''),  # noqa
        '0021xx31': ('DS', '1', 'Patient Reference ID', ''),  # noqa
        '0021xx35': ('IS', '1', 'Chemical Shift Number', ''),  # noqa
        '0021xx40': ('IS', '1', 'Phase Number', ''),  # noqa
        '0021xx50': ('IS', '1', 'Dynamic Scan Number', ''),  # noqa
        '0021xx60': ('IS', '1', 'Number of Rows In Object', ''),  # noqa
        '0021xx61': ('IS', '1-n', 'Row Number', ''),  # noqa
        '0021xx62': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0029xx00': ('DS', '2', 'Unknown', ''),  # noqa
        '0029xx04': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx11': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx20': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx31': ('DS', '2', 'Unknown', ''),  # noqa
        '0029xx32': ('DS', '2', 'Unknown', ''),  # noqa
        '0029xx50': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx51': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx52': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx53': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xxc3': ('IS', '1', 'Scan Resolution', ''),  # noqa
        '0029xxc4': ('IS', '1', 'Field of View', ''),  # noqa
        '0029xxd5': ('LT', '1', 'Slice Thickness', ''),  # noqa
    },
    'PHILIPS MR/PART 12': {
        '0009xx10': ('US', '1', 'Unknown', ''),  # noqa
    },
    'PHILIPS MR/PART 6': {
        '0019xx10': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'PHILIPS MR/PART 7': {
        '0019xx00': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'PHILIPS NM -Private': {
        '7051xx00': ('US', '1', 'Current Segment', ''),  # noqa
        '7051xx01': ('US', '1', 'Number of Segments', ''),  # noqa
        '7051xx02': ('FL', '1', 'Segment Start Position', ''),  # noqa
        '7051xx03': ('FL', '1', 'Segment Stop Position', ''),  # noqa
        '7051xx04': ('FL', '1', 'Rel. COR offset - X dir.', ''),  # noqa
        '7051xx05': ('FL', '1', 'Rel. COR offset - Z dir.', ''),  # noqa
        '7051xx06': ('US', '1', 'Current Rotation Number', ''),  # noqa
        '7051xx07': ('US', '1', 'Number of Rotations', ''),  # noqa
        '7051xx10': ('DS', '1', 'Alignment Translations', ''),  # noqa
        '7051xx11': ('DS', '1', 'Alignment Rotations', ''),  # noqa
        '7051xx12': ('DS', '1', 'Alignment Timestamp', ''),  # noqa
    },
    'PHILIPS UNDOCUMENTED': {
        '5503xx12': ('SL', '1', 'Slice Thickness', ''),  # noqa
        '5503xx24': ('UT', '1', 'Plane', ''),  # noqa
        '5503xx30': ('SS', '1', 'Number of Slices', ''),  # noqa
        '5503xxa5': ('UT', '1', 'Prepulse', ''),  # noqa
        '5503xxae': ('SS', '1', 'Contrast Agent Flag', ''),  # noqa
        '5503xxbb': ('SL', '1', 'Coil ID', ''),  # noqa
        '5503xxc2': ('UT', '1', 'Anatomy', ''),  # noqa
        '5503xxc3': ('UT', '1', 'Indication', ''),  # noqa
    },
    'PHILIPS UNKNOWN': {
        '2001xx01': ('UN', '1', 'MRSeriesNrOfEchoes', ''),  # noqa
        '2001xx02': ('UN', '1', 'MRSeriesScanningTechniqueDescription', ''),  # noqa
        '2001xx05': ('UN', '1', 'StackSequence', ''),  # noqa
        '2001xx06': ('UN', '1', 'Examination Source', ''),  # noqa
        '2001xx07': ('UN', '1', 'MRSeriesAcquisitionNumber', ''),  # noqa
        '2001xx08': ('UN', '1', 'MRSeriesNrOfDynamicScans', ''),  # noqa
        '2005xx02': ('UN', '1', 'MRSeriesNrOfChemicalShifts', ''),  # noqa
        '2005xx03': ('UN', '1', 'MRSeriesRepetitionTime', ''),  # noqa
        '2005xx36': ('UN', '1', 'MRVolumeSelection', ''),  # noqa
    },
    'PHILIPS-MR-1': {
        '0019xx11': ('IS', '1', 'Chemical Shift Number', ''),  # noqa
        '0019xx12': ('IS', '1', 'Phase Number (Philips)', ''),  # noqa
        '0021xx01': ('IS', '1', 'Reconstruction Number', ''),  # noqa
        '0021xx02': ('IS', '1', 'Slice Number', ''),  # noqa
    },
    'PMOD_1': {
        '0055xx01': ('FD', '1-n', 'Frame Start Times Vector', ''),  # noqa
        '0055xx02': ('FD', '3-3n', 'Frame Positions Vector', ''),  # noqa
        '0055xx03': ('FD', '6-6n', 'Frame Orientations Vector', ''),  # noqa
        '0055xx04': ('FD', '1-n', 'Frame Durations (ms) Vector', ''),  # noqa
        '0055xx05': ('FD', '1-n', 'Frame Rescale Slope Vector', ''),  # noqa
    },
    'PMOD_GENPET': {
        '7fe1xx01': ('UT', '1', 'Slices Names', ''),  # noqa
        '7fe1xx02': ('UT', '1', 'Gene Codes', ''),  # noqa
        '7fe1xx03': ('UT', '1', 'Gene Labels', ''),  # noqa
    },
    'PMS-THORA-5.1': {
        '0089xx20': ('SQ', '1', 'Stamp Image Sequence', ''),  # noqa
    },
    'PMTF INFORMATION DATA': {
        '00290089': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx31': ('LO', '1', 'PMTF Information 1', ''),  # noqa
        '0029xx32': ('UL', '1', 'PMTF Information 2', ''),  # noqa
        '0029xx33': ('UL', '1', 'PMTF Information 3', ''),  # noqa
        '0029xx34': ('CS', '1', 'PMTF Information 4', ''),  # noqa
        '0029xx89': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx90': ('OB', '1', 'Unknown', ''),  # noqa
        '7015xx73': ('SQ', '1', 'Unknown', ''),  # noqa
    },
    'PMTF INFORMATION DATA^10': {
        '00090002': ('SH', '1', 'Unknown', ''),  # noqa
        '00110003': ('US', '1', 'Unknown', ''),  # noqa
        '00110004': ('SQ', '1', 'Unknown', ''),  # noqa
        '00110005': ('US', '1', 'Unknown', ''),  # noqa
        '00110006': ('US', '1', 'Unknown', ''),  # noqa
        '00110007': ('US', '1-n', 'Unknown', ''),  # noqa
        '00110008': ('SH', '1', 'Unknown', ''),  # noqa
        '00190001': ('UL', '1', 'Unknown', ''),  # noqa
        '00190002': ('SL', '1', 'Unknown', ''),  # noqa
        '00190003': ('US', '1', 'Unknown', ''),  # noqa
        '00190004': ('SL', '1', 'Unknown', ''),  # noqa
        '00190005': ('FL', '1', 'Unknown', ''),  # noqa
        '00190006': ('SL', '1', 'Unknown', ''),  # noqa
        '00190007': ('FL', '3', 'Unknown', ''),  # noqa
        '00190008': ('US', '1', 'Unknown', ''),  # noqa
        '00190009': ('FL', '1', 'Unknown', ''),  # noqa
        '0019000a': ('FL', '1', 'Unknown', ''),  # noqa
        '0019000b': ('FL', '1', 'Unknown', ''),  # noqa
        '0019000c': ('US', '3', 'Unknown', ''),  # noqa
        '0019000d': ('SL', '6', 'Unknown', ''),  # noqa
        '0019000e': ('SL', '6', 'Unknown', ''),  # noqa
        '0019000f': ('SL', '6', 'Unknown', ''),  # noqa
        '00190010': ('US', '2', 'Unknown', ''),  # noqa
        '00190011': ('SL', '2', 'Unknown', ''),  # noqa
        '00190012': ('US', '1', 'Unknown', ''),  # noqa
        '00190013': ('SL', '1', 'Unknown', ''),  # noqa
        '00190014': ('US', '1', 'Unknown', ''),  # noqa
        '00190015': ('SL', '1', 'Unknown', ''),  # noqa
        '00190016': ('FL', '1', 'Unknown', ''),  # noqa
        '00190017': ('SL', '1', 'Unknown', ''),  # noqa
        '00190018': ('US', '1', 'Unknown', ''),  # noqa
        '00190019': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001a': ('US', '1', 'Unknown', ''),  # noqa
        '0019001b': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001e': ('US', '1', 'Unknown', ''),  # noqa
        '00190027': ('SL', '1', 'Unknown', ''),  # noqa
        '00190028': ('SL', '1', 'Unknown', ''),  # noqa
        '00190029': ('SH', '1', 'Unknown', ''),  # noqa
        '0019002a': ('DS', '3', 'Unknown', ''),  # noqa
        '0019002b': ('SH', '1', 'Unknown', ''),  # noqa
        '0019002c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019002d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019002e': ('US', '1', 'Unknown', ''),  # noqa
        '0019002f': ('FL', '1', 'Unknown', ''),  # noqa
        '00190030': ('UL', '1', 'Unknown', ''),  # noqa
        '00190031': ('OF', '1-n', 'Unknown', ''),  # noqa
        '00190032': ('FL', '1', 'Unknown', ''),  # noqa
        '00190033': ('SL', '3', 'Unknown', ''),  # noqa
        '00190034': ('SL', '1', 'Unknown', ''),  # noqa
        '00190035': ('SL', '1', 'Unknown', ''),  # noqa
        '00190036': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190038': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003b': ('SL', '2', 'Unknown', ''),  # noqa
        '0019003c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190042': ('US', '1', 'Unknown', ''),  # noqa
        '00190043': ('US', '1', 'Unknown', ''),  # noqa
        '00190044': ('SL', '1', 'Unknown', ''),  # noqa
        '00190045': ('SS', '1', 'Unknown', ''),  # noqa
        '00190046': ('US', '1', 'Unknown', ''),  # noqa
        '00190047': ('FL', '1', 'Unknown', ''),  # noqa
        '00190048': ('US', '1', 'Unknown', ''),  # noqa
        '00190049': ('US', '1', 'Unknown', ''),  # noqa
        '0019004b': ('US', '1', 'Unknown', ''),  # noqa
        '0019004c': ('US', '1', 'Unknown', ''),  # noqa
        '0019004d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019004e': ('US', '1', 'Unknown', ''),  # noqa
        '0019004f': ('US', '1', 'Unknown', ''),  # noqa
        '00190050': ('SL', '2', 'Unknown', ''),  # noqa
        '00190051': ('SL', '2', 'Unknown', ''),  # noqa
        '00190052': ('LO', '1', 'Unknown', ''),  # noqa
        '00190054': ('US', '1', 'Unknown', ''),  # noqa
        '00190055': ('US', '1', 'Unknown', ''),  # noqa
        '00190057': ('FL', '3', 'Unknown', ''),  # noqa
        '00190058': ('FL', '3', 'Unknown', ''),  # noqa
        '00190059': ('SL', '1', 'Unknown', ''),  # noqa
        '0019005a': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0019005d': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0019005e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019005f': ('FL', '1', 'Unknown', ''),  # noqa
        '00190060': ('US', '1', 'Unknown', ''),  # noqa
        '00190061': ('US', '1', 'Unknown', ''),  # noqa
        '00190062': ('US', '1', 'Unknown', ''),  # noqa
        '00190063': ('FL', '1', 'Unknown', ''),  # noqa
        '00190064': ('FL', '1', 'Unknown', ''),  # noqa
        '00190065': ('SL', '2', 'Unknown', ''),  # noqa
        '00190069': ('FL', '1', 'Unknown', ''),  # noqa
        '0019006a': ('US', '1', 'Unknown', ''),  # noqa
        '0019006b': ('SL', '1', 'Unknown', ''),  # noqa
        '0019006d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019006e': ('FL', '1', 'Unknown', ''),  # noqa
        '0019006f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190070': ('LO', '1', 'Unknown', ''),  # noqa
        '00190071': ('LO', '1', 'Unknown', ''),  # noqa
        '00190073': ('LO', '1', 'Unknown', ''),  # noqa
        '00190075': ('LO', '1', 'Unknown', ''),  # noqa
        '00190076': ('LO', '1', 'Unknown', ''),  # noqa
        '00190078': ('LO', '1', 'Unknown', ''),  # noqa
        '0019007b': ('LO', '1', 'Unknown', ''),  # noqa
        '0019007c': ('FL', '1', 'Unknown', ''),  # noqa
        '0019007d': ('FL', '1', 'Unknown', ''),  # noqa
        '0019007e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190085': ('FL', '1', 'Unknown', ''),  # noqa
        '00190086': ('SL', '1', 'Unknown', ''),  # noqa
        '00190087': ('FL', '1', 'Unknown', ''),  # noqa
        '00190088': ('LO', '1', 'Unknown', ''),  # noqa
        '0019008a': ('SL', '1-n', 'Unknown', ''),  # noqa
        '0019008c': ('UL', '1', 'Unknown', ''),  # noqa
        '0019008d': ('TM', '1', 'Unknown', ''),  # noqa
        '0019008e': ('SL', '1', 'Unknown', ''),  # noqa
        '00190092': ('SL', '1', 'Unknown', ''),  # noqa
        '00190093': ('FL', '3', 'Unknown', ''),  # noqa
        '00190096': ('US', '1', 'Unknown', ''),  # noqa
        '0019009b': ('FL', '3', 'Unknown', ''),  # noqa
        '0019009c': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a0': ('SL', '4', 'Unknown', ''),  # noqa
        '001900a1': ('DS', '1', 'Unknown', ''),  # noqa
        '001900a2': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a3': ('SL', '3', 'Unknown', ''),  # noqa
        '001900a4': ('FL', '3', 'Unknown', ''),  # noqa
        '001900a5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a8': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ab': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ac': ('US', '1', 'Unknown', ''),  # noqa
        '001900ae': ('FL', '1', 'Unknown', ''),  # noqa
        '001900af': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b0': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b7': ('FL', '2', 'Unknown', ''),  # noqa
        '001900ba': ('FL', '1', 'Unknown', ''),  # noqa
        '001900bb': ('FL', '1', 'Unknown', ''),  # noqa
        '001900bc': ('FL', '2', 'Unknown', ''),  # noqa
        '001900bd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900be': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c6': ('FL', '2', 'Unknown', ''),  # noqa
        '001900c9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ca': ('LO', '1', 'Unknown', ''),  # noqa
        '001900cb': ('UL', '1', 'Unknown', ''),  # noqa
        '001900cc': ('UL', '1', 'Unknown', ''),  # noqa
        '001900cd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ce': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d0': ('US', '1', 'Unknown', ''),  # noqa
        '001900d1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d2': ('SL', '3', 'Unknown', ''),  # noqa
        '001900d3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d8': ('US', '1', 'Unknown', ''),  # noqa
        '001900d9': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900da': ('US', '1', 'Unknown', ''),  # noqa
        '001900db': ('SL', '1', 'Unknown', ''),  # noqa
        '001900dc': ('SL', '1', 'Unknown', ''),  # noqa
        '001900e1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900e4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900e5': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900e6': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900e9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ea': ('UI', '1', 'Unknown', ''),  # noqa
        '001900eb': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ec': ('US', '1', 'Unknown', ''),  # noqa
        '001900ee': ('FL', '1', 'Unknown', ''),  # noqa
        '001900ef': ('FL', '1', 'Unknown', ''),  # noqa
        '001900f0': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f1': ('FL', '1', 'Unknown', ''),  # noqa
        '001900f2': ('FL', '1', 'Unknown', ''),  # noqa
        '001900f3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f4': ('FD', '1', 'Unknown', ''),  # noqa
        '001900f5': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f6': ('UI', '1', 'Unknown', ''),  # noqa
        '001900f8': ('US', '1', 'Unknown', ''),  # noqa
        '001900f9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fa': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fb': ('UL', '1', 'Unknown', ''),  # noqa
        '001900fc': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fd': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fe': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ff': ('SL', '3', 'Unknown', ''),  # noqa
        '00210002': ('SL', '1', 'Unknown', ''),  # noqa
        '00210003': ('SL', '1', 'Unknown', ''),  # noqa
        '00210004': ('US', '1', 'Unknown', ''),  # noqa
        '00210008': ('DS', '3', 'Unknown', ''),  # noqa
        '00210009': ('DS', '3', 'Unknown', ''),  # noqa
        '0021000a': ('DS', '3', 'Unknown', ''),  # noqa
        '0021000b': ('US', '1', 'Unknown', ''),  # noqa
        '0021000c': ('US', '1', 'Unknown', ''),  # noqa
        '0021000d': ('FL', '1', 'Unknown', ''),  # noqa
        '0021000f': ('US', '1', 'Unknown', ''),  # noqa
        '00210012': ('DS', '3', 'Unknown', ''),  # noqa
        '00210014': ('SQ', '1', 'Unknown', ''),  # noqa
        '00210015': ('FL', '1', 'Unknown', ''),  # noqa
        '00210016': ('FL', '2', 'Unknown', ''),  # noqa
        '00210018': ('US', '1', 'Unknown', ''),  # noqa
        '0021001a': ('US', '1', 'Unknown', ''),  # noqa
        '0021001d': ('IS', '1', 'Unknown', ''),  # noqa
        '0021001f': ('US', '1', 'Unknown', ''),  # noqa
        '00290001': ('SL', '1', 'Unknown', ''),  # noqa
        '00290005': ('SQ', '1', 'Unknown', ''),  # noqa
        '00290006': ('FL', '1', 'Unknown', ''),  # noqa
        '00290007': ('FL', '1', 'Unknown', ''),  # noqa
        '0029001c': ('FL', '2', 'Unknown', ''),  # noqa
        '00290021': ('SL', '3', 'Unknown', ''),  # noqa
        '0029004e': ('SL', '1', 'Unknown', ''),  # noqa
        '00290050': ('LO', '1', 'Unknown', ''),  # noqa
        '00290051': ('LO', '1', 'Unknown', ''),  # noqa
        '00290052': ('LO', '1', 'Unknown', ''),  # noqa
        '00290054': ('LO', '1', 'Unknown', ''),  # noqa
        '00290067': ('FD', '4', 'Unknown', ''),  # noqa
        '00290068': ('SS', '1', 'Unknown', ''),  # noqa
        'e2010002': ('US', '1', 'Unknown', ''),  # noqa
        'e3010000': ('SH', '1', 'Unknown', ''),  # noqa
        'e4010000': ('US', '1', 'Unknown', ''),  # noqa
        'e4010001': ('US', '1', 'Unknown', ''),  # noqa
        'e4010002': ('US', '1', 'Unknown', ''),  # noqa
        'e4010003': ('US', '1', 'Unknown', ''),  # noqa
        'e4010004': ('US', '1', 'Unknown', ''),  # noqa
        'e4010005': ('OB', '1', 'Unknown', ''),  # noqa
        'e4010008': ('FL', '1', 'Unknown', ''),  # noqa
        'e4010012': ('FL', '1', 'Unknown', ''),  # noqa
        'e4010013': ('OB', '1', 'Unknown', ''),  # noqa
        'e4010020': ('SQ', '1', 'Unknown', ''),  # noqa
        'e4010021': ('SQ', '1', 'Unknown', ''),  # noqa
        'e4010022': ('LO', '1', 'Unknown', ''),  # noqa
        'e4010023': ('SH', '1', 'Unknown', ''),  # noqa
        'e4010024': ('OB', '1', 'Unknown', ''),  # noqa
        'e4030000': ('SQ', '1', 'Unknown', ''),  # noqa
        'ee010000': ('US', '1', 'Unknown', ''),  # noqa
        'ee010001': ('OB', '1', 'Unknown', ''),  # noqa
        'ee010002': ('US', '1', 'Unknown', ''),  # noqa
    },
    'PMTF INFORMATION DATA^11': {
        '00190002': ('SL', '1', 'Unknown', ''),  # noqa
        '00190003': ('SL', '1', 'Unknown', ''),  # noqa
        '00190004': ('SL', '1', 'Unknown', ''),  # noqa
        '00190007': ('OB', '1', 'Unknown', ''),  # noqa
        '00190008': ('SH', '1', 'Unknown', ''),  # noqa
        '00190009': ('SL', '2', 'Unknown', ''),  # noqa
        '0019000a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000b': ('OB', '1', 'Unknown', ''),  # noqa
        '0019000c': ('SL', '1', 'Unknown', ''),  # noqa
        '00190019': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190024': ('SL', '1', 'Unknown', ''),  # noqa
        '00190025': ('SL', '1', 'Unknown', ''),  # noqa
        '00190026': ('SL', '1', 'Unknown', ''),  # noqa
        '00190028': ('SL', '1', 'Unknown', ''),  # noqa
        '00190029': ('SL', '1', 'Unknown', ''),  # noqa
        '0019002a': ('FL', '1', 'Unknown', ''),  # noqa
        '0019002b': ('FL', '1', 'Unknown', ''),  # noqa
        '0019002c': ('SL', '3', 'Unknown', ''),  # noqa
        '0019002d': ('SL', '3', 'Unknown', ''),  # noqa
        '0019002e': ('SL', '1', 'Unknown', ''),  # noqa
        '00190030': ('SL', '1', 'Unknown', ''),  # noqa
        '00190031': ('SL', '1', 'Unknown', ''),  # noqa
        '00190032': ('SL', '1', 'Unknown', ''),  # noqa
        '00190034': ('FL', '1', 'Unknown', ''),  # noqa
        '00190035': ('SL', '1', 'Unknown', ''),  # noqa
        '00190036': ('FL', '1', 'Unknown', ''),  # noqa
        '00190037': ('SL', '1', 'Unknown', ''),  # noqa
        '00190038': ('SL', '1', 'Unknown', ''),  # noqa
        '00190039': ('FL', '1', 'Unknown', ''),  # noqa
        '0019003a': ('FL', '1', 'Unknown', ''),  # noqa
        '0019003c': ('FL', '3', 'Unknown', ''),  # noqa
        '0019003e': ('FL', '9', 'Unknown', ''),  # noqa
        '0019003f': ('UI', '1', 'Unknown', ''),  # noqa
        '00190040': ('US', '1', 'Unknown', ''),  # noqa
        '00190041': ('US', '1', 'Unknown', ''),  # noqa
        '00190042': ('SL', '1', 'Unknown', ''),  # noqa
        '00190043': ('SL', '1', 'Unknown', ''),  # noqa
        '00190044': ('SL', '1', 'Unknown', ''),  # noqa
        '00190046': ('FL', '1', 'Unknown', ''),  # noqa
        '00190048': ('LT', '1', 'Unknown', ''),  # noqa
        '00190049': ('LT', '1', 'Unknown', ''),  # noqa
        '0019004c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019004d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019004e': ('SL', '1', 'Unknown', ''),  # noqa
        '00190055': ('LO', '1', 'Unknown', ''),  # noqa
        '00190057': ('FL', '1', 'Unknown', ''),  # noqa
        '00190058': ('US', '1', 'Unknown', ''),  # noqa
        '00190059': ('US', '1', 'Unknown', ''),  # noqa
        '0019005c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019005d': ('SL', '1', 'Unknown', ''),  # noqa
        '00190060': ('SL', '1', 'Unknown', ''),  # noqa
        '00190063': ('SL', '1', 'Unknown', ''),  # noqa
        '00190067': ('FL', '1', 'Unknown', ''),  # noqa
        '00190068': ('SL', '1', 'Unknown', ''),  # noqa
        '0019006c': ('FL', '1', 'Unknown', ''),  # noqa
        '0019006d': ('SH', '1', 'Unknown', ''),  # noqa
        '0019006e': ('SH', '1', 'Unknown', ''),  # noqa
        '0019006f': ('FL', '1', 'Unknown', ''),  # noqa
        '00190078': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007a': ('SL', '2', 'Unknown', ''),  # noqa
        '0019007c': ('FL', '3', 'Unknown', ''),  # noqa
        '0019007d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190080': ('FL', '1', 'Unknown', ''),  # noqa
        '00190084': ('SL', '1', 'Unknown', ''),  # noqa
        '00190087': ('SL', '1', 'Unknown', ''),  # noqa
        '0019008a': ('US', '1', 'Unknown', ''),  # noqa
        '0019008f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190090': ('SL', '1', 'Unknown', ''),  # noqa
        '00190091': ('SL', '1', 'Unknown', ''),  # noqa
        '00190092': ('SL', '1', 'Unknown', ''),  # noqa
        '00190094': ('FL', '1', 'Unknown', ''),  # noqa
        '0019009a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019009b': ('US', '1', 'Unknown', ''),  # noqa
        '0019009c': ('FL', '1', 'Unknown', ''),  # noqa
        '0019009d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019009e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019009f': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a5': ('US', '1', 'Unknown', ''),  # noqa
        '001900a6': ('US', '1', 'Unknown', ''),  # noqa
        '001900a8': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ad': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ae': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b2': ('US', '1', 'Unknown', ''),  # noqa
        '001900b3': ('US', '1', 'Unknown', ''),  # noqa
        '001900b4': ('US', '1', 'Unknown', ''),  # noqa
        '001900b5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900b6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b7': ('US', '1', 'Unknown', ''),  # noqa
        '001900b9': ('US', '1', 'Unknown', ''),  # noqa
        '001900c0': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c1': ('US', '1', 'Unknown', ''),  # noqa
        '001900c3': ('FL', '1', 'Unknown', ''),  # noqa
        '001900c4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900e0': ('FL', '1', 'Unknown', ''),  # noqa
        '001900e1': ('FL', '1', 'Unknown', ''),  # noqa
        '001900e3': ('SL', '3', 'Unknown', ''),  # noqa
        '001900e4': ('DS', '1', 'Unknown', ''),  # noqa
        '001900e5': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900e6': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900f0': ('SL', '1-n', 'Unknown', ''),  # noqa
        '001900f1': ('SL', '3', 'Unknown', ''),  # noqa
        '001900f2': ('FL', '3', 'Unknown', ''),  # noqa
        '001900f3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f5': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900f6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f7': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f8': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fa': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fb': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fc': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fe': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ff': ('SL', '1', 'Unknown', ''),  # noqa
    },
    'PMTF INFORMATION DATA^12': {
        '00190000': ('SL', '1', 'Unknown', ''),  # noqa
        '00190001': ('SL', '1', 'Unknown', ''),  # noqa
        '00190002': ('SL', '1', 'Unknown', ''),  # noqa
        '00190003': ('SL', '1', 'Unknown', ''),  # noqa
        '00190004': ('SL', '1', 'Unknown', ''),  # noqa
        '00190005': ('SH', '1', 'Unknown', ''),  # noqa
        '00190006': ('FL', '1', 'Unknown', ''),  # noqa
        '00190007': ('UL', '2', 'Unknown', ''),  # noqa
        '00190008': ('UL', '2', 'Unknown', ''),  # noqa
        '00190009': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000b': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000c': ('UL', '1', 'Unknown', ''),  # noqa
        '0019000d': ('SQ', '1', 'Unknown', ''),  # noqa
        '0019000e': ('US', '1', 'Unknown', ''),  # noqa
        '00190010': ('SL', '1', 'Unknown', ''),  # noqa
        '00190011': ('SL', '1', 'Unknown', ''),  # noqa
        '00190012': ('SL', '1', 'Unknown', ''),  # noqa
        '00190013': ('FL', '1', 'Unknown', ''),  # noqa
        '00190014': ('FL', '1', 'Unknown', ''),  # noqa
        '00190018': ('UL', '1', 'Unknown', ''),  # noqa
        '00190028': ('DS', '1', 'Unknown', ''),  # noqa
        '0019002a': ('TM', '1', 'Unknown', ''),  # noqa
        '0019002b': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190032': ('SH', '1', 'Unknown', ''),  # noqa
        '00190034': ('SL', '1', 'Unknown', ''),  # noqa
        '00190076': ('OB', '1', 'Unknown', ''),  # noqa
        '00190079': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190080': ('FD', '1', 'Unknown', ''),  # noqa
        '00190085': ('US', '1', 'Unknown', ''),  # noqa
        '00190086': ('LO', '1', 'Unknown', ''),  # noqa
        '00190087': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190088': ('US', '1', 'Unknown', ''),  # noqa
        '00190089': ('SL', '1', 'Unknown', ''),  # noqa
        '0019008a': ('US', '1', 'Unknown', ''),  # noqa
        '0019008b': ('US', '1', 'Unknown', ''),  # noqa
        '0019008f': ('OB', '1', 'Unknown', ''),  # noqa
        '00190093': ('SL', '1', 'Unknown', ''),  # noqa
        '00190094': ('UI', '1', 'Unknown', ''),  # noqa
        '00190095': ('UI', '1', 'Unknown', ''),  # noqa
        '00190098': ('FL', '3', 'Unknown', ''),  # noqa
        '00190099': ('LO', '1', 'Unknown', ''),  # noqa
        '0019009a': ('DS', '1', 'Unknown', ''),  # noqa
        '0019009c': ('DS', '1', 'Unknown', ''),  # noqa
        '0019009d': ('US', '1', 'Unknown', ''),  # noqa
        '0019009e': ('FL', '3', 'Unknown', ''),  # noqa
        '0019009f': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a0': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a1': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a2': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a3': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a4': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a6': ('FL', '8', 'Unknown', ''),  # noqa
        '001900a7': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a8': ('FL', '1', 'Unknown', ''),  # noqa
        '001900aa': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ab': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ac': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ad': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ae': ('FL', '3', 'Unknown', ''),  # noqa
        '001900af': ('FL', '3', 'Unknown', ''),  # noqa
        '001900b3': ('FD', '1', 'Unknown', ''),  # noqa
        '001900b4': ('LO', '1', 'Unknown', ''),  # noqa
        '001900c2': ('US', '1', 'Unknown', ''),  # noqa
        '001900c3': ('FL', '1', 'Unknown', ''),  # noqa
        '001900c4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c5': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c7': ('FL', '1', 'Unknown', ''),  # noqa
        '001900cc': ('SS', '1', 'Unknown', ''),  # noqa
        '001900cd': ('LO', '1', 'Unknown', ''),  # noqa
        '001900cf': ('FL', '1', 'Unknown', ''),  # noqa
        '001900d1': ('FL', '3', 'Unknown', ''),  # noqa
        '001900d2': ('US', '3', 'Unknown', ''),  # noqa
        '001900d3': ('SS', '1', 'Unknown', ''),  # noqa
        '001900d4': ('US', '2', 'Unknown', ''),  # noqa
        '001900d5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900d6': ('FL', '3', 'Unknown', ''),  # noqa
        '001900d7': ('US', '2', 'Unknown', ''),  # noqa
        '001900d8': ('FL', '5', 'Unknown', ''),  # noqa
        '001900de': ('US', '1', 'Unknown', ''),  # noqa
        '001900df': ('US', '1', 'Unknown', ''),  # noqa
        '001900e0': ('US', '1', 'Unknown', ''),  # noqa
        '001900e1': ('FL', '3', 'Unknown', ''),  # noqa
        '001900e2': ('FL', '3', 'Unknown', ''),  # noqa
        '001900e3': ('TM', '1', 'Unknown', ''),  # noqa
        '001900e4': ('US', '2', 'Unknown', ''),  # noqa
        '001900eb': ('US', '1', 'Unknown', ''),  # noqa
        '001900ec': ('US', '1', 'Unknown', ''),  # noqa
    },
    'PMTF INFORMATION DATA^13': {
        'e4030000': ('SH', '1', 'Unknown', ''),  # noqa
        'e4030001': ('OB', '1', 'Unknown', ''),  # noqa
        'e4030002': ('OB', '1', 'Unknown', ''),  # noqa
        'e4030003': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'POLYTRON-SMS 2.5': {
        '0009xx02': ('UN', '1', 'Private Data 1', ''),  # noqa
        '0009xx03': ('UN', '1', 'Private Data 2', ''),  # noqa
        '0009xx04': ('UN', '1', 'Private Data 3', ''),  # noqa
        '0009xx06': ('UN', '1', 'Private Data 3', ''),  # noqa
        '0009xx10': ('UN', '1', 'Private Data 4', ''),  # noqa
        '0009xx11': ('UN', '1', 'Private Data 5', ''),  # noqa
        '0009xx12': ('UN', '1', 'Private Data 6', ''),  # noqa
        '0089xx10': ('UN', '1', 'Private Data', ''),  # noqa
    },
    'PRIVATE ORIGINAL ATTRIBUTES': {
        '0021xx01': ('SQ', '1', 'Private Original Attribute Sequence', ''),  # noqa
        '0021xx05': ('DT', '1', 'Replacement Date and Time', ''),  # noqa
        '0021xx10': ('LO', '1', 'Replacement Originator Name', ''),  # noqa
        '0021xx12': ('LO', '1', 'Replacement Reason', ''),  # noqa
        '0021xx70': ('PN', '1-n', "Original Operators' Name", ''),  # noqa
    },
    'Philips EV Imaging DD 017': {
        '2007xxc1': ('UI', '1', '? SOP Instance UID ?', ''),  # noqa
        '2007xxc2': ('DA', '1', 'Unknown', ''),  # noqa
        '2007xxc3': ('TM', '1', 'Unknown', ''),  # noqa
        '2007xxc4': ('UL', '1', 'Unknown', ''),  # noqa
    },
    'Philips EV Imaging DD 019': {
        '2007xx00': ('LO', '1', 'Unknown', ''),  # noqa
        '2007xx01': ('UT', '1', 'Unknown', ''),  # noqa
    },
    'Philips EV Imaging DD 021': {
        '2007xx04': ('SL', '1', 'Vol Seg Edit Connectivity', ''),  # noqa
    },
    'Philips EV Imaging DD 022': {
        '2007xx00': ('ST', '1', '', ''),  # noqa
        '2007xx12': ('UN', '1', 'Volume Sequence Capture', ''),  # noqa
        '2007xx17': ('UN', '1', 'Original SOP Instance', ''),  # noqa
        '2007xx33': ('LO', '1', '', ''),  # noqa
        '2007xx34': ('CS', '1', '', ''),  # noqa
    },
    'Philips EnVisor': {
        '7777xx01': ('DA', '1', "Date 3D/PanView internal 'dataset' file was acquired", ''),  # noqa
        '7777xx02': ('CS', '1', 'Type of 3D or PanView', ''),  # noqa
        '7777xx03': ('LO', '1', 'Internal 3D/PanView software version number', ''),  # noqa
        '7777xx14': ('LT', '1', 'Private string', ''),  # noqa
    },
    'Philips Imaging DD 001': {
        '2001xx01': ('FL', '1', 'Chemical Shift', ''),  # noqa
        '2001xx02': ('IS', '1', 'Chemical Shift Number MR', ''),  # noqa
        '2001xx03': ('FL', '1', 'Diffusion B-Factor', ''),  # noqa
        '2001xx04': ('CS', '1', 'Diffusion Direction', ''),  # noqa
        '2001xx05': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx06': ('CS', '1', 'Image Enhanced', ''),  # noqa
        '2001xx07': ('CS', '1', 'Image Type ED ES', ''),  # noqa
        '2001xx08': ('IS', '1', 'Phase Number', ''),  # noqa
        '2001xx09': ('FL', '1', 'Unknown', ''),  # noqa
        '2001xx0a': ('IS', '1', 'Slice Number MR', ''),  # noqa
        '2001xx0b': ('CS', '1', 'Slice Orientation', ''),  # noqa
        '2001xx0c': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx0e': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx0f': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx10': ('CS', '1', 'Cardiac Sync', ''),  # noqa
        '2001xx11': ('FL', '1', 'Diffusion Echo Time', ''),  # noqa
        '2001xx12': ('CS', '1', 'Dynamic Series', ''),  # noqa
        '2001xx13': ('SL', '1', 'EPI Factor', ''),  # noqa
        '2001xx14': ('SL', '1', 'Number of Echoes', ''),  # noqa
        '2001xx15': ('SS', '1', 'Number of Locations', ''),  # noqa
        '2001xx16': ('SS', '1', 'Number of PC Directions', ''),  # noqa
        '2001xx17': ('SL', '1', 'Number of Phases MR', ''),  # noqa
        '2001xx18': ('SL', '1', 'Number of Slices MR', ''),  # noqa
        '2001xx19': ('CS', '1', 'Partial Matrix Scanned', ''),  # noqa
        '2001xx1a': ('FL', '1-n', 'PC Velocity', ''),  # noqa
        '2001xx1b': ('FL', '1', 'Prepulse Delay', ''),  # noqa
        '2001xx1c': ('CS', '1', 'Prepulse Type', ''),  # noqa
        '2001xx1d': ('IS', '1', 'Reconstruction Number MR', ''),  # noqa
        '2001xx1e': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx1f': ('CS', '1', 'Respiration Sync', ''),  # noqa
        '2001xx20': ('LO', '1', 'Scanning Technique Description MR', ''),  # noqa
        '2001xx21': ('CS', '1', 'SPIR', ''),  # noqa
        '2001xx22': ('FL', '1', 'Water Fat Shift', ''),  # noqa
        '2001xx23': ('DS', '1', 'Flip Angle Philips', ''),  # noqa
        '2001xx24': ('CS', '1', 'Interactive', ''),  # noqa
        '2001xx25': ('SH', '1', 'Echo Time Display MR', ''),  # noqa
        '2001xx26': ('CS', '1', 'Presentation State Subtraction Active', ''),  # noqa
        '2001xx28': ('FL', '1', 'Edge Enhancement Gain Factor Sub', ''),  # noqa
        '2001xx29': ('FL', '1', 'Edge Enhancement Gain Factor Non Sub', ''),  # noqa
        '2001xx2a': ('CS', '1', 'Edge Enhancement Taste Adapt Sub', ''),  # noqa
        '2001xx2b': ('CS', '1', 'Edge Enhancement Taste Non Sub', ''),  # noqa
        '2001xx2c': ('FL', '1', 'Harmonization Factor', ''),  # noqa
        '2001xx2d': ('SS', '1', 'Number of Stack Slices', ''),  # noqa
        '2001xx2f': ('FL', '1', 'Harmonization Gain', ''),  # noqa
        '2001xx30': ('UL', '1', 'Log Subtraction Gain Step', ''),  # noqa
        '2001xx31': ('US', '1', 'Mixing NR of Mask Image Numbers', ''),  # noqa
        '2001xx32': ('FL', '1-n', 'Stack Radial Angle', ''),  # noqa
        '2001xx33': ('CS', '1-n', 'Stack Radial Axis', ''),  # noqa
        '2001xx34': ('CS', '1', 'Mixing Mask Operation', ''),  # noqa
        '2001xx35': ('SS', '1-n', 'Stack Slice Number', ''),  # noqa
        '2001xx36': ('CS', '1-n', 'Stack Type', ''),  # noqa
        '2001xx37': ('CS', '1', 'Mixing Operation Type', ''),  # noqa
        '2001xx39': ('FL', '1', 'Unknown', ''),  # noqa
        '2001xx3a': ('CS', '1', 'Pixel Shift', ''),  # noqa
        '2001xx3d': ('UL', '1', 'Unknown', ''),  # noqa
        '2001xx3f': ('CS', '1', 'Interpolation Method', ''),  # noqa
        '2001xx42': ('CS', '1', 'Subtraction Land Marking Active', ''),  # noqa
        '2001xx46': ('CS', '1', 'Graphic Line Style', ''),  # noqa
        '2001xx47': ('FL', '1', 'Graphic Line Width', ''),  # noqa
        '2001xx48': ('SS', '1', 'Graphic Annotation ID', ''),  # noqa
        '2001xx4b': ('CS', '1', 'Poly Line Interpolation Method', ''),  # noqa
        '2001xx4c': ('CS', '1', 'Poly Line Begin Point Style', ''),  # noqa
        '2001xx4d': ('CS', '1', 'Poly Line End Point Style', ''),  # noqa
        '2001xx4e': ('CS', '1', 'Window Smoothing Taste', ''),  # noqa
        '2001xx4f': ('FD', '1', 'Harmonization Offset', ''),  # noqa
        '2001xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '2001xx52': ('UI', '1', 'Unknown', ''),  # noqa
        '2001xx53': ('CS', '1', 'Window Invert', ''),  # noqa
        '2001xx55': ('CS', '1', 'Graphic Line Color', ''),  # noqa
        '2001xx56': ('CS', '1', 'Graphic Type (Private)', ''),  # noqa
        '2001xx5a': ('ST', '1', 'Graphic Annotation Model', ''),  # noqa
        '2001xx5d': ('ST', '1', 'Measurement Text Units', ''),  # noqa
        '2001xx5e': ('ST', '1', 'Measurement Text Type', ''),  # noqa
        '2001xx5f': ('SQ', '1', 'Stack Sequence', ''),  # noqa
        '2001xx60': ('SL', '1', 'Number of Stacks', ''),  # noqa
        '2001xx61': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx62': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx63': ('CS', '1', 'Examination Source', ''),  # noqa
        '2001xx64': ('SH', '1', 'Text Type', ''),  # noqa
        '2001xx65': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx67': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx68': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx69': ('SQ', '1', 'Display Shutter Sequence', ''),  # noqa
        '2001xx6a': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx6b': ('SQ', '1', 'Has Edge Enhancement Sequence', ''),  # noqa
        '2001xx6d': ('LO', '1', 'Text Font', ''),  # noqa
        '2001xx6e': ('SH', '1', 'Series Type', ''),  # noqa
        '2001xx6f': ('SQ', '1', 'Mixing Sequence', ''),  # noqa
        '2001xx71': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx73': ('SQ', '1', 'Referenced Mask Image Sequence', ''),  # noqa
        '2001xx74': ('DS', '1-n', 'Window Center Sub', ''),  # noqa
        '2001xx75': ('DS', '1-n', 'Window Width Sub', ''),  # noqa
        '2001xx76': ('UL', '1', 'Unknown', ''),  # noqa
        '2001xx77': ('CS', '1', 'GL TrafoType', ''),  # noqa
        '2001xx79': ('SQ', '1', 'Harmonisation Sequence', ''),  # noqa
        '2001xx7a': ('FL', '1', 'Unknown', ''),  # noqa
        '2001xx7b': ('IS', '1', 'Acquisition Number', ''),  # noqa
        '2001xx7e': ('US', '1', 'Edge Enhancement Gain Taste', ''),  # noqa
        '2001xx7f': ('US', '1', 'Edge Enhancement Gain Taste Sub', ''),  # noqa
        '2001xx80': ('LO', '1', 'Text Anchor Point Alignment', ''),  # noqa
        '2001xx81': ('IS', '1', 'Number of Dynamic Scans', ''),  # noqa
        '2001xx82': ('IS', '1', 'Echo Train Length', ''),  # noqa
        '2001xx83': ('DS', '1', 'Imaging Frequency', ''),  # noqa
        '2001xx84': ('DS', '1', 'Inversion Time', ''),  # noqa
        '2001xx85': ('DS', '1', 'Magnetic Field Strength', ''),  # noqa
        '2001xx86': ('IS', '1', 'Unknown', ''),  # noqa
        '2001xx87': ('SH', '1', 'Imaged Nucleus', ''),  # noqa
        '2001xx88': ('DS', '1', 'Number of Averages', ''),  # noqa
        '2001xx89': ('DS', '1', 'Phase FOV Percent', ''),  # noqa
        '2001xx8a': ('DS', '1', 'Sampling Percent', ''),  # noqa
        '2001xx8b': ('SH', '1', 'Unknown', ''),  # noqa
        '2001xx93': ('LO', '1', 'Text Style', ''),  # noqa
        '2001xx94': ('LO', '1', 'Processing Order Specialization', ''),  # noqa
        '2001xx97': ('SH', '1', 'Nucleus', ''),  # noqa
        '2001xx9a': ('SQ', '1', 'Graphic Number Sequence', ''),  # noqa
        '2001xx9b': ('UL', '1', 'Graphic Number', ''),  # noqa
        '2001xx9c': ('LO', '1', 'Unknown', ''),  # noqa
        '2001xx9d': ('LO', '1', 'PIIM Subtraction Type', ''),  # noqa
        '2001xx9f': ('US', '2', 'Pixel Processing Kernel Size', ''),  # noqa
        '2001xxa1': ('CS', '1', 'Is Raw Image', ''),  # noqa
        '2001xxa2': ('US', '1', 'LOG Subtraction Curve Taste', ''),  # noqa
        '2001xxa3': ('UL', '1', 'Text Color Foreground', ''),  # noqa
        '2001xxa4': ('UL', '1', 'Text Color Background', ''),  # noqa
        '2001xxa5': ('UL', '1', 'Text Color Shadow', ''),  # noqa
        '2001xxc1': ('LO', '1', 'Nested Object Type Name', ''),  # noqa
        '2001xxcc': ('ST', '1', 'Unknown', ''),  # noqa
        '2001xxda': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xxf1': ('FL', '1-n', 'Prospective Motion Correction', ''),  # noqa
        '2001xxf2': ('FL', '1', 'Retrospective Motion Correction', ''),  # noqa
        '2005xx14': ('CS', '1', 'Diffusion', ''),  # noqa
        '2005xx20': ('SL', '1', 'Number of Chemical Shifts', ''),  # noqa
        '2005xx30': ('FL', '1', 'Repetition Time', ''),  # noqa
        '2005xx33': ('FL', '1', 'Scan Duration', ''),  # noqa
        '2005xx35': ('CS', '1', 'Data Type', ''),  # noqa
        '2005xx8b': ('SH', '1', 'Transmitting Coil', ''),  # noqa
        '2005xx9f': ('CS', '1', 'Spectral Selective Excitation Pulse', ''),  # noqa
        '2005xxa1': ('CS', '1', 'Syncra Scan Type', ''),  # noqa
    },
    'Philips Imaging DD 002': {
        '2001xx01': ('US', '1', 'Unknown', ''),  # noqa
        '2001xx02': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx13': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx14': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx15': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx16': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx17': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx18': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx19': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx1a': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx1b': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx1c': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx1d': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx1e': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx1f': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx20': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx21': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx22': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx23': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx24': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx25': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx26': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx27': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx28': ('US', '1', 'Unknown', ''),  # noqa
        '2001xx29': ('US', '1', 'Unknown', ''),  # noqa
        '2001xx2a': ('US', '1', 'Unknown', ''),  # noqa
        '2001xx2b': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx2c': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx2d': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx2e': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx2f': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx30': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx31': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx32': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx33': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx34': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx35': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx36': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx37': ('FD', '1', 'Unknown', ''),  # noqa
        '2001xx39': ('CS', '1', 'Unknown', ''),  # noqa
        '2001xx3a': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx3b': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx3c': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx3d': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx3e': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx3f': ('SS', '1', 'Unknown', ''),  # noqa
        '2001xx40': ('SS', '1', 'Unknown', ''),  # noqa
    },
    'Philips Imaging DD 065': {
        '4007xx00': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'Philips Imaging DD 067': {
        '4001xx00': ('SQ', '1', 'Unknown', ''),  # noqa
        '4001xx01': ('CS', '1', 'Unknown', ''),  # noqa
        '4001xx08': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'Philips Imaging DD 070': {
        '4001xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '4001xx11': ('SQ', '1', 'Unknown', ''),  # noqa
        '4001xx12': ('SQ', '1', 'Unknown', ''),  # noqa
        '4001xx16': ('ST', '1', 'Unknown', ''),  # noqa
        '4001xx17': ('ST', '1', 'Unknown', ''),  # noqa
        '4001xx18': ('ST', '1', 'Unknown', ''),  # noqa
        '4001xx1c': ('SQ', '1', 'Unknown', ''),  # noqa
        '4001xx1d': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'Philips Imaging DD 073': {
        '4007xx48': ('FL', '1', 'Unknown', ''),  # noqa
    },
    'Philips Imaging DD 129': {
        '2001xx00': ('SQ', '1', 'Unknown', ''),  # noqa
        '2001xx01': ('SQ', '1', 'Unknown', ''),  # noqa
    },
    'Philips MR Imaging DD 001': {
        '2005xx00': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx01': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx02': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx04': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx05': ('CS', '1', 'Synergy Reconstruction Type', ''),  # noqa
        '2005xx08': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx09': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx0a': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx0b': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx0c': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx0d': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx0e': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx0f': ('DS', '1', 'Window Center', ''),  # noqa
        '2005xx10': ('DS', '1', 'Window Width', ''),  # noqa
        '2005xx11': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx12': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx13': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx14': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx15': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx16': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx17': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx18': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx19': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx1a': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx1b': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx1c': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx1d': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx1e': ('SH', '1', 'Unknown', ''),  # noqa
        '2005xx1f': ('SH', '1', 'Unknown', ''),  # noqa
        '2005xx20': ('SL', '1', 'Number of Chemical Shift', ''),  # noqa
        '2005xx21': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx22': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx23': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx25': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx26': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx27': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx28': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx29': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx2a': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx2b': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx2c': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx2d': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx2e': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx2f': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx30': ('FL', '1', 'Repetition Time', ''),  # noqa
        '2005xx31': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx32': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx33': ('FL', '1', 'Acquisition Duration', ''),  # noqa
        '2005xx34': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx35': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx36': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx37': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx38': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx39': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx3a': ('SH', '1', 'Unknown', ''),  # noqa
        '2005xx3b': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx3c': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx3d': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx3e': ('SL', '1-n', 'Unknown', ''),  # noqa
        '2005xx48': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx49': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx4a': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx4b': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx4c': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx4d': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx4e': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx4f': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx50': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx51': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx52': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx53': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx54': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx55': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx56': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx57': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx58': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx59': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx5a': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx5b': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx5c': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx5d': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx5e': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx5f': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx60': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx61': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx63': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx64': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx65': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx66': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx67': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx68': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx69': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx6a': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx6b': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx6c': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx6d': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx6e': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx6f': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx70': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx71': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx72': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx73': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx74': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx75': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx76': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx78': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx79': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx7a': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx7b': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx7e': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx80': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx81': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx83': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx84': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx85': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx86': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx9e': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx9f': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xxa0': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xxa1': ('CS', '1', 'Syncra Scan Type', ''),  # noqa
        '2005xxa2': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xxa3': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xxa4': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xxa5': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xxa6': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xxa7': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xxa8': ('DS', '1', 'Unknown', ''),  # noqa
        '2005xxa9': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xxb0': ('FL', '1', 'Diffusion Direction RL', ''),  # noqa
        '2005xxb1': ('FL', '1', 'Diffusion Direction AP', ''),  # noqa
        '2005xxb2': ('FL', '1', 'Diffusion Direction FH', ''),  # noqa
        '2005xxc0': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'Philips MR Imaging DD 002': {
        '2005xx32': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx37': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx38': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx39': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx40': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx41': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx43': ('SL', '1', 'Unknown', ''),  # noqa
        '2005xx44': ('OW', '1', 'Unknown', ''),  # noqa
        '2005xx47': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx99': ('UL', '1', 'Unknown', ''),  # noqa
    },
    'Philips MR Imaging DD 003': {
        '2005xx00': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx01': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx13': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx34': ('SL', '1', 'Unknown', ''),  # noqa
        '2005xx45': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx49': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx51': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx52': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx53': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx56': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx57': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx81': ('UI', '1', 'Unknown', ''),  # noqa
        '2005xx82': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'Philips MR Imaging DD 004': {
        '2005xx00': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx01': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx02': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx03': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx04': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx05': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx06': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx07': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx08': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx09': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx10': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx12': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx13': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx14': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx15': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx16': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx17': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx25': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx26': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx27': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx28': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx29': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx30': ('CS', '1-n', 'Unknown', ''),  # noqa
        '2005xx31': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx33': ('FL', '3', 'Unknown', ''),  # noqa
        '2005xx34': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx35': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx36': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx37': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx38': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx39': ('SS', '2', 'Unknown', ''),  # noqa
        '2005xx40': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx41': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx42': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx43': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx44': ('SS', '1-n', 'Unknown', ''),  # noqa
        '2005xx45': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx46': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx47': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx48': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx49': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx50': ('FL', '2', 'Unknown', ''),  # noqa
        '2005xx51': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx52': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx53': ('LO', '1-n', 'Unknown', ''),  # noqa
        '2005xx54': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx55': ('FL', '1-n', 'Unknown', ''),  # noqa
        '2005xx56': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx57': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx58': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx59': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx60': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx61': ('FL', '2', 'Unknown', ''),  # noqa
        '2005xx62': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx63': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx64': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx70': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx71': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx72': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx73': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx74': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx75': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx76': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx77': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx78': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx79': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx81': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx82': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx89': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx90': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx91': ('PN', '1', 'Unknown', ''),  # noqa
        '2005xx92': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx93': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx95': ('UI', '1', 'Unknown', ''),  # noqa
        '2005xx96': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx97': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx98': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx99': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'Philips MR Imaging DD 005': {
        '2005xx00': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx01': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx02': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx03': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx06': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx07': ('SS', '1', 'Unknown', ''),  # noqa
        '2005xx09': ('DS', '1', 'Unknown', ''),  # noqa
        '2005xx0a': ('DS', '1', 'Unknown', ''),  # noqa
        '2005xx0b': ('LO', '1', 'Unknown', ''),  # noqa
        '2005xx0e': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx0f': ('SQ', '1', 'Unknown', ''),  # noqa
        '2005xx10': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx11': ('UI', '1', 'Unknown', ''),  # noqa
        '2005xx12': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx13': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx14': ('SL', '1', 'Unknown', ''),  # noqa
        '2005xx15': ('SL', '1', 'Unknown', ''),  # noqa
        '2005xx16': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx18': ('CS', '3', 'Unknown', ''),  # noqa
        '2005xx19': ('CS', '3', 'Unknown', ''),  # noqa
        '2005xx1a': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx1b': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx1c': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx1d': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx1e': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx1f': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx20': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx21': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx22': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx23': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx24': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx25': ('UL', '1', 'Unknown', ''),  # noqa
        '2005xx26': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx27': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx28': ('SL', '1', 'Unknown', ''),  # noqa
        '2005xx2a': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx2b': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx2c': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx2d': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx2e': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx2f': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx30': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx31': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx32': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx35': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx36': ('UI', '1', 'Unknown', ''),  # noqa
        '2005xx37': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx38': ('LT', '1', 'Unknown', ''),  # noqa
        '2005xx39': ('LT', '1', 'Unknown', ''),  # noqa
        '2005xx3a': ('LT', '1', 'Unknown', ''),  # noqa
        '2005xx3b': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx3c': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx3d': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx3e': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx3f': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx40': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx41': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx42': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx43': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx44': ('IS', '1', 'Unknown', ''),  # noqa
        '2005xx45': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx46': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx47': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx48': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx49': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx4a': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx4b': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx4c': ('FL', '1', 'Unknown', ''),  # noqa
        '2005xx4d': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx4e': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx4f': ('CS', '1', 'Unknown', ''),  # noqa
        '2005xx50': ('SS', '1', 'Unknown', ''),  # noqa
    },
    'Philips NM Private Group': {
        '7043xx00': ('SH', '1', 'Unknown', ''),  # noqa
    },
    'Philips PET Private Group': {
        '0511xx00': ('US', '1', 'Unknown', ''),  # noqa
        '0511xx01': ('US', '1', 'Unknown', ''),  # noqa
        '0511xx02': ('OB', '1', 'Unknown', ''),  # noqa
        '0511xx03': ('OB', '1', 'Unknown', ''),  # noqa
        '0511xx32': ('DS', '1', 'Unknown', ''),  # noqa
        '0511xx50': ('DS', '1', 'Unknown', ''),  # noqa
        '7053xx00': ('DS', '1', 'SUV Scale Factor', ''),  # noqa
        '7053xx01': ('OB', '1', 'Private', ''),  # noqa
        '7053xx02': ('OB', '1', 'Private', ''),  # noqa
        '7053xx03': ('ST', '1', 'Original image file name', ''),  # noqa
        '7053xx04': ('OB', '1', 'File Data', ''),  # noqa
        '7053xx05': ('LO', '1', 'Worklist Info File Name', ''),  # noqa
        '7053xx06': ('OB', '1', 'Unknown', ''),  # noqa
        '7053xx07': ('SQ', '1', 'Acquisition File Sequence', ''),  # noqa
        '7053xx08': ('SQ', '1', 'Unknown', ''),  # noqa
        '7053xx09': ('DS', '1', 'Activity Concentration Scale Factor', ''),  # noqa
        '7053xx0f': ('UL', '1', 'Segment Size', ''),  # noqa
        '7053xx10': ('US', '1', 'Segment Number', ''),  # noqa
        '7053xx11': ('US', '1', 'Number of Segments', ''),  # noqa
        '7053xx12': ('SQ', '1', 'File Data Sequence', ''),  # noqa
        '7053xx13': ('SS', '1', 'Unknown', ''),  # noqa
        '7053xx14': ('SS', '1', 'Unknown', ''),  # noqa
        '7053xx15': ('SS', '1', 'Unknown', ''),  # noqa
        '7053xx16': ('SS', '1', 'Unknown', ''),  # noqa
        '7053xx17': ('SS', '1', 'Unknown', ''),  # noqa
        '7053xx18': ('SS', '1', 'Unknown', ''),  # noqa
        '7053xxc2': ('UI', '1', 'Unknown', ''),  # noqa
    },
    'Philips RAD Imaging DD 001': {
        '200bxx00': ('PN', '1', 'Unknown', ''),  # noqa
        '200bxx01': ('US', '1', 'Unknown', ''),  # noqa
        '200bxx02': ('US', '1', 'Unknown', ''),  # noqa
        '200bxx05': ('IS', '1', 'Unknown', ''),  # noqa
        '200bxx11': ('LO', '1', 'Unknown', ''),  # noqa
        '200bxx27': ('DT', '1', 'Unknown', ''),  # noqa
        '200bxx28': ('DS', '1', 'Unknown', ''),  # noqa
        '200bxx29': ('DS', '1', 'Unknown', ''),  # noqa
        '200bxx2a': ('UL', '1', 'Unknown', ''),  # noqa
        '200bxx2b': ('DA', '1', 'Unknown', ''),  # noqa
        '200bxx2c': ('TM', '1', 'Unknown', ''),  # noqa
        '200bxx2d': ('LO', '1', 'Unknown', ''),  # noqa
        '200bxx3b': ('LO', '1', 'Unknown', ''),  # noqa
        '200bxx40': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx41': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx42': ('UI', '1', 'Unknown', ''),  # noqa
        '200bxx43': ('UI', '1', 'Unknown', ''),  # noqa
        '200bxx47': ('DA', '1', 'Unknown', ''),  # noqa
        '200bxx48': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx4c': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx4d': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx4f': ('DT', '1', 'Unknown', ''),  # noqa
        '200bxx52': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'Philips RAD Imaging DD 097': {
        '200bxx00': ('ST', '1', 'Unknown', ''),  # noqa
        '200bxx01': ('CS', '1', 'Unknown', ''),  # noqa
        '200bxx02': ('SS', '1', 'Unknown', ''),  # noqa
        '200bxx50': ('SS', '1', 'Unknown', ''),  # noqa
        '200bxx51': ('SS', '1', 'Unknown', ''),  # noqa
        '200bxx52': ('SS', '1', 'Unknown', ''),  # noqa
        '200bxx53': ('SS', '1', 'Unknown', ''),  # noqa
        '200bxx54': ('ST', '1', 'Unknown', ''),  # noqa
        '200bxx60': ('LT', '1', 'Unknown', ''),  # noqa
        '200bxx63': ('LT', '1', 'Unknown', ''),  # noqa
        '200bxx65': ('SS', '1', 'Unknown', ''),  # noqa
        '200bxx6e': ('US', '1', 'Unknown', ''),  # noqa
        '200bxx72': ('FD', '1', 'Unknown', ''),  # noqa
        '200bxx73': ('SS', '1', 'Unknown', ''),  # noqa
        '200bxx74': ('IS', '1', 'Unknown', ''),  # noqa
        '200bxx75': ('CS', '1', 'Unknown', ''),  # noqa
        '200bxx76': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx78': ('IS', '1-n', 'Unknown', ''),  # noqa
        '200bxx79': ('IS', '1', 'Unknown', ''),  # noqa
        '200bxx7a': ('IS', '1', 'Unknown', ''),  # noqa
        '200bxx7b': ('US', '1', 'Unknown', ''),  # noqa
        '200bxx7c': ('US', '1', 'Unknown', ''),  # noqa
        '200bxx7d': ('IS', '1-n', 'Unknown', ''),  # noqa
        '200bxx7e': ('UI', '1', 'Unknown', ''),  # noqa
        '200bxx81': ('LO', '1', 'Unknown', ''),  # noqa
        '200bxx82': ('LO', '1', 'Unknown', ''),  # noqa
        '200bxx85': ('IS', '1', 'Unknown', ''),  # noqa
        '200bxx86': ('CS', '1', 'Unknown', ''),  # noqa
        '200bxx88': ('CS', '1', 'Unknown', ''),  # noqa
        '200bxx89': ('LT', '1', 'Unknown', ''),  # noqa
        '200bxx90': ('DS', '1', 'Unknown', ''),  # noqa
        '200bxx96': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx99': ('SH', '1', 'Unknown', ''),  # noqa
        '200bxx9a': ('FD', '1', 'Unknown', ''),  # noqa
        '200bxx9b': ('FD', '1', 'Unknown', ''),  # noqa
        '200bxxa0': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging 60': {
        '0031xx30': ('UL', '1', 'Private data', ''),  # noqa
        '0031xx31': ('UL', '1', 'Private data', ''),  # noqa
    },
    'Philips US Imaging DD 017': {
        '200dxx05': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 023': {
        '200dxx37': ('DA', '1', 'Unknown', ''),  # noqa
        '200dxx38': ('TM', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 033': {
        '200dxx01': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx02': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx03': ('LO', '6', 'Unknown', ''),  # noqa
        '200dxx04': ('LO', '6', 'Unknown', ''),  # noqa
        '200dxx05': ('LO', '1-n', 'Unknown', ''),  # noqa
        '200dxx06': ('LO', '6', 'Unknown', ''),  # noqa
        '200dxx07': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx08': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx09': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0a': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0b': ('OB', '1', 'Raw Data US', ''),  # noqa
        '200dxx14': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 034': {
        '200dxx01': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx02': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx03': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx04': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx05': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx06': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx07': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx08': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx09': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0a': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0b': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0c': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0d': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0e': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0f': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx10': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx21': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx22': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx23': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx24': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 035': {
        '200dxx01': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx02': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx03': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx04': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx05': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx07': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx08': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx09': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0a': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0b': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0c': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0d': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 036': {
        '200dxx01': ('LO', '3', 'Cols/Rows/Frames', ''),  # noqa
        '200dxx02': ('LO', '3', 'Cols/Rows/Frames', ''),  # noqa
        '200dxx03': ('LO', '3', 'Voxel Spacing', ''),  # noqa
        '200dxx04': ('LO', '3', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 038': {
        '200dxx01': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 039': {
        '200dxx01': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx04': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx05': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx06': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx07': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx08': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx09': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0a': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0b': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0c': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx0d': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 040': {
        '200dxx01': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx02': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx03': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx04': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx05': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx06': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx07': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx20': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 041': {
        '200dxx1e': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 042': {
        '200dxx50': ('LO', '3', 'Unknown', ''),  # noqa
        '200dxx51': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx52': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx53': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx54': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx55': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx56': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx57': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx58': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx59': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx5a': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx5b': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx5c': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx5d': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx5e': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx5f': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx60': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx70': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx71': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx72': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx73': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx74': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx75': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx76': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx77': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 043': {
        '200dxx05': ('SH', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 109': {
        '200dxx00': ('US', '1', 'Unknown', ''),  # noqa
        '200dxx01': ('SQ', '1', 'Unknown', ''),  # noqa
        '200dxx02': ('ST', '1', 'Unknown', ''),  # noqa
        '200dxx03': ('CS', '1', 'Unknown', ''),  # noqa
        '200dxx04': ('SL', '4', 'Unknown', ''),  # noqa
        '200dxx05': ('UL', '3', 'Unknown', ''),  # noqa
        '200dxx06': ('UL', '3', 'Unknown', ''),  # noqa
        '200dxx07': ('CS', '1', 'Unknown', ''),  # noqa
        '200dxx08': ('CS', '1', 'Unknown', ''),  # noqa
        '200dxx09': ('OB', '1', 'Unknown', ''),  # noqa
        '200dxx0a': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx0b': ('OB', '1', 'Unknown', ''),  # noqa
        '200dxx0c': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx0d': ('SQ', '1', 'Unknown', ''),  # noqa
        '200dxx0e': ('CS', '1', 'Unknown', ''),  # noqa
        '200dxx0f': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx10': ('SL', '1', 'Unknown', ''),  # noqa
        '200dxx11': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx12': ('SL', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Imaging DD 113': {
        '200dxx01': ('LO', '1', 'Unknown', ''),  # noqa
        '200dxx02': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx03': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx04': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx05': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx06': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx07': ('CS', '1', 'Unknown', ''),  # noqa
        '200dxx09': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx0b': ('CS', '1', 'Unknown', ''),  # noqa
        '200dxx0c': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx0d': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx0e': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx0f': ('DS', '1', 'Unknown', ''),  # noqa
        '200dxx10': ('DS', '1', 'Unknown', ''),  # noqa
        '200dxx11': ('SL', '1', 'Unknown', ''),  # noqa
        '200dxx12': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx13': ('FL', '1-n', 'Unknown', ''),  # noqa
        '200dxx14': ('US', '1', 'Unknown', ''),  # noqa
        '200dxx15': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx17': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx18': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx19': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx1a': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx1b': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx1c': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx1d': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx1e': ('UL', '1', 'Unknown', ''),  # noqa
        '200dxx1f': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx20': ('FD', '1', 'Unknown', ''),  # noqa
        '200dxx21': ('FD', '1', 'Unknown', ''),  # noqa
    },
    'Philips US Private 3D': {
        '200dxx02': ('IS', '1', 'Threedpr Echo Vision Setting', ''),  # noqa
        '200dxx03': ('IS', '1', 'Threedpr Color Vision Setting', ''),  # noqa
        '200dxx04': ('IS', '1', 'Threedpr Transparency', ''),  # noqa
        '200dxx06': ('FD', '1', 'Threedpr Vision Vol Brightness', ''),  # noqa
        '200dxx08': ('IS', '1', 'Threedpr Low Threshold', ''),  # noqa
        '200dxx09': ('IS', '1', 'Threedpr Image Layout', ''),  # noqa
        '200dxx0a': ('IS', '1', 'Threedpr Xres Filtering Enabled', ''),  # noqa
        '200dxx0b': ('IS', '1', 'Threedpr Echo Twod Chroma Map Enabled', ''),  # noqa
        '200dxx0c': ('IS', '1', 'Threedpr Box Outlined Enabled', ''),  # noqa
        '200dxx0d': ('IS', '1', 'Threedpr Smoothing Enabled', ''),  # noqa
        '200dxx0e': ('IS', '1', 'Threedpr Reference Graphic Enabled', ''),  # noqa
        '200dxx0f': ('IS', '1', 'Threedpr Map Inverted', ''),  # noqa
        '200dxx10': ('IS', '1', 'Threedpr Color Stream Display Enabled', ''),  # noqa
        '200dxx11': ('IS', '1', 'Threedpr Echo Stream Display Enabled', ''),  # noqa
        '200dxx12': ('LO', '1', 'Vdb Param Color 3d Estimate Scale(2)', ''),  # noqa
        '200dxx13': ('LO', '1', 'Vdb Param Color 3d Estimate Apex Position (1)', ''),  # noqa
        '200dxx14': ('LO', '1', 'Vdb Param Color 3d Estimate Color Offset', ''),  # noqa
        '200dxx15': ('LO', '1', 'Vdb Param Echo 3d Estimate Dimension(2)', ''),  # noqa
        '200dxx16': ('SQ', '1', 'Private Native Threed Data Sequence(1)', ''),  # noqa
        '200dxx17': ('IS', '1', 'Threedpr Basic Vol Brightness', ''),  # noqa
        '200dxx18': ('LO', '1', 'Vdb Param Echo 3d Estimate Apex Position (2)', ''),  # noqa
        '200dxx1a': ('IS', '1', 'Threedpr Echo Smoothing', ''),  # noqa
        '200dxx1b': ('IS', '1', 'Threedpr Color Smoothing', ''),  # noqa
        '200dxx1e': ('IS', '1', 'Threedpr Num Completed Trim Planes', ''),  # noqa
        '200dxx1f': ('IS', '1', 'Threedpr Depth', ''),  # noqa
        '200dxx20': ('SQ', '1', 'Private Native Data Stream Array', ''),  # noqa
        '200dxx21': ('IS', '1', 'Threedpr Wall Filter', ''),  # noqa
        '200dxx23': ('FD', '1', 'Threedpr Baseline', ''),  # noqa
        '200dxx24': ('FD', '1', 'Threedpr Gain', ''),  # noqa
        '200dxx25': ('FD', '1', 'Threedpr Compress', ''),  # noqa
        '200dxx26': ('FD', '1', 'Threedpr Light Brightness', ''),  # noqa
        '200dxx27': ('FD', '1', 'Threedpr Elevation Scale Factor', ''),  # noqa
        '200dxx28': ('FD', '1', 'Threedpr Zoom Factor', ''),  # noqa
        '200dxx29': ('FD', '1', 'Threedpr Color Write Priority', ''),  # noqa
        '200dxx2a': ('FD', '1', 'Threedpr Rotation Angle X', ''),  # noqa
        '200dxx2b': ('FD', '1', 'Threedpr Rotation Angle Y', ''),  # noqa
        '200dxx2c': ('FD', '1', 'Threedpr Data Voi Center', ''),  # noqa
        '200dxx2d': ('FD', '1', 'Threedpr View Translation', ''),  # noqa
        '200dxx2e': ('FD', '1', 'Threedpr Data Voi Min Point', ''),  # noqa
        '200dxx2f': ('FD', '1', 'Threedpr Data Voi Max Point', ''),  # noqa
        '200dxx30': ('FD', '1', 'Threedpr Box Crop Min Point', ''),  # noqa
        '200dxx31': ('FD', '1', 'Threedpr Box Crop Max Point', ''),  # noqa
        '200dxx32': ('FD', '1', 'Threedpr Mpr Rotation Matrix', ''),  # noqa
        '200dxx33': ('FD', '1', 'Threedpr Vol Rotation Matrix', ''),  # noqa
        '200dxx34': ('FD', '1', 'Threedpr Trim Plane Equation', ''),  # noqa
        '200dxx35': ('IS', '1', 'Threedpr Subpage Data Version', ''),  # noqa
        '200dxx36': ('IS', '1', 'Threedpr Is Arbitrary Crop', ''),  # noqa
        '200dxx37': ('IS', '1', 'Threedpr Arbitrary Crop Dist From Center', ''),  # noqa
        '200dxx38': ('FD', '1', 'Threedpr Arbitrary Crop Rotation Matrix', ''),  # noqa
        '200dxx39': ('FD', '1', 'Threedpr Color Gain', ''),  # noqa
        '200dxx40': ('IS', '1', 'Threedpr Color Wall Filter Index', ''),  # noqa
        '200dxx41': ('IS', '1', 'Threedpr Cursor Enabled', ''),  # noqa
        '200dxx42': ('IS', '1', 'Threedpr Bondbox Graphic Enabled', ''),  # noqa
    },
    'Philips X-ray Imaging DD 001': {
        '2003xx00': ('CS', '1', 'Unknown', ''),  # noqa
        '2003xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '2003xx02': ('FD', '3', 'Unknown', ''),  # noqa
        '2003xx03': ('LO', '1', 'Unknown', ''),  # noqa
        '2003xx04': ('SQ', '1', 'Private enhanced Table Sequence', ''),  # noqa
        '2003xx06': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx09': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '2003xx11': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx12': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx13': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx14': ('FD', '1', 'Unknown', ''),  # noqa
        '2003xx15': ('FD', '1', 'Unknown', ''),  # noqa
        '2003xx16': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx17': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx18': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx19': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx22': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx24': ('FD', '4', 'Unknown', ''),  # noqa
        '2003xx25': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx26': ('SL', '1', 'Unknown', ''),  # noqa
        '2003xx27': ('SH', '1', 'Unknown', ''),  # noqa
        '2003xx28': ('SH', '1', 'Unknown', ''),  # noqa
        '2003xx29': ('FD', '1', 'Unknown', ''),  # noqa
        '2003xx2a': ('LO', '1', 'Unknown', ''),  # noqa
        '2003xx2b': ('FD', '1', 'Unknown', ''),  # noqa
        '2003xx2c': ('SH', '1', 'Unknown', ''),  # noqa
        '2003xx2d': ('SL', '1-n', 'Unknown', ''),  # noqa
        '2003xx2e': ('SQ', '1', 'Unknown', ''),  # noqa
        '2003xx2f': ('CS', '1', 'IsResolvePatientMixApplied', ''),  # noqa
        '2003xx30': ('CS', '1', 'Unknown', ''),  # noqa
        '2003xx31': ('CS', '1', 'Unknown', ''),  # noqa
        '2003xx32': ('UI', '1', 'Unknown', ''),  # noqa
    },
    'Picker MR Private Group': {
        '7101xx00': ('OB', '1', 'Unknown', ''),  # noqa
        '7101xx01': ('SL', '1', 'Unknown', ''),  # noqa
        '7101xx02': ('OB', '1', 'Unknown', ''),  # noqa
        '7101xx03': ('SL', '1', 'Unknown', ''),  # noqa
        '7101xx04': ('SH', '1', 'Unknown', ''),  # noqa
        '7101xx05': ('SH', '2', 'Unknown', ''),  # noqa
        '7101xx06': ('SH', '4', 'Unknown', ''),  # noqa
        '7101xx10': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'Picker NM Private Group': {
        '7001xx01': ('UI', '1', 'Private', ''),  # noqa
        '7001xx02': ('OB', '1', 'Private', ''),  # noqa
        '7001xx03': ('OB', '1', 'Private', ''),  # noqa
        '7001xx04': ('OB', '1', 'Private', ''),  # noqa
        '7001xx05': ('OB', '1', 'Private', ''),  # noqa
        '7001xx06': ('OB', '1', 'Private', ''),  # noqa
        '7001xx07': ('OB', '1', 'Private', ''),  # noqa
        '7001xx08': ('OB', '1', 'Private', ''),  # noqa
        '7001xx09': ('OB', '1', 'Private', ''),  # noqa
        '7001xx10': ('SQ', '1', 'Private', ''),  # noqa
        '7001xx11': ('LO', '1', 'Private', ''),  # noqa
        '7001xx12': ('OB', '1', 'Private', ''),  # noqa
        '7001xx13': ('US', '1', 'Private', ''),  # noqa
        '7001xx14': ('OB', '1', 'Private', ''),  # noqa
        '7001xx15': ('OB', '1', 'Private', ''),  # noqa
        '7001xx16': ('OB', '1', 'Private', ''),  # noqa
        '7001xx17': ('LO', '1', 'Contains a text string that includes some of the same information that appears on the Odyssey Clinical Index (image directory) for this Image.', ''),  # noqa
        '7043xx00': ('SH', '1', 'Private.', ''),  # noqa
    },
    'QCA': {
        '0009xx00': ('CS', '1', 'Analysis Type', ''),  # noqa
        '0009xx04': ('LO', '1', 'Segment Name', ''),  # noqa
        '0009xx12': ('DS', '1', 'Pre Catheter size', ''),  # noqa
        '0009xx13': ('DS', '1', 'Pre Reference Diameter', ''),  # noqa
        '0009xx14': ('DS', '1', 'Pre Minimum Lumen Diameter', ''),  # noqa
        '0009xx15': ('DS', '1', 'Pre Average Diameter', ''),  # noqa
        '0009xx16': ('DS', '1', 'Pre Stenosis Length', ''),  # noqa
        '0009xx17': ('DS', '1', 'Pre Stenosis %', ''),  # noqa
        '0009xx18': ('DS', '1', 'Pre Geometric Area Reduction %', ''),  # noqa
        '0009xx22': ('DS', '1', 'Post Catheter Size', ''),  # noqa
        '0009xx23': ('DS', '1', 'Post Reference Diameter', ''),  # noqa
        '0009xx24': ('DS', '1', 'Post Minimum Lumen Diameter', ''),  # noqa
        '0009xx25': ('DS', '1', 'Post Average Diameter', ''),  # noqa
        '0009xx26': ('DS', '1', 'Post Stenosis Length', ''),  # noqa
        '0009xx27': ('DS', '1', 'Post Stenosis %', ''),  # noqa
        '0009xx28': ('DS', '1', 'Post Geometric Area Reduction %', ''),  # noqa
    },
    'QCA_RESULTS': {
        '0009xx00': ('CS', '1', 'Analysis Views', ''),  # noqa
        '0009xx10': ('LO', '1', 'Segment', ''),  # noqa
        '0009xx11': ('LO', '1', 'Pre Catheter Name', ''),  # noqa
        '0009xx12': ('DS', '1', 'Pre Catheter Size', ''),  # noqa
        '0009xx13': ('DS', '1', 'Pre Reference Diameter', ''),  # noqa
        '0009xx14': ('DS', '1', 'Pre Minimum Lumen Diameter', ''),  # noqa
        '0009xx15': ('DS', '1', 'Pre Average Diameter', ''),  # noqa
        '0009xx16': ('DS', '1', 'Pre Stenosis Length', ''),  # noqa
        '0009xx17': ('IS', '1', 'Pre Stenosis %', ''),  # noqa
        '0009xx18': ('IS', '1', 'Pre Geometric Area Reduction %', ''),  # noqa
        '0009xx21': ('LO', '1', 'Post Catheter Name', ''),  # noqa
        '0009xx22': ('DS', '1', 'Post Catheter Size', ''),  # noqa
        '0009xx23': ('DS', '1', 'Post Reference Diameter', ''),  # noqa
        '0009xx24': ('DS', '1', 'Post Minimum Lumen Diameter', ''),  # noqa
        '0009xx25': ('DS', '1', 'Post Average Diameter', ''),  # noqa
        '0009xx26': ('DS', '1', 'Post Stenosis Length', ''),  # noqa
        '0009xx27': ('IS', '1', 'Post Stenosis %', ''),  # noqa
        '0009xx28': ('IS', '1', 'Post Geometric Area Reduction %', ''),  # noqa
        '0009xx40': ('IS', '1', 'Calibration Frame', ''),  # noqa
        '0009xx41': ('IS', '1', 'End Diastolic Frame', ''),  # noqa
        '0009xx42': ('IS', '1', 'End Systolic Frame', ''),  # noqa
        '0009xx43': ('DS', '1', 'End Diastolic Volume', ''),  # noqa
        '0009xx44': ('DS', '1', 'End Systolic Volume', ''),  # noqa
        '0009xx45': ('DS', '1', 'Stroke Volume', ''),  # noqa
        '0009xx47': ('DS', '1', 'Ejection Fraction', ''),  # noqa
        '0009xx48': ('DS', '1', 'Body Surface Area', ''),  # noqa
        '0009xx49': ('SH', '1', 'Artery Territory Region', ''),  # noqa
        '0009xx50': ('IS', '1', 'Number of Diseased Vessels', ''),  # noqa
        '0009xx51': ('DS', '1', 'Hypokinesis in Region', ''),  # noqa
        '0009xx52': ('DS', '1', 'Hyperkinesis in Opposite Region', ''),  # noqa
        '0009xx53': ('IS', '1', 'Percent Total LV Hypokinesis', ''),  # noqa
        '0009xx55': ('DS', '1', 'Calibration Factor', ''),  # noqa
    },
    'QUASAR_INTERNAL_USE': {
        '0009xx01': ('UL', '1-n', 'Rate Vector', ''),  # noqa
        '0009xx02': ('UL', '1-n', 'Count Vector', ''),  # noqa
        '0009xx03': ('UL', '1-n', 'Time Vector', ''),  # noqa
        '0009xx07': ('US', '1-n', 'Angle Vector', ''),  # noqa
        '0009xx08': ('US', '1', 'Camera Shape', ''),  # noqa
        '0009xx10': ('US', '1', 'WholeBody Spots', ''),  # noqa
        '0009xx11': ('US', '1', 'Worklist Flag', ''),  # noqa
        '0009xx12': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx13': ('ST', '1', 'Sequence Type', ''),  # noqa
        '0009xx14': ('ST', '1', 'Sequence Name', ''),  # noqa
        '0009xx15': ('UL', '1', 'Avr RR Time Vector', ''),  # noqa
        '0009xx16': ('UL', '1', 'Low Limit Vector', ''),  # noqa
        '0009xx17': ('UL', '1', 'High Limit Vector', ''),  # noqa
        '0009xx18': ('UL', '1', 'Begin Index Vector', ''),  # noqa
        '0009xx19': ('UL', '1', 'End Index Vector', ''),  # noqa
        '0009xx1a': ('UL', '1', 'Raw Time Vector', ''),  # noqa
        '0009xx1b': ('LO', '1', 'Image Type String', ''),  # noqa
        '0009xx1d': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx1e': ('ST', '1', 'Unknown', ''),  # noqa
        '0009xx22': ('FL', '1', 'Unknown', ''),  # noqa
        '0009xx23': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx39': ('UI', '1', 'Unknown', ''),  # noqa
        '0009xx40': ('DA', '1', 'Unknown', ''),  # noqa
        '0009xx41': ('TM', '1', 'Unknown', ''),  # noqa
        '0009xx42': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx44': ('SH', '1', 'Unknown', ''),  # noqa
        '0037xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '0037xx1b': ('LO', '1', 'Unknown', ''),  # noqa
        '0037xx30': ('LO', '1', 'Unknown', ''),  # noqa
        '0037xx40': ('LO', '1', 'Unknown', ''),  # noqa
        '0037xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '0037xx60': ('LO', '1', 'Unknown', ''),  # noqa
        '0037xx70': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'QVA': {
        '0009xx40': ('IS', '1', 'Calibration Frame', ''),  # noqa
        '0009xx41': ('IS', '1', 'End Diastolic Frame', ''),  # noqa
        '0009xx42': ('IS', '1', 'End Systolic Frame', ''),  # noqa
        '0009xx43': ('DS', '1', 'End Diastolic Volume', ''),  # noqa
        '0009xx44': ('DS', '1', 'End Systolic Volume', ''),  # noqa
        '0009xx45': ('DS', '1', 'Stroke Volume', ''),  # noqa
        '0009xx46': ('DS', '1', 'Cardiac Output', ''),  # noqa
        '0009xx47': ('DS', '1', 'Ejection Fraction', ''),  # noqa
        '0009xx48': ('DS', '1', 'Body Surface Area', ''),  # noqa
        '0009xx49': ('SH', '1', 'Artery Territory Region', ''),  # noqa
        '0009xx50': ('IS', '1', 'Number of Diseased Vessels', ''),  # noqa
        '0009xx51': ('DS', '1', 'Hypokinesis in Region', ''),  # noqa
        '0009xx52': ('DS', '1', 'Hyperkinesis in Region', ''),  # noqa
        '0009xx53': ('IS', '1', 'percent of chords with hyperkinesis <- 2 SD', ''),  # noqa
        '0009xx54': ('IS', '1', 'percent of chords with alkinesis/dyskinesis', ''),  # noqa
        '0009xx55': ('DS', '1', 'Calibration Factor', ''),  # noqa
    },
    'REPORT_FROM_APP': {
        '0039xx95': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'RadWorksMarconi': {
        '0029xx24': ('US', '1', '<internal', ''),  # noqa
    },
    'RadWorksTBR': {
        '3111xx02': ('CS', '1', 'AMI Compression Type (RET)', ''),  # noqa
        '3111xxff': ('SQ', '1', '<internal', ''),  # noqa
    },
    'SCHICK TECHNOLOGIES - Change Item Creator ID': {
        '0021xx01': ('UI', '1', 'Change List Item UID', ''),  # noqa
        '0021xx02': ('US', '1', 'Operation', ''),  # noqa
        '0021xx03': ('DT', '1', 'Date', ''),  # noqa
        '0021xx04': ('PN', '1', 'User Name', ''),  # noqa
        '0021xx05': ('OB', '1', 'Additional Change Data', ''),  # noqa
    },
    'SCHICK TECHNOLOGIES - Change List Creator ID': {
        '0021xx01': ('UI', '1', 'Reference Image Instance UID', ''),  # noqa
        '0021xx02': ('SQ', '1', 'Sequence', ''),  # noqa
    },
    'SCHICK TECHNOLOGIES - Image Security Creator ID': {
        '0029xx01': ('UL', '1', 'Image Checksum', ''),  # noqa
    },
    'SCHICK TECHNOLOGIES - Note Item Creator ID': {
        '0021xx01': ('ST', '1', 'Text', ''),  # noqa
        '0021xx02': ('DT', '1', 'Date', ''),  # noqa
        '0021xx03': ('PN', '1', 'User Name', ''),  # noqa
        '0021xx04': ('US', '2', 'Coordinates (X, Y)', ''),  # noqa
    },
    'SCHICK TECHNOLOGIES - Note List Creator ID': {
        '0021xx01': ('UI', '1', 'Reference Image Instance UID', ''),  # noqa
        '0021xx02': ('SQ', '1', 'Item', ''),  # noqa
    },
    'SCHICK TECHNOLOGIES - Viewset Creator ID': {
        '0009xx01': ('UI', '1', 'Instance UID', ''),  # noqa
        '0009xx02': ('LO', '1', 'Name', ''),  # noqa
        '0009xx03': ('SQ', '1', 'Sequence', ''),  # noqa
        '0009xx04': ('UL', '1', 'Mode', ''),  # noqa
        '0009xx05': ('UL', '1', 'Type', ''),  # noqa
    },
    'SCHICK TECHNOLOGIES - Viewset Item Creator ID': {
        '0009xx01': ('UI', '1', 'Image Instance UID', ''),  # noqa
        '0009xx02': ('US', '1', 'Number', ''),  # noqa
        '0009xx03': ('US', '1', 'Order', ''),  # noqa
        '0009xx04': ('US', '1', 'Type', ''),  # noqa
        '0009xx05': ('US', '1', 'Orientation', ''),  # noqa
        '0009xx06': ('US', '4', 'Rect (Left, Top, Width, Height)', ''),  # noqa
        '0009xx07': ('US', '1', 'Caption Height', ''),  # noqa
        '0009xx08': ('US', '1', 'Source', ''),  # noqa
        '0009xx09': ('US', '1', 'Default Width', ''),  # noqa
        '0009xx0a': ('US', '1', 'Default Height', ''),  # noqa
    },
    'SECTRA_Ident_01': {
        '0009xx01': ('LO', '1', 'Request number', ''),  # noqa
        '0009xx02': ('LO', '1', 'Examination number', ''),  # noqa
        '0009xx04': ('LO', '1', 'Series ID', ''),  # noqa
        '0009xx05': ('LO', '1', 'Series Order', ''),  # noqa
        '0009xx06': ('LO', '1', 'File Name', ''),  # noqa
        '0009xx07': ('LO', '1', 'Image Data ID', ''),  # noqa
    },
    'SECTRA_ImageInfo_01': {
        '0029xx01': ('OB', '1', 'Image info', ''),  # noqa
        '0029xx02': ('CS', '1', 'Marking', ''),  # noqa
        '0029xx03': ('LO', '1', 'No Decompression', ''),  # noqa
        '0029xx04': ('OB', '1', 'Image Info new', ''),  # noqa
    },
    'SECTRA_OverlayInfo_01': {
        '6001xx01': ('LO', '1', 'Sectra Overlay', ''),  # noqa
    },
    'SEGAMI MIML': {
        '0031xx98': ('OW', '1', 'Unknown', ''),  # noqa
    },
    'SEGAMI__MEMO': {
        '0035xx97': ('SH', '1', 'Unknown', ''),  # noqa
        '0035xx98': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'SET WINDOW': {
        '0019xx00': ('UN', '1', 'Set Window Image Filter', ''),  # noqa
        '0019xx01': ('UN', '1', 'Set Window Magnification Power', ''),  # noqa
    },
    'SHS MagicView 300': {
        '0029xx01': ('FD', '1-n', 'Zoom Factor', ''),  # noqa
        '0029xx02': ('FD', '1', 'Pan Factor X', ''),  # noqa
        '0029xx03': ('FD', '1', 'Pan Factor Y', ''),  # noqa
        '0029xx04': ('LO', '1', 'NmPalette', ''),  # noqa
    },
    'SIEMENS CM VA0  ACQU': {
        '0019xx10': ('LO', '1', 'Parameter File Name', ''),  # noqa
        '0019xx11': ('LO', '1', 'Sequence File Name', ''),  # noqa
        '0019xx12': ('LO', '1', 'Sequence File Owner', ''),  # noqa
        '0019xx13': ('LO', '1', 'Sequence Description', ''),  # noqa
        '0019xx14': ('LO', '1', 'EPI File Name', ''),  # noqa
        '0019xx20': ('LO', '1', 'Mode File Name', ''),  # noqa
        '0019xx30': ('LO', '1', 'Convolution Kernel Comment 1', ''),  # noqa
        '0019xx31': ('LO', '1', 'Convolution Kernel Comment 2', ''),  # noqa
        '0019xx32': ('LO', '1', 'Convolution Kernel Comment 3', ''),  # noqa
        '0019xx33': ('LO', '1', 'Convolution Kernel Comment 4', ''),  # noqa
        '0019xx34': ('LO', '1', 'Convolution Kernel Comment 5', ''),  # noqa
        '0019xx35': ('LO', '1', 'Convolution Kernel Comment 6', ''),  # noqa
        '0019xx36': ('LO', '1', 'Convolution Kernel Comment 7', ''),  # noqa
        '0019xx37': ('LO', '1', 'Convolution Kernel Comment 8', ''),  # noqa
        '0019xx38': ('LO', '1', 'Convolution Kernel Comment 9', ''),  # noqa
        '0019xx39': ('LO', '1', 'Convolution Kernel Comment 10', ''),  # noqa
        '0019xx3a': ('LO', '1', 'Reading Code RZ1 Comment 1', ''),  # noqa
        '0019xx3b': ('LO', '1', 'Reading Code RZ1 Comment 2', ''),  # noqa
        '0019xx3c': ('LO', '1', 'Reading Code RZ2 Comment 1', ''),  # noqa
    },
    'SIEMENS CM VA0  CMS': {
        '0009xx00': ('IS', '1', 'Number of Measurements', ''),  # noqa
        '0009xx10': ('CS', '1', 'Storage Mode', ''),  # noqa
        '0009xx12': ('UL', '1', 'Evaluation Mask Image', ''),  # noqa
        '0009xx26': ('DA', '1', 'Table Zero Date', ''),  # noqa
        '0009xx27': ('TM', '1', 'Table Zero Time', ''),  # noqa
        '0011xx0a': ('LO', '1', 'Unknown', ''),  # noqa
        '0011xx10': ('DA', '1', 'Registration Date', ''),  # noqa
        '0011xx11': ('TM', '1', 'Registration Time', ''),  # noqa
        '0011xx22': ('LO', '1', 'Unknown', ''),  # noqa
        '0011xx23': ('DS', '1', 'Used Patient Weight', ''),  # noqa
        '0011xx40': ('IS', '1', 'Organ Code', ''),  # noqa
        '0013xx00': ('PN', '1', 'Modifying Physician', ''),  # noqa
        '0013xx10': ('DA', '1', 'Modification Date', ''),  # noqa
        '0013xx12': ('TM', '1', 'Modification Time', ''),  # noqa
        '0013xx20': ('PN', '1', 'Patient Name', ''),  # noqa
        '0013xx22': ('LO', '1', 'Patient Id', ''),  # noqa
        '0013xx30': ('DA', '1', 'Patient Birthdate', ''),  # noqa
        '0013xx31': ('DS', '1', 'Patient Weight', ''),  # noqa
        '0013xx32': ('PN', '1', 'Patient Maiden Name', ''),  # noqa
        '0013xx33': ('PN', '1', 'Referring Physician', ''),  # noqa
        '0013xx34': ('LO', '1', 'Admitting Diagnosis', ''),  # noqa
        '0013xx35': ('CS', '1', 'Patient Sex', ''),  # noqa
        '0013xx40': ('LO', '1', 'Procedure Description', ''),  # noqa
        '0013xx42': ('CS', '1', 'Rest Direction', ''),  # noqa
        '0013xx44': ('CS', '1', 'Patient Position', ''),  # noqa
        '0013xx46': ('SH', '1', 'View Direction', ''),  # noqa
        '0013xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '0013xx51': ('LO', '1', 'Unknown', ''),  # noqa
        '0013xx52': ('LO', '1', 'Unknown', ''),  # noqa
        '0013xx53': ('LO', '1', 'Unknown', ''),  # noqa
        '0013xx54': ('LO', '1', 'Unknown', ''),  # noqa
        '0013xx55': ('LO', '1', 'Unknown', ''),  # noqa
        '0013xx56': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx10': ('IS', '1', 'Net Frequency', ''),  # noqa
        '0019xx20': ('CS', '1', 'Measurement Mode', ''),  # noqa
        '0019xx30': ('CS', '1', 'Calculation Mode', ''),  # noqa
        '0019xx50': ('IS', '1', 'Noise Level', ''),  # noqa
        '0019xx60': ('IS', '1', 'Number of Data Bytes', ''),  # noqa
        '0019xx70': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0019xx80': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx20': ('DS', '1-n', 'Field of View', ''),  # noqa
        '0021xx22': ('DS', '1', 'Image Magnification Factor', ''),  # noqa
        '0021xx24': ('DS', '1-n', 'Image Scroll Offset', ''),  # noqa
        '0021xx26': ('IS', '1', 'Image Pixel Offset', ''),  # noqa
        '0021xx30': ('CS', '1', 'View Direction', ''),  # noqa
        '0021xx32': ('CS', '1', 'Rest Direction', ''),  # noqa
        '0021xx60': ('DS', '1-n', 'Image Position', ''),  # noqa
        '0021xx61': ('DS', '1-n', 'Image Normal', ''),  # noqa
        '0021xx63': ('DS', '1', 'Image Distance', ''),  # noqa
        '0021xx65': ('US', '1', 'Image Positioning History Mask', ''),  # noqa
        '0021xx6a': ('DS', '1-n', 'Image Row', ''),  # noqa
        '0021xx6b': ('DS', '1-n', 'Image Column', ''),  # noqa
        '0021xx70': ('CS', '1-n', 'Patient Orientation Set 1', ''),  # noqa
        '0021xx71': ('CS', '1-n', 'Patient Orientation Set 2', ''),  # noqa
        '0021xx80': ('LO', '1', 'Study Name', ''),  # noqa
        '0021xx82': ('SH', '1', 'Study Type', ''),  # noqa
        '0029xx10': ('CS', '1', 'Window Style', ''),  # noqa
        '0029xx11': ('CS', '1', 'Window Look', ''),  # noqa
        '0029xx12': ('UL', '1', 'Window Table Index', ''),  # noqa
        '0029xx13': ('CS', '1', 'Window Scale', ''),  # noqa
        '0029xx20': ('CS', '1-n', 'Pixel Quality Code', ''),  # noqa
        '0029xx22': ('IS', '1-n', 'Pixel Quality Value', ''),  # noqa
        '0029xx50': ('CS', '1', 'Archive Code', ''),  # noqa
        '0029xx51': ('CS', '1', 'Exposure Code', ''),  # noqa
        '0029xx52': ('IS', '1', 'Sort Code', ''),  # noqa
        '0029xx53': ('CS', '1', 'Remote Copy Code', ''),  # noqa
        '0029xx60': ('IS', '1', 'Splash', ''),  # noqa
        '0051xx10': ('LO', '1-n', 'Image Text', ''),  # noqa
        '6021xx00': ('CS', '1', 'Image Graphics Format Code', ''),  # noqa
        '6021xx10': ('OB', '1', 'Image Graphics', ''),  # noqa
        '7fe1xx00': ('OB', '1-n', 'Binary Data', ''),  # noqa
    },
    'SIEMENS CM VA0  COAD': {
        '0019xx3d': ('LO', '1', 'Reading Code RZ2 Comment 2', ''),  # noqa
    },
    'SIEMENS CM VA0  LAB': {
        '0009xx10': ('LO', '1', 'Generator Identification Label', ''),  # noqa
        '0009xx11': ('LO', '1', 'Gantry Identification Label', ''),  # noqa
        '0009xx12': ('LO', '1', 'XRay Tube Identification Label', ''),  # noqa
        '0009xx13': ('LO', '1', 'Detector Identification Label', ''),  # noqa
        '0009xx14': ('LO', '1', 'DAS Identification Label', ''),  # noqa
        '0009xx15': ('LO', '1', 'SMI Identification Label', ''),  # noqa
        '0009xx16': ('LO', '1', 'CPU Identification Label', ''),  # noqa
        '0009xx20': ('SH', '1', 'Header Version', ''),  # noqa
    },
    'SIEMENS CM VA0  OST': {
        '6023xx00': ('LO', '1', 'Osteo Contour Comment', ''),  # noqa
        '6023xx10': ('SS', '1-n', 'Osteo Contour Buffer', ''),  # noqa
    },
    'SIEMENS CSA ENVELOPE': {
        '0029xx10': ('OB', '1', 'syngo Report Data', ''),  # noqa
        '0029xx11': ('OB', '1', 'syngo Report Presentation', ''),  # noqa
    },
    'SIEMENS CSA HEADER': {
        '0029xx08': ('CS', '1', 'CSA Image Header Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'CSA Image Header Version', ''),  # noqa
        '0029xx10': ('OB', '1', 'CSA Image Header Info', ''),  # noqa
        '0029xx18': ('CS', '1', 'CSA Series Header Type', ''),  # noqa
        '0029xx19': ('LO', '1', 'CSA Series Header Version', ''),  # noqa
        '0029xx20': ('OB', '1', 'CSA Series Header Info', ''),  # noqa
    },
    'SIEMENS CSA NON-IMAGE': {
        '0029xx08': ('CS', '1', 'CSA Data Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'CSA Data Version', ''),  # noqa
        '0029xx10': ('OB', '1', 'CSA Data Info', ''),  # noqa
        '7fe1xx10': ('OB', '1', 'CSA Data', ''),  # noqa
    },
    'SIEMENS CSA REPORT': {
        '0029xx08': ('CS', '1', 'syngo Report Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'syngo Report', ''),  # noqa
        '0029xx15': ('US', '1', 'SR Variant', ''),  # noqa
        '0029xx17': ('UI', '1', 'SC SOP Instance UID', ''),  # noqa
    },
    'SIEMENS CT VA0  COAD': {
        '0019xx10': ('IS', '1', 'Distance Source to SourceSide Collimator', ''),  # noqa
        '0019xx11': ('IS', '1', 'Distance Source to DetectorSide Collimator', ''),  # noqa
        '0019xx20': ('IS', '1', 'Number of Possible Channels', ''),  # noqa
        '0019xx21': ('IS', '1', 'Mean Channel Number', ''),  # noqa
        '0019xx22': ('DS', '1', 'Detector Spacing', ''),  # noqa
        '0019xx23': ('DS', '1', 'Detector Center', ''),  # noqa
        '0019xx24': ('DS', '1', 'Reading Integration Time', ''),  # noqa
        '0019xx50': ('DS', '1', 'Detector Alignment', ''),  # noqa
        '0019xx52': ('DS', '1', 'Table Feed', ''),  # noqa
        '0019xx54': ('DS', '1', 'Rotation Time', ''),  # noqa
        '0019xx60': ('DS', '1', 'Focus Alignment', ''),  # noqa
        '0019xx65': ('UL', '1', 'Focal Spot Deflection Amplitude', ''),  # noqa
        '0019xx66': ('UL', '1', 'Focal Spot Deflection Phase', ''),  # noqa
        '0019xx67': ('UL', '1', 'Focal Spot Deflection Offset', ''),  # noqa
        '0019xx70': ('DS', '1', 'Water Scaling Factor', ''),  # noqa
        '0019xx71': ('DS', '1', 'Interpolation Factor', ''),  # noqa
        '0019xx80': ('CS', '1', 'Patient Region', ''),  # noqa
        '0019xx82': ('CS', '1', 'Patient Phase of Life', ''),  # noqa
        '0019xx90': ('DS', '1', 'Osteo Offset', ''),  # noqa
        '0019xx92': ('DS', '1', 'Osteo Regression Line Slope', ''),  # noqa
        '0019xx93': ('DS', '1', 'Osteo Regression Line Intercept', ''),  # noqa
        '0019xx94': ('IS', '1', 'Osteo Standardization Code', ''),  # noqa
        '0019xx96': ('IS', '1', 'Osteo Phantom Number', ''),  # noqa
        '0019xxa0': ('DS', '1', 'Spiral Location Begin', ''),  # noqa
        '0019xxa1': ('DS', '1', 'Spiral Location End', ''),  # noqa
        '0019xxa2': ('CS', '1', 'Spiral z Profile', ''),  # noqa
        '0019xxa3': ('CS', '1', 'Spiral Reconstruction Direction', ''),  # noqa
        '0019xxa4': ('DS', '1', 'Spiral Reconstruction Increment', ''),  # noqa
        '0019xxa5': ('DS', '1', 'Scan Tilt Plane Distance', ''),  # noqa
        '0019xxa6': ('UL', '1-n', 'Mode Processing Step Mask', ''),  # noqa
        '0019xxa7': ('UL', '1', 'Mode Processing Control Mask', ''),  # noqa
        '0019xxa8': ('UL', '1-n', 'Mode Master Mask', ''),  # noqa
        '0019xxa9': ('IS', '1', 'Mode Store Step', ''),  # noqa
        '0019xxaa': ('CS', '1', 'Focus Size Type', ''),  # noqa
        '0019xxab': ('IS', '1', 'Mode Adaptive Filter Kind', ''),  # noqa
        '0019xxac': ('IS', '1', 'Mode MBH Kind', ''),  # noqa
        '0019xxad': ('IS', '1', 'Mode Balancing Kind', ''),  # noqa
        '0019xxae': ('IS', '1', 'Number of Readings per Rotation', ''),  # noqa
        '0019xxaf': ('DS', '1', 'Correction Table Reference Time', ''),  # noqa
        '0019xxb0': ('DS', '1', 'Feed per Rotation', ''),  # noqa
        '0019xxbd': ('IS', '1', 'Pulmo Trigger Level', ''),  # noqa
        '0019xxbe': ('DS', '1', 'Expiratoric Reserve', ''),  # noqa
        '0019xxbf': ('DS', '1', 'Vital Capacity', ''),  # noqa
        '0019xxc0': ('DS', '1', 'Pulmo Water', ''),  # noqa
        '0019xxc1': ('DS', '1', 'Pulmo Air', ''),  # noqa
        '0019xxc2': ('DA', '1', 'Pulmo Date', ''),  # noqa
        '0019xxc3': ('TM', '1', 'Pulmo Time', ''),  # noqa
        '0019xxc4': ('UL', '1', 'Unknown', ''),  # noqa
        '0019xxc5': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS CT VA0  GEN': {
        '0019xx10': ('DS', '1', 'Source Side Collimator Aperture', ''),  # noqa
        '0019xx11': ('DS', '1', 'Detector Side Collimator Aperture', ''),  # noqa
        '0019xx20': ('IS', '1', 'Exposure Time current', ''),  # noqa
        '0019xx21': ('IS', '1', 'Exposure current', ''),  # noqa
        '0019xx25': ('DS', '1', 'Generator Power current', ''),  # noqa
        '0019xx26': ('DS', '1', 'Generator Voltage current', ''),  # noqa
        '0019xx40': ('UL', '1', 'Master Control Mask', ''),  # noqa
        '0019xx42': ('US', '1-n', 'Processing Mask', ''),  # noqa
        '0019xx44': ('UL', '1-n', 'IRS Data Number', ''),  # noqa
        '0019xx45': ('UL', '1-n', 'IRS Data Length', ''),  # noqa
        '0019xx62': ('IS', '1', 'Number of Virtual Channels', ''),  # noqa
        '0019xx70': ('IS', '1', 'Number of Reading', ''),  # noqa
        '0019xx71': ('CS', '1', 'Reading Code', ''),  # noqa
        '0019xx74': ('IS', '1', 'Number of Projections', ''),  # noqa
        '0019xx75': ('IS', '1', 'Number of Bytes', ''),  # noqa
        '0019xx80': ('IS', '1-n', 'Reconstruction Algorithm Set', ''),  # noqa
        '0019xx81': ('IS', '1', 'Reconstruction Algorithm Index', ''),  # noqa
        '0019xx82': ('LO', '1', 'Regeneration Software Version', ''),  # noqa
        '0019xx84': ('IS', '1', 'Multiscan Reconstruction Increment', ''),  # noqa
        '0019xx85': ('IS', '1', 'Multiscan Reconstruction Width', ''),  # noqa
        '0019xx88': ('IS', '1', 'Range Number', ''),  # noqa
        '0021xx10': ('IS', '1', 'Rotation Angle', ''),  # noqa
        '0021xx11': ('IS', '1', 'Start Angle', ''),  # noqa
        '0021xx20': ('IS', '1', 'Scan', ''),  # noqa
        '0021xx30': ('IS', '1', 'Tube Position', ''),  # noqa
        '0021xx32': ('DS', '1', 'Length of Topogram', ''),  # noqa
        '0021xx34': ('DS', '1', 'Correction Factor', ''),  # noqa
        '0021xx36': ('DS', '1', 'Maximum Table Position', ''),  # noqa
        '0021xx40': ('IS', '1', 'Table Move Direction Code', ''),  # noqa
        '0021xx45': ('IS', '1', 'VOI Start Row', ''),  # noqa
        '0021xx46': ('IS', '1', 'VOI Stop Row', ''),  # noqa
        '0021xx47': ('IS', '1', 'VOI Start Column', ''),  # noqa
        '0021xx48': ('IS', '1', 'VOI Stop Column', ''),  # noqa
        '0021xx49': ('IS', '1', 'VOI Start Slice', ''),  # noqa
        '0021xx4a': ('IS', '1', 'VOI Stop Slice', ''),  # noqa
        '0021xx50': ('IS', '1', 'Vector Start Row', ''),  # noqa
        '0021xx51': ('IS', '1', 'Vector Row Step', ''),  # noqa
        '0021xx52': ('IS', '1', 'Vector Start Column', ''),  # noqa
        '0021xx53': ('IS', '1', 'Vector Column Step', ''),  # noqa
        '0021xx60': ('IS', '1', 'Range Type Code', ''),  # noqa
        '0021xx62': ('IS', '1', 'Reference Type Code', ''),  # noqa
        '0021xx70': ('DS', '1-n', 'Object Orientation', ''),  # noqa
        '0021xx72': ('DS', '1-n', 'Light Orientation', ''),  # noqa
        '0021xx75': ('DS', '1', 'Light Brightness', ''),  # noqa
        '0021xx76': ('DS', '1', 'Light Contrast', ''),  # noqa
        '0021xx7a': ('IS', '1-n', 'Overlay Threshold', ''),  # noqa
        '0021xx7b': ('IS', '1-n', 'Surface Threshold', ''),  # noqa
        '0021xx7c': ('IS', '1-n', 'Grey Scale Threshold', ''),  # noqa
        '0021xxa0': ('IS', '1-n', 'Field of Interest', ''),  # noqa
        '0021xxa1': ('CS', '1', 'Image Filter Label', ''),  # noqa
        '0021xxa2': ('CS', '1', 'Exemplary Element 1', ''),  # noqa
        '0021xxa3': ('IS', '1-n', 'Exemplary Element 2', ''),  # noqa
        '0021xxa4': ('LO', '1', 'Exemplary Element 3', ''),  # noqa
        '0021xxa5': ('IS', '1', 'Reference Data Set 1', ''),  # noqa
        '0021xxa6': ('IS', '1', 'Reference Data Set 2', ''),  # noqa
        '0021xxa7': ('LO', '1', 'Window Program Name', ''),  # noqa
    },
    'SIEMENS CT VA0  IDE': {
        '0009xx10': ('LO', '1', 'SOMATOM Software Name', ''),  # noqa
        '0009xx30': ('CS', '1', 'Data Set Subtype 1', ''),  # noqa
        '0009xx31': ('SH', '1', 'Data Set Subtype 2', ''),  # noqa
        '0009xx32': ('SH', '1', 'Data Set Subtype 3', ''),  # noqa
        '0009xx33': ('SH', '1', 'Data Set Subtype 4', ''),  # noqa
        '0009xx34': ('SH', '1', 'Data Set Subtype 5', ''),  # noqa
        '0009xx40': ('LO', '1', 'Directory Text', ''),  # noqa
        '0009xx42': ('LO', '1', 'Exposure Time Text', ''),  # noqa
        '0009xx50': ('DA', '1', 'Scan Date', ''),  # noqa
        '0009xx51': ('TM', '1', 'Scan Time', ''),  # noqa
    },
    'SIEMENS CT VA0  ORI': {
        '0009xx20': ('LO', '1', 'Original Data Set Owner', ''),  # noqa
        '0009xx30': ('SH', '1', 'Original Modality', ''),  # noqa
    },
    'SIEMENS CT VA0  ORMR': {
        '0021xx80': ('DS', '1', 'Repetition Time', ''),  # noqa
        '0021xx81': ('DS', '1', 'Echo Time', ''),  # noqa
        '0021xx82': ('DS', '1', 'Inversion Time', ''),  # noqa
        '0021xx83': ('IS', '1', 'Number of Averages', ''),  # noqa
        '0021xx84': ('DS', '1', 'Imaging Frequency', ''),  # noqa
        '0021xx85': ('LO', '1', 'Imaged Nucleus', ''),  # noqa
        '0021xx86': ('IS', '1', 'Echo Number', ''),  # noqa
        '0021xx90': ('DS', '1', 'Flip Angle', ''),  # noqa
    },
    'SIEMENS CT VA0  OST': {
        '6021xx00': ('LO', '1', 'Osteo Contour Comment', ''),  # noqa
        '6021xx10': ('US', '256', 'Osteo Contour Buffer', ''),  # noqa
    },
    'SIEMENS CT VA0  RAW': {
        '0021xx10': ('UL', '1-n', 'Creation Mask service', ''),  # noqa
        '0021xx20': ('UL', '1-n', 'Evaluation Mask service', ''),  # noqa
        '0021xx30': ('US', '1-n', 'Extended Processing Mask', ''),  # noqa
        '0021xx40': ('UL', '1-n', 'Manipulation Mask', ''),  # noqa
        '0021xx41': ('UL', '1-n', 'Composition Mask', ''),  # noqa
        '0021xx42': ('UL', '1-n', 'Alteration Mask', ''),  # noqa
        '0021xx43': ('UL', '1-n', 'Generation Mask', ''),  # noqa
        '0021xx44': ('UL', '1-n', 'Function Mask', ''),  # noqa
        '0021xx50': ('CS', '1', 'Mode Mirroring Code', ''),  # noqa
    },
    'SIEMENS DFR.01': {
        '0021xx10': ('US', '1', 'Graphic Evaluation Mask', ''),  # noqa
        '0021xx11': ('US', '1', 'Type 1st Graphic Element', ''),  # noqa
        '0021xx12': ('LO', '1', 'Description 1st Graphic Element', ''),  # noqa
        '0021xx13': ('US', '1', 'Type 2nd Graphic Element', ''),  # noqa
        '0021xx14': ('LO', '1', 'Description 2nd Graphic Element', ''),  # noqa
        '0021xx15': ('US', '1', 'Type 3rd Graphic Element', ''),  # noqa
        '0021xx16': ('LO', '1', 'Description 3rd Graphic Element', ''),  # noqa
        '0021xx17': ('US', '1', 'Type 4th Graphic Element', ''),  # noqa
        '0021xx18': ('LO', '1', 'Description 4th Graphic Element', ''),  # noqa
        '0021xx19': ('US', '1', 'Type 5th Graphic Element', ''),  # noqa
        '0021xx20': ('LO', '1', 'Description 5th Graphic Element', ''),  # noqa
        '0021xx21': ('US', '1', 'Type 6th Graphic Element', ''),  # noqa
        '0021xx22': ('LO', '1', 'Description 6th Graphic Element', ''),  # noqa
        '0021xx23': ('US', '1', 'Type 7th Graphic Element', ''),  # noqa
        '0021xx24': ('LO', '1', 'Description 7th Graphic Element', ''),  # noqa
        '0021xx25': ('US', '1', 'Type 8th Graphic Element', ''),  # noqa
        '0021xx26': ('LO', '1', 'Description 8th Graphic Element', ''),  # noqa
        '0021xx27': ('US', '1', 'Type 9th Graphic Element', ''),  # noqa
        '0021xx28': ('LO', '1', 'Description 9th Graphic Element', ''),  # noqa
        '0021xx29': ('US', '1', 'Type 10th Graphic Element', ''),  # noqa
        '0021xx30': ('LO', '1', 'Description 10th Graphic Element', ''),  # noqa
    },
    'SIEMENS DFR.01 MANIPULATED': {
        '0017xx11': ('US', '1', 'Window Width Native Current', ''),  # noqa
        '0017xx12': ('US', '1', 'Window Center Native', ''),  # noqa
        '0017xx14': ('US', '1', 'Window Width Subtraction Current', ''),  # noqa
        '0017xx15': ('US', '1', 'Window Center Subtraction Current', ''),  # noqa
        '0017xx25': ('DS', '1', 'Edge Enhancement Native Current', ''),  # noqa
        '0017xx27': ('DS', '1', 'Edge Enhancement Subtraction Current', ''),  # noqa
        '0017xx29': ('IS', '1', 'Edge Enhancement %', ''),  # noqa
        '0017xx30': ('IS', '1', 'Harmonization %', ''),  # noqa
        '0017xx31': ('US', '1', 'DSA Representation Current', ''),  # noqa
        '0017xx32': ('US', '1', 'Number of Mask Current', ''),  # noqa
        '0017xx33': ('US', '1', 'RightLeft Mark Current', ''),  # noqa
        '0017xx35': ('US', '1', 'Number of Series Representative', ''),  # noqa
        '0017xx37': ('US', '1', 'Rectangle Shutter Horizontal Current', ''),  # noqa
        '0017xx38': ('US', '1', 'Rectangle Shutter Vertical Aktuell', ''),  # noqa
        '0017xx71': ('LO', '1', 'Landmark Current', ''),  # noqa
        '0017xx72': ('US', '1', 'Zoom Factor', ''),  # noqa
        '0017xx73': ('US', '1', 'Roam Horizontal', ''),  # noqa
        '0017xx74': ('US', '1', 'Roam Vertical', ''),  # noqa
        '0017xx77': ('IS', '1', 'Pixel Shift Horizontal', ''),  # noqa
        '0017xx78': ('IS', '1', 'Pixel Shift Vertical', ''),  # noqa
        '0017xx79': ('US', '1', 'Image Flip', ''),  # noqa
        '0017xx7a': ('US', '1', 'Invers Current', ''),  # noqa
        '0017xx80': ('US', '1', 'Unknown', ''),  # noqa
        '0017xx83': ('SH', '1', 'Documentation Flag', ''),  # noqa
        '0017xx84': ('LO', '1', 'Right Marker', ''),  # noqa
        '0017xx91': ('US', '1', 'Summation Count Filling', ''),  # noqa
        '0017xx92': ('US', '1', 'Summation Count Mask', ''),  # noqa
        '0017xx93': ('US', '1', 'PeakOp Start', ''),  # noqa
        '0017xx94': ('US', '1', 'PeakOp End', ''),  # noqa
        '0017xxa0': ('IS', '1', 'Cine Rate', ''),  # noqa
        '0017xxa1': ('LO', '1', 'Image Name', ''),  # noqa
        '0017xxa2': ('LO', '1', 'Image Name Extension 1', ''),  # noqa
        '0017xxa3': ('LO', '1', 'Image Name Extension 2', ''),  # noqa
    },
    'SIEMENS DFR.01 ORIGINAL': {
        '0017xx10': ('CS', '1', 'Image Type', ''),  # noqa
        '0017xx11': ('US', '1', 'Window Width Native Original', ''),  # noqa
        '0017xx12': ('US', '1', 'Window Center Native', ''),  # noqa
        '0017xx14': ('US', '1', 'Window Width Subtraction Original', ''),  # noqa
        '0017xx15': ('US', '1', 'Window Center Subtraction Original', ''),  # noqa
        '0017xx16': ('US', '1', 'LUT Number for Autowindow', ''),  # noqa
        '0017xx18': ('US', '1', 'Unknown', ''),  # noqa
        '0017xx21': ('US', '1', 'Edge Enhancement Kernelsize Original', ''),  # noqa
        '0017xx22': ('US', '1', 'Edge Enhancement Mode Original', ''),  # noqa
        '0017xx23': ('US', '1-n', 'Edge Enhancement LUTs Original', ''),  # noqa
        '0017xx24': ('US', '1', 'Filter Type Native Original', ''),  # noqa
        '0017xx25': ('DS', '1', 'Edge Enhancement Native Original', ''),  # noqa
        '0017xx26': ('US', '1', 'Filter Type Subtraction Original', ''),  # noqa
        '0017xx27': ('DS', '1', 'Edge Enhancement Subtraction Original', ''),  # noqa
        '0017xx2a': ('US', '1', 'Unknown', ''),  # noqa
        '0017xx30': ('IS', '1', 'Unknown', ''),  # noqa
        '0017xx31': ('US', '1', 'DSA Representation Original', ''),  # noqa
        '0017xx32': ('US', '1', 'Number of Maske Original', ''),  # noqa
        '0017xx33': ('US', '1', 'RightLeft Mark Original', ''),  # noqa
        '0017xx34': ('DS', '1', 'Slice Position', ''),  # noqa
        '0017xx37': ('US', '1', 'Rectangle Shutter Horizontal Original', ''),  # noqa
        '0017xx38': ('US', '1', 'Rectangle Vertical Original', ''),  # noqa
        '0017xx41': ('DS', '1', 'Dose', ''),  # noqa
        '0017xx42': ('DS', '1', 'Dose Area Product', ''),  # noqa
        '0017xx43': ('US', '1', 'Focus', ''),  # noqa
        '0017xx44': ('US', '1', 'SDM', ''),  # noqa
        '0017xx45': ('DS', '1', 'Image Intensifer Format', ''),  # noqa
        '0017xx46': ('DS', '1', 'Density Correction', ''),  # noqa
        '0017xx47': ('LO', '1', 'Exposure Curves', ''),  # noqa
        '0017xx48': ('IS', '1', 'Unknown', ''),  # noqa
        '0017xx49': ('LO', '1', 'Organ Program Name', ''),  # noqa
        '0017xx4a': ('IS', '1', 'Count of Images in Series', ''),  # noqa
        '0017xx51': ('US', '1', 'Image Intensifier Zoom', ''),  # noqa
        '0017xx52': ('UL', '1', 'ROSA Receiver ErrCount', ''),  # noqa
        '0017xx61': ('US', '1', 'Table Position Peri', ''),  # noqa
        '0017xx62': ('US', '1-n', 'Series Numbers of Petri', ''),  # noqa
        '0017xx71': ('LO', '1', 'Landmark Original', ''),  # noqa
        '0017xx72': ('US', '1', 'Unknown', ''),  # noqa
        '0017xx73': ('US', '1', 'Unknown', ''),  # noqa
        '0017xx74': ('US', '1', 'Unknown', ''),  # noqa
        '0017xx79': ('US', '1', 'Unknown', ''),  # noqa
        '0017xx7a': ('US', '1', 'Invers Original', ''),  # noqa
        '0017xx7b': ('IS', '1', 'Unknown', ''),  # noqa
        '0017xxa0': ('IS', '1', 'Unknown', ''),  # noqa
        '0017xxb1': ('CS', '1', 'L2 Image', ''),  # noqa
        '0017xxb2': ('IS', '1', 'L2 Acquisition Monitor', ''),  # noqa
        '0017xxc1': ('LO', '1', 'Folder UID', ''),  # noqa
        '0017xxc2': ('LO', '1', 'Series UID', ''),  # noqa
        '0017xxc3': ('LO', '1', 'Subseries UID', ''),  # noqa
    },
    'SIEMENS DFR.01 SERVICE': {
        '0021xx10': ('US', '1', '1 Plot', ''),  # noqa
        '0021xx11': ('US', '1', 'Width 1 Plot', ''),  # noqa
        '0021xx12': ('US', '1', '2 Plot', ''),  # noqa
        '0021xx13': ('US', '1', 'Width 2 Plot', ''),  # noqa
        '0021xx20': ('US', '1-5', 'xCoordinate Region of Interest', ''),  # noqa
        '0021xx21': ('US', '1-5', 'yCoordinate Region of Interest', ''),  # noqa
        '0021xx22': ('US', '1-5', 'Width Region of Interest', ''),  # noqa
        '0021xx23': ('US', '1-5', 'Height Region of Interest', ''),  # noqa
    },
    'SIEMENS DICOM': {
        '0009xx10': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xx12': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS DLR.01': {
        '0019xx10': ('LO', '1', 'Measurement Mode', ''),  # noqa
        '0019xx11': ('LO', '1', 'Image Type', ''),  # noqa
        '0019xx15': ('LO', '1', 'Software Version', ''),  # noqa
        '0019xx20': ('LO', '1', 'MPM Code', ''),  # noqa
        '0019xx21': ('LO', '1', 'Latitude', ''),  # noqa
        '0019xx22': ('LO', '1', 'Sensitivity', ''),  # noqa
        '0019xx23': ('LO', '1', 'EDR', ''),  # noqa
        '0019xx24': ('LO', '1', 'l fix', ''),  # noqa
        '0019xx25': ('LO', '1', 's fix', ''),  # noqa
        '0019xx26': ('LO', '1', 'Preset Mode', ''),  # noqa
        '0019xx27': ('LO', '1', 'Region', ''),  # noqa
        '0019xx28': ('LO', '1', 'Subregion', ''),  # noqa
        '0019xx30': ('LO', '1', 'Orientation', ''),  # noqa
        '0019xx31': ('LO', '1', 'Mark on Film', ''),  # noqa
        '0019xx32': ('LO', '1', 'Rotation on DRC', ''),  # noqa
        '0019xx40': ('LO', '1', 'Reader Type', ''),  # noqa
        '0019xx41': ('LO', '1', 'Sub Modality', ''),  # noqa
        '0019xx42': ('LO', '1', 'Reader Serial Number', ''),  # noqa
        '0019xx50': ('LO', '1', 'Cassette Scale', ''),  # noqa
        '0019xx51': ('LO', '1', 'Cassette Matrix', ''),  # noqa
        '0019xx52': ('LO', '1', 'Cassette Submatrix', ''),  # noqa
        '0019xx53': ('LO', '1', 'Barcode', ''),  # noqa
        '0019xx60': ('LO', '1', 'GT Contrast Type', ''),  # noqa
        '0019xx61': ('LO', '1', 'GA Rotation Amount', ''),  # noqa
        '0019xx62': ('LO', '1', 'GC Rotation Center', ''),  # noqa
        '0019xx63': ('LO', '1', 'GS Density Shift', ''),  # noqa
        '0019xx64': ('US', '1', 'RN Frequency Rank', ''),  # noqa
        '0019xx65': ('LO', '1', 'RE Frequency Enhancement', ''),  # noqa
        '0019xx66': ('LO', '1', 'RT Frequency Type', ''),  # noqa
        '0019xx67': ('LO', '1', 'Kernel Length', ''),  # noqa
        '0019xx68': ('UL', '1', 'Kernel Mode', ''),  # noqa
        '0019xx69': ('UL', '1', 'Convulsion Mode', ''),  # noqa
        '0019xx70': ('LO', '1', 'PLA Source', ''),  # noqa
        '0019xx71': ('LO', '1', 'PLA Destination', ''),  # noqa
        '0019xx75': ('LO', '1', 'UID Original Image', ''),  # noqa
        '0019xx76': ('LO', '1', 'Filterset', ''),  # noqa
        '0019xx80': ('LO', '1', 'Reader Header', ''),  # noqa
        '0019xx90': ('LO', '1', 'PLA of Secondary Destination', ''),  # noqa
        '0019xxa0': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa1': ('DS', '1', 'Unknown', ''),  # noqa
        '0041xx10': ('US', '1', 'Number of Hardcopies', ''),  # noqa
        '0041xx20': ('CS', '1', 'Film Format', ''),  # noqa
        '0041xx30': ('LO', '1', 'Film Size', ''),  # noqa
        '0041xx31': ('LO', '1', 'Full Film Format', ''),  # noqa
    },
    'SIEMENS ISI': {
        '0003xx08': ('US', '1', 'ISI Command Field', ''),  # noqa
        '0003xx11': ('US', '1', 'Attach ID Application Code', ''),  # noqa
        '0003xx12': ('UL', '1', 'Attach ID Message Count', ''),  # noqa
        '0003xx13': ('DA', '1', 'Attach ID Date', ''),  # noqa
        '0003xx14': ('TM', '1', 'Attach ID Time', ''),  # noqa
        '0003xx20': ('US', '1', 'Message Type', ''),  # noqa
        '0003xx30': ('DA', '1', 'Max Waiting Date', ''),  # noqa
        '0003xx31': ('TM', '1', 'Max Waiting Time', ''),  # noqa
        '0009xx01': ('UN', '1', 'RIS Patient Info IMGEF', ''),  # noqa
        '0009xx14': ('SQ', '1', 'RIS Patient Info IMGEF', ''),  # noqa
        '0011xx03': ('LO', '1', 'Patient UID', ''),  # noqa
        '0011xx04': ('LO', '1', 'Patient ID', ''),  # noqa
        '0011xx0a': ('LO', '1', 'Case ID', ''),  # noqa
        '0011xx22': ('LO', '1', 'Request ID', ''),  # noqa
        '0011xx23': ('LO', '1', 'Examination UID', ''),  # noqa
        '0011xx41': ('LO', '1', 'Medical Alerts', ''),  # noqa
        '0011xx42': ('LO', '1', 'Contrast Allergy', ''),  # noqa
        '0011xxa1': ('DA', '1', 'Patient Registration Date', ''),  # noqa
        '0011xxa2': ('TM', '1', 'Patient Registration Time', ''),  # noqa
        '0011xxb0': ('LO', '1', 'Patient Last Name', ''),  # noqa
        '0011xxb2': ('LO', '1', 'Patient First Name', ''),  # noqa
        '0011xxb4': ('CS', '1', 'Patient Hospital Status', ''),  # noqa
        '0011xxbc': ('LO', '1', 'Current Location Time', ''),  # noqa
        '0011xxc0': ('CS', '1', 'Patient Insurance Status', ''),  # noqa
        '0011xxd0': ('LO', '1', 'Patient Billing Type', ''),  # noqa
        '0011xxd2': ('LO', '1', 'Patient Billing Address', ''),  # noqa
        '0031xx12': ('LO', '1', 'Examination Reason', ''),  # noqa
        '0031xx30': ('DA', '1', 'Requested Date', ''),  # noqa
        '0031xx32': ('TM', '1', 'Worklist Request Start Time', ''),  # noqa
        '0031xx33': ('TM', '1', 'Worklist Request End Time', ''),  # noqa
        '0031xx4a': ('TM', '1', 'Requested Time', ''),  # noqa
        '0031xx80': ('LO', '1', 'Requested Location', ''),  # noqa
        '0055xx46': ('PN', '1', 'Current Ward', ''),  # noqa
        '0193xx02': ('LO', '1', 'RIS Key', ''),  # noqa
        '0307xx01': ('SQ', '1', 'RIS Worklist IMGEF', ''),  # noqa
        '0309xx01': ('SQ', '1', 'RIS Report IMGEF', ''),  # noqa
        '4009xx01': ('LO', '1', 'Report ID', ''),  # noqa
        '4009xx20': ('CS', '1', 'Report Status', ''),  # noqa
        '4009xx30': ('DA', '1', 'Report Creation Date', ''),  # noqa
        '4009xx70': ('PN', '1', 'Report Approving Physician', ''),  # noqa
        '4009xxe0': ('LO', '1', 'Report Text', ''),  # noqa
        '4009xxe1': ('LO', '1', 'Report Author', ''),  # noqa
        '4009xxe2': ('PN', '1', 'Report Transcriber', ''),  # noqa
        '4009xxe3': ('PN', '1', 'Reporting Radiologist', ''),  # noqa
    },
    'SIEMENS MED': {
        '0009xx10': ('LO', '1', 'Recognition Code', ''),  # noqa
        '0009xx30': ('US', '1', 'Byte Offset of Original Header', ''),  # noqa
        '0009xx31': ('US', '1', 'Length of Original Header', ''),  # noqa
        '0009xx40': ('US', '1', 'Byte Offset of Pixel Matrix', ''),  # noqa
        '0009xx41': ('UL', '1', 'Length of Pixel Matrix', ''),  # noqa
        '0009xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx51': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx80': ('ST', '1', '', ''),  # noqa
        '0009xxf5': ('LO', '1', 'PDM EFID Placeholder', ''),  # noqa
        '0009xxf6': ('LO', '1', 'PDM Data Object Type Extension', ''),  # noqa
        '0011xx10': ('ST', '1', '', ''),  # noqa
        '0017xx00': ('ST', '1', '', ''),  # noqa
        '0017xx20': ('ST', '1', '', ''),  # noqa
        '0017xx60': ('LO', '1', '', ''),  # noqa
        '0017xx80': ('ST', '1', '', ''),  # noqa
        '0019xx01': ('SS', '1', '', ''),  # noqa
        '0019xx02': ('SS', '1', '', ''),  # noqa
        '0019xx03': ('SS', '1', '', ''),  # noqa
        '0019xx04': ('ST', '1', '', ''),  # noqa
        '0019xx05': ('ST', '1', '', ''),  # noqa
        '0019xx06': ('SL', '1', '', ''),  # noqa
        '0019xx07': ('SL', '1', '', ''),  # noqa
        '0019xx08': ('SS', '1', '', ''),  # noqa
        '0019xx09': ('SS', '1', '', ''),  # noqa
        '0019xx0a': ('ST', '1', '', ''),  # noqa
        '0019xx0b': ('ST', '1', '', ''),  # noqa
        '0019xx0c': ('SS', '1', '', ''),  # noqa
        '0019xx0d': ('ST', '1', '', ''),  # noqa
        '0019xx0e': ('ST', '1', '', ''),  # noqa
        '0019xx0f': ('SL', '1', '', ''),  # noqa
        '0019xx11': ('ST', '1', '', ''),  # noqa
        '0019xx12': ('ST', '1', '', ''),  # noqa
        '0019xx13': ('SS', '1', '', ''),  # noqa
        '0019xx14': ('SS', '1', '', ''),  # noqa
        '0019xx15': ('SS', '1', '', ''),  # noqa
        '0019xx16': ('SS', '1', '', ''),  # noqa
        '0019xx17': ('SS', '1', '', ''),  # noqa
        '0019xx18': ('SS', '1', '', ''),  # noqa
        '0019xx19': ('SS', '1', '', ''),  # noqa
        '0019xx1a': ('SS', '1', '', ''),  # noqa
        '0019xx1b': ('SS', '1', '', ''),  # noqa
        '0019xx1c': ('SS', '1', '', ''),  # noqa
        '0019xx1d': ('SS', '1', '', ''),  # noqa
        '0019xx20': ('SL', '1', '', ''),  # noqa
        '0019xx21': ('SL', '1', '', ''),  # noqa
        '0019xx22': ('SL', '1', '', ''),  # noqa
        '0019xx23': ('SS', '1', '', ''),  # noqa
        '0019xx24': ('SL', '1', '', ''),  # noqa
        '0019xx25': ('SL', '1', '', ''),  # noqa
        '0019xx26': ('SL', '1', '', ''),  # noqa
        '0019xx27': ('SL', '1', '', ''),  # noqa
        '0019xx30': ('SL', '1', '', ''),  # noqa
        '0019xx31': ('SL', '1', '', ''),  # noqa
        '0019xx32': ('SL', '1', '', ''),  # noqa
        '0019xx41': ('SS', '1', '', ''),  # noqa
        '0019xx42': ('SS', '1', '', ''),  # noqa
        '0019xx43': ('SS', '1', '', ''),  # noqa
        '0019xx44': ('SS', '1', '', ''),  # noqa
        '0019xx45': ('SL', '1', '', ''),  # noqa
        '0019xx47': ('SL', '1', '', ''),  # noqa
        '0019xx48': ('ST', '1', '', ''),  # noqa
        '0019xx49': ('SL', '1', '', ''),  # noqa
        '0019xx4a': ('SS', '1', '', ''),  # noqa
        '0019xx4b': ('SS', '1', '', ''),  # noqa
        '0019xx4c': ('SL', '1', '', ''),  # noqa
        '0019xx4e': ('SS', '1', '', ''),  # noqa
        '0019xx4f': ('SS', '1', '', ''),  # noqa
        '0019xx50': ('SS', '1', '', ''),  # noqa
        '0019xx51': ('SS', '1', '', ''),  # noqa
        '0019xx52': ('SS', '1', '', ''),  # noqa
        '0019xx53': ('SS', '1', '', ''),  # noqa
        '0019xx54': ('ST', '1', '', ''),  # noqa
        '0019xx55': ('SS', '1', '', ''),  # noqa
        '0019xx56': ('SS', '1', '', ''),  # noqa
        '0019xx57': ('SS', '1', '', ''),  # noqa
        '0019xx58': ('SS', '1', '', ''),  # noqa
        '0019xx59': ('SS', '1', '', ''),  # noqa
        '0019xx5a': ('ST', '1', '', ''),  # noqa
        '0019xx5b': ('SS', '1', '', ''),  # noqa
        '0019xx5c': ('SS', '1', '', ''),  # noqa
        '0019xx5d': ('SS', '1', '', ''),  # noqa
        '0019xx5e': ('SS', '1', '', ''),  # noqa
        '0019xx5f': ('SS', '1', '', ''),  # noqa
        '0019xx60': ('SS', '1', '', ''),  # noqa
        '0019xx61': ('SS', '1', '', ''),  # noqa
        '0019xx62': ('SS', '1', '', ''),  # noqa
        '0019xx63': ('SS', '1', '', ''),  # noqa
        '0019xx64': ('SS', '1', '', ''),  # noqa
        '0019xx65': ('SS', '1', '', ''),  # noqa
        '0019xx66': ('SS', '1', '', ''),  # noqa
        '0019xx67': ('SS', '1', '', ''),  # noqa
        '0019xx68': ('SL', '1', '', ''),  # noqa
        '0019xx69': ('SS', '1', '', ''),  # noqa
        '0019xx6a': ('SS', '1', '', ''),  # noqa
        '0019xx6b': ('SL', '1', '', ''),  # noqa
        '0019xx6c': ('SL', '1', '', ''),  # noqa
        '0019xx6d': ('SS', '1', '', ''),  # noqa
        '0019xx6e': ('SS', '1', '', ''),  # noqa
        '0019xx6f': ('SS', '1', '', ''),  # noqa
        '0019xx70': ('ST', '1', '', ''),  # noqa
        '0019xx71': ('ST', '1', '', ''),  # noqa
        '0019xx72': ('SL', '1', '', ''),  # noqa
        '0019xx73': ('SL', '1', '', ''),  # noqa
        '0019xx74': ('SS', '1', '', ''),  # noqa
        '0019xx75': ('SS', '1', '', ''),  # noqa
        '0019xx76': ('SS', '1', '', ''),  # noqa
        '0019xx77': ('SS', '1', '', ''),  # noqa
        '0019xx78': ('SS', '1', '', ''),  # noqa
        '0019xx7f': ('SS', '1', '', ''),  # noqa
        '0019xx80': ('SS', '1', '', ''),  # noqa
        '0019xx81': ('SS', '1', '', ''),  # noqa
        '0019xx82': ('SL', '1', '', ''),  # noqa
        '0019xx83': ('SS', '1', '', ''),  # noqa
        '0019xx84': ('SS', '1', '', ''),  # noqa
        '0019xx85': ('SS', '1', '', ''),  # noqa
        '0019xx86': ('SS', '1', '', ''),  # noqa
        '0019xx87': ('SS', '1', '', ''),  # noqa
        '0019xx88': ('SL', '1', '', ''),  # noqa
        '0019xx89': ('SS', '1', '', ''),  # noqa
        '0019xx8a': ('SL', '1', '', ''),  # noqa
        '0019xx8d': ('SL', '1', '', ''),  # noqa
        '0019xx8e': ('SL', '1', '', ''),  # noqa
        '0019xx91': ('SL', '1', '', ''),  # noqa
        '0019xx92': ('SL', '1', '', ''),  # noqa
        '0019xx93': ('SL', '1', '', ''),  # noqa
        '0019xx94': ('SS', '1', '', ''),  # noqa
        '0019xx95': ('SS', '1', '', ''),  # noqa
        '0019xx96': ('SL', '1', '', ''),  # noqa
        '0019xx97': ('SS', '1', '', ''),  # noqa
        '0019xxa0': ('SS', '1', '', ''),  # noqa
        '0019xxa1': ('SS', '1', '', ''),  # noqa
        '0019xxa2': ('SL', '1', '', ''),  # noqa
        '0019xxa3': ('SL', '1', '', ''),  # noqa
        '0019xxa4': ('SL', '1', '', ''),  # noqa
        '0019xxc0': ('SL', '1', '', ''),  # noqa
        '0019xxc1': ('SS', '1', '', ''),  # noqa
        '0019xxc2': ('SS', '1', '', ''),  # noqa
        '0019xxf0': ('SL', '1', '', ''),  # noqa
        '001fxx00': ('LO', '1', '', ''),  # noqa
        '001fxx02': ('LO', '1', '', ''),  # noqa
        '001fxx50': ('LO', '1', '', ''),  # noqa
        '001fxx70': ('LO', '1', '', ''),  # noqa
        '0021xx10': ('DS', '1', 'Zoom', ''),  # noqa
        '0021xx11': ('DS', '1-n', 'Target', ''),  # noqa
        '0021xx12': ('IS', '1', 'Tube Angle During Topogram', ''),  # noqa
        '0021xx20': ('US', '1', 'ROI Mask', ''),  # noqa
        '0031xx01': ('ST', '1', '', ''),  # noqa
        '0031xx03': ('SL', '1', '', ''),  # noqa
        '0031xx04': ('ST', '1', '', ''),  # noqa
        '0031xx05': ('SS', '1', '', ''),  # noqa
        '0031xx06': ('SL', '1', '', ''),  # noqa
        '0031xx07': ('SS', '1', '', ''),  # noqa
        '0031xx08': ('ST', '1', '', ''),  # noqa
        '0031xx09': ('SS', '1', '', ''),  # noqa
        '0031xx0a': ('SS', '1', '', ''),  # noqa
        '0031xx0b': ('SS', '1', '', ''),  # noqa
        '0031xx0c': ('SS', '1', '', ''),  # noqa
        '0031xx0d': ('SS', '1', '', ''),  # noqa
        '0031xx0e': ('SS', '1', '', ''),  # noqa
        '0031xx0f': ('SL', '1', '', ''),  # noqa
        '0031xx10': ('SL', '1', '', ''),  # noqa
        '0031xx11': ('SS', '1', '', ''),  # noqa
        '0041xx12': ('SL', '1', '', ''),  # noqa
        '0041xx13': ('SL', '1', '', ''),  # noqa
        '0041xx21': ('ST', '1', '', ''),  # noqa
        '0041xx30': ('ST', '1', '', ''),  # noqa
        '0041xx32': ('ST', '1', '', ''),  # noqa
        '0041xx34': ('ST', '1', '', ''),  # noqa
        '0041xx36': ('ST', '1', '', ''),  # noqa
        '0041xx40': ('ST', '1', '', ''),  # noqa
        '0041xx50': ('SS', '1', '', ''),  # noqa
        '0041xx52': ('SS', '1', '', ''),  # noqa
        '0041xx60': ('ST', '1', '', ''),  # noqa
        '0041xx70': ('SL', '1', '', ''),  # noqa
        '0041xx71': ('SL', '1', '', ''),  # noqa
        '0051xx10': ('SS', '1', '', ''),  # noqa
        '0051xx11': ('SS', '1', '', ''),  # noqa
        '0051xx12': ('SS', '1', '', ''),  # noqa
        '0051xx13': ('SS', '1', '', ''),  # noqa
        '0051xx14': ('SS', '1', '', ''),  # noqa
        '0051xx15': ('SL', '1', '', ''),  # noqa
        '0051xx18': ('SL', '1', '', ''),  # noqa
        '0053xx01': ('SS', '1', '', ''),  # noqa
        '0053xx02': ('SS', '1', '', ''),  # noqa
        '0053xx03': ('SS', '1', '', ''),  # noqa
        '0053xx10': ('SS', '1', '', ''),  # noqa
        '0053xx11': ('SL', '1', '', ''),  # noqa
        '0053xx12': ('SS', '1', '', ''),  # noqa
        '0053xx13': ('SL', '1', '', ''),  # noqa
        '0053xx14': ('SS', '1', '', ''),  # noqa
        '0053xx15': ('SL', '1', '', ''),  # noqa
        '0053xx16': ('SS', '1', '', ''),  # noqa
        '0053xx17': ('SS', '1', '', ''),  # noqa
        '0053xx18': ('SL', '1', '', ''),  # noqa
        '0053xx19': ('SS', '1', '', ''),  # noqa
        '0053xx1a': ('SS', '1', '', ''),  # noqa
        '0053xx1b': ('SL', '1', '', ''),  # noqa
        '0053xx1c': ('SS', '1', '', ''),  # noqa
        '0053xx1d': ('SL', '1', '', ''),  # noqa
        '0053xx30': ('SS', '1', '', ''),  # noqa
        '0053xx31': ('SS', '1', '', ''),  # noqa
        '0053xx32': ('SS', '1', '', ''),  # noqa
        '0053xx33': ('SL', '1', '', ''),  # noqa
        '0053xx40': ('SS', '1', '', ''),  # noqa
        '0053xx41': ('SL', '1', '', ''),  # noqa
        '0053xx42': ('SS', '1', '', ''),  # noqa
        '0053xx43': ('SL', '1', '', ''),  # noqa
        '0053xx44': ('SS', '1', '', ''),  # noqa
        '0055xx01': ('SS', '1', '', ''),  # noqa
        '0055xx02': ('SS', '1', '', ''),  # noqa
        '0055xx03': ('SL', '1', '', ''),  # noqa
        '0055xx20': ('SS', '1', '', ''),  # noqa
        '0055xx21': ('ST', '1', '', ''),  # noqa
        '0055xx22': ('SS', '1', '', ''),  # noqa
        '0055xx23': ('ST', '1', '', ''),  # noqa
        '0055xx24': ('SS', '1', '', ''),  # noqa
        '0055xx25': ('ST', '1', '', ''),  # noqa
        '0055xx29': ('SL', '1', '', ''),  # noqa
        '0055xx2a': ('SL', '1', '', ''),  # noqa
        '0055xx30': ('SS', '1', '', ''),  # noqa
        '0055xx31': ('ST', '1', '', ''),  # noqa
        '0055xx32': ('SS', '1', '', ''),  # noqa
        '0055xx33': ('ST', '1', '', ''),  # noqa
        '0055xx34': ('SS', '1', '', ''),  # noqa
        '0055xx35': ('ST', '1', '', ''),  # noqa
        '0055xx38': ('SL', '1', '', ''),  # noqa
        '0055xx39': ('SL', '1', '', ''),  # noqa
        '0055xx3a': ('SL', '1', '', ''),  # noqa
        '0055xx40': ('SS', '1', '', ''),  # noqa
        '0055xx48': ('SL', '1', '', ''),  # noqa
        '0055xx50': ('SS', '1', '', ''),  # noqa
        '0055xx51': ('SS', '1', '', ''),  # noqa
        '0055xx52': ('SS', '1', '', ''),  # noqa
        '0055xx53': ('ST', '1', '', ''),  # noqa
        '0055xx54': ('SL', '1', '', ''),  # noqa
        '0055xx55': ('SL', '1', '', ''),  # noqa
        '0055xx56': ('SS', '1', '', ''),  # noqa
        '0055xx57': ('SS', '1', '', ''),  # noqa
        '0055xx58': ('SL', '1', '', ''),  # noqa
        '0055xx59': ('ST', '1', '', ''),  # noqa
        '0055xx5a': ('SL', '1', '', ''),  # noqa
        '0055xx5b': ('SS', '1', '', ''),  # noqa
        '0055xx5c': ('ST', '1', '', ''),  # noqa
        '0055xx5d': ('SS', '1', '', ''),  # noqa
        '0055xx5e': ('SS', '1', '', ''),  # noqa
        '0055xx5f': ('SL', '1', '', ''),  # noqa
        '0055xx60': ('SS', '1', '', ''),  # noqa
        '0055xx61': ('SS', '1', '', ''),  # noqa
        '0055xx64': ('SS', '1', '', ''),  # noqa
        '0055xx65': ('SS', '1', '', ''),  # noqa
        '0055xx66': ('SS', '1', '', ''),  # noqa
        '0055xx67': ('SS', '1', '', ''),  # noqa
        '0055xx68': ('SS', '1', '', ''),  # noqa
        '0055xx69': ('SS', '1', '', ''),  # noqa
        '0055xx6a': ('SS', '1', '', ''),  # noqa
        '0055xx6b': ('SS', '1', '', ''),  # noqa
        '0055xx6c': ('SS', '1', '', ''),  # noqa
        '0055xx6d': ('SS', '1', '', ''),  # noqa
        '0055xx70': ('SL', '1', '', ''),  # noqa
        '0055xx71': ('SL', '1', '', ''),  # noqa
        '0055xx72': ('SL', '1', '', ''),  # noqa
        '0055xx73': ('SL', '1', '', ''),  # noqa
        '0055xx74': ('SL', '1', '', ''),  # noqa
        '0055xx75': ('SL', '1', '', ''),  # noqa
        '0055xx76': ('SL', '1', '', ''),  # noqa
        '0055xx77': ('SL', '1', '', ''),  # noqa
        '0055xx78': ('SL', '1', '', ''),  # noqa
        '0055xx80': ('SS', '1', '', ''),  # noqa
        '0055xx81': ('SS', '1', '', ''),  # noqa
        '0055xx82': ('SS', '1', '', ''),  # noqa
        '0055xx83': ('SS', '1', '', ''),  # noqa
        '0055xx84': ('SS', '1', '', ''),  # noqa
        '0055xx85': ('SS', '1', '', ''),  # noqa
        '0055xx86': ('SL', '1', '', ''),  # noqa
        '0055xx87': ('SL', '1', '', ''),  # noqa
        '0055xx88': ('SL', '1', '', ''),  # noqa
        '0055xx89': ('ST', '1', '', ''),  # noqa
        '0055xx8a': ('SS', '1', '', ''),  # noqa
        '0055xx8b': ('SL', '1', '', ''),  # noqa
        '0055xx8c': ('SS', '1', '', ''),  # noqa
        '0055xx8d': ('SL', '1', '', ''),  # noqa
        '0055xx8e': ('SL', '1', '', ''),  # noqa
        '0055xx8f': ('SL', '1', '', ''),  # noqa
        '0055xx90': ('SL', '1', '', ''),  # noqa
        '0055xx91': ('SS', '1', '', ''),  # noqa
        '0055xx92': ('ST', '1', '', ''),  # noqa
        '0055xx93': ('SL', '1', '', ''),  # noqa
        '0055xx94': ('SL', '1', '', ''),  # noqa
        '0055xx95': ('SL', '1', '', ''),  # noqa
        '0055xx96': ('SL', '1', '', ''),  # noqa
        '0055xx97': ('SL', '1', '', ''),  # noqa
        '0055xx98': ('SS', '1', '', ''),  # noqa
        '0055xx99': ('SS', '1', '', ''),  # noqa
        '0055xx9a': ('SS', '1', '', ''),  # noqa
        '0055xx9b': ('SS', '1', '', ''),  # noqa
        '0055xx9c': ('SS', '1', '', ''),  # noqa
        '0055xx9d': ('SL', '1', '', ''),  # noqa
        '0055xx9e': ('SL', '1', '', ''),  # noqa
        '0055xx9f': ('SL', '1', '', ''),  # noqa
        '0055xxa0': ('SL', '1', '', ''),  # noqa
        '0055xxa1': ('SL', '1', '', ''),  # noqa
        '0055xxa2': ('SL', '1', '', ''),  # noqa
        '0055xxa3': ('SL', '1', '', ''),  # noqa
        '0055xxa4': ('SS', '1', '', ''),  # noqa
        '0055xxa5': ('SL', '1', '', ''),  # noqa
        '0055xxa6': ('SL', '1', '', ''),  # noqa
        '0055xxa7': ('SS', '1', '', ''),  # noqa
        '0055xxa8': ('SS', '1', '', ''),  # noqa
        '0055xxa9': ('SS', '1', '', ''),  # noqa
        '0055xxb0': ('SS', '1', '', ''),  # noqa
        '0055xxb1': ('SS', '1', '', ''),  # noqa
        '0057xx10': ('SS', '1', '', ''),  # noqa
        '0057xx20': ('SL', '1', '', ''),  # noqa
        '5001xx01': ('SS', '1', '', ''),  # noqa
        '5001xx02': ('SL', '1', '', ''),  # noqa
        '5001xx03': ('SL', '1', '', ''),  # noqa
        '5001xx04': ('SL', '1', '', ''),  # noqa
        '5001xx05': ('SL', '1', '', ''),  # noqa
        '5001xx06': ('SL', '1', '', ''),  # noqa
        '5001xx07': ('ST', '1', '', ''),  # noqa
        '5001xx08': ('ST', '1', '', ''),  # noqa
        '5001xx09': ('ST', '1', '', ''),  # noqa
        '5001xx0a': ('ST', '1', '', ''),  # noqa
        '5001xx0b': ('SL', '1', '', ''),  # noqa
        '7001xx10': ('SS', '1', '', ''),  # noqa
        '7003xx10': ('SL', '1', '', ''),  # noqa
        '7005xx10': ('SS', '1', '', ''),  # noqa
        '7fe1xx10': ('SS', '1', '', ''),  # noqa
        '7fe3xx14': ('SL', '1', '', ''),  # noqa
        '7fe3xx15': ('SL', '1', '', ''),  # noqa
        '7fe3xx16': ('SL', '1', '', ''),  # noqa
        '7fe3xx17': ('SL', '1', '', ''),  # noqa
        '7fe3xx18': ('SL', '1', '', ''),  # noqa
        '7fe3xx19': ('ST', '1', '', ''),  # noqa
        '7fe3xx1a': ('SL', '1', '', ''),  # noqa
        '7fe3xx1b': ('SS', '1', '', ''),  # noqa
        '7fe3xx1c': ('SS', '1', '', ''),  # noqa
        '7fe3xx1e': ('SL', '1', '', ''),  # noqa
        '7fe3xx1f': ('SL', '1', '', ''),  # noqa
        '7fe3xx20': ('SL', '1', '', ''),  # noqa
        '7fe3xx21': ('SL', '1', '', ''),  # noqa
        '7fe3xx22': ('SL', '1', '', ''),  # noqa
        '7fe3xx23': ('SL', '1', '', ''),  # noqa
        '7fe3xx24': ('ST', '1', '', ''),  # noqa
        '7fe3xx25': ('SS', '1', '', ''),  # noqa
    },
    'SIEMENS MED DISPLAY': {
        '0029xx04': ('CS', '1', 'Photometric Interpretation', ''),  # noqa
        '0029xx10': ('US', '1', 'Rows', ''),  # noqa
        '0029xx11': ('US', '1', 'Columns', ''),  # noqa
        '0029xx20': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx50': ('US', '2', 'Origin', ''),  # noqa
        '0029xx80': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx99': ('LO', '1', 'Shutter Type', ''),  # noqa
        '0029xxa0': ('US', '1', 'Rows of Rectangular Shutter', ''),  # noqa
        '0029xxa1': ('US', '1', 'Columns of Rectangular Shutter', ''),  # noqa
        '0029xxa2': ('US', '1', 'Origin of Rectangular Shutter', ''),  # noqa
        '0029xxb0': ('US', '1', 'Radius of Circular Shutter', ''),  # noqa
        '0029xxb2': ('US', '1', 'Origin of Circular Shutter', ''),  # noqa
        '0029xxc1': ('US', '1', 'Contour of Irregular Shutter', ''),  # noqa
    },
    'SIEMENS MED DISPLAY 0000': {
        '0029xx99': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xxc1': ('US', '1-n', 'Unknown', ''),  # noqa
    },
    'SIEMENS MED ECAT FILE INFO': {
        '0021xx00': ('OB', '1', 'ECAT_Main_Header', ''),  # noqa
        '0021xx01': ('OB', '1', 'ECAT_Image_Subheader', ''),  # noqa
    },
    'SIEMENS MED HG': {
        '0029xx10': ('US', '1', 'List of Group Numbers', ''),  # noqa
        '0029xx15': ('LO', '1', 'List of Shadow Owner Codes', ''),  # noqa
        '0029xx20': ('US', '1', 'List of Element Numbers', ''),  # noqa
        '0029xx30': ('US', '1', 'List of Total Display Length', ''),  # noqa
        '0029xx40': ('LO', '1-n', 'List of Display Prefix', ''),  # noqa
        '0029xx50': ('LO', '1-n', 'List of Display Postfix', ''),  # noqa
        '0029xx60': ('US', '1', 'List of Text Position', ''),  # noqa
        '0029xx70': ('LO', '1', 'List of Text Concatenation', ''),  # noqa
    },
    'SIEMENS MED MAMMO': {
        '0029xx5a': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS MED MG': {
        '0029xx10': ('US', '1', 'List of Group Numbers', ''),  # noqa
        '0029xx15': ('LO', '1', 'List of Shadow Owner Codes', ''),  # noqa
        '0029xx20': ('US', '1', 'List of Element Numbers', ''),  # noqa
        '0029xx30': ('US', '1', 'List of Total Display Length', ''),  # noqa
        '0029xx40': ('LO', '1-n', 'List of Display Prefix', ''),  # noqa
        '0029xx50': ('LO', '1-n', 'List of Display Postfix', ''),  # noqa
        '0029xx60': ('US', '1', 'List of Text Position', ''),  # noqa
        '0029xx70': ('LO', '1', 'List of Text Concatenation', ''),  # noqa
    },
    'SIEMENS MED NM': {
        '0009xx80': ('LO', '1', 'Main Acquisition View', ''),  # noqa
        '0011xx10': ('CS', '1', 'Organ System', ''),  # noqa
        '0017xx00': ('ST', '1', 'Unknown 0017 0000', ''),  # noqa
        '0017xx20': ('CS', '1', 'Scanning Sequence', ''),  # noqa
        '0017xx60': ('DS', '1', 'KVP', ''),  # noqa
        '0017xx70': ('ST', '1', 'Unknown', ''),  # noqa
        '0017xx80': ('ST', '1-n', 'Unknown 0017 0080', ''),  # noqa
        '0019xx01': ('SS', '1', 'Number of detectors', ''),  # noqa
        '0019xx02': ('SS', '1', 'Number of scalers', ''),  # noqa
        '0019xx03': ('SS', '1', 'Scaler Index', ''),  # noqa
        '0019xx04': ('DS', '1', 'Radionuclide Units', ''),  # noqa
        '0019xx05': ('DS', '1', 'Radiopharmaceutical', ''),  # noqa
        '0019xx06': ('FL', '1', 'Display Magnification', ''),  # noqa
        '0019xx07': ('SL', '1', 'Scaler Counts', ''),  # noqa
        '0019xx08': ('SS', '1', 'Processed Flag 0 Raw 1 Process', ''),  # noqa
        '0019xx09': ('SS', '1', 'MicroDELTA Parameter Blocks', ''),  # noqa
        '0019xx0a': ('LO', '1', 'MicroDELTA File Extension', ''),  # noqa
        '0019xx0b': ('LO', '1', 'MicroDELTA Write ID', ''),  # noqa
        '0019xx0c': ('SS', '1', 'MicroDELTA Write Version', ''),  # noqa
        '0019xx0d': ('CS', '1', 'MicroDELTA Mode', ''),  # noqa
        '0019xx0e': ('LO', '1', 'MicroDELTA ESFR', ''),  # noqa
        '0019xx0f': ('SL', '1', 'Siemens ICON Data Type', ''),  # noqa
        '0019xx10': ('OW', '1', 'MicroDELTA Expansion Blocks', ''),  # noqa
        '0019xx11': ('CS', '1', 'MicroDELTA Version', ''),  # noqa
        '0019xx12': ('LO', '1', 'MicroDELTA Trend', ''),  # noqa
        '0019xx13': ('SS', '1', 'MicroDELTA Number of Overlays', ''),  # noqa
        '0019xx14': ('SS', '1', 'MicroDELTA Overlay Block', ''),  # noqa
        '0019xx15': ('SS', '1', 'MicroDELTA Color Table Extra', ''),  # noqa
        '0019xx16': ('SS', '1', 'Number of Views', ''),  # noqa
        '0019xx17': ('SS', '1', 'MicroDELTA Thyroid Markers', ''),  # noqa
        '0019xx18': ('SS', '1', 'MicroDELTA Color Table Used', ''),  # noqa
        '0019xx19': ('SS', '1', 'Save Screen Flag 1 SaveScreen', ''),  # noqa
        '0019xx1a': ('SS', '1', 'MicroDELTA Overlay Map', ''),  # noqa
        '0019xx1b': ('SS', '1', 'SGI Converted LookUp Table', ''),  # noqa
        '0019xx1c': ('SS', '1', 'MicroDELTA Mystery1', ''),  # noqa
        '0019xx1d': ('SS', '1', 'MicroDELTA Mystery2', ''),  # noqa
        '0019xx20': ('FL', '1', 'Time of Lasix Administration', ''),  # noqa
        '0019xx21': ('FL', '1', 'Lasix Dose mg', ''),  # noqa
        '0019xx22': ('FL', '1', 'Bladder Esidual Volume cc', ''),  # noqa
        '0019xx23': ('SS', '1', 'Bladder Image Extension', ''),  # noqa
        '0019xx24': ('FL', '1', 'Serum Creatinine mg/dl', ''),  # noqa
        '0019xx25': ('FL', '1', 'TER', ''),  # noqa
        '0019xx26': ('FL', '1', 'TER Lower Limit', ''),  # noqa
        '0019xx27': ('FL', '1', 'Body Surface Area m2', ''),  # noqa
        '0019xx30': ('FL', '1', 'CTQ Normal Margin', ''),  # noqa
        '0019xx31': ('FL', '1', 'CTQ Abnormal Sagittal Margin', ''),  # noqa
        '0019xx32': ('FL', '1', 'CTQ Abnormal Oblique Margin', ''),  # noqa
        '0019xx41': ('SS', '1', 'Accepted Beats', ''),  # noqa
        '0019xx42': ('SS', '1', 'Rejected Beats', ''),  # noqa
        '0019xx43': ('SS', '1', 'Percent of R-R Interval Framed', ''),  # noqa
        '0019xx44': ('SS', '1', 'Beats Rejected Post PVC', ''),  # noqa
        '0019xx45': ('FL', '1', 'Trigger Source', ''),  # noqa
        '0019xx47': ('FL', '1', 'Beat Rejection Parameter', ''),  # noqa
        '0019xx48': ('SH', '1', 'Rejection Scheme', ''),  # noqa
        '0019xx49': ('FL', '1', 'PVC Threshold msec', ''),  # noqa
        '0019xx4a': ('SS', '1', 'Framing Mode 1 Forward 2 F/B', ''),  # noqa
        '0019xx4b': ('SS', '1', 'Autobeat Window 0 No 1 Yes', ''),  # noqa
        '0019xx4c': ('FL', '1', 'MicroDELTA Acquisition Time per Window msec', ''),  # noqa
        '0019xx4e': ('SS', '1', 'CTQ Unknown Entry Count', ''),  # noqa
        '0019xx4f': ('SS', '1', 'CTQ Matrix Size', ''),  # noqa
        '0019xx50': ('SS', '1', 'CTQ has been used', ''),  # noqa
        '0019xx51': ('SS', '1', 'CTQ Male Entry Count', ''),  # noqa
        '0019xx52': ('SS', '1', 'CTQ Female Entry Count', ''),  # noqa
        '0019xx53': ('SS', '1', 'CTQ Stress/Rest Time Delay', ''),  # noqa
        '0019xx54': ('CS', '1', 'CTQ Time Delay Units', ''),  # noqa
        '0019xx55': ('SS', '1', 'CTQ Min Oblique Stack Count', ''),  # noqa
        '0019xx56': ('SS', '1', 'CTQ Max Oblique Stack Count', ''),  # noqa
        '0019xx57': ('SS', '1', 'CTQ Min Sagittal Stack Count', ''),  # noqa
        '0019xx58': ('SS', '1', 'CTQ Max Sagittal Stack Count', ''),  # noqa
        '0019xx59': ('SS', '1', 'CTQ Min Radius Percent', ''),  # noqa
        '0019xx5a': ('UL', '1', 'CTQ Find Max or Average Flag', ''),  # noqa
        '0019xx5b': ('SS', '1', 'CTQ Basal Slice Index Offset', ''),  # noqa
        '0019xx5c': ('SS', '1', 'CTQ Starting Line Index', ''),  # noqa
        '0019xx5d': ('SS', '1', 'CTQ Line Counts', ''),  # noqa
        '0019xx5e': ('SS', '1', 'CTQ Radii Counts', ''),  # noqa
        '0019xx5f': ('SS', '1', 'CTQ Radial Angle Increment', ''),  # noqa
        '0019xx60': ('SS', '1', 'Whole Body Processed Flag 0:Raw 1:Img1-Img2 2:Im', ''),  # noqa
        '0019xx61': ('SS', '1', 'Whole Body View', ''),  # noqa
        '0019xx62': ('SS', '1', 'WB Display Field Length in cm', ''),  # noqa
        '0019xx63': ('SS', '1', 'WB Scan Length in cm', ''),  # noqa
        '0019xx64': ('SS', '1', 'WB Scan Speed cm/min', ''),  # noqa
        '0019xx65': ('SS', '1', 'WB Scan Speed Mode 0 Manual 1 Auto', ''),  # noqa
        '0019xx66': ('SS', '1', 'WB Scan Start 0 Head 1 Feet', ''),  # noqa
        '0019xx67': ('SS', '1', 'WB Scan Direction 0 Lt to Rt 1 Rt to Lt', ''),  # noqa
        '0019xx68': ('FL', '1', 'WB Aperature Width in cm', ''),  # noqa
        '0019xx69': ('SS', '1', 'WB Number of Passes', ''),  # noqa
        '0019xx6a': ('SS', '1', 'WB Scan Time msec', ''),  # noqa
        '0019xx6b': ('FL', '1', 'WB Anterior kCounts View 1', ''),  # noqa
        '0019xx6c': ('FL', '1', 'WB Anterior kCounts View 2', ''),  # noqa
        '0019xx6d': ('FL', '1', 'WB Count Density', ''),  # noqa
        '0019xx6e': ('SS', '1', 'WB Reference View Flag 1 Ref', ''),  # noqa
        '0019xx6f': ('FL', '1', 'WB Coun Density Speed cm/min', ''),  # noqa
        '0019xx70': ('CS', '1', 'WB Scan Type', ''),  # noqa
        '0019xx71': ('LO', '1', 'WB IRIS Corr. File Name', ''),  # noqa
        '0019xx72': ('FL', '1', 'WB Posterior kCounts View 1', ''),  # noqa
        '0019xx73': ('FL', '1', 'WB Posterior kCounts View 2', ''),  # noqa
        '0019xx74': ('SS', '1', 'WB Ant View Status No Img 1 Complete 2 Aborted', ''),  # noqa
        '0019xx75': ('SS', '1', 'WB Post View Status No Img 1 Complete 2 Aborted', ''),  # noqa
        '0019xx76': ('SS', '1', 'WB Post Scan Time msec', ''),  # noqa
        '0019xx77': ('SS', '1', 'WB Ant Pixel Overflow 1 Yes', ''),  # noqa
        '0019xx78': ('SS', '1', 'WB Post Pixel Overflow 1 Yes', ''),  # noqa
        '0019xx7f': ('SS', '1', 'Segment Type 0 Segments 2 Time/Segment', ''),  # noqa
        '0019xx80': ('SS', '1', 'Number of Segments', ''),  # noqa
        '0019xx81': ('SS', '1', 'PVC Rejection Flag 1 Reject', ''),  # noqa
        '0019xx82': ('SL', '1', 'Total Counts Framed', ''),  # noqa
        '0019xx83': ('SS', '1', 'Total Beats Framed', ''),  # noqa
        '0019xx84': ('SS', '1', 'Present Time of Day', ''),  # noqa
        '0019xx85': ('SS', '1', 'Framed Counts', ''),  # noqa
        '0019xx86': ('SS', '1', 'Time per Segment msec', ''),  # noqa
        '0019xx87': ('LT', '1', 'BBA Miscellaneous Info', ''),  # noqa
        '0019xx88': ('SL', '1', 'Tolerance %', ''),  # noqa
        '0019xx89': ('SS', '1', 'SWG', ''),  # noqa
        '0019xx8a': ('SL', '1', 'R-R Interval msec', ''),  # noqa
        '0019xx8d': ('SL', '1', 'Total Counts in Acquisition', ''),  # noqa
        '0019xx8e': ('SL', '1', 'Rejection Type', ''),  # noqa
        '0019xx91': ('FL', '1', 'Phase Total Counts', ''),  # noqa
        '0019xx92': ('SL', '1', 'Phase Pause msec', ''),  # noqa
        '0019xx93': ('SL', '1', 'Phase Start msec', ''),  # noqa
        '0019xx94': ('SS', '1', 'Window Center Method 0 Avg 1 Peak', ''),  # noqa
        '0019xx95': ('SS', '1', 'Number of Beats to Average', ''),  # noqa
        '0019xx96': ('FL', '1', 'Histogram Bin Interval msec', ''),  # noqa
        '0019xx97': ('SS', '1', 'Counts in Peak Bin', ''),  # noqa
        '0019xxa0': ('SS', '1', 'VPDs Detected', ''),  # noqa
        '0019xxa1': ('SS', '1', 'Number of Phases', ''),  # noqa
        '0019xxa2': ('SL', '1', 'Requested Frame Duration msec', ''),  # noqa
        '0019xxa3': ('SL', '1', 'Frames per Phase', ''),  # noqa
        '0019xxa4': ('SL', '1', 'Frame Pause msec', ''),  # noqa
        '0019xxa5': ('SS', '1-n', 'Number of repeats per phase', ''),  # noqa
        '0019xxa6': ('SS', '1-n', 'Cycles per repeat', ''),  # noqa
        '0019xxa7': ('SL', '1-n', 'Repeat start time', ''),  # noqa
        '0019xxa8': ('SL', '1-n', 'Repeat stop time', ''),  # noqa
        '0019xxa9': ('SL', '1-n', 'Effective repeat time', ''),  # noqa
        '0019xxaa': ('SS', '1-n', 'Acquired cycles per repeat', ''),  # noqa
        '0019xxc0': ('FL', '1', 'Head Tilt degrees', ''),  # noqa
        '0019xxc1': ('SS', '1', 'Uniformity Correction Flag', ''),  # noqa
        '0019xxc2': ('SS', '1', 'Overflow Flag', ''),  # noqa
        '0019xxc3': ('ST', '1', 'Unknown', ''),  # noqa
        '0019xxf0': ('FL', '1', 'Pixel Dimensions', ''),  # noqa
        '001fxx50': ('DS', '1', 'Location RET', ''),  # noqa
        '0021xx00': ('OB', '1', 'ECAT File Menu Header', ''),  # noqa
        '0021xx01': ('OB', '1', 'ECAT File Subheader', ''),  # noqa
        '0021xx10': ('ST', '1', 'Unknown', ''),  # noqa
        '0031xx01': ('LO', '1', 'Camera Name', ''),  # noqa
        '0031xx02': ('SS', '1', 'Unknown Element 0031 02', ''),  # noqa
        '0031xx03': ('FL', '1', 'External Zoom', ''),  # noqa
        '0031xx04': ('FL', '1', 'CCD Energy Level', ''),  # noqa
        '0031xx05': ('SS', '1', 'CCD Window Width', ''),  # noqa
        '0031xx06': ('FL', '1', 'CCD Window Offset', ''),  # noqa
        '0031xx07': ('SS', '1', 'CCD Peaking Mode', ''),  # noqa
        '0031xx08': ('LO', '1', 'CCD Autopeak Function', ''),  # noqa
        '0031xx09': ('SS', '1', 'CCD Count Rate Mode', ''),  # noqa
        '0031xx0a': ('SS', '1', 'Analog Output Device', ''),  # noqa
        '0031xx0b': ('SS', '1', 'Communication Type', ''),  # noqa
        '0031xx0c': ('SS', '1', 'Control Unit 1 ICON 2 DOT 3 ScintiView', ''),  # noqa
        '0031xx0d': ('SS', '1', 'WAM Mode', ''),  # noqa
        '0031xx0e': ('SS', '1', 'Event Control Mode', ''),  # noqa
        '0031xx0f': ('FL', '1', 'Zoom X Offset 0.1 mm', ''),  # noqa
        '0031xx10': ('FL', '1', 'Zoom Y Offset 0.1 mm', ''),  # noqa
        '0031xx11': ('SS', '1', 'Gantry Zero Position', ''),  # noqa
        '0031xx12': ('SS', '1', 'Unknown', ''),  # noqa
        '0031xx13': ('ST', '1', 'Unknown', ''),  # noqa
        '0031xx14': ('ST', '1', 'Unknown', ''),  # noqa
        '0031xx15': ('SL', '1-n', 'Unknown', ''),  # noqa
        '0031xx16': ('SL', '1-n', 'Unknown', ''),  # noqa
        '0031xx17': ('SS', '1-n', 'Unknown', ''),  # noqa
        '0031xx20': ('ST', '1', 'Unknown', ''),  # noqa
        '0031xx21': ('SS', '1', 'Unknown', ''),  # noqa
        '0033xx00': ('FL', '1-n', 'Flood correction Matrix Det 1 up to SR 2.0', ''),  # noqa
        '0033xx01': ('FL', '1-n', 'Flood correction Matrix Det 2 up to SR 2.0', ''),  # noqa
        '0033xx10': ('FL', '1-n', 'COR Data for Detector 1', ''),  # noqa
        '0033xx11': ('FL', '1-n', 'COR Data for Detector 2', ''),  # noqa
        '0033xx14': ('FL', '1', 'MHR ( Y-Shift) data for detector 1', ''),  # noqa
        '0033xx15': ('FL', '1', 'MHR ( Y-Shift) data for detector 2', ''),  # noqa
        '0033xx18': ('FL', '1-n', 'NCO Data for detector 1', ''),  # noqa
        '0033xx19': ('FL', '1-n', 'NCO Data for detector 2', ''),  # noqa
        '0033xx20': ('FL', '1', 'Bed correction angle', ''),  # noqa
        '0033xx21': ('FL', '1', 'Gantry correction angle', ''),  # noqa
        '0033xx22': ('SS', '1-n', 'Bed U/D correction data', ''),  # noqa
        '0033xx23': ('SS', '1-n', 'Unknown', ''),  # noqa
        '0033xx24': ('FL', '1', 'Backprojection angle head 1', ''),  # noqa
        '0033xx25': ('FL', '1', 'Backprojection angle head 2', ''),  # noqa
        '0033xx28': ('SL', '1', 'Number of point sources used for NCO and MHR', ''),  # noqa
        '0033xx29': ('FL', '1', 'Crystal thickness', ''),  # noqa
        '0033xx30': ('LO', '1', 'Preset name used for acquisition', ''),  # noqa
        '0033xx31': ('FL', '1', 'Camera config angle', ''),  # noqa
        '0033xx32': ('LO', '1', 'Crystal type Startburst or not', ''),  # noqa
        '0033xx33': ('SL', '1', 'Gantry step for COIN acquisitions', ''),  # noqa
        '0033xx34': ('FL', '1', 'Bed step for wholebody or Coin acquisitions', ''),  # noqa
        '0033xx35': ('FL', '1', 'Weight factor table for coincidence acquisitions', ''),  # noqa
        '0033xx36': ('FL', '1', 'Transaxial acceptance width for coincidence', ''),  # noqa
        '0033xx37': ('SL', '1', 'Starburst flags', ''),  # noqa
        '0033xx38': ('FL', '1', 'Pixel scale factor', ''),  # noqa
        '0035xx00': ('LO', '1', 'Specialized tomo type', ''),  # noqa
        '0035xx01': ('LO', '1', 'Energy window type', ''),  # noqa
        '0035xx02': ('SS', '1', 'Start and end row illuminated by wind position', ''),  # noqa
        '0035xx03': ('LO', '1', 'Blank scan image for profile', ''),  # noqa
        '0035xx04': ('SS', '1', 'Repeat number of the original dynamic SPECT', ''),  # noqa
        '0035xx05': ('SS', '1', 'Phase number of the original dynamic SPECT', ''),  # noqa
        '0037xx00': ('OW', '1', 'Flood correction matrix Detector 1', ''),  # noqa
        '0037xx80': ('OW', '1', 'Flood correction matrix Detector 2', ''),  # noqa
        '0039xx00': ('LT', '1', 'Toshiba CBF activity results', ''),  # noqa
        '0041xx01': ('SL', '1', 'Unknown', ''),  # noqa
        '0041xx02': ('SL', '1', 'Unknown', ''),  # noqa
        '0041xx05': ('FD', '1-n', 'Unknown', ''),  # noqa
        '0041xx06': ('FD', '1-n', 'Unknown', ''),  # noqa
        '0041xx07': ('FD', '1-n', 'Unknown', ''),  # noqa
        '0041xx08': ('FD', '1-n', 'Unknown', ''),  # noqa
        '0041xx11': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0041xx21': ('LO', '1', 'Text Relating to Data Object', ''),  # noqa
        '0041xx30': ('DA', '1', 'Folder Creation Date', ''),  # noqa
        '0041xx32': ('TM', '1', 'Folder Creation Time', ''),  # noqa
        '0041xx34': ('DA', '1', 'Folder Modification Date', ''),  # noqa
        '0041xx36': ('TM', '1', 'Folder Modification Time', ''),  # noqa
        '0041xx40': ('LO', '1', 'Folder Owner Name', ''),  # noqa
        '0041xx50': ('SS', '1', 'Folder Status', ''),  # noqa
        '0041xx70': ('SL', '1', 'Number of Images in Folder', ''),  # noqa
        '0041xx71': ('SL', '1', 'Number of Non-Image Objects', ''),  # noqa
        '0043xx01': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0043xx03': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0043xx04': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0051xx10': ('SS', '1', 'Number of Windows', ''),  # noqa
        '0051xx11': ('SS', '1', 'Average Heart Rate BPM', ''),  # noqa
        '0051xx12': ('SS', '1', 'Accepted Beats in Window', ''),  # noqa
        '0051xx13': ('SS', '1', 'Average R-R Interval msec', ''),  # noqa
        '0051xx14': ('SS', '1', 'Window Width %', ''),  # noqa
        '0051xx15': ('SL', '1', 'Hottest Pixel in Window', ''),  # noqa
        '0051xx18': ('SL', '1', 'Total Counts in Window', ''),  # noqa
        '0053xx01': ('SS', '1', 'Terminate on Pixel Overflow Flag 1 Terminate', ''),  # noqa
        '0053xx02': ('SS', '1', 'Terminate on List Buffer Overflow Flag', ''),  # noqa
        '0053xx03': ('SS', '1', 'First Frame by Counts', ''),  # noqa
        '0053xx10': ('SS', '1', 'Elapsed Time Start Condition 0 None 1 Any 2 All', ''),  # noqa
        '0053xx11': ('SL', '1', 'Elapsed Time Start msec', ''),  # noqa
        '0053xx12': ('SS', '1', 'Count Rate Start Condition 0 None 1 Any 2 All', ''),  # noqa
        '0053xx13': ('SL', '1', 'Count Rate Start', ''),  # noqa
        '0053xx14': ('SS', '1', 'Start Heart Beat Count Condition 0 None 1 Any 2', ''),  # noqa
        '0053xx15': ('SL', '1', 'Start Heart Beat Count', ''),  # noqa
        '0053xx16': ('SS', '1', 'Start Heart Rate Threshold Condition', ''),  # noqa
        '0053xx17': ('SS', '1', 'Start Heart Rate Increasing Flag', ''),  # noqa
        '0053xx18': ('SL', '1', 'Start Heart Rate', ''),  # noqa
        '0053xx19': ('SL', '1', 'Manual Stop Flag 0 No 1 Yes', ''),  # noqa
        '0053xx1a': ('SS', '1', 'Elapsed Time Stop Condition 0 None 1 Any 2 All', ''),  # noqa
        '0053xx1b': ('SL', '1', 'Elapsed Time Stop', ''),  # noqa
        '0053xx1c': ('SS', '1', 'Stop Heart Beat Count Condition 0 None 1 Any 2 A', ''),  # noqa
        '0053xx1d': ('SL', '1', 'Stop Heart Beat Count', ''),  # noqa
        '0053xx30': ('SS', '1', 'Info Density Stop Condition', ''),  # noqa
        '0053xx31': ('SS', '1', 'Info Density Stop Scaler', ''),  # noqa
        '0053xx32': ('SS', '1', 'Info Density Stop Region', ''),  # noqa
        '0053xx33': ('SL', '1', 'Info Density Stop Count', ''),  # noqa
        '0053xx40': ('SS', '1', 'Stop Condition Status 0 None 1 Any 2 All', ''),  # noqa
        '0053xx41': ('SL', '1', 'Stop Count', ''),  # noqa
        '0053xx42': ('SS', '1', 'Stop Count Condition Status 0 None 1 Any 2 All', ''),  # noqa
        '0053xx43': ('SL', '1', 'Stop Time', ''),  # noqa
        '0053xx44': ('SS', '1', 'Stop Time Condition Status 0 None 1 Any 2 All', ''),  # noqa
        '0055xx02': ('SS', '1', 'Unknown 55-02', ''),  # noqa
        '0055xx04': ('SS', '1', 'Prompt window width', ''),  # noqa
        '0055xx05': ('SS', '1', 'Random window width', ''),  # noqa
        '0055xx20': ('SS', '1', 'Flood Corr. Flag 1 Corr', ''),  # noqa
        '0055xx21': ('DS', '1', 'Flood Acquisition Date', ''),  # noqa
        '0055xx30': ('SS', '1', 'COR Corr. Flag 1 Corr', ''),  # noqa
        '0055xx31': ('DA', '1', 'COR Acquisition Date', ''),  # noqa
        '0055xx38': ('OW', '1', 'COR Data', ''),  # noqa
        '0055xx40': ('SS', '1', 'Noncircular Orbit Flag 1 NCO', ''),  # noqa
        '0055xx48': ('FL', '1', 'NCO Values', ''),  # noqa
        '0055xx4c': ('SL', '1', 'Unknown', ''),  # noqa
        '0055xx4d': ('SL', '1', 'Unknown', ''),  # noqa
        '0055xx50': ('SS', '1', 'Prone Flag 0 Supine 1 Prone', ''),  # noqa
        '0055xx51': ('SS', '1', 'Orbit 0 Circular 1 Elliptical', ''),  # noqa
        '0055xx52': ('SS', '1', 'Total Rotation in Degrees', ''),  # noqa
        '0055xx53': ('CS', '1', 'Zero Location (T=Top B=Bottom)', ''),  # noqa
        '0055xx54': ('FL', '1', 'Angular Step', ''),  # noqa
        '0055xx55': ('FL', '1', 'Start Angle', ''),  # noqa
        '0055xx56': ('SS', '1', 'Decay Corr. Flag 1 Corr', ''),  # noqa
        '0055xx57': ('SS', '1', 'Scatter Corr. Flag 1 Corr', ''),  # noqa
        '0055xx58': ('FL', '1', 'Radial Map Info in 0.1 mm Inc.', ''),  # noqa
        '0055xx59': ('CS', '1', 'Direction H HeadIn F FeetIn', ''),  # noqa
        '0055xx5a': ('FL', '1', 'Table Traverse cm', ''),  # noqa
        '0055xx5b': ('SS', '1', 'Multiplexor Flag 1 Multiplexed', ''),  # noqa
        '0055xx5c': ('DS', '1', 'Pixel Acquisition Date', ''),  # noqa
        '0055xx5d': ('SS', '1', 'Angle Type 1 360o 2 128 Steps', ''),  # noqa
        '0055xx5e': ('SL', '1', 'Orbit Definition', ''),  # noqa
        '0055xx5f': ('FL', '1', 'Arm Length in cm', ''),  # noqa
        '0055xx60': ('SS', '1', 'Auto Window Beats', ''),  # noqa
        '0055xx61': ('SS', '1', 'Non-gated File Extension', ''),  # noqa
        '0055xx64': ('SS', '1', 'TIC Error Values', ''),  # noqa
        '0055xx65': ('SS', '1', 'X1', ''),  # noqa
        '0055xx66': ('SS', '1', 'Y1', ''),  # noqa
        '0055xx67': ('SS', '1', 'X2', ''),  # noqa
        '0055xx68': ('SS', '1', 'Y2', ''),  # noqa
        '0055xx69': ('SS', '1', 'X3', ''),  # noqa
        '0055xx6a': ('SS', '1', 'Y3', ''),  # noqa
        '0055xx6b': ('SS', '1', 'X4', ''),  # noqa
        '0055xx6c': ('SS', '1', 'Y4', ''),  # noqa
        '0055xx6d': ('SS', '1', 'Pixel Size Flag 1 Valid Size', ''),  # noqa
        '0055xx70': ('FL', '1', 'X Focal Length', ''),  # noqa
        '0055xx71': ('FL', '1', 'Y Focal Length', ''),  # noqa
        '0055xx72': ('FL', '1', 'X Gains', ''),  # noqa
        '0055xx73': ('FL', '1', 'Y Gains', ''),  # noqa
        '0055xx74': ('FL', '1', 'X Offset', ''),  # noqa
        '0055xx75': ('FL', '1', 'Y Offset', ''),  # noqa
        '0055xx76': ('FL', '1', 'X Principal Ray', ''),  # noqa
        '0055xx77': ('FL', '1', 'Y Principal Ray', ''),  # noqa
        '0055xx78': ('FL', '1', 'Total Flood Counts', ''),  # noqa
        '0055xx7e': ('FL', '1-n', 'Collimator thickness', ''),  # noqa
        '0055xx7f': ('FL', '1-n', 'Collimator angular resolution', ''),  # noqa
        '0055xx80': ('SS', '1', 'File Altered Flag 1 Altered', ''),  # noqa
        '0055xx81': ('SS', '1', 'Raw Data Extension', ''),  # noqa
        '0055xx82': ('SS', '1', 'Sagittal Extension', ''),  # noqa
        '0055xx83': ('SS', '1', 'Coronal Extension', ''),  # noqa
        '0055xx84': ('SS', '1', 'Transverse Extension', ''),  # noqa
        '0055xx85': ('SS', '1', 'Volume Rendered Extension', ''),  # noqa
        '0055xx86': ('SL', '1', 'Plane of Transverse Bottom Slice', ''),  # noqa
        '0055xx87': ('SL', '1', 'Plane of Transverse Top Slice', ''),  # noqa
        '0055xx88': ('SL', '1', 'Slice Step in Pixels', ''),  # noqa
        '0055xx8a': ('SL', '1', 'Y-Axis Smooth Slice Weights', ''),  # noqa
        '0055xx8b': ('SL', '1', 'Number of Transverse Slices', ''),  # noqa
        '0055xx8c': ('SS', '1', 'Attenuation Flag 1 Chang 2 Sorenson', ''),  # noqa
        '0055xx8d': ('SS', '1', 'Sagittal Right Limit', ''),  # noqa
        '0055xx8e': ('SS', '1', 'Sagittal Left Limit', ''),  # noqa
        '0055xx8f': ('SS', '1', 'Coronal Posterior Limit', ''),  # noqa
        '0055xx90': ('SS', '1', 'Coronal Anterior Limit', ''),  # noqa
        '0055xx91': ('SS', '1', 'Isotope Used in Reconstruction', ''),  # noqa
        '0055xx93': ('FL', '1', 'Filter Cutoff Frequency', ''),  # noqa
        '0055xx94': ('FL', '1', 'Filter Alpha Coefficient', ''),  # noqa
        '0055xx95': ('FL', '1', 'Filter Order', ''),  # noqa
        '0055xx96': ('FL', '1', 'Attenuation Cooefficient', ''),  # noqa
        '0055xx97': ('SS', '1', 'Percent Ray', ''),  # noqa
        '0055xx98': ('SS', '1', 'Astigmatic Collimator 1 Neuro 2 Cardiac', ''),  # noqa
        '0055xx99': ('SS', '1', 'XP0', ''),  # noqa
        '0055xx9a': ('SS', '1', 'ZP0', ''),  # noqa
        '0055xx9b': ('SS', '1', 'XP1', ''),  # noqa
        '0055xx9c': ('SS', '1', 'ZP1', ''),  # noqa
        '0055xx9d': ('FL', '1', 'Rotation Matrix', ''),  # noqa
        '0055xx9e': ('FL', '1', 'X0', ''),  # noqa
        '0055xx9f': ('FL', '1', 'X1', ''),  # noqa
        '0055xxa0': ('FL', '1', 'Y0', ''),  # noqa
        '0055xxa1': ('FL', '1', 'Y1', ''),  # noqa
        '0055xxa2': ('FL', '1', 'Z0', ''),  # noqa
        '0055xxa3': ('FL', '1', 'Z1', ''),  # noqa
        '0055xxa4': ('SS', '1', 'Transverse Scale', ''),  # noqa
        '0055xxa5': ('FL', '1', 'Pixel Size X Direction mm', ''),  # noqa
        '0055xxa6': ('FL', '1', 'Pixel Size Y Direction mm', ''),  # noqa
        '0055xxa7': ('SS', '1', 'Regions File Extension', ''),  # noqa
        '0055xxa8': ('SS', '1', 'Gated SPECT Bins Reconstructed', ''),  # noqa
        '0055xxa9': ('SS', '1', 'Vertical Oblique Image', ''),  # noqa
        '0055xxb0': ('SS', '1', 'Oblique Region First Slice', ''),  # noqa
        '0055xxb1': ('SS', '1', 'Oblique Region Last Slice', ''),  # noqa
        '0055xxc0': ('SS', '1-n', 'Unknown', ''),  # noqa
        '0055xxc2': ('SS', '1', 'Unknown', ''),  # noqa
        '0055xxc3': ('SS', '1', 'Unknown', ''),  # noqa
        '0055xxc4': ('SS', '1', 'Unknown', ''),  # noqa
        '0055xxd0': ('SS', '1', 'Unknown', ''),  # noqa
        '0057xx01': ('LO', '1', 'e.soft DICOM original image type', ''),  # noqa
        '0057xx02': ('FL', '1', 'Dose calibration factor', ''),  # noqa
        '0057xx03': ('LO', '1', 'Units', ''),  # noqa
        '0057xx04': ('LO', '1', 'Decay correction', ''),  # noqa
        '0057xx05': ('SL', '1-n', 'Radio nuclide half life', ''),  # noqa
        '0057xx06': ('FL', '1', 'Rescale intercept', ''),  # noqa
        '0057xx07': ('FL', '1', 'Rescale Slope', ''),  # noqa
        '0057xx08': ('FL', '1', 'Frame reference time', ''),  # noqa
        '0057xx09': ('SL', '1', 'Number of Radiopharmaceutical information seq', ''),  # noqa
        '0057xx0a': ('FL', '1', 'Decay factor', ''),  # noqa
        '0057xx0b': ('LO', '1', 'Counts source', ''),  # noqa
        '0057xx0c': ('SL', '1-n', 'Radio Nuclide positron fraction', ''),  # noqa
        '0057xx10': ('SS', '1', 'Low Count', ''),  # noqa
        '0057xx20': ('SS', '1', 'Vertical Oblique Image', ''),  # noqa
        '5001xx02': ('SL', '1', 'Number of Points', ''),  # noqa
        '5001xx03': ('FL', '1', 'Minimal Value on X-Axis', ''),  # noqa
        '5001xx04': ('FL', '1', 'Maximal Value on X-Axis', ''),  # noqa
        '5001xx05': ('FL', '1', 'Minimal Value on Y-Axis', ''),  # noqa
        '5001xx06': ('FL', '1', 'Maximal Value on Y-Axis', ''),  # noqa
        '5001xx07': ('LO', '1', 'Curve Name', ''),  # noqa
        '5001xx08': ('LO', '1', 'Curve Function Label', ''),  # noqa
        '5001xx09': ('SH', '1', 'X Axis Label', ''),  # noqa
        '5001xx0a': ('SH', '1', 'Y Axis Label', ''),  # noqa
        '5001xx0b': ('OW', '1', 'Curve Data', ''),  # noqa
        '7fe1xx10': ('OW', '1', 'Compressed Pixel Data', ''),  # noqa
        '7fe3xx00': ('UL', '1', 'Length of Group 0x7FE3', ''),  # noqa
        '7fe3xx14': ('SL', '1', 'Lowest Pixel Value in THIS Frame', ''),  # noqa
        '7fe3xx15': ('SL', '1', 'Highest Pixel Value in THIS Frame', ''),  # noqa
        '7fe3xx16': ('SL', '1', 'Total Counts in THIS Frame', ''),  # noqa
        '7fe3xx17': ('SL', '1', 'Duration of THIS Frame msec', ''),  # noqa
        '7fe3xx18': ('FL', '1', 'Frame Angle', ''),  # noqa
        '7fe3xx19': ('LO', '1', 'Frame Name', ''),  # noqa
        '7fe3xx1a': ('FL', '1', 'View Number', ''),  # noqa
        '7fe3xx1b': ('SS', '1', 'Pixel Overflow Flag 1 Pixel Overflow', ''),  # noqa
        '7fe3xx1c': ('SS', '1', 'Buffer Overflow Flag 1 Buffer Overflow', ''),  # noqa
        '7fe3xx1e': ('SL', '1', 'Start Time of THIS Frame From Start of Study', ''),  # noqa
        '7fe3xx1f': ('SL', '1', 'ROI Maximum Pixel Value', ''),  # noqa
        '7fe3xx20': ('SL', '1', 'ROI Average Pixel Value', ''),  # noqa
        '7fe3xx21': ('SL', '1', 'ROI Total Counts', ''),  # noqa
        '7fe3xx22': ('SL', '1', 'ROI Total Pixels', ''),  # noqa
        '7fe3xx23': ('SL', '1', 'ROI Center Coordinates', ''),  # noqa
        '7fe3xx24': ('LO', '1', 'ROI Name', ''),  # noqa
        '7fe3xx25': ('SS', '1', 'ROI Data', ''),  # noqa
        '7fe3xx26': ('OW', '1', 'Unknown', ''),  # noqa
        '7fe3xx27': ('OW', '1', 'Unknown', ''),  # noqa
        '7fe3xx28': ('OW', '1', 'Unknown', ''),  # noqa
        '7fe3xx29': ('OW', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS MED OCS ACKNOWLEDGE FLAG': {
        '0039xx81': ('IS', '1', 'Acknowledge Flag', ''),  # noqa
    },
    'SIEMENS MED OCS AE TITLE': {
        '0039xx79': ('CS', '1', 'AE Title', ''),  # noqa
    },
    'SIEMENS MED OCS CALIBRATION DATE': {
        '0039xx81': ('CS', '1', 'Calibration Date', ''),  # noqa
    },
    'SIEMENS MED OCS CBT ARC INCREMENT': {
        '0039xx84': ('IS', '1-n', 'Arc Increment', ''),  # noqa
    },
    'SIEMENS MED OCS CBT ENDING GANTRY ANGLE': {
        '0039xx83': ('DS', '1-n', 'Ending Projection Angle', ''),  # noqa
    },
    'SIEMENS MED OCS CBT MISSING PROJECTION FRAMES': {
        '0039xx91': ('IS', '1-n', 'Missing Projection Frames', ''),  # noqa
    },
    'SIEMENS MED OCS CBT PATIENT_ORIENTATION': {
        '0039xx93': ('CS', '1', 'Patient Orientation', ''),  # noqa
    },
    'SIEMENS MED OCS CBT PROJECTION GANTRY POSITIONS': {
        '0039xx86': ('DS', '1-n', 'Gantry Positions', ''),  # noqa
    },
    'SIEMENS MED OCS CBT RECON FILTER TYPE': {
        '0039xx90': ('IS', '1', 'Reconstruction Filter Type', ''),  # noqa
    },
    'SIEMENS MED OCS CBT RECON NUM OF SLICES': {
        '0039xx89': ('IS', '1', 'Number of Reconstruction Slices', ''),  # noqa
    },
    'SIEMENS MED OCS CBT RECON SLICE HEIGHT': {
        '0039xx88': ('IS', '1', 'Reconstruction Slice Height', ''),  # noqa
    },
    'SIEMENS MED OCS CBT RECON SLICE WIDTH': {
        '0039xx87': ('IS', '1', 'Reconstruction Slice Width', ''),  # noqa
    },
    'SIEMENS MED OCS CBT ROTATION DIRECTION': {
        '0039xx85': ('CS', '1-n', 'Gantry Rotation Direction', ''),  # noqa
    },
    'SIEMENS MED OCS CBT STARTING GANTRY ANGLE': {
        '0039xx82': ('DS', '1-n', 'Starting Projection Angle', ''),  # noqa
    },
    'SIEMENS MED OCS CBT TOTAL_MU': {
        '0039xx96': ('DS', '1', 'Total MU delivered during Cone Beam', ''),  # noqa
    },
    'SIEMENS MED OCS COMMON EDGE': {
        '0039xx83': ('IS', '1', 'Common Edge', ''),  # noqa
    },
    'SIEMENS MED OCS FIELD ID': {
        '0039xx80': ('CS', '1', 'Field ID', ''),  # noqa
    },
    'SIEMENS MED OCS FIELD NAME': {
        '0039xx79': ('CS', '1', 'Field Name', ''),  # noqa
    },
    'SIEMENS MED OCS FP Alignment Calibration Date / Time': {
        '0039xx95': ('DT', '1', 'Flat Panel Alignment last calibration Date and Time', ''),  # noqa
    },
    'SIEMENS MED OCS I0 MU SCALE FACTOR': {
        '0039xx97': ('IS', '1', 'I0-MU Scale Factor', ''),  # noqa
    },
    'SIEMENS MED OCS ICC MATRIX': {
        '0039xx82': ('DS', '2', 'Image Center in Image Coordinates', ''),  # noqa
    },
    'SIEMENS MED OCS NUMBER OF FRAMES': {
        '0039xx76': ('IS', '1', 'Number of Frames', ''),  # noqa
    },
    'SIEMENS MED OCS NUMBER OF SUB FRAMES': {
        '0039xx77': ('IS', '1', 'Number of Sub-Frames', ''),  # noqa
    },
    'SIEMENS MED OCS PI ALIGNMENT IMAGE': {
        '0039xx94': ('IS', '1', 'Alignment Offset Valid Flag', ''),  # noqa
    },
    'SIEMENS MED OCS PI VALID PIXEL MAP': {
        '0039xx92': ('IS', '1', 'Valid Pixel Map Flag', ''),  # noqa
    },
    'SIEMENS MED OCS REFERENCE IMAGE': {
        '0039xx76': ('UI', '1', 'Reference Image', ''),  # noqa
    },
    'SIEMENS MED OCS REFERENCE LOCKED': {
        '0039xx88': ('IS', '1', 'Locked Flag', ''),  # noqa
    },
    'SIEMENS MED OCS SC IMG PIX SPC': {
        '0039xx87': ('DS', '2', 'Non-RT Image Pixel Spacing', ''),  # noqa
    },
    'SIEMENS MED OCS SC IMG SAD': {
        '0039xx86': ('DS', '1', 'Non-RT Image SAD', ''),  # noqa
    },
    'SIEMENS MED OCS SC IMG SID': {
        '0039xx85': ('DS', '1', 'Non-RT Image SID', ''),  # noqa
    },
    'SIEMENS MED OCS SCALED IMG PIX SPC': {
        '0039xx84': ('DS', '2', 'Scaled Image Pixel Spacing', ''),  # noqa
    },
    'SIEMENS MED OCS SITE NAME': {
        '0039xx78': ('CS', '1', 'Site Name', ''),  # noqa
    },
    'SIEMENS MED OCS TABLE LATERAL POSITION': {
        '0039xx98': ('DS', '1', 'Lateral Table Position', ''),  # noqa
    },
    'SIEMENS MED OCS TABLE LONGITUDINAL POSITION': {
        '0039xx99': ('DS', '1', 'Longitudinal Table Position', ''),  # noqa
    },
    'SIEMENS MED OCS TABLE OFFSET': {
        '0039xx78': ('DS', '3', 'Offset', ''),  # noqa
    },
    'SIEMENS MED OCS TABLE VERTICAL POSITION': {
        '0039xx75': ('DS', '1', 'vertical Table Position', ''),  # noqa
    },
    'SIEMENS MED OCS TRANS MATRIX': {
        '0039xx80': ('DS', '5', 'Transformation Matrix', ''),  # noqa
    },
    'SIEMENS MED SMS USG ANTARES': {
        '0019xx00': ('SH', '1', 'Private Creator Version', ''),  # noqa
        '0019xx03': ('UN', '1', 'Frame Rate', ''),  # noqa
        '0019xx0c': ('US', '1', 'Burned in Graphics', ''),  # noqa
        '0019xx0d': ('UN', '1', 'SieClear Index', ''),  # noqa
        '0019xx20': ('UN', '1', 'B-Mode Submode', ''),  # noqa
        '0019xx21': ('UN', '1', 'B-Mode Dynamic Range', ''),  # noqa
        '0019xx22': ('UN', '1', 'B-Mode Overall Gain', ''),  # noqa
        '0019xx23': ('UN', '1', 'B-Mode Res/Speed Index', ''),  # noqa
        '0019xx24': ('UN', '1', 'B-Mode Edge Enhance Index', ''),  # noqa
        '0019xx25': ('UN', '1', 'B-Mode Persistence Index', ''),  # noqa
        '0019xx26': ('UN', '1', 'B-Mode Map Index', ''),  # noqa
        '0019xx27': ('US', '1', '???', ''),  # noqa
        '0019xx28': ('US', '1', '???', ''),  # noqa
        '0019xx29': ('US', '1', '???', ''),  # noqa
        '0019xx2a': ('US', '1', 'B-Mode Tint Type', ''),  # noqa
        '0019xx2d': ('UN', '1', 'B-Mode Tint Index', ''),  # noqa
        '0019xx2e': ('UN', '1', 'ClarifyVE Index', ''),  # noqa
        '0019xx31': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx3a': ('UN', '1', 'Image Flag', ''),  # noqa
        '0019xx3b': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('UN', '1', 'Color Flow state', ''),  # noqa
        '0019xx41': ('UN', '1', 'Color Flow Wall Filter Index', ''),  # noqa
        '0019xx42': ('UN', '1', 'Color Flow Submode', ''),  # noqa
        '0019xx43': ('UN', '1', 'Color Flow Overall Gain', ''),  # noqa
        '0019xx44': ('UN', '1', 'Color Flow Res/Speed Index', ''),  # noqa
        '0019xx46': ('UN', '1', 'Color Flow Smooth Index', ''),  # noqa
        '0019xx47': ('UN', '1', 'Color Flow Persistence Index', ''),  # noqa
        '0019xx48': ('UN', '1', 'Color Flow Map Index', ''),  # noqa
        '0019xx49': ('UN', '1', 'Color Flow Priority Index', ''),  # noqa
        '0019xx54': ('UN', '1', 'Color Flow Maximum Velocity', ''),  # noqa
        '0019xx60': ('UN', '1', 'Doppler Dynamic Range', ''),  # noqa
        '0019xx61': ('UN', '1', 'Doppler Overall Gain', ''),  # noqa
        '0019xx62': ('UN', '1', 'Doppler Wall Filter', ''),  # noqa
        '0019xx63': ('UN', '1', 'Doppler Gate Size', ''),  # noqa
        '0019xx65': ('UN', '1', 'Doppler Map Index', ''),  # noqa
        '0019xx66': ('UN', '1', 'Doppler Submode', ''),  # noqa
        '0019xx67': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx69': ('UN', '1', 'Doppler Time/Freq Res Index', ''),  # noqa
        '0019xx6a': ('US', '1', 'Doppler Trace Inverted', ''),  # noqa
        '0019xx6c': ('US', '1', 'Doppler Tint Type', ''),  # noqa
        '0019xx72': ('UN', '1', 'Doppler Tint Index', ''),  # noqa
        '0019xx80': ('UN', '1', 'M-Mode Dynamic Range', ''),  # noqa
        '0019xx81': ('UN', '1', 'M-Mode Overall Gain', ''),  # noqa
        '0019xx82': ('UN', '1', 'M-Mode Edge Enhance Index', ''),  # noqa
        '0019xx83': ('UN', '1', 'M-Mode Map Index', ''),  # noqa
        '0019xx86': ('UN', '1', 'M-Mode Tint Type', ''),  # noqa
        '0019xx87': ('UN', '1', 'M-Mode Submode', ''),  # noqa
        '0019xx88': ('UN', '1', 'M-Mode Tint Index', ''),  # noqa
        '0019xxa0': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS MED SMS USG ANTARES 3D VOLUME': {
        '0039xx00': ('UN', '1', 'Release Version', ''),  # noqa
        '0039xx03': ('UN', '1', 'VolumeAcquisitionDuration', ''),  # noqa
        '0039xx04': ('UN', '1', 'VolumeRawDataType', ''),  # noqa
        '0039xx05': ('UN', '1', 'ScanType', ''),  # noqa
        '0039xx06': ('UN', '1', 'ZlateralMin', ''),  # noqa
        '0039xx07': ('UN', '1', 'ZlateralSpan', ''),  # noqa
        '0039xx08': ('UN', '1', 'ZRadiusOfCurvature', ''),  # noqa
        '0039xx09': ('UN', '1', 'WobbleCorrection', ''),  # noqa
        '0039xx10': ('UN', '1', 'ScaleAlongWidth', ''),  # noqa
        '0039xx11': ('UN', '1', 'ScaleAlongHeight', ''),  # noqa
        '0039xx12': ('UN', '1', 'ScaleAlongDepth', ''),  # noqa
        '0039xx13': ('UN', '1', 'BufferSize', ''),  # noqa
        '0039xx14': ('UN', '1', 'AcquisitionRate', ''),  # noqa
        '0039xx15': ('UN', '1', 'DepthMinCm', ''),  # noqa
        '0039xx16': ('UN', '1', 'IsLeftRightFlippedEn', ''),  # noqa
        '0039xx17': ('UN', '1', 'IsUpDownFlippedEn', ''),  # noqa
        '0039xx18': ('UN', '1', 'IsVolumeGeomAccurate', ''),  # noqa
        '0039xx19': ('UN', '1', 'BByteMaskOffset', ''),  # noqa
        '0039xx20': ('UN', '1', 'BByteMaskSize', ''),  # noqa
        '0039xx21': ('UN', '1', 'DepthMaxCm', ''),  # noqa
        '0039xx22': ('UN', '1', 'AcqPlaneRotationDeg', ''),  # noqa
        '0039xx23': ('UN', '1', 'BeamAxialSpan', ''),  # noqa
        '0039xx24': ('UN', '1', 'BeamLateralMin', ''),  # noqa
        '0039xx25': ('UN', '1', 'BeamLateralSpan', ''),  # noqa
        '0039xx26': ('UN', '1', 'BeamAxialMin', ''),  # noqa
        '0039xx27': ('UN', '1', 'NumDisplaySamples', ''),  # noqa
        '0039xx28': ('UN', '1', 'DVolumeWidth', ''),  # noqa
        '0039xx29': ('UN', '1', 'DVolumeDepth', ''),  # noqa
        '0039xx30': ('UN', '1', 'DVolumeHeight', ''),  # noqa
        '0039xx31': ('UN', '1', 'DVolumePosX', ''),  # noqa
        '0039xx32': ('UN', '1', 'DVolumePosY', ''),  # noqa
        '0039xx33': ('UN', '1', 'DVolumePosZ', ''),  # noqa
        '0039xx34': ('UN', '1', 'DBeamAxialMin', ''),  # noqa
        '0039xx35': ('UN', '1', 'DBeamAxialSpan', ''),  # noqa
        '0039xx36': ('UN', '1', 'DBeamLateralMin', ''),  # noqa
        '0039xx37': ('UN', '1', 'DBeamLateralSpan', ''),  # noqa
        '0039xx38': ('UN', '1', 'NumOfVolumesInSequence', ''),  # noqa
        '0039xx39': ('UN', '1', 'DByteMaskOffset', ''),  # noqa
        '0039xx40': ('UN', '1', 'DByteMaskSize', ''),  # noqa
        '0039xx50': ('UN', '1', 'PrivateCreatorVersionOfBookmark', ''),  # noqa
        '0039xx51': ('UN', '1', 'BCutPlaneEnable', ''),  # noqa
        '0039xx52': ('UN', '1', 'BMprColorMapIndex', ''),  # noqa
        '0039xx53': ('UN', '1', 'BMprDynamicRangeDb', ''),  # noqa
        '0039xx54': ('UN', '1', 'BMprGrayMapIndex', ''),  # noqa
        '0039xx55': ('UN', '1', 'BVolumeRenderMode', ''),  # noqa
        '0039xx56': ('UN', '1', 'BVrBrightness', ''),  # noqa
        '0039xx57': ('UN', '1', 'BVrContrast', ''),  # noqa
        '0039xx58': ('UN', '1', 'BVrColorMapIndex', ''),  # noqa
        '0039xx59': ('UN', '1', 'BVrDynamicRangeDb', ''),  # noqa
        '0039xx5a': ('UN', '1', 'BVrGrayMapIndex', ''),  # noqa
        '0039xx5b': ('UN', '1', 'BVrOpacity', ''),  # noqa
        '0039xx5c': ('UN', '1', 'BVrThresholdHigh', ''),  # noqa
        '0039xx5d': ('UN', '1', 'BVrThresholdLow', ''),  # noqa
        '0039xx5e': ('UN', '1', 'BPreProcessFilterMix', ''),  # noqa
        '0039xx5f': ('UN', '1', 'CCutPlaneEnable', ''),  # noqa
        '0039xx60': ('UN', '1', 'CFrontClipMode', ''),  # noqa
        '0039xx61': ('UN', '1', 'CMprColorMapIndex', ''),  # noqa
        '0039xx62': ('UN', '1', 'CMprColorFlowPriorityIndex', ''),  # noqa
        '0039xx63': ('UN', '1', 'CVolumeRenderMode', ''),  # noqa
        '0039xx64': ('UN', '1', 'CVrColorMapIndex', ''),  # noqa
        '0039xx65': ('UN', '1', 'CVrColorFlowPriorityIndex', ''),  # noqa
        '0039xx66': ('UN', '1', 'CVrOpacity', ''),  # noqa
        '0039xx67': ('UN', '1', 'CVrThresholdHigh', ''),  # noqa
        '0039xx68': ('UN', '1', 'CVrThresholdLow', ''),  # noqa
        '0039xx69': ('UN', '1', 'VoiMode', ''),  # noqa
        '0039xx6a': ('UN', '1', 'VoiRotationOffsetDeg', ''),  # noqa
        '0039xx6b': ('UN', '1', 'VoiSizeRatioX', ''),  # noqa
        '0039xx6c': ('UN', '1', 'VoiSizeRatioY', ''),  # noqa
        '0039xx6d': ('UN', '1', 'VoiSizeRatioZ', ''),  # noqa
        '0039xx6e': ('UN', '1', 'VoiSyncPlane', ''),  # noqa
        '0039xx6f': ('UN', '1', 'VoiViewMode', ''),  # noqa
        '0039xx70': ('UN', '1', 'VrOrientationA', ''),  # noqa
        '0039xx71': ('UN', '1', 'MprOrientationA', ''),  # noqa
        '0039xx72': ('UN', '1', 'VrOffsetVector', ''),  # noqa
        '0039xx73': ('UN', '1', 'BlendingRatio', ''),  # noqa
        '0039xx74': ('UN', '1', 'FusionBlendMode', ''),  # noqa
        '0039xx75': ('UN', '1', 'QualityFactor', ''),  # noqa
        '0039xx76': ('UN', '1', 'RendererType', ''),  # noqa
        '0039xx77': ('UN', '1', 'SliceMode', ''),  # noqa
        '0039xx78': ('UN', '1', 'ActiveQuad', ''),  # noqa
        '0039xx79': ('UN', '1', 'ScreenMode', ''),  # noqa
        '0039xx7a': ('UN', '1', 'CutPlaneSide', ''),  # noqa
        '0039xx7b': ('UN', '1', 'WireframeMode', ''),  # noqa
        '0039xx7c': ('UN', '1', 'CrossmarkMode', ''),  # noqa
        '0039xx7d': ('UN', '1', 'MprDisplayType', ''),  # noqa
        '0039xx7e': ('UN', '1', 'VolumeDisplayType', ''),  # noqa
        '0039xx7f': ('UN', '1', 'LastReset', ''),  # noqa
        '0039xx80': ('UN', '1', 'LastNonFullScreenMode', ''),  # noqa
        '0039xx81': ('UN', '1', 'MprToolIndex', ''),  # noqa
        '0039xx82': ('UN', '1', 'VoiToolIndex', ''),  # noqa
        '0039xx83': ('UN', '1', 'ToolLoopMode', ''),  # noqa
        '0039xx84': ('UN', '1', 'VolumeArbMode', ''),  # noqa
        '0039xx85': ('UN', '1', 'MprZoomEn', ''),  # noqa
        '0039xx86': ('UN', '1', 'IsVolumeZoomEn', ''),  # noqa
        '0039xx87': ('UN', '1', 'ZoomLevelMpr', ''),  # noqa
        '0039xx88': ('UN', '1', 'ZoomLevelVolume', ''),  # noqa
        '0039xx89': ('UN', '1', 'IsAutoRotateEn', ''),  # noqa
        '0039xx8a': ('UN', '1', 'AutoRotateAxis', ''),  # noqa
        '0039xx8b': ('UN', '1', 'AutoRotateRangeIndex', ''),  # noqa
        '0039xx8c': ('UN', '1', 'AutoRotateSpeedIndex', ''),  # noqa
        '0039xx8d': ('UN', '1', 'CVrBrightness', ''),  # noqa
        '0039xx8e': ('UN', '1', 'CFlowStateIndex', ''),  # noqa
        '0039xx8f': ('UN', '1', 'BSubmodeIndex', ''),  # noqa
        '0039xx90': ('UN', '1', 'CSubmodeIndex', ''),  # noqa
        '0039xx91': ('UN', '1', 'DICOMAttrNameCutPlane', ''),  # noqa
        '0039xx92': ('UN', '1', 'BookmarkChunkId', ''),  # noqa
        '0039xx93': ('UN', '1', 'SequenceMinChunkId', ''),  # noqa
        '0039xx94': ('UN', '1', 'SequenceMaxChunkId', ''),  # noqa
        '0039xx95': ('UN', '1', 'VolumeRateHz', ''),  # noqa
        '0039xx9a': ('UN', '1', 'VoiPositionOffsetX', ''),  # noqa
        '0039xx9b': ('UN', '1', 'VoiPositionOffsetY', ''),  # noqa
        '0039xx9c': ('UN', '1', 'VoiPositionOffsetZ', ''),  # noqa
        '0039xx9d': ('UN', '1', 'VrToolIndex', ''),  # noqa
        '0039xx9e': ('UN', '1', 'ShadingPercent', ''),  # noqa
        '0039xx9f': ('UN', '1', 'VolumeType', ''),  # noqa
        '0039xxa0': ('UN', '1', 'DICOMAttrNameVrQuadDisplayType', ''),  # noqa
        '0039xxa1': ('UN', '1', 'DICOMAttrNameMprCenterLocation', ''),  # noqa
        '0039xxe0': ('UN', '1', 'DICOMAttrNameSliceRangeType', ''),  # noqa
        '0039xxe1': ('UN', '1', 'DICOMAttrNameSliceMPRPlane', ''),  # noqa
        '0039xxe2': ('UN', '1', 'DICOMAttrNameSliceLayout', ''),  # noqa
        '0039xxe3': ('UN', '1', 'DICOMAttrNameSliceSpacing', ''),  # noqa
        '0039xxe4': ('UN', '1', 'DICOMAttrNameThinVrMode', ''),  # noqa
        '0039xxe5': ('UN', '1', 'DICOMAttrNameThinVrThickness', ''),  # noqa
        '0039xxe6': ('UN', '1', 'DICOMAttrNameVoiPivotX', ''),  # noqa
        '0039xxe7': ('UN', '1', 'DICOMAttrNameVoiPivotY', ''),  # noqa
        '0039xxe8': ('UN', '1', 'DICOMAttrNameVoiPivotZ', ''),  # noqa
        '0039xxe9': ('UN', '1', 'DICOMAttrNameCTopVoiQuad', ''),  # noqa
    },
    'SIEMENS MED SMS USG S2000': {
        '0019xx00': ('UN', '1', 'Private Creator Version', ''),  # noqa
        '0019xx03': ('FD', '1', 'Frame Rate', ''),  # noqa
        '0019xx0c': ('US', '1', 'Burned in Graphics', ''),  # noqa
        '0019xx0d': ('SH', '1', 'SieClear Index', ''),  # noqa
        '0019xx20': ('SH', '1', 'B-Mode Submode', ''),  # noqa
        '0019xx21': ('FD', '1', 'B-Mode Dynamic Range', ''),  # noqa
        '0019xx22': ('FD', '1', 'B-Mode Overall Gain', ''),  # noqa
        '0019xx23': ('US', '1', 'B-Mode Res/Speed Index', ''),  # noqa
        '0019xx24': ('US', '1', 'B-Mode Edge Enhance Index', ''),  # noqa
        '0019xx25': ('US', '1', 'B-Mode Persistence Index', ''),  # noqa
        '0019xx26': ('US', '1', 'B-Mode Map Index', ''),  # noqa
        '0019xx27': ('US', '1', '??', ''),  # noqa
        '0019xx28': ('US', '1', '??', ''),  # noqa
        '0019xx29': ('US', '1', '??', ''),  # noqa
        '0019xx2a': ('US', '1', 'B-Mode Tint Type', ''),  # noqa
        '0019xx2d': ('US', '1', 'B-Mode Tint Index', ''),  # noqa
        '0019xx2e': ('SH', '1', 'ClarifyVE Index', ''),  # noqa
        '0019xx3a': ('UN', '1', 'Image Flag', ''),  # noqa
        '0019xx3b': ('LT', '1', 'IPDA/MDA Data', ''),  # noqa
        '0019xx3c': ('UT', '1', 'Thumbnail Data', ''),  # noqa
        '0019xx40': ('UN', '1', 'Color Flow state', ''),  # noqa
        '0019xx41': ('UN', '1', 'Color Flow Wall Filter Index', ''),  # noqa
        '0019xx42': ('UN', '1', 'Color Flow Submode', ''),  # noqa
        '0019xx43': ('UN', '1', 'Color Flow Overall Gain', ''),  # noqa
        '0019xx44': ('UN', '1', 'Color Flow Res/Speed Index', ''),  # noqa
        '0019xx46': ('UN', '1', 'Color Flow Smooth Index', ''),  # noqa
        '0019xx47': ('UN', '1', 'Color Flow Persistence Index', ''),  # noqa
        '0019xx48': ('UN', '1', 'Color Flow Map Index', ''),  # noqa
        '0019xx49': ('UN', '1', 'Color Flow Priority Index', ''),  # noqa
        '0019xx54': ('UN', '1', 'Color Flow Maximum Velocity', ''),  # noqa
        '0019xx60': ('UN', '1', 'Doppler Dynamic Range', ''),  # noqa
        '0019xx61': ('UN', '1', 'Doppler Overall Gain', ''),  # noqa
        '0019xx62': ('UN', '1', 'S2000 Private Doppler Wall Filter', ''),  # noqa
        '0019xx63': ('UN', '1', 'Attributes Doppler Gate Size', ''),  # noqa
        '0019xx65': ('UN', '1', 'Doppler Map Index', ''),  # noqa
        '0019xx66': ('UN', '1', 'Doppler Submode', ''),  # noqa
        '0019xx69': ('UN', '1', 'Doppler Time/Freq Res Index', ''),  # noqa
        '0019xx6a': ('UN', '1', 'Doppler Trace Inverted', ''),  # noqa
        '0019xx6c': ('UN', '1', 'Doppler Tint Type', ''),  # noqa
        '0019xx72': ('UN', '1', 'Doppler Tint Index', ''),  # noqa
        '0019xx80': ('UN', '1', 'M-Mode Dynamic Range', ''),  # noqa
        '0019xx81': ('UN', '1', 'M-Mode Overall Gain', ''),  # noqa
        '0019xx82': ('UN', '1', 'M-Mode Edge Enhance Index', ''),  # noqa
        '0019xx83': ('UN', '1', 'M-Mode Map Index', ''),  # noqa
        '0019xx86': ('UN', '1', 'M-Mode Tint Type', ''),  # noqa
        '0019xx87': ('UN', '1', 'M-Mode Submode', ''),  # noqa
        '0019xx88': ('UN', '1', 'M-Mode Tint Index', ''),  # noqa
    },
    'SIEMENS MED SP DXMG WH AWS 1': {
        '0019xx01': ('UL', '1-n', 'Unknown', ''),  # noqa
        '0019xx02': ('US', '2', 'Unknown', ''),  # noqa
        '0041xx02': ('SH', '1', 'Reason for the Requested Procedure', ''),  # noqa
        '0055xx01': ('LO', '1', 'Projection View Display String', ''),  # noqa
    },
    'SIEMENS MEDCOM HEADER': {
        '0029xx08': ('CS', '1', 'MedCom Header Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'MedCom Header Version', ''),  # noqa
        '0029xx10': ('OB', '1', 'MedCom Header Info', ''),  # noqa
        '0029xx20': ('OB', '1', 'MedCom History Information', ''),  # noqa
        '0029xx31': ('LO', '1', 'PMTF Information 1', ''),  # noqa
        '0029xx32': ('UL', '1', 'PMTF Information 2', ''),  # noqa
        '0029xx33': ('UL', '1', 'PMTF Information 3', ''),  # noqa
        '0029xx34': ('CS', '1', 'PMTF Information 4', ''),  # noqa
        '0029xx35': ('UL', '1', 'PMTF Information 5', ''),  # noqa
        '0029xx40': ('SQ', '1', 'Application Header Sequence', ''),  # noqa
        '0029xx41': ('CS', '1', 'Application Header Type', ''),  # noqa
        '0029xx42': ('LO', '1', 'Application Header ID', ''),  # noqa
        '0029xx43': ('LO', '1', 'Application Header Version', ''),  # noqa
        '0029xx44': ('OB', '1', 'Application Header Info', ''),  # noqa
        '0029xx50': ('LO', '8', 'Workflow Control Flags', ''),  # noqa
        '0029xx51': ('CS', '1', 'Arch. Management Flag Keep Online', ''),  # noqa
        '0029xx52': ('CS', '1', 'Arch. Mgmnt Flag Do Not Archive', ''),  # noqa
        '0029xx53': ('CS', '1', 'Image Location Status', ''),  # noqa
        '0029xx54': ('DS', '1', 'Estimated Retrieve Time', ''),  # noqa
        '0029xx55': ('DS', '1', 'Data Size of Retrieved Images', ''),  # noqa
        '0029xx70': ('SQ', '1', 'Siemens Link Sequence', ''),  # noqa
        '0029xx71': ('AT', '1', 'Referenced Tag', ''),  # noqa
        '0029xx72': ('CS', '1', 'Referenced Tag Type', ''),  # noqa
        '0029xx73': ('UL', '1', 'Referenced Value Length', ''),  # noqa
        '0029xx74': ('CS', '1', 'Referenced Object Device Type', ''),  # noqa
        '0029xx75': ('OB', '1', 'Referenced Object Device Location', ''),  # noqa
        '0029xx76': ('OB', '1', 'Referenced Object ID', ''),  # noqa
    },
    'SIEMENS MEDCOM HEADER2': {
        '0029xx60': ('LO', '1', 'Series Workflow Status', ''),  # noqa
    },
    'SIEMENS MEDCOM OOG': {
        '0029xx08': ('CS', '1', 'MedCom OOG Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'MedCom OOG Version', ''),  # noqa
        '0029xx10': ('OB', '1', 'MedCom OOG Info', ''),  # noqa
    },
    'SIEMENS MR HEADER': {
        '0019xx08': ('CS', '1', 'CSA Image Header Type', ''),  # noqa
        '0019xx09': ('LO', '1', 'CSA Image Header Version ??', ''),  # noqa
        '0019xx0a': ('US', '1', 'NumberOfImagesInMosaic', ''),  # noqa
        '0019xx0b': ('DS', '1', 'SliceMeasurementDuration', ''),  # noqa
        '0019xx0c': ('IS', '1', 'B_value', ''),  # noqa
        '0019xx0d': ('CS', '1', 'DiffusionDirectionality', ''),  # noqa
        '0019xx0e': ('FD', '3', 'DiffusionGradientDirection', ''),  # noqa
        '0019xx0f': ('SH', '1', 'GradientMode', ''),  # noqa
        '0019xx11': ('SH', '1', 'FlowCompensation', ''),  # noqa
        '0019xx12': ('SL', '3', 'TablePositionOrigin', ''),  # noqa
        '0019xx13': ('SL', '3', 'ImaAbsTablePosition', ''),  # noqa
        '0019xx14': ('IS', '3', 'ImaRelTablePosition', ''),  # noqa
        '0019xx15': ('FD', '3', 'SlicePosition_PCS', ''),  # noqa
        '0019xx16': ('DS', '1', 'TimeAfterStart', ''),  # noqa
        '0019xx17': ('DS', '1', 'SliceResolution', ''),  # noqa
        '0019xx18': ('IS', '1', 'RealDwellTime', ''),  # noqa
        '0019xx23': ('IS', '1', 'FMRIStimulInfo', ''),  # noqa
        '0019xx25': ('FD', '3', 'RBMoCoTrans', ''),  # noqa
        '0019xx26': ('FD', '3', 'RBMoCoRot', ''),  # noqa
        '0019xx27': ('FD', '6', 'B_matrix', ''),  # noqa
        '0019xx28': ('FD', '1', 'BandwidthPerPixelPhaseEncode', ''),  # noqa
        '0019xx29': ('FD', '1', 'MosaicRefAcqTimes', ''),  # noqa
        '0051xx08': ('CS', '1', 'CSA Image Header Type', ''),  # noqa
        '0051xx09': ('LO', '1', 'CSA Image Header Version ??', ''),  # noqa
        '0051xx0a': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx0b': ('SH', '1', 'AcquisitionMatrixText', ''),  # noqa
        '0051xx0c': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx0d': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx0e': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx0f': ('LO', '1', 'CoilString', ''),  # noqa
        '0051xx11': ('LO', '1', 'PATModeText', ''),  # noqa
        '0051xx12': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx13': ('SH', '1', 'PositivePCSDirections', ''),  # noqa
        '0051xx15': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx16': ('LO', '1', 'Unknown', ''),  # noqa
        '0051xx17': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx18': ('SH', '1', 'Unknown', ''),  # noqa
        '0051xx19': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS MR VA0  COAD': {
        '0019xx12': ('DS', '1', 'Magnetic Field Strength', ''),  # noqa
        '0019xx14': ('DS', '1', 'ADC Voltage', ''),  # noqa
        '0019xx16': ('DS', '1-n', 'ADC Offset', ''),  # noqa
        '0019xx20': ('DS', '1', 'Transmitter Amplitude', ''),  # noqa
        '0019xx21': ('IS', '1', 'Number of Transmitter Amplitudes', ''),  # noqa
        '0019xx22': ('DS', '1', 'Transmitter Attenuator', ''),  # noqa
        '0019xx24': ('DS', '1', 'Transmitter Calibration', ''),  # noqa
        '0019xx26': ('DS', '1', 'Transmitter Reference', ''),  # noqa
        '0019xx50': ('DS', '1', 'Receiver Total Gain', ''),  # noqa
        '0019xx51': ('DS', '1', 'Receiver Amplifier Gain', ''),  # noqa
        '0019xx52': ('DS', '1', 'Receiver Preamplifier Gain', ''),  # noqa
        '0019xx54': ('DS', '1', 'Receiver Cable Attenuation', ''),  # noqa
        '0019xx55': ('DS', '1', 'Receiver Reference Gain', ''),  # noqa
        '0019xx56': ('IS', '1', 'Receiver Filter Frequency', ''),  # noqa
        '0019xx60': ('DS', '1', 'Reconstruction Scale Factor', ''),  # noqa
        '0019xx62': ('DS', '1', 'Reference Scale Factor', ''),  # noqa
        '0019xx70': ('DS', '1', 'Phase Gradient Amplitude', ''),  # noqa
        '0019xx71': ('DS', '1', 'Readout Gradient Amplitude', ''),  # noqa
        '0019xx72': ('DS', '1', 'Selection Gradient Amplitude', ''),  # noqa
        '0019xx80': ('DS', '1-n', 'Gradient Delay Time', ''),  # noqa
        '0019xx82': ('DS', '1', 'Total Gradient Delay Time', ''),  # noqa
        '0019xx90': ('LO', '1', 'Sensitivity Correction Label', ''),  # noqa
        '0019xx91': ('DS', '1-5', 'Saturation Phase Encoding Vector Coronal Component', ''),  # noqa
        '0019xx92': ('DS', '1-5', 'Saturation Readout Vector Coronal Component', ''),  # noqa
        '0019xxa0': ('IS', '1', 'RF Watchdog Mask', ''),  # noqa
        '0019xxa1': ('DS', '1', 'EPI Reconstruction Slope', ''),  # noqa
        '0019xxa2': ('DS', '1', 'RF Power Error Indicator', ''),  # noqa
        '0019xxa5': ('DS', '1-n', 'Specific Absorption Rate SAR', ''),  # noqa
        '0019xxa6': ('DS', '1-n', 'Specific Energy Dose SED', ''),  # noqa
        '0019xxb0': ('UL', '1', 'Adjustment Status Mask', ''),  # noqa
        '0019xxc1': ('DS', '1-n', 'EPI Capacity', ''),  # noqa
        '0019xxc2': ('DS', '1-n', 'EPI Inductance', ''),  # noqa
        '0019xxc3': ('IS', '1-n', 'EPI Switch Configuration Code', ''),  # noqa
        '0019xxc4': ('IS', '1-n', 'EPI Switch Hardware Code', ''),  # noqa
        '0019xxc5': ('DS', '1-n', 'EPI Switch Delay Time', ''),  # noqa
        '0019xxd1': ('DS', '1', 'Flow Sensitivity', ''),  # noqa
        '0019xxd2': ('CS', '1', 'Calculation Submode', ''),  # noqa
        '0019xxd3': ('DS', '1', 'Field of View Ratio', ''),  # noqa
        '0019xxd4': ('IS', '1', 'Base Raw Matrix Size', ''),  # noqa
        '0019xxd5': ('IS', '1', '2D Phase Oversampling Lines', ''),  # noqa
        '0019xxd6': ('IS', '1', '3D Phase Oversampling Part', ''),  # noqa
        '0019xxd7': ('IS', '1', 'Echo Line Position', ''),  # noqa
        '0019xxd8': ('IS', '1', 'Echo Column Position', ''),  # noqa
        '0019xxd9': ('IS', '1', 'Lines per Segment', ''),  # noqa
        '0019xxda': ('CS', '1', 'Phase Coding Direction', ''),  # noqa
    },
    'SIEMENS MR VA0  GEN': {
        '0019xx10': ('DS', '1', 'Total Measurement Time nominal', ''),  # noqa
        '0019xx11': ('DS', '1', 'Total Measurement Time current', ''),  # noqa
        '0019xx12': ('DS', '1', 'Start Delay Time', ''),  # noqa
        '0019xx13': ('DS', '1', 'Dwell Time', ''),  # noqa
        '0019xx14': ('IS', '1', 'Number of Phases', ''),  # noqa
        '0019xx16': ('UL', '1-n', 'Sequence Control Mask', ''),  # noqa
        '0019xx18': ('UL', '1', 'Measurement Status Mask', ''),  # noqa
        '0019xx20': ('IS', '1', 'Number of Fourier Lines nominal', ''),  # noqa
        '0019xx21': ('IS', '1', 'Number of Fourier Lines current', ''),  # noqa
        '0019xx26': ('IS', '1', 'Number of Fourier Lines after Zero', ''),  # noqa
        '0019xx28': ('IS', '1', 'First Measured Fourier Line', ''),  # noqa
        '0019xx30': ('IS', '1', 'Acquisition Columns', ''),  # noqa
        '0019xx31': ('IS', '1', 'Reconstruction Columns', ''),  # noqa
        '0019xx40': ('IS', '1', 'AC Element Number', ''),  # noqa
        '0019xx41': ('UL', '1', 'AC Element Select Mask', ''),  # noqa
        '0019xx42': ('UL', '1', 'AC Element Data Mask', ''),  # noqa
        '0019xx43': ('IS', '1-n', 'AC Element To ADC Connect', ''),  # noqa
        '0019xx44': ('IS', '1-n', 'AC Element Noise Level', ''),  # noqa
        '0019xx45': ('IS', '1', 'AC ADC Pair Number', ''),  # noqa
        '0019xx46': ('UL', '1', 'AC Combination Mask', ''),  # noqa
        '0019xx50': ('IS', '1', 'Number of Averages current', ''),  # noqa
        '0019xx60': ('DS', '1', 'Flip Angle', ''),  # noqa
        '0019xx70': ('IS', '1', 'Number of Prescans', ''),  # noqa
        '0019xx81': ('CS', '1', 'Filter Type for Raw Data', ''),  # noqa
        '0019xx82': ('DS', '1-4', 'Filter Parameter for Raw Data', ''),  # noqa
        '0019xx83': ('CS', '1', 'Filter Type for Image Data', ''),  # noqa
        '0019xx84': ('DS', '1-4', 'Filter Parameter for Image Data', ''),  # noqa
        '0019xx85': ('CS', '1', 'Filter Type for Phase Correction', ''),  # noqa
        '0019xx86': ('DS', '1-4', 'Filter Parameter for Phase Correction', ''),  # noqa
        '0019xx87': ('CS', '1', 'Normalization Filter Type for Image Data', ''),  # noqa
        '0019xx88': ('DS', '1-4', 'Normalization Filter Parameter for Image Data', ''),  # noqa
        '0019xx90': ('IS', '1', 'Number of Saturation Regions', ''),  # noqa
        '0019xx91': ('DS', '1-5', 'Saturation Phase Encoding Vector Sagittal Compo...', ''),  # noqa
        '0019xx92': ('DS', '1-5', 'Saturation Readout Vector Sagittal Component', ''),  # noqa
        '0019xx93': ('IS', '1', 'EPI Stimulation Monitor Mode', ''),  # noqa
        '0019xx94': ('DS', '1', 'Image Rotation Angle', ''),  # noqa
        '0019xx96': ('UL', '1-n', 'Coil ID Mask', ''),  # noqa
        '0019xx97': ('UL', '1-n', 'Coil Class Mask', ''),  # noqa
        '0019xx98': ('DS', '1-n', 'Coil Position', ''),  # noqa
        '0019xxa0': ('DS', '1', 'EPI Reconstruction Phase', ''),  # noqa
        '0019xxa1': ('DS', '1', 'EPI Reconstruction Slope', ''),  # noqa
        '0021xx20': ('IS', '1', 'Phase Corrections Rows sequence', ''),  # noqa
        '0021xx21': ('IS', '1', 'Phase Corrections Columns sequence', ''),  # noqa
        '0021xx22': ('IS', '1', 'Phase Corrections Rows reconstruction', ''),  # noqa
        '0021xx24': ('IS', '1', 'Phase Corrections Columns reconstruction', ''),  # noqa
        '0021xx30': ('IS', '1', 'Number of 3D Raw Partitions nominal', ''),  # noqa
        '0021xx31': ('IS', '1', 'Number of 3D Raw Partitions current', ''),  # noqa
        '0021xx34': ('IS', '1', 'Number of 3D Image Partitions', ''),  # noqa
        '0021xx36': ('IS', '1', 'Actual 3D Image Partition Number', ''),  # noqa
        '0021xx39': ('DS', '1', 'Slab Thickness', ''),  # noqa
        '0021xx40': ('IS', '1', 'Number of Slices nominal', ''),  # noqa
        '0021xx41': ('IS', '1', 'Number of Slices current', ''),  # noqa
        '0021xx42': ('IS', '1', 'Current Slice Number', ''),  # noqa
        '0021xx43': ('IS', '1', 'Current Group Number', ''),  # noqa
        '0021xx44': ('DS', '1', 'Current Slice Distance Factor', ''),  # noqa
        '0021xx45': ('IS', '1', 'MIP Start Row', ''),  # noqa
        '0021xx46': ('IS', '1', 'MIP Stop Row', ''),  # noqa
        '0021xx47': ('IS', '1', 'MIP Start Column', ''),  # noqa
        '0021xx48': ('IS', '1', 'MIP Stop Column', ''),  # noqa
        '0021xx49': ('IS', '1', 'MIP Start Slice', ''),  # noqa
        '0021xx4a': ('IS', '1', 'MIP Stop Slice', ''),  # noqa
        '0021xx4f': ('CS', '1', 'Order of Slices', ''),  # noqa
        '0021xx50': ('UL', '1', 'Signal Mask', ''),  # noqa
        '0021xx52': ('IS', '1', 'Delay after Trigger', ''),  # noqa
        '0021xx53': ('IS', '1', 'RRInterval', ''),  # noqa
        '0021xx54': ('DS', '1', 'Number of Trigger Pulses', ''),  # noqa
        '0021xx56': ('DS', '1', 'Repetition Time effective', ''),  # noqa
        '0021xx57': ('CS', '1', 'Gate Phase', ''),  # noqa
        '0021xx58': ('DS', '1', 'Gate Threshold', ''),  # noqa
        '0021xx59': ('DS', '1', 'Gated Ratio', ''),  # noqa
        '0021xx60': ('IS', '1', 'Number of Interpolated Images', ''),  # noqa
        '0021xx70': ('IS', '1', 'Number of Echoes', ''),  # noqa
        '0021xx72': ('DS', '1', 'Second Echo Time', ''),  # noqa
        '0021xx73': ('DS', '1', 'Second Repetition Time', ''),  # noqa
        '0021xx80': ('IS', '1', 'Cardiac Code', ''),  # noqa
        '0021xx91': ('DS', '1-n', 'Saturation Phase Encoding Vector Transversal Co...', ''),  # noqa
        '0021xx92': ('DS', '1-n', 'Saturation Readout Vector Transversal Component', ''),  # noqa
        '0021xx93': ('DS', '1', 'EPI Change Value of Magnitude', ''),  # noqa
        '0021xx94': ('DS', '1', 'EPI Change Value of X Component', ''),  # noqa
        '0021xx95': ('DS', '1', 'EPI Change Value of Y Component', ''),  # noqa
        '0021xx96': ('DS', '1', 'EPI Change Value of Z Component', ''),  # noqa
    },
    'SIEMENS MR VA0  RAW': {
        '0021xx00': ('CS', '1', 'Sequence Type', ''),  # noqa
        '0021xx01': ('IS', '1', 'Vector Size original', ''),  # noqa
        '0021xx02': ('IS', '1', 'Vector Size extended', ''),  # noqa
        '0021xx03': ('DS', '1', 'Acquired Spectral Range', ''),  # noqa
        '0021xx04': ('DS', '1-n', 'VOI Position', ''),  # noqa
        '0021xx05': ('DS', '1-n', 'VOI Size', ''),  # noqa
        '0021xx06': ('IS', '1-n', 'CSI Matrix Size original', ''),  # noqa
        '0021xx07': ('IS', '1-n', 'CSI Matrix Size extended', ''),  # noqa
        '0021xx08': ('DS', '1-n', 'Spatial Grid Shift', ''),  # noqa
        '0021xx09': ('DS', '1', 'Signal Limits Minimum', ''),  # noqa
        '0021xx10': ('DS', '1', 'Signal Limits Maximum', ''),  # noqa
        '0021xx11': ('DS', '1', 'Spec Info Mask', ''),  # noqa
        '0021xx12': ('DS', '1', 'EPI Time Rate of Change of Magnitude', ''),  # noqa
        '0021xx13': ('DS', '1', 'EPI Time Rate of Change of X Component', ''),  # noqa
        '0021xx14': ('DS', '1', 'EPI Time Rate of Change of Y Component', ''),  # noqa
        '0021xx15': ('DS', '1', 'EPI Time Rate of Change of Z Component', ''),  # noqa
        '0021xx16': ('DS', '1', 'EPI Time Rate of Change Legal Limit 1', ''),  # noqa
        '0021xx17': ('IS', '1', 'EPI Operation Mode Flag', ''),  # noqa
        '0021xx18': ('DS', '1', 'EPI Field Calculation Safety Factor', ''),  # noqa
        '0021xx19': ('DS', '1', 'EPI Legal Limit 1 of Change Value', ''),  # noqa
        '0021xx20': ('DS', '1', 'EPI Legal Limit 2 of Change Value', ''),  # noqa
        '0021xx21': ('DS', '1', 'EPI Rise Time', ''),  # noqa
        '0021xx30': ('DS', '1-n', 'AC ADC Offset', ''),  # noqa
        '0021xx31': ('DS', '1-n', 'AC Preamplifier Gain', ''),  # noqa
        '0021xx50': ('CS', '1', 'Saturation Type', ''),  # noqa
        '0021xx51': ('DS', '1-n', 'Saturation Normal Vector', ''),  # noqa
        '0021xx52': ('DS', '1-n', 'Saturation Position Vector', ''),  # noqa
        '0021xx53': ('DS', '1-n', 'Saturation Thickness', ''),  # noqa
        '0021xx54': ('DS', '1-n', 'Saturation Width', ''),  # noqa
        '0021xx55': ('DS', '1-n', 'Saturation Distance', ''),  # noqa
    },
    'SIEMENS NUMARIS II': {
        '7fe3xx00': ('LO', '1', 'Image Graphics Format Code', ''),  # noqa
        '7fe3xx10': ('OB', '1', 'Image Graphics', ''),  # noqa
        '7fe3xx20': ('OB', '1', 'Image Graphics Dummy', ''),  # noqa
    },
    'SIEMENS RA GEN': {
        '0011xx20': ('UL', '1', 'Total Fluoro TimePatient', ''),  # noqa
        '0011xx25': ('UL', '1', 'Dose Area ProductPatient', ''),  # noqa
        '0011xx30': ('LO', '1', 'Patient DOB', ''),  # noqa
        '0011xx35': ('LO', '1', 'Patient Initial Puck Counter', ''),  # noqa
        '0011xx40': ('CS', '1', 'Patient Initial Position', ''),  # noqa
        '0019xx15': ('CS', '1', 'Acquired Plane', ''),  # noqa
        '0019xx20': ('UL', '1', 'Scene Flag', ''),  # noqa
        '0019xx22': ('UL', '1', 'ReferencePhotofile Flag', ''),  # noqa
        '0019xx24': ('LO', '1', 'Scene Name', ''),  # noqa
        '0019xx26': ('US', '1', 'Acquisition Index', ''),  # noqa
        '0019xx28': ('US', '1', 'Mixed Pulse Mode', ''),  # noqa
        '0019xx2a': ('US', '1', 'Number of Positions', ''),  # noqa
        '0019xx2c': ('US', '1', 'Number of Phases', ''),  # noqa
        '0019xx2e': ('US', '1-n', 'Framerate for 8 Positions', ''),  # noqa
        '0019xx30': ('US', '1-n', 'FramesPhase', ''),  # noqa
        '0019xx32': ('US', '1', 'Stepping Direction', ''),  # noqa
        '0019xx34': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx36': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx38': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx3a': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx3c': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx3e': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx42': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx44': ('US', '1', 'Image Transfer Delay', ''),  # noqa
        '0019xx46': ('UL', '1', 'InversNot Invers', ''),  # noqa
        '0019xx48': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx4a': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx4c': ('US', '1', 'Blanking Circle Diameter', ''),  # noqa
        '0019xx50': ('US', '1', 'Stand Data Valid', ''),  # noqa
        '0019xx52': ('US', '1', 'Table Tilt', ''),  # noqa
        '0019xx54': ('US', '1', 'Table Axis Rotation', ''),  # noqa
        '0019xx56': ('US', '1', 'Table Longitudinal Position', ''),  # noqa
        '0019xx58': ('US', '1', 'Table Side Offset', ''),  # noqa
        '0019xx5a': ('US', '1', 'Table Isocenter Height', ''),  # noqa
        '0019xx5c': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx5e': ('UL', '1', 'Collimation Data Valid', ''),  # noqa
        '0019xx60': ('UL', '1', 'PERI Sequence Number', ''),  # noqa
        '0019xx62': ('UL', '1', 'PERI Total Scenes', ''),  # noqa
        '0019xx64': ('US', '1', 'PERI Overlap Top', ''),  # noqa
        '0019xx66': ('UL', '1', 'PERI Overlap Bottom', ''),  # noqa
        '0019xx68': ('UL', '1', 'Raw Image Number', ''),  # noqa
        '0019xx6a': ('UL', '1', 'XRay Data Valid', ''),  # noqa
        '0019xx70': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx72': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx74': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx76': ('UL', '1', 'Filling Average Factor', ''),  # noqa
        '0019xx78': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx7a': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx7c': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx7e': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx80': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx82': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx84': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx86': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx88': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx8a': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx8c': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx8e': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx92': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx94': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx96': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx98': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx9a': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx9c': ('UL', '1', 'II Level CalibrationFactor', ''),  # noqa
        '0019xx9e': ('UL', '1', 'Nativ Review Flag', ''),  # noqa
        '0021xx15': ('US', '1', 'Images in Study', ''),  # noqa
        '0021xx20': ('US', '1', 'Scenes in Study', ''),  # noqa
        '0021xx25': ('US', '1', 'Images in Photofile', ''),  # noqa
        '0021xx30': ('US', '1', 'Images in All Scenes', ''),  # noqa
        '0021xx40': ('US', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS RA PLANE A': {
        '0019xx20': ('UL', '1', 'System Calibration Factor Plane A', ''),  # noqa
        '0019xx22': ('US', '1', 'XRay Parameter Set Number', ''),  # noqa
        '0019xx24': ('US', '1', 'XRay System', ''),  # noqa
        '0019xx26': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx28': ('US', '1', 'Acquired Display Mode', ''),  # noqa
        '0019xx2a': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx2c': ('US', '1', 'Acquisition Framerate', ''),  # noqa
        '0019xx2e': ('US', '1', 'Maximum Frame Limit', ''),  # noqa
        '0019xx30': ('US', '1', 'Native Filter Type', ''),  # noqa
        '0019xx32': ('US', '1', 'Subtracted Filter Type', ''),  # noqa
        '0019xx34': ('US', '1', 'Filter Factor Native', ''),  # noqa
        '0019xx36': ('US', '1', 'Anatomic Blackground Factor', ''),  # noqa
        '0019xx38': ('US', '1', 'Window Upper Limit Native', ''),  # noqa
        '0019xx3a': ('US', '1', 'Window Lower Limit Native', ''),  # noqa
        '0019xx3c': ('US', '1', 'Window Brightness Phase 1 Sub', ''),  # noqa
        '0019xx3e': ('US', '1', 'Window Brightness Phase 2 Sub', ''),  # noqa
        '0019xx40': ('US', '1', 'Window Contrast Phase 1 Sub', ''),  # noqa
        '0019xx42': ('US', '1', 'Window Contrast Phase 2 Sub', ''),  # noqa
        '0019xx44': ('US', '1', 'Filter Factor Subtraction', ''),  # noqa
        '0019xx46': ('US', '1', 'Peak Opacified', ''),  # noqa
        '0019xx48': ('UL', '1', 'Mask Frame', ''),  # noqa
        '0019xx4a': ('UL', '1', 'BIH Frame', ''),  # noqa
        '0019xx4c': ('US', '1', 'Center Beam Angulation CaudCran', ''),  # noqa
        '0019xx4e': ('US', '1', 'Center Beam Angulation LR Anterior', ''),  # noqa
        '0019xx50': ('US', '1', 'Longitudinal Position', ''),  # noqa
        '0019xx52': ('US', '1', 'Side Offset', ''),  # noqa
        '0019xx54': ('US', '1', 'Isocenter Height', ''),  # noqa
        '0019xx56': ('US', '1', 'Image Twist', ''),  # noqa
        '0019xx58': ('US', '1', 'SourceImage Distance', ''),  # noqa
        '0019xx5a': ('US', '1', 'Mechanical Magnet Factor', ''),  # noqa
        '0019xx5c': ('UL', '1', 'Calibration Flag', ''),  # noqa
        '0019xx5e': ('UL', '1', 'Calibration Angle CranCaud', ''),  # noqa
        '0019xx60': ('UL', '1', 'Calibration Angle RAOLAO', ''),  # noqa
        '0019xx62': ('UL', '1', 'Calibration Table to Floor Distance', ''),  # noqa
        '0019xx64': ('UL', '1', 'Calibration Isocenter to Floor Distance', ''),  # noqa
        '0019xx66': ('UL', '1', 'Calibration Isocenter to Source Distance', ''),  # noqa
        '0019xx68': ('UL', '1', 'Calibration Source to II Distance', ''),  # noqa
        '0019xx6a': ('UL', '1', 'Calibration II Zoom', ''),  # noqa
        '0019xx6c': ('UL', '1', 'Calibration II Field', ''),  # noqa
        '0019xx6e': ('UL', '1', 'Calibration Factor', ''),  # noqa
        '0019xx70': ('UL', '1', 'Calibration Object to Image Distance', ''),  # noqa
        '0019xx72': ('UL', '1-n', 'Calibration System Factor', ''),  # noqa
        '0019xx74': ('UL', '1-n', 'Calibration System Correction', ''),  # noqa
        '0019xx76': ('UL', '1-n', 'Calibration System II Formats', ''),  # noqa
        '0019xx78': ('UL', '1', 'Calibration Gantry Data Valid', ''),  # noqa
        '0019xx7a': ('US', '1', 'Collimator Square Breadth', ''),  # noqa
        '0019xx7c': ('US', '1', 'Collimator Square Height', ''),  # noqa
        '0019xx7e': ('US', '1', 'Collimator Square Diameter', ''),  # noqa
        '0019xx80': ('US', '1', 'Collimator Finger Turn Angle', ''),  # noqa
        '0019xx82': ('US', '1', 'Collimator Finger Position', ''),  # noqa
        '0019xx84': ('US', '1', 'Collimator Diaphragm Turn Angle', ''),  # noqa
        '0019xx86': ('US', '1', 'Collimator Diagphragm Position 1', ''),  # noqa
        '0019xx88': ('US', '1', 'Collimator Diaphragm Position 2', ''),  # noqa
        '0019xx8a': ('US', '1', 'Collimator Diaphragm Mode', ''),  # noqa
        '0019xx8c': ('US', '1', 'Collimator Beam Limit Breadth', ''),  # noqa
        '0019xx8e': ('US', '1', 'Collimator Beam Limit Height', ''),  # noqa
        '0019xx90': ('US', '1', 'Collimator Beam Limit Diameter', ''),  # noqa
        '0019xx92': ('US', '1', 'XRay Control Mode', ''),  # noqa
        '0019xx94': ('US', '1', 'XRay System', ''),  # noqa
        '0019xx96': ('US', '1', 'Focal Spot', ''),  # noqa
        '0019xx98': ('US', '1', 'Exposure Control', ''),  # noqa
        '0019xx9a': ('US', '1', 'XRay Voltage', ''),  # noqa
        '0019xx9c': ('US', '1', 'XRay Current', ''),  # noqa
        '0019xx9e': ('UL', '1', 'XRay Current Time Product', ''),  # noqa
        '0019xxa0': ('US', '1', 'Pulse Time', ''),  # noqa
        '0019xxa2': ('US', '1', 'Scene Time Fluoro Clock', ''),  # noqa
        '0019xxa4': ('US', '1', 'Maximum PulseRate', ''),  # noqa
        '0019xxa6': ('US', '1', 'Pulses per Scene', ''),  # noqa
        '0019xxa8': ('UL', '1', 'Dose Area Product of Scene', ''),  # noqa
        '0019xxaa': ('US', '1', 'Dose', ''),  # noqa
        '0019xxac': ('US', '1', 'Dose Rate', ''),  # noqa
    },
    'SIEMENS RA PLANE B': {
        '0019xx20': ('UL', '1', 'System Calibration Factor Plane B', ''),  # noqa
        '0019xx22': ('US', '1', 'XRay Parameter Set Number', ''),  # noqa
        '0019xx24': ('US', '1', 'XRay System', ''),  # noqa
        '0019xx26': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx28': ('US', '1', 'Acquired Display Mode', ''),  # noqa
        '0019xx2a': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx2c': ('US', '1', 'Acquisition Framerate', ''),  # noqa
        '0019xx2e': ('US', '1', 'Maximum Frame Limit', ''),  # noqa
        '0019xx30': ('US', '1', 'Native Filter Type', ''),  # noqa
        '0019xx32': ('US', '1', 'Subtracted Filter Type', ''),  # noqa
        '0019xx34': ('US', '1', 'Filter Factor Native', ''),  # noqa
        '0019xx36': ('US', '1', 'Anatomic Blackground Factor', ''),  # noqa
        '0019xx38': ('US', '1', 'Window Upper Limit Native', ''),  # noqa
        '0019xx3a': ('US', '1', 'Window Lower Limit Native', ''),  # noqa
        '0019xx3c': ('US', '1', 'Window Brightness Phase 1 Sub', ''),  # noqa
        '0019xx3e': ('US', '1', 'Window Brightness Phase 2 Sub', ''),  # noqa
        '0019xx40': ('US', '1', 'Window Contrast Phase 1 Sub', ''),  # noqa
        '0019xx42': ('US', '1', 'Window Contrast Phase 2 Sub', ''),  # noqa
        '0019xx44': ('US', '1', 'Filter Factor Subtraction', ''),  # noqa
        '0019xx46': ('US', '1', 'Peak Opacified', ''),  # noqa
        '0019xx48': ('UL', '1', 'Mask Frame', ''),  # noqa
        '0019xx4a': ('UL', '1', 'BIH Frame', ''),  # noqa
        '0019xx4c': ('US', '1', 'Center Beam Angulation CaudCran', ''),  # noqa
        '0019xx4e': ('US', '1', 'Center Beam Angulation LR Anterior', ''),  # noqa
        '0019xx50': ('US', '1', 'Longitudinal Position', ''),  # noqa
        '0019xx52': ('US', '1', 'Side Offset', ''),  # noqa
        '0019xx54': ('US', '1', 'Isocenter Height', ''),  # noqa
        '0019xx56': ('US', '1', 'Image Twist', ''),  # noqa
        '0019xx58': ('US', '1', 'SourceImage Distance', ''),  # noqa
        '0019xx5a': ('US', '1', 'Mechanical Magnet Factor', ''),  # noqa
        '0019xx5c': ('UL', '1', 'Calibration Flag', ''),  # noqa
        '0019xx5e': ('UL', '1', 'Calibration Angle CranCaud', ''),  # noqa
        '0019xx60': ('UL', '1', 'Calibration Angle RAOLAO', ''),  # noqa
        '0019xx62': ('UL', '1', 'Calibration Table to Floor Distance', ''),  # noqa
        '0019xx64': ('UL', '1', 'Calibration Isocenter to Floor Distance', ''),  # noqa
        '0019xx66': ('UL', '1', 'Calibration Isocenter to Source Distance', ''),  # noqa
        '0019xx68': ('UL', '1', 'Calibration Source to II Distance', ''),  # noqa
        '0019xx6a': ('UL', '1', 'Calibration II Zoom', ''),  # noqa
        '0019xx6c': ('UL', '1', 'Calibration II Field', ''),  # noqa
        '0019xx6e': ('UL', '1', 'Calibration Factor', ''),  # noqa
        '0019xx70': ('UL', '1', 'Calibration Object to Image Distance', ''),  # noqa
        '0019xx72': ('UL', '1-n', 'Calibration System Factor', ''),  # noqa
        '0019xx74': ('UL', '1-n', 'Calibration System Correction', ''),  # noqa
        '0019xx76': ('UL', '1-n', 'Calibration System II Formats', ''),  # noqa
        '0019xx78': ('UL', '1', 'Calibration Gantry Data Valid', ''),  # noqa
        '0019xx7a': ('US', '1', 'Collimator Square Breadth', ''),  # noqa
        '0019xx7c': ('US', '1', 'Collimator Square Height', ''),  # noqa
        '0019xx7e': ('US', '1', 'Collimator Square Diameter', ''),  # noqa
        '0019xx80': ('US', '1', 'Collimator Finger Turn Angle', ''),  # noqa
        '0019xx82': ('US', '1', 'Collimator Finger Position', ''),  # noqa
        '0019xx84': ('US', '1', 'Collimator Diaphragm Turn Angle', ''),  # noqa
        '0019xx86': ('US', '1', 'Collimator Diagphragm Position 1', ''),  # noqa
        '0019xx88': ('US', '1', 'Collimator Diaphragm Position 2', ''),  # noqa
        '0019xx8a': ('US', '1', 'Collimator Diaphragm Mode', ''),  # noqa
        '0019xx8c': ('US', '1', 'Collimator Beam Limit Breadth', ''),  # noqa
        '0019xx8e': ('US', '1', 'Collimator Beam Limit Height', ''),  # noqa
        '0019xx90': ('US', '1', 'Collimator Beam Limit Diameter', ''),  # noqa
        '0019xx92': ('US', '1', 'XRay Control Mode', ''),  # noqa
        '0019xx94': ('US', '1', 'XRay System', ''),  # noqa
        '0019xx96': ('US', '1', 'Focal Spot', ''),  # noqa
        '0019xx98': ('US', '1', 'Exposure Control', ''),  # noqa
        '0019xx9a': ('US', '1', 'XRay Voltage', ''),  # noqa
        '0019xx9c': ('US', '1', 'XRay Current', ''),  # noqa
        '0019xx9e': ('UL', '1', 'XRay Current Time Product', ''),  # noqa
        '0019xxa0': ('US', '1', 'Pulse Time', ''),  # noqa
        '0019xxa2': ('US', '1', 'Scene Time Fluoro Clock', ''),  # noqa
        '0019xxa4': ('US', '1', 'Maximum PulseRate', ''),  # noqa
        '0019xxa6': ('US', '1', 'Pulses per Scene', ''),  # noqa
        '0019xxa8': ('UL', '1', 'Dose Area Product of Scene', ''),  # noqa
        '0019xxaa': ('US', '1', 'Dose', ''),  # noqa
        '0019xxac': ('US', '1', 'Dose Rate', ''),  # noqa
    },
    'SIEMENS RIS': {
        '0011xx10': ('LO', '1', 'Patient UID', ''),  # noqa
        '0011xx11': ('LO', '1', 'Patient ID', ''),  # noqa
        '0011xx20': ('DA', '1', 'Patient Registration Date', ''),  # noqa
        '0011xx21': ('TM', '1', 'Patient Registration Time', ''),  # noqa
        '0011xx30': ('PN', '1', 'Patient NameRIS', ''),  # noqa
        '0011xx31': ('PN', '1', 'Patient Prename', ''),  # noqa
        '0011xx40': ('LO', '1', 'Patient Hospital Status', ''),  # noqa
        '0011xx41': ('LO', '1', 'Medical Alerts', ''),  # noqa
        '0011xx42': ('LO', '1', 'Contrast Allergy', ''),  # noqa
        '0031xx10': ('LO', '1', 'Request UID', ''),  # noqa
        '0031xx45': ('LO', '1', 'Requesting Physician', ''),  # noqa
        '0031xx50': ('LO', '1', 'Requested Physician', ''),  # noqa
        '0033xx10': ('LO', '1', 'Patient Study UID', ''),  # noqa
    },
    'SIEMENS SIENET': {
        '0019xx01': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS SMS-AX  ACQ 1.0': {
        '0021xx00': ('US', '1', 'Acquisition Type', ''),  # noqa
        '0021xx01': ('US', '1', 'Acquisition Mode', ''),  # noqa
        '0021xx02': ('US', '1', 'Footswitch Index', ''),  # noqa
        '0021xx03': ('US', '1', 'Acquisition Room', ''),  # noqa
        '0021xx04': ('SL', '1', 'Current Time Product', ''),  # noqa
        '0021xx05': ('SL', '1', 'Dose', ''),  # noqa
        '0021xx06': ('SL', '1', 'Skin Dose Percent', ''),  # noqa
        '0021xx07': ('SL', '1', 'Skin Dose Accumulation', ''),  # noqa
        '0021xx08': ('SL', '1', 'Skin Dose Rate', ''),  # noqa
        '0021xx09': ('UL', '1', 'Impac Filename', ''),  # noqa
        '0021xx0a': ('UL', '1', 'Copper Filter', ''),  # noqa
        '0021xx0b': ('US', '1', 'Measuring Field', ''),  # noqa
        '0021xx0c': ('SS', '3', 'Post Blanking Circle', ''),  # noqa
        '0021xx0d': ('SS', '2-2n', 'Dyna Angles', ''),  # noqa
        '0021xx0e': ('SS', '1', 'Total Steps', ''),  # noqa
        '0021xx0f': ('SL', '3-3n', 'Dyna X-Ray Info', ''),  # noqa
        '0021xx10': ('US', '1', 'Modality LUT Input Gamma', ''),  # noqa
        '0021xx11': ('US', '1', 'Modality LUT Output Gamma', ''),  # noqa
        '0021xx12': ('OB', '1-n', 'SH_STPAR', ''),  # noqa
        '0021xx13': ('US', '1', 'Acquisition Zoom', ''),  # noqa
        '0021xx14': ('SS', '1', 'Dyna Angulation Step Width', ''),  # noqa
        '0021xx15': ('US', '1', 'Harmonization', ''),  # noqa
        '0021xx16': ('US', '1', 'DR Single Flag', ''),  # noqa
        '0021xx17': ('SL', '1', 'Source to Isocenter', ''),  # noqa
        '0021xx18': ('US', '1', 'Pressure Data', ''),  # noqa
        '0021xx19': ('SL', '1', 'ECG Index Array', ''),  # noqa
        '0021xx1a': ('US', '1', 'FD Flag', ''),  # noqa
        '0021xx1b': ('OB', '1', 'SH_ZOOM', ''),  # noqa
        '0021xx1c': ('OB', '1', 'SH_COLPAR', ''),  # noqa
        '0021xx1d': ('US', '1', 'K-Factor', ''),  # noqa
        '0021xx1e': ('US', '8', 'EVE', ''),  # noqa
        '0021xx1f': ('SL', '1', 'Total Scene Time', ''),  # noqa
        '0021xx20': ('US', '1', 'Restore Flag', ''),  # noqa
        '0021xx21': ('US', '1', 'Stand Movement Flag', ''),  # noqa
        '0021xx22': ('US', '1', 'FD Rows', ''),  # noqa
        '0021xx23': ('US', '1', 'FD Columns', ''),  # noqa
        '0021xx24': ('US', '1', 'Table Movement Flag', ''),  # noqa
        '0021xx25': ('LO', '1', 'Original Organ Program Name', ''),  # noqa
        '0021xx26': ('DS', '1', 'Crispy XPI Filter', ''),  # noqa
        '0021xx28': ('SQ', '1', 'Unknown', ''),  # noqa
        '0021xx30': ('OB', '1', 'Unknown', ''),  # noqa
        '0021xx40': ('US', '3', 'Unknown', ''),  # noqa
        '0021xx41': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx42': ('US', '1-n', 'Unknown', ''),  # noqa
        '0021xx57': ('SS', '1-3', 'Unknown', ''),  # noqa
        '0021xx58': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xx71': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS SMS-AX  ORIGINAL IMAGE INFO 1.0': {
        '0025xx00': ('US', '1', 'View Native', ''),  # noqa
        '0025xx01': ('US', '1', 'Original Series Number', ''),  # noqa
        '0025xx02': ('US', '1', 'Original Image Number', ''),  # noqa
        '0025xx03': ('US', '1', 'Win Center', ''),  # noqa
        '0025xx04': ('US', '1', 'Win Width', ''),  # noqa
        '0025xx05': ('US', '1', 'Win Brightness', ''),  # noqa
        '0025xx06': ('US', '1', 'Win Contrast', ''),  # noqa
        '0025xx07': ('US', '1', 'Original Frame Number', ''),  # noqa
        '0025xx08': ('US', '1', 'Original Mask Frame Number', ''),  # noqa
        '0025xx09': ('US', '1', 'Opac', ''),  # noqa
        '0025xx0a': ('US', '1', 'Original Number of Frames', ''),  # noqa
        '0025xx0b': ('DS', '1', 'Original Scene Duration', ''),  # noqa
        '0025xx0c': ('LO', '1', 'Identifier LOID', ''),  # noqa
        '0025xx0d': ('SS', '1-n', 'Original Scene VFR Info', ''),  # noqa
        '0025xx0e': ('SS', '1', 'Original Frame ECG Position', ''),  # noqa
        '0025xx0f': ('SS', '1', 'Original ECG 1st Frame Offset (retired)', ''),  # noqa
        '0025xx10': ('SS', '1', 'Zoom Flag', ''),  # noqa
        '0025xx11': ('US', '1', 'Flex', ''),  # noqa
        '0025xx12': ('US', '1', 'Number of Mask Frames', ''),  # noqa
        '0025xx13': ('US', '1', 'Number of Fill Frames', ''),  # noqa
        '0025xx14': ('IS', '1', 'Series Number', ''),  # noqa
        '0025xx15': ('IS', '1', 'Image Number', ''),  # noqa
        '0025xx16': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS SMS-AX  QUANT 1.0': {
        '0023xx00': ('DS', '2', 'Horizontal Calibration Pixel Size', ''),  # noqa
        '0023xx01': ('DS', '2', 'Vertical Calibration Pixel Size', ''),  # noqa
        '0023xx02': ('LO', '1', 'Calibration Object', ''),  # noqa
        '0023xx03': ('DS', '1', 'Calibration Object Size', ''),  # noqa
        '0023xx04': ('LO', '1', 'Calibration Method', ''),  # noqa
        '0023xx05': ('ST', '1', 'Filename', ''),  # noqa
        '0023xx06': ('IS', '1', 'Frame Number', ''),  # noqa
        '0023xx07': ('IS', '2', 'Calibration Factor Multiplicity', ''),  # noqa
        '0023xx08': ('IS', '1', 'Calibration TOD Value', ''),  # noqa
    },
    'SIEMENS SMS-AX  VIEW 1.0': {
        '0019xx00': ('US', '1', 'Review Mode', ''),  # noqa
        '0019xx01': ('US', '1', 'Anatomical Background Percent', ''),  # noqa
        '0019xx02': ('US', '1', 'Number of Phases', ''),  # noqa
        '0019xx03': ('US', '1', 'Apply Anatomical Background', ''),  # noqa
        '0019xx04': ('SS', '4-4n', 'Pixel Shift Array', ''),  # noqa
        '0019xx05': ('US', '1', 'Brightness', ''),  # noqa
        '0019xx06': ('US', '1', 'Contrast', ''),  # noqa
        '0019xx07': ('US', '1', 'Enabled', ''),  # noqa
        '0019xx08': ('US', '1', 'Native Edge Enh. Percent Gain', ''),  # noqa
        '0019xx09': ('SS', '1', 'Native Edge Enh. LUT Index', ''),  # noqa
        '0019xx0a': ('SS', '1', 'Native Edge Enh. Kernel Size', ''),  # noqa
        '0019xx0b': ('US', '1', 'Subtr. Edge Enh. Percent Gain', ''),  # noqa
        '0019xx0c': ('SS', '1', 'Subtr. Edge Enh. LUT Index', ''),  # noqa
        '0019xx0d': ('SS', '1', 'Subtr. Edge Enh. Kernel Size', ''),  # noqa
        '0019xx0e': ('US', '1', 'Fade Percent', ''),  # noqa
        '0019xx0f': ('US', '1', 'Flipped Before Laterality Applied', ''),  # noqa
        '0019xx10': ('US', '1', 'Apply Fade', ''),  # noqa
        '0019xx11': ('US', '1', 'RefImages Taken', ''),  # noqa
        '0019xx12': ('US', '1', 'Zoom', ''),  # noqa
        '0019xx13': ('SS', '1', 'Pan X', ''),  # noqa
        '0019xx14': ('SS', '1', 'Pan Y', ''),  # noqa
        '0019xx15': ('SS', '1', 'Native Edge Enh. Adv Perc. Gain', ''),  # noqa
        '0019xx16': ('SS', '1', 'Subtr. Edge Enh. Adv Perc. Gain', ''),  # noqa
        '0019xx17': ('US', '1', 'Invert Flag', ''),  # noqa
        '0019xx1a': ('OB', '1', 'Quant 1K Overlay', ''),  # noqa
        '0019xx1b': ('US', '1', 'Original Resolution', ''),  # noqa
        '0019xx1c': ('DS', '1', 'Auto Window Center', ''),  # noqa
        '0019xx1d': ('DS', '1', 'Auto Window Width', ''),  # noqa
    },
    'SIEMENS Selma': {
        '0019xx06': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx07': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx08': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx26': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx29': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx30': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx31': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx32': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx33': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx34': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx35': ('US', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS WH SR 1.0': {
        '0071xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '0071xx02': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'SIEMENS_FLCOMPACT_VA01A_PROC': {
        '0017xx0a': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx0b': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx0c': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx0d': ('FL', '1', 'Internal Data', ''),  # noqa
        '0017xx0e': ('LO', '1', 'Internal Data', ''),  # noqa
        '0017xx0f': ('LO', '1', 'Internal Data', ''),  # noqa
        '0017xx14': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx16': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx17': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx18': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx19': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx1a': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx1b': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx1c': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx1e': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx1f': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx20': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx21': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx22': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx23': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx24': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx25': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx26': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx27': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx28': ('FL', '1', 'Internal Data', ''),  # noqa
        '0017xx29': ('FL', '1', 'Internal Data', ''),  # noqa
        '0017xx48': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx49': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx4a': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx4b': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx4c': ('LO', '1', 'Internal Data', ''),  # noqa
        '0017xx4d': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx4e': ('LO', '1', 'Internal Data', ''),  # noqa
        '0017xx4f': ('LO', '1', 'Internal Data', ''),  # noqa
        '0017xx50': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx51': ('FL', '1', 'Internal Data', ''),  # noqa
        '0017xx52': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx53': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx54': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx55': ('SS', '1', 'Internal Data', ''),  # noqa
        '0017xx5a': ('OW', '1', 'Internal Data', ''),  # noqa
        '0017xx5b': ('OW', '1', 'Internal Data', ''),  # noqa
        '0017xx5c': ('OW', '1', 'Internal Data', ''),  # noqa
        '0017xx64': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx66': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx67': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx68': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx85': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx86': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx87': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx88': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx89': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx8a': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx8b': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx8c': ('FL', '1', 'Internal Data', ''),  # noqa
        '0017xx8d': ('FL', '1', 'Internal Data', ''),  # noqa
        '0017xx8e': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xx8f': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxa0': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxa1': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxa2': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxa3': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxa4': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxa5': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxa6': ('US', '1', 'Internal Data', ''),  # noqa
        '0017xxb0': ('DS', '1', 'Internal Data', ''),  # noqa
        '0017xxc0': ('LO', '1', 'Internal Data', ''),  # noqa
    },
    'SIENET': {
        '0009xx01': ('US', '1', 'SIENET Command Field', ''),  # noqa
        '0009xx14': ('LO', '1', 'Receiver PLA', ''),  # noqa
        '0009xx16': ('US', '1', 'Transfer Priority', ''),  # noqa
        '0009xx29': ('LO', '1', 'Actual User', ''),  # noqa
        '0009xx70': ('DS', '1', 'Unknown', ''),  # noqa
        '0009xx71': ('DS', '1', 'Unknown', ''),  # noqa
        '0009xx72': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx73': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx74': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx75': ('LO', '1', 'Unknown', ''),  # noqa
        '0091xx20': ('PN', '1-n', 'Patient Name', ''),  # noqa
        '0095xx01': ('LO', '1', 'Examination Folder ID', ''),  # noqa
        '0095xx04': ('UL', '1', 'Folder Reported Status', ''),  # noqa
        '0095xx05': ('LO', '1', 'Folder Reporting Radiologist', ''),  # noqa
        '0095xx07': ('LO', '1', 'SIENET ISA PLA', ''),  # noqa
        '0095xx0c': ('UL', '1', 'Folder Rebuild Status', ''),  # noqa
        '0095xx20': ('UN', '1', 'Unknown', ''),  # noqa
        '0099xx02': ('UL', '1', 'Key Images', ''),  # noqa
        '0099xx05': ('SL', '1', 'Image Number', ''),  # noqa
    },
    'SPI': {
        '0009xx10': ('LO', '1', 'Comments', ''),  # noqa
        '0009xx15': ('LO', '1', 'Unique Identifier', ''),  # noqa
        '0009xx40': ('US', '1', 'Data Object Type', ''),  # noqa
        '0009xx41': ('SH', '1', 'Data Object Subtype', ''),  # noqa
        '0011xx10': ('LO', '1', 'Organ', ''),  # noqa
        '0011xx15': ('LO', '1', 'Allergy Indication', ''),  # noqa
        '0011xx20': ('CS', '1', 'Pregnancy', ''),  # noqa
        '0029xx60': ('LO', '1', 'Compression Algorithm', ''),  # noqa
    },
    'SPI RELEASE 1': {
        '0009xx10': ('LO', '1', 'Comments', ''),  # noqa
        '0009xx15': ('LO', '1', 'Unique Identifier', ''),  # noqa
        '0009xx40': ('US', '1', 'Data Object Type', ''),  # noqa
        '0009xx41': ('SH', '1', 'Data Object Subtype', ''),  # noqa
        '0011xx10': ('LO', '1', 'Organ', ''),  # noqa
        '0011xx15': ('LO', '1', 'Allergy Indication', ''),  # noqa
        '0011xx20': ('CS', '1', 'Pregnancy', ''),  # noqa
        '0029xx60': ('LO', '1', 'Compression Algorithm', ''),  # noqa
    },
    'SPI Release 1': {
        '0009xx08': ('CS', '1', 'Unknown', ''),  # noqa
        '0009xx10': ('LO', '1', 'Comments', ''),  # noqa
        '0009xx15': ('LO', '1', 'UID', ''),  # noqa
        '0009xx40': ('US', '1', 'Data Object Type', ''),  # noqa
        '0009xx41': ('SH', '1', 'Data Object Subtype', ''),  # noqa
        '0011xx10': ('LO', '1', 'Organ', ''),  # noqa
        '0011xx15': ('LO', '1', 'Allergy Indication', ''),  # noqa
        '0011xx20': ('LO', '1', 'Pregnancy', ''),  # noqa
        '0029xx60': ('LO', '1', 'Compression Algorithm', ''),  # noqa
    },
    'SPI-P Release 1': {
        '0009xx00': ('LT', '1', 'Data Object Recognition Code', ''),  # noqa
        '0009xx04': ('LO', '1-n', 'Image Data Consistency', ''),  # noqa
        '0009xx08': ('US', '1', 'Unknown', ''),  # noqa
        '0009xx12': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx15': ('LO', '1', 'Unique Identifier', ''),  # noqa
        '0009xx16': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx18': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx21': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xx22': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx31': ('LO', '1', 'PACS Unique Identifier', ''),  # noqa
        '0009xx34': ('LO', '1', 'Cluster Unique Identifier', ''),  # noqa
        '0009xx38': ('LO', '1', 'System Unique Identifier', ''),  # noqa
        '0009xx39': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx40': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx41': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx51': ('LO', '1', 'Study Unique Identifier', ''),  # noqa
        '0009xx61': ('LO', '1', 'Series Unique Identifier', ''),  # noqa
        '0009xx91': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xxa0': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xxf2': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xxf3': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xxf4': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xxf5': ('UN', '1', 'Unknown', ''),  # noqa
        '0009xxf7': ('LT', '1', 'Unknown', ''),  # noqa
        '0011xx10': ('LT', '1', 'Patient Entry ID', ''),  # noqa
        '0011xx20': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx21': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx22': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx30': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx31': ('UN', '1', 'Unknown', ''),  # noqa
        '0011xx32': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx00': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx01': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx02': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx10': ('US', '1', 'Mains Frequency', ''),  # noqa
        '0019xx25': ('LO', '1-n', 'Original Pixel Data Quality', ''),  # noqa
        '0019xx30': ('US', '1', 'ECG Triggering', ''),  # noqa
        '0019xx31': ('UN', '1', 'ECG 1 Offset', ''),  # noqa
        '0019xx32': ('UN', '1', 'ECG 2 Offset 1', ''),  # noqa
        '0019xx33': ('UN', '1', 'ECG 2 Offset 2', ''),  # noqa
        '0019xx50': ('US', '1', 'Video Scan Mode', ''),  # noqa
        '0019xx51': ('US', '1', 'Video LineRate', ''),  # noqa
        '0019xx60': ('US', '1', 'Xray Technique', ''),  # noqa
        '0019xx61': ('DS', '1', 'Image Identifier Format', ''),  # noqa
        '0019xx62': ('US', '1', 'Iris Diaphragm', ''),  # noqa
        '0019xx63': ('CS', '1', 'Filter', ''),  # noqa
        '0019xx64': ('CS', '1', 'Cine Parallel', ''),  # noqa
        '0019xx65': ('CS', '1', 'Cine Master', ''),  # noqa
        '0019xx70': ('US', '1', 'Exposure Channel', ''),  # noqa
        '0019xx71': ('UN', '1', 'Exposure Channel First Image', ''),  # noqa
        '0019xx72': ('US', '1', 'Processing Channel', ''),  # noqa
        '0019xx80': ('DS', '1', 'Acquisition Delay', ''),  # noqa
        '0019xx81': ('UN', '1', 'Relative Image Time', ''),  # noqa
        '0019xx90': ('CS', '1', 'Video White Compression', ''),  # noqa
        '0019xxa0': ('US', '1', 'Angulation', ''),  # noqa
        '0019xxa1': ('US', '1', 'Rotation', ''),  # noqa
        '0021xx12': ('LT', '1', 'Series Unique Identifier', ''),  # noqa
        '0021xx14': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx00': ('DS', '4', 'Unknown', ''),  # noqa
        '0029xx20': ('DS', '1', 'Pixel Aspect Ratio', ''),  # noqa
        '0029xx25': ('LO', '1-n', 'Processed Pixel Data Quality', ''),  # noqa
        '0029xx30': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx38': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx60': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx61': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx67': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx70': ('LT', '1', 'Window ID', ''),  # noqa
        '0029xx71': ('CS', '1', 'Video Invert Subtracted', ''),  # noqa
        '0029xx72': ('CS', '1', 'Video Invert Nonsubtracted', ''),  # noqa
        '0029xx77': ('CS', '1', 'Window Select Status', ''),  # noqa
        '0029xx78': ('LT', '1', 'ECG Display Printing ID', ''),  # noqa
        '0029xx79': ('CS', '1', 'ECG Display Printing', ''),  # noqa
        '0029xx7e': ('CS', '1', 'ECG Display Printing Enable Status', ''),  # noqa
        '0029xx7f': ('CS', '1', 'ECG Display Printing Select Status', ''),  # noqa
        '0029xx80': ('LT', '1', 'Physiological Display ID', ''),  # noqa
        '0029xx81': ('US', '1', 'Preferred Physiological Channel Display', ''),  # noqa
        '0029xx8e': ('CS', '1', 'Physiological Display Enable Status', ''),  # noqa
        '0029xx8f': ('CS', '1', 'Physiological Display Select Status', ''),  # noqa
        '0029xx90': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0029xx91': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx9f': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xxa0': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0029xxa1': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxaf': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xxb0': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0029xxb1': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxbf': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xxc0': ('LT', '1', 'Functional Shutter ID', ''),  # noqa
        '0029xxc1': ('US', '1', 'Field Of Shutter', ''),  # noqa
        '0029xxc5': ('LT', '1', 'Field Of Shutter Rectangle', ''),  # noqa
        '0029xxce': ('CS', '1', 'Shutter Enable Status', ''),  # noqa
        '0029xxcf': ('CS', '1', 'Shutter Select Status', ''),  # noqa
        '7fe1xx10': ('UN', '1', 'Pixel Data', ''),  # noqa
    },
    'SPI-P Release 1;1': {
        '0009xxc0': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xxc1': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx00': ('UN', '1', 'Physiological Data Type', ''),  # noqa
        '0019xx01': ('UN', '1', 'Physiological Data Channel And Kind', ''),  # noqa
        '0019xx02': ('US', '1', 'Sample Bits Allocated', ''),  # noqa
        '0019xx03': ('US', '1', 'Sample Bits Stored', ''),  # noqa
        '0019xx04': ('US', '1', 'Sample High Bit', ''),  # noqa
        '0019xx05': ('US', '1', 'Sample Representation', ''),  # noqa
        '0019xx06': ('UN', '1', 'Smallest Sample Value', ''),  # noqa
        '0019xx07': ('UN', '1', 'Largest Sample Value', ''),  # noqa
        '0019xx08': ('UN', '1', 'Number Of Samples', ''),  # noqa
        '0019xx09': ('UN', '1', 'Sample Data', ''),  # noqa
        '0019xx0a': ('UN', '1', 'Sample Rate', ''),  # noqa
        '0019xx10': ('UN', '1', 'Physiological Data Type 2', ''),  # noqa
        '0019xx11': ('UN', '1', 'Physiological Data Channel And Kind 2', ''),  # noqa
        '0019xx12': ('US', '1', 'Sample Bits Allocated 2', ''),  # noqa
        '0019xx13': ('US', '1', 'Sample Bits Stored 2', ''),  # noqa
        '0019xx14': ('US', '1', 'Sample High Bit 2', ''),  # noqa
        '0019xx15': ('US', '1', 'Sample Representation 2', ''),  # noqa
        '0019xx16': ('UN', '1', 'Smallest Sample Value 2', ''),  # noqa
        '0019xx17': ('UN', '1', 'Largest Sample Value 2', ''),  # noqa
        '0019xx18': ('UN', '1', 'Number Of Samples 2', ''),  # noqa
        '0019xx19': ('UN', '1', 'Sample Data 2', ''),  # noqa
        '0019xx1a': ('UN', '1', 'Sample Rate 2', ''),  # noqa
        '0021xx41': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx42': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx43': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx44': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xx45': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx50': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx51': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx52': ('US', '1', 'Unknown', ''),  # noqa
        '0021xx60': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0021xx61': ('IS', '1-n', 'Unknown', ''),  # noqa
        '0021xx67': ('LO', '1-n', 'Unknown', ''),  # noqa
        '0021xx6a': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0021xx6b': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0021xx6c': ('US', '1-n', 'Unknown', ''),  # noqa
        '0021xx6d': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0021xx6e': ('US', '1-n', 'Unknown', ''),  # noqa
        '0021xx6f': ('DS', '1-n', 'Unknown', ''),  # noqa
        '0029xx00': ('LT', '1', 'Zoom ID', ''),  # noqa
        '0029xx01': ('DS', '1-n', 'Zoom Rectangle', ''),  # noqa
        '0029xx03': ('DS', '1', 'Zoom Factor', ''),  # noqa
        '0029xx04': ('US', '1', 'Zoom Function', ''),  # noqa
        '0029xx0e': ('CS', '1', 'Zoom Enable Status', ''),  # noqa
        '0029xx0f': ('CS', '1', 'Zoom Select Status', ''),  # noqa
        '0029xx40': ('LT', '1', 'Magnifying Glass ID', ''),  # noqa
        '0029xx41': ('DS', '1-n', 'Magnifying Glass Rectangle', ''),  # noqa
        '0029xx43': ('DS', '1', 'Magnifying Glass Factor', ''),  # noqa
        '0029xx44': ('US', '1', 'Magnifying Glass Function', ''),  # noqa
        '0029xx4e': ('CS', '1', 'Magnifying Glass Enable Status', ''),  # noqa
        '0029xx4f': ('CS', '1', 'Magnifying Glass Select Status', ''),  # noqa
    },
    'SPI-P Release 1;2': {
        '0029xx00': ('LT', '1', 'Subtraction Mask ID', ''),  # noqa
        '0029xx04': ('UN', '1', 'Masking Function', ''),  # noqa
        '0029xx0c': ('UN', '1', 'Proprietary Masking Parameters', ''),  # noqa
        '0029xx1e': ('CS', '1', 'Subtraction Mask Enable Status', ''),  # noqa
        '0029xx1f': ('CS', '1', 'Subtraction Mask Select Status', ''),  # noqa
    },
    'SPI-P Release 1;3': {
        '0029xx00': ('LT', '1', 'Image Enhancement ID', ''),  # noqa
        '0029xx01': ('LT', '1', 'Image Enhancement', ''),  # noqa
        '0029xx02': ('LT', '1', 'Convolution ID', ''),  # noqa
        '0029xx03': ('LT', '1', 'Convolution Type', ''),  # noqa
        '0029xx04': ('LT', '1', 'Convolution Kernel Size ID', ''),  # noqa
        '0029xx05': ('US', '2', 'Convolution Kernel Size', ''),  # noqa
        '0029xx06': ('US', '1-n', 'Convolution Kernel', ''),  # noqa
        '0029xx0c': ('DS', '1', 'Enhancement Gain', ''),  # noqa
        '0029xx1e': ('CS', '1', 'Image Enhancement Enable Status', ''),  # noqa
        '0029xx1f': ('CS', '1', 'Image Enhancement Select Status', ''),  # noqa
    },
    'SPI-P Release 2;1': {
        '0011xx18': ('LT', '1', 'Unknown', ''),  # noqa
        '0023xx0d': ('UI', '1', 'Unknown', ''),  # noqa
        '0023xx0e': ('UI', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-CTBE Release 1': {
        '0019xx00': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx02': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx03': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx04': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx05': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx0b': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx0c': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx14': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx18': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx19': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx1a': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx1b': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx1c': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx1d': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-CTBE-Private Release 1': {
        '0021xx00': ('DS', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-GV-CT Release 1': {
        '0009xx00': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx20': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx30': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx40': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx60': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx70': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx75': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx80': ('LO', '1', 'Unknown', ''),  # noqa
        '0009xx90': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx08': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx09': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx0a': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx20': ('TM', '1', 'Unknown', ''),  # noqa
        '0019xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx60': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx61': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx63': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx64': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx65': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx70': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx80': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx81': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx90': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xxa0': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xxa1': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxa2': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxa3': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxb0': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xxb1': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx20': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx30': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xx40': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xx60': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xx70': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xx80': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xx90': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xxa0': ('US', '1', 'Unknown', ''),  # noqa
        '0021xxa1': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xxa2': ('DS', '1', 'Unknown', ''),  # noqa
        '0021xxa3': ('LT', '1', 'Unknown', ''),  # noqa
        '0021xxa4': ('LT', '1', 'Unknown', ''),  # noqa
        '0021xxb0': ('LO', '1', 'Unknown', ''),  # noqa
        '0021xxc0': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx30': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx31': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx32': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx33': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx80': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx90': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xxd0': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xxd1': ('IS', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-PCR Release 2': {
        '0019xx10': ('US', '1', 'Reader Mode', ''),  # noqa
        '0019xx20': ('ST', '1', 'MRM Code', ''),  # noqa
        '0019xx30': ('US', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('DS', '1', 'Latitude', ''),  # noqa
        '0019xx60': ('ST', '1', 'View Name', ''),  # noqa
        '0019xx80': ('US', '1', 'Unknown', ''),  # noqa
        '0019xxa1': ('ST', '1', 'Unknown', ''),  # noqa
        '0019xxa3': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa4': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa5': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa6': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa7': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa8': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxa9': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxaa': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxab': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxac': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxad': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxae': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxaf': ('ST', '1', 'Unknown', ''),  # noqa
        '0019xxb0': ('ST', '1', 'Unknown', ''),  # noqa
        '0019xxb1': ('ST', '1', 'Unknown', ''),  # noqa
        '0019xxb2': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxb3': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxb4': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xxb5': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxb6': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxb7': ('ST', '1', 'Unknown', ''),  # noqa
        '0019xxb8': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xxb9': ('ST', '1', 'Unknown', ''),  # noqa
        '0019xxba': ('ST', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private-CWS Release 1': {
        '0021xx00': ('LT', '1', 'Window Of Images ID', ''),  # noqa
        '0021xx01': ('CS', '1', 'Window Of Images Type', ''),  # noqa
        '0021xx02': ('IS', '1-n', 'WindowOfImagesScope', ''),  # noqa
    },
    'SPI-P-Private-DCI Release 1': {
        '0019xx10': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx11': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx12': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx13': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx14': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx15': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx16': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx17': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private-DiDi Release 1': {
        '0019xx00': ('LT', '1', 'Post Mode String', ''),  # noqa
        '0019xx01': ('LT', '1', 'Post Data', ''),  # noqa
        '0019xx10': ('LT', '1', 'Image Header', ''),  # noqa
        '0019xx20': ('LT', '1', 'SCPreName', ''),  # noqa
        '0019xx21': ('IS', '1', 'SCPostNo', ''),  # noqa
        '0019xx22': ('LT', '1', 'SCSOPInstanceUID', ''),  # noqa
        '0019xx23': ('LT', '1', 'SCCreationDate', ''),  # noqa
        '0019xx24': ('LT', '1', 'SCProcessingCategory', ''),  # noqa
        '0019xx25': ('LT', '1', 'SCPostMethod', ''),  # noqa
        '0019xx26': ('LT', '1', 'SCPostString', ''),  # noqa
        '0019xx27': ('LT', '1', 'SCPostString2', ''),  # noqa
        '0019xx28': ('LT', '1', 'SCMode', ''),  # noqa
        '0019xx29': ('IS', '1', 'SCStCommit', ''),  # noqa
        '0019xx2a': ('IS', '1', 'SCExported', ''),  # noqa
        '0019xx2b': ('IS', '1', 'SCPrinted', ''),  # noqa
        '0019xx2c': ('LT', '1', 'SCOperator', ''),  # noqa
        '0019xx40': ('LT', '1', 'SCPreName', ''),  # noqa
        '0019xx41': ('IS', '1', 'SCPreType', ''),  # noqa
    },
    'SPI-P-Private_CDS Release 1': {
        '0021xx40': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx00': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private_ICS Release 1': {
        '0019xx30': ('DS', '1', 'Unknown', ''),  # noqa
        '0019xx31': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx07': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx08': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx0c': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx0d': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx0e': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx0f': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx18': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx1b': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx1c': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx1d': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx1e': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx20': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx4c': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx4d': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx4e': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx4f': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx50': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx51': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx66': ('DS', '4', 'Unknown', ''),  # noqa
        '0029xx67': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx68': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx6a': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx6b': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx72': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx91': ('IS', '1', 'Unknown', ''),  # noqa
        '0029xx93': ('LO', '1-n', 'Unknown', ''),  # noqa
        '0029xx94': ('LO', '1-n', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private_ICS Release 1;1': {
        '0029xx00': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xx05': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx06': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx20': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx22': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx23': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx24': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx25': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx26': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx30': ('ST', '1', 'Unknown', ''),  # noqa
        '0029xx6b': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxc1': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxcb': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxcc': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxcd': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxd4': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xxd5': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xxd6': ('ST', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private_ICS Release 1;2': {
        '0029xx00': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx02': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx03': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xx04': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xx05': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xx30': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xxa0': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxa1': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxa2': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxa3': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxa5': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxa6': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxd9': ('SQ', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private_ICS Release 1;3': {
        '0029xx00': ('ST', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('ST', '1', 'Unknown', ''),  # noqa
        '0029xx60': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxb0': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxb1': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xxb2': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xxb4': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xxb9': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xxc0': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxc1': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxc2': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxc3': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxc4': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxc5': ('SQ', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private_ICS Release 1;4': {
        '0029xx00': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('FL', '2', 'Unknown', ''),  # noqa
        '0029xx02': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx06': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx07': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xx08': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx09': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx0a': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx0b': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx0c': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx0e': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx0f': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xx90': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xx9a': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx9c': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xxa0': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxa1': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxb1': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxb2': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxb3': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxb5': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xxb6': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxbc': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxbd': ('SL', '1', 'Unknown', ''),  # noqa
        '0029xxbe': ('US', '1', 'Unknown', ''),  # noqa
        '0029xxd6': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxd7': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxd8': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xxd9': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xxda': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xxdc': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxdd': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xxe0': ('SQ', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private_ICS Release 1;5': {
        '0029xx50': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx55': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-Private_ICS Release 1;6': {
        '0029xx01': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx02': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx03': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx04': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx06': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx07': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx08': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx0a': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx0b': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx0c': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx0d': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx0f': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx14': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx15': ('UL', '2', 'Unknown', ''),  # noqa
        '0029xx16': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx17': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx1a': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx1d': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx1f': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx20': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx23': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx24': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx2a': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx2b': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx2c': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx2d': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx2e': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx2f': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx32': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx34': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx35': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx36': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx37': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx38': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx39': ('FL', '1', 'Unknown', ''),  # noqa
        '0029xx3d': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx43': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx44': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx48': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx4f': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx5c': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx5d': ('UL', '1-n', 'Unknown', ''),  # noqa
        '0029xx5e': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx5f': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx63': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx65': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx66': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx67': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx68': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx69': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx6d': ('SQ', '1', 'Unknown', ''),  # noqa
    },
    'SPI-P-XSB-DCI Release 1': {
        '0019xx10': ('LT', '1', 'Video Beam Boost', ''),  # noqa
        '0019xx11': ('US', '1', 'Channel Generating Video Sync', ''),  # noqa
        '0019xx12': ('US', '1', 'Video Gain', ''),  # noqa
        '0019xx13': ('US', '1', 'Video Offset', ''),  # noqa
        '0019xx20': ('DS', '1', 'RTD Data Compression Factor', ''),  # noqa
    },
    'SPI-P-XSB-VISUB Release 1': {
        '0019xx00': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx10': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx11': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx12': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx20': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx40': ('UN', '1', 'Unknown', ''),  # noqa
        '0019xx50': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx00': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx01': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx02': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx0f': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx10': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx11': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx12': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx1f': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx20': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx22': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx2f': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx30': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx31': ('DS', '1', 'Unknown', ''),  # noqa
        '0029xx32': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx3f': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'STENTOR': {
        '0073xx01': ('ST', '1', 'Unknown', ''),  # noqa
        '0073xx02': ('LT', '1', 'Private Creator', ''),  # noqa
        '0073xx03': ('UT', '1', 'Stentor Remote AETitle Element', ''),  # noqa
        '0073xx04': ('UT', '1', 'Stentor Local AETitle Element', ''),  # noqa
        '0073xx06': ('UT', '1', 'Stentor Transfer Syntax Value', ''),  # noqa
    },
    'SVISION': {
        '0017xx00': ('LO', '1', 'Extended Body Part', ''),  # noqa
        '0017xx10': ('LO', '1', 'Extended View Position', ''),  # noqa
        '0017xx20': ('SQ', '1', 'Scheduled Procedure Step', ''),  # noqa
        '0017xxa0': ('IS', '1', 'Fixed Grid System', ''),  # noqa
        '0017xxf0': ('IS', '1', 'Images SOP Class', ''),  # noqa
        '0019xx00': ('IS', '1', 'AEC Field', ''),  # noqa
        '0019xx01': ('IS', '1', 'AEC Film Screen', ''),  # noqa
        '0019xx02': ('IS', '1', 'AEC Density', ''),  # noqa
        '0019xx10': ('IS', '1', 'Patient Thickness', ''),  # noqa
        '0019xx16': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx18': ('IS', '1', 'Beam Distance', ''),  # noqa
        '0019xx20': ('IS', '1', 'Workstation Number', ''),  # noqa
        '0019xx28': ('IS', '1', 'Tube Number', ''),  # noqa
        '0019xx30': ('IS', '1', 'Bucky Grid', ''),  # noqa
        '0019xx34': ('IS', '1', 'Focus', ''),  # noqa
        '0019xx38': ('IS', '1', 'Age Group', ''),  # noqa
        '0019xx40': ('IS', '1', 'Collimator Distance X', ''),  # noqa
        '0019xx41': ('IS', '1', 'Collimator Distance Y', ''),  # noqa
        '0019xx50': ('IS', '1', 'Bucky Height', ''),  # noqa
        '0019xx60': ('IS', '1', 'Bucky Angle', ''),  # noqa
        '0019xx68': ('IS', '1', 'C-Arm Angle', ''),  # noqa
        '0019xx69': ('IS', '1', 'Collimator Angle', ''),  # noqa
        '0019xx70': ('IS', '1', 'Filter Number', ''),  # noqa
        '0019xx74': ('LO', '1', 'Filter Material 1', ''),  # noqa
        '0019xx75': ('LO', '1', 'Filter Material 2', ''),  # noqa
        '0019xx78': ('DS', '1', 'Filter Thickness 1', ''),  # noqa
        '0019xx79': ('DS', '1', 'Filter Thickness 2', ''),  # noqa
        '0019xx80': ('IS', '1', 'Bucky Format', ''),  # noqa
        '0019xx81': ('IS', '1', 'Object Position', ''),  # noqa
        '0019xx90': ('LO', '1', 'Desk Command', ''),  # noqa
        '0019xx91': ('IS', '1', 'Central Beam X', ''),  # noqa
        '0019xx92': ('IS', '1', 'Central Beam Y', ''),  # noqa
        '0019xx93': ('IS', '1', 'Tube Turn Angle', ''),  # noqa
        '0019xx94': ('IS', '1', 'Stand drive level', ''),  # noqa
        '0019xxa0': ('DS', '1', 'Extended Exposure Time', ''),  # noqa
        '0019xxa1': ('DS', '1', 'Actual Exposure Time', ''),  # noqa
        '0019xxa8': ('DS', '1', 'Extended X-ray Tube Current', ''),  # noqa
        '0019xxb0': ('IS', '1', 'Dose Indicator', ''),  # noqa
        '0019xxb1': ('IS', '1', 'Shift Reference Value', ''),  # noqa
        '0019xxf0': ('IS', '1', 'Unknown', ''),  # noqa
        '0021xx00': ('DS', '1', 'Noise Reduction', ''),  # noqa
        '0021xx01': ('DS', '1', 'Contrast Amplification', ''),  # noqa
        '0021xx02': ('DS', '1', 'Edge Contrast Boosting', ''),  # noqa
        '0021xx03': ('DS', '1', 'Latitude Reduction', ''),  # noqa
        '0021xx10': ('LO', '1', 'Find Range Algorithm', ''),  # noqa
        '0021xx11': ('DS', '1', 'Threshold C-Algorithm', ''),  # noqa
        '0021xx20': ('LO', '1', 'Sensometric Curve', ''),  # noqa
        '0021xx30': ('DS', '1', 'Lower Window Offset', ''),  # noqa
        '0021xx31': ('DS', '1', 'Upper Window Offset', ''),  # noqa
        '0021xx40': ('DS', '1', 'Min. Printable Density', ''),  # noqa
        '0021xx41': ('DS', '1', 'Max. Printable Density', ''),  # noqa
        '0021xx50': ('DS', '1', 'Min. Window Latitude', ''),  # noqa
        '0021xx51': ('DS', '1', 'Max. Window Latitude', ''),  # noqa
        '0021xx52': ('DS', '1', 'Rel. Window Alignment', ''),  # noqa
        '0021xx60': ('DS', '1', 'Decomposition Layer', ''),  # noqa
        '0021xx90': ('DS', '1', 'Brightness', ''),  # noqa
        '0021xx91': ('DS', '1', 'Contrast', ''),  # noqa
        '0021xx92': ('DS', '1', 'Shape Factor', ''),  # noqa
        '0023xx00': ('LO', '1', 'Image Laterality', ''),  # noqa
        '0023xx01': ('IS', '1', 'Letter Position', ''),  # noqa
        '0023xx02': ('IS', '1', 'Burned In Annotation', ''),  # noqa
        '0023xx03': ('LO', '1', 'Unknown', ''),  # noqa
        '0023xxf0': ('IS', '1', 'Image SOP Class', ''),  # noqa
        '0025xx00': ('IS', '1', 'Original Image', ''),  # noqa
        '0025xx01': ('IS', '1', 'Not Processed Image', ''),  # noqa
        '0025xx02': ('IS', '1', 'Cut Out Image', ''),  # noqa
        '0025xx03': ('IS', '1', 'Duplicated Image', ''),  # noqa
        '0025xx04': ('IS', '1', 'Stored Image', ''),  # noqa
        '0025xx05': ('IS', '1', 'Retrieved Image', ''),  # noqa
        '0025xx06': ('IS', '1', 'New Image', ''),  # noqa
        '0025xx07': ('IS', '1', 'Media Stored Image', ''),  # noqa
        '0025xx08': ('IS', '1', 'Image State', ''),  # noqa
        '0025xx09': ('IS', '1', 'Image Stitched Manually', ''),  # noqa
        '0025xx0a': ('IS', '1', 'Image Stitched Automatically', ''),  # noqa
        '0025xx20': ('LO', '1', 'Source Image File', ''),  # noqa
        '0025xx21': ('LO', '1', 'Source UID', ''),  # noqa
        '0027xx00': ('IS', '1', 'Number of Series', ''),  # noqa
        '0027xx01': ('IS', '1', 'Number of Studies', ''),  # noqa
        '0027xx10': ('DT', '1', 'Oldest Series', ''),  # noqa
        '0027xx11': ('DT', '1', 'Newest Series', ''),  # noqa
        '0027xx12': ('DT', '1', 'Oldest Study', ''),  # noqa
        '0027xx13': ('DT', '1', 'Newest Study', ''),  # noqa
        '0029xx00': ('IS', '1', 'Key Note Instance UID', ''),  # noqa
        '0029xx01': ('IS', '1', 'Storage State', ''),  # noqa
        '0029xx02': ('IS', '1', 'Referenced Image SOP Class', ''),  # noqa
        '0029xx03': ('LO', '1', 'Ref. Image Instance UID', ''),  # noqa
        '0029xx04': ('IS', '1', 'Rel. Presentation State Number', ''),  # noqa
        '0029xx05': ('LO', '1', 'Rel. Presentation State UID', ''),  # noqa
    },
    'Siemens Ultrasound Miscellaneous': {
        '0019xx20': ('SH', '1', 'Unknown', ''),  # noqa
    },
    'Siemens: Thorax/Multix FD Image Stamp': {
        '0023xx00': ('US', '1', 'Unknown', ''),  # noqa
        '0023xx01': ('US', '1', 'Unknown', ''),  # noqa
        '0023xx02': ('US', '1', 'Unknown', ''),  # noqa
        '0023xx03': ('US', '1', 'Unknown', ''),  # noqa
        '0023xx04': ('US', '1', 'Unknown', ''),  # noqa
    },
    'Siemens: Thorax/Multix FD Lab Settings': {
        '0019xx00': ('LT', '1', 'Internal Value', ''),  # noqa
        '0019xx02': ('LO', '1', 'Total Area Dose Product', ''),  # noqa
        '0019xx04': ('LO', '1', 'Unknown', ''),  # noqa
        '0019xx05': ('US', '1', 'Cassette Image', ''),  # noqa
        '0019xx06': ('FD', '1', 'Table Object Distance', ''),  # noqa
        '0019xx07': ('FD', '1', 'Table Detector Distance', ''),  # noqa
        '0019xx08': ('US', '1', 'Ortho Step Distance', ''),  # noqa
        '0021xx08': ('US', '1', 'Auto Window Flag', ''),  # noqa
        '0021xx09': ('SL', '1', 'Auto Window Center', ''),  # noqa
        '0021xx0a': ('SL', '1', 'Auto Window Width', ''),  # noqa
        '0021xx0b': ('SS', '1', 'Filter ID', ''),  # noqa
        '0021xx14': ('US', '1', 'Anatomic Correct View', ''),  # noqa
        '0021xx15': ('SS', '1', 'Auto Window Shift', ''),  # noqa
        '0021xx16': ('DS', '1', 'Auto Window Expansion', ''),  # noqa
        '0021xx17': ('LO', '1', 'System Type', ''),  # noqa
        '0021xx30': ('SH', '1', 'Anatomic Sort Number', ''),  # noqa
        '0021xx31': ('SH', '1', 'Acquisition Sort Number', ''),  # noqa
    },
    'Siemens: Thorax/Multix FD Post Processing': {
        '0021xx00': ('US', '1', 'Label Left', ''),  # noqa
        '0021xx01': ('SS', '1', 'Label Left Orientation', ''),  # noqa
        '0021xx02': ('FL', '1', 'Label Left Percentage X', ''),  # noqa
        '0021xx03': ('FL', '1', 'Label Left Percentage X', ''),  # noqa
        '0021xx04': ('US', '1', 'Label Right', ''),  # noqa
        '0021xx05': ('SS', '1', 'Label Right Orientation', ''),  # noqa
        '0021xx06': ('FL', '1', 'Label Right Percentage X', ''),  # noqa
        '0021xx07': ('FL', '1', 'Label Right Percentage X', ''),  # noqa
        '0021xx08': ('US', '1', 'Auto Window Flag', ''),  # noqa
        '0021xx09': ('SL', '1', 'Auto Window Center', ''),  # noqa
        '0021xx0a': ('SL', '1', 'Auto Window Width', ''),  # noqa
        '0021xx0b': ('SS', '1', 'Filter ID', ''),  # noqa
        '0021xx0c': ('FL', '1', 'Degree of Edge Enhancement', ''),  # noqa
        '0021xx0d': ('SS', '1', 'Half Kernel Size', ''),  # noqa
        '0021xx0e': ('US', '1', 'Dose Control Value', ''),  # noqa
        '0021xx0f': ('US', '1', 'Deleted Image Flag', ''),  # noqa
        '0021xx10': ('US', '1', 'Same Size Support', ''),  # noqa
        '0021xx11': ('SS', '1', 'Label Left Init Position', ''),  # noqa
        '0021xx12': ('SS', '1', 'Label Right Init Position', ''),  # noqa
        '0021xx13': ('SS', '1', 'Patient Rotation', ''),  # noqa
        '0021xx14': ('US', '1', 'Anatomic Correct View Flag', ''),  # noqa
        '0021xx15': ('SS', '1', 'Auto Window Shift', ''),  # noqa
        '0021xx16': ('DS', '1', 'Auto Window Expansion', ''),  # noqa
    },
    'Siemens: Thorax/Multix FD Raw Image Settings': {
        '0025xx00': ('SS', '1', 'Raw Image Amplification', ''),  # noqa
        '0025xx01': ('SS', '1', 'Gamma LUT', ''),  # noqa
        '0025xx02': ('US', '1', 'Collimator Manual', ''),  # noqa
        '0025xx03': ('FL', '1', 'Collimator Up Left X Percentage', ''),  # noqa
        '0025xx04': ('FL', '1', 'Collimator Up Right X Percentage', ''),  # noqa
        '0025xx05': ('FL', '1', 'Collimator Low Left X Percentage', ''),  # noqa
        '0025xx06': ('FL', '1', 'Collimator Low Right X Percentage', ''),  # noqa
        '0025xx07': ('FL', '1', 'Collimator Up Left Y Percentage', ''),  # noqa
        '0025xx08': ('FL', '1', 'Collimator Up Right Y Percentage', ''),  # noqa
        '0025xx09': ('FL', '1', 'Collimator Low Left Y Percentage', ''),  # noqa
        '0025xx0a': ('FL', '1', 'Collimator Low Right Y Percentage', ''),  # noqa
        '0025xx0b': ('US', '1', 'Set Gray', ''),  # noqa
        '0025xx0c': ('SS', '1', 'Harmonization Kernel', ''),  # noqa
        '0025xx0d': ('FL', '1', 'Harmonization Gain', ''),  # noqa
        '0025xx0e': ('SS', '1', 'Edge Enhancement Kernel', ''),  # noqa
        '0025xx0f': ('FL', '1', 'Edge Enhancement Gain', ''),  # noqa
        '0025xx10': ('LT', '1', 'Raw Image File Name', ''),  # noqa
        '0025xx11': ('SS', '1', 'Global Offset', ''),  # noqa
        '0025xx12': ('SS', '1', 'Image Columns', ''),  # noqa
        '0025xx13': ('SS', '1', 'Image Rows', ''),  # noqa
        '0025xx14': ('SS', '1', 'Image Alignment', ''),  # noqa
        '0025xx15': ('SS', '1', 'Active Image Columns', ''),  # noqa
        '0025xx16': ('SS', '1', 'Active Image Rows', ''),  # noqa
        '0025xx17': ('LO', '1', 'System Type', ''),  # noqa
        '0025xx18': ('US', '1', 'Auto Gain', ''),  # noqa
        '0025xx19': ('US', '1', 'Ortho Sub Sampling', ''),  # noqa
        '0025xx1a': ('US', '2', 'Image Crop Upper Left', ''),  # noqa
        '0025xx1b': ('US', '2', 'Image Crop Upper Right', ''),  # noqa
        '0025xx1c': ('US', '2', 'Image Crop Lower Left', ''),  # noqa
        '0025xx1d': ('US', '2', 'Image Crop Lower Right', ''),  # noqa
        '0025xx30': ('US', '1', 'Manual Cropping', ''),  # noqa
        '0025xx31': ('SS', '1', 'Gamma LUT Parameter 1', ''),  # noqa
        '0025xx32': ('DS', '1', 'Gamma LUT Parameter 2', ''),  # noqa
        '0025xx33': ('SS', '1', 'Gamma LUT Parameter 3', ''),  # noqa
        '0025xx34': ('SS', '1', 'Gamma LUT Parameter 4', ''),  # noqa
    },
    'Siemens: Thorax/Multix FD Version': {
        '0017xx00': ('LO', '1', 'Build Date', ''),  # noqa
        '0017xx01': ('LO', '1', 'IOD Version', ''),  # noqa
    },
    'Silhouette Annot V1.0': {
        '0029xx11': ('IS', '1', 'Annotation Name', ''),  # noqa
        '0029xx12': ('LT', '1', 'Annotation Font', ''),  # noqa
        '0029xx13': ('LT', '1', 'Annotation Text Foreground Color', ''),  # noqa
        '0029xx14': ('LT', '1', 'Annotation Text Background Color', ''),  # noqa
        '0029xx15': ('UL', '1', 'Annotation Text Backing Mode', ''),  # noqa
        '0029xx16': ('UL', '1', 'Annotation Text Justification', ''),  # noqa
        '0029xx17': ('UL', '1', 'Annotation Text Location', ''),  # noqa
        '0029xx18': ('LT', '1', 'Annotation Text String', ''),  # noqa
        '0029xx19': ('UL', '1', 'Annotation Text Attach Mode', ''),  # noqa
        '0029xx20': ('UL', '1', 'Annotation Text Cursor Mode', ''),  # noqa
        '0029xx21': ('UL', '1', 'Annotation Text Shadow Offset X', ''),  # noqa
        '0029xx22': ('UL', '1', 'Annotation Text Shadow Offset Y', ''),  # noqa
        '0029xx23': ('LT', '1', 'Annotation Line Color', ''),  # noqa
        '0029xx24': ('UL', '1', 'Annotation Line Thickness', ''),  # noqa
        '0029xx25': ('UL', '1', 'Annotation Line Type', ''),  # noqa
        '0029xx26': ('UL', '1', 'Annotation Line Style', ''),  # noqa
        '0029xx27': ('UL', '1', 'Annotation Line Dash Length', ''),  # noqa
        '0029xx28': ('UL', '1', 'Annotation Line Attach Mode', ''),  # noqa
        '0029xx29': ('UL', '1', 'Annotation Line Point Count', ''),  # noqa
        '0029xx30': ('FD', '1', 'Annotation Line Points', ''),  # noqa
        '0029xx31': ('UL', '1', 'Annotation Line Control Size', ''),  # noqa
        '0029xx32': ('LT', '1', 'Annotation Marker Color', ''),  # noqa
        '0029xx33': ('UL', '1', 'Annotation Marker Type', ''),  # noqa
        '0029xx34': ('UL', '1', 'Annotation Marker Size', ''),  # noqa
        '0029xx35': ('FD', '1', 'Annotation Marker Location', ''),  # noqa
        '0029xx36': ('UL', '1', 'Annotation Marker Attach Mode', ''),  # noqa
        '0029xx37': ('LT', '1', 'Annotation Geom Color', ''),  # noqa
        '0029xx38': ('UL', '1', 'Annotation Geom Thickness', ''),  # noqa
        '0029xx39': ('UL', '1', 'Annotation Geom Line Style', ''),  # noqa
        '0029xx40': ('UL', '1', 'Annotation Geom Dash Length', ''),  # noqa
        '0029xx41': ('UL', '1', 'Annotation Geom Fill Pattern', ''),  # noqa
        '0029xx42': ('UL', '1', 'Annotation Interactivity', ''),  # noqa
        '0029xx43': ('FD', '1', 'Annotation Arrow Length', ''),  # noqa
        '0029xx44': ('FD', '1', 'Annotation Arrow Angle', ''),  # noqa
        '0029xx45': ('UL', '1', "Annotation Don't Save", ''),  # noqa
    },
    'Silhouette Graphics Export V1.0': {
        '0029xx00': ('UI', '1', 'Unknown', ''),  # noqa
    },
    'Silhouette Line V1.0': {
        '0029xx11': ('IS', '1', 'Line Name', ''),  # noqa
        '0029xx12': ('LT', '1', 'Line Name Font', ''),  # noqa
        '0029xx13': ('UL', '1', 'Line Name Display', ''),  # noqa
        '0029xx14': ('LT', '1', 'Line Normal Color', ''),  # noqa
        '0029xx15': ('UL', '1', 'Line Type', ''),  # noqa
        '0029xx16': ('UL', '1', 'Line Thickness', ''),  # noqa
        '0029xx17': ('UL', '1', 'Line Style', ''),  # noqa
        '0029xx18': ('UL', '1', 'Line Dash Length', ''),  # noqa
        '0029xx19': ('UL', '1', 'Line Interactivity', ''),  # noqa
        '0029xx20': ('LT', '1', 'Line Measurement Color', ''),  # noqa
        '0029xx21': ('LT', '1', 'Line Measurement Font', ''),  # noqa
        '0029xx22': ('UL', '1', 'Line Measurement Dash Length', ''),  # noqa
        '0029xx23': ('UL', '1', 'Line Point Space', ''),  # noqa
        '0029xx24': ('FD', '1', 'Line Points', ''),  # noqa
        '0029xx25': ('UL', '1', 'Line Control Point Size', ''),  # noqa
        '0029xx26': ('UL', '1', 'Line Control Point Space', ''),  # noqa
        '0029xx27': ('FD', '1', 'Line Control Points', ''),  # noqa
        '0029xx28': ('LT', '1', 'Line Label', ''),  # noqa
        '0029xx29': ('UL', '1', "Line Don't Save", ''),  # noqa
    },
    'Silhouette ROI V1.0': {
        '0029xx11': ('IS', '1', 'ROI Name', ''),  # noqa
        '0029xx12': ('LT', '1', 'ROI Name Font', ''),  # noqa
        '0029xx13': ('LT', '1', 'ROI Normal Color', ''),  # noqa
        '0029xx14': ('UL', '1', 'ROI Fill Pattern', ''),  # noqa
        '0029xx15': ('UL', '1', 'ROI Bp Seg', ''),  # noqa
        '0029xx16': ('UN', '1', 'ROI Bp Seg Pairs', ''),  # noqa
        '0029xx17': ('UL', '1', 'ROI Seed Space', ''),  # noqa
        '0029xx18': ('UN', '1', 'ROI Seeds', ''),  # noqa
        '0029xx19': ('UL', '1', 'ROI Line Thickness', ''),  # noqa
        '0029xx20': ('UL', '1', 'ROI Line Style', ''),  # noqa
        '0029xx21': ('UL', '1', 'ROI Line Dash Length', ''),  # noqa
        '0029xx22': ('UL', '1', 'ROI Interactivity', ''),  # noqa
        '0029xx23': ('UL', '1', 'ROI Name Position', ''),  # noqa
        '0029xx24': ('UL', '1', 'ROI Name Display', ''),  # noqa
        '0029xx25': ('LT', '1', 'ROI Label', ''),  # noqa
        '0029xx26': ('UL', '1', 'ROI Shape', ''),  # noqa
        '0029xx27': ('FD', '1', 'ROI Shape Tilt', ''),  # noqa
        '0029xx28': ('UL', '1', 'ROI Shape Points Count', ''),  # noqa
        '0029xx29': ('UL', '1', 'ROI Shape Points Space', ''),  # noqa
        '0029xx30': ('FD', '1', 'ROI Shape Points', ''),  # noqa
        '0029xx31': ('UL', '1', 'ROI Shape Control Points Count', ''),  # noqa
        '0029xx32': ('UL', '1', 'ROI Shape Control Points Space', ''),  # noqa
        '0029xx33': ('FD', '1', 'ROI Shape Control Points', ''),  # noqa
        '0029xx34': ('UL', '1', "ROI Don't Save", ''),  # noqa
    },
    'Silhouette Sequence Ids V1.0': {
        '0029xx41': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx42': ('SQ', '1', 'Unknown', ''),  # noqa
        '0029xx43': ('SQ', '1', 'Unknown', ''),  # noqa
    },
    'Silhouette V1.0': {
        '0029xx13': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx14': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx17': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx18': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx19': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx1a': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx1b': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx1c': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx1d': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx1e': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx21': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx22': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx23': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx24': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx25': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx27': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx28': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx29': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx30': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx52': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx53': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx54': ('UN', '1', 'Unknown', ''),  # noqa
        '0029xx55': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx56': ('LT', '1', 'Unknown', ''),  # noqa
        '0029xx57': ('UN', '1', 'Unknown', ''),  # noqa
    },
    'Silhouette VRS 3.0': {
        '0029xx13': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx14': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx17': ('FD', '2', 'Unknown', ''),  # noqa
        '0029xx18': ('FD', '2', 'Unknown', ''),  # noqa
        '0029xx19': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx1a': ('FD', '1', 'Unknown', ''),  # noqa
        '0029xx1b': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx1c': ('UL', '1', 'Unknown', ''),  # noqa
        '0029xx1d': ('UL', '3', 'Unknown', ''),  # noqa
        '0029xx1e': ('UL', '3', 'Unknown', ''),  # noqa
        '0029xx27': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx28': ('OB', '1', 'Unknown', ''),  # noqa
        '0029xx30': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx32': ('US', '1', 'Unknown', ''),  # noqa
        '0029xx34': ('LO', '1', 'Unknown', ''),  # noqa
        '0029xx35': ('CS', '1', 'Unknown', ''),  # noqa
        '0029xx36': ('US', '1', 'Unknown', ''),  # noqa
    },
    'Sound Technologies': {
        'f001xx00': ('CS', '1', 'Patient Species', ''),  # noqa
        'f001xx01': ('CS', '1', 'Patient Breed', ''),  # noqa
        'f001xx02': ('CS', '1', 'Patient Category Size', ''),  # noqa
        'f001xx03': ('CS', '1', 'Patient Sex Extended (including spay/neuter)', ''),  # noqa
        'f001xx04': ('CS', '1', 'Image View', ''),  # noqa
        'f001xx05': ('CS', '1', 'Anatomy Imaged', ''),  # noqa
        'f001xx06': ('CS', '1', 'Image enhancements', ''),  # noqa
        'f001xx07': ('CS', '1', 'Detector Settings', ''),  # noqa
        'f001xx08': ('CS', '1', 'Application Version', ''),  # noqa
        'f001xx09': ('LO', '1', 'Image Laterality Extended', ''),  # noqa
        'f001xx0a': ('PN', '1', 'Client Name', ''),  # noqa
        'f001xx0b': ('UI', '1', 'Reference Study Instance Uid', ''),  # noqa
        'f001xx0c': ('UI', '1', 'Reference Series Instance Uid', ''),  # noqa
        'f001xx0d': ('LO', '1', 'Exam Ref Id', ''),  # noqa
        'f001xx0e': ('ST', '1', 'Physician Of Record Address', ''),  # noqa
        'f001xx0f': ('SH', '1', 'Physician Of Record Phone Numbers', ''),  # noqa
        'f001xx10': ('LT', '1', 'Reason For Study', ''),  # noqa
        'f001xx11': ('LO', '1', 'Protocol', ''),  # noqa
        'f001xx12': ('LO', '1', 'CaptureInputType', ''),  # noqa
        'f001xx13': ('LT', '1', 'Exam Complaint', ''),  # noqa
        'f001xx14': ('LO', '1', 'Exam Web Code', ''),  # noqa
        'f001xx15': ('LO', '1', 'Exam Category', ''),  # noqa
        'f001xx16': ('SH', '1', 'Exam Diagnosis', ''),  # noqa
        'f001xx17': ('PN', '1', 'Exam Created By', ''),  # noqa
        'f001xx18': ('LO', '1', 'Exam Created By Group', ''),  # noqa
        'f001xx19': ('DT', '1', 'Exam Required By DateTime', ''),  # noqa
        'f001xx1a': ('LO', '1', 'Capture Type', ''),  # noqa
        'f001xx1b': ('IS', '1', 'Telemed Exam ID', ''),  # noqa
        'f001xx1c': ('LO', '1', 'Exam Created By Guid', ''),  # noqa
        'f001xx1d': ('LO', '1', 'Client Name Guid', ''),  # noqa
    },
    'TMDTK': {
        '7effxx21': ('SQ', '1', 'Unknown', ''),  # noqa
        '7effxx2e': ('LT', '1', 'Unknown', ''),  # noqa
    },
    'TOSHIBA COMAPL HEADER': {
        '0029xx08': ('CS', '1', 'COMAPL Header Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'COMAPL Header Version', ''),  # noqa
        '0029xx10': ('LO', '1', '', ''),  # noqa
        '0029xx20': ('OB', '1', 'COMAPL History Information', ''),  # noqa
        '0029xx31': ('LO', '1-n', '', ''),  # noqa
        '0029xx32': ('UL', '1-n', '', ''),  # noqa
        '0029xx33': ('UL', '1-n', '', ''),  # noqa
        '0029xx34': ('CS', '1-n', '', ''),  # noqa
    },
    'TOSHIBA COMAPL OOG': {
        '0029xx08': ('CS', '1', 'COMAPL OOG Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'COMAPL OOG Version', ''),  # noqa
        '0029xx10': ('LO', '1', '', ''),  # noqa
        '0029xx31': ('LO', '1-n', '', ''),  # noqa
        '0029xx32': ('UL', '1-n', '', ''),  # noqa
        '0029xx33': ('UL', '1-n', '', ''),  # noqa
        '0029xx34': ('CS', '1-n', '', ''),  # noqa
    },
    'TOSHIBA ENCRYPTED SR DATA': {
        '7015xx00': ('OB', '1', 'Toshiba US Private Data', ''),  # noqa
    },
    'TOSHIBA MDW HEADER': {
        '0029xx08': ('CS', '1', 'Application Header Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'Application Header Version', ''),  # noqa
        '0029xx10': ('CS', '1', 'Image Header Type', ''),  # noqa
        '0029xx11': ('LO', '1', 'Image Header Version', ''),  # noqa
        '0029xx12': ('OB', '1', 'Image Header Info', ''),  # noqa
        '0029xx18': ('CS', '1', 'Series Header Type', ''),  # noqa
        '0029xx19': ('LO', '1', 'Series Header Version', ''),  # noqa
        '0029xx20': ('OB', '1', 'Series Header Info', ''),  # noqa
        '0029xx31': ('LO', '1', 'PMTF Information 1', ''),  # noqa
        '0029xx32': ('UL', '1', 'PMTF Information 2', ''),  # noqa
        '0029xx33': ('UL', '1', 'PMTF Information 3', ''),  # noqa
        '0029xx34': ('CS', '1', 'PMTF Information 4', ''),  # noqa
    },
    'TOSHIBA MDW NON-IMAGE': {
        '0029xx08': ('CS', '1', 'Application Header Type', ''),  # noqa
        '0029xx09': ('LO', '1', 'Application Header Version', ''),  # noqa
        '0029xx10': ('OB', '1', 'Application Header Data', ''),  # noqa
        '0029xx20': ('OB', '1', 'Application Header Data', ''),  # noqa
        '7fe1xx10': ('OB', '1', 'Toshiba US Private Data', ''),  # noqa
    },
    'TOSHIBA_MEC_1.0': {
        '0009xx01': ('LT', '1', 'Unknown', ''),  # noqa
        '0009xx02': ('US', '1-n', 'Unknown', ''),  # noqa
        '0009xx03': ('US', '1-n', 'Unknown', ''),  # noqa
        '0009xx04': ('US', '1-n', 'Unknown', ''),  # noqa
        '0011xx01': ('LT', '1', 'Unknown', ''),  # noqa
        '0011xx02': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx01': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx02': ('US', '1-n', 'Unknown', ''),  # noqa
        '0021xx01': ('US', '1-n', 'Unknown', ''),  # noqa
        '0021xx02': ('US', '1-n', 'Unknown', ''),  # noqa
        '0021xx03': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx01': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx02': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx03': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx10': ('US', '1-n', 'Unknown', ''),  # noqa
    },
    'TOSHIBA_MEC_CT3': {
        '7005xx00': ('OB', '1-n', 'CT Private Data 1', ''),  # noqa
        '7005xx03': ('SH', '1', 'Cardiac R-R Mean Time', ''),  # noqa
        '7005xx04': ('SH', '1', 'Cardiac Reconstruction Gating Phase in Percent', ''),  # noqa
        '7005xx05': ('SH', '1', 'Cardiac Reconstruction Gating Phase in ms', ''),  # noqa
        '7005xx06': ('SH', '1', 'Cardiac Reconstruction Mode', ''),  # noqa
        '7005xx07': ('DS', '2', 'Reconstruction Center', ''),  # noqa
        '7005xx08': ('DS', '1', 'Detector Slice Thickness in mm', ''),  # noqa
        '7005xx09': ('LO', '1', 'Number of Detector rows to Reconstruct', ''),  # noqa
        '7005xx0a': ('DS', '1', 'Table Speed in mm/rot', ''),  # noqa
        '7005xx0b': ('SH', '1', 'Filter', ''),  # noqa
        '7005xx0c': ('SH', '1', 'Reconstruction Correction Type', ''),  # noqa
        '7005xx0d': ('CS', '1', 'Organ', ''),  # noqa
        '7005xx0e': ('SH', '1', 'File Type Remarks', ''),  # noqa
        '7005xx0f': ('SH', '1', 'Direction', ''),  # noqa
        '7005xx10': ('OB', '1-n', 'CT Private Data 2', ''),  # noqa
        '7005xx11': ('LT', '1', 'Series Comment', ''),  # noqa
        '7005xx12': ('SH', '1', 'Position', ''),  # noqa
        '7005xx13': ('US', '1', 'Expert Plan No.', ''),  # noqa
        '7005xx14': ('US', '1', 'Reconstruction ROI No.', ''),  # noqa
        '7005xx15': ('US', '1', 'Special Helical ACQ No.', ''),  # noqa
        '7005xx16': ('UI', '1', 'Volume UID', ''),  # noqa
        '7005xx17': ('US', '1', 'Total Frame Count in the Volume', ''),  # noqa
        '7005xx18': ('US', '1', 'Frame No.', ''),  # noqa
        '7005xx19': ('UL', '1', 'Frame Sort Key', ''),  # noqa
        '7005xx1a': ('US', '1', 'Frame Sort Order', ''),  # noqa
        '7005xx1b': ('SH', '1', 'Convolution Kernel', ''),  # noqa
        '7005xx1c': ('LO', '1', 'Contrast/Bolus Agent', ''),  # noqa
        '7005xx1d': ('UL', '1', 'Reconstruction Number', ''),  # noqa
        '7005xx1e': ('UL', '1', 'Raw Data Number', ''),  # noqa
        '7005xx1f': ('LO', '1', 'Volume Number', ''),  # noqa
        '7005xx20': ('UL', '1', 'Local Series Number', ''),  # noqa
        '7005xx21': ('LO', '1', 'Decrease in Artifact Filter', ''),  # noqa
        '7005xx22': ('DS', '1', 'Reconstruction Interval', ''),  # noqa
        '7005xx23': ('DS', '1', 'Pitch Factor', ''),  # noqa
        '7005xx24': ('DA', '1', 'The Acquisition Date of NRA', ''),  # noqa
        '7005xx25': ('UL', '1', 'Large Data File Attribute', ''),  # noqa
        '7005xx26': ('CS', '1-8', 'Large Data File Name', ''),  # noqa
        '7005xx28': ('SQ', '1', 'Enhanced CT Private Sequence', ''),  # noqa
        '7005xx29': ('UI', '1', 'Frame UID', ''),  # noqa
        '7005xx30': ('CS', '1', 'Main Modality in Study', ''),  # noqa
        '7005xx35': ('DS', '2', 'Scan Range', ''),  # noqa
        '7005xx36': ('OB', '1-n', 'CT Private Data 3', ''),  # noqa
        '7005xx37': ('IS', '1', 'Total Frames', ''),  # noqa
        '7005xx38': ('IS', '1', 'Start Frame', ''),  # noqa
        '7005xx39': ('IS', '1', 'End Frame', ''),  # noqa
        '7005xx40': ('FD', '1', 'DLP Dose Length Product', ''),  # noqa
        '7005xx41': ('SH', '1', 'Raw Slice Information', ''),  # noqa
        '7005xx42': ('US', '1', 'Local Frame No', ''),  # noqa
        '7005xx43': ('DS', '3', 'Volume Vector', ''),  # noqa
        '7005xx44': ('US', '1', 'Volume Type', ''),  # noqa
        '7005xx45': ('DS', '1', 'Relative Table Position of 4D Volume', ''),  # noqa
        '7005xx46': ('DS', '1', 'Absolute Table Position of 4D Volume', ''),  # noqa
        '7005xx47': ('DS', '1', 'Slice Pitch of 4D Volume', ''),  # noqa
        '7005xx48': ('LO', '1', 'Respiratory Gating Inf.', ''),  # noqa
        '7005xx49': ('SH', '1', 'Respiration Phase', ''),  # noqa
        '7005xxf1': ('CS', '1', 'Protect Mark for Image, Curve or Private Record', ''),  # noqa
        '7005xxf2': ('CS', '1', 'Protect Mark for Series Record', ''),  # noqa
        '7005xxf3': ('CS', '1', 'Protect Mark for Study Record', ''),  # noqa
    },
    'TOSHIBA_MEC_CT_1.0': {
        '0019xx01': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx02': ('IS', '1', 'Unknown', ''),  # noqa
        '0019xx03': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx04': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx05': ('LT', '1', 'Unknown', ''),  # noqa
        '0019xx06': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx07': ('US', '1-n', 'Unknown', ''),  # noqa
        '0019xx08': ('LT', '1', 'Orientation Head Feet', ''),  # noqa
        '0019xx09': ('LT', '1', 'View Direction', ''),  # noqa
        '0019xx0a': ('LT', '1', 'Orientation Supine Prone', ''),  # noqa
        '0019xx0b': ('DS', '1', 'Location', ''),  # noqa
        '0019xx0c': ('CS', '1', 'Scan View Direction', ''),  # noqa
        '0019xx0d': ('TM', '1', 'Time', ''),  # noqa
        '0019xx0e': ('DS', '1', 'Unknown', ''),  # noqa
        '7ff1xx01': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx02': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx03': ('IS', '1', 'Unknown', ''),  # noqa
        '7ff1xx04': ('IS', '1', 'Unknown', ''),  # noqa
        '7ff1xx05': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx07': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx08': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx09': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx0a': ('LT', '1', 'Unknown', ''),  # noqa
        '7ff1xx0b': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx0c': ('US', '1-n', 'Unknown', ''),  # noqa
        '7ff1xx0d': ('US', '1-n', 'Unknown', ''),  # noqa
    },
    'TOSHIBA_MEC_MR3': {
        '00290089': ('LO', '1', 'Unknown', ''),  # noqa
        '700dxx00': ('DS', '1', 'Scale Factor', ''),  # noqa
        '700dxx01': ('OB', '1', 'Acquisition Order', ''),  # noqa
        '700dxx02': ('DS', '9', 'Orientation Vector', ''),  # noqa
        '700dxx03': ('SS', '1', 'Flip Flag', ''),  # noqa
        '700dxx04': ('OB', '1', 'Rotate Information', ''),  # noqa
        '700dxx05': ('DS', '1', 'FOV', ''),  # noqa
        '700dxx06': ('US', '4', 'Image Matrix', ''),  # noqa
        '700dxx07': ('OB', '1', 'Image Information', ''),  # noqa
        '700dxx08': ('OB', '1', 'Original Data', ''),  # noqa
        '700dxx09': ('SS', '1', 'Original Data Flag', ''),  # noqa
        '700dxx0c': ('CS', '1', 'Receiver Gain Correction Check Flag', ''),  # noqa
        '700dxx20': ('SH', '1', 'Identification Flag of 3D GDC', ''),  # noqa
        '700dxx80': ('US', '1', 'Number of PAC channel', ''),  # noqa
        '700dxx81': ('US', '1', 'Reference mode', ''),  # noqa
        '700dxx82': ('SQ', '1', 'Gain value group for MRS', ''),  # noqa
        '700dxx83': ('FL', '1', 'Gain value of each channel for MRS', ''),  # noqa
        '700dxx84': ('FL', '1', 'Phase value of each channel for MRS', ''),  # noqa
        '700dxx85': ('FL', '1', 'Reference gain value of each channel for MRS', ''),  # noqa
        '700dxx86': ('FL', '1', 'Reference gain value of each channel for MRS', ''),  # noqa
        '700dxx87': ('FL', '1', 'Receiver gain of reference scan', ''),  # noqa
        '700dxx88': ('UL', '1', 'Flag of water Sat pulse', ''),  # noqa
        '700dxx89': ('FL', '1', 'Selected contrast TE', ''),  # noqa
        '700dxx8a': ('SQ', '1', 'Raw Data Set Sequence', ''),  # noqa
        '700dxx8b': ('DS', '1', 'Multi Slice number', ''),  # noqa
        '700dxx8c': ('DS', '1', 'Multi Coverage number', ''),  # noqa
        '700dxx8d': ('SQ', '1', 'Raw Data Sequence', ''),  # noqa
        '700dxx8e': ('DS', '1', 'Coil Channel No.', ''),  # noqa
        '700dxx8f': ('OB', '1', 'MRS Raw Data', ''),  # noqa
        '700dxx90': ('OF', '1', 'MRS Ref Raw Data', ''),  # noqa
        '700dxx91': ('FL', '1', 'Receiver gain of prescan', ''),  # noqa
    },
    'TOSHIBA_MEC_MR3^10': {
        '00090002': ('SH', '1', 'Unknown', ''),  # noqa
        '00110003': ('US', '1', 'Unknown', ''),  # noqa
        '00110004': ('SQ', '1', 'Unknown', ''),  # noqa
        '00110005': ('US', '1', 'Unknown', ''),  # noqa
        '00110006': ('US', '1', 'Unknown', ''),  # noqa
        '00110007': ('US', '1-n', 'Unknown', ''),  # noqa
        '00110008': ('SH', '1', 'Unknown', ''),  # noqa
        '0011000c': ('SS', '1', 'Unknown', ''),  # noqa
        '00190001': ('UL', '1', 'Unknown', ''),  # noqa
        '00190002': ('SL', '1', 'Unknown', ''),  # noqa
        '00190003': ('US', '1', 'Unknown', ''),  # noqa
        '00190004': ('SL', '1', 'Unknown', ''),  # noqa
        '00190005': ('FL', '1', 'Unknown', ''),  # noqa
        '00190006': ('SL', '1', 'Unknown', ''),  # noqa
        '00190007': ('FL', '3', 'Unknown', ''),  # noqa
        '00190008': ('US', '1', 'Unknown', ''),  # noqa
        '00190009': ('FL', '1', 'Unknown', ''),  # noqa
        '0019000a': ('FL', '1', 'Unknown', ''),  # noqa
        '0019000b': ('FL', '1', 'Unknown', ''),  # noqa
        '0019000c': ('US', '3', 'Unknown', ''),  # noqa
        '0019000d': ('SL', '6', 'Unknown', ''),  # noqa
        '0019000e': ('SL', '6', 'Unknown', ''),  # noqa
        '0019000f': ('SL', '6', 'Unknown', ''),  # noqa
        '00190010': ('US', '2', 'Unknown', ''),  # noqa
        '00190011': ('SL', '2', 'Unknown', ''),  # noqa
        '00190012': ('US', '1', 'Unknown', ''),  # noqa
        '00190013': ('SL', '1', 'Unknown', ''),  # noqa
        '00190014': ('US', '1', 'Unknown', ''),  # noqa
        '00190015': ('SL', '1', 'Unknown', ''),  # noqa
        '00190016': ('FL', '1', 'Unknown', ''),  # noqa
        '00190017': ('SL', '1', 'Unknown', ''),  # noqa
        '00190018': ('US', '1', 'Unknown', ''),  # noqa
        '00190019': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001a': ('US', '1', 'Unknown', ''),  # noqa
        '0019001b': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019001e': ('US', '1', 'Unknown', ''),  # noqa
        '00190027': ('SL', '1', 'Unknown', ''),  # noqa
        '00190028': ('SL', '1', 'Unknown', ''),  # noqa
        '00190029': ('SH', '1', 'Unknown', ''),  # noqa
        '0019002b': ('SH', '1', 'Unknown', ''),  # noqa
        '0019002c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019002d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019002e': ('US', '1', 'Unknown', ''),  # noqa
        '0019002f': ('FL', '1', 'Unknown', ''),  # noqa
        '00190030': ('UL', '1', 'Unknown', ''),  # noqa
        '00190031': ('OF', '1-n', 'Unknown', ''),  # noqa
        '00190032': ('FL', '1', 'Unknown', ''),  # noqa
        '00190033': ('SL', '3', 'Unknown', ''),  # noqa
        '00190034': ('SL', '1', 'Unknown', ''),  # noqa
        '00190035': ('SL', '1', 'Unknown', ''),  # noqa
        '00190036': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190038': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003b': ('SL', '2', 'Unknown', ''),  # noqa
        '0019003c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019003f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190042': ('US', '1', 'Unknown', ''),  # noqa
        '00190043': ('US', '1', 'Unknown', ''),  # noqa
        '00190044': ('SL', '1', 'Unknown', ''),  # noqa
        '00190045': ('SS', '1', 'Unknown', ''),  # noqa
        '00190046': ('US', '1', 'Unknown', ''),  # noqa
        '00190047': ('FL', '1', 'Unknown', ''),  # noqa
        '00190048': ('US', '1', 'Unknown', ''),  # noqa
        '00190049': ('US', '1', 'Unknown', ''),  # noqa
        '0019004b': ('US', '1', 'Unknown', ''),  # noqa
        '0019004c': ('US', '1', 'Unknown', ''),  # noqa
        '0019004d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019004e': ('US', '1', 'Unknown', ''),  # noqa
        '0019004f': ('US', '1', 'Unknown', ''),  # noqa
        '00190050': ('SL', '2', 'Unknown', ''),  # noqa
        '00190051': ('SL', '2', 'Unknown', ''),  # noqa
        '00190052': ('LO', '1', 'Unknown', ''),  # noqa
        '00190054': ('US', '1', 'Unknown', ''),  # noqa
        '00190055': ('US', '1', 'Unknown', ''),  # noqa
        '00190057': ('FL', '3', 'Unknown', ''),  # noqa
        '00190058': ('FL', '3', 'Unknown', ''),  # noqa
        '00190059': ('SL', '1', 'Unknown', ''),  # noqa
        '0019005a': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0019005d': ('FL', '1-n', 'Unknown', ''),  # noqa
        '0019005e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019005f': ('FL', '1', 'Unknown', ''),  # noqa
        '00190060': ('US', '1', 'Unknown', ''),  # noqa
        '00190061': ('US', '1', 'Unknown', ''),  # noqa
        '00190062': ('US', '1', 'Unknown', ''),  # noqa
        '00190063': ('FL', '1', 'Unknown', ''),  # noqa
        '00190064': ('FL', '1', 'Unknown', ''),  # noqa
        '00190065': ('SL', '2', 'Unknown', ''),  # noqa
        '00190069': ('FL', '1', 'Unknown', ''),  # noqa
        '0019006a': ('US', '1', 'Unknown', ''),  # noqa
        '0019006b': ('SL', '1', 'Unknown', ''),  # noqa
        '0019006d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019006e': ('FL', '1', 'Unknown', ''),  # noqa
        '0019006f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190070': ('LO', '1', 'Unknown', ''),  # noqa
        '00190071': ('LO', '1', 'Unknown', ''),  # noqa
        '00190073': ('LO', '1', 'Unknown', ''),  # noqa
        '00190075': ('LO', '1', 'Unknown', ''),  # noqa
        '00190076': ('LO', '1', 'Unknown', ''),  # noqa
        '00190078': ('LO', '1', 'Unknown', ''),  # noqa
        '0019007b': ('LO', '1', 'Unknown', ''),  # noqa
        '0019007c': ('FL', '1', 'Unknown', ''),  # noqa
        '0019007d': ('FL', '1', 'Unknown', ''),  # noqa
        '0019007e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190085': ('FL', '1', 'Unknown', ''),  # noqa
        '00190086': ('SL', '1', 'Unknown', ''),  # noqa
        '00190087': ('FL', '1', 'Unknown', ''),  # noqa
        '00190088': ('LO', '1', 'Unknown', ''),  # noqa
        '0019008a': ('SL', '1-n', 'Unknown', ''),  # noqa
        '0019008c': ('UL', '1', 'Unknown', ''),  # noqa
        '0019008e': ('SL', '1', 'Unknown', ''),  # noqa
        '00190092': ('SL', '1', 'Unknown', ''),  # noqa
        '00190093': ('FL', '3', 'Unknown', ''),  # noqa
        '00190096': ('US', '1', 'Unknown', ''),  # noqa
        '0019009b': ('FL', '3', 'Unknown', ''),  # noqa
        '0019009c': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a0': ('SL', '4', 'Unknown', ''),  # noqa
        '001900a1': ('DS', '1', 'Unknown', ''),  # noqa
        '001900a2': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a3': ('SL', '3', 'Unknown', ''),  # noqa
        '001900a4': ('FL', '3', 'Unknown', ''),  # noqa
        '001900a5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a8': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ab': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ac': ('US', '1', 'Unknown', ''),  # noqa
        '001900ad': ('FL', '1', 'Unknown', ''),  # noqa
        '001900ae': ('FL', '1', 'Unknown', ''),  # noqa
        '001900af': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b0': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b7': ('FL', '2', 'Unknown', ''),  # noqa
        '001900ba': ('FL', '1', 'Unknown', ''),  # noqa
        '001900bb': ('FL', '1', 'Unknown', ''),  # noqa
        '001900bc': ('FL', '2', 'Unknown', ''),  # noqa
        '001900bd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900be': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c6': ('FL', '2', 'Unknown', ''),  # noqa
        '001900c9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ca': ('LO', '1', 'Unknown', ''),  # noqa
        '001900cb': ('UL', '1', 'Unknown', ''),  # noqa
        '001900cc': ('UL', '1', 'Unknown', ''),  # noqa
        '001900cd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ce': ('SL', '1', 'Unknown', ''),  # noqa
        '001900cf': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d0': ('US', '1', 'Unknown', ''),  # noqa
        '001900d1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d2': ('SL', '3', 'Unknown', ''),  # noqa
        '001900d3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900d8': ('US', '1', 'Unknown', ''),  # noqa
        '001900d9': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900da': ('US', '1', 'Unknown', ''),  # noqa
        '001900db': ('SL', '1', 'Unknown', ''),  # noqa
        '001900dc': ('SL', '1', 'Unknown', ''),  # noqa
        '001900e1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900e4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900e5': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900e6': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900e9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ea': ('UI', '1', 'Unknown', ''),  # noqa
        '001900eb': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ec': ('US', '1', 'Unknown', ''),  # noqa
        '001900ee': ('FL', '1', 'Unknown', ''),  # noqa
        '001900ef': ('FL', '1', 'Unknown', ''),  # noqa
        '001900f0': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f1': ('FL', '1', 'Unknown', ''),  # noqa
        '001900f2': ('FL', '1', 'Unknown', ''),  # noqa
        '001900f3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f4': ('FD', '1', 'Unknown', ''),  # noqa
        '001900f5': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f6': ('UI', '1', 'Unknown', ''),  # noqa
        '001900f8': ('US', '1', 'Unknown', ''),  # noqa
        '001900f9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fa': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fb': ('UL', '1', 'Unknown', ''),  # noqa
        '001900fc': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fd': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fe': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ff': ('SL', '3', 'Unknown', ''),  # noqa
        '00210002': ('SL', '1', 'Unknown', ''),  # noqa
        '00210003': ('SL', '1', 'Unknown', ''),  # noqa
        '00210004': ('US', '1', 'Unknown', ''),  # noqa
        '00210008': ('DS', '3', 'Unknown', ''),  # noqa
        '00210009': ('DS', '3', 'Unknown', ''),  # noqa
        '0021000a': ('DS', '3', 'Unknown', ''),  # noqa
        '0021000b': ('US', '1', 'Unknown', ''),  # noqa
        '0021000c': ('US', '1', 'Unknown', ''),  # noqa
        '0021000d': ('FL', '1', 'Unknown', ''),  # noqa
        '0021000f': ('US', '1', 'Unknown', ''),  # noqa
        '00210012': ('DS', '3', 'Unknown', ''),  # noqa
        '00210014': ('SQ', '1', 'Unknown', ''),  # noqa
        '00210015': ('FL', '1', 'Unknown', ''),  # noqa
        '00210016': ('FL', '2', 'Unknown', ''),  # noqa
        '00210018': ('US', '1', 'Unknown', ''),  # noqa
        '0021001d': ('IS', '1', 'Unknown', ''),  # noqa
        '0021001f': ('US', '1', 'Unknown', ''),  # noqa
        '00210022': ('US', '1', 'Unknown', ''),  # noqa
        '00290001': ('SL', '1', 'Unknown', ''),  # noqa
        '00290005': ('SQ', '1', 'Unknown', ''),  # noqa
        '00290006': ('FL', '1', 'Unknown', ''),  # noqa
        '00290007': ('FL', '1', 'Unknown', ''),  # noqa
        '0029001c': ('FL', '2', 'Unknown', ''),  # noqa
        '00290021': ('SL', '3', 'Unknown', ''),  # noqa
        '0029004e': ('SL', '1', 'Unknown', ''),  # noqa
        '00290050': ('LO', '1', 'Unknown', ''),  # noqa
        '00290051': ('LO', '1', 'Unknown', ''),  # noqa
        '00290052': ('LO', '1', 'Unknown', ''),  # noqa
        '00290054': ('LO', '1', 'Unknown', ''),  # noqa
        '00290067': ('FD', '4', 'Unknown', ''),  # noqa
        '00290068': ('SS', '1', 'Unknown', ''),  # noqa
        '0029006e': ('OB', '1', 'Unknown', ''),  # noqa
        '700d0010': ('DS', '1', '2nd Flip Angle [degree]', ''),  # noqa
        '700d0011': ('US', '2', 'Acquisition Inner Matrix', ''),  # noqa
        '700d0012': ('US', '1', 'MP2RAGE Flag', ''),  # noqa
        '700d0013': ('FL', '1', 'Inversion efficiency of inversion recovery pulse', ''),  # noqa
        '700d0014': ('SL', '1', 'Number of dummy shot', ''),  # noqa
        '700d0015': ('FL', '1', 'FFE total repetition time[s]', ''),  # noqa
        '700d0016': ('LO', '3', 'PAS Name', ''),  # noqa
        '700d0017': ('LT', '1', 'Intended Processing', ''),  # noqa
        '700d0018': ('SS', '1-n', 'Scanned Orientation IDs', ''),  # noqa
        '700d0019': ('OB', '1', 'PAS Reproduct Information', ''),  # noqa
        '700d0080': ('US', '1', 'Unknown', ''),  # noqa
        'e2010002': ('US', '1', 'Unknown', ''),  # noqa
        'e3010000': ('SH', '1', 'Unknown', ''),  # noqa
        'e4010000': ('US', '1', 'Unknown', ''),  # noqa
        'e4010001': ('US', '1', 'Unknown', ''),  # noqa
        'e4010002': ('US', '1', 'Unknown', ''),  # noqa
        'e4010003': ('US', '1', 'Unknown', ''),  # noqa
        'e4010004': ('US', '1', 'Unknown', ''),  # noqa
        'e4010005': ('OB', '1', 'Unknown', ''),  # noqa
        'e4010008': ('FL', '1', 'Unknown', ''),  # noqa
        'e4010012': ('FL', '1', 'Unknown', ''),  # noqa
        'e4010013': ('OB', '1', 'Unknown', ''),  # noqa
        'e4010020': ('SQ', '1', 'Unknown', ''),  # noqa
        'e4010021': ('SQ', '1', 'Unknown', ''),  # noqa
        'e4010022': ('LO', '1', 'Unknown', ''),  # noqa
        'e4010023': ('SH', '1', 'Unknown', ''),  # noqa
        'e4010024': ('OB', '1', 'Unknown', ''),  # noqa
        'e4030000': ('SQ', '1', 'Unknown', ''),  # noqa
        'ee010000': ('US', '1', 'Unknown', ''),  # noqa
        'ee010001': ('OB', '1', 'Unknown', ''),  # noqa
        'ee010002': ('US', '1', 'Unknown', ''),  # noqa
    },
    'TOSHIBA_MEC_MR3^11': {
        '00190002': ('SL', '1', 'Unknown', ''),  # noqa
        '00190003': ('SL', '1', 'Unknown', ''),  # noqa
        '00190004': ('SL', '1', 'Unknown', ''),  # noqa
        '00190008': ('SH', '1', 'Unknown', ''),  # noqa
        '00190009': ('SL', '2', 'Unknown', ''),  # noqa
        '0019000a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000b': ('OB', '1', 'Unknown', ''),  # noqa
        '0019000c': ('SL', '1', 'Unknown', ''),  # noqa
        '00190019': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190024': ('SL', '1', 'Unknown', ''),  # noqa
        '00190025': ('SL', '1', 'Unknown', ''),  # noqa
        '00190026': ('SL', '1', 'Unknown', ''),  # noqa
        '00190028': ('SL', '1', 'Unknown', ''),  # noqa
        '00190029': ('SL', '1', 'Unknown', ''),  # noqa
        '0019002a': ('FL', '1', 'Unknown', ''),  # noqa
        '0019002b': ('FL', '1', 'Unknown', ''),  # noqa
        '0019002c': ('SL', '3', 'Unknown', ''),  # noqa
        '0019002d': ('SL', '3', 'Unknown', ''),  # noqa
        '0019002e': ('SL', '1', 'Unknown', ''),  # noqa
        '00190030': ('SL', '1', 'Unknown', ''),  # noqa
        '00190031': ('SL', '1', 'Unknown', ''),  # noqa
        '00190032': ('SL', '1', 'Unknown', ''),  # noqa
        '00190034': ('FL', '1', 'Unknown', ''),  # noqa
        '00190035': ('SL', '1', 'Unknown', ''),  # noqa
        '00190036': ('FL', '1', 'Unknown', ''),  # noqa
        '00190037': ('SL', '1', 'Unknown', ''),  # noqa
        '00190038': ('SL', '1', 'Unknown', ''),  # noqa
        '00190039': ('FL', '1', 'Unknown', ''),  # noqa
        '0019003a': ('FL', '1', 'Unknown', ''),  # noqa
        '0019003c': ('FL', '3', 'Unknown', ''),  # noqa
        '0019003e': ('FL', '9', 'Unknown', ''),  # noqa
        '0019003f': ('UI', '1', 'Unknown', ''),  # noqa
        '00190040': ('US', '1', 'Unknown', ''),  # noqa
        '00190041': ('US', '1', 'Unknown', ''),  # noqa
        '00190042': ('SL', '1', 'Unknown', ''),  # noqa
        '00190043': ('SL', '1', 'Unknown', ''),  # noqa
        '00190044': ('SL', '1', 'Unknown', ''),  # noqa
        '00190046': ('FL', '1', 'Unknown', ''),  # noqa
        '00190048': ('LT', '1', 'Unknown', ''),  # noqa
        '00190049': ('LT', '1', 'Unknown', ''),  # noqa
        '0019004c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019004e': ('SL', '1', 'Unknown', ''),  # noqa
        '00190055': ('LO', '1', 'Unknown', ''),  # noqa
        '00190057': ('FL', '1', 'Unknown', ''),  # noqa
        '00190058': ('US', '1', 'Unknown', ''),  # noqa
        '00190059': ('US', '1', 'Unknown', ''),  # noqa
        '0019005c': ('SL', '1', 'Unknown', ''),  # noqa
        '0019005d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019005f': ('FL', '1', 'Unknown', ''),  # noqa
        '00190060': ('SL', '1', 'Unknown', ''),  # noqa
        '00190061': ('FL', '1', 'Unknown', ''),  # noqa
        '00190062': ('FL', '1', 'Unknown', ''),  # noqa
        '00190063': ('SL', '1', 'Unknown', ''),  # noqa
        '00190067': ('FL', '1', 'Unknown', ''),  # noqa
        '00190068': ('SL', '1', 'Unknown', ''),  # noqa
        '0019006c': ('FL', '1', 'Unknown', ''),  # noqa
        '0019006d': ('SH', '1', 'Unknown', ''),  # noqa
        '0019006e': ('SH', '1', 'Unknown', ''),  # noqa
        '0019006f': ('FL', '1', 'Unknown', ''),  # noqa
        '00190071': ('SL', '1', 'Unknown', ''),  # noqa
        '00190072': ('FL', '1', 'Unknown', ''),  # noqa
        '00190078': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007a': ('SL', '2', 'Unknown', ''),  # noqa
        '0019007c': ('FL', '3', 'Unknown', ''),  # noqa
        '0019007d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019007f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190080': ('FL', '1', 'Unknown', ''),  # noqa
        '00190084': ('SL', '1', 'Unknown', ''),  # noqa
        '00190087': ('SL', '1', 'Unknown', ''),  # noqa
        '0019008a': ('US', '1', 'Unknown', ''),  # noqa
        '0019008f': ('SL', '1', 'Unknown', ''),  # noqa
        '00190091': ('SL', '1', 'Unknown', ''),  # noqa
        '00190092': ('SL', '1', 'Unknown', ''),  # noqa
        '00190094': ('FL', '1', 'Unknown', ''),  # noqa
        '0019009a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019009b': ('US', '1', 'Unknown', ''),  # noqa
        '0019009c': ('FL', '1', 'Unknown', ''),  # noqa
        '0019009d': ('SL', '1', 'Unknown', ''),  # noqa
        '0019009e': ('SL', '1', 'Unknown', ''),  # noqa
        '0019009f': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a0': ('SL', '1', 'Unknown', ''),  # noqa
        '001900a5': ('US', '1', 'Unknown', ''),  # noqa
        '001900a6': ('US', '1', 'Unknown', ''),  # noqa
        '001900a8': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ad': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ae': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b0': ('FL', '1', 'Unknown', ''),  # noqa
        '001900b1': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b2': ('US', '1', 'Unknown', ''),  # noqa
        '001900b3': ('US', '1', 'Unknown', ''),  # noqa
        '001900b4': ('US', '1', 'Unknown', ''),  # noqa
        '001900b5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900b6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900b7': ('US', '1', 'Unknown', ''),  # noqa
        '001900b9': ('US', '1', 'Unknown', ''),  # noqa
        '001900bb': ('FL', '1', 'Unknown', ''),  # noqa
        '001900bc': ('SL', '1', 'Unknown', ''),  # noqa
        '001900bd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900be': ('FL', '1', 'Unknown', ''),  # noqa
        '001900bf': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c0': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c1': ('US', '1', 'Unknown', ''),  # noqa
        '001900c3': ('FL', '1', 'Unknown', ''),  # noqa
        '001900c4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900cd': ('SL', '3', 'Unknown', ''),  # noqa
        '001900e0': ('FL', '1', 'Unknown', ''),  # noqa
        '001900e1': ('FL', '1', 'Unknown', ''),  # noqa
        '001900e3': ('SL', '3', 'Unknown', ''),  # noqa
        '001900e4': ('DS', '1', 'Unknown', ''),  # noqa
        '001900e5': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900e6': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900f0': ('SL', '4', 'Unknown', ''),  # noqa
        '001900f1': ('SL', '3', 'Unknown', ''),  # noqa
        '001900f2': ('FL', '3', 'Unknown', ''),  # noqa
        '001900f3': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f5': ('SQ', '1', 'Unknown', ''),  # noqa
        '001900f6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f7': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f8': ('SL', '1', 'Unknown', ''),  # noqa
        '001900f9': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fa': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fb': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fc': ('FL', '1', 'Unknown', ''),  # noqa
        '001900fd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fe': ('SL', '1', 'Unknown', ''),  # noqa
        '001900ff': ('SL', '1', 'Unknown', ''),  # noqa
    },
    'TOSHIBA_MEC_MR3^12': {
        '00190000': ('SL', '1', 'Unknown', ''),  # noqa
        '00190001': ('SL', '1', 'Unknown', ''),  # noqa
        '00190002': ('SL', '1', 'Unknown', ''),  # noqa
        '00190003': ('SL', '1', 'Unknown', ''),  # noqa
        '00190004': ('SL', '1', 'Unknown', ''),  # noqa
        '00190005': ('SH', '1', 'Unknown', ''),  # noqa
        '00190006': ('FL', '1', 'Unknown', ''),  # noqa
        '00190007': ('UL', '1-n', 'Unknown', ''),  # noqa
        '00190008': ('UL', '1-n', 'Unknown', ''),  # noqa
        '00190009': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000a': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000b': ('SL', '1', 'Unknown', ''),  # noqa
        '0019000c': ('UL', '1', 'Unknown', ''),  # noqa
        '0019000d': ('SQ', '1', 'Unknown', ''),  # noqa
        '0019000e': ('US', '1', 'Unknown', ''),  # noqa
        '00190010': ('SL', '1', 'Unknown', ''),  # noqa
        '00190011': ('SL', '1', 'Unknown', ''),  # noqa
        '00190012': ('SL', '1', 'Unknown', ''),  # noqa
        '00190013': ('FL', '1', 'Unknown', ''),  # noqa
        '00190014': ('FL', '1', 'Unknown', ''),  # noqa
        '00190018': ('UL', '1', 'Unknown', ''),  # noqa
        '00190028': ('DS', '1', 'Unknown', ''),  # noqa
        '0019002a': ('DS', '3', 'Unknown', ''),  # noqa
        '0019002b': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190032': ('SH', '1', 'Unknown', ''),  # noqa
        '00190034': ('SL', '1', 'Unknown', ''),  # noqa
        '00190052': ('FL', '2', 'Unknown', ''),  # noqa
        '00190076': ('OB', '1', 'Unknown', ''),  # noqa
        '00190079': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190080': ('FD', '1', 'Unknown', ''),  # noqa
        '00190085': ('US', '1', 'Unknown', ''),  # noqa
        '00190086': ('LO', '1', 'Unknown', ''),  # noqa
        '00190087': ('SQ', '1', 'Unknown', ''),  # noqa
        '00190088': ('US', '1', 'Unknown', ''),  # noqa
        '00190089': ('SL', '1', 'Unknown', ''),  # noqa
        '0019008a': ('US', '1', 'Unknown', ''),  # noqa
        '0019008b': ('US', '1', 'Unknown', ''),  # noqa
        '0019008f': ('OB', '1', 'Unknown', ''),  # noqa
        '00190093': ('SL', '1', 'Unknown', ''),  # noqa
        '00190094': ('UI', '1', 'Unknown', ''),  # noqa
        '00190095': ('UI', '1', 'Unknown', ''),  # noqa
        '00190098': ('FL', '3', 'Unknown', ''),  # noqa
        '00190099': ('LO', '1', 'Unknown', ''),  # noqa
        '0019009a': ('DS', '1', 'Unknown', ''),  # noqa
        '0019009c': ('DS', '1', 'Unknown', ''),  # noqa
        '0019009d': ('US', '1', 'Unknown', ''),  # noqa
        '0019009e': ('FL', '3', 'Unknown', ''),  # noqa
        '0019009f': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a0': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a1': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a2': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a3': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a4': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a6': ('FL', '1-n', 'Unknown', ''),  # noqa
        '001900a7': ('FL', '1', 'Unknown', ''),  # noqa
        '001900a8': ('FL', '1', 'Unknown', ''),  # noqa
        '001900aa': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ab': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ac': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ad': ('FL', '3', 'Unknown', ''),  # noqa
        '001900ae': ('FL', '3', 'Unknown', ''),  # noqa
        '001900af': ('FL', '3', 'Unknown', ''),  # noqa
        '001900b3': ('FD', '1', 'Unknown', ''),  # noqa
        '001900b4': ('LO', '1', 'Unknown', ''),  # noqa
        '001900c2': ('US', '1', 'Unknown', ''),  # noqa
        '001900c3': ('FL', '1', 'Unknown', ''),  # noqa
        '001900c4': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c5': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c6': ('SL', '1', 'Unknown', ''),  # noqa
        '001900c7': ('FL', '1', 'Unknown', ''),  # noqa
        '001900cd': ('LO', '1', 'Unknown', ''),  # noqa
        '001900ce': ('UL', '1', 'Unknown', ''),  # noqa
        '001900cf': ('FL', '1', 'Unknown', ''),  # noqa
        '001900d1': ('FL', '3', 'Unknown', ''),  # noqa
        '001900d2': ('US', '3', 'Unknown', ''),  # noqa
        '001900d3': ('SS', '1', 'Unknown', ''),  # noqa
        '001900d4': ('US', '2', 'Unknown', ''),  # noqa
        '001900d5': ('FL', '1', 'Unknown', ''),  # noqa
        '001900d6': ('FL', '3', 'Unknown', ''),  # noqa
        '001900d7': ('US', '2', 'Unknown', ''),  # noqa
        '001900d8': ('FL', '1-n', 'Unknown', ''),  # noqa
        '001900de': ('US', '1', 'Unknown', ''),  # noqa
        '001900df': ('US', '1', 'Unknown', ''),  # noqa
        '001900e0': ('US', '1', 'Unknown', ''),  # noqa
        '001900e1': ('FL', '3', 'Unknown', ''),  # noqa
        '001900e2': ('FL', '3', 'Unknown', ''),  # noqa
        '001900e3': ('TM', '1', 'Unknown', ''),  # noqa
        '001900e4': ('US', '2', 'Unknown', ''),  # noqa
        '001900eb': ('US', '1', 'Unknown', ''),  # noqa
        '001900ec': ('US', '1', 'Unknown', ''),  # noqa
        '001900ef': ('DS', '1', 'Unknown', ''),  # noqa
        '001900f0': ('LO', '1', 'Unknown', ''),  # noqa
        '001900f1': ('LO', '1', 'Unknown', ''),  # noqa
        '001900fd': ('SL', '1', 'Unknown', ''),  # noqa
        '001900fe': ('SL', '1', 'Unknown', ''),  # noqa
    },
    'TOSHIBA_MEC_MR3^13': {
        '00190002': ('US', '1', 'Unknown', ''),  # noqa
        '00190003': ('SL', '1', 'Unknown', ''),  # noqa
        '00190004': ('US', '1', 'Unknown', ''),  # noqa
        '00190005': ('SL', '1', 'Unknown', ''),  # noqa
        '00190008': ('SL', '1', 'Unknown', ''),  # noqa
        '00190009': ('SQ', '1', 'Unknown', ''),  # noqa
        '0019000a': ('FD', '3', 'Unknown', ''),  # noqa
        '0019000b': ('FD', '1', 'Unknown', ''),  # noqa
        '0019000c': ('FD', '1', 'Unknown', ''),  # noqa
        '0019000f': ('SH', '1', 'Unknown', ''),  # noqa
        'e4030000': ('SH', '1', 'Unknown', ''),  # noqa
        'e4030001': ('OB', '1', 'Unknown', ''),  # noqa
        'e4030002': ('OB', '1', 'Unknown', ''),  # noqa
        'e4030003': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'TOSHIBA_MEC_OT3': {
        '0009xx00': ('LO', '1', 'HIS/RIS Study ID', ''),  # noqa
        '7019xx71': ('CS', '1', 'Indicator of creator', ''),  # noqa
        '7019xx72': ('LO', '1', 'ID of quality assurance reviewer', ''),  # noqa
        '7019xx73': ('PN', '1', 'Name of quality assurance reviewer', ''),  # noqa
        '7019xx74': ('DA', '1', 'Date of completion of quality assurance', ''),  # noqa
        '7019xx75': ('TM', '1', 'Time of completion of quality assurance', ''),  # noqa
        '7019xx76': ('LO', '1', 'Host name of quality assurance station', ''),  # noqa
        '7019xx77': ('CS', '1', 'Station name and version of quality assurance station', ''),  # noqa
        '7019xx78': ('CS', '1', 'Flag of completion of quality assurance', ''),  # noqa
        '7019xx79': ('CS', '1', 'Status of quality assurance review', ''),  # noqa
        '7019xx7a': ('UI', '1', 'Original SOP Instance UID', ''),  # noqa
        '7019xx7b': ('UI', '1', 'Original Series Instance UID', ''),  # noqa
        '7019xx7c': ('UI', '1', 'Original Study Instance UID', ''),  # noqa
        '7019xx7d': ('US', '1', 'Rotation information for image display from original image', ''),  # noqa
        '7019xx7e': ('SQ', '1', 'Sequence of LR mark', ''),  # noqa
        '7019xx7f': ('US', '1', 'Rotation status at creation of LR mark', ''),  # noqa
        '7019xx80': ('OB_OW', '1', 'Original image data on area of original LR mark', ''),  # noqa
        '7019xx81': ('SS', '1', 'X start position of LR mark', ''),  # noqa
        '7019xx82': ('SS', '1', 'Y start position of LR mark', ''),  # noqa
        '7019xx83': ('US', '1', 'Size of LR mark in X direction', ''),  # noqa
        '7019xx84': ('US', '1', 'Size of LR mark in Y direction', ''),  # noqa
        '7019xx85': ('LO', '1', 'Previous Patient ID', ''),  # noqa
        '7019xx86': ('CS', '1', 'Previous modality', ''),  # noqa
    },
    'TOSHIBA_MEC_XA3': {
        '7079xx10': ('LO', '1', '', ''),  # noqa
        '7079xx21': ('SH', '5', '', ''),  # noqa
        '7079xx22': ('IS', '2', '', ''),  # noqa
        '7079xx23': ('IS', '2', '', ''),  # noqa
        '7079xx24': ('DS', '1', '', ''),  # noqa
        '7079xx25': ('SH', '1', '', ''),  # noqa
        '7079xx26': ('DS', '2', '', ''),  # noqa
        '7079xx27': ('US', '2', '', ''),  # noqa
        '7079xx28': ('US', '1', '', ''),  # noqa
        '7079xx29': ('US', '10', '', ''),  # noqa
        '7079xx2a': ('US', '5', '', ''),  # noqa
        '7079xx2b': ('UN', '1', '', ''),  # noqa
        '7079xx2c': ('SH', '3', '', ''),  # noqa
        '7079xx2d': ('SS', '2', '', ''),  # noqa
        '7079xx2e': ('SH', '1', '', ''),  # noqa
        '7079xx2f': ('SH', '1', '', ''),  # noqa
        '7079xx30': ('US', '1', '', ''),  # noqa
        '7079xx31': ('US', '1-n', '', ''),  # noqa
        '7079xx32': ('SH', '2', '', ''),  # noqa
        '7079xx33': ('US', '1-n', '', ''),  # noqa
        '7079xx34': ('SH', '1', '', ''),  # noqa
        '7079xx35': ('SH', '1', '', ''),  # noqa
        '7079xx36': ('SH', '1', '', ''),  # noqa
        '7079xx37': ('US', '4', '', ''),  # noqa
        '7079xx38': ('SS', '1-n', '', ''),  # noqa
        '7079xx39': ('SS', '1-n', '', ''),  # noqa
        '7079xx3a': ('US', '2', '', ''),  # noqa
        '7079xx3b': ('SH', '1', '', ''),  # noqa
        '7079xx3c': ('DS', '2', '', ''),  # noqa
        '7079xx3d': ('SS', '2', '', ''),  # noqa
        '7079xx3e': ('SH', '1', '', ''),  # noqa
        '7079xx3f': ('US', '2', '', ''),  # noqa
        '7079xx40': ('SH', '2', '', ''),  # noqa
        '7079xx41': ('SS', '2', '', ''),  # noqa
        '7079xx42': ('SH', '1', '', ''),  # noqa
        '7079xx43': ('SH', '1', '', ''),  # noqa
        '7079xx44': ('US', '1', '', ''),  # noqa
        '7079xx45': ('SH', '1', '', ''),  # noqa
        '7079xx46': ('SS', '1', '', ''),  # noqa
        '7079xx47': ('SS', '18', '', ''),  # noqa
        '7079xx48': ('US', '12', '', ''),  # noqa
        '7079xx49': ('US', '3', '', ''),  # noqa
        '7079xx4a': ('US', '1', '', ''),  # noqa
        '7079xx4b': ('LO', '3', '', ''),  # noqa
        '7079xx4c': ('OB', '1', '', ''),  # noqa
        '7079xx4d': ('LO', '3', '', ''),  # noqa
        '7079xx4e': ('SL', '35', '', ''),  # noqa
        '7079xx4f': ('SH', '3', '', ''),  # noqa
        '7079xx50': ('US', '1-n', '', ''),  # noqa
        '7079xx51': ('US', '1-n', '', ''),  # noqa
        '7079xx52': ('US', '1', '', ''),  # noqa
        '7079xx53': ('SH', '1', '', ''),  # noqa
        '7079xx54': ('US', '5', '', ''),  # noqa
        '7079xx55': ('UL', '47-47n', '', ''),  # noqa
        '7079xx56': ('US', '1', '', ''),  # noqa
        '7079xx57': ('US', '1-n', '', ''),  # noqa
        '7079xx58': ('US', '1', '', ''),  # noqa
        '7079xx59': ('US', '2-2n', '', ''),  # noqa
        '7079xx5a': ('US', '1', '', ''),  # noqa
        '7079xx5b': ('US', '2', '', ''),  # noqa
        '7079xx5c': ('US', '2-2n', '', ''),  # noqa
        '7079xx5d': ('SH', '1', '', ''),  # noqa
        '7079xx5e': ('US', '2', '', ''),  # noqa
        '7079xx5f': ('SS', '4-4n', '', ''),  # noqa
        '7079xx60': ('US', '1-n', '', ''),  # noqa
        '7079xx61': ('SS', '30-30n', '', ''),  # noqa
        '7079xx62': ('US', '4', '', ''),  # noqa
        '7079xx63': ('US', '1-n', '', ''),  # noqa
        '7079xx64': ('US', '1-n', '', ''),  # noqa
        '7079xx65': ('US', '1-n', '', ''),  # noqa
        '7079xx66': ('US', '1-n', '', ''),  # noqa
        '7079xx67': ('US', '1-n', '', ''),  # noqa
        '7079xx68': ('US', '1-n', '', ''),  # noqa
        '7079xx69': ('US', '1-n', '', ''),  # noqa
        '7079xx6a': ('US', '1-n', '', ''),  # noqa
        '7079xx6b': ('US', '1-n', '', ''),  # noqa
        '7079xx6c': ('US', '1', '', ''),  # noqa
        '7079xx6d': ('DS', '1', '', ''),  # noqa
        '7079xx6e': ('LO', '1', '', ''),  # noqa
        '7079xx6f': ('DS', '1', '', ''),  # noqa
        '7079xx70': ('DS', '1', '', ''),  # noqa
        '7079xx71': ('DS', '1-n', '', ''),  # noqa
        '7079xx72': ('DS', '1-n', '', ''),  # noqa
        '7079xx73': ('SL', '4', '', ''),  # noqa
        '7079xx74': ('SL', '28', '', ''),  # noqa
        '7079xx75': ('SH', '1', '', ''),  # noqa
        '7079xx76': ('US', '1', '', ''),  # noqa
        '7079xx77': ('SL', '1', '', ''),  # noqa
        '7079xx78': ('US', '1', '', ''),  # noqa
        '7079xx79': ('US', '1', '', ''),  # noqa
        '7079xx7b': ('SH', '1', 'Unknown', ''),  # noqa
        '7079xx80': ('LO', '1', '', ''),  # noqa
        '7079xx81': ('SS', '1-n', '', ''),  # noqa
        '7079xx82': ('SS', '1-n', '', ''),  # noqa
    },
    'TOSHIBA_SR': {
        '7015xx10': ('OB', '1', 'Unknown', ''),  # noqa
        '7015xx60': ('OB', '1', 'Unknown', ''),  # noqa
    },
    'V1': {
        '0011xx01': ('OB', '1', 'User Data', ''),  # noqa
        '0011xx02': ('DS', '1', 'Normalization Coefficient', ''),  # noqa
        '0011xx03': ('DS', '1-n', 'Receiving Gain', ''),  # noqa
        '0011xx04': ('DS', '1', 'Mean Image Noise', ''),  # noqa
    },
    'VEPRO BROKER 1.0': {
        '0057xx10': ('SQ', '1', 'VEPRO Data replace sequence', ''),  # noqa
    },
    'VEPRO BROKER 1.0 DATA REPLACE': {
        '0057xx20': ('SQ', '1', 'Original data sequence', ''),  # noqa
        '0057xx30': ('SQ', '1', 'Replaced data sequence', ''),  # noqa
        '0057xx40': ('DA', '1', 'Date of data replacement', ''),  # noqa
        '0057xx41': ('TM', '1', 'Time of data replacement', ''),  # noqa
        '0057xx42': ('LO', '1', 'Dicom receive node', ''),  # noqa
        '0057xx43': ('LO', '1', 'Application name', ''),  # noqa
        '0057xx44': ('LO', '1', 'Computer name', ''),  # noqa
    },
    'VEPRO DICOM RECEIVE DATA 1.0': {
        '0059xx40': ('DA', '1', 'Receive date', ''),  # noqa
        '0059xx41': ('TM', '1', 'Receive time', ''),  # noqa
        '0059xx42': ('ST', '1', 'Receive node', ''),  # noqa
        '0059xx43': ('ST', '1', 'Receive application', ''),  # noqa
        '0059xx50': ('ST', '1', 'Receive local computer', ''),  # noqa
        '0059xx51': ('ST', '1', 'Receive local ae title', ''),  # noqa
        '0059xx60': ('ST', '1', 'Receive remote computer', ''),  # noqa
        '0059xx61': ('ST', '1', 'Receive remote ae title', ''),  # noqa
        '0059xx70': ('UI', '1', 'Receive original transfer syntax', ''),  # noqa
    },
    'VEPRO DICOM TRANSFER 1.0': {
        '0059xx10': ('SQ', '1', 'Dicom Transfer Info', ''),  # noqa
    },
    'VEPRO VIF 3.0 DATA': {
        '0055xx30': ('OB', '1', 'Icon data', ''),  # noqa
        '0055xx65': ('OB', '1', 'Image hash value', ''),  # noqa
    },
    'VEPRO VIM 5.0 DATA': {
        '0055xx10': ('OB', '1', 'VIFHEADER2', ''),  # noqa
        '0055xx20': ('OB', '1', 'VIMDATA2', ''),  # noqa
        '0055xx30': ('OB', '1', 'ICONDATA2', ''),  # noqa
        '0055xx51': ('UI', '1', 'VEPRO UID ??', ''),  # noqa
        '0055xx65': ('OB', '1', '??', ''),  # noqa
    },
    'Varian Medical Systems VISION 3253': {
        '3253xx00': ('UN', '1', 'XML stream.', ''),  # noqa
        '3253xx01': ('UN', '1', 'Data length of the XML stream', ''),  # noqa
        '3253xx02': ('UN', '1', 'Extended Interface Format tag', ''),  # noqa
    },
    'Viewing Protocol': {
        '0065xx93': ('CS', '1', 'Unknown', ''),  # noqa
    },
    'Vital Images SW 3.4': {
        '5653xx10': ('OB', '1', 'Saved Workflow', ''),  # noqa
        '5653xx11': ('LO', '1', 'Saved Workflow File Name', ''),  # noqa
        '5653xx12': ('OB', '1', 'Saved Workflow File Data', ''),  # noqa
        '5653xx13': ('SL', '1', 'Saved Workflow File Length', ''),  # noqa
        '5653xx14': ('SQ', '1', 'Saved Workflow File Sequence', ''),  # noqa
        '5653xx15': ('SQ', '1', 'Image Sequence', ''),  # noqa
        '5653xx16': ('SL', '1', 'Volume Interpolated Slices', ''),  # noqa
        '5653xx17': ('UI', '1', 'Volume SOP Instance UID', ''),  # noqa
        '5653xx18': ('SH', '1', 'Saved Workflow Mark', ''),  # noqa
        '5653xx19': ('UI', '1', 'Unknown', ''),  # noqa
        '5653xx22': ('UI', '1', 'Unknown', ''),  # noqa
        '5653xx23': ('LO', '1', 'Unknown', ''),  # noqa
    },
    'Voxar 2.16.124.113543.6003.1999.12.20.12.5.0': {
        '1135xx00': ('UI', '1', 'Private Voxar Capture UID', ''),  # noqa
        '1135xx01': ('OB', '1', 'Private Voxar Saved State', ''),  # noqa
        '1135xx02': ('SQ', '1', 'Private Voxar Icon Image Sequence', ''),  # noqa
        '1135xx03': ('ST', '1', 'Private Voxar Top Right Display Demographics', ''),  # noqa
        '1135xx04': ('ST', '1', 'Private Voxar Bottom Left Display Demographics', ''),  # noqa
        '1135xx05': ('IS', '1', 'Private Voxar Span State Schema', ''),  # noqa
        '1135xx06': ('UL', '1', 'Private Voxar Live Image Restored Size', ''),  # noqa
        '1135xx07': ('UI', '1', 'Private Voxar CaptureType', ''),  # noqa
        '1135xx08': ('SQ', '1', 'Private Voxar Capture Source Series UID Sequence', ''),  # noqa
        '1135xx09': ('UI', '1', 'Private Voxar Capture Source Series UID', ''),  # noqa
        '1135xx10': ('IS', '1', 'Private Voxar Background Gray For Capture', ''),  # noqa
        '1135xx11': ('IS', '1', 'Private Voxar Calcium Scoring Report Schema', ''),  # noqa
        '1135xx12': ('IS', '1', 'Private Voxar Source Series Number', ''),  # noqa
        '1135xx13': ('LO', '1', 'Private Voxar Bottom Left Display Demographics', ''),  # noqa
    },
    'WG12 Supplement 43': {
        '0009xx01': ('SQ', '1', 'Event Timer Sequence', ''),  # noqa
        '0009xx02': ('FD', '1', 'Event Time Interval', ''),  # noqa
        '0009xx03': ('SQ', '1', 'Event Code Sequence', ''),  # noqa
        '0019xx01': ('FD', '1', 'Focus Depth(s)', ''),  # noqa
        '0019xx03': ('SQ', '1', 'Excluded Intervals Sequence', ''),  # noqa
        '0019xx04': ('DT', '1', 'Exclusion Start Datetime', ''),  # noqa
        '0019xx05': ('FD', '1', 'Exclusion Duration', ''),  # noqa
        '0019xx06': ('SQ', '1', 'US Image Description Sequence', ''),  # noqa
        '0019xx07': ('SQ', '1', 'Image Data Type Sequence', ''),  # noqa
        '0019xx08': ('CS', '1', 'Data Type', ''),  # noqa
        '0019xx09': ('SQ', '1', 'Transducer Scan Geometry Code Sequence', ''),  # noqa
        '0019xx0b': ('CS', '1', 'Aliased Data Type', ''),  # noqa
        '0019xx0c': ('CS', '1', 'Position Measuring Device Used', ''),  # noqa
        '0019xx0d': ('SQ', '1', 'Transducer Scanning Configuration Code Sequence', ''),  # noqa
        '0019xx0e': ('SQ', '1', 'Transducer Beam Steering Code Sequence', ''),  # noqa
        '0019xx0f': ('SQ', '1', 'Transducer Access Code Sequence', ''),  # noqa
        '0021xx01': ('FD', '1', 'Image Position (Volume)', ''),  # noqa
        '0021xx02': ('FD', '1', 'Image Orientation (Volume)', ''),  # noqa
        '0021xx07': ('CS', '1', 'Ultrasound Acquisition Geometry', ''),  # noqa
        '0021xx08': ('FD', '1', 'Apex Position', ''),  # noqa
        '0021xx09': ('FD', '1', 'Volume to Transducer Mapping Matrix', ''),  # noqa
        '0021xx0a': ('FD', '1', 'Volume to Table Mapping Matrix', ''),  # noqa
        '0021xx0c': ('CS', '1', 'Patient Frame of Reference Source', ''),  # noqa
        '0021xx0d': ('FD', '1', 'Temporal Position Time Offset', ''),  # noqa
        '0021xx0e': ('SQ', '1', 'Plane Position (Volume) Sequence', ''),  # noqa
        '0021xx0f': ('SQ', '1', 'Plane Orientation (Volume) Sequence', ''),  # noqa
        '0021xx10': ('SQ', '1', 'Temporal Position Sequence', ''),  # noqa
        '0021xx11': ('CS', '1', 'Dimension Organization Type', ''),  # noqa
        '0029xx01': ('SQ', '1', 'Data Frame Assignment Sequence', ''),  # noqa
        '0029xx02': ('CS', '1', 'Data Path Assignment', ''),  # noqa
        '0029xx03': ('US', '1', 'Bits Mapped to Color Lookup Table', ''),  # noqa
        '0029xx04': ('SQ', '1', 'Opacity 1 LUT Sequence', ''),  # noqa
        '0029xx05': ('CS', '1', 'Opacity 1 LUT Transfer Function', ''),  # noqa
        '0029xx06': ('FD', '1', 'Opacity Constant', ''),  # noqa
        '0029xx07': ('US', '1', 'Opacity Lookup Table Descriptor', ''),  # noqa
        '0029xx08': ('OW', '1', 'Opacity Lookup Table Data', ''),  # noqa
        '0029xx0b': ('SQ', '1', 'Enhanced Palette Color Lookup Table Sequence', ''),  # noqa
        '0029xx0c': ('SQ', '1', 'Opacity 2 LUT Sequence', ''),  # noqa
        '0029xx0d': ('CS', '1', 'Opacity 2 LUT Transfer Function', ''),  # noqa
        '0029xx0e': ('CS', '1', 'Data Path ID', ''),  # noqa
        '0029xx0f': ('CS', '1', 'RGB LUT Transfer Function', ''),  # noqa
        '0029xx10': ('CS', '1', 'Alpha LUT Transfer Function', ''),  # noqa
        '0041xx01': ('CS', '1', 'Performed Protocol Type', ''),  # noqa
    },
    'http://www.gemedicalsystems.com/it_solutions/bamwallthickness/1.0': {
        '3119xx10': ('DT', '1', 'BAM WallThickness Session Date/Time', ''),  # noqa
        '3119xx20': ('PN', '1', 'BAM WallThickness Session Creator', ''),  # noqa
        '3119xx30': ('CS', '1', 'BAM WallThickness Session Completion Flag', ''),  # noqa
        '3119xx40': ('SQ', '1', 'BAM WallThickness File Sequence', ''),  # noqa
        '3119xx50': ('ST', '1', 'BAM WallThickness File Name', ''),  # noqa
        '3119xx60': ('OB', '1', 'BAM WallThickness File Content', ''),  # noqa
    },
    'http://www.gemedicalsystems.com/it_solutions/orthoview/2.1': {
        '3117xx10': ('DT', '1', 'OrthoView Session Date/Time', ''),  # noqa
        '3117xx20': ('PN', '1', 'OrthoView Session Creator', ''),  # noqa
        '3117xx30': ('CS', '1', 'OrthoView Session Completion Flag', ''),  # noqa
        '3117xx40': ('SQ', '1', 'OrthoView File Sequence', ''),  # noqa
        '3117xx50': ('ST', '1', 'OrthoView File Name', ''),  # noqa
        '3117xx60': ('OB', '1', 'OrthoView File Content', ''),  # noqa
    },
    'http://www.gemedicalsystems.com/it_solutions/rad_pacs/': {
        '3115xx01': ('UT', '1', 'Reference to pacs study', ''),  # noqa
        '3115xx02': ('UT', '1', 'Reference to pacs image', ''),  # noqa
        '3115xx03': ('CS', '1', 'Pacs examnotes flag', ''),  # noqa
    },
    'syngoDynamics': {
        '0021xxae': ('OB', '1', 'Unknown', ''),  # noqa
    },
}
