/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Adler32;
import java.util.zip.DeflaterConstants;
import java.util.zip.DeflaterHuffman;
import java.util.zip.DeflaterPending;

class DeflaterEngine
implements DeflaterConstants {
    private static final int TOO_FAR = 4096;
    private int ins_h;
    private short[] head;
    private short[] prev;
    private int matchStart;
    private int matchLen;
    private boolean prevAvailable;
    private int blockStart;
    private int strstart;
    private int lookahead;
    private byte[] window;
    private int strategy;
    private int max_chain;
    private int max_lazy;
    private int niceLength;
    private int goodLength;
    private int comprFunc;
    private byte[] inputBuf;
    private int totalIn;
    private int inputOff;
    private int inputEnd;
    private DeflaterPending pending;
    private DeflaterHuffman huffman;
    private Adler32 adler;

    public void reset() {
        this.huffman.reset();
        this.adler.reset();
        this.strstart = 1;
        this.blockStart = 1;
        this.lookahead = 0;
        this.totalIn = 0;
        this.prevAvailable = false;
        this.matchLen = 2;
        int i = 0;
        while (i < 32768) {
            this.head[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 32768) {
            this.prev[i] = 0;
            ++i;
        }
    }

    public final void resetAdler() {
        this.adler.reset();
    }

    public final int getAdler() {
        int chksum = (int)this.adler.getValue();
        return chksum;
    }

    public final int getTotalIn() {
        return this.totalIn;
    }

    public final void setStrategy(int strat) {
        this.strategy = strat;
    }

    public void setLevel(int lvl) {
        this.goodLength = DeflaterConstants.GOOD_LENGTH[lvl];
        this.max_lazy = DeflaterConstants.MAX_LAZY[lvl];
        this.niceLength = DeflaterConstants.NICE_LENGTH[lvl];
        this.max_chain = DeflaterConstants.MAX_CHAIN[lvl];
        if (DeflaterConstants.COMPR_FUNC[lvl] != this.comprFunc) {
            switch (this.comprFunc) {
                case 0: {
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushStoredBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.updateHash();
                    break;
                }
                case 1: {
                    if (this.strstart <= this.blockStart) break;
                    this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                    this.blockStart = this.strstart;
                    break;
                }
                case 2: {
                    if (this.prevAvailable) {
                        this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                    }
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.prevAvailable = false;
                    this.matchLen = 2;
                    break;
                }
            }
            this.comprFunc = COMPR_FUNC[lvl];
        }
    }

    private final void updateHash() {
        this.ins_h = this.window[this.strstart] << 5 ^ this.window[this.strstart + 1];
    }

    private final int insertString() {
        short match;
        int hash = (this.ins_h << 5 ^ this.window[this.strstart + 2]) & Short.MAX_VALUE;
        this.prev[this.strstart & Short.MAX_VALUE] = match = this.head[hash];
        this.head[hash] = (short)this.strstart;
        this.ins_h = hash;
        return match & (char)-1;
    }

    private final void slideWindow() {
        int m;
        System.arraycopy(this.window, 32768, this.window, 0, 32768);
        this.matchStart -= 32768;
        this.strstart -= 32768;
        this.blockStart -= 32768;
        int i = 0;
        while (i < 32768) {
            m = this.head[i] & (char)-1;
            short s = 0;
            if (m >= 32768) {
                s = (short)(m - 32768);
            }
            this.head[i] = s;
            ++i;
        }
        i = 0;
        while (i < 32768) {
            m = this.prev[i] & (char)-1;
            short s = 0;
            if (m >= 32768) {
                s = (short)(m - 32768);
            }
            this.prev[i] = s;
            ++i;
        }
    }

    private final void fillWindow() {
        if (this.strstart >= 65274) {
            this.slideWindow();
        }
        while (this.lookahead < 262 && this.inputOff < this.inputEnd) {
            int more = 65536 - this.lookahead - this.strstart;
            if (more > this.inputEnd - this.inputOff) {
                more = this.inputEnd - this.inputOff;
            }
            System.arraycopy(this.inputBuf, this.inputOff, this.window, this.strstart + this.lookahead, more);
            this.adler.update(this.inputBuf, this.inputOff, more);
            this.inputOff += more;
            this.totalIn += more;
            this.lookahead += more;
        }
        if (this.lookahead >= 3) {
            this.updateHash();
        }
    }

    private final boolean findLongestMatch(int curMatch) {
        int chainLength = this.max_chain;
        int niceLength = this.niceLength;
        short[] prev = this.prev;
        int scan = this.strstart;
        int best_end = this.strstart + this.matchLen;
        int best_len = Math.max(this.matchLen, 2);
        int limit = Math.max(this.strstart - 32506, 0);
        int strend = scan + 258 - 1;
        byte scan_end1 = this.window[best_end - 1];
        byte scan_end = this.window[best_end];
        if (best_len >= this.goodLength) {
            chainLength >>= 2;
        }
        if (niceLength > this.lookahead) {
            niceLength = this.lookahead;
        }
        do {
            if (this.window[curMatch + best_len] != scan_end || this.window[curMatch + best_len - 1] != scan_end1 || this.window[curMatch] != this.window[scan] || this.window[curMatch + 1] != this.window[scan + 1]) continue;
            int match = curMatch + 2;
            scan += 2;
            while (this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && scan < strend) {
            }
            if (scan > best_end) {
                this.matchStart = curMatch;
                best_end = scan;
                best_len = scan - this.strstart;
                if (best_len >= niceLength) break;
                scan_end1 = this.window[best_end - 1];
                scan_end = this.window[best_end];
            }
            scan = this.strstart;
        } while ((curMatch = prev[curMatch & Short.MAX_VALUE] & (char)-1) > limit && --chainLength != 0);
        this.matchLen = Math.min(best_len, this.lookahead);
        boolean bl = false;
        if (this.matchLen >= 3) {
            bl = true;
        }
        return bl;
    }

    void setDictionary(byte[] buffer, int offset, int length) {
        this.adler.update(buffer, offset, length);
        if (length < 3) {
            return;
        }
        if (length > 32506) {
            offset += length - 32506;
            length = 32506;
        }
        System.arraycopy(buffer, offset, this.window, this.strstart, length);
        this.updateHash();
        --length;
        while (--length > 0) {
            this.insertString();
            ++this.strstart;
        }
        this.strstart += 2;
        this.blockStart = this.strstart;
    }

    private final boolean deflateStored(boolean flush, boolean finish) {
        if (!flush && this.lookahead == 0) {
            return false;
        }
        this.strstart += this.lookahead;
        this.lookahead = 0;
        int storedLen = this.strstart - this.blockStart;
        if (storedLen >= DeflaterConstants.MAX_BLOCK_SIZE || this.blockStart < 32768 && storedLen >= 32506 || flush) {
            boolean lastBlock = finish;
            if (storedLen > DeflaterConstants.MAX_BLOCK_SIZE) {
                storedLen = DeflaterConstants.MAX_BLOCK_SIZE;
                lastBlock = false;
            }
            this.huffman.flushStoredBlock(this.window, this.blockStart, storedLen, lastBlock);
            this.blockStart += storedLen;
            return lastBlock ^ true;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean deflateFast(boolean flush, boolean finish) {
        if (this.lookahead >= 262 || flush) ** GOTO lbl38
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.lookahead == 0) {
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, finish);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart > 65274) {
                this.slideWindow();
            }
            if (this.lookahead >= 3 && (hashHead = this.insertString()) != 0 && this.strategy != 2 && this.strstart - hashHead <= 32506 && this.findLongestMatch(hashHead)) {
                this.huffman.tallyDist(this.strstart - this.matchStart, this.matchLen);
                this.lookahead -= this.matchLen;
                if (this.matchLen <= this.max_lazy && this.lookahead >= 3) {
                    while (--this.matchLen > 0) {
                        ++this.strstart;
                        this.insertString();
                    }
                    ++this.strstart;
                } else {
                    this.strstart += this.matchLen;
                    if (this.lookahead >= 2) {
                        this.updateHash();
                    }
                }
                this.matchLen = 2;
                continue;
            }
            this.huffman.tallyLit(this.window[this.strstart] & 255);
            ++this.strstart;
            --this.lookahead;
            if (!this.huffman.isFull()) continue;
            v0 = false;
            if (finish && this.lookahead == 0) {
                v0 = true;
            }
            lastBlock = v0;
            this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, lastBlock);
            this.blockStart = this.strstart;
            return lastBlock ^ true;
lbl38:
            // 3 sources

            ** while (this.lookahead >= 262 || flush)
        }
lbl39:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean deflateSlow(boolean flush, boolean finish) {
        if (this.lookahead >= 262 || flush) ** GOTO lbl52
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.lookahead == 0) {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 255);
                }
                this.prevAvailable = false;
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, finish);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart >= 65274) {
                this.slideWindow();
            }
            prevMatch = this.matchStart;
            prevLen = this.matchLen;
            if (this.lookahead >= 3) {
                hashHead = this.insertString();
                if (this.strategy != 2 && hashHead != 0 && this.strstart - hashHead <= 32506 && this.findLongestMatch(hashHead) && this.matchLen <= 5 && (this.strategy == 1 || this.matchLen == 3 && this.strstart - this.matchStart > 4096)) {
                    this.matchLen = 2;
                }
            }
            if (prevLen >= 3 && this.matchLen <= prevLen) {
                this.huffman.tallyDist(this.strstart - 1 - prevMatch, prevLen);
                prevLen -= 2;
                do {
                    ++this.strstart;
                    --this.lookahead;
                    if (this.lookahead < 3) continue;
                    this.insertString();
                } while (--prevLen > 0);
                ++this.strstart;
                --this.lookahead;
                this.prevAvailable = false;
                this.matchLen = 2;
            } else {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 255);
                }
                this.prevAvailable = true;
                ++this.strstart;
                --this.lookahead;
            }
            if (!this.huffman.isFull()) continue;
            len = this.strstart - this.blockStart;
            if (this.prevAvailable) {
                --len;
            }
            v0 = false;
            if (finish && this.lookahead == 0 && !this.prevAvailable) {
                v0 = true;
            }
            lastBlock = v0;
            this.huffman.flushBlock(this.window, this.blockStart, len, lastBlock);
            this.blockStart += len;
            return lastBlock ^ true;
lbl52:
            // 2 sources

            ** while (this.lookahead >= 262 || flush)
        }
lbl53:
        // 1 sources

        return true;
    }

    public boolean deflate(boolean flush, boolean finish) {
        boolean progress;
        do {
            this.fillWindow();
            boolean bl = false;
            if (flush && this.inputOff == this.inputEnd) {
                bl = true;
            }
            boolean canFlush = bl;
            switch (this.comprFunc) {
                case 0: {
                    progress = this.deflateStored(canFlush, finish);
                    break;
                }
                case 1: {
                    progress = this.deflateFast(canFlush, finish);
                    break;
                }
                case 2: {
                    progress = this.deflateSlow(canFlush, finish);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } while (this.pending.isFlushed() && progress);
        return progress;
    }

    public void setInput(byte[] buf, int off, int len) {
        if (this.inputOff < this.inputEnd) {
            throw new IllegalStateException("Old input was not completely processed");
        }
        int end = off + len;
        if (off < 0 || off > end || end > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inputBuf = buf;
        this.inputOff = off;
        this.inputEnd = end;
    }

    public final boolean needsInput() {
        boolean bl = false;
        if (this.inputEnd == this.inputOff) {
            bl = true;
        }
        return bl;
    }

    DeflaterEngine(DeflaterPending pending) {
        this.pending = pending;
        this.huffman = new DeflaterHuffman(pending);
        this.adler = new Adler32();
        this.window = new byte[65536];
        this.head = new short[32768];
        this.prev = new short[32768];
        this.strstart = 1;
        this.blockStart = 1;
    }
}

