/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.util.LineTable;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.util.VariableTable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class VMVirtualMachine {
    public static native void suspendThread(Thread var0);

    public static void suspendAllThreads() {
        ThreadGroup jdwpGroup;
        Thread current = Thread.currentThread();
        ThreadGroup group = jdwpGroup = current.getThreadGroup();
        ThreadGroup parent = group.getParent();
        while (parent != null) {
            group = parent;
            parent = group.getParent();
        }
        int num = group.activeCount();
        Thread[] threads = new Thread[num];
        group.enumerate(threads);
        int i = 0;
        while (i < num) {
            Thread t = threads[i];
            if (t != null && t.getThreadGroup() != jdwpGroup && t != current) {
                VMVirtualMachine.suspendThread(t);
            }
            ++i;
        }
        VMVirtualMachine.suspendThread(current);
    }

    public static native void resumeThread(Thread var0);

    public static void resumeAllThreads() {
        ThreadGroup jdwpGroup;
        Thread current = Thread.currentThread();
        ThreadGroup group = jdwpGroup = current.getThreadGroup();
        ThreadGroup parent = group.getParent();
        while (parent != null) {
            group = parent;
            parent = group.getParent();
        }
        int num = group.activeCount();
        Thread[] threads = new Thread[num];
        group.enumerate(threads);
        int i = 0;
        while (i < num) {
            Thread t = threads[i];
            if (t != null && t.getThreadGroup() != jdwpGroup && t != current) {
                VMVirtualMachine.resumeThread(t);
            }
            ++i;
        }
    }

    public static native int getSuspendCount(Thread var0);

    public static native int getAllLoadedClassesCount();

    public static native Iterator getAllLoadedClasses();

    public static native int getClassStatus(Class var0);

    public static native ArrayList getFrames(Thread var0, int var1, int var2);

    public static native VMFrame getFrame(Thread var0, ByteBuffer var1);

    public static native int getFrameCount(Thread var0);

    public static native int getThreadStatus(Thread var0);

    public static native ArrayList getLoadRequests(ClassLoader var0);

    public static native MethodResult executeMethod(Object var0, Thread var1, Class var2, Method var3, Object[] var4, boolean var5);

    public static native VariableTable getVarTable(Class var0, Method var1);

    public static native LineTable getLineTable(Class var0, Method var1);

    public static native String getSourceFile(Class var0);

    public static native void registerEvent(EventRequest var0);

    public static native void unregisterEvent(EventRequest var0);

    public static native void clearEvents(byte var0);
}

