/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class MetalSeparatorUI
extends BasicSeparatorUI {
    private static MetalSeparatorUI instance = null;

    public static ComponentUI createUI(JComponent component) {
        if (instance == null) {
            instance = new MetalSeparatorUI();
        }
        return instance;
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle r = new Rectangle();
        SwingUtilities.calculateInnerArea(c, r);
        Color saved = g.getColor();
        Color c1 = UIManager.getColor("Separator.foreground");
        Color c2 = UIManager.getColor("Separator.background");
        if (!(c instanceof JSeparator)) {
            return;
        }
        JSeparator s = (JSeparator)c;
        if (s.getOrientation() == 0) {
            int midAB = r.height / 2;
            g.setColor(c1);
            g.drawLine(r.x, r.y + midAB - 1, r.x + r.width, r.y + midAB - 1);
            g.setColor(c2);
            g.fillRect(r.x, r.y + midAB, r.x + r.width, r.y + midAB);
        } else {
            int midAD = r.height / 2 + r.y;
            g.setColor(c1);
            g.drawLine(r.x, r.y, r.x, r.y + r.height);
            g.setColor(c2);
            g.fillRect(r.x + midAD, r.y + r.height, r.x + midAD, r.y + r.height);
        }
        g.setColor(saved);
    }
}

