/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number
implements Comparable {
    private static final long serialVersionUID = 7515723908773894738L;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('S');
    public static final int SIZE = 16;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static Short[] shortCache = new Short[256];
    private final short value;

    public static final String toString(short s) {
        return String.valueOf(s);
    }

    public static final short parseShort(String s) {
        return Short.parseShort(s, 10);
    }

    public static final short parseShort(String s, int radix) {
        int i = Integer.parseInt(s, radix, false);
        if ((short)i != i) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    public static final Short valueOf(String s, int radix) {
        return new Short(Short.parseShort(s, radix));
    }

    public static final Short valueOf(String s) {
        return new Short(Short.parseShort(s, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Short valueOf(short val) {
        if (val < -128 || val > 127) {
            return new Short(val);
        }
        Short[] shortArray = shortCache;
        synchronized (shortCache) {
            if (shortCache[val - -128] == null) {
                Short.shortCache[val - -128] = new Short(val);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return shortCache[val - -128];
        }
    }

    public static final Short decode(String s) {
        int i = Integer.parseInt(s, 10, true);
        if ((short)i != i) {
            throw new NumberFormatException();
        }
        return new Short((short)i);
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object obj) {
        boolean bl = false;
        if (obj instanceof Short && this.value == ((Short)obj).value) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(Short s) {
        return this.value - s.value;
    }

    public final int compareTo(Object o) {
        return this.compareTo((Short)o);
    }

    public static final short reverseBytes(short val) {
        return (short)(val >> 8 & 0xFF | val << 8 & 0xFF00);
    }

    public Short(short value) {
        this.value = value;
    }

    public Short(String s) {
        this.value = Short.parseShort(s, 10);
    }
}

