/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class URLUtils {
    private static Logger log = Logger.getLogger(URLUtils.class);
    private static Pattern URLmatcher = Pattern.compile(".{1,8}://.*");

    public static String getPath(String url) throws MalformedURLException {
        URL fauxURL = URLUtils.getFauxUrl(url);
        return fauxURL.getPath();
    }

    public static String getQuery(String url) throws MalformedURLException {
        URL fauxURL = URLUtils.getFauxUrl(url);
        return fauxURL.getQuery();
    }

    public static String getHost(String url) throws MalformedURLException {
        URL fauxURL = URLUtils.getFauxUrl(url);
        return fauxURL.getHost();
    }

    public static Map<String, String> parseQueryString(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] name_val = param.split("=", 2);
            if (name_val.length != 2) continue;
            map.put(name_val[0], name_val[1]);
        }
        return map;
    }

    public static String addExtension(String url, String extension) {
        try {
            String path = URLUtils.getPath(url);
            return url.replaceFirst(path, path + extension);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            return url + extension;
        }
    }

    public static String replaceExtension(String url, String extension, String newExtension) {
        String path = url;
        try {
            path = URLUtils.getPath(url);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
        }
        int idx = path.lastIndexOf(extension);
        String newPath = path.substring(0, idx) + newExtension + path.substring(idx + extension.length());
        return url.replaceFirst(path, newPath);
    }

    public static String addParameter(String urlString, String parameter) {
        return (urlString.indexOf(63) > 0 ? "&" : "?") + parameter;
    }

    public static boolean isURL(String f) {
        return URLmatcher.matcher(f).matches();
    }

    private static URL getFauxUrl(String url) throws MalformedURLException {
        String protocol;
        Object fauxURL = url;
        int idx = url.indexOf(":");
        if (idx > 0 && !(protocol = url.substring(0, idx)).startsWith("http")) {
            fauxURL = "http" + url.substring(idx);
        }
        return new URL((String)fauxURL);
    }
}

