/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.core.CoreCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;

public final class BetaIntegerCodec
extends CoreCodec<Integer> {
    private final int offset;
    private final int bitsPerValue;
    private final long valueLimit;

    public BetaIntegerCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, int offset, int bitsPerValue) {
        super(coreBlockInputStream, coreBlockOutputStream);
        this.offset = offset;
        this.bitsPerValue = bitsPerValue;
        this.valueLimit = 1L << bitsPerValue;
    }

    @Override
    public final Integer read() {
        return this.coreBlockInputStream.readBits(this.bitsPerValue) - this.offset;
    }

    @Override
    public Integer read(int length) {
        throw new RuntimeException("Not implemented.");
    }

    private int getAndCheckOffsetValue(int value) {
        int newValue = value + this.offset;
        if (newValue < 0) {
            String negative = String.format("Value %s plus offset %s must be positive", value, this.offset);
            throw new IllegalArgumentException(negative);
        }
        if ((long)newValue >= this.valueLimit) {
            String tooBig = String.format("Value %s plus offset %s is greater than or equal to limit %s", value, this.offset, this.valueLimit);
            throw new IllegalArgumentException(tooBig);
        }
        return newValue;
    }

    @Override
    public final void write(Integer value) {
        this.coreBlockOutputStream.write(this.getAndCheckOffsetValue(value), this.bitsPerValue);
    }
}

