/* -----------------------------------------------------------------------------
 * guilemain.i
 *
 * The main functions for a user augmented guile
 * version that can handle wrapped calls as generated by SWIG
 * ----------------------------------------------------------------------------- */

%{
#include <libguile.h>

#ifdef __cplusplus
extern "C" {
#endif

static void
inner_main(void *closure, int argc, char **argv)
{
#ifdef SWIGINIT
  SWIGINIT
#else
  SWIG_init();			/* SWIG init function */
#endif
  scm_shell(argc, argv);	/* scheme interpreter */
  /* never reached: scm_shell will perform an exit */
}

#ifdef __cplusplus
}
#endif

int
main(int argc, char **argv)
{
  /* put any default initialisation code here: e.g. exit handlers */
  scm_boot_guile(argc, argv, inner_main, 0); /* make a stack entry for the
						garbage collector */
  return 0; /* never reached, but avoids a warning */
}
%}
